<?php
/**
 * External product add to cart
 *
 * This template can be overridden by copying it to yourtheme/kkart/single-product/add-to-cart/external.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'kkart_before_add_to_cart_form' ); ?>

<form class="cart" action="<?php echo esc_url( $product_url ); ?>" method="get">
	<?php do_action( 'kkart_before_add_to_cart_button' ); ?>
	
	<button type="submit" class="kkart-cart-btn-holder single_add_to_cart_button">
				
		<?php 
		if( !empty($el['atts']['cart_icon'])){
			echo '<i class="'. $el['atts']['cart_icon'].' kkart-cart-btn-icon"></i>';
		}
		
		echo '<span class="kkart-cart-btn-text">'. esc_html( $button_text ) .'</span>';
		
		if( !empty($el['atts']['cart_icon'])){
			echo '<i class="'. $el['atts']['cart_icon'].' kkart-cart-btn-icon"></i>';
		}
		?>
		
	</button>

	<?php kkart_query_string_form_fields( $product_url ); ?>

	<?php do_action( 'kkart_after_add_to_cart_button' ); ?>
</form>

<?php do_action( 'kkart_after_add_to_cart_form' ); ?>
