import { __ } from '@wordpress/i18n';
import { useRef } from '@wordpress/element';
import { ColorPickerControl } from './color';
import { LabelControl } from './label';

export const GradientControl = (props) => {
	const { prop, value, setAttributes } = props;
	const { name } = prop['c'];

	const globalDivOne = useRef(null)
	const globalDivTwo = useRef(null)
	const globalDivThree = useRef(null)
  
	var val = !pagelayer_empty(value) ? value : ['', '', '', '', '', '', ''];

	if (pagelayer_is_string(val)) {
		val = val.split(',');
	}

	const handleInputChange = (index, newValue) => {
		const newValues = [...val];
		newValues[index] = newValue;
		setAttributes({ [name]: newValues.toString() });
	};

	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props} />
			<div className="pagelayer-elp-gradient-div">
				<div className="pagelayer-elp-gradient-div">
					<div className="pagelayer-elp-prop-grp pagelayer-elp-gradient-angle">
						<label className="pagelayer-elp-label">{ __('Angle') }</label>
						<input
							className="pagelayer-elp-gradient-input pagelayer-elp-gradient-angle"
							type="number"
							max="360"
							min="0"
							step="1"
							onChange={(e) => handleInputChange(0, parseFloat(e.target.value))}
							value={val[0]}
						></input>
					</div>
					<div className="pagelayer-elp-prop-grp pagelayer-elp-gradient-color" ref={globalDivOne}>
						<label className="pagelayer-elp-label">{ __('Color') } 1</label>
						<ColorPickerControl
							onChange={(color) => handleInputChange(1, color)}
							value={val[1]}
							type={prop.type}
							setAttributes={setAttributes}
							handleClick={(color) => handleInputChange(1, '$'+color)}
							showRemoveIcon={ false }
						/>
					</div>
					<div className="pagelayer-elp-prop-grp pagelayer-elp-gradient-per1" >
						<label className="pagelayer-elp-label">{ __('Percentage') } 1</label>
						<input
							className="pagelayer-elp-gradient-input"
							type="number"
							max="100"
							min="-100"
							step="1"
							onChange={(e) => handleInputChange(2, parseFloat(e.target.value))}
							value={val[2]}
						></input>
					</div>
					<div className="pagelayer-elp-prop-grp pagelayer-elp-gradient-color" ref={globalDivTwo}>
						<label className="pagelayer-elp-label">{ __('Color') } 2</label>
						<ColorPickerControl
							onChange={(color) => handleInputChange(3, color)}
							value={val[3]}
							type={prop.type}
							setAttributes={setAttributes}
							handleClick={(color) => handleInputChange(3, '$'+color)}
							showRemoveIcon={ false }
						/>
					</div>
					<div className="pagelayer-elp-prop-grp pagelayer-elp-gradient-per2">
						<label className="pagelayer-elp-label">{ __('Percentage') } 2</label>
						<input
							className="pagelayer-elp-gradient-input pagelayer-elp-gradient-per2"
							type="number"
							max="100"
							min="0"
							step="1"
							onChange={(e) => handleInputChange(4, parseFloat(e.target.value))}
							value={val[4]}
						></input>
					</div>
					<div className="pagelayer-elp-prop-grp pagelayer-elp-gradient-color" ref={globalDivThree}>
						<label className="pagelayer-elp-label">{ __('Color') } 3</label>
						<ColorPickerControl
							onChange={(color) => handleInputChange(5, color)}
							value={val[5]}
							type={prop.type}
							setAttributes={setAttributes}
							handleClick={(color) => handleInputChange(5, '$'+color)}
							showRemoveIcon={ false }
						/>
					</div>
					<div className="pagelayer-elp-prop-grp pagelayer-elp-gradient-per3">
						<label className="pagelayer-elp-label">{ __('Percentage') } 3</label>
						<input
							className="pagelayer-elp-gradient-input pagelayer-elp-gradient-per3"
							type="number"
							max="100"
							min="0"
							step="1"
							onChange={(e) => handleInputChange(6, parseFloat(e.target.value))}
							value={val[6]}
						></input>
					</div>
				</div>
			</div>
		</div>
	)
}
