<?php
/**
 * SitePad back compat functionality
 *
 * Prevents SitePad from running on WordPress versions prior to 4.4,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.4.
 *
 * @package WordPress
 * @subpackage SitePad
 * @since SitePad 1.0
 */

/**
 * Prevent switching to SitePad on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since SitePad 1.0
 */
function sitepad_switch_theme() {
	switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );

	unset( $_GET['activated'] );

	add_action( 'admin_notices', 'sitepad_upgrade_notice' );
}
add_action( 'after_switch_theme', 'sitepad_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * SitePad on WordPress versions prior to 4.4.
 *
 * @since SitePad 1.0
 *
 * @global string $wp_version WordPress version.
 */
function sitepad_upgrade_notice() {
	$message = sprintf( __( 'SitePad requires at least WordPress version 4.4. You are running version %s. Please upgrade and try again.', 'sitepad' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.4.
 *
 * @since SitePad 1.0
 *
 * @global string $wp_version WordPress version.
 */
function sitepad_customize() {
	wp_die(
		sprintf( __( 'SitePad requires at least WordPress version 4.4. You are running version %s. Please upgrade and try again.', 'sitepad' ), $GLOBALS['wp_version'] ),
		'',
		array(
			'back_link' => true,
		)
	);
}
add_action( 'load-customize.php', 'sitepad_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.4.
 *
 * @since SitePad 1.0
 *
 * @global string $wp_version WordPress version.
 */
function sitepad_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( __( 'SitePad requires at least WordPress version 4.4. You are running version %s. Please upgrade and try again.', 'sitepad' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'sitepad_preview' );
