<?php
/**
 * Core Administration API
 *
 * @package WordPress
 * @subpackage Administration
 * @since 2.3.0
 */

if ( ! defined( 'WP_ADMIN' ) ) {
	/*
	 * This file is being included from a file other than site-admin/admin.php, so
	 * some setup was skipped. Make sure the admin message catalog is loaded since
	 * load_default_textdomain() will not have done so in this context.
	 */
	load_textdomain( 'default', WP_LANG_DIR . '/admin-' . get_locale() . '.mo' );
}

/** WordPress Administration Hooks */
require_once( ABSPATH . 'site-admin/includes/admin-filters.php' );

/** WordPress Bookmark Administration API */
require_once( ABSPATH . 'site-admin/includes/bookmark.php' );

/** WordPress Comment Administration API */
require_once( ABSPATH . 'site-admin/includes/comment.php' );

/** WordPress Administration File API */
require_once( ABSPATH . 'site-admin/includes/file.php' );

/** WordPress Image Administration API */
require_once( ABSPATH . 'site-admin/includes/image.php' );

/** WordPress Media Administration API */
require_once( ABSPATH . 'site-admin/includes/media.php' );

/** WordPress Import Administration API */
require_once( ABSPATH . 'site-admin/includes/import.php' );

/** WordPress Misc Administration API */
require_once( ABSPATH . 'site-admin/includes/misc.php' );

/** WordPress Options Administration API */
require_once( ABSPATH . 'site-admin/includes/options.php' );

/** WordPress Plugin Administration API */
require_once( ABSPATH . 'site-admin/includes/plugin.php' );

/** WordPress Post Administration API */
require_once( ABSPATH . 'site-admin/includes/post.php' );

/** WordPress Administration Screen API */
require_once( ABSPATH . 'site-admin/includes/class-wp-screen.php' );
require_once( ABSPATH . 'site-admin/includes/screen.php' );

/** WordPress Taxonomy Administration API */
require_once( ABSPATH . 'site-admin/includes/taxonomy.php' );

/** WordPress Template Administration API */
require_once( ABSPATH . 'site-admin/includes/template.php' );

/** WordPress List Table Administration API and base class */
require_once( ABSPATH . 'site-admin/includes/class-wp-list-table.php' );
require_once( ABSPATH . 'site-admin/includes/class-wp-list-table-compat.php' );
require_once( ABSPATH . 'site-admin/includes/list-table.php' );

/** WordPress Theme Administration API */
require_once( ABSPATH . 'site-admin/includes/theme.php' );

/** WordPress User Administration API */
require_once( ABSPATH . 'site-admin/includes/user.php' );

/** WordPress Site Icon API */
require_once( ABSPATH . 'site-admin/includes/class-wp-site-icon.php' );

/** WordPress Update Administration API */
require_once( ABSPATH . 'site-admin/includes/update.php' );
