<?php
/**
 * Dashboard Administration Screen
 *
 * @package WordPress
 * @subpackage Administration
 */

/** Load WordPress Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

include( ABSPATH . 'site-admin/admin-header.php' );

//$all_sites_tmp = wp_get_sites();
//r_print($all_sites_tmp);

$orig_blog_id = get_current_blog_id();
$total_stats['post_count'] = 0;
$total_stats['page_count'] = 0;
$total_stats['space_used'] = 0;

//foreach($all_sites_tmp as $k => $v){
	
	//switch_to_blog( $orig_blog_id );
	
	// Post count
	$v['post_stats'] = wp_count_posts();
	$v['post_count'] = $v['post_stats']->publish + $v['post_stats']->draft;
	
	// Page count
	$v['page_stats'] = wp_count_posts('page');
	$v['page_count'] = $v['page_stats']->publish + $v['page_stats']->draft;	
	
	$v['space_allowed'] = get_option( 'sitepad_allowed_space' );
	$v['space_used'] = get_option( 'sitepad_used_space' );
	
	// Total Stats
	$total_stats['post_count'] += $v['post_count'];
	$total_stats['page_count'] += $v['page_count'];
	$total_stats['space_used'] = $v['space_used'];		//Show Total space used..
	$total_stats['space_allowed'] = $v['space_allowed'];	//Show Total space allowed..
	
	$all_sites[$orig_blog_id] = $v;
	
//}

//r_print($all_sites);

//switch_to_blog( $orig_blog_id );


if(get_site_option('upload_space_check_disabled') || empty($total_stats['space_allowed'])){
	$show_allowed = 'Unlimited';
	$total_stats['space_allowed'] = 1;
}else{
	
	if( $total_stats['space_used'] > 1000){
		$show_allowed = ceil(round(number_format($total_stats['space_used'] / KB_IN_BYTES ), 2));
		/* translators: Gigabytes */
		$show_allowed .= __( 'GB' );
	}else{
		$show_allowed = ceil(round(number_format($total_stats['space_used'] ), 2));
		/* translators: Megabytes */
		$show_allowed .= __( 'MB' );
	}
	
	$show_allowed .= '/';
	
	if( $total_stats['space_allowed'] > 1000){
		$show_allowed .= number_format( $total_stats['space_allowed'] / KB_IN_BYTES );
		/* translators: Gigabytes */
		$show_allowed .= __( 'GB' );
	}else{
		$show_allowed .= number_format( $total_stats['space_allowed'] );
		/* translators: Megabytes */
		$show_allowed .= __( 'MB' );
	}
	
}


?>

<link rel="stylesheet" type="text/css" href="<?php echo sitepad_assets_url().'/css/owl.carousel.min.css';?>">
<link rel="stylesheet" type="text/css" href="<?php echo sitepad_assets_url().'/css/owl.theme.default.min.css';?>">
<script src="<?php echo sitepad_assets_url().'/js/owl.carousel.min.js';?>" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo sitepad_assets_url().'/js/jquery.easypiechart.min.js';?>" type="text/javascript" charset="utf-8"></script>

<div class="wrap" id="contents_response">

<table border="0" cellpadding="5" cellspacing="5" width="100%" class="stats_table">
<tr>
	<td width="25%">
	<div class="hoverall">
		<div class="smbox">
			<?php
			$sites_url = isset($sitepad['goto_sites']) ? $sitepad['goto_sites'] : (isset($sitepad['goto_cp']) ? $sitepad['goto_cp'] : '');
			echo '<a href="'.$sites_url.'">
				<div class="resource_gr statistic_grp" style="background-color: #40B19B;border: 1px solid #40B19B;">
					<div class="resource_header"><b>'.__('Sites').'</b></div>
					<div class="resource_content">
						<div class="resource_container">
						<table border="0" cellpadding="3" cellspacing="3" width="100%" class="stats_table">
						<tr>
						<td width="25%">
							<i class="sm-dashicons dashboard-icons dashicons dashicons-admin-site dashicon_dashboard"></i>
						</td>
						<td width="75%">
							<div style="text-align:left;"><p><br /><font size="3"><b>'.count($all_sites).'</b></font> '.__('Active Sites').'</p></div>
						</td>
						</tr>
						</table>
						</div>
					</div>
				</div>
			</a>';
			?>
		</div>
	</div>
	</td>	
	<td width="25%">
	<div class="hoverall">
		<div class="smbox">
			<?php
			echo '<a href="'.admin_url('edit.php?post_type=page').'">
				<div class="resource_gr statistic_grp" style="background-color: #EA695C;border: 1px solid #EA695C;">
					<div class="resource_header"><b>'.__('Pages').'</b></div>
					<div class="resource_content">
						<div class="resource_container">
						<table border="0" cellpadding="3" cellspacing="3" width="100%" class="stats_table">
						<tr>
						<td width="20%">
							<i class="sm-dashicons dashboard-icons dashicons dashicons-admin-page dashicon_dashboard"></i>
						</td>
						<td width="80%">
							<div style="text-align:left;"><p>'.__('Current Site').' : <font size="3"><b>'.$all_sites[$orig_blog_id]['page_count'].'</b></font>
							<br />'.__('Total').' : <font size="3"><b>'.$total_stats['page_count'].'</b></font></p></div>
						</td>
						</tr>
						</table>
						</div>
					</div>
				</div>
			</a>';
			?>
		</div>
	</div>
	</td>
	<td width="25%">
	<div class="hoverall">
		<div class="smbox">
	
			<?php 
			echo '<a href="'.admin_url('edit.php').'">
				<div class="resource_gr statistic_grp" style="background-color: #A163BA;border: 1px solid #A163BA;">
					<div class="resource_header"><b>'.__('Posts').'</b></div>
					<div class="resource_content">
						<div class="resource_container">
						<table border="0" cellpadding="3" cellspacing="3" width="100%" class="stats_table">
						<tr>
						<td width="20%">
							<i class="sm-dashicons dashboard-icons dashicons dashicons-admin-post dashicon_dashboard"></i>
						</td>
						<td width="80%">
							<div style="text-align:left;"><p>'.__('Current Site').' : <font size="3"><b>'.$all_sites[$orig_blog_id]['post_count'].'</b></font>
							<br />'.__('Total').' : <font size="3"><b>'.$total_stats['post_count'].'</b></font></p></div>
						</td>
						</tr>
						</table>
						</div>
					</div>
				</div>
			</a>';
			?>
		</div>
	</div>
	</td>
	<td width="25%">
	<div class="hoverall">
		<div class="smbox">
			<?php
			
				echo '<a href="'.admin_url('upload.php').'">
				<div class="resource_gr statistic_grp" style="background-color: #4D95C4;border: 1px solid #4D95C4;">
					<div class="resource_header"><b>'.__('Media Usage').'</b></div>
					<div class="resource_content">
						<div class="resource_container">
						<table border="0" cellpadding="3" cellspacing="3" width="100%" class="stats_table">
						<tr>
						<td width="25%">
							<div class="chart" data-percent="'.ceil(round($total_stats['space_used'], 2)/$total_stats['space_allowed']*100).'"></div>
						</td>
						<td width="75%">
							<div><p><font size="3"><b>'.$show_allowed.'</b></font></p></div>
						</td>
						</tr>
						</table>
						</div>
					</div>
				</div>
			</a>';
			?>
		</div>
	</div>
	</td>
</tr>
</table>
<?php 
if(empty($SESS['no_recent_themes'])){
	
	if ( current_user_can( 'switch_themes' ) ) {
		$themes = wp_prepare_themes_for_js();
	} else {
		$themes = wp_prepare_themes_for_js( array( wp_get_theme() ) );
	}
	
	echo '<br /><center><h5>'.__('Recently Added Themes').'</h5></center>
	<div class="owl-carousel owl-theme">';

$i = 0;
foreach ($themes as $slug => $t){
	
	$i++;
	
	if($i > 16) break;
	
	if(file_exists($sitepad['data_path'].'/themes/'.$t['id'])){
		$img_path = get_theme_root_uri($t['id']).'/'.$t['id'].'/'.$t['id'].'_275.jpg';
	}else{		
		$img_path = sitepad_themes_api_url($t['id']).'/'.$t['id'].'_275.jpg';
	}
	
	echo '<div style="border:1px solid #ccc;padding:2px;" id="'.$t['id'].'" onclick="sm_details(this.id)" >
			<div class="smush_theme_header">'.$t['name'].'</div>
			<img src="'.$img_path.'" />
		</div>';
	
}
	
echo '</div>';

} ?>
<div class="theme-overlay"></div>
<p class="no-themes"><?php _e( 'No themes found. Try a different search.' ); ?></p>

</div><!-- .wrap -->

<script type="text/javascript">
<?php if(empty($SESS['no_recent_themes'])){

foreach($themes as $k => $v){
	$_themes[$k] = $v;
	if(count($_themes) > 20){
		break;
	}
}

?>
var data_details = <?php echo json_encode($_themes, JSON_PRETTY_PRINT); ?>;
var sm_category = <?php echo json_encode($sp_category, JSON_PRETTY_PRINT); ?>;

function sm_details(el) {

	for(x in data_details){
		if(x >= 16){
			break;
		}
		var data = new Object();
		var cur = parseInt(x);
		if(el == data_details[x].id){
			data.screenshot = data_details[x].screenshot[0];
			data.category = sm_category[data_details[x].category].en;
			data.active = data_details[x].active;
			data.actions = data_details[x].actions;
			data.actions.activate = data_details[x].actions.activate;
			data.name = data_details[x].name;
			data.description = data_details[x].description;
			data.version = data_details[x].version;
			data.tags = data_details[x].tags;
			data.parent = data_details[x].parent;
			data.actions['delete'] = data_details[x].actions.delete;
			data.authorAndUri = data_details[x].authorAndUri;
			data.demo = data.name.replace(' ', '_');
			if(data_details[cur-1]){
				data.previous = data_details[cur-1].id;
			}
			if(data_details[cur+1]){
				data.next = data_details[cur+1].id;
			}
			var smtemplate = wp.template('themes-details-wrap');
			sm_tmpl(data);
			function sm_tmpl( data ){
				$themes = jQuery(".theme-overlay").css('display','block');;
				$themes.html(smtemplate(data));
			}
		}
	}
}
function close_smdetails(){
	jQuery(".theme-overlay").css('display','none');
}

jQuery(document).ready(function($){
	$('.owl-carousel').owlCarousel({
		loop:true,
		items: 4,
		margin:10,
		nav: false,
		dots: true,
		autoplay:true,
		autoplayTimeout:2000,
		autoplayHoverPause:true
	});
});

<?php } ?>
function bar_color(v) {
	if(v <= 50) {
		return "#00C853";
	} else if(v <= 80) {
		return "#FF9100";
	} else {
		return "#D50000";
	}
}

jQuery(".chart").easyPieChart({
	barColor: bar_color,
	trackColor:  "rgba(255,255,255,0.3)",
	scaleColor: "#FFFFFF",
	animate: { duration: 1000, enabled: true },
	lineWidth:7,
	size: 85,
	lineCap: "cap",
});

</script>

<?php if(empty($SESS['no_recent_themes'])){ ?>
<script type="text/template" id="tmpl-themes-details-wrap">
<div class="theme-backdrop"></div>
<div class="theme-wrap" >
		<div class="theme-header">
			<button class="left dashicons dashicons-no" onclick="sm_details('{{{ data.previous }}}');"><span class="screen-reader-text"><?php _e( 'Show previous theme' ); ?></span></button>
			<button class="right dashicons dashicons-no" onclick="sm_details('{{{ data.next }}}');"><span class="screen-reader-text"><?php _e( 'Show next theme' ); ?></span></button>
			<button class="close dashicons dashicons-no" onclick="close_smdetails();"><span class="screen-reader-text"><?php _e( 'Close details dialog' ); ?></span></button>
		</div>
		<div class="theme-about">
			<div class="theme-screenshots">
			<# if ( data.screenshot ) { #>
				<div class="screenshot"><img src="{{ data.screenshot }}" alt="" id="data_screenshot"/></div>
			<# } else { #>
				<div class="screenshot blank"></div>
			<# } #>
			</div>

			<div class="theme-info">
				<h2 class="theme-name">{{{ data.name }}}<span class="theme-version"><?php printf( __( 'Version: %s' ), '{{ data.version }}' ); ?></span>
				<# if ( ! data.active && data.actions.activate ) { #>
					<a href="{{{ data.actions.activate }}}" class="button button-secondary activate"><?php _e( 'Activate' ); ?></a>
				<# } #>
				<?php if(empty($SESS['no_demos'])){ ?>
				<# if ( data.demo ) { #>
					<a href="<?php echo BRAND_SM_DEMOS; ?>{{{ data.demo }}}/" target="_blank" style="text-decoration:none; color:#FFF;"><span class="button button-primary" style="vertical-align:middle;"><?php _e( 'Demo' ); ?></span></a>
				<# } #>
				<?php } ?>
				</h2>
				<# if ( data.active ) { #>
					<span class="current-label"><?php _e( 'Current Theme' ); ?></span>
				<# } #>
				
				<p class="theme-description">{{{ data.description }}}</p>

				<# if ( data.parent ) { #>
					<p class="parent-theme"><?php printf( __( 'This is a child theme of %s.' ), '<strong>{{{ data.parent }}}</strong>' ); ?></p>
				<# } #>
				
				<# if ( data.category ) { #>
					<p class="theme-category"><span><?php _e( 'Category:' ); ?></span> {{{ data.category }}}</p>
				<# } #>
				<# if ( data.tags ) { #>
					<p class="theme-tags"><span><?php _e( 'Tags:' ); ?></span> {{{ data.tags }}}</p>
				<# } #>
				
			</div>
		</div>

		<div class="theme-actions">
			<div class="active-theme">
				<a href="{{{ data.actions.customize }}}" class="button button-primary customize load-customize hide-if-no-customize"><?php _e( 'Customize' ); ?></a>
				<?php echo implode( ' ', $current_theme_actions ); ?>
			</div>
			<div class="inactive-theme">
				
				<a href="{{{ data.actions.customize }}}" class="button button-primary load-customize hide-if-no-customize"><?php _e( 'Live Preview' ); ?></a>
			</div>

			<# if ( ! data.active && data.actions['delete'] ) { #>
				<a href="{{{ data.actions['delete'] }}}" class="button button-secondary delete-theme"><?php _e( 'Delete' ); ?></a>
			<# } #>
		</div>
</div>
</div>
</script>
<?php } ?>

</div><!-- wrap -->

<?php
require( ABSPATH . 'site-admin/admin-footer.php' );
