<?php
/**
 * Deprecated this page, use gosmtp instead
 * Tools Administration Screen.
 *
 * @package SitePad
 * @subpackage Administration
 */

/** SitePad Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

/** SitePad Translation Installation API */
require_once( ABSPATH . 'site-admin/includes/translation-install.php' );

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'Sorry, you are not allowed to manage options for this site.' ) );
}

$title       = __( 'SMTP Mail Setting' );

include( ABSPATH . 'site-admin/admin-header.php' );

// Send test mail
if(isset($_REQUEST['send_mail'])){
	
	// Check nonce
	check_admin_referer( 'sitepad-options' );
	
	$to = $_REQUEST['reciever_test_email'];
	$subject = $_REQUEST['smtp_test_subject'];
	$body = $_REQUEST['smtp_test_message'];
	
	if(isset($_GET['debug'])){
		// show wp_mail() errors
		add_action( 'wp_mail_failed', 'onMailError', 10, 1 );
		function onMailError( $wp_error ) {
			echo "<pre>";
			print_r($wp_error);
			echo "</pre>";
		}	
	}
	
	if(!get_option('sitepad_smtp_options')){
		$send_mail['error'] = 1;
		$send_mail['error_msg'] = _('You have not configured SMTP settings yet !');
	}else{
	
		$result = wp_mail($to, $subject, $body);
		
		if(!empty($result)){
			$send_mail['success'] = 1;
		}else{
			$send_mail['error'] = 1;
		}
	}
}

// Save SMTP details
if(isset($_REQUEST['save'])){
	
	// Check nonce
	check_admin_referer( 'sitepad-options' );
	
	$smtp_host = '';
	if(isset($_POST['smtp_host']) && !empty($_POST['smtp_host'])){
		$smtp_host = sanitize_text_field($_POST['smtp_host']);
	}
	
	$smtp_auth = '';
	if(isset($_POST['smtp_auth']) && (!empty($_POST['smtp_auth']) || $_POST['smtp_auth'] === '0')){
		$smtp_auth = sanitize_text_field($_POST['smtp_auth']);
	}
	
	$smtp_username = '';
	if(isset($_POST['smtp_username']) && !empty($_POST['smtp_username'])){
		$smtp_username = sanitize_text_field($_POST['smtp_username']);
	}
	
	$smtp_password = '';
	if(isset($_POST['smtp_password']) && !empty($_POST['smtp_password'])){
		//echo "password: ".$_POST['smtp_password'];               
		$smtp_password = sanitize_text_field($_POST['smtp_password']);
		$smtp_password = wp_unslash($smtp_password); // This removes slash (automatically added by WordPress) from the password when apostrophe is present
		$smtp_password = base64_encode($smtp_password);
	}
	
	$encryption = '';
	if(isset($_POST['encryption']) && !empty($_POST['encryption'])){
		$encryption = sanitize_text_field($_POST['encryption']);
	}
	
	$smtp_port = '';
	if(isset($_POST['smtp_port']) && !empty($_POST['smtp_port'])){
		$smtp_port = sanitize_text_field($_POST['smtp_port']);
	}
	
/* 	$smtp_from_mail = '';
	if(isset($_POST['smtp_from_mail']) && !empty($_POST['smtp_from_mail'])){
		$smtp_from_mail = sanitize_email($_POST['smtp_from_mail']);
	}
	
	$from_name = '';
	if(isset($_POST['from_name']) && !empty($_POST['from_name'])){
		$from_name = sanitize_text_field(stripslashes($_POST['from_name']));
	} */
	
	$disable_ssl_verification = '';
	if(isset($_POST['disable_ssl_verification']) && !empty($_POST['disable_ssl_verification'])){
		$disable_ssl_verification = sanitize_text_field($_POST['disable_ssl_verification']);
	}
	
	$enable_smtp = '';
	if(isset($_POST['enable_smtp']) && !empty($_POST['enable_smtp'])){
		$enable_smtp = sanitize_text_field($_POST['enable_smtp']);
	}
	
	$options = array();
	$options['enable_smtp'] = $enable_smtp;
	$options['smtp_host'] = $smtp_host;
	$options['smtp_auth'] = $smtp_auth;
	$options['smtp_username'] = $smtp_username;
	$options['smtp_password'] = $smtp_password;
	$options['encryption'] = $encryption;
	$options['smtp_port'] = $smtp_port;
	//$options['smtp_from_mail'] = $smtp_from_mail;
	//$options['from_name'] = $from_name;
	$options['disable_ssl_verification'] = $disable_ssl_verification;
	
	if(update_option( 'sitepad_smtp_options', $options )){
		$msg['success'] = 1;
	}
}

$smtp_options = get_option('sitepad_smtp_options', array());

$smtp_options['enable_smtp'] = isset($smtp_options['enable_smtp'])? $smtp_options['enable_smtp'] : '';
$smtp_options['smtp_from_mail'] = isset($smtp_options['smtp_from_mail'])? $smtp_options['smtp_from_mail'] : '';
$smtp_options['from_name'] = isset($smtp_options['from_name'])? $smtp_options['from_name'] : '';
$smtp_options['smtp_host'] = isset($smtp_options['smtp_host'])? $smtp_options['smtp_host'] : '';
$smtp_options['encryption'] = isset($smtp_options['encryption'])? $smtp_options['encryption'] : '';
$smtp_options['smtp_auth'] = isset($smtp_options['smtp_auth'])? $smtp_options['smtp_auth'] : '';
$smtp_options['disable_ssl_verification'] = isset($smtp_options['disable_ssl_verification'])? $smtp_options['disable_ssl_verification'] : '';
?>
<script>
	jQuery(document).ready(function(){
		
		// Tabs Handler
		var tabs = jQuery('.sitepad-wrapper').find('.nav-tab');
		var tabsPanel = jQuery('.tabs-wrapper').find('.sitepad-tab-panel');
		tabs.on('click', function(){
			var jEle = jQuery(this);
			var id = jEle.attr('nav-tab');
			
			tabs.removeClass('nav-tab-active');
			tabsPanel.hide();
			jEle.addClass('nav-tab-active');
			jQuery('.tabs-wrapper').find(id).show();
			
		});
		
		// Auth show and hide Handler
		var smtpAuth = jQuery('input[name="smtp_auth"]');
		
		smtpAuth.on('click', function(){
			var val = jQuery(this).attr('value');
			
			if(val == 1){
				jQuery('.smtp-auth').show();
			}else{
				jQuery('.smtp-auth').hide();
			}
		});
		
		// For On load set
		jQuery('input[name="smtp_auth"][checked="checked"]').click();
		
	});
</script>
<div class="wrap">
<h1><?php echo esc_html( $title ); ?></h1>

<?php
if(!empty($msg['success'])){
	echo '<div id="message" class="updated notice is-dismissible"><p>'.__('SMTP settings have been saved successfully!').'</p></div>';
}

if(!empty($send_mail['success'])){
	echo '<div id="message" class="updated notice is-dismissible"><p>'.__('Mail sent successfully!').'</p></div>';
}else if(!empty($send_mail['error'])){
	echo '<div id="message" class="error notice is-dismissible"><p>'.( !empty($send_mail['error_msg']) ? $send_mail['error_msg'] : __('Unable to send mail, Please check your SMTP details') ).'</p></div>';
}
?>
	<div class="tabs-wrapper">
		<h2 class="nav-tab-wrapper sitepad-wrapper">
			<a nav-tab="#smtpsetting" class="nav-tab nav-tab-active"><?php _e('SMTP Settings'); ?></a>
			<a nav-tab="#smtp-test" class="nav-tab "><?php _e('Test Mail'); ?></a>
		</h2>
		<div class="sitepad-tab-panel" id="smtpsetting">
			<form class="sitepad-smtp-mail" name="smtp-details" method="post" action="">
				<?php wp_nonce_field('sitepad-options'); ?>
				<table class="form-table">
					<tr>
						<th scope="row"><?php _e('Enable SMTP'); ?></th>
						<td>
							<input name="enable_smtp" type="checkbox" <?php checked('on', $smtp_options['enable_smtp'])?>>
						</td>
					</tr>
					<!--<tr>
						<th scope="row">From Email Address</th>
						<td>
							<input name="smtp_from_mail" type="email" class="regular-text" placeholder="abc@sitepad.com" <?php if(!empty($smtp_options['smtp_from_mail'])){
								echo 'value="'.$smtp_options['smtp_from_mail'].'"';
							}?>>
							<p class="description" id="tagline-description"><?php _e( 'The email address which emails are sent from.' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row">From Name</th>
						<td>
							<input name="from_name" type="text" class="regular-text" placeholder="Sitepad" <?php if(!empty($smtp_options['from_name'])){
								echo 'value="'.$smtp_options['from_name'].'"';
							}?>>
							<p class="description" id="tagline-description"><?php _e( 'The name which emails are sent from.'); ?></p>	
						</td>
					</tr>-->
					<tr>
						<th scope="row"><?php _e('SMTP Host'); ?></th>
						<td>
							<input name="smtp_host" type="text" class="regular-text" placeholder="smtp.example.com" <?php if(!empty($smtp_options['smtp_host'])){
								echo 'value="'.$smtp_options['smtp_host'].'"';
							}?>>
							<p class="description" id="tagline-description"><?php _e( 'Your mail server' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php _e('Type of Encryption'); ?></th>
						<td>
							<input name="encryption" type="radio" value="none" <?php checked("none", $smtp_options['encryption']); ?>> <?php _e('None'); ?>
							<input name="encryption" type="radio" value="ssl" <?php checked("ssl", $smtp_options['encryption']); ?>><?php _e('SSL'); ?>
							<input name="encryption" type="radio" value="tls" <?php checked("tls", $smtp_options['encryption']); ?>><?php _e('TLS'); ?>
							<p class="description" id="tagline-description"><?php _e( 'For most servers TLS is the recommended option. If your SMTP provider offers both SSL and TLS options, we recommend using TLS.'); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php _e('SMTP Port'); ?></th>
						<td>
							<input name="smtp_port" type="text" class="regular-text" placeholder="465" <?php if(!empty($smtp_options['smtp_port'])){
								echo 'value="'.$smtp_options['smtp_port'].'"';
							}?>>
							<p class="description" id="tagline-description">
							<?php _e( 'The port to your mail server'); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php _e('SMTP Authentication'); ?></th>
						<td>
							<input name="smtp_auth" type="radio" value="0" <?php checked('0', $smtp_options['smtp_auth']); ?>><?php _e('No'); ?>
							<input name="smtp_auth" type="radio" value="1" <?php checked('1', $smtp_options['smtp_auth']); ?>><?php _e('Yes'); ?>
							<p class="description" id="tagline-description"><?php _e( 'This options should always be checked Yes'); ?></p>
						</td>
					</tr>
					<tr class="smtp-auth">
						<th scope="row"><?php _e('SMTP Username'); ?></th>
						<td>
							<input name="smtp_username" type="text" class="regular-text" placeholder="Sitepad" <?php if(!empty($smtp_options['smtp_username'])){
								echo 'value="'.$smtp_options['smtp_username'].'"';
							}?>>
							<p class="description" id="tagline-description"><?php _e( 'The username to login to your mail server' ); ?></p>
						</td>
					</tr>
					<tr class="smtp-auth">
						<th scope="row"><?php _e('SMTP Password'); ?></th>
						<td>
							<input name="smtp_password" type="password" class="regular-text">
							<p class="description" id="tagline-description"><?php _e( 'The SMTP Password to login to your mail server. The saved password is not shown for security reasons. You need enter it every time you update the settings.' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php _e('Disable SSL Certificate Verification'); ?></th>
						<td>
							<input name="disable_ssl_verification" type="checkbox" <?php checked('on', $smtp_options['disable_ssl_verification']); ?>>
							<p class="description" id="tagline-description"><?php _e( 'As of PHP 5.6 you will get a warning/error if the SSL certificate on the server is not properly configured. You can check this option to disable that default behaviour. Please note that PHP 5.6 made this change for a good reason. So you should get your host to fix the SSL configurations instead of bypassing it' ); ?></p>
						</td>
					</tr>
				</table>
				
				<p>
					<input type="submit" name="save" class="button button-primary" value="Save Changes">
				</p>
			</form>	
		</div>
		<div class="sitepad-tab-panel" id="smtp-test" style="display:none">
			<form class="sitepad-smtp-mail" name="test-mail" method="post" action="">
				<?php wp_nonce_field('sitepad-options'); ?>
				<table class="form-table">
					<tr>
						<th scope="row"><?php _e('To'); ?>:</th>
						<td>
							<input type="email" name="reciever_test_email" class="regular-text" placeholder="abc@sitepad.com" required />
							<p class="description" id="tagline-description"><?php _e( 'Enter the recipient\'s email address.' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php _e('Subject'); ?>:</th>
						<td>
							<input type="text" name="smtp_test_subject" class="regular-text" placeholder="Enter Subject" required />
							<p class="description" id="tagline-description"><?php _e( 'Enter a subject for your message.' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php _e('Message'); ?></th>
						<td>
							<textarea name="smtp_test_message" placeholder="Enter Message" class="regular-text" rows="10" required ></textarea>
							<p class="description" id="tagline-description"><?php _e( 'Write your email message' ); ?> </p>
						</td>
					</tr>
				</table>
				<p>
					<input type="submit" name="send_mail" class="button button-primary" value="Send Mail">
				</p>
			</form>
		</div>
	</div>
</div>
<?php

require_once( ABSPATH . 'site-admin/admin-footer.php' ); ?>