<?php
/**
 * Single docs template
 *
 * This template can be overridden by copying it to yourtheme/documentor/single.php.
 *
 * @author  softaculous
 * @package documentor/Templates
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

documentor()->get_template_part( 'global/wrap-start' );

while ( have_posts() ) :
    the_post(); ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class( 'documentor-single' . ( documentor()->get_option( 'ajax', 'documentor_single', true ) ? ' documentor-single-ajax' : '' ) ); ?>>

        <?php documentor()->get_template_part( 'single/sidebar' ); ?>

        <div class="documentor-single-content">
            <?php
            documentor()->get_template_part( 'single/content-breadcrumbs' );

            documentor()->get_template_part( 'single/content-title' );
            ?>

            <div class="entry-content">
                <?php
                the_content();

                wp_link_pages(
                    array(
                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'documentor' ),
                        'after'  => '</div>',
                    )
                );

                documentor()->get_template_part( 'single/content-articles' );
                ?>
            </div><!-- .entry-content -->

            <?php

            documentor()->get_template_part( 'single/footer' );

            documentor()->get_template_part( 'single/adjacent-links' );

            documentor()->get_template_part( 'single/feedback' );

            documentor()->get_template_part( 'single/feedback-suggestion' );

            if ( documentor()->get_option( 'show_comments', 'documentor_single', true ) ) {
                documentor()->get_template_part( 'single/comments' );
            }

            ?>
        </div><!-- .documentor-single-content -->
    </article><!-- #post-## -->
    <?php

endwhile;

documentor()->get_template_part( 'global/wrap-end' );
