<?php
/**
 * Single docs feedback suggestion template
 *
 * This template can be overridden by copying it to yourtheme/documentor/single/feedback-suggestion.php.
 *
 * @author  softaculous
 * @package documentor/Templates
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:disable
$admin_email = documentor()->get_option( 'show_feedback_suggestion_email', 'documentor_single', '' ) ? : get_option( 'admin_email' );

if (
    ! documentor()->get_option( 'show_feedback_buttons', 'documentor_single', true ) ||
    ! documentor()->get_option( 'show_feedback_suggestion', 'documentor_single', false ) ||
    ! $admin_email
) {
    return;
}

$from = '';

if ( is_user_logged_in() ) {
    $user = wp_get_current_user();

    if ( $user->display_name ) {
        $from = $user->display_name;
    }

    if ( $user->user_email ) {
        $from .= ( $from ? ' <' : '' ) . $user->user_email . ( $from ? '>' : '' );
    }
}
// phpcs:enable

?>

<form class="documentor-single-feedback-suggestion" action="" method="post" style="display: none;">
    <h3><?php echo esc_html__( 'How can we improve this documentation?', 'documentor' ); ?></h3>

    <div>
        <textarea name="suggestion" placeholder="<?php echo esc_attr__( 'Your suggestions', 'documentor' ); ?>" required></textarea>

        <input name="from" type="text" value="<?php echo esc_attr( $from ); ?>" placeholder="<?php echo esc_attr__( 'Your Name or Email (Optional)', 'documentor' ); ?>">

        <button class="documentor-btn documentor-btn-md"><?php echo esc_attr__( 'Send', 'documentor' ); ?></button>

        <input type="hidden" name="id" value="<?php echo esc_attr( get_the_ID() ); ?>">
        <input type="hidden" name="action" value="documentor_suggestion">
    </div>
</form>
