/* global kkart_orders_params */
jQuery( function( $ ) {

	if ( typeof kkart_orders_params === 'undefined' ) {
		return false;
	}

	/**
	 * KKARTOrdersTable class.
	 */
	var KKARTOrdersTable = function() {
		$( document )
			.on( 'click', '.post-type-shop_order .wp-list-table tbody td', this.onRowClick )
			.on( 'click', '.order-preview:not(.disabled)', this.onPreview );
	};

	/**
	 * Click a row.
	 */
	KKARTOrdersTable.prototype.onRowClick = function( e ) {
		if ( $( e.target ).filter( 'a, a *, .no-link, .no-link *, button, button *' ).length ) {
			return true;
		}

		if ( window.getSelection && window.getSelection().toString().length ) {
			return true;
		}

		var $row = $( this ).closest( 'tr' ),
			href = $row.find( 'a.order-view' ).attr( 'href' );

		if ( href && href.length ) {
			e.preventDefault();

			if ( e.metaKey || e.ctrlKey ) {
				window.open( href, '_blank' );
			} else {
				window.location = href;
			}
		}
	};

	/**
	 * Preview an order.
	 */
	KKARTOrdersTable.prototype.onPreview = function() {
		var $previewButton    = $( this ),
			$order_id         = $previewButton.data( 'order-id' );

		if ( $previewButton.data( 'order-data' ) ) {
			$( this ).KKARTBackboneModal({
				template: 'kkart-modal-view-order',
				variable : $previewButton.data( 'order-data' )
			});
		} else {
			$previewButton.addClass( 'disabled' );

			$.ajax({
				url:     kkart_orders_params.ajax_url,
				data:    {
					order_id: $order_id,
					action  : 'kkart_get_order_details',
					security: kkart_orders_params.preview_nonce
				},
				type:    'GET',
				success: function( response ) {
					$( '.order-preview' ).removeClass( 'disabled' );

					if ( response.success ) {
						$previewButton.data( 'order-data', response.data );

						$( this ).KKARTBackboneModal({
							template: 'kkart-modal-view-order',
							variable : response.data
						});
					}
				}
			});
		}
		return false;

	};

	/**
	 * Init KKARTOrdersTable.
	 */
	new KKARTOrdersTable();
} );
