/* global kkart_settings_params, wp */
( function( $, params, wp ) {
	$( function() {
		// Sell Countries
		$( 'select#kkart_allowed_countries' ).change( function() {
			if ( 'specific' === $( this ).val() ) {
				$( this ).closest('tr').next( 'tr' ).hide();
				$( this ).closest('tr').next().next( 'tr' ).show();
			} else if ( 'all_except' === $( this ).val() ) {
				$( this ).closest('tr').next( 'tr' ).show();
				$( this ).closest('tr').next().next( 'tr' ).hide();
			} else {
				$( this ).closest('tr').next( 'tr' ).hide();
				$( this ).closest('tr').next().next( 'tr' ).hide();
			}
		}).change();

		// Ship Countries
		$( 'select#kkart_ship_to_countries' ).change( function() {
			if ( 'specific' === $( this ).val() ) {
				$( this ).closest('tr').next( 'tr' ).show();
			} else {
				$( this ).closest('tr').next( 'tr' ).hide();
			}
		}).change();

		// Stock management
		$( 'input#kkart_manage_stock' ).change( function() {
			if ( $( this ).is(':checked') ) {
				$( this ).closest('tbody').find( '.manage_stock_field' ).closest( 'tr' ).show();
			} else {
				$( this ).closest('tbody').find( '.manage_stock_field' ).closest( 'tr' ).hide();
			}
		}).change();

		// Color picker
		$( '.colorpick' )

			.iris({
				change: function( event, ui ) {
					$( this ).parent().find( '.colorpickpreview' ).css({ backgroundColor: ui.color.toString() });
				},
				hide: true,
				border: true
			})

			.on( 'click focus', function( event ) {
				event.stopPropagation();
				$( '.iris-picker' ).hide();
				$( this ).closest( 'td' ).find( '.iris-picker' ).show();
				$( this ).data( 'original-value', $( this ).val() );
			})

			.on( 'change', function() {
				if ( $( this ).is( '.iris-error' ) ) {
					var original_value = $( this ).data( 'original-value' );

					if ( original_value.match( /^\#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/ ) ) {
						$( this ).val( $( this ).data( 'original-value' ) ).change();
					} else {
						$( this ).val( '' ).change();
					}
				}
			});

		$( 'body' ).on( 'click', function() {
			$( '.iris-picker' ).hide();
		});

		// Edit prompt
		$( function() {
			var changed = false;

			$( 'input, textarea, select, checkbox' ).change( function() {
				if ( ! changed ) {
					window.onbeforeunload = function() {
						return params.i18n_nav_warning;
					};
					changed = true;
				}
			});

			$( '.submit :input' ).click( function() {
				window.onbeforeunload = '';
			});
		});

		// Sorting
		$( 'table.kkart_gateways tbody, table.kkart_shipping tbody' ).sortable({
			items: 'tr',
			cursor: 'move',
			axis: 'y',
			handle: 'td.sort',
			scrollSensitivity: 40,
			helper: function( event, ui ) {
				ui.children().each( function() {
					$( this ).width( $( this ).width() );
				});
				ui.css( 'left', '0' );
				return ui;
			},
			start: function( event, ui ) {
				ui.item.css( 'background-color', '#f6f6f6' );
			},
			stop: function( event, ui ) {
				ui.item.removeAttr( 'style' );
				ui.item.trigger( 'updateMoveButtons' );
			}
		});

		// Select all/none
		$( '.kkart' ).on( 'click', '.select_all', function() {
			$( this ).closest( 'td' ).find( 'select option' ).attr( 'selected', 'selected' );
			$( this ).closest( 'td' ).find( 'select' ).trigger( 'change' );
			return false;
		});

		$( '.kkart' ).on( 'click', '.select_none', function() {
			$( this ).closest( 'td' ).find( 'select option' ).removeAttr( 'selected' );
			$( this ).closest( 'td' ).find( 'select' ).trigger( 'change' );
			return false;
		});

		// Re-order buttons.
		$( '.kkart-item-reorder-nav').find( '.kkart-move-up, .kkart-move-down' ).on( 'click', function() {
			var moveBtn = $( this ),
				$row    = moveBtn.closest( 'tr' );

			moveBtn.focus();

			var isMoveUp = moveBtn.is( '.kkart-move-up' ),
				isMoveDown = moveBtn.is( '.kkart-move-down' );

			if ( isMoveUp ) {
				var $previewRow = $row.prev( 'tr' );

				if ( $previewRow && $previewRow.length ) {
					$previewRow.before( $row );
					wp.a11y.speak( params.i18n_moved_up );
				}
			} else if ( isMoveDown ) {
				var $nextRow = $row.next( 'tr' );

				if ( $nextRow && $nextRow.length ) {
					$nextRow.after( $row );
					wp.a11y.speak( params.i18n_moved_down );
				}
			}

			moveBtn.focus(); // Re-focus after the container was moved.
			moveBtn.closest( 'table' ).trigger( 'updateMoveButtons' );
		} );

		$( '.kkart-item-reorder-nav').closest( 'table' ).on( 'updateMoveButtons', function() {
			var table    = $( this ),
				lastRow  = $( this ).find( 'tbody tr:last' ),
				firstRow = $( this ).find( 'tbody tr:first' );

			table.find( '.kkart-item-reorder-nav .kkart-move-disabled' ).removeClass( 'kkart-move-disabled' )
				.attr( { 'tabindex': '0', 'aria-hidden': 'false' } );
			firstRow.find( '.kkart-item-reorder-nav .kkart-move-up' ).addClass( 'kkart-move-disabled' )
				.attr( { 'tabindex': '-1', 'aria-hidden': 'true' } );
			lastRow.find( '.kkart-item-reorder-nav .kkart-move-down' ).addClass( 'kkart-move-disabled' )
				.attr( { 'tabindex': '-1', 'aria-hidden': 'true' } );
		} );

		$( '.kkart-item-reorder-nav').closest( 'table' ).trigger( 'updateMoveButtons' );


		$( '.submit button' ).on( 'click', function() {
			if (
				$( 'select#kkart_allowed_countries' ).val() === 'specific' &&
				! $( '[name="kkart_specific_allowed_countries[]"]' ).val()
			) {
				if ( window.confirm( kkart_settings_params.i18n_no_specific_countries_selected ) ) {
					return true;
				}
				return false;
			}
		} );

	});
})( jQuery, kkart_settings_params, wp );
