<?php
/**
 * Admin View: Notice - Base table missing.
 *
 * @package Kkart\Admin
 */

defined( 'ABSPATH' ) || exit;

?>
<div class="updated kkart-message">
	<a class="kkart-message-close notice-dismiss" href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'kkart-hide-notice', 'base_tables_missing' ), 'kkart_hide_notices_nonce', '_kkart_notice_nonce' ) ); ?>">
		<?php esc_html_e( 'Dismiss', 'kkart' ); ?>
	</a>

	<p>
		<strong><?php esc_html_e( 'Database tables missing', 'kkart' ); ?></strong>
	</p>
	<p>
		<?php
		$verify_db_tool_available = array_key_exists( 'verify_db_tables', KKART_Admin_Status::get_tools() );
		$missing_tables           = get_option( 'kkart_schema_missing_tables' );
		if ( $verify_db_tool_available ) {
			echo wp_kses_post(
				sprintf(
				/* translators: %1%s: Missing tables (seperated by ",") %2$s: Link to check again */
					__( 'One or more tables required for Kkart to function are missing, some features may not work as expected. Missing tables: %1$s. <a href="%2$s">Check again.</a>', 'kkart' ),
					esc_html( implode( ', ', $missing_tables ) ),
					wp_nonce_url( admin_url( 'admin.php?page=kkart-status&tab=tools&action=verify_db_tables' ), 'debug_action' )
				)
			);
		} else {
			echo wp_kses_post(
				sprintf(
				/* translators: %1%s: Missing tables (seperated by ",") */
					__( 'One or more tables required for Kkart to function are missing, some features may not work as expected. Missing tables: %1$s.', 'kkart' ),
					esc_html( implode( ', ', $missing_tables ) )
				)
			);
		}
		?>
	</p>
</div>
