<?php
/**
 * Order Item Product Data Store Interface
 *
 * @version 3.0.0
 * @package Kkart\Interface
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * KKART Order Item Data Store Interface
 *
 * Functions that must be defined by order item store classes.
 *
 * @version  3.0.0
 */
interface KKART_Order_Item_Product_Data_Store_Interface {
	/**
	 * Get a list of download IDs for a specific item from an order.
	 *
	 * @param KKART_Order_Item $item Item object.
	 * @param KKART_Order      $order Order object.
	 * @return array
	 */
	public function get_download_ids( $item, $order );
}
