<?php
/**
 * Kkart Admin: Update version reminder note.
 *
 * Creates a note to nudge users to use the newer version when two are installed.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * Deactivate_Plugin.
 */
class DeactivatePlugin {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-deactivate-plugin';

	/**
	 * Attach hooks.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'deactivate_feature_plugin' ) );
	}

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		$note = new Note();
		$note->set_title( __( 'Deactivate old Kkart Admin version', 'kkart' ) );
		$note->set_content( __( 'Your current version of Kkart Admin is outdated and a newer version is included with Kkart.  We recommend deactivating the plugin and using the stable version included with Kkart.', 'kkart' ) );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_INFORMATIONAL );
		$note->set_name( self::NOTE_NAME );
		$note->set_content_data( (object) array() );
		$note->set_source( 'kkart-admin' );
		$note->add_action(
			'deactivate-feature-plugin',
			__( 'Deactivate', 'kkart' ),
			kkart_admin_url( '&action=deactivate-feature-plugin' ),
			Note::E_KKART_ADMIN_NOTE_UNACTIONED,
			true
		);
		return $note;
	}

	/**
	 * Delete the note if the version is higher than the included.
	 */
	public static function delete_note() {
		Notes::delete_notes_with_name( self::NOTE_NAME );
	}

	/**
	 * Deactivate feature plugin.
	 */
	public function deactivate_feature_plugin() {
		/* phpcs:disable WordPress.Security.NonceVerification */
		if (
			! isset( $_GET['page'] ) ||
			'kkart-admin' !== $_GET['page'] ||
			! isset( $_GET['action'] ) ||
			'deactivate-feature-plugin' !== $_GET['action'] ||
			! defined( 'KKART_ADMIN_PLUGIN_FILE' )
		) {
			return;
		}
		/* phpcs:enable */

		$deactivate_url = admin_url( 'plugins.php?action=deactivate&plugin=' . rawurlencode( KKART_ADMIN_PLUGIN_FILE ) . '&plugin_status=all&paged=1&_wpnonce=' . wp_create_nonce( 'deactivate-plugin_' . KKART_ADMIN_PLUGIN_FILE ) );
		wp_safe_redirect( $deactivate_url );
		exit;
	}
}
