/**
 * External dependencies
 */
import PropTypes from 'prop-types';
import classnames from 'classnames';
import Summary from '@kkart/base-components/summary';
import { getSetting } from '@kkart/settings';
import {
	useInnerBlockLayoutContext,
	useProductDataContext,
} from '@kkart/shared-context';
import { withProductDataContext } from '@kkart/shared-hocs';

/**
 * Internal dependencies
 */
import './style.scss';

/**
 * Product Summary Block Component.
 *
 * @param {Object} props             Incoming props.
 * @param {string} [props.className] CSS Class name for the component.
 * @return {*} The component.
 */
const Block = ( { className } ) => {
	const { parentClassName } = useInnerBlockLayoutContext();
	const { product } = useProductDataContext();

	if ( ! product ) {
		return (
			<div
				className={ classnames(
					className,
					`kkart-block-components-product-summary`,
					{
						[ `${ parentClassName }__product-summary` ]: parentClassName,
					}
				) }
			/>
		);
	}

	const source = product.short_description
		? product.short_description
		: product.description;

	if ( ! source ) {
		return null;
	}

	const countType = getSetting( 'wordCountType', 'words' );

	return (
		<Summary
			className={ classnames(
				className,
				`kkart-block-components-product-summary`,
				{
					[ `${ parentClassName }__product-summary` ]: parentClassName,
				}
			) }
			source={ source }
			maxLength={ 150 }
			countType={ countType }
		/>
	);
};

Block.propTypes = {
	className: PropTypes.string,
};

export default withProductDataContext( Block );
