/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import PropTypes from 'prop-types';
import { useContainerWidthContext } from '@kkart/base-context';
import Panel from '@kkart/base-components/panel';

/**
 * Internal dependencies
 */
import OrderSummaryItem from './order-summary-item.js';
import './style.scss';

const OrderSummary = ( { cartItems = [] } ) => {
	const { isLarge, hasContainerWidth } = useContainerWidthContext();

	if ( ! hasContainerWidth ) {
		return null;
	}

	return (
		<Panel
			className="kkart-block-components-order-summary"
			initialOpen={ isLarge }
			title={
				<span className="kkart-block-components-order-summary__button-text">
					{ __( 'Order summary', 'kkart' ) }
				</span>
			}
			titleTag="h2"
		>
			<div className="kkart-block-components-order-summary__content">
				{ cartItems.map( ( cartItem ) => {
					return (
						<OrderSummaryItem
							key={ cartItem.key }
							cartItem={ cartItem }
						/>
					);
				} ) }
			</div>
		</Panel>
	);
};

OrderSummary.propTypes = {
	cartItems: PropTypes.arrayOf(
		PropTypes.shape( { key: PropTypes.string.isRequired } )
	),
};

export default OrderSummary;
