/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import {
	PRIVACY_URL,
	TERMS_URL,
	PRIVACY_PAGE_NAME,
	TERMS_PAGE_NAME,
} from '@kkart/block-settings';
import { decodeEntities } from '@wordpress/html-entities';

/**
 * Internal dependencies
 */
import './style.scss';

const Policies = () => {
	return (
		<ul className="kkart-block-components-checkout-policies">
			{ PRIVACY_URL && (
				<li className="kkart-block-components-checkout-policies__item">
					<a
						href={ PRIVACY_URL }
						target="_blank"
						rel="noopener noreferrer"
					>
						{ PRIVACY_PAGE_NAME
							? decodeEntities( PRIVACY_PAGE_NAME )
							: __(
									'Privacy Policy',
									'kkart'
							  ) }
					</a>
				</li>
			) }
			{ TERMS_URL && (
				<li className="kkart-block-components-checkout-policies__item">
					<a
						href={ TERMS_URL }
						target="_blank"
						rel="noopener noreferrer"
					>
						{ TERMS_PAGE_NAME
							? decodeEntities( TERMS_PAGE_NAME )
							: __(
									'Terms and Conditions',
									'kkart'
							  ) }
					</a>
				</li>
			) }
		</ul>
	);
};

export default Policies;
