/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { CART_URL } from '@kkart/block-settings';
import { Icon, arrowBack } from '@kkart/icons';

/**
 * Internal dependencies
 */
import './style.scss';

const ReturnToCartButton = ( { link } ) => {
	return (
		<a
			href={ link || CART_URL }
			className="kkart-block-components-checkout-return-to-cart-button"
		>
			<Icon srcElement={ arrowBack } />
			{ __( 'Return to Cart', 'kkart' ) }
		</a>
	);
};

export default ReturnToCartButton;
