/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { FormStep } from '@kkart/base-components/cart-checkout';
import {
	useCheckoutContext,
	useShippingDataContext,
} from '@kkart/base-context';

/**
 * Internal dependencies
 */
import CheckoutOrderNotes from './order-notes';

const OrderNotesStep = () => {
	const { needsShipping } = useShippingDataContext();
	const {
		isProcessing: checkoutIsProcessing,
		orderNotes,
		dispatchActions,
	} = useCheckoutContext();
	const { setOrderNotes } = dispatchActions;

	return (
		<FormStep id="order-notes" showStepNumber={ false }>
			<CheckoutOrderNotes
				disabled={ checkoutIsProcessing }
				onChange={ setOrderNotes }
				placeholder={
					needsShipping
						? __(
								'Notes about your order, e.g. special notes for delivery.',
								'kkart'
						  )
						: __(
								'Notes about your order.',
								'kkart'
						  )
				}
				value={ orderNotes }
			/>
		</FormStep>
	);
};

export default OrderNotesStep;
