import { __ } from '@wordpress/i18n';
import { useState, useEffect, useRef } from '@wordpress/element';
import { useBlockProps, RichText } from '@wordpress/block-editor';

export const RenderImageSliderBlock = (props) =>{
	
	const { _props, tag, data } = props;
	const { setAttributes } = _props;
	const { atts : attributes, id } = data;
	const [imgData, setImgData] = useState({});
		
	useEffect(() => {		
		
		var ids = attributes?.ids ? attributes?.ids : [];
		
		// TODO: preload all image urls form
		// Query the media library for media items with the specified post IDs.
		wp.media.query({ post__in: ids }).more().then(function () {
			
			var urls = {};
			var titles = {};
			var img_urls = {};
			
			for(var x in ids){
				var attachment = wp.media.attachment(ids[x]);
				var i = 'i'+ids[x];
				
				urls[i] = attachment.get('url');
				titles[i] = attachment.get('title');
				
				// Create a URL
				img_urls[i] = {}
				
				for(var x in attachment.get('sizes')){
					img_urls[i][x] = attachment.attributes.sizes[x].url;
				}
			}
			
			setImgData({
				urls: urls,
				allUrls: img_urls,
				allTitles: titles,
			});
		});
		
	}, [attributes]);
	
	useEffect(() => {
		
		var jEle = pagelayer_query(`.p-${id}`);
		
		if(pagelayer_empty(imgData)){
			return;
		}
		
		pagelayer_pl_image_slider(jEle);

	}, [attributes, imgData]);
	
	const renderImageList = () => {
		
		if (
			pagelayer_empty(imgData) ||
			pagelayer_empty(imgData.urls)
		) {
			return (<h4 style={{ textAlign: 'center' }}>
				{ __('Please select Images from left side Widget properties.') }
			</h4>);
		}
		
		// Destroy slider if already setuped
		var jEle = pagelayer_query(`.p-${id}`);
		pagelayer_owl_destroy(jEle, '.pagelayer-image-slider-ul');
			
		// The URLs
		const img_urls = imgData.urls;
		const all_urls = imgData.allUrls;
		const img_title = imgData.allTitles;

		const imageList = [];

		const is_link =	'link_type' in attributes && !pagelayer_empty(attributes['link_type']);

		for (const x in img_urls) {
			// Use the default URL first
			let url = img_urls[x];

			// But if we have a custom size, use that
			if (
				attributes['size'] !== 'custom' &&
				x in all_urls &&
				attributes['size'] in all_urls[x]
			) {
				url = all_urls[x][attributes['size']];
			}

			const listItem = (
				<li className="pagelayer-slider-item" key={x}>
					{is_link ? (
						<a
							href={
							attributes['link_type'] === 'media_file'
							? !pagelayer_empty(img_urls[x])
							  ? img_urls[x]
							  : url
							: attributes['link'] || ''
							}
							className="pagelayer-link-sel"
						>
							<img
								className="pagelayer-img"
								src={url}
								title={img_title[x]}
								alt={img_title[x]}
							/>
						</a>
					) : (
					<img
						className="pagelayer-img"
						src={url}
						title={img_title[x]}
						alt={img_title[x]}
					/>
					)}
				</li>
			);

			imageList.push(listItem);
		}
		
		// Render the list of images
		return (<>
			{ imageList }
			</>
		);
	}
	
	var ulAttrs = {};
	
	// Which arrows to show
	if('controls' in attributes){
		if(attributes.controls == 'arrows' || attributes.controls == 'none'){
			ulAttrs['data-pager'] = "false";
		}
		
		if(attributes.controls == 'pager' || attributes.controls == 'none'){
			ulAttrs['data-controls'] = "false";
		}
	}
	
	return (
		<>
			<div className="pagelayer-image-slider-div">
				<ul
					className="pagelayer-image-slider-ul pagelayer-owl-holder pagelayer-owl-carousel pagelayer-owl-theme"
					{...ulAttrs}
				>
				{ renderImageList() }
				</ul>
			</div>
		</>
	);
}
