import { LabelControl } from './label';

export const CheckboxControl = (props) =>{
	
	const { prop, label, value, setAttributes } = props;
	const { name } = prop['c'];
	
	const handleCheckboxChange = (e) => {
		const checked = e.target.checked;
		setAttributes({[name]: checked ? 'true' : ''});
	};

	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
			<div className="pagelayer-elp-checkbox-div">
				<input
					type="checkbox"
					className="pagelayer-elp-checkbox"
					checked={value === 'true'}
					onChange={handleCheckboxChange}
				/>
			</div>
		</div>
	);
}