import { LabelControl } from './label';
import { MediaUpload } from '@wordpress/block-editor';
import { useState, useEffect, useRef } from '@wordpress/element';

const blankImg = pagelayer_url+'/images/default-image.png';

export const ImageControl = (props) =>{
		
	const { attributes, prop, value, setAttributes, allow = [ 'image' ]} = props;
	const { name } = prop['c'];
	const tmpAtts = attributes?.tmpAtts ?  {...attributes.tmpAtts} : {};
	
	var url = pagelayer_empty(tmpAtts[name+'-url']) ? '' : tmpAtts[name+'-url'];
	
	const onSelectImage = (imageProps) => {
		const { id, url, title, alt, sizes } = imageProps;
		
		var sizeUrls = {};
		
		// Keep a list of all sizes
		for(var x in sizes){
			sizeUrls[name+'-'+x+'-url'] = sizes[x].url;
		}
		
		const tmp = {
			...tmpAtts,
			[name+'-url']: url,
			[name+'-title']: title,
			[name+'-alt']: alt,
			[name+'-no-image-set']: '',
			...sizeUrls
		};
		
		setAttributes({
			[name]: id,
			tmpAtts: tmp
		});
		
		setAttributes({ ['pagelayer-srcset']: url+', '+url+' 1x'});
	}
	
	const onRemoveImage = (e) => {
		e.stopPropagation();
		
		const tmp = {...tmpAtts};
		
		Object.keys(tmp).forEach(key => {
		  if (key.startsWith(name + '-')) {
				delete tmp[key];
		  }
		});
		
		tmp[name+'-no-image-set'] = 1;
		tmp[name+'-url'] = blankImg;
		
		setAttributes({
			[name]: blankImg,
			tmpAtts: tmp
		});
	}
	
	const renderMediaUploader = (open) => {
		const hasImage = !pagelayer_empty(url) ? 'pagelayer-has-image' : '';
		return (
			<div
				className={`pagelayer-elp-image-div ${hasImage}`}
				style={ {backgroundImage: `url("${url}")`} }
				onClick={ () => {open()} }
			>
				<span 
					className="pagelayer-elp-remove-image"
					onClick={onRemoveImage}
				><i className="pli pli-cross" ></i></span>
				<span 
					className="pagelayer-elp-add-image"
				><i className="dashicons dashicons-plus-alt2" ></i></span>				
			</div>
		);
	}
	
	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
				<MediaUpload
					title="Select Image"
					onSelect={ onSelectImage }
					allowedTypes={ allow }
					value={ value }
					render={ ( { open } ) => renderMediaUploader( open ) }
				/>
		</div>
	);	
}