import { LabelControl } from './label';

export const TextareaControl = (props) =>{
	
	const { prop, value, setAttributes	} = props;
	const { name } = prop['c']; 
	
	const rows = prop.rows ? prop.rows : '';

	// Convert the jQuery function to a React method
	const handleInputChange = (e) => {
		setAttributes({ [name]: e.target.value });
	};
	
	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
			<div className="pagelayer-elp-textarea-div">
				<textarea
					rows={rows}
					className="pagelayer-elp-textarea" 
					onChange={handleInputChange}
				>
				{value}
				</textarea>
			</div>
		</div>
	);	
}