<?php
/**
 * 2007-2016 PrestaShop
 *
 * thirty bees is an extension to the PrestaShop e-commerce software developed by PrestaShop SA
 * Copyright (C) 2017-2024 thirty bees
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@thirtybees.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://www.thirtybees.com for more information.
 *
 *  @author    thirty bees <contact@thirtybees.com>
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2017-2024 thirty bees
 *  @copyright 2007-2016 PrestaShop SA
 *  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  PrestaShop is an internationally registered trademark & property of PrestaShop SA
 */

/**
 * Class HelperViewCore
 */
class HelperViewCore extends Helper
{
    /**
     * @var int
     */
    public $id;

    /**
     * @var bool
     */
    public $toolbar = true;

    /**
     * @var string
     */
    public $table;

    /**
     * @var string
     */
    public $token;

    /**
     * @var string|null If not null, a title will be added on that list
     */
    public $title = null;

    /**
     * HelperViewCore constructor.
     */
    public function __construct()
    {
        $this->base_folder = 'helpers/view/';
        $this->base_tpl = 'view.tpl';
        parent::__construct();
    }

    /**
     * @return string
     *
     * @throws SmartyException
     * @throws PrestaShopException
     */
    public function generateView()
    {
        $this->tpl = $this->createTemplate($this->base_tpl);

        $this->tpl->assign(
            [
                'title'          => $this->title,
                'current'        => $this->currentIndex,
                'token'          => $this->token,
                'table'          => $this->table,
                'show_toolbar'   => $this->show_toolbar,
                'toolbar_scroll' => $this->toolbar_scroll,
                'toolbar_btn'    => $this->toolbar_btn,
                'link'           => $this->context->link,
            ]
        );

        return parent::generate();
    }
}
