/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import RegularEvent from"@typo3/core/event/regular-event.js";import Viewport from"@typo3/backend/viewport.js";import{MultiRecordSelectionSelectors}from"@typo3/backend/multi-record-selection.js";import{FileListActionSelector,FileListActionUtility}from"@typo3/filelist/file-list-actions.js";import{ThumbnailSize}from"@typo3/backend/element/thumbnail-element.js";export var FileListDragDropEvent;!function(e){e.transfer="typo3:filelist:resource:dragdrop:transfer"}(FileListDragDropEvent||(FileListDragDropEvent={}));class FileListDragDrop{constructor(){this.dragPreviewId="dragpreview",this.currentAnimationRequestId=null,this.previewSize=32,this.rootDocument=top.document;const e=FileListActionSelector.elementSelector+'[draggable="true"]',t=new Image;t.src="data:image/gif;base64,R0lGODlhAQABAIAAAAUEBAAAACwAAAAAAQABAAACAkQBADs=",new RegularEvent("dragstart",((e,r)=>{const i=[],o=document.querySelectorAll(MultiRecordSelectionSelectors.checkboxSelector+":checked");if(o.length)o.forEach((e=>{if(e.checked){const t=e.closest(FileListActionSelector.elementSelector);t.dataset.filelistDragdropTransferItem="true";const r=FileListActionUtility.getResourceForElement(t);i.push(r)}}));else{const e=r.closest(FileListActionSelector.elementSelector);e.dataset.filelistDragdropTransferItem="true";const t=FileListActionUtility.getResourceForElement(e);i.push(t)}const n=this.createPreview(i);e.dataTransfer.setDragImage(t,0,0),e.dataTransfer.effectAllowed="move",e.dataTransfer.setData("application/json",JSON.stringify(i));const s=this.determinePreviewPosition(e);this.updatePreviewPosition(n,s)})).delegateTo(document,e),new RegularEvent("drag",(e=>{e.stopPropagation()}),{capture:!0,passive:!0}).delegateTo(document,e),new RegularEvent("dragover",((e,t)=>{e.stopPropagation();const r=FileListActionUtility.getResourceForElement(t);this.isDropAllowedOnResoruce(r)&&(e.dataTransfer.dropEffect="move",e.preventDefault(),t.classList.add("success"))}),{capture:!0}).delegateTo(document,e),new RegularEvent("drop",((e,t)=>{e.stopPropagation();const r={action:"transfer",resources:JSON.parse(e.dataTransfer.getData("application/json")??"{}"),target:FileListActionUtility.getResourceForElement(t)};top.document.dispatchEvent(new CustomEvent(FileListDragDropEvent.transfer,{detail:r}))}),{capture:!0,passive:!0}).delegateTo(document,e),new RegularEvent("dragend",(e=>{e.stopPropagation(),this.reset()}),{capture:!0,passive:!0}).delegateTo(document,e),new RegularEvent("dragleave",((e,t)=>{e.stopPropagation(),t.classList.remove("success")}),{capture:!0,passive:!0}).delegateTo(document,e),new RegularEvent("dragover",(e=>{if(0===e.screenX&&0===e.screenY)return;const t=this.rootDocument.getElementById(this.dragPreviewId);if(!t)return;const r=this.determinePreviewPosition(e),i=t.getBoundingClientRect();r.left===i.left&&r.top===i.top||this.updatePreviewPosition(t,r)}),{capture:!0,passive:!0}).bindTo(window)}createPreview(e){this.rootDocument.getElementById(this.dragPreviewId)?.remove();const t=this.rootDocument.createElement("div");t.id=this.dragPreviewId,t.setAttribute("inert","true"),t.classList.add("resource-dragpreview"),this.rootDocument.body.appendChild(t);const r=e.filter((e=>e.hasPreview)).slice(0,3);if(r.length>0){const e=this.rootDocument.createElement("div");e.classList.add("resource-dragpreview-thumbnails"),t.appendChild(e),r.forEach((t=>{const r=new URL(top.TYPO3.settings.Resource.thumbnailUrl,window.origin);r.searchParams.set("identifier",t.uid.toString(10));const i=this.rootDocument.createElement("typo3-backend-thumbnail");i.url=r.toString(),i.size=ThumbnailSize.small,i.height=this.previewSize,i.width=this.previewSize,e.appendChild(i)}))}const i=e.length-r.length;if(i>0){const e=document.createElement("div");e.classList.add("resource-dragpreview-counter"),e.textContent=(r.length>0?"+":"")+i.toString(),t.appendChild(e)}return t}updatePreviewPosition(e,t){this.currentAnimationRequestId&&window.cancelAnimationFrame(this.currentAnimationRequestId),this.currentAnimationRequestId=window.requestAnimationFrame((()=>{e.style.transform="translate("+Math.round(t.left)+"px, "+Math.round(t.top)+"px)"}))}determinePreviewPosition(e){let t=e.clientX+16,r=e.clientY+16;const i=Viewport.ContentContainer.get();if(e.view===i){const e=i.frameElement.getBoundingClientRect();t+=e.left,r+=e.top}return{left:t,top:r}}reset(){document.querySelectorAll(FileListActionSelector.elementSelector).forEach((e=>{delete e.dataset.filelistDragdropTransferItem,e.classList.remove("success")})),this.rootDocument.getElementById(this.dragPreviewId)?.remove()}isDropAllowedOnResoruce(e){return!("filelistDragdropTransferItem"in document.querySelector(FileListActionSelector.elementSelector+'[data-filelist-identifier="'+e.identifier+'"]').dataset)&&"folder"===e.type}}export default new FileListDragDrop;