<?php
/*
Do not put any content above the opening PHP tag
Translated by: LYNX Data Systems ltd.
TO CREATE A NEW LANGUAGE, COPY THE en-us.php to your own localization code name.
We are going to keep these files in the iso xx-xx format because that will also
allow us to autoformat numbers on the sites.

PLEASE put your name somewhere at the top of the language file so we can get in touch with
you to update it and thank you for your hard work!

PLEASE NOTE: DO NOT ADD RANDOM KEYS in the middle of the translations.  In order to make it easier to tell what language keys are missing, from this point forward, we are going to add all new language keys at the BOTTOM of this file. The number of lines in your language file will tell you which keys still need to be translated.  If you have questions please ask on the forums or on Discord.

UserSpice
An Open Source PHP User Management System
by the UserSpice Team at http://UserSpice.com

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
%m1% - Dynamic markers which are replaced at run time by the relevant index.
*/

$lang = array();
//important strings
//You definitely want to customize these for your language
$lang = array_merge($lang, array(
	"THIS_LANGUAGE"	=> "Bulgarian",
	"THIS_CODE"			=> "bg-BG",
	"MISSING_TEXT"	=> "Missing Text",
));

$lang = array_merge($lang, array(
    "PASS_ENTER_CODE"     => "Въведете кода, изпратен на вашия имейл",
    "PASS_EMAIL_ONLY"     => "Моля, проверете имейла си за връзка за вход",
    "PASS_CODE_ONLY"      => "Моля, въведете кода, изпратен на вашия имейл",
    "PASS_BOTH"           => "Моля, проверете имейла си за връзка за вход или въведете кода, изпратен на вашия имейл",
    "PASS_VER_BUTTON"     => "Потвърди кода",
    "PASS_EMAIL_ONLY_MSG" => "Моля, потвърдете имейл адреса си като кликнете на връзката по-долу",
    "PASS_CODE_ONLY_MSG"  => "Моля, въведете кода по-долу, за да влезете",
    "PASS_BOTH_MSG"       => "Моля, потвърдете имейл адреса си като кликнете на връзката по-долу или въведете кода по-долу, за да влезете",
    "PASS_YOUR_CODE"      => "Вашият код за потвърждение е: ",
    "PASS_CONFIRM_LOGIN"  => "Потвърдете Вход",
    "PASS_CONFIRM_CLICK"  => "Кликнете, за да завършите входа",
    "PASS_GENERIC_ERROR"  => "Нещо се обърка",
));

//Database Menus
$lang = array_merge($lang, array(
	"MENU_HOME"			=> "Начало",
	"MENU_HELP"			=> "Помощ",
	"MENU_ACCOUNT"	=> "Профил",
	"MENU_DASH"			=> "Админ панел",
	"MENU_USER_MGR"	=> "Управление на потребители",
	"MENU_PAGE_MGR"	=> "Управление на страници",
	"MENU_PERM_MGR"	=> "управление на права",
	"MENU_MSGS_MGR"	=> "Управление на съобщения",
	"MENU_LOGS_MGR"	=> "Системен лог",
	"MENU_LOGOUT"		=> "Изход",
));

// Signup
$lang = array_merge($lang, array(
	"SIGNUP_TEXT"					=> "Регистрация",
	"SIGNUP_BUTTONTEXT"		=> "Регистрирай ме",
	"SIGNUP_AUDITTEXT"		=> "Регистриран",
));

// Signin
$lang = array_merge($lang, array(
	"SIGNIN_FAIL"				=> "** НЕУСПЕШЕН ВХОД **",
	"SIGNIN_PLEASE_CHK" => "Моля проверерете вашите потребител и парола и опитайте отново",
	"SIGNIN_UORE"				=> "Потребител или И-мейл адрес",
	"SIGNIN_PASS"				=> "Парола",
	"SIGNIN_TITLE"			=> "Вход в системата",
	"SIGNIN_TEXT"				=> "Вход",
	"SIGNOUT_TEXT"			=> "Изход",
	"SIGNIN_BUTTONTEXT"	=> "Вход",
	"SIGNIN_REMEMBER"		=> "Запомни ме",
	"SIGNIN_AUDITTEXT"	=> "Влязъл",
	"SIGNIN_FORGOTPASS"	=> "Забравена парола",
	"SIGNOUT_AUDITTEXT"	=> "Излязъл",
));

// Account Page
$lang = array_merge($lang, array(
	"ACCT_EDIT"					=> "Промяна на информация",
	"ACCT_2FA"					=> "Управление на 2 Факторна Аутентификация",
	"ACCT_SESS"					=> "Управление на сесии",
	"ACCT_HOME"					=> "Account Home",
	"ACCT_SINCE"				=> "Член от",
	"ACCT_LOGINS"				=> "Брой влизания",
	"ACCT_SESSIONS"			=> "Брой активни сесии",
	"ACCT_MNG_SES"			=> "Натиснете бутон упраление на сесии в лявата част за повече информация.",
));

//General Terms
$lang = array_merge($lang, array(
	"GEN_ENABLED"			=> "Активно",
	"GEN_DISABLED"		=> "Неактивно",
	"GEN_ENABLE"			=> "Активирай",
	"GEN_DISABLE"			=> "Деактивирай",
	"GEN_NO"					=> "Не",
	"GEN_YES"					=> "Да",
	"GEN_MIN"					=> "мин",
	"GEN_MAX"					=> "макс",
	"GEN_CHAR"				=> "символ", //as in characters
	"GEN_SUBMIT"			=> "Изпрати",
	"GEN_MANAGE"			=> "Управление на",
	"GEN_VERIFY"			=> "Потвърди",
	"GEN_SESSION"			=> "Сесия",
	"GEN_SESSIONS"		=> "Сесии",
	"GEN_EMAIL"				=> "И-мейл адрес",
	"GEN_FNAME"				=> "Име",
	"GEN_LNAME"				=> "Фамилия",
	"GEN_UNAME"				=> "Потребител",
	"GEN_PASS"				=> "Парола",
	"GEN_MSG"					=> "Съобщение",
	"GEN_TODAY"				=> "Днес",
	"GEN_CLOSE"				=> "Затвори",
	"GEN_CANCEL"			=> "Откажи",
	"GEN_CHECK"				=> "[ маркирай/демаркирай всички ]",
	"GEN_WITH"				=> "with",
	"GEN_UPDATED"			=> "Актуализиран",
	"GEN_UPDATE"			=> "Актуализирай",
	"GEN_BY"					=> "от",
	"GEN_FUNCTIONS"		=> "Функции",
	"GEN_NUMBER"			=> "номер",
	"GEN_NUMBERS"			=> "номера",
	"GEN_INFO"				=> "Информация",
	"GEN_REC"					=> "Записано",
	"GEN_DEL"					=> "Изтрий",
	"GEN_NOT_AVAIL"		=> "Не е налично",
	"GEN_AVAIL"				=> "Налично",
	"GEN_BACK"				=> "Назад",
	"GEN_RESET"				=> "Промяна",
	"GEN_REQ"					=> "задължително",
	"GEN_AND"					=> "и",
	"GEN_SAME"				=> "трябва да бъдат еднакви",
));

$lang = array_merge($lang, array(

    "GEN_PASSKEY"           => "Ключ за достъп",

    "GEN_ACTIONS"           => "Действия",

    "GEN_BACK_TO_ACCT"      => "Обратно към акаунта",

    "GEN_DB_ERROR"          => "Възникна грешка в базата данни. Моля, опитайте отново.",

    "GEN_IMPORTANT"         => "Важно",

    "GEN_NO_PERMISSIONS"    => "Нямате разрешение за достъп до тази страница.",

    "GEN_NO_PERMISSIONS_MSG" => "Нямате разрешение за достъп до тази страница. Ако смятате, че това е грешка, моля свържете се с администратора на сайта.",

    "PASSKEYS_MANAGE_TITLE"                 => "Управление на ключовете за достъп",

    "PASSKEYS_LOGIN_TITLE"                  => "Вход с ключ за достъп",

    "PASSKEY_DELETE_SUCCESS"                => "Ключът за достъп е изтрит успешно.",

    "PASSKEY_DELETE_FAIL_DB"                => "Неуспешно изтриване на ключа за достъп от базата данни.",

    "PASSKEY_DELETE_NOT_FOUND"              => "Ключът за достъп не е намерен или нямате разрешение да го изтриете.",

    "PASSKEY_NOTE_UPDATE_SUCCESS"           => "Бележката за ключа за достъп е актуализирана успешно.",

    "PASSKEY_NOTE_UPDATE_FAIL"              => "Неуспешна актуализация на бележката за ключа за достъп.",

    "PASSKEY_REGISTER_NEW"                  => "Регистриране на нов ключ за достъп",

    "PASSKEY_ERR_LIMIT_REACHED"             => "Достигнахте максимума от 10 ключа за достъп.",

    "PASSKEY_NOTE_TH"                       => "Бележка за ключа",

    "PASSKEY_TIMES_USED_TH"                 => "Брой използвания",

    "PASSKEY_LAST_USED_TH"                  => "Последно използван",

    "PASSKEY_LAST_IP_TH"                    => "Последен IP",

    "PASSKEY_EDIT_NOTE_BTN"                 => "Редактиране на бележката",

    "PASSKEY_CONFIRM_DELETE_JS"             => "Сигурни ли сте, че искате да изтриете този ключ за достъп?",

    "PASSKEY_EDIT_MODAL_TITLE"              => "Редактиране на бележката за ключа",

    "PASSKEY_EDIT_MODAL_LABEL"              => "Бележка за ключа",

    "PASSKEY_SAVE_CHANGES_BTN"              => "Запазване на промените",

    "PASSKEY_NONE_REGISTERED"               => "Все още нямате регистрирани ключове за достъп.",

    "PASSKEY_MUST_REGISTER_FIRST"           => "Първо трябва да регистрирате ключ за достъп от удостоверен акаунт, преди да използвате тази функция.",

    "PASSKEY_STORING"                       => "Запазване на ключа за достъп...",

    "PASSKEY_STORED_SUCCESS"                => "Ключът за достъп е запазен успешно!",

    "PASSKEY_INVALID_ACTION"                => "Невалидно действие: ",

    "PASSKEY_NO_ACTION_SPECIFIED"           => "Не е посочено действие",

    "PASSKEYS_MANAGE_TITLE"                 => "Управление на вашите ключове за достъп",

    "PASSKEYS_LOGIN_TITLE"                  => "Вход с ключ за достъп",

    "PASSKEY_DELETE_SUCCESS"                => "Ключът за достъп е изтрит успешно.",

    "PASSKEY_DELETE_FAIL_DB"                => "Неуспешно изтриване на ключа за достъп от базата данни.",

    "PASSKEY_DELETE_NOT_FOUND"              => "Ключът за достъп не е намерен или разрешението е отказано.",

    "PASSKEY_NOTE_UPDATE_SUCCESS"           => "Бележката за ключа за достъп е актуализирана успешно.",

    "PASSKEY_NOTE_UPDATE_FAIL"              => "Неуспешна актуализация на бележката за ключа за достъп.",

    "PASSKEY_ERR_NETWORK_SUGGESTION"        => "Открит е проблем с мрежата. Опитайте различна мрежа или обновете страницата.",

    "PASSKEY_ERR_CROSS_DEVICE_SUGGESTION"   => "Открито е удостоверяване между устройства. Уверете се, че и двете устройства имат достъп до интернет.",

    "PASSKEY_ERR_CROSS_DEVICE_ALTERNATIVE"  => "Опитайте да отворите тази страница директно на телефона си.",

    "PASSKEY_ERR_DIAGNOSTIC_FAILED"         => "Не можа да се генерира диагностика: ",

    "PASSKEY_MISSING_CREDENTIAL_DATA"       => "Липсват необходимите данни за удостоверяване за запазване.",

    "PASSKEY_MISSING_AUTH_DATA"             => "Липсват необходимите данни за удостоверяване.",

    "PASSKEY_LOG_NO_MESSAGE"                => "Няма съобщение",

    "PASSKEY_USER_NOT_FOUND"                => "Потребителят не е намерен след валидацията на ключа за достъп.",

    "PASSKEY_FATAL_ERROR"                   => "Фатална грешка: ",

    "PASSKEY_LOGIN_SUCCESS"                 => "Успешен вход.",

    // JavaScript status messages (passkeys.php)

    "PASSKEY_CROSS_DEVICE_PREP"             => "Подготовка за регистрация между устройства. Може да се наложи да използвате телефона или таблета си.",

    "PASSKEY_DEVICE_REGISTRATION"           => "Използване на регистрация на ключ за достъп на устройството...",

    "PASSKEY_STARTING_REGISTRATION"         => "Започване на регистрацията на ключа за достъп...",

    "PASSKEY_REQUEST_OPTIONS"               => "Заявяване на опции за регистрация от сървъра...",

    "PASSKEY_FOLLOW_PROMPTS"                => "Следвайте подканите за създаване на вашия ключ за достъп. Може да се наложи да използвате друго устройство.",

    "PASSKEY_FOLLOW_PROMPTS_SIMPLE"         => "Следвайте подканите за създаване на вашия ключ за достъп...",

    "PASSKEY_CREATION_FAILED"               => "Създаването на ключа за достъп се провали - не е върнат удостоверител.",

    "PASSKEY_STORING_SERVER"                => "Запазване на вашия ключ за достъп...",

    "PASSKEY_CREATED_SUCCESS"               => "Ключът за достъп е създаден успешно!",

    "PASSKEY_CROSS_DEVICE_AUTH_PREP"        => "Подготовка за удостоверяване между устройства. Уверете се, че телефонът и компютърът ви имат достъп до интернет.",

    "PASSKEY_DEVICE_AUTH"                   => "Използване на удостоверяване с ключ за достъп на устройството...",

    "PASSKEY_STARTING_AUTH"                 => "Започване на удостоверяването с ключ за достъп...",

    "PASSKEY_QR_CODE_INSTRUCTION"           => "Сканирайте QR кода с телефона си, когато се появи. Уверете се, че и двете устройства имат достъп до интернет.",

    "PASSKEY_PHONE_TABLET_INSTRUCTION"      => "Изберете \"Използване на телефон или таблет\" когато бъдете подканени, след това сканирайте QR кода.",

    "PASSKEY_AUTHENTICATING"                => "Удостоверяване с вашия ключ за достъп...",

    "PASSKEY_SUCCESS_REDIRECTING"           => "Удостоверяването е успешно! Пренасочване...",

    // Timeout messages

    "PASSKEY_TIMEOUT_CROSS_DEVICE"          => "Регистрацията изтече. За устройства: 1) Опитайте отново, 2) Уверете се, че устройствата имат интернет, 3) Обмислете да регистрирате директно на телефона си.",

    "PASSKEY_TIMEOUT_SIMPLE"                => "Регистрацията изтече. Моля, опитайте отново.",

    "PASSKEY_AUTH_TIMEOUT_CROSS_DEVICE"     => "Удостоверяването между устройства изтече. Отстраняване на проблеми: 1) И двете устройства се нуждаят от интернет, 2) Опитайте да сканирате QR кода по-бързо, 3) Обмислете да използвате същото устройство, 4) Някои мрежи блокират удостоверяването между устройства.",

    "PASSKEY_AUTH_TIMEOUT_SIMPLE"           => "Удостоверяването изтече. Моля, опитайте отново.",

    "PASSKEY_NO_CREDENTIAL"                 => "Не е получен удостоверител. Нов опит...",

    "PASSKEY_AUTH_FAILED_NO_CREDENTIAL"     => "Удостоверяването се провали - не е върнат удостоверител.",

    "PASSKEY_ATTEMPT_RETRY"                 => "се провали. Нов опит... (остават %d опита)",

    // Error messages

    "PASSKEY_CROSS_DEVICE_FAILED"           => "Регистрацията между устройства се провали. Опитайте: 1) Уверете се, че и двете устройства имат интернет, 2) Обмислете да регистрирате директно на телефона си, 3) Някои корпоративни мрежи блокират тази функция.",

    "PASSKEY_REGISTRATION_CANCELLED"        => "Регистрацията бе отменена или устройството не поддържа ключове за достъп.",

    "PASSKEY_NOT_SUPPORTED"                 => "Ключовете за достъп не се поддържат на тази комбинация от устройство/браузър.",

    "PASSKEY_SECURITY_ERROR"                => "Грешка в сигурността - това обикновено означава несъответствие на домейн/произход.",

    "PASSKEY_ALREADY_EXISTS"                => "Ключ за достъп вече съществува за този акаунт на това устройство. Опитайте с различно устройство или първо изтрийте съществуващите ключове.",

    "PASSKEY_CROSS_DEVICE_AUTH_FAILED"      => "Удостоверяването между устройства се провали. Опитайте: 1) Уверете се, че и двете устройства имат стабилен интернет, 2) Използвайте същата WiFi мрежа, ако е възможно, 3) Опитайте да се удостоверите директно на телефона си, 4) Някои корпоративни мрежи блокират тази функция.",

    "PASSKEY_AUTH_CANCELLED"                => "Удостоверяването бе отменено или не е избран ключ за достъп.",

    "PASSKEY_NETWORK_ERROR"                 => "Мрежова грешка. За удостоверяване между устройства, и двете устройства се нуждаят от достъп до интернет и може да е необходимо да са в същата мрежа.",

    "PASSKEY_CREDENTIAL_NOT_FOUND"          => "Удостоверяването се провали - удостоверителят не е разпознат.",

    // Cross-device guidance

    "PASSKEY_CROSS_DEVICE_GUIDANCE_TITLE"   => "Съвети за удостоверяване между устройства:",

    "PASSKEY_GUIDANCE_INTERNET"             => "Уверете се, че и компютърът, и телефонът ви имат достъп до интернет",

    "PASSKEY_GUIDANCE_WIFI"                 => "Да сте в същата WiFi мрежа може да помогне (но не винаги е необходимо)",

    "PASSKEY_GUIDANCE_SELECT_DEVICE"        => "Когато бъдете подканени, изберете \"Използване на телефон или таблет\"",

    "PASSKEY_GUIDANCE_SCAN_QUICKLY"         => "Сканирайте QR кода бързо, когато се появи",

    "PASSKEY_GUIDANCE_TRY_DIRECT"           => "Ако се провали, опитайте да обновите и да използвате браузъра на телефона си директно",

    // Troubleshooting

    "PASSKEY_SHOW_TROUBLESHOOTING"          => "Показване на съвети за отстраняване на проблеми",

    "PASSKEY_HIDE_TROUBLESHOOTING"          => "Скриване на съветите за отстраняване на проблеми",

    "PASSKEY_DIAGNOSTICS_RUNNING"           => "Стартира диагностика...",

    "PASSKEY_DIAGNOSTICS_COMPLETE"          => "Диагностиката е завършена. Проверете конзолата за подробности.",

    "PASSKEY_ISSUES_DETECTED"               => "Открити проблеми:",

    "PASSKEY_ENVIRONMENT_SUITABLE"          => "Средата изглежда подходяща за ключове за достъп.",

    "PASSKEY_DIAGNOSTICS_FAILED"            => "Диагностиката се провали:",

    // Modal

    "PASSKEY_ADD_NOTE_NEW"                  => "Добавяне на бележка към вашия нов ключ за достъп",

    // Technical errors

    "PASSKEY_BASE64_ERROR"                  => "Грешка при декодиране на Base64:",

    // Server-side errors (passkey_parser.php)

    "PASSKEY_ERR_NETWORK_SUGGESTION"        => "Открит е проблем с мрежата. Опитайте различна мрежа или обновете страницата.",

    "PASSKEY_ERR_CROSS_DEVICE_SUGGESTION"   => "Открито е удостоверяване между устройства. Уверете се, че и двете устройства имат достъп до интернет.",

    "PASSKEY_ERR_CROSS_DEVICE_ALTERNATIVE"  => "Опитайте да отворите тази страница директно на телефона си.",

    "PASSKEY_ERR_DIAGNOSTIC_FAILED"         => "Не можа да се генерира диагностика: ",

    "PASSKEY_INVALID_JSON"                  => "Получени невалидни JSON данни:",

    "PASSKEY_LOG_NO_MESSAGE"                => "Няма съобщение",

    "PASSKEY_MISSING_CREDENTIAL_DATA"       => "Липсват необходимите данни за удостоверяване за запазване.",

    "PASSKEY_MISSING_AUTH_DATA"             => "Липсват необходимите данни за удостоверяване.",

    "PASSKEY_FATAL_ERROR"                   => "Фатална грешка: ",

    // Session/validation errors (PasskeyHandler.php)

    "PASSKEY_NO_CHALLENGE_SESSION"          => "В сесията не е намерено предизвикателство за регистрация на ключ за достъп. Моля, опитайте да регистрирате отново.",

    "PASSKEY_USER_MISMATCH"                 => "Несъответствие на потребителски ID. Моля, опитайте да регистрирате отново.",

    "PASSKEY_CHALLENGE_USER_MISMATCH"       => "Потребителския ID в опциите за предизвикателство не съответства на текущия потребител. Моля, опитайте да регистрирате отново.",

    "PASSKEY_REGISTRATION_FAILED_ERROR"     => "Регистрацията на ключа за достъп се провали. Моля, уверете се, че устройството и браузърът ви поддържат WebAuthn и опитайте отново. Грешка:",

    "PASSKEY_NO_AUTH_CHALLENGE_SESSION"     => "В сесията не е намерено предизвикателство за потвърждение на ключ за достъп. Моля, опитайте да влезете отново.",

    "PASSKEY_CREDENTIAL_NOT_IN_DB"          => "Удостоверителят за ключа за достъп не е намерен в базата данни.",

    "PASSKEY_CREDENTIAL_WRONG_USER"         => "Удостоверителят за ключа за достъп не принадлежи на очаквания потребител.",

    "PASSKEY_VALIDATION_FAILED_ERROR"       => "Валидацията на ключа за достъп се провали. Моля, опитайте отново или се свържете с поддръжката, ако проблемът продължава. Грешка:",

    "PASSKEY_USER_NOT_FOUND_REGISTRATION"   => "Потребителят не е намерен за регистрация.",

    // --- Used in passkey_parser.php ---

    "PASSKEY_LOGIN_REQUIRED"        => "Трябва да сте влезли, за да извършите това действие.",

    "PASSKEY_ACTION_MISSING"        => "Необходимият параметър 'action' липсваше от заявката.",

    "PASSKEY_STORAGE_FAILED"        => "Неуспешно запазване на ключа за достъп. Операцията беше неуспешна.",

    "PASSKEY_LOGIN_FAILED"          => "Входът с ключ за достъп се провали. Удостоверяването не можа да бъде проверено.",

    "PASSKEY_INVALID_METHOD"        => "Невалиден метод на заявката:", // The script appends the method name after this key

    // --- Used in passkeys.php ---

    "CSRF_ERROR"                    => "Проверката на CSRF токена се провали. Моля, върнете се назад и опитайте да изпратите формуляра отново.",

    // Network analysis from analyzeNetworkConditions()

    "PASSKEY_NETWORK_PRIVATE"       => "Възможен проблем: Изглежда сте в частна мрежа, което понякога може да пречи на комуникацията между устройства.",

    "PASSKEY_NETWORK_PROXY"         => "Възможен проблем: Открит е прокси или VPN. Това може да пречи на комуникацията между устройства.",

    "PASSKEY_NETWORK_MOBILE"        => "Забележка: Изглежда сте в мобилна мрежа. Осигурете стабилна връзка за операции между устройства.",

    "PASSKEY_NETWORK_CORPORATE"     => "Възможен проблем: Може да е активна корпоративна защитна стена, която може да повлияе на удостоверяването между устройства.",

    // Recommendations from getCrossDeviceRecommendations()

    "PASSKEY_RECOMMENDATION_CROSS_DEVICE"   => "Препоръка: Вероятно използвате десктоп. Подгответе се да използвате телефона си за сканиране на QR код.",

    "PASSKEY_RECOMMENDATION_SAME_NETWORK"   => "Препоръка: За най-добри резултати, уверете се, че компютърът и мобилното ви устройство са в същата Wi-Fi мрежа.",

    "PASSKEY_RECOMMENDATION_QR_QUICK"       => "Препоръка: Бъдете готови да сканирате QR кода бързо, тъй като заявката може да изтече.",

    "PASSKEY_RECOMMENDATION_INTERNET"       => "Препоръка: Уверете се, че и компютърът, и мобилното ви устройство имат стабилна интернет връзка.",

    "PASSKEY_RECOMMENDATION_UNITY_WEBVIEW"  => "Препоръка: За Unity WebViews, уверете се, че страницата има достатъчно време да се зареди и обработи заявката за ключ за достъп.",

    "PASSKEY_RECOMMENDATION_UNITY_TIMEOUT"  => "Препоръка: Времето за изчакване може да е по-дълго в Unity. Моля, бъдете търпеливи.",

    "PASSKEY_RECOMMENDATION_MOBILE_LOCAL"   => "Препоръка: Тъй като сте на мобилно устройство, трябва да можете да регистрирате ключ за достъп директно на това устройство.",

    "PASSKEY_RECOMMENDATION_GOOGLE_MANAGER" => "Препоръка: На Android можете да управлявате ключовете си за достъп в Google Password Manager.",

    // Validation from validateCrossDeviceEnvironment()

    "PASSKEY_VALIDATION_RP_IP"                  => "Предупреждение за конфигурацията: ID на доверяющата страна е зададен като IP адрес.",

    "PASSKEY_VALIDATION_RP_DOMAIN"              => "Препоръка: Задайте ID на доверяващата страна на вашето доменно име (напр. yourwebsite.com) за по-добра сигурност и съвместимост.",

    "PASSKEY_VALIDATION_HTTPS_REQUIRED"         => "Грешка в конфигурацията: HTTPS е необходим за работа на ключовете за достъп на действащ сървър. Вашият сайт изглежда е на HTTP.",

    "PASSKEY_VALIDATION_NETWORK"                => "Мрежово предупреждение", // Generic prefix for network issues

    "PASSKEY_VALIDATION_TRY_DIFFERENT_NETWORK"  => "Препоръка: Ако възникнат проблеми, опитайте различна мрежа (напр. превключете от корпоративен Wi-Fi на мобилна точка за достъп).",

    "PASSKEY_VALIDATION_CROSS_DEVICE_INTERNET"  => "Препоръка: За действия между устройства, уверете се, че и двете устройства имат надеждна интернет връзка.",

    "PASSKEY_VALIDATION_MOBILE_FALLBACK"        => "Препоръка: Ако действията между устройства се провалят, опитайте да посетите тази страница директно на мобилното си устройство, за да завършите действието.",

    "PASSKEY_INFO_TITLE"           => "За ключовете за достъп",

    "PASSKEY_INFO_DESC"            => "Ключовете за достъп са сигурен начин за вход без парола, използвайки вградените функции за сигурност на устройството ви като отпечатък, разпознаване на лице или ПИН. Те са по-сигурни от паролите, осигуряват по-бърз вход, работят на различни устройства при синхронизиране с мениджъри на пароли и са устойчиви на фишинг атаки. Ключовете за достъп работят на модерни смартфони, таблети, компютри и могат да се съхраняват в мениджъри на пароли като 1Password, Bitwarden, iCloud Keychain или Google Password Manager.",

    "PASSKEY_BACK_TO_LOGIN"                      => "Обратно към входа",

));

//validation class
$lang = array_merge($lang, array(
	"VAL_SAME"				=> "трябва да бъдат еднакви",
	"VAL_EXISTS"			=> "вече съществува. Моля изберете друго",
	"VAL_DB"					=> "Грешка в базата данни",
	"VAL_NUM"					=> "трябва да бъде число",
	"VAL_INT"					=> "трябва да бъде цяло число",
	"VAL_EMAIL"				=> "трябва да бъде валиден И-мейл адрес",
	"VAL_NO_EMAIL"		=> "не трябва да бъде И-мейл адрес",
	"VAL_SERVER"			=> "трябва да принадлежи на валиден сървър",
	"VAL_LESS"				=> "трябва да бъде по-малко от",
	"VAL_GREAT"				=> "трябва да бъде по-голямо от",
	"VAL_LESS_EQ"			=> "трябва да бъде по-малко или равно на",
	"VAL_GREAT_EQ"		=> "трябва да бъде по-голямо или равно на",
	"VAL_NOT_EQ"			=> "не трябва да бъде равно на",
	"VAL_EQ"					=> "трябва да бъде раввно на",
	"VAL_TZ"					=> "трябва да бъде валидно име на часова зона",
	"VAL_MUST"				=> "трябва да бъде",
	"VAL_MUST_LIST"		=> "трябва да бъде едно от следните",
	"VAL_TIME"				=> "трябва да бъде валидно време",
	"VAL_SEL"					=> "невалидна селекция",
	"VAL_NA_PHONE"		=> "Трябва да бъде валиден Български телефонен номер",
));

//Time
$lang = array_merge($lang, array(
	"T_YEARS"			=> "Години",
	"T_YEAR"			=> "Година",
	"T_MONTHS"		=> "Месеци",
	"T_MONTH"			=> "Месец",
	"T_WEEKS"			=> "Седмици",
	"T_WEEK"			=> "Седмица",
	"T_DAYS"			=> "Дни",
	"T_DAY"				=> "Ден",
	"T_HOURS"			=> "Часа",
	"T_HOUR"			=> "Час",
	"T_MINUTES"		=> "Минути",
	"T_MINUTE"		=> "Минута",
	"T_SECONDS"		=> "Секунди",
	"T_SECOND"		=> "Секунда",
));


//Passwords
$lang = array_merge($lang, array(
	"PW_NEW"		=> "Нова парола",
	"PW_OLD"		=> "Стара парола",
	"PW_CONF"		=> "Потвърди парола",
	"PW_RESET"	=> "Забравена парола",
	"PW_UPD"		=> "Паролата е променена",
	"PW_SHOULD"	=> "Паролата трябва...",
	"PW_SHOW"		=> "Покажи паролата",
	"PW_SHOWS"	=> "Покажи паролите",
));


//Join
$lang = array_merge($lang, array(
	"JOIN_SUC"			=> "Добре дошли в ",
	"JOIN_THANKS"		=> "Благодарим ви, че се регистрирахте!",
	"JOIN_HAVE"			=> "Трябва да има поне ",
	"JOIN_LOWER"		=>	" малка буква",
	"JOIN_SYMBOL"		=> " символ",
	"JOIN_CAP"			=> " главна буква",
	"JOIN_TWICE"		=> "бъде написано правилно два пъти",
	"JOIN_CLOSED"		=> "Регистрацията не е позволена. Свържете се с администратор..",
	"JOIN_TC"				=> "Политика за поверителност и споразумения при регистрация",
	"JOIN_ACCEPTTC" => "Приемам политиката за поверителност и споразуменията при регистрация",
	"JOIN_CHANGED"	=> "Нашата политика е променена",
	"JOIN_ACCEPT" 	=> "Приемам политиката за поверителност и споразуменията",
	"JOIN_SCORE" => "Резултат:",
	"JOIN_INVALID_PW" => "Невалидна парола",

));

//Sessions
$lang = array_merge($lang, array(
	"SESS_SUC"	=> "Успешно прекаратена ",
));

//Messages
$lang = array_merge($lang, array(
	"MSG_SENT"			=> "Вашето съобщение беше изпратено!",
	"MSG_MASS"			=> "Вашето масово съобщение беше изпратено!",
	"MSG_NEW"				=> "Ново съобщение",
	"MSG_NEW_MASS"	=> "Ново масово съобщение",
	"MSG_CONV"			=> "Кореспондеция",
	"MSG_NO_CONV"		=> "Няма кореспонденция",
	"MSG_NO_ARC"		=> "Няма кореспонденция",
	"MSG_QUEST"			=> "Изпрати известие по И-мейл, ако е активно?",
	"MSG_ARC"				=> "Архивирани съобщения",
	"MSG_VIEW_ARC"	=> "Преглед на архивирани",
	"MSG_SETTINGS"  => "Настройки",
	"MSG_READ"			=> "Прочетено",
	"MSG_BODY"			=> "Текст",
	"MSG_SUB"				=> "Тема",
	"MSG_DEL"				=> "Доставено",
	"MSG_REPLY"			=> "Отговор",
	"MSG_QUICK"			=> "Бърз отговор",
	"MSG_SELECT"		=> "Избери потребител",
	"MSG_UNKN"			=> "Непознат получател",
	"MSG_NOTIF"			=> "Съобщение чрез известяване по И-мейл",
	"MSG_BLANK"			=> "Съобщението не може да бъде празно",
	"MSG_MODAL"			=> "Натиснете тук или Alt + R за да изполвате полето или натиснете Shift + R за да разширите панела за отговор!",
	"MSG_ARCHIVE_SUCCESSFUL"        => "Успешно архивирахте %m1% съобщения",
	"MSG_UNARCHIVE_SUCCESSFUL"      => "Успешно разархивирахте %m1% съобщения",
	"MSG_DELETE_SUCCESSFUL"         => "Успешно изтрихте %m1% съобщения",
	"USER_MESSAGE_EXEMPT"         			=> "User is %m1% exempted from messages.",
	"MSG_MK_READ"		=> "Прочетено",
	"MSG_MK_UNREAD"	=> "Непрочетено",
	"MSG_ARC_THR"		=> "Архивирай маркираните съобщения",
	"MSG_UN_THR"		=> "Разархивирай маркираните съобщения",
	"MSG_DEL_THR"		=> "Изтрий маркираните съобщения",
	"MSG_SEND"			=> "Изпрати съобщение",
));

//2 Factor Authentication
$lang = array_merge($lang, array(

    "2FA"               => "Двуфакторно удостоверяване",

    "2FA_CONF"  => "Сигурни ли сте, че искате да изключите двуфакторното удостоверяване? Акаунтът ви вече няма да бъде защитен.",

    "2FA_SCAN"  => "Сканирайте този QR код с вашето приложение за удостоверяване или въведете ключа",

    "2FA_THEN"  => "След това въведете един от вашите еднократни ключове тук",

    "2FA_FAIL"  => "Възникна проблем при проверката на двуфакторното удостоверяване. Моля, проверете интернет връзката или се свържете с поддръжката.",

    "2FA_CODE"  => "Код за двуфакторно удостоверяване",

    "2FA_EXP"       => "Изтече 1 отпечатък",

    "2FA_EXPD"  => "Изтекъл",

    "2FA_EXPS"  => "Изтича",

    "2FA_ACTIVE" => "Активни сесии",

    "2FA_NOT_FN" => "Не са намерени отпечатъци",

    "2FA_FP"        => "Отпечатъци",

    "2FA_NP"        => "Неуспешен вход - Кодът за двуфакторно удостоверяване не беше предоставен. Моля, опитайте отново.",

    "2FA_INV"       => "Неуспешен вход - Кодът за двуфакторно удостоверяване беше невалиден. Моля, опитайте отново.",

    "2FA_FATAL" => "Фатална грешка - Моля, свържете се със системния администратор. В момента не можем да генерираме код за двуфакторно удостоверяване.",

    "2FA_SECTION_TITLE"                    => "Двуфакторно удостоверяване (TOTP)",

    "2FA_SK_ALT"                          => "Ако не можете да сканирате QR кода, ръчно въведете този таен ключ в приложението си за удостоверяване.",

    "2FA_IS_ENABLED"                       => "Двуфакторното удостоверяване защитава вашия акаунт.",

    "2FA_NOT_ENABLED_INFO"                 => "Двуфакторното удостоверяване в момента не е включено.",

    "2FA_NOT_ENABLED_EXPLAIN"              => "Двуфакторното удостоверяване (TOTP) добавя допълнителен слой сигурност към вашия акаунт, като изисква код от приложение за удостоверяване на телефона ви в допълнение към паролата ви.",

    // Setup Process

    "2FA_SETUP_TITLE"                      => "Настройка на двуфакторно удостоверяване",

    "2FA_SECRET_KEY_LABEL"                 => "Таен ключ:",

    "2FA_SETUP_VERIFY_CODE_LABEL"          => "Въведете кода за проверка от приложението",

    // Backup Codes

    "2FA_SUCCESS_ENABLED_TITLE"            => "Двуфакторното удостоверяване е включено! Запазете резервните си кодове",

    "2FA_SUCCESS_ENABLED_INFO"             => "По-долу са вашите резервни кодове. Съхранявайте ги сигурно - всеки може да се използва само веднъж.",

    "2FA_BACKUP_CODES_WARNING"             => "Третирайте тези кодове като пароли. Съхранявайте ги сигурно.",

    "2FA_SUCCESS_BACKUP_REGENERATED"       => "Генерирани са нови резервни кодове. Запазете ги сигурно.",

    "2FA_BACKUP_CODE_LABEL"                => "Резервен код",

    "2FA_REGEN_CODES_BTN"                  => "Регенериране на резервни кодове",

    "2FA_INVALIDATE_WARNING"            => "Това ще обезсили всички съществуващи резервни кодове. Сигурни ли сте?",

    // Authentication

    "2FA_CODE_LABEL"                       => "Код за удостоверяване",

    "2FA_VERIFY_BTN"                       => "Потвърждаване и вход",

    "2FA_VERIFY_TITLE"                     => "Необходимо е двуфакторно удостоверяване",

    "2FA_VERIFY_INFO"                      => "Въведете 6-цифрения код от приложението си за удостоверяване.",

    // Actions & Buttons

    "2FA_ENABLE_BTN"                       => "Включване на двуфакторно удостоверяване",

    "2FA_DISABLE_BTN"                      => "Изключване на двуфакторно удостоверяване",

    "2FA_VERIFY_ACTIVATE_BTN"              => "Потвърждаване и активиране",

    "2FA_CANCEL_SETUP_BTN"                 => "Отказ от настройката",

    "2FA_DONE_BTN"                         => "Готово",

    // Success Messages

    "REDIR_2FA_DIS"                 => "Двуфакторното удостоверяване е изключено.",

    "2FA_SUCCESS_BACKUP_ACK"               => "Резервните кодове са потвърдени.",

    "2FA_SUCCESS_SETUP_CANCELLED"          => "Настройката е отказана.",

    // Error Messages

    "2FA_ERR_INVALID_BACKUP"               => "Невалиден резервен код. Моля, опитайте отново.",

    "2FA_ERR_DISABLE_FAILED"               => "Неуспешно изключване на двуфакторното удостоверяване.",

    "2FA_ERR_NO_SECRET"                    => "Не можа да се извлече тайната за удостоверяване. Моля, опитайте отново.",

    "2FA_ERR_BACKUP_INVALIDATE_FAIL"       => "Резервният код е потвърден, но неуспешно обезсилване. Моля, свържете се с поддръжката.",

    "2FA_ERR_NO_CODE_PROVIDED"             => "Не е предоставен код за удостоверяване.",

    "RATE_LIMIT_LOGIN"              => "Твърде много неуспешни опити за вход. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_TOTP"               => "Твърде много грешни кодове за удостоверяване. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_PASSKEY"            => "Твърде много опити за удостоверяване с ключ за достъп. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_PASSKEY_STORE"      => "Твърде много опити за регистрация на ключ за достъп. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_PASSWORD_RESET"     => "Твърде много заявки за възстановяване на парола. Моля, изчакайте преди да поискате друго възстановяване.",

    "RATE_LIMIT_PASSWORD_RESET_SUBMIT" => "Твърде много опити за възстановяване на парола. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_REGISTRATION"       => "Твърде много опити за регистрация. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_EMAIL_VERIFICATION" => "Твърде много заявки за потвърждение на имейл. Моля, изчакайте преди да поискате друго потвърждение.",

    "RATE_LIMIT_EMAIL_CHANGE"       => "Твърде много заявки за смяна на имейл. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_PASSWORD_CHANGE"    => "Твърде много опити за смяна на парола. Моля, изчакайте преди да опитате отново.",

    "RATE_LIMIT_GENERIC"            => "Твърде много опити. Моля, изчакайте преди да опитате отново.",

));


$lang = array_merge($lang, array(
	"REDIR_2FA"						=> "Съжаляваме.Дву Факторна Аутентификация не е активна",
	"REDIR_2FA_EN"				=> "2 Факторна Аутентификация Активна",
	"REDIR_2FA_DIS"				=> "2 Факторна Аутентификация Неактивна",
	"REDIR_2FA_VER"				=> "2 Факторна Аутентификация Проверена и Активна",
	"REDIR_SOMETHING_WRONG" => "Грешка. Моля опитайте отново.",
	"REDIR_MSG_NOEX"			=> "Това съобщение не ви принадлежи или не съществува.",
	"REDIR_UN_ONCE"				=> "Потребителското име е било променяно вече.",
	"REDIR_EM_SUCC"				=> "И-мейла е Актуализиран Успешно",
));

//Emails
$lang = array_merge($lang, array(
	"EML_SIGN_IN_WITH" => "Вход с:",
	"EML_FEATURE_DISABLED" => "Тази функция е деактивирана",
	"EML_PASSWORDLESS_SENT" => "Моля, проверете имейла си за връзка за вход.",
	"EML_PASSWORDLESS_SUBJECT" => "Моля, потвърдете вашия имейл, за да влезете.",
	"EML_PASSWORDLESS_BODY" => "Моля, потвърдете вашия имейл, като кликнете върху връзката по-долу. Ще бъдете вписани автоматично.",

	"EML_CONF"			=> "Потвърди И-мейл адрес",
	"EML_VER"				=> "Потвърдете вашият И-мейл адрес",
	"EML_CHK"				=> "Изпратен е И-мейл за активация. Моля проверете вашата електронна поща. Също проверете и папката СПАМ, линка за активация е валиден само ",
	"EML_MAT"				=> "И-мейл адресите не съвпадат.",
	"EML_HELLO"			=> "Здравейте от ",
	"EML_HI" => "Здравейте",
	"EML_AD_HAS" => "Администраторът е нулирал вашата парола.",
	"EML_AC_HAS" => "Администраторът е създал вашия акаунт.",
	"EML_REQ" => "Ще трябва да зададете вашата парола, използвайки горепосочения линк.",
	"EML_EXP" => "Моля, обърнете внимание, линковете за парола изтичат след",
	"EML_VER_EXP" => "Моля, обърнете внимание, линковете за верификация изтичат след",
	"EML_CLICK" => "Натиснете тук, за да влезете в системата.",
	"EML_REC" => "Препоръчва се да промените паролата си след влизане в системата.",
	"EML_MSG" => "Имате ново съобщение от",
	"EML_REPLY" => "Натиснете тук, за да отговорите или да видите темата.",
	"EML_WHY" => "Получавате този имейл, защото е направена заявка за нулиране на вашата парола. Ако това не сте вие, можете да пренебрегнете този имейл.",
	"EML_HOW" => "Ако сте вие, натиснете линка по-долу, за да продължите с процеса за нулиране на паролата.",
	"EML_EML" => "Беше направена заявка за промяна на вашия имейл от вашия потребителски акаунт.",
	"EML_VER_EML" => "Благодарим ви за регистрацията. След като потвърдите вашия имейл адрес, ще можете да влезете в системата! Моля, натиснете линка по-долу, за да потвърдите вашия имейл адрес.",

));

//Verification
$lang = array_merge($lang, array(
	"VER_SUC"			=> "Вашият И-мейл адрес e потвърден!",
	"VER_FAIL"		=> "Не успяхме да потвърдим вашият акаунт. Моля опитайте отново.",
	"VER_RESEND"	=> "Изпрати отново активационен И-мейл",
	"VER_AGAIN"		=> "Въведете И-мейл адрес и опитайте отново",
	"VER_PAGE"		=> "<li>Проверете вашата електронна поща и натиснете на линка за активация</li><li>Готово</li>",
	"VER_RES_SUC" => " Линк за активация е изпратен на вашата електронна поща.  Натиснете линка за да завършите активацията. Също проверете и папката СПАМ, ако не откривате нищо в основната папка.  Линковете за активация са валидни само ",
	"VER_OOPS"		=> "Грешка, вероятно е изтекъл срокът за активация. Натиснете линка долу и опитайте отново",
	"VER_RESET"		=> "Вашата парола е променена успешно!",
	"VER_INS"			=> "<li>Въведете И-мейл адрес за да продължите със смяната на парола.</li> <li>Проверете вашата електронна поща и натиснете върху получения линк.</li>
												<li>Следвайте инструкцийте.</li>",
	"VER_SENT"		=> " Линк за промяна на паролата е изпратен на вашата електронна поща. 
			    							 Натиснете линка в съощението за промяна на паролата. Също проверете и папката СПАМ, ако не откривате нищо в основната папка..  Линковете за активация са валидни само ",
	"VER_PLEASE"	=> "Моля променете вашата парола",
));

//User Settings
$lang = array_merge($lang, array(
	"SET_PIN"				=> "ПИН за промяна",
	"SET_WHY"				=> "Защо не мога да променя това?",
	"SET_PW_MATCH"	=> "Новите пароли трябва да съвпадат",

	"SET_PIN_NEXT"	=> "Може да променяте вашият ПИН при следващото влизане",
	"SET_UPDATE"		=> "Актуализирайте вашите потребителски настройки",
	"SET_NOCHANGE"	=> "Промяната на потребителски имена е забранена от администратор.",
	"SET_ONECHANGE"	=> "Промяната на потребителски имена е разрешена само веднъж.",

	"SET_GRAVITAR"	=> "Искате да промените вашата профилна снимка?  <br> Посетете <a href='https://en.gravatar.com/'>https://en.gravatar.com/</a> и се регистрирайте със същия И-мейл адрес, както в този сайт. Става бързо и лесно!",

	"SET_NOTE1"			=> " Забележка  има заявка на изчакване за актуализация на вашия И-мейл адрес ",

	"SET_NOTE2"			=> ".  Моля използвайте верификационния И-мейл за тази заявка. 
		 Ако ви е необходим нов верификационен И-мейл, Моля въведете И-мейл адрес и изпратете заявката отново. ",

	"SET_PW_REQ" 		=> "Необходимо при смяна на парола, И-мейл, или смяна на ПИН",
	"SET_PW_REQI" 	=> "Необходимо при смяна на парола",

));

//Errors
$lang = array_merge($lang, array(
	"ERR_FAIL_ACT"		=> "Неуспешно прекратяване на активна сесия, Грешка: ",
	"ERR_EMAIL"				=> "И-мейл не беше изпратен поради грешка. Моля свържете се с администратор.",
	"ERR_EM_DB"				=> "Този И-мейл адрес не съществува в базата данни",
	"ERR_TC"					=> "Моля прочетете и приемете политиката за поверителност и споразуменията",
	"ERR_CAP"					=> "Неуспешен Captcha тест, Робот!",
	"ERR_PW_SAME"			=> "Старата парола не може да бъде същата като новата",
	"ERR_PW_FAIL"			=> "Неуспешна верификация на парола. Неуспешна актуализация. Моля опитайте отново.",
	"ERR_GOOG"				=> "Забележка:  Ако първоначално сте се регистрирали с Google/Facebook акаунт, ще трябва да използвате линка за забравена парола за да промените вашата парола.",
	"ERR_EM_VER"			=> "Верификацията по И-мейл не е активна. Моля свържете се с администратор.",
	"ERR_EMAIL_STR"		=> "Грешка. Моля потвърдете вашия И-мейл адрес отново.",
));

//Maintenance Page
$lang = array_merge($lang, array(
	"MAINT_HEAD"		=> "Ще се върнем скоро!",
	"MAINT_MSG"			=> "Съжаляваме за неудобството, в момента правим промени по сайта.<br> Ще се върнем скоро!",
	"MAINT_BAN"			=> "Съжаляваме. Вие сте блокирани. Ако е станала грешка, моля свържете се с администратор.",
	"MAINT_TOK"			=> "Има грешка във вашата форма. Моля опитайте отново. Ако тази грешка продължи, моля свържете се с администратор.",
	"MAINT_OPEN"		=> "PHP платформа за управление на потребители с отворен код.",
	"MAINT_PLEASE"	=> "Успешно инсталирахте UserSpice!<br>За да разгледате документацията, моля посетете"
));

//dataTables Added in 4.4.08
//NOTE: do not change the words like _START_ between the two _ symbols!
$lang = array_merge($lang, array(
	"DAT_SEARCH" => "Търсене",
	"DAT_FIRST" => "Първи",
	"DAT_LAST" => "Последен",
	"DAT_NEXT" => "Следващ",
	"DAT_PREV" => "Предишен",
	"DAT_NODATA" => "Няма налични данни в таблицата",
	"DAT_INFO" => "Показване на _START_ до _END_ от общо _TOTAL_ записа",
	"DAT_ZERO" => "Показване на 0 до 0 от 0 записа",
	"DAT_FILTERED" => "(филтрирани от общо _MAX_ записа)",
	"DAT_MENU_LENG" => "Покажи _MENU_ записи",
	"DAT_LOADING" => "Зареждане...",
	"DAT_PROCESS" => "Обработка...",
	"DAT_NO_REC" => "Не бяха намерени съответстващи записи",
	"DAT_ASC" => "Активирайте, за да сортирате колоната във възходящ ред",
	"DAT_DESC" => "Активирайте, за да сортирате колоната в низходящ ред",

));


//LEAVE THIS LINE AT THE BOTTOM.  It allows users/lang to override these keys
if (file_exists($abs_us_root . $us_url_root . "usersc/lang/" . $lang["THIS_CODE"] . ".php")) {
	include($abs_us_root . $us_url_root . "usersc/lang/" . $lang["THIS_CODE"] . ".php");
}
 //do not put a closing php tag here
