SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `softaculous_vision568`
--

-- --------------------------------------------------------

--
-- Table structure for table `avis_activitylog`
--

CREATE TABLE `avis_activitylog` (
  `activity_id` int(15) NOT NULL AUTO_INCREMENT,
  `user_id` int(4) DEFAULT '0',
  `is_client` tinyint(1) DEFAULT '0' COMMENT '0 for staff,1 for client',
  `content` text,
  `module_id` int(15) DEFAULT '0' COMMENT 'setting- 0, client -1, self help-2, blab-3, login-4, cmdb-5,relationship-6, ITIL-7,schedule incident-8,forum-9,task-10,billing-11',
  `activity_date` int(15) DEFAULT '0',
  `ip` varchar(31) DEFAULT NULL,
  `ticket_hash` varchar(255) DEFAULT NULL,
  `ticket_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_adminaccess`
--

CREATE TABLE `avis_adminaccess` (
  `adminaccess_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `domain` varchar(255) DEFAULT NULL,
  `domain_access` text,
  `level` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`adminaccess_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_adminaccess`
--

INSERT INTO `avis_adminaccess` VALUES
(1, 1, '0', '1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_alert`
--

CREATE TABLE `avis_alert` (
  `alert_id` int(15) NOT NULL AUTO_INCREMENT,
  `alert_name` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `vscope` tinyint(2) DEFAULT '0',
  `sms_enabled` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `concat_type` enum('or','and') DEFAULT 'and',
  `event` varchar(255) DEFAULT NULL,
  `template` int(15) DEFAULT '0',
  `reciever` varchar(255) DEFAULT NULL,
  `reciever_team` varchar(255) DEFAULT NULL,
  `hipchat_enabled` int(11) NOT NULL DEFAULT '1',
  `slack_enabled` int(11) NOT NULL DEFAULT '1',
  `slack_chennel_id` text,
  `hipchat_room_ids` text,
  `hangout_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `webhook_ids` text,
  PRIMARY KEY (`alert_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_alert`
--

INSERT INTO `avis_alert` VALUES
(1, 'New incident notification to default team', 1, 0, 0, 0, 1, 'and', '0', 8, '1', '1', 1, 1, NULL, NULL, 1, NULL),
(2, 'Incident assigned to default team', 1, 0, 0, 0, 2, 'and', '8', 8, '1', '1', 1, 1, NULL, NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `avis_alert_criteria`
--

CREATE TABLE `avis_alert_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `alert_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(4) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_alert_criteria`
--

INSERT INTO `avis_alert_criteria` VALUES
(1, 1, 0, 0, '', 'and'),
(2, 1, 0, 0, '', 'or'),
(3, 2, 10, 0, '0', 'and'),
(4, 2, 0, 0, '', 'or');

-- --------------------------------------------------------

--
-- Table structure for table `avis_assign_queue`
--

CREATE TABLE `avis_assign_queue` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `queue_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_attachment`
--

CREATE TABLE `avis_attachment` (
  `attachment_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `parent_type` tinyint(2) DEFAULT '0',
  `file_location` int(15) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(255) DEFAULT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `content` longtext,
  `inline` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`attachment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_auditlog`
--

CREATE TABLE `avis_auditlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-problem, 2-changes',
  `workflow_id` int(11) DEFAULT '0',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_auditlog_archive`
--

CREATE TABLE `avis_auditlog_archive` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-problem, 2-changes',
  `workflow_id` int(11) DEFAULT '0',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_automation`
--

CREATE TABLE `avis_automation` (
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `parent_id` int(15) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  `operation_time` int(15) DEFAULT '0',
  `is_client` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `avis_autotask`
--

CREATE TABLE `avis_autotask` (
  `autotask_id` int(1) NOT NULL AUTO_INCREMENT,
  `autotask_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `event` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`autotask_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_autotask_criteria`
--

CREATE TABLE `avis_autotask_criteria` (
  `atcriteria_id` int(1) NOT NULL AUTO_INCREMENT,
  `autotask_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`atcriteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_auto_assign_ticket_setting`
--

CREATE TABLE `avis_auto_assign_ticket_setting` (
  `assign_setting_id` int(12) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT '0',
  `access` int(11) DEFAULT '0',
  `modified_time` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_balance`
--

CREATE TABLE `avis_balance` (
  `balance_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `amount` decimal(10,2) DEFAULT '0.00',
  `content` text,
  `entry_date` int(15) DEFAULT '0',
  `transaction_id` varchar(255) DEFAULT NULL,
  `invoice_id` int(15) DEFAULT '0',
  `balance_type` tinyint(1) NOT NULL DEFAULT '0',
  `is_credit` tinyint(1) NOT NULL DEFAULT '0',
  `gateway_id` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`balance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_billing_log`
--

CREATE TABLE `avis_billing_log` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `description` tinytext,
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `location` tinyint(4) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  `workflow_id` int(11) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_billrate_setting`
--

CREATE TABLE `avis_billrate_setting` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `domain_id` int(15) DEFAULT '0',
  `billing_method` int(2) DEFAULT '0' COMMENT '0-Incidentbase,1-Timebase',
  `due_time` varchar(100) DEFAULT NULL,
  `time_rate` varchar(100) DEFAULT NULL,
  `bill_time` varchar(100) DEFAULT NULL,
  `balance` varchar(100) DEFAULT NULL,
  `invoice` int(15) DEFAULT '0',
  `ticket_rate` varchar(100) DEFAULT NULL,
  `is_enabled` int(2) DEFAULT '0',
  `entry_date` varchar(255) DEFAULT NULL,
  `is_default_rate` tinyint(1) DEFAULT '0',
  `is_apply_time_credit` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_blab`
--

CREATE TABLE `avis_blab` (
  `blab_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` text,
  `content` text,
  `owner` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `is_closed` tinyint(1) DEFAULT '0',
  `access_type` tinyint(1) DEFAULT '0',
  `ticket_id` int(15) DEFAULT '0',
  `mod_date` int(15) DEFAULT '0',
  PRIMARY KEY (`blab_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_blab_access`
--

CREATE TABLE `avis_blab_access` (
  `access_id` int(15) NOT NULL AUTO_INCREMENT,
  `blab_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  `access_type` tinyint(1) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_date` int(15) DEFAULT '0',
  `interval_time` int(15) DEFAULT '0',
  PRIMARY KEY (`access_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_blab_conversation`
--

CREATE TABLE `avis_blab_conversation` (
  `conversation_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `content` text,
  `entry_date` int(15) DEFAULT '0',
  `owner` int(15) DEFAULT '0',
  `mod_date` int(15) DEFAULT '0',
  PRIMARY KEY (`conversation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_blab_read`
--

CREATE TABLE `avis_blab_read` (
  `read_id` int(15) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(15) DEFAULT '0',
  `receiver_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `flag_read` int(15) DEFAULT '0',
  `mod_date` int(15) DEFAULT '0',
  PRIMARY KEY (`read_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_blab_trend`
--

CREATE TABLE `avis_blab_trend` (
  `trend_id` int(15) NOT NULL AUTO_INCREMENT,
  `blab_id` varchar(255) DEFAULT NULL,
  `trend` varchar(255) DEFAULT NULL,
  `trend_count` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  PRIMARY KEY (`trend_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_breakline`
--

CREATE TABLE `avis_breakline` (
  `breakline_id` int(15) NOT NULL AUTO_INCREMENT,
  `expression` varchar(255) DEFAULT NULL,
  `is_expression` tinyint(1) DEFAULT '1',
  `is_enabled` tinyint(1) DEFAULT '1',
  `exec_order` int(15) DEFAULT '0',
  PRIMARY KEY (`breakline_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_breakline`
--

INSERT INTO `avis_breakline` VALUES
(1, '-- original mail[0-9]* --', 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_calendar_task`
--

CREATE TABLE `avis_calendar_task` (
  `task_id` int(15) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) DEFAULT NULL,
  `description` text,
  `start_date` int(11) DEFAULT '0',
  `end_date` int(11) DEFAULT '0',
  `task_type` tinyint(1) DEFAULT '1',
  `task_status` varchar(31) DEFAULT NULL,
  `priority` varchar(31) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `label` varchar(31) DEFAULT NULL,
  `location` varchar(31) DEFAULT NULL,
  PRIMARY KEY (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_channel`
--

CREATE TABLE `avis_channel` (
  `channel_id` int(15) NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(255) DEFAULT NULL,
  `icon_path` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_access` varchar(511) DEFAULT '0',
  `default_id` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`channel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

--
-- Dumping data for table `avis_channel`
--

INSERT INTO `avis_channel` VALUES
(1, 'Email', 'vh vh-ticket vh-brown', 1, '0', 1),
(2, 'Call', 'vh vh-call vh-green', 1, '0', 2),
(3, 'Facebook', 'vh vh-facebook vh-facebook-color', 1, '0', 3),
(4, 'Twitter', 'vh vh-twitter vh-blue', 1, '0', 4),
(5, 'Portal', 'vh vh-imac', 1, '0', 5),
(6, 'Chat', 'vh vh-chat vh-yellow', 1, '0', 6),
(7, 'Service', 'vh vh-service-item', 1, '0', 7),
(8, 'LiveChatInc', 'vh vh-livechat-inc vh-livechat-inc-color', 1, '0', 8),
(9, 'LiveZilla', 'vh vh-livezilla vh-livezilla-color', 1, '0', 9),
(10, 'UserLike', 'vh vh-userlike vh-userlike-color', 1, '0', 10),
(11, 'Comm100', 'vh vh-comm100 vh-comm100-color', 1, '0', 11),
(12, 'GoToMeeting', 'vh vh-gotomeeting vh-gotomeeting-color', 1, '0', 12),
(13, 'GoToAssist', 'vh vh-gotoassist vh-gotoassist-color', 1, '0', 13),
(14, 'TeamViewer', 'vh vh-teamviewer vh-teamviewer-color', 1, '0', 14),
(15, 'WebEx', 'vh vh-webex vh-webex-color', 1, '0', 15),
(16, 'Twilio', 'vh vh-twilio vh-twilio-color', 1, '0', 16),
(17, 'ClickDesk', 'vh vh-clickdesk vh-clickdesk-color', 1, '0', 17),
(18, 'Zopim', 'vh vh-zopim vh-zopim-color', 1, '0', 18),
(19, 'Exotel', 'vh vh-exotel vh-exotel-color', 1, '0', 19),
(20, 'Google calender', 'vh vh-google vh-google-color', 1, '0', 20),
(21, 'Crisp', 'vh vh-crisp vh-crisp-color', 1, '0', 21),
(22, 'Aircall', 'vh vh-aircall vh-aircall-color', 1, '0', 22),
(23, 'Asterisk', 'vh vh-asterisk vh-asterisk-color', 1, '0', 23),
(24, 'Zoom', 'vh vh-zoom-meetings vh-zoom-meetings-color', 1, '0', 24),
(25, 'Livechat', 'vh vh-chat vh-blue-color', 1, '0', 25),
(26, 'Intercom', 'vh vh-intercom vh-blue-color', 1, '0', 26),
(27, 'Acknowledgement', 'vh vh-vh-icons-logo vh-orange-color', 1, '0', 27);

-- --------------------------------------------------------

--
-- Table structure for table `avis_client`
--

CREATE TABLE `avis_client` (
  `client_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_id` int(15) DEFAULT '0',
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `initials` varchar(15) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT 'MD5(RAND())',
  `contact_number` varchar(255) DEFAULT NULL,
  `mobile_number` varchar(255) DEFAULT NULL,
  `temporary_address` text,
  `permanent_address` text,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip_code` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `website` text,
  `fax` varchar(255) DEFAULT NULL,
  `office_name` varchar(255) DEFAULT NULL,
  `office_email` varchar(255) DEFAULT NULL,
  `office_contact_num` varchar(255) DEFAULT NULL,
  `office_address` text,
  `office_phone` varchar(255) DEFAULT NULL,
  `office_fax` varchar(255) DEFAULT NULL,
  `office_website` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `gender` varchar(15) DEFAULT '',
  `birthdate` int(15) DEFAULT '0',
  `netmeetingid` varchar(255) DEFAULT NULL,
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `otherim` varchar(255) DEFAULT NULL,
  `is_spam` tinyint(1) DEFAULT '0',
  `is_banned` tinyint(1) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '1',
  `is_verified` tinyint(1) DEFAULT '1',
  `parent_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `optionB_domain_id` int(15) DEFAULT '0',
  `credit` decimal(10,2) DEFAULT '0.00',
  `balance` int(15) DEFAULT '0',
  `image_path` varchar(255) DEFAULT NULL,
  `language` int(15) NOT NULL DEFAULT '1',
  `login_as` int(15) NOT NULL DEFAULT '0' COMMENT '1-FB, 2-gmail, 3-twitter,4-whmcs,5-clientexec,6-linkedin,7-sugarcrm,8-wordpress,9-drupal',
  `department_access` varchar(255) DEFAULT '0',
  `client_type` int(1) NOT NULL DEFAULT '0' COMMENT '0 for regular client, 1 for call client',
  `password_auth` int(3) DEFAULT '0',
  `forum_signature_content` text,
  `forum_email_notification` int(1) NOT NULL DEFAULT '1',
  `is_manager` int(1) NOT NULL DEFAULT '0' COMMENT '0=No,1=Yes',
  `harvest_id` int(11) NOT NULL DEFAULT '0' COMMENT 'harvest client registration id',
  `registration_date` int(15) DEFAULT '0' COMMENT 'client registeration date',
  `client_permission` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0 default 1=approval permission',
  `ticket_approve_permission` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0 default 1=incident approval permission',
  `pp_accept_date` int(15) DEFAULT '0' COMMENT 'privacy policy accept date',
  `linkedin_url` text,
  `otp_number` varchar(255) NOT NULL,
  PRIMARY KEY (`client_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_client`
--

INSERT INTO `avis_client` VALUES
(0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'MD5(RAND())', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1, 0, NULL, 0, '0.00', 0, NULL, 1, 0, '0', 0, 0, NULL, 1, 0, 0, 0, 0, 0, 0, NULL, ''),
(1, 1, 'Sample', 'Customer', NULL, 'customer@iamdemo.com', 'customer@iamdemo.com', 'xZisoLyXrao=', 'ce9a9a5bfc188d0f632db45561d6fda5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1, 0, 1, 1, '0.00', 0, NULL, 1, 0, '0', 0, NULL, NULL, 1, 0, 0, [[timestamp]], 0, 0, 0, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `avis_clientportal_design`
--

CREATE TABLE `avis_clientportal_design` (
  `design_id` int(5) NOT NULL AUTO_INCREMENT,
  `domain_id` int(5) DEFAULT '0',
  `design_content` longtext,
  `design_type` varchar(20) DEFAULT NULL,
  `design_filename` varchar(20) DEFAULT NULL,
  `is_enable` int(5) DEFAULT '1',
  PRIMARY KEY (`design_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_client_email`
--

CREATE TABLE `avis_client_email` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT '0',
  `additional_email` varchar(255) DEFAULT NULL,
  `is_verified` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=11 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_client_group`
--

CREATE TABLE `avis_client_group` (
  `group_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) DEFAULT NULL,
  `group_type` int(4) NOT NULL DEFAULT '0',
  `description` text,
  `is_enable` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `credit` decimal(10,2) DEFAULT '0.00',
  `debit` decimal(10,2) DEFAULT '0.00',
  `office_email` varchar(255) DEFAULT NULL,
  `office_contact_num` varchar(255) DEFAULT NULL,
  `office_address` text,
  `office_city` varchar(255) DEFAULT NULL,
  `office_state` varchar(255) DEFAULT NULL,
  `office_country` varchar(255) DEFAULT NULL,
  `office_phone` varchar(255) DEFAULT NULL,
  `office_fax` varchar(255) DEFAULT NULL,
  `office_website` varchar(255) DEFAULT NULL,
  `domain_id` int(15) DEFAULT '0',
  `zip_code` varchar(255) DEFAULT NULL,
  `domain_list` text,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_client_group`
--

INSERT INTO `avis_client_group` VALUES
(1, 'Default', 0, '', 1, 0, '0.00', '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `avis_cmdbfilter`
--

CREATE TABLE `avis_cmdbfilter` (
  `filter_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) DEFAULT NULL,
  `vscope` tinyint(2) DEFAULT '1',
  `display_order` int(15) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `filter` longtext,
  `concat_type` enum('and','or') DEFAULT 'and',
  `is_enabled` tinyint(1) DEFAULT '1',
  `search_trash` tinyint(1) DEFAULT '0',
  `search_spam` tinyint(1) DEFAULT '0',
  `is_report` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_cmdbfilter_criteria`
--

CREATE TABLE `avis_cmdbfilter_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_cmdb_checkinout`
--

CREATE TABLE `avis_cmdb_checkinout` (
  `check_id` int(15) NOT NULL AUTO_INCREMENT,
  `assets_id` int(15) NOT NULL,
  `checkinoutstatus` int(15) NOT NULL COMMENT '1-Checkin, 2- checkout',
  `usedby` varchar(255) NOT NULL,
  `usedbytype` int(2) NOT NULL,
  `staff_id` int(15) NOT NULL,
  `remark` text NOT NULL,
  `entry_date` varchar(255) NOT NULL,
  PRIMARY KEY (`check_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_contract_poorders`
--

CREATE TABLE `avis_contract_poorders` (
  `po_id` int(15) NOT NULL AUTO_INCREMENT,
  `po_no` int(15) NOT NULL,
  `po_name` varchar(255) NOT NULL,
  `po_date` int(15) NOT NULL,
  `invoice_no` varchar(15) NOT NULL,
  `invoice_date` int(15) NOT NULL,
  `po_description` varchar(255) NOT NULL,
  `contract_id` int(15) NOT NULL,
  `entry_date` int(15) NOT NULL,
  `staff_id` int(15) NOT NULL,
  `license_count` int(15) NOT NULL,
  `cost` int(15) NOT NULL,
  `total_cost` int(15) NOT NULL,
  `attach_ci` varchar(255) NOT NULL,
  PRIMARY KEY (`po_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_credit`
--

CREATE TABLE `avis_credit` (
  `credit_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `owner_type` int(1) DEFAULT '0',
  `creator_id` int(15) DEFAULT '0',
  `content` text,
  `amount` varchar(15) NOT NULL,
  `ticket_balance` tinyint(1) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `ticket_id` int(20) DEFAULT '0',
  `v4entries` int(2) NOT NULL DEFAULT '0',
  `addmethod` int(15) NOT NULL DEFAULT '0' COMMENT '0 for manual or invoicehash',
  PRIMARY KEY (`credit_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_customfield`
--

CREATE TABLE `avis_customfield` (
  `customfield_id` int(15) NOT NULL AUTO_INCREMENT,
  `customgroup_id` int(15) DEFAULT '0',
  `ci_type` int(4) DEFAULT '0',
  `field_type` int(4) DEFAULT '1',
  `field_group` int(15) DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `field_description` varchar(255) DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `default_value` varchar(255) DEFAULT NULL,
  `is_selected` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '0',
  `is_required` tinyint(1) DEFAULT '0',
  `is_staff_editable` tinyint(1) DEFAULT '0',
  `is_user_editable` tinyint(1) DEFAULT '0',
  `regular_expression` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`customfield_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_customfield`
--

INSERT INTO `avis_customfield` VALUES
(1, 1, 0, 3, 1, 'Incident feedback', 'Please comment about support quality.', 0, '', 0, 1, 0, 1, 1, 'none');

-- --------------------------------------------------------

--
-- Table structure for table `avis_customfield_data`
--

CREATE TABLE `avis_customfield_data` (
  `customfield_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `group_type` int(15) DEFAULT '0',
  `customfield_id` int(15) DEFAULT '0',
  `content` text,
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`customfield_data_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_customgroup`
--

CREATE TABLE `avis_customgroup` (
  `customgroup_id` int(15) NOT NULL AUTO_INCREMENT,
  `customgroup_name` varchar(255) DEFAULT NULL,
  `description` text,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `location` tinyint(4) DEFAULT '0',
  `department_access` varchar(255) DEFAULT NULL,
  `visible_to` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customgroup_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_customgroup`
--

INSERT INTO `avis_customgroup` VALUES
(1, 'Feedback', NULL, 0, 1, 3, '0', 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_dashboard_data`
--

CREATE TABLE `avis_dashboard_data` (
  `dashboard_data_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) DEFAULT '0',
  `module_name` varchar(255) DEFAULT NULL,
  `is_changed` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`dashboard_data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `avis_dashboard_data`
--

INSERT INTO `avis_dashboard_data` VALUES
(1, 2, 'incident', 0),
(2, 3, 'clients', 0),
(3, 4, 'solutions', 0),
(4, 5, 'billing', 0),
(5, 10, 'cmdb', 0),
(6, 11, 'task', 0),
(7, 12, 'forums', 0),
(8, 14, 'problems', 0),
(9, 15, 'releases', 0),
(10, 16, 'contract', 0),
(11, 17, 'changes', 0),
(12, 18, 'service request', 0),
(13, 25, 'livechat', 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_department`
--

CREATE TABLE `avis_department` (
  `department_id` int(15) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(255) DEFAULT NULL,
  `description` text,
  `domain_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `is_paid` tinyint(1) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `autoresponder_id` int(15) DEFAULT '2',
  `autoresponder` tinyint(1) DEFAULT '1',
  `registration` tinyint(1) DEFAULT '0',
  `signature` text,
  `chataccess` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`department_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_department`
--

INSERT INTO `avis_department` VALUES
(1, 'General', NULL, 1, 1, 0, 0, 1, 2, 1, 0, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_departmentview`
--

CREATE TABLE `avis_departmentview` (
  `department_vid` int(15) NOT NULL AUTO_INCREMENT,
  `department_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  PRIMARY KEY (`department_vid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_device`
--

CREATE TABLE `avis_device` (
  `device_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `device_type` int(4) DEFAULT '0',
  `api_key` varchar(255) DEFAULT NULL,
  `staff_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `badgecount` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`device_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_devices`
--

CREATE TABLE `avis_devices` (
  `devices_id` int(4) NOT NULL AUTO_INCREMENT,
  `user_id` int(15) DEFAULT '0',
  `ip` varchar(31) DEFAULT NULL,
  `logintime` int(15) DEFAULT '0',
  `session_id` varchar(65) DEFAULT NULL,
  `usebrows` varchar(85) DEFAULT NULL,
  `content` text,
  `usedevice` varchar(85) DEFAULT NULL,
  `is_banned_devices` tinyint(1) DEFAULT '0',
  `login_attempts` int(15) DEFAULT '0',
  PRIMARY KEY (`devices_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_domain`
--

CREATE TABLE `avis_domain` (
  `domain_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `default_email` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `domain_url` varchar(255) DEFAULT NULL,
  `domain_name` varchar(255) DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `language_id` int(15) DEFAULT '1',
  `timezone` varchar(255) DEFAULT '0',
  `timezone_dst` tinyint(1) DEFAULT '0',
  `theme` varchar(255) NOT NULL DEFAULT 'default',
  `send_mail` int(15) DEFAULT '0',
  `bcc_email` varchar(255) DEFAULT NULL,
  `currency` varchar(4) DEFAULT 'USD',
  `timezone_name` text,
  PRIMARY KEY (`domain_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_domain`
--

INSERT INTO `avis_domain` VALUES
(1, NULL, 1, '[[admin_email]]', '[[domhost]]', '[[softurl]]/', '[[site_name]]', 1, 1, '0', 0, 'default', 0, NULL, 'USD', 'London, Monrovia, Nouakchott, Ouagadougou, Reykjavik, Sao Tome, St Helena');

-- --------------------------------------------------------

--
-- Table structure for table `avis_drive`
--

CREATE TABLE `avis_drive` (
  `drive_id` int(15) NOT NULL AUTO_INCREMENT,
  `department_id` int(15) NOT NULL DEFAULT '0',
  `owner` int(4) DEFAULT '0',
  `file_location` int(15) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(255) DEFAULT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `content` longtext,
  `creation_date` int(15) DEFAULT '0',
  PRIMARY KEY (`drive_id`),
  KEY `department_id` (`department_id`),
  KEY `file_name` (`file_name`),
  KEY `file_type` (`file_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_dst_setting`
--

CREATE TABLE `avis_dst_setting` (
  `timezone_id` int(11) NOT NULL AUTO_INCREMENT,
  `timezone` varchar(50) DEFAULT NULL,
  `dst_timezone` int(11) DEFAULT '0' COMMENT '0=No DST,1=DST',
  `dst_start_date` varchar(50) DEFAULT NULL,
  `dst_end_date` varchar(50) DEFAULT NULL,
  `dst_flag` int(11) DEFAULT '0' COMMENT '0 for same year, 1 for previous year, 2 for next year ',
  PRIMARY KEY (`timezone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=49 ;

--
-- Dumping data for table `avis_dst_setting`
--

INSERT INTO `avis_dst_setting` VALUES
(1, '-43200', 0, '', '', 0),
(2, '-39600', 0, '', '', 0),
(3, '-36000', 0, '', '', 0),
(4, '-34200', 0, '', '', 0),
(5, '-32400', 0, '', '', 0),
(6, '-28800', 0, '', '', 0),
(7, '-28800', 1, '13-03', '06-11', 0),
(8, '-25200', 0, '', '', 0),
(9, '-25200', 1, '13-03', '06-11', 0),
(10, '-21600', 0, '', '', 0),
(11, '-21600', 1, '03-04', '30-10', 0),
(12, '-18000', 0, '', '', 0),
(13, '-18000', 1, '13-03', '06-11', 0),
(14, '-14400', 0, '', '', 0),
(15, '-14400', 1, '13-03', '06-11', 0),
(16, '-12600', 1, '13-03', '06-11', 0),
(17, '-10800', 0, '', '', 0),
(18, '-10800', 1, '16-10', '21-02', 1),
(19, '-7200', 0, '', '', 0),
(20, '-3600', 0, '', '', 0),
(21, '-3600', 1, '27-03', '30-10', 0),
(22, '+0', 0, '', '', 0),
(23, '+0', 1, '27-03', '30-10', 0),
(24, '+3600', 0, '', '', 0),
(25, '+3600', 1, '27-03', '30-10', 0),
(26, '+7200', 0, '', '', 0),
(27, '+7200', 1, '27-03', '30-10', 0),
(28, '+10800', 0, '', '', 0),
(29, '+10800', 1, '27-03', '30-10', 0),
(30, '+12600', 1, '21-03', '21-09', 0),
(31, '+14400', 0, '', '', 0),
(32, '+16200', 0, '', '', 0),
(33, '+18000', 0, '', '', 0),
(34, '+19800', 0, '', '', 0),
(35, '+21600', 0, '', '', 0),
(36, '+23400', 0, '', '', 0),
(37, '+25200', 0, '', '', 0),
(38, '+28800', 0, '', '', 0),
(39, '+32400', 0, '', '', 0),
(40, '+34200', 0, '', '', 0),
(41, '+36000', 0, '', '', 0),
(42, '+37800', 1, '02-10', '03-04', 1),
(43, '+39600', 0, '', '', 0),
(44, '+39600', 1, '02-10', '03-04', 1),
(45, '+43200', 0, '', '', 0),
(46, '+43200', 1, '06-11', '17-01', 1),
(47, '+46800', 0, '', '', 0),
(48, '+46800', 1, '25-09', '03-04', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_emailtemplate`
--

CREATE TABLE `avis_emailtemplate` (
  `etemplate_id` int(15) NOT NULL AUTO_INCREMENT,
  `etemplate_name` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `content` text,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `default_id` int(4) DEFAULT '0',
  `is_itil` int(11) DEFAULT '0',
  `language` int(15) DEFAULT '1',
  `parent_id` int(11) DEFAULT '0',
  `attachment_setting` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`etemplate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=48 ;

--
-- Dumping data for table `avis_emailtemplate`
--

INSERT INTO `avis_emailtemplate` VALUES
(1, 'Client registration', 'Client registration details', 'Hello {username},<br>Thank you for registering with us.<br><br>Your account has been setup and you can now login to our client portal . <br>Client portal url : <a href="{link}">{link}</a><br>Email: {useremail}<br><br> Please reset your password by using following link <br><a href="{resetlink}">{resetlink}<span></span></a><br>Using client portal you can track your existing incidents, submit new incidents and update your profile.<br>', 0, 1, 1, 0, 1, 0, 1),
(2, 'Auto responder', '[{ticket_hash}]: {subject}', 'Hello {username},<br>           A request for assistance has been received. Our system has created a incident for your issue.<br><br><strong>Following are incident details -</strong><br>Incident ID: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Our staff will assist you shortly.<br>You can update or reply your incident online at :<br><a href="{link}">{link}</a><br><br>Login URL  as below:<br><span class="nodeLabelBox repTarget "><span class="nodeAttr editGroup "><span class="nodeValue editable "><a href="{login_url}">{login_url}</a></span></span></span>', 0, 1, 2, 0, 1, 0, 1),
(3, 'Staff reply', '[{ticket_hash}]: {subject}', ' {reply_message}<br><br><strong>Incident details - </strong><br>Incident ID: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br></br>You can update or reply your incident online at : <br><a href="{link}">{link}</a><br><br>Login to client portal using following link: <br><a href="{login_url}">{login_url}</a><br>', 0, 1, 3, 0, 1, 0, 1),
(4, 'Restricted client', 'Restricted client', 'Hello,<br>\r\n<br>\r\nThe email address that you have used to submit incident is not registered in our client portal. While sending email please make sure you use the same email address that you have used while registering with us.<br>\r\n<br>\r\nIf you have not registered to our client portal, we request you to register it and then submit incidents.<br>\r\n<br>\r\nYou can register to our client portal here - <br>\r\n<a href="{link}">{link}</a><br>', 0, 1, 4, 0, 1, 0, 1),
(5, 'Reset password', 'Reset password', 'Hello {username}<br>            As per your password reset request, Please click on following link to reset your password <br><a href="{resetlink}"> {resetlink}</a>', 0, 1, 5, 0, 1, 0, 1),
(6, 'Client approval pending', 'Registration pending for approval', 'Hello {username},<br />\r\n<br />\r\nThank you for registering to our client portal.<br />\r\nYour account is currently being reviewed and once its active you will receive email with login details for our client portal ', 0, 1, 6, 0, 1, 0, 1),
(7, 'Incident auto close', 'Incident Auto close', 'This is an automatically generated email alert by our helpdesk system.<br>\r\n<br>\r\nBelow mentioned incident has not been updated in the last 24 hours and will be automatically closed by the system.<br>\r\nIf your issue is already resolved please ignore this email otherwise update your incident with further details so that our staff can assist you.<br>\r\n<br>\r\nIncident Id: {ticket_hash}<br>\r\nSubject: {subject}<br>\r\nDepartment: {department}<br>\r\nIncident type: {ticket_type}<br>\r\nPriority: {priority}<br>\r\nStatus: {status}<br>', 0, 1, 7, 0, 1, 0, 1),
(8, 'Alert template', '{alert}[{ticket_hash}]: {subject}', '{ticket_reply}<br>\r\n<br><strong>Incident details :</strong><br>Incident Id: {ticket_hash}<br>Subject: {subject}<br>\r\nDepartment: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Last replier: {last_replier}<br>', 0, 1, 8, 0, 1, 0, 1),
(9, 'Invoice created', 'Invoice created', 'Dear {username},<br>            This is a notice that an invoice has been generated on {invoice_date}.<br><br>Invoice #{invoice_hash}<br>Amount Due: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br>Due Date: {invoice_duedate}<br><br><strong>Invoice Items</strong><br>{description}<br>Total: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br>------------------------------------------------------<br><strong>Sub Total</strong>: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br><strong>Total:</strong> {currency_symbol}<span></span>{invoice_amount} {currency} <span></span><br>------------------------------------------------------<br>Check invoice details using following link : <br>{invoice_link}<br>', 0, 1, 9, 0, 1, 0, 1),
(10, 'Send email', '[{ticket_hash}]: {subject}', '<strong></strong> {message}', 0, 1, 10, 0, 1, 0, 1),
(11, 'Incident forward', '[{ticket_hash}]: {subject}', '{reply_message}', 0, 1, 11, 0, 1, 0, 1),
(12, 'No balance', 'Insufficient balance', 'Hello,<br>\r\n<br> \r\n      You have opted to open incident for a paid department but your account do not have sufficient funds. Please add funds to your account and then re-open the incident.', 0, 1, 12, 0, 1, 0, 1),
(13, 'Staff registration', 'Staff registration details', 'Hello {staff_name},<br>\r\n<div>\r\n	Welcome to our help desk staff portal.\r\n<br><br>Your account has been setup and you can now login to staff portal using details below.<br><div>\r\nStaff Portal URL: <a href="{manage_portal_link}">{manage_portal_link} </a><br>\r\nUserName: {user_name}<br>\r\n Please reset your  password by using following link<br>\r\n <a href="{resetlink}">{resetlink}</a><br>\r\n<br>\r\nPlease feel free to update your profile, signature and other help desk related settings.<br></div></div>', 0, 1, 13, 0, 1, 0, 1),
(14, 'Parser failed', 'Email not parsed for {mail_queue}: {subject}', '<p>Sender : {from_email}<br> To : {mail_queue}<span></span></p><p>Actual message :<br> {message}</p>', 0, 1, 14, 0, 1, 0, 1),
(15, 'New blab', 'New blab added', 'Hello {first_name} {last_name},<br> New blab added by {staff_name}. <br><strong>Blab content : </strong><br>{message}<br>{company}<br>{view_blab_link}', 0, 1, 15, 0, 1, 0, 1),
(16, 'Client registration verification email', 'Verify email', 'Hello {username},<br> Thank you for registering to our client portal. Please click on following link to verify your email. <br><a href="{verification_link}">{verification_link}</a><br>', 0, 1, 16, 0, 1, 0, 1),
(17, 'Change approval', 'Approval request for change', 'Hello {first_name} {last_name},<br><br>Approval request for change {changes_hash} {changes_name} is waiting for your approval. <br> Please visit <a href="{changes_details_link}">{changes_details_link}</a> and confirm your approval.<span></span><br>', 0, 1, 17, 1, 1, 0, 1),
(18, 'Contract approval', 'Request for contract approval', 'Hello {first_name} {last_name},<br><br>A new contract {contract_name}(#{contract_number}) is waiting for your approval.<br> Please visit <a href="{contract_approval_link}">{contract_approval_link}</a> and confirm your approval.<br><br>', 0, 1, 18, 0, 1, 0, 1),
(19, 'Release approval', 'Approval request for release ', 'Hello {first_name} {last_name},<br><br>Approval request for release {release_hash} {releases_name} is waiting for your approval. <br>Please visit <a href="{releases_approval_link}">{releases_approval_link}</a> and confirm your approval.', 0, 1, 19, 1, 1, 0, 1),
(20, 'Alert ITIL template', '{alert}     [{problem_hash}{change_hash}{release_hash}]: {subject}', 'Alert : {alert}<br>Hash: {problem_hash}{change_hash}{release_hash} <br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Impact : {impact}<br>Risk : {risk}<br>Type : {type}<br><br>', 0, 1, 20, 1, 1, 0, 1),
(21, 'Contract expiry reminder', 'Contract expiry reminder', 'Hello,<br>{contract_name}(#{contract_number})<span></span> is due for renewal and will  be expired in next {contract_days}  days. <br>Please visit  below contract link to view more details<br><a href="{contract_link}">{contract_link}</a><br>', 0, 1, 21, 0, 1, 0, 1),
(22, 'Client feedback', 'Please give us your valuable feedback on incident: {ticket_hash}', 'Hello {username},<br><br>We have resolved your incident, Below are details for your request.<br><br>Incident Id: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Please give us your feedback on how was your overall experience with our team while resolving your issue.<br>{link}index.php?/feedback/{useremail}/{salt}/{ticket_id}<br><br>Your feedback will help us improve our customer service.<br>', 0, 1, 22, 0, 1, 0, 1),
(23, 'New task assigned', 'New task assigned', 'Hello {first_name} {last_name}<br>New task has been assigned to you by {staff_name}<br><br><strong><strong>Following are task details :</strong><strong></strong> </strong><br>Title: {title}<br>Description: {description}<br>Status: {status}<br>Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', 0, 1, 23, 0, 1, 0, 1),
(24, 'New comment added to task', 'New comment added to task : {title}', 'Hello {first_name} {last_name},<br> New comment added to task by {staff_name}<br><br><strong>Task comment details : </strong><br>Title: {title}<br>Comment: {comment}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', 0, 1, 24, 0, 1, 0, 1),
(25, 'New forum topic', 'New forum topic added :{topic_title}', 'Hello {username},<br><br>New forum topic added <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}]<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please follow below link </strong>:<br>{topic_link}', 0, 1, 25, 0, 1, 0, 1),
(26, 'New reply for forum topic', 'New forum topic comment added : {topic_title}', 'Hello {username},<br><br>New forum topic added <strong>{topic_title}</strong> in [{domain} > {forum_category} > {forum_title}]<br><strong>Created by</strong> : {poster_name}<br><strong>Details</strong>:<br>{details}<br><br>Please follow below link<br>{topic_link}', 0, 1, 26, 0, 1, 0, 1),
(27, 'Forum topic approved', 'Forum topic approved :{topic_title}', '<p>Hello {username},</p><p><br>Forum topic <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}] is approved<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please visit below link </strong>:<br>{topic_link}</p>', 0, 1, 27, 0, 1, 0, 1),
(28, 'Topic comment approved', 'Forum topic comment approved', '<p>Hello {username},</p><p><br>Forum topic <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}] comment is approved<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please visit below link </strong>:<br>{topic_link}</p>', 0, 1, 28, 0, 1, 0, 1),
(29, 'Report download', ' Helpdesk report - {report_title}', '<p>Report available for download .<br><a href="{download_report_link}">{download_report_link}</a><br><br></p>', 0, 1, 29, 0, 1, 0, 1),
(30, 'Task overdue reminder', 'Task overdue reminder', 'Hello,<br>Task created by you or assigned to you will be overdue in next 24 hour.<br><br><strong><strong>Task details :</strong><strong></strong> </strong><br>Task title: {title}<br>Task Description: {description}<br>Task Status: {status}<br>Task Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please visit below link to view more details<br>{view_task_link}<br><br><br>', 0, 1, 30, 0, 1, 0, 1),
(31, 'Task overdue', 'Task overdue', 'Hello,<br>Task created by you or assigned to you is overdue today.<br><br><strong><strong>Overdue task details :</strong><strong></strong> </strong><br>Task title: {title}<br>Task description: {description}<br>Task status: {status}<br>Task priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please visit below link to view more details<br>{view_task_link}<br><br>', 0, 1, 31, 0, 1, 0, 1),
(32, 'Task status changed', 'Task status changed', 'Hello {first_name} {last_name},<br>Task status changed by {staff_name}<br><br>Following are task details : <br>Title: {title}<br>Description: {description}<br>Status: {status}<br>Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', 0, 1, 32, 0, 1, 0, 1),
(33, 'Incident approval', 'Approval request for incident ', 'Hello {first_name} {last_name},<br><br>Approval request for incident {ticket_hash} {subject} is waiting for your approval. <br>Please visit <a href="{ticket_approval_link}">{ticket_approval_link}</a> and confirm your approval.', 0, 1, 33, 0, 1, 0, 1),
(34, 'staff_devices', 'Staff_devices_information', '<p>Hello {first_name} {last_name},<br>New sign_in from {browser} on {os} <br>Device: {device}<br><br>Os: {os}<br><br>Browser: {browser}<br><br>IP: {ip}</p>', 0, 1, 34, 0, 1, 0, 1),
(35, 'ITIL automation template for problem', '[{problem_hash}]: {subject}', 'Alert : {alert}<br>Hash: {problem_hash}<br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Impact : {impact}<br>', 0, 1, 35, 1, 1, 0, 1),
(36, 'ITIL automation template for change', '[{changes_hash}]: {subject}', 'Alert : {alert}<br>Hash: {changes_hash}<br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Impact : {impact}<br>Risk : {risk}<br>Type : {change_type}<br><br>', 0, 1, 36, 1, 1, 0, 1),
(37, 'ITIL automation template for release', '[{release_hash}]: {subject}', 'Alert : {alert}<br>Hash: {release_hash}<br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Type : {release_type}<br><br>', 0, 1, 37, 1, 1, 0, 1),
(38, 'Incident approval accept', 'Approval request accept', 'Hello {first_name} {last_name},<br><br>Approval request accepted  ', 0, 1, 38, 0, 1, 0, 1),
(39, 'Incident approval rejected', 'Approval request rejected', 'Hello {first_name} {last_name},<br><br>Requested by : {requested_by}<br><br>Rejected by : {rejected_by}<br><br>Reason for rejection  : {rejected_comment}<br><br>Your request for approval has been rejected ', 0, 1, 39, 0, 1, 0, 1),
(40, 'Asset expired', '[{name}]: expired', '<p>Asset {name} expired on {expiry_date}.</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href="{asset_link}">click here</a></p>', 0, 1, 40, 0, 1, 0, 1),
(41, 'Asset added/updated', '{subject}', '<p>{subject}</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href="{asset_link}">click here</a></p>', 0, 1, 41, 0, 1, 0, 1),
(42, 'Asset tracking registration key and setup', 'Asset tracking registration key and setup', 'Hello ,<br><br>please find below registration key for your asset tracking software.<br>Registration key : {registration_key}<br><br>Below are links for downloading Asset discovery tools \r\n<br>Discovery agents :<br>{agent_links}<br><br>Asset Discovery Probe :<br>{probe_links}', 0, 1, 42, 0, 1, 0, 1),
(43, 'Data wiping requested', '[{name}]: Data wiping requested ', '<p>Asset {name} data wiping requested.</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href="{asset_link}">click here</a></p>', 0, 1, 43, 0, 1, 0, 0),
(44, 'Data wiping completed', '[{name}]: Data wiping completed ', '<p>Asset {name} data wiping completed.</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href="{asset_link}">click here</a></p>', 0, 1, 44, 0, 1, 0, 0),
(45, 'Contract renewed', 'Contract Renewed', 'Hello,<br>{contract_name}(#{contract_number}) is renewed and will  be expired on {contract_expiry}.</p>\r\n<p>Total cost - {contract_cost}</p>\r\n<p>Attached CI - {contract_assets}</p>\r\n<p>Please visit  below contract link to view more details<br><a href="{contract_link}">{contract_link}</a><br>', 0, 1, 45, 0, 1, 0, 1),
(46, 'Client Verification OTP', 'Client email verification', '<p>Hello,<br><br>This email is used for connecting to our live chat. Please verify your email address with the OTP: {emailotp}.<br><br><br></p>', 0, 1, 46, 0, 1, 0, 0),
(47, 'Asset acknowledgement', 'Asset acknowledgement [{ticket_hash}]', '<p>Hello {username},</p><p>you have assigned asset named {assetname} by our team on {assigned_date}.</p><p>please reply with acknowledgement document to this email.</p>\r\n<p>Best Regards,<br><br><br></p>', 0, 1, 47, 0, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_exotel_apps`
--

CREATE TABLE `avis_exotel_apps` (
  `exotel_id` int(11) NOT NULL AUTO_INCREMENT,
  `integration_id` int(11) DEFAULT '0',
  `app_name` varchar(255) DEFAULT NULL,
  `exophones` text,
  `app_id` int(11) DEFAULT '0',
  `department` varchar(20) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `auto_ticket` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`exotel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_exo_call_details`
--

CREATE TABLE `avis_exo_call_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api_response` text,
  `success_status` tinyint(1) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `sid` varchar(500) DEFAULT NULL,
  `domain` int(11) DEFAULT '0',
  `request_type` tinyint(1) DEFAULT '0' COMMENT '0=call, 1=sms',
  `from_no` varchar(500) DEFAULT NULL,
  `to_no` varchar(500) DEFAULT NULL,
  `auto_ticket` int(11) DEFAULT '0',
  `department` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_exportlist`
--

CREATE TABLE `avis_exportlist` (
  `export_id` int(15) NOT NULL AUTO_INCREMENT,
  `export_name` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `filter` text,
  `department_id` int(15) DEFAULT '0',
  `is_completed` int(2) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `report_time` int(15) DEFAULT '0',
  `database_name` varchar(255) DEFAULT NULL,
  `database_user` varchar(255) DEFAULT NULL,
  `database_password` varchar(255) DEFAULT NULL,
  `report_type` int(2) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `staff_email` varchar(255) DEFAULT NULL,
  `request_date` datetime DEFAULT NULL,
  `export_type` int(11) DEFAULT '0' COMMENT '1=csv,2=html,3=xls',
  `send_email` int(11) DEFAULT '0' COMMENT '1=yes,no=0',
  `email_id` varchar(100) DEFAULT NULL,
  `receive_date` int(15) DEFAULT '0',
  PRIMARY KEY (`export_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_favorite`
--

CREATE TABLE `avis_favorite` (
  `favorite_id` int(20) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `parent_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-incident,1-client',
  `owner` int(11) NOT NULL DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`favorite_id`),
  KEY `parent_id` (`parent_id`,`owner`,`parent_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_fetchmail`
--

CREATE TABLE `avis_fetchmail` (
  `fetch_id` int(15) NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fetch_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_filter`
--

CREATE TABLE `avis_filter` (
  `filter_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) DEFAULT NULL,
  `vscope` tinyint(2) DEFAULT '1',
  `display_order` int(15) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `filter` longtext,
  `concat_type` enum('and','or') DEFAULT 'and',
  `is_enabled` tinyint(1) DEFAULT '1',
  `search_trash` tinyint(1) DEFAULT '0',
  `search_spam` tinyint(1) DEFAULT '0',
  `is_report` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=39 ;

--
-- Dumping data for table `avis_filter`
--

INSERT INTO `avis_filter` VALUES
(1, 'All incidents', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(2, 'New incidents', 1, 3, 0, '', 'and', 1, 0, 0, 0),
(3, 'Overdue incidents', 1, 4, 0, '', 'and', 1, 0, 0, 0),
(4, 'Assigned incidents', 1, 5, 0, '', 'and', 1, 0, 0, 0),
(5, 'Trash', 1, 10, 0, '', 'and', 1, 1, 1, 0),
(6, 'Spam', 1, 9, 0, '', 'and', 1, 0, 1, 0),
(7, 'Drafts', 1, 8, 0, '', 'and', 1, 0, 0, 0),
(8, 'Problems', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(9, 'Open', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(10, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(11, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(12, 'Changes', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(13, 'Open', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(14, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(15, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(16, 'Releases', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(17, 'Open', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(18, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(19, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(20, 'Service request', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(21, 'Schedule incidents', 1, 6, 0, '', 'and', 1, 0, 0, 0),
(22, '30 Minutes overdue', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(23, '60 Minutes overdue', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(24, '1 Day overdue', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(25, 'Open incidents', 1, 2, 0, '', 'and', 1, 0, 0, 0),
(26, 'Critical incidents', 1, 12, 0, '', 'and', 0, 0, 0, 0),
(27, 'Unassigned incidents', 1, 13, 0, '', 'and', 0, 0, 0, 0),
(28, 'Recent replied incidents', 1, 14, 0, '', 'and', 0, 0, 0, 0),
(29, 'Recent closed incidents', 1, 15, 0, '', 'and', 0, 0, 0, 0),
(30, 'Service request new ', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(31, 'Service request overdue ', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(32, 'Service request assigned', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(33, 'Favorite ', 1, 7, 0, '', 'and', 1, 0, 0, 0),
(34, 'Archive', 1, 11, 0, '', 'and', 1, 0, 0, 0),
(35, 'All service requests', 1, 6, 0, '', 'and', 1, 0, 0, 0),
(36, 'All chats', 1, 7, 0, '', 'and', 1, 0, 0, 0),
(37, 'Recent chats', 1, 7, 0, '', 'and', 1, 0, 0, 0),
(38, 'Missed chats', 1, 7, 0, '', 'and', 1, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_filter_criteria`
--

CREATE TABLE `avis_filter_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=59 ;

--
-- Dumping data for table `avis_filter_criteria`
--

INSERT INTO `avis_filter_criteria` VALUES
(1, 1, 8, 1, '3', NULL),
(2, 2, 8, 1, '3', NULL),
(3, 2, 17, 1, 'unix_timestamp()', NULL),
(4, 2, 8, 1, '4', NULL),
(5, 3, 8, 1, '3', NULL),
(6, 3, 17, 0, 'unix_timestamp()', NULL),
(7, 4, 10, 1, 'VIS_STAFF_ID', NULL),
(8, 2, 13, 0, '1', NULL),
(9, 3, 13, 0, '1', NULL),
(10, 4, 8, 1, '3', NULL),
(11, 8, 8, 1, '3', NULL),
(12, 9, 1, 0, '1', NULL),
(13, 10, 1, 0, '3', NULL),
(14, 11, 0, 0, 'VIS_STAFF_ID', NULL),
(15, 12, 8, 1, '3', NULL),
(16, 13, 1, 0, '1', NULL),
(17, 14, 1, 0, '3', NULL),
(18, 15, 0, 0, 'VIS_STAFF_ID', NULL),
(19, 16, 8, 1, '3', NULL),
(20, 17, 1, 0, '1', NULL),
(21, 18, 1, 0, '3', NULL),
(22, 19, 0, 0, 'VIS_STAFF_ID', NULL),
(23, 20, 8, 0, '1', 'and'),
(24, 20, 24, 0, '7', 'and'),
(25, 22, 36, 1, '1800', 'and'),
(26, 23, 36, 1, '3600', 'and'),
(27, 24, 36, 1, '86400', 'and'),
(28, 25, 8, 0, '1', 'and'),
(29, 25, 0, 0, '', 'or'),
(30, 26, 9, 0, '4', 'and'),
(31, 26, 8, 1, '3', 'and'),
(32, 26, 0, 0, '', 'or'),
(33, 27, 10, 0, '0', 'and'),
(34, 27, 8, 0, '3', 'and'),
(35, 27, 0, 0, '', 'or'),
(36, 28, 28, 0, '', 'and'),
(37, 28, 0, 0, '', 'or'),
(38, 29, 8, 0, '3', 'and'),
(39, 29, 0, 0, '', 'or'),
(40, 30, 24, 0, '7', 'and'),
(41, 30, 8, 1, '3', NULL),
(42, 30, 17, 1, 'unix_timestamp()', NULL),
(43, 31, 24, 0, '7', 'and'),
(44, 31, 8, 1, '3', NULL),
(45, 31, 17, 0, 'unix_timestamp()', NULL),
(46, 32, 24, 0, '7', 'and'),
(47, 32, 10, 1, 'VIS_STAFF_ID', NULL),
(48, 3, 24, 1, '7', 'and'),
(49, 4, 24, 1, '7', 'and'),
(50, 2, 24, 1, '7', 'and'),
(51, 1, 8, 1, '4', NULL),
(52, 33, 42, 1, 'VIS_STAFF_ID', NULL),
(53, 3, 8, 1, '4', 'and'),
(54, 35, 0, 0, '', 'or'),
(55, 35, 24, 0, '7', 'and'),
(56, 36, 44, 0, '25', NULL),
(57, 37, 44, 0, '25', NULL),
(58, 38, 44, 0, '25', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `avis_formfield`
--

CREATE TABLE `avis_formfield` (
  `formfield_id` int(15) NOT NULL AUTO_INCREMENT,
  `formgroup_id` int(15) DEFAULT '0',
  `ci_type` int(4) DEFAULT '0',
  `field_type` int(4) DEFAULT '1',
  `field_group` int(15) DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `field_description` longtext,
  `display_order` int(15) DEFAULT '0',
  `default_value` varchar(255) DEFAULT NULL,
  `is_selected` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '0',
  `is_required` tinyint(1) DEFAULT '0',
  `is_staff_editable` tinyint(1) DEFAULT '0',
  `is_user_editable` tinyint(1) DEFAULT '0',
  `regular_expression` varchar(255) DEFAULT NULL,
  `is_editor` tinyint(1) DEFAULT '0' COMMENT '1=yes,0=no',
  `placeholder` varchar(200) DEFAULT NULL,
  `tooltip` varchar(500) DEFAULT NULL,
  `html_attribute` text,
  `inline` tinyint(4) DEFAULT '0' COMMENT '1=yes,0=no',
  `no_of_file` int(11) DEFAULT '0',
  PRIMARY KEY (`formfield_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_formgroup`
--

CREATE TABLE `avis_formgroup` (
  `formgroup_id` int(15) NOT NULL AUTO_INCREMENT,
  `formgroup_name` varchar(255) DEFAULT NULL,
  `form_name` varchar(500) DEFAULT NULL,
  `description` text,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `script` longtext,
  `form_type` tinyint(1) DEFAULT '0' COMMENT '1=email base,0=call base',
  `department` varchar(10) DEFAULT NULL,
  `subject` varchar(250) DEFAULT NULL,
  `captcha` tinyint(4) DEFAULT '0' COMMENT '1=yes,0=no',
  `hdformheader` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`formgroup_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_forum`
--

CREATE TABLE `avis_forum` (
  `forum_id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_cat_id` int(11) DEFAULT '0',
  `description` text,
  `creation_date` int(15) DEFAULT '0',
  `topic_access` int(4) DEFAULT '0',
  `display_status` tinyint(1) DEFAULT '0' COMMENT '0-everyone,1-logged in,2-only staff client',
  `display_order` int(15) DEFAULT '0',
  `is_topic_move` tinyint(4) DEFAULT '0' COMMENT '0 for No, 1 for Yes',
  `forum_status` tinyint(1) DEFAULT '0' COMMENT '0-Planned,1-In progress,2-Implemented,3-Solved,4-Unsolved,5-Deferred',
  PRIMARY KEY (`forum_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_forum_activity_log`
--

CREATE TABLE `avis_forum_activity_log` (
  `activity_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `parent_type` tinyint(4) DEFAULT '0' COMMENT '0 for topc, 1 for comment',
  `entry_date` int(15) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `domain_id` int(11) DEFAULT '0',
  `is_spam` tinyint(4) DEFAULT '0',
  `is_approved` tinyint(4) DEFAULT '0',
  `is_client` tinyint(4) DEFAULT '0' COMMENT '0 for staff,1 for client',
  `poster_id` int(11) DEFAULT '0',
  `topic_id` int(11) DEFAULT '0',
  PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_forum_category`
--

CREATE TABLE `avis_forum_category` (
  `forum_cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) DEFAULT '0',
  `description` text,
  `display_order` int(15) DEFAULT '0',
  `access_type` tinyint(2) DEFAULT '0' COMMENT '0 for public,1 for private',
  PRIMARY KEY (`forum_cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_forum_comment`
--

CREATE TABLE `avis_forum_comment` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) DEFAULT '0',
  `poster_id` int(11) DEFAULT '0',
  `poster_type` tinyint(1) DEFAULT '0' COMMENT '1 for client, 0 for staff',
  `content` longtext,
  `entry_date` int(15) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_forum_topic`
--

CREATE TABLE `avis_forum_topic` (
  `topic_id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) DEFAULT '0',
  `title` text,
  `topic_url` varchar(255) DEFAULT NULL,
  `description` longtext,
  `user_id` int(11) DEFAULT '0',
  `is_client` int(11) DEFAULT '0',
  `is_lock` int(11) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  `is_spam` int(11) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '0' COMMENT '0 for disapprove, 1 for approve',
  `is_sticky` tinyint(2) DEFAULT '0',
  `view_cnt` int(11) DEFAULT '0',
  PRIMARY KEY (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_forum_topic_followers`
--

CREATE TABLE `avis_forum_topic_followers` (
  `follow_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) DEFAULT '0',
  `follower_id` int(11) DEFAULT '0',
  `follower_type` tinyint(1) DEFAULT '0' COMMENT '1 for client, 0 for staff',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`follow_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_forum_topic_likes`
--

CREATE TABLE `avis_forum_topic_likes` (
  `like_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `parent_type` tinyint(4) DEFAULT '0' COMMENT '0 for topc, 1 for comment',
  `poster_id` int(11) DEFAULT '0',
  `poster_type` tinyint(1) DEFAULT '0' COMMENT '1 for client, 0 for staff',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_gateway`
--

CREATE TABLE `avis_gateway` (
  `gateway_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `field_value` text,
  `gateway_name` varchar(255) DEFAULT NULL,
  `gateway_type` tinyint(1) DEFAULT '0',
  `gateway_mode` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`gateway_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_gateway_log`
--

CREATE TABLE `avis_gateway_log` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_hash` int(15) DEFAULT '0',
  `gateway_id` tinyint(1) DEFAULT '0',
  `txn_data` text,
  `gateway_status` text,
  `entry_date` int(11) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_holiday`
--

CREATE TABLE `avis_holiday` (
  `holiday_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text,
  `holiday_date` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '0',
  `schedule_id` int(15) DEFAULT '0',
  `halfday_time` varchar(255) DEFAULT NULL,
  `timezone` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`holiday_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_integration`
--

CREATE TABLE `avis_integration` (
  `integration_id` int(15) NOT NULL AUTO_INCREMENT,
  `integration_type` int(4) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `db_name` varchar(255) DEFAULT NULL,
  `db_password` varchar(255) DEFAULT NULL,
  `db_prefix` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `billing_url` text,
  `admin_user` varchar(255) DEFAULT NULL,
  `admin_password` text,
  `api_key` varchar(255) DEFAULT NULL,
  `con_timeout` text,
  `read_timeout` text,
  `scheme` varchar(255) DEFAULT NULL,
  `rec_path` text,
  `integration_title` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`integration_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_invoice`
--

CREATE TABLE `avis_invoice` (
  `invoice_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) NOT NULL DEFAULT '0',
  `ticket_id` int(15) DEFAULT '0',
  `product_id` int(15) DEFAULT '0',
  `invoice_hash` varchar(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `due_date` int(15) DEFAULT '0',
  `paid_date` int(15) DEFAULT '0',
  `subtotal` decimal(10,2) NOT NULL DEFAULT '0.00',
  `credit` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `invoice_status` int(4) DEFAULT '0',
  `is_edited` tinyint(1) DEFAULT '0',
  `balance` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_id` int(15) NOT NULL DEFAULT '0',
  `product_status` int(4) NOT NULL DEFAULT '2',
  PRIMARY KEY (`invoice_id`),
  KEY `client_id` (`client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_invoice_detail`
--

CREATE TABLE `avis_invoice_detail` (
  `invoice_detail_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `tax` tinyint(1) DEFAULT '0',
  `description` text,
  `amount` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`invoice_detail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_invoice_tax_mapping`
--

CREATE TABLE `avis_invoice_tax_mapping` (
  `invoice_tax_map_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(15) DEFAULT '0',
  `invoice_detail_id` int(15) DEFAULT '0',
  `tax_id` int(15) DEFAULT '0',
  `tax_status` int(15) DEFAULT '0',
  PRIMARY KEY (`invoice_tax_map_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_assetdept`
--

CREATE TABLE `avis_itil_assetdept` (
  `assetdept_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`assetdept_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_itil_assetdept`
--

INSERT INTO `avis_itil_assetdept` VALUES
(1, 'General', 'General department', 1, 0, 0, 1, '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_asset_attributes`
--

CREATE TABLE `avis_itil_asset_attributes` (
  `attr_id` int(15) NOT NULL AUTO_INCREMENT,
  `attribute` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `attr_type_id` int(15) NOT NULL COMMENT '0-basic info, 1- processor, 2- hd, 3- Networdadadapter, 4- IO,5-additionalattr',
  `asset_id` int(15) NOT NULL,
  `attr_type_group` int(15) NOT NULL,
  `ci_property_type` int(15) NOT NULL COMMENT '1- Hardware, 2- Software, 8- Workstation',
  `field_one` varchar(255) NOT NULL,
  `field_two` varchar(255) NOT NULL,
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_asset_attributes_archive`
--

CREATE TABLE `avis_itil_asset_attributes_archive` (
  `attr_id` int(15) NOT NULL AUTO_INCREMENT,
  `attribute` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `attr_type_id` int(15) NOT NULL COMMENT '0-basic info, 1- processor, 2- hd, 3- Networdadadapter, 4- IO,5-additionalattr',
  `asset_id` int(15) NOT NULL,
  `attr_type_group` int(15) NOT NULL,
  `ci_property_type` int(15) NOT NULL COMMENT '1- Hardware, 2- Software, 8- Workstation',
  `field_one` varchar(255) NOT NULL,
  `field_two` varchar(255) NOT NULL,
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_asset_state`
--

CREATE TABLE `avis_itil_asset_state` (
  `asset_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`asset_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `avis_itil_asset_state`
--

INSERT INTO `avis_itil_asset_state` VALUES
(1, 'In use', 1, 0, 1, 1, '#FF9911', '0'),
(2, 'Missing', 1, 0, 4, 1, '#FFA500', '0'),
(3, 'In Transit', 1, 0, 2, 1, '#808080', '0'),
(4, 'In stock', 1, 0, 3, 1, '#008000', '0'),
(5, 'Retired', 1, 0, 5, 1, '#FF0000', '0'),
(6, 'Closed', 1, 0, 5, 1, '#0000FF', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_assignment`
--

CREATE TABLE `avis_itil_assignment` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `module` int(5) NOT NULL COMMENT '1-change,2-problem,3-release',
  `role` int(5) NOT NULL COMMENT '1-implementor,2-coordinator,3-manager,4-approver,5-tester,6-CAB,7-releasemanager,8-resourcemngr,9-deliverymngr,10-riskmngr,11-ROI,12-problemmngr,13-approvedby,14-supervisor',
  `ticket_id` int(15) NOT NULL,
  `owner_id` int(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_attach_relationships`
--

CREATE TABLE `avis_itil_attach_relationships` (
  `attach_id` int(11) NOT NULL AUTO_INCREMENT,
  `relation_id` int(11) DEFAULT '0',
  `assets_id` int(11) DEFAULT '0',
  `ci_id` int(11) DEFAULT '0',
  `relation_type` int(11) DEFAULT '0' COMMENT '0-forward,1-reverse',
  PRIMARY KEY (`attach_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_auditlog`
--

CREATE TABLE `avis_itil_auditlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `log_subject` varchar(255) DEFAULT NULL,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `workflow_id` int(11) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` text,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-cmdb, 2-changes,3- problems',
  `new_log` int(2) DEFAULT '1',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_auditlog_archive`
--

CREATE TABLE `avis_itil_auditlog_archive` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `log_subject` varchar(255) DEFAULT NULL,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `workflow_id` int(11) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` text,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-cmdb, 2-changes,3- problems',
  `new_log` int(2) DEFAULT '1',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_automation`
--

CREATE TABLE `avis_itil_automation` (
  `itilflow_id` int(15) NOT NULL AUTO_INCREMENT,
  `autotask_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `event` varchar(255) DEFAULT NULL,
  `product_id` int(11) NOT NULL,
  PRIMARY KEY (`itilflow_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_automation_action`
--

CREATE TABLE `avis_itil_automation_action` (
  `waction_id` int(15) NOT NULL AUTO_INCREMENT,
  `itilflow_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text,
  PRIMARY KEY (`waction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_automation_criteria`
--

CREATE TABLE `avis_itil_automation_criteria` (
  `wcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `itilflow_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`wcriteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_changes`
--

CREATE TABLE `avis_itil_changes` (
  `changes_id` int(15) NOT NULL AUTO_INCREMENT,
  `changes_from` varchar(255) DEFAULT NULL,
  `changes_hash` varchar(250) DEFAULT NULL,
  `subject` text,
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `change_type_id` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `description` longtext,
  `assets_ci_id` varchar(500) DEFAULT NULL,
  `attachment_id` varchar(255) DEFAULT NULL,
  `domain_id` int(20) DEFAULT '0',
  `is_enabled` tinyint(2) DEFAULT '0',
  `reason` text,
  `reasons_attachment` varchar(555) DEFAULT NULL,
  `impact_planning` text,
  `impact_attachment` varchar(555) DEFAULT NULL,
  `rollout` text,
  `rollout_attachment` varchar(555) DEFAULT NULL,
  `backout` text,
  `backout_attachment` varchar(555) DEFAULT NULL,
  `category_id` int(11) DEFAULT '0',
  `subcategory_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `urgency_id` int(11) NOT NULL DEFAULT '0',
  `proposed_plan` text,
  `business_justification` text,
  `current_step` int(10) NOT NULL DEFAULT '1',
  `is_desc_clear` tinyint(2) NOT NULL DEFAULT '0',
  `review_details` text,
  `change_review_status` varchar(255) NOT NULL DEFAULT '',
  `is_request_valid` tinyint(2) NOT NULL DEFAULT '0',
  `highlevelplan` text,
  `technicalplan` text,
  `resourceplan` text,
  `testplan` text,
  `testplan_attachment` varchar(555) DEFAULT NULL,
  `commplan` text,
  `acceptcanceplan` text,
  `monitorplan` text,
  `coordinatebuild` tinyint(2) NOT NULL DEFAULT '0',
  `buildactivity` tinyint(2) NOT NULL DEFAULT '0',
  `coordicatetest` tinyint(2) NOT NULL DEFAULT '0',
  `testlog` text,
  `resolveddefects` tinyint(2) NOT NULL DEFAULT '0',
  `suppodoc` tinyint(2) NOT NULL DEFAULT '0',
  `risk_avoid` tinyint(2) NOT NULL DEFAULT '0',
  `mitigation` tinyint(2) NOT NULL DEFAULT '0',
  `techapproval` tinyint(2) NOT NULL DEFAULT '0',
  `techinfo` text,
  `rejectchng` tinyint(2) NOT NULL DEFAULT '0',
  `testoptions` tinyint(2) NOT NULL DEFAULT '0',
  `cancelrec` tinyint(2) NOT NULL DEFAULT '0',
  `changeassess` tinyint(2) NOT NULL DEFAULT '0',
  `approvalreview` tinyint(2) NOT NULL DEFAULT '0',
  `supportmem` tinyint(2) NOT NULL DEFAULT '0',
  `stdchangelist` tinyint(2) NOT NULL DEFAULT '0',
  `schedule` text,
  `cabactivity` tinyint(2) NOT NULL DEFAULT '0',
  `coordchange` tinyint(2) NOT NULL DEFAULT '0',
  `execimplem` tinyint(2) DEFAULT '0',
  `implementation_status` tinyint(2) DEFAULT NULL,
  `exebackout` tinyint(2) DEFAULT '0',
  `triggerconfigupdate` tinyint(2) NOT NULL DEFAULT '0',
  `triggerimplmonitoring` tinyint(2) NOT NULL DEFAULT '0',
  `evalmonitoring` text,
  `resultdoc` tinyint(2) DEFAULT '0',
  `furtherdeatils` text,
  `request_time` int(15) DEFAULT '0',
  `closing_time` int(15) DEFAULT '0',
  `build_date` int(15) NOT NULL DEFAULT '0',
  `test_date` int(15) NOT NULL DEFAULT '0',
  `imp_date` int(15) NOT NULL DEFAULT '0',
  `impschedule` int(15) NOT NULL DEFAULT '0',
  `impscheduleend` int(15) NOT NULL DEFAULT '0',
  `impscheduleinterval` tinyint(4) NOT NULL DEFAULT '0',
  `pso_planning` text,
  `pso_attachment` varchar(555) DEFAULT NULL,
  PRIMARY KEY (`changes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_changes_aprovals`
--

CREATE TABLE `avis_itil_changes_aprovals` (
  `aprovals_id` int(11) NOT NULL AUTO_INCREMENT,
  `aprovals_type` tinyint(2) DEFAULT '0' COMMENT '0-change planning, 1-release acceptance',
  `parent_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `aprovals_status` tinyint(2) DEFAULT '0' COMMENT '0-requested, 1-aproved, 2-cancelled, 3-rejected',
  `send_date` varchar(20) DEFAULT NULL,
  `status_date` varchar(20) DEFAULT NULL,
  `remark` text,
  `is_enabled` int(11) DEFAULT '0',
  `request_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  PRIMARY KEY (`aprovals_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_changes_archive`
--

CREATE TABLE `avis_itil_changes_archive` (
  `changes_id` int(15) NOT NULL AUTO_INCREMENT,
  `changes_from` varchar(255) DEFAULT NULL,
  `changes_hash` varchar(250) DEFAULT NULL,
  `subject` text,
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `change_type_id` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `description` longtext,
  `assets_ci_id` varchar(500) DEFAULT NULL,
  `attachment_id` varchar(255) DEFAULT NULL,
  `domain_id` int(20) DEFAULT '0',
  `is_enabled` tinyint(2) DEFAULT '0',
  `reason` text,
  `reasons_attachment` varchar(555) DEFAULT NULL,
  `impact_planning` text,
  `impact_attachment` varchar(555) DEFAULT NULL,
  `rollout` text,
  `rollout_attachment` varchar(555) DEFAULT NULL,
  `backout` text,
  `backout_attachment` varchar(555) DEFAULT NULL,
  `category_id` int(11) DEFAULT '0',
  `subcategory_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `urgency_id` int(11) NOT NULL DEFAULT '0',
  `proposed_plan` text,
  `business_justification` text,
  `current_step` int(10) NOT NULL DEFAULT '1',
  `is_desc_clear` tinyint(2) NOT NULL DEFAULT '0',
  `review_details` text,
  `change_review_status` varchar(255) NOT NULL DEFAULT '',
  `is_request_valid` tinyint(2) NOT NULL DEFAULT '0',
  `highlevelplan` text,
  `technicalplan` text,
  `resourceplan` text,
  `testplan` text,
  `testplan_attachment` varchar(555) DEFAULT NULL,
  `commplan` text,
  `acceptcanceplan` text,
  `monitorplan` text,
  `coordinatebuild` tinyint(2) NOT NULL DEFAULT '0',
  `buildactivity` tinyint(2) NOT NULL DEFAULT '0',
  `coordicatetest` tinyint(2) NOT NULL DEFAULT '0',
  `testlog` text,
  `resolveddefects` tinyint(2) NOT NULL DEFAULT '0',
  `suppodoc` tinyint(2) NOT NULL DEFAULT '0',
  `risk_avoid` tinyint(2) NOT NULL DEFAULT '0',
  `mitigation` tinyint(2) NOT NULL DEFAULT '0',
  `techapproval` tinyint(2) NOT NULL DEFAULT '0',
  `techinfo` text,
  `rejectchng` tinyint(2) NOT NULL DEFAULT '0',
  `testoptions` tinyint(2) NOT NULL DEFAULT '0',
  `cancelrec` tinyint(2) NOT NULL DEFAULT '0',
  `changeassess` tinyint(2) NOT NULL DEFAULT '0',
  `approvalreview` tinyint(2) NOT NULL DEFAULT '0',
  `supportmem` tinyint(2) NOT NULL DEFAULT '0',
  `stdchangelist` tinyint(2) NOT NULL DEFAULT '0',
  `schedule` text,
  `cabactivity` tinyint(2) NOT NULL DEFAULT '0',
  `coordchange` tinyint(2) NOT NULL DEFAULT '0',
  `execimplem` tinyint(2) DEFAULT '0',
  `implementation_status` tinyint(2) DEFAULT NULL,
  `exebackout` tinyint(2) DEFAULT '0',
  `triggerconfigupdate` tinyint(2) NOT NULL DEFAULT '0',
  `triggerimplmonitoring` tinyint(2) NOT NULL DEFAULT '0',
  `evalmonitoring` text,
  `resultdoc` tinyint(2) DEFAULT '0',
  `furtherdeatils` text,
  `request_time` int(15) DEFAULT '0',
  `closing_time` int(15) DEFAULT '0',
  `build_date` int(15) NOT NULL DEFAULT '0',
  `test_date` int(15) NOT NULL DEFAULT '0',
  `imp_date` int(15) NOT NULL DEFAULT '0',
  `impschedule` int(15) NOT NULL DEFAULT '0',
  `impscheduleend` int(15) NOT NULL DEFAULT '0',
  `impscheduleinterval` tinyint(4) NOT NULL DEFAULT '0',
  `pso_planning` text,
  `pso_attachment` varchar(555) DEFAULT NULL,
  PRIMARY KEY (`changes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_change_type`
--

CREATE TABLE `avis_itil_change_type` (
  `change_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`change_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_itil_change_type`
--

INSERT INTO `avis_itil_change_type` VALUES
(1, 'Minor', 1, 0, 1, 1, '#008000', '0'),
(2, 'Standard', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Major', 1, 0, 3, 1, '#FFA500', '0'),
(4, 'Emergency', 1, 0, 4, 1, '#FF0000', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_ci_product`
--

CREATE TABLE `avis_itil_ci_product` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `ci_type_id` int(11) DEFAULT '0',
  `manufacturer` varchar(50) DEFAULT NULL,
  `product_status_id` int(11) DEFAULT '0',
  `depreciation_type_id` int(11) DEFAULT '0',
  `procurement_id` int(11) DEFAULT '0',
  `description` text,
  `department_access` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_ci_product_status`
--

CREATE TABLE `avis_itil_ci_product_status` (
  `product_status_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`product_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_itil_ci_product_status`
--

INSERT INTO `avis_itil_ci_product_status` VALUES
(1, 'In Production', 1, 0, 1, 1, '#008000', '0'),
(2, 'In Pipeline', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Retired', 1, 0, 3, 1, '#FF0000', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_cmdb_assets`
--

CREATE TABLE `avis_itil_cmdb_assets` (
  `assets_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `ci_type_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `description` longtext,
  `location_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `department_access` varchar(511) DEFAULT NULL,
  `usedby` varchar(255) DEFAULT NULL,
  `assigned_on` int(20) DEFAULT '0',
  `attachment_id` varchar(255) DEFAULT NULL,
  `product_id` int(11) DEFAULT '0',
  `vendor_id` int(11) DEFAULT '0',
  `warranty_year` int(15) DEFAULT '0',
  `warranty_month` int(15) DEFAULT '0',
  `installation_date` int(15) DEFAULT '0',
  `expiry_date` int(11) DEFAULT '0',
  `assets_state` int(11) DEFAULT '0' COMMENT 'also use for licence type',
  `asset_tag` varchar(100) DEFAULT NULL COMMENT 'also use for cost',
  `licence_key` varchar(100) DEFAULT NULL COMMENT 'also use for serial number',
  `installation_path` varchar(255) DEFAULT NULL,
  `last_audit_date` int(15) DEFAULT '0',
  `salvage` varchar(50) DEFAULT NULL,
  `depreciation_type` int(11) DEFAULT '0',
  `ci_property_type` tinyint(1) DEFAULT '0' COMMENT '1-hardware,2-software',
  `is_child` int(15) NOT NULL DEFAULT '0',
  `version` varchar(55) NOT NULL DEFAULT '',
  `usefullife` int(15) DEFAULT '0',
  `usedbytype` int(2) DEFAULT '0' COMMENT '1-client 2-staff',
  `user_of` int(15) DEFAULT '0',
  `software_type` int(15) DEFAULT '0',
  `software_category` int(15) DEFAULT '0',
  `manufacturer` int(15) DEFAULT '0',
  `xmlfilename` varchar(255) NOT NULL DEFAULT '',
  `scan_request` tinyint(2) NOT NULL DEFAULT '0',
  `os_installation_date` int(15) DEFAULT '0',
  `group_id` int(15) NOT NULL DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `lifecycle_status_id` int(15) DEFAULT '0',
  `disposition_status_id` int(15) DEFAULT '0',
  `main_os` int(5) DEFAULT '0' COMMENT '1-Windows,2-Linux,3-Mac,4-Android,5-IOS',
  `storage_loc` text,
  `physical_loc` text,
  `assetdept_id` int(15) NOT NULL DEFAULT '0',
  `is_deleted` tinyint(2) NOT NULL DEFAULT '0',
  `delete_request` tinyint(2) NOT NULL DEFAULT '0',
  `data_wiping` int(5) NOT NULL DEFAULT '0' COMMENT '1-dw requested, 2- dw completed',
  `compliancereq` varchar(255) DEFAULT NULL,
  `disposalreg` varchar(255) DEFAULT NULL,
  `privacydoc` varchar(255) DEFAULT NULL,
  `unautorized` tinyint(2) NOT NULL DEFAULT '0',
  `barcodetype` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-barcode, 1- qrcode',
  `is_migrated` tinyint(2) NOT NULL DEFAULT '0',
  `migrated_from` varchar(255) NOT NULL DEFAULT '',
  `pcuser` varchar(255) DEFAULT NULL,
  `is_approve` int(2) NOT NULL DEFAULT '0',
  `acceptable` int(2) NOT NULL DEFAULT '0',
  `approved_by` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assets_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_cmdb_assets_archive`
--

CREATE TABLE `avis_itil_cmdb_assets_archive` (
  `assets_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `ci_type_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `description` longtext,
  `location_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `department_access` varchar(511) DEFAULT NULL,
  `usedby` varchar(255) DEFAULT NULL,
  `assigned_on` int(20) DEFAULT '0',
  `attachment_id` varchar(255) DEFAULT NULL,
  `product_id` int(11) DEFAULT '0',
  `vendor_id` int(11) DEFAULT '0',
  `warranty_year` int(15) DEFAULT '0',
  `warranty_month` int(15) DEFAULT '0',
  `installation_date` int(15) DEFAULT '0',
  `expiry_date` int(11) DEFAULT '0',
  `assets_state` int(11) DEFAULT '0' COMMENT 'also use for licence type',
  `asset_tag` varchar(100) DEFAULT NULL COMMENT 'also use for cost',
  `licence_key` varchar(100) DEFAULT NULL COMMENT 'also use for serial number',
  `installation_path` varchar(255) DEFAULT NULL,
  `last_audit_date` int(15) DEFAULT '0',
  `salvage` varchar(50) DEFAULT NULL,
  `depreciation_type` int(11) DEFAULT '0',
  `ci_property_type` tinyint(1) DEFAULT '0' COMMENT '1-hardware,2-software',
  `is_child` int(15) NOT NULL DEFAULT '0',
  `version` varchar(55) NOT NULL DEFAULT '',
  `usefullife` int(15) DEFAULT '0',
  `usedbytype` int(2) DEFAULT '0' COMMENT '1-client 2-staff',
  `user_of` int(15) DEFAULT '0',
  `software_type` int(15) DEFAULT '0',
  `software_category` int(15) DEFAULT '0',
  `manufacturer` int(15) DEFAULT '0',
  `xmlfilename` varchar(255) NOT NULL DEFAULT '',
  `scan_request` tinyint(2) NOT NULL DEFAULT '0',
  `os_installation_date` int(15) DEFAULT '0',
  `group_id` int(15) NOT NULL DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `lifecycle_status_id` int(15) DEFAULT '0',
  `disposition_status_id` int(15) DEFAULT '0',
  `main_os` int(5) DEFAULT '0' COMMENT '1-Windows,2-Linux,3-Mac,4-Android,5-IOS',
  `storage_loc` text,
  `physical_loc` text,
  `assetdept_id` int(15) NOT NULL DEFAULT '0',
  `is_deleted` tinyint(2) NOT NULL DEFAULT '0',
  `delete_request` tinyint(2) NOT NULL DEFAULT '0',
  `data_wiping` int(5) NOT NULL DEFAULT '0' COMMENT '1-dw requested, 2- dw completed',
  `compliancereq` varchar(255) DEFAULT NULL,
  `disposalreg` varchar(255) DEFAULT NULL,
  `privacydoc` varchar(255) DEFAULT NULL,
  `unautorized` tinyint(2) NOT NULL DEFAULT '0',
  `barcodetype` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-barcode, 1- qrcode',
  `is_migrated` tinyint(2) NOT NULL DEFAULT '0',
  `migrated_from` varchar(255) NOT NULL DEFAULT '',
  `pcuser` varchar(255) DEFAULT NULL,
  `is_approve` int(2) NOT NULL DEFAULT '0',
  `acceptable` int(2) NOT NULL DEFAULT '0',
  `approved_by` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assets_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_cmdb_contract`
--

CREATE TABLE `avis_itil_cmdb_contract` (
  `contract_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `department_id` int(20) DEFAULT '0',
  `contract_number` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0' COMMENT '0 -draft, 1-pending, 2-Active, 3-Rejected, 4-Canceled, 5-Expired',
  `product` int(11) DEFAULT '0',
  `vendor` int(11) DEFAULT '0',
  `license_count` varchar(255) DEFAULT NULL,
  `license_type` int(11) DEFAULT '0',
  `approver` int(11) DEFAULT '0',
  `cost` varchar(255) DEFAULT NULL,
  `description` longtext,
  `start_date` int(15) DEFAULT '0',
  `end_date` int(15) DEFAULT '0',
  `attach_ci` varchar(700) DEFAULT NULL,
  `attach_file` varchar(255) DEFAULT NULL,
  `if_notify_expiry` int(1) NOT NULL DEFAULT '0',
  `notify_before` varchar(50) DEFAULT NULL,
  `notify_to` varchar(255) DEFAULT NULL,
  `is_enabled` int(1) NOT NULL DEFAULT '0',
  `po_no` int(11) DEFAULT '0',
  `po_name` varchar(255) DEFAULT NULL,
  `po_date` int(15) DEFAULT '0',
  `invoice_no` varchar(15) DEFAULT '0',
  `invoice_date` int(15) DEFAULT '0',
  `total_cost` varchar(255) DEFAULT NULL,
  `po_description` varchar(255) DEFAULT NULL,
  `sw_license_type_id` int(11) DEFAULT '0',
  `license_control_id` int(11) DEFAULT '0',
  `auto_renew` int(2) NOT NULL DEFAULT '0',
  `group_id` int(11) DEFAULT '0',
  PRIMARY KEY (`contract_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_cmdb_relationships`
--

CREATE TABLE `avis_itil_cmdb_relationships` (
  `relation_id` int(11) NOT NULL AUTO_INCREMENT,
  `forward` varchar(50) DEFAULT NULL,
  `inverse` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`relation_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;

--
-- Dumping data for table `avis_itil_cmdb_relationships`
--

INSERT INTO `avis_itil_cmdb_relationships` VALUES
(1, 'depend on', 'userd by'),
(2, 'uses', 'used by'),
(3, 'send data to', 'received data from'),
(4, 'runs', 'runs on'),
(5, 'connected to', 'connected by'),
(6, 'subscribes to', 'subscribed by'),
(7, 'impacts', 'impacted by'),
(8, 'submits', 'submitted by'),
(9, 'supports', 'supported by'),
(10, 'author of', 'written by'),
(11, 'hosted on', 'hosts'),
(12, 'enables', 'is enabled by'),
(13, 'includes', 'member of'),
(14, 'contains', 'in rack'),
(15, 'located in', 'houses'),
(16, 'exchanges data with', 'exchanges data with'),
(17, 'managed by', 'manages'),
(18, 'uses', 'owned by'),
(19, 'virtualized by', 'virtualizes'),
(20, 'is edited by', 'editor'),
(21, 'backed up by', 'backed up by'),
(22, 'consists of', 'are part of');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_configuration_item`
--

CREATE TABLE `avis_itil_configuration_item` (
  `item_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `parent_id` int(15) DEFAULT '0',
  `display_order` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_access` varchar(511) DEFAULT NULL,
  `is_custom` tinyint(2) NOT NULL DEFAULT '0',
  `depreciation_type` int(11) DEFAULT '0',
  `warrenty_year` int(11) DEFAULT '5',
  `vendor` int(15) NOT NULL DEFAULT '1',
  `default_id` int(15) NOT NULL DEFAULT '0',
  `asset_type` int(15) NOT NULL DEFAULT '0',
  `category` int(15) NOT NULL DEFAULT '0',
  `tracking` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `avis_itil_configuration_item`
--

INSERT INTO `avis_itil_configuration_item` VALUES
(1, 'Services', 0, 0, 1, '0', 0, 1, 5, 1, 1, 1, 0, 1),
(2, 'Hardware', 0, 0, 1, '0', 0, 1, 5, 1, 2, 1, 0, 1),
(3, 'Software', 0, 0, 1, '0', 0, 1, 5, 1, 3, 1, 0, 1),
(4, 'Consumable', 0, 0, 1, '0', 0, 1, 5, 1, 4, 1, 0, 1),
(5, 'Network', 0, 0, 1, '0', 0, 1, 5, 1, 5, 1, 0, 1),
(6, 'Document', 0, 0, 1, '0', 0, 1, 5, 1, 6, 1, 0, 1),
(7, 'Other', 0, 0, 1, '0', 0, 1, 5, 1, 7, 1, 0, 1),
(8, 'Workstation', 0, 0, 1, '0', 0, 1, 5, 1, 8, 2, 1, 1),
(9, 'Virtual Hosts', 0, 0, 1, '0', 0, 1, 5, 1, 9, 2, 1, 1),
(10, 'Virtual Machines', 0, 0, 1, '0', 0, 1, 5, 1, 10, 2, 1, 1),
(11, 'Desktops', 8, 0, 1, '0', 0, 1, 5, 1, 11, 2, 1, 1),
(12, 'Laptops', 8, 0, 1, '0', 0, 1, 5, 1, 12, 2, 1, 1),
(13, 'Mobiles', 8, 0, 1, '0', 0, 1, 5, 1, 13, 2, 1, 1),
(14, 'Server', 8, 0, 1, '0', 0, 1, 5, 1, 14, 2, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_contract_type`
--

CREATE TABLE `avis_itil_contract_type` (
  `contract_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`contract_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_itil_contract_type`
--

INSERT INTO `avis_itil_contract_type` VALUES
(1, 'Lease', 1, 0, 1, 1, '#a13903', '0'),
(2, 'Maintenance', 1, 0, 2, 1, '#99ee00', '0'),
(3, 'Software License', 1, 0, 3, 1, '#b25d0b', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_depreciation_type`
--

CREATE TABLE `avis_itil_depreciation_type` (
  `depreciation_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`depreciation_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_itil_depreciation_type`
--

INSERT INTO `avis_itil_depreciation_type` VALUES
(1, 'SL-5', 'SL-5', 1, 0, 1, 1, '#bd1601', '0'),
(2, 'SYD-5', 'SYD-5', 1, 0, 2, 1, '#b86406', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_disposition_status`
--

CREATE TABLE `avis_itil_disposition_status` (
  `disposition_status_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`disposition_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_itil_disposition_status`
--

INSERT INTO `avis_itil_disposition_status` VALUES
(1, 'Sold', 1, 0, 1, 1, '#008000', '0', '0'),
(2, 'Donated', 1, 0, 2, 1, '#FF9911', '0', '0'),
(3, 'Lost', 1, 0, 3, 1, '#FFA500', '0', '0'),
(4, 'Destroyed', 1, 0, 4, 1, '#FF0000', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_finance_management`
--

CREATE TABLE `avis_itil_finance_management` (
  `finance_id` int(11) NOT NULL AUTO_INCREMENT,
  `finance_type_id` int(11) DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `display_order` int(11) DEFAULT '0',
  `useful_life` int(11) DEFAULT '0',
  `description` text,
  `access_type` tinyint(2) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`finance_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_itil_finance_management`
--

INSERT INTO `avis_itil_finance_management` VALUES
(1, 1, 'DT-SL', 1, 5, 'Depreciation type - Straight Line', 0, '0', 1),
(2, 2, 'DT-DB', 2, 5, 'Depreciation type - Declining Balance', 0, '0', 1),
(3, 3, 'DT-DDB', 3, 5, 'Depreciation type - Double Declining Balance', 0, '0', 1),
(4, 4, 'DT-SOD', 4, 5, 'Depreciation type - Sum Of Years Digit', 0, '0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_impact`
--

CREATE TABLE `avis_itil_impact` (
  `impact_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`impact_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_itil_impact`
--

INSERT INTO `avis_itil_impact` VALUES
(1, 'Affect business', 1, 0, 1, 1, '#008000', '0', '0', '0', '0', '0'),
(2, 'User affect ', 1, 0, 2, 1, '#FF9911', '0', '0', '0', '0', '0'),
(3, 'Affect group', 1, 0, 3, 1, '#FFA500', '0', '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_license_type`
--

CREATE TABLE `avis_itil_license_type` (
  `license_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`license_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_itil_license_type`
--

INSERT INTO `avis_itil_license_type` VALUES
(1, 'Open Source', 1, 0, 1, 1, '#008000', '0'),
(2, 'Commercial', 1, 0, 2, 1, '#FF0000', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_lifecycle_status`
--

CREATE TABLE `avis_itil_lifecycle_status` (
  `lifecycle_status_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`lifecycle_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `avis_itil_lifecycle_status`
--

INSERT INTO `avis_itil_lifecycle_status` VALUES
(1, 'Ordered', 1, 0, 1, 1, '#008000', '0', '0'),
(2, 'Received', 1, 0, 2, 1, '#FF9911', '0', '0'),
(3, 'In storage', 1, 0, 3, 1, '#FFA500', '0', '0'),
(4, 'Deployed', 1, 0, 4, 1, '#FA8072', '0', '0'),
(5, 'Retired', 1, 0, 5, 1, '#FF0000', '0', '0'),
(6, 'Disposed', 1, 0, 6, 1, '#FFD700', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_location`
--

CREATE TABLE `avis_itil_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `contact` varchar(50) DEFAULT NULL,
  `parent_id` int(11) DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text,
  `department_access` varchar(511) DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  `access_type` tinyint(2) DEFAULT '0',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_itil_location`
--

INSERT INTO `avis_itil_location` VALUES
(1, 'America', '', 0, 'example@example.com', '', '', '0', 1, 0, '0', '0', '0', '0'),
(2, 'Asia', '', 0, 'example@example.com', '', '', '0', 1, 0, '0', '0', '0', '0'),
(3, 'Australia', '', 0, 'example@example.com', '', '', '0', 1, 0, '0', '0', '0', '0'),
(4, 'Europe', '', 0, 'example@example.com', '', '', '0', 1, 0, '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_manufacturer`
--

CREATE TABLE `avis_itil_manufacturer` (
  `manufacturer_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_models`
--

CREATE TABLE `avis_itil_models` (
  `model_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`model_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_problems`
--

CREATE TABLE `avis_itil_problems` (
  `problem_id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_from` varchar(255) DEFAULT NULL,
  `problem_hash` varchar(50) DEFAULT NULL,
  `subject` varchar(555) DEFAULT NULL,
  `description` longtext,
  `status_id` int(2) DEFAULT '0' COMMENT '1-open,3-closed',
  `priority_id` int(2) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `due_by` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(20) NOT NULL DEFAULT '0',
  `staff_id` varchar(555) DEFAULT NULL,
  `attachment_id` varchar(555) DEFAULT NULL,
  `is_enabled` tinyint(2) DEFAULT '0',
  `rootcause` text,
  `rootcause_attachment` varchar(450) DEFAULT NULL,
  `impact_analysis` text,
  `impact_attachment` varchar(450) DEFAULT NULL,
  `symptoms` text,
  `symptoms_attachment` varchar(450) DEFAULT NULL,
  `permanent_id` int(11) DEFAULT '0',
  `workaround_id` int(11) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `urgency_id` int(15) DEFAULT '0',
  `request_time` int(15) DEFAULT '0',
  `request_user` text,
  `known_error` varchar(255) DEFAULT NULL,
  `workaround` text,
  `instructions` longtext,
  `identification_note` longtext,
  `stage_attachment` varchar(450) DEFAULT NULL,
  `resource_instructions` text,
  `manpower_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `total_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `hardware_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `software_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `installation_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `training_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `maintenance_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `delivery_date` int(15) DEFAULT '0',
  `risk_instruction` text,
  `downtime_start` int(15) DEFAULT '0',
  `downtime_end` int(15) DEFAULT '0',
  `downtime_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `roi_instruction` text,
  `action_instruction` text,
  `close_solution` text,
  `close_time` int(15) DEFAULT '0',
  `current_step` int(15) NOT NULL DEFAULT '0',
  `review` text,
  `review_attachment` varchar(255) DEFAULT NULL,
  `review_type` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`problem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_problems_archive`
--

CREATE TABLE `avis_itil_problems_archive` (
  `problem_id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_from` varchar(255) DEFAULT NULL,
  `problem_hash` varchar(50) DEFAULT NULL,
  `subject` varchar(555) DEFAULT NULL,
  `description` longtext,
  `status_id` int(2) DEFAULT '0' COMMENT '1-open,3-closed',
  `priority_id` int(2) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `due_by` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(20) NOT NULL DEFAULT '0',
  `staff_id` varchar(555) DEFAULT NULL,
  `attachment_id` varchar(555) DEFAULT NULL,
  `is_enabled` tinyint(2) DEFAULT '0',
  `rootcause` text,
  `rootcause_attachment` varchar(450) DEFAULT NULL,
  `impact_analysis` text,
  `impact_attachment` varchar(450) DEFAULT NULL,
  `symptoms` text,
  `symptoms_attachment` varchar(450) DEFAULT NULL,
  `permanent_id` int(11) DEFAULT '0',
  `workaround_id` int(11) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `urgency_id` int(15) DEFAULT '0',
  `request_time` int(15) DEFAULT '0',
  `request_user` text,
  `known_error` varchar(255) DEFAULT NULL,
  `workaround` text,
  `instructions` longtext,
  `identification_note` longtext,
  `stage_attachment` varchar(450) DEFAULT NULL,
  `resource_instructions` text,
  `manpower_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `total_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `hardware_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `software_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `installation_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `training_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `maintenance_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `delivery_date` int(15) DEFAULT '0',
  `risk_instruction` text,
  `downtime_start` int(15) DEFAULT '0',
  `downtime_end` int(15) DEFAULT '0',
  `downtime_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `roi_instruction` text,
  `action_instruction` text,
  `close_solution` text,
  `close_time` int(15) DEFAULT '0',
  `current_step` int(15) NOT NULL DEFAULT '0',
  `review` text,
  `review_attachment` varchar(255) DEFAULT NULL,
  `review_type` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`problem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_procurement_mode`
--

CREATE TABLE `avis_itil_procurement_mode` (
  `procurement_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`procurement_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_itil_procurement_mode`
--

INSERT INTO `avis_itil_procurement_mode` VALUES
(1, 'Buy', 1, 0, 1, 1, '#FF0000', '0'),
(2, 'Lease', 1, 0, 2, 1, '#FFA500', '0'),
(3, 'Both', 1, 0, 3, 1, '#008000', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_product_vendors`
--

CREATE TABLE `avis_itil_product_vendors` (
  `product_vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `vendor_id` int(11) DEFAULT '0',
  `product_id` int(11) DEFAULT '0',
  `price` varchar(255) DEFAULT NULL,
  `warranty_year` int(11) DEFAULT '0',
  `warranty_month` int(11) DEFAULT '0',
  `quantity` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`product_vendor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_relation`
--

CREATE TABLE `avis_itil_relation` (
  `attach_id` int(15) NOT NULL AUTO_INCREMENT,
  `attach_type` int(4) DEFAULT '0' COMMENT '0 - incident ci, 1 - incident - problem, 2 - problem change, 3 - change release, 4 - problem ci, 5 - release ci, 6 - incident change, 7-cmdb relationships, 8-problem task, 9-changes ci, 10-changes task, 11-release task,12-incident task,13-contract ci',
  `parent_id` int(4) DEFAULT '0',
  `child_id` int(11) DEFAULT '0',
  PRIMARY KEY (`attach_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='0 incident - ci' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_releases`
--

CREATE TABLE `avis_itil_releases` (
  `release_id` int(15) NOT NULL AUTO_INCREMENT,
  `release_hash` varchar(255) DEFAULT NULL,
  `release_from` int(15) DEFAULT '0',
  `subject` text,
  `description` longtext,
  `planned_start_date` int(15) DEFAULT '0',
  `planned_end_date` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `release_type_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(555) DEFAULT '0',
  `assets_id` int(15) DEFAULT '0',
  `attachment_id` varchar(525) DEFAULT NULL,
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `buildplan` text,
  `buildplan_attachment` varchar(450) DEFAULT NULL,
  `testplan` text,
  `testplan_attachment` varchar(450) DEFAULT NULL,
  `is_enabled` tinyint(2) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `risk_id` int(11) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `urgency_id` int(11) DEFAULT '0',
  `sla_id` int(11) DEFAULT '0',
  `charge_centre` int(11) DEFAULT '0',
  `request_user` text,
  `current_step` int(11) NOT NULL DEFAULT '1',
  `affect_impact` text NOT NULL,
  `changes_desc` text NOT NULL,
  `risk_details` text NOT NULL,
  `audience` varchar(255) NOT NULL,
  `dschedule_date` varchar(255) NOT NULL,
  `dschedule_desc` text NOT NULL,
  `dstrategy` text NOT NULL,
  `testing_approval` tinyint(1) NOT NULL DEFAULT '0',
  `risk_disruptions` text NOT NULL,
  `ready_deploy` tinyint(1) NOT NULL DEFAULT '0',
  `deploy_desc` text NOT NULL,
  `financial_assets` text NOT NULL,
  `processes_materials` text NOT NULL,
  `service_release_details` text NOT NULL,
  `monitor_startdate` varchar(255) NOT NULL,
  `monitor_enddate` varchar(255) NOT NULL,
  `monitor_review` text NOT NULL,
  `release_feedback` text NOT NULL,
  `conf_know` tinyint(1) NOT NULL DEFAULT '0',
  `quality_achieved` tinyint(1) NOT NULL DEFAULT '0',
  `implementation_review` text NOT NULL,
  `closing_date` varchar(255) NOT NULL,
  `rolloutplan` text NOT NULL,
  `backoutplan` text NOT NULL,
  `affectedversion` text NOT NULL,
  `releaseversion` text NOT NULL,
  `distru_tech` text NOT NULL,
  `distru_loc` text NOT NULL,
  `rolloutplan_attachment` varchar(450) DEFAULT NULL,
  `backoutplan_attachment` varchar(450) DEFAULT NULL,
  `closure_cate` int(11) NOT NULL DEFAULT '0',
  `service_trans` text NOT NULL,
  `comp_aqui` int(5) NOT NULL DEFAULT '0',
  `accept_test` int(5) NOT NULL DEFAULT '0',
  `storage_loc` text NOT NULL,
  `physical_loc` text NOT NULL,
  `dml_attachment` varchar(450) DEFAULT NULL,
  PRIMARY KEY (`release_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_releases_archive`
--

CREATE TABLE `avis_itil_releases_archive` (
  `release_id` int(15) NOT NULL AUTO_INCREMENT,
  `release_hash` varchar(255) DEFAULT NULL,
  `release_from` int(15) DEFAULT '0',
  `subject` text,
  `description` longtext,
  `planned_start_date` int(15) DEFAULT '0',
  `planned_end_date` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `release_type_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(555) DEFAULT '0',
  `assets_id` int(15) DEFAULT '0',
  `attachment_id` varchar(525) DEFAULT NULL,
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `buildplan` text,
  `buildplan_attachment` varchar(450) DEFAULT NULL,
  `testplan` text,
  `testplan_attachment` varchar(450) DEFAULT NULL,
  `is_enabled` tinyint(2) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `risk_id` int(11) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `urgency_id` int(11) DEFAULT '0',
  `sla_id` int(11) DEFAULT '0',
  `charge_centre` int(11) DEFAULT '0',
  `request_user` text,
  `current_step` int(11) NOT NULL DEFAULT '1',
  `affect_impact` text NOT NULL,
  `changes_desc` text NOT NULL,
  `risk_details` text NOT NULL,
  `audience` varchar(255) NOT NULL,
  `dschedule_date` varchar(255) NOT NULL,
  `dschedule_desc` text NOT NULL,
  `dstrategy` text NOT NULL,
  `testing_approval` tinyint(1) NOT NULL DEFAULT '0',
  `risk_disruptions` text NOT NULL,
  `ready_deploy` tinyint(1) NOT NULL DEFAULT '0',
  `deploy_desc` text NOT NULL,
  `financial_assets` text NOT NULL,
  `processes_materials` text NOT NULL,
  `service_release_details` text NOT NULL,
  `monitor_startdate` varchar(255) NOT NULL,
  `monitor_enddate` varchar(255) NOT NULL,
  `monitor_review` text NOT NULL,
  `release_feedback` text NOT NULL,
  `conf_know` tinyint(1) NOT NULL DEFAULT '0',
  `quality_achieved` tinyint(1) NOT NULL DEFAULT '0',
  `implementation_review` text NOT NULL,
  `closing_date` varchar(255) NOT NULL,
  `rolloutplan` text NOT NULL,
  `backoutplan` text NOT NULL,
  `affectedversion` text NOT NULL,
  `releaseversion` text NOT NULL,
  `distru_tech` text NOT NULL,
  `distru_loc` text NOT NULL,
  `rolloutplan_attachment` varchar(450) DEFAULT NULL,
  `backoutplan_attachment` varchar(450) DEFAULT NULL,
  `closure_cate` int(11) NOT NULL DEFAULT '0',
  `service_trans` text NOT NULL,
  `comp_aqui` int(5) NOT NULL DEFAULT '0',
  `accept_test` int(5) NOT NULL DEFAULT '0',
  `storage_loc` text NOT NULL,
  `physical_loc` text NOT NULL,
  `dml_attachment` varchar(450) DEFAULT NULL,
  PRIMARY KEY (`release_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_release_type`
--

CREATE TABLE `avis_itil_release_type` (
  `release_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`release_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_itil_release_type`
--

INSERT INTO `avis_itil_release_type` VALUES
(1, 'Minor', 1, 0, 1, 1, '#008000', '0'),
(2, 'Standard', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Major', 1, 0, 3, 1, '#FFA500', '0'),
(4, 'Emergency', 1, 0, 4, 1, '#FF0000', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_report`
--

CREATE TABLE `avis_itil_report` (
  `report_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `filter` text NOT NULL,
  `is_report` tinyint(2) NOT NULL,
  `staff_id` int(15) NOT NULL,
  `created_date` varchar(255) NOT NULL,
  `from_date` varchar(255) NOT NULL,
  `to_date` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `priority` varchar(255) NOT NULL,
  `impact` varchar(255) NOT NULL,
  `category` varchar(255) NOT NULL,
  `subcategory` varchar(255) NOT NULL,
  `item` varchar(255) NOT NULL,
  `changetype` varchar(255) NOT NULL,
  `risk` varchar(255) NOT NULL,
  `urgency` int(255) NOT NULL,
  `releasetype` int(255) NOT NULL,
  `location` varchar(255) NOT NULL,
  `filter_id` int(15) NOT NULL,
  `vis_main_search` int(15) NOT NULL,
  `domain_id` int(15) NOT NULL,
  `knownerror` varchar(255) NOT NULL,
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_request_stage`
--

CREATE TABLE `avis_itil_request_stage` (
  `request_stage_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`request_stage_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_itil_request_stage`
--

INSERT INTO `avis_itil_request_stage` VALUES
(1, 'New', 'New', 1, 0, 1, 1, '#008000', '0'),
(2, 'In progress', 'In progress', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Completed', 'Completed', 1, 0, 3, 1, '#FF0000', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_risk`
--

CREATE TABLE `avis_itil_risk` (
  `risk_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`risk_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_itil_risk`
--

INSERT INTO `avis_itil_risk` VALUES
(1, 'Low', 1, 0, 1, 1, '#008000', '0', '0', '0', '0'),
(2, 'Medium', 1, 0, 2, 1, '#FF9911', '0', '0', '0', '0'),
(3, 'High', 1, 0, 3, 1, '#FFA500', '0', '0', '0', '0'),
(4, 'Very high', 1, 0, 4, 1, '#FF0000', '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_service_category`
--

CREATE TABLE `avis_itil_service_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `description` text,
  `domain_id` int(11) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `avis_itil_service_category`
--

INSERT INTO `avis_itil_service_category` VALUES
(1, 'Hardware', 'hardware appliances', 0, 0, 1),
(2, 'Software', 'software appliances', 0, 0, 1),
(3, 'User management', 'user management', 0, 0, 1),
(4, 'Data service', 'data service', 0, 0, 1),
(5, 'Application access', 'application access', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_service_item`
--

CREATE TABLE `avis_itil_service_item` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `category_id` int(11) DEFAULT '0',
  `item_department_id` int(11) DEFAULT '0',
  `ci_product_id` int(11) DEFAULT '0',
  `description` text,
  `display_order` int(11) DEFAULT '0',
  `cost` varchar(50) DEFAULT NULL,
  `estimated_delivery` varchar(50) DEFAULT NULL,
  `estimated_delivery_hrs` int(2) NOT NULL DEFAULT '0',
  `cost_status` tinyint(1) NOT NULL DEFAULT '0',
  `estimate_status` tinyint(1) NOT NULL DEFAULT '0',
  `quantity_status` tinyint(1) NOT NULL DEFAULT '0',
  `item_image` text,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_id` int(11) NOT NULL DEFAULT '0',
  `ledger_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_service_ticket`
--

CREATE TABLE `avis_itil_service_ticket` (
  `service_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_item_id` int(11) DEFAULT '0',
  `ticket_id` int(11) DEFAULT '0',
  `quantity` varchar(20) DEFAULT NULL,
  `total_cost` varchar(50) DEFAULT NULL,
  `install_details` text NOT NULL,
  `move_details` text NOT NULL,
  `add_details` text NOT NULL,
  `change_details` text NOT NULL,
  `install_status` int(15) NOT NULL DEFAULT '0',
  `move_status` int(15) NOT NULL DEFAULT '0',
  `add_status` int(15) NOT NULL DEFAULT '0',
  `change_status` int(15) NOT NULL DEFAULT '0',
  `lifecycle_stage` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`service_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_service_ticket_archive`
--

CREATE TABLE `avis_itil_service_ticket_archive` (
  `service_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_item_id` int(11) DEFAULT '0',
  `ticket_id` int(11) DEFAULT '0',
  `quantity` varchar(20) DEFAULT NULL,
  `total_cost` varchar(50) DEFAULT NULL,
  `install_details` text NOT NULL,
  `move_details` text NOT NULL,
  `add_details` text NOT NULL,
  `change_details` text NOT NULL,
  `install_status` int(15) NOT NULL DEFAULT '0',
  `move_status` int(15) NOT NULL DEFAULT '0',
  `add_status` int(15) NOT NULL DEFAULT '0',
  `change_status` int(15) NOT NULL DEFAULT '0',
  `lifecycle_stage` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`service_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_software_category`
--

CREATE TABLE `avis_itil_software_category` (
  `software_cat_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`software_cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_software_license_type`
--

CREATE TABLE `avis_itil_software_license_type` (
  `sw_license_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`sw_license_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `avis_itil_software_license_type`
--

INSERT INTO `avis_itil_software_license_type` VALUES
(1, 'Enterprise', 1, 0, 1, 1, '#008000', '0', '0'),
(2, 'Network', 1, 0, 2, 1, '#FF9911', '0', '0'),
(3, 'Named', 1, 0, 3, 1, '#FFA500', '0', '0'),
(4, 'Concurrent', 1, 0, 4, 1, '#FF0000', '0', '0'),
(5, 'Subscription', 1, 0, 5, 1, '#FFD700', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_software_type`
--

CREATE TABLE `avis_itil_software_type` (
  `software_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`software_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_swlicense_control`
--

CREATE TABLE `avis_itil_swlicense_control` (
  `license_control_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`license_control_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `avis_itil_swlicense_control`
--

INSERT INTO `avis_itil_swlicense_control` VALUES
(1, 'Available for distribution', 1, 0, 1, 1, '#008000', '0', '0'),
(2, 'Distributed and consumed', 1, 0, 2, 1, '#FF9911', '0', '0'),
(3, 'Harvested for re-use', 1, 0, 3, 1, '#FFA500', '0', '0'),
(4, 'Re-allocated', 1, 0, 4, 1, '#FF0000', '0', '0'),
(5, 'End-of-license removal', 1, 0, 5, 1, '#FFD700', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_itil_vendor`
--

CREATE TABLE `avis_itil_vendor` (
  `vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `primary_contact` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `description` text,
  `address` text,
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `department_access` varchar(511) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`vendor_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_itil_vendor`
--

INSERT INTO `avis_itil_vendor` VALUES
(1, 'Default', NULL, NULL, NULL, NULL, 0, '0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_keywords`
--

CREATE TABLE `avis_keywords` (
  `kw_id` int(15) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(255) DEFAULT NULL,
  `entry_from` tinyint(5) DEFAULT '0' COMMENT '0-manual,1-VA',
  `va_id` int(15) DEFAULT '0',
  `article_ids` varchar(255) DEFAULT NULL,
  `domain_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`kw_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_label`
--

CREATE TABLE `avis_label` (
  `label_id` int(15) NOT NULL AUTO_INCREMENT,
  `label_name` varchar(255) DEFAULT NULL,
  `staff_id` int(4) DEFAULT '0',
  `group_type` int(4) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `label_color` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `department_access` varchar(511) DEFAULT '0',
  `visible_to_leftpanel` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`label_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_label`
--

INSERT INTO `avis_label` VALUES
(1, 'Important', 1, 0, 1426598374, 1, '#e33244', 1, '0', 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_label_data`
--

CREATE TABLE `avis_label_data` (
  `parent_id` int(4) DEFAULT '0',
  `label_id` int(15) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `avis_language`
--

CREATE TABLE `avis_language` (
  `language_id` int(15) NOT NULL AUTO_INCREMENT,
  `language_name` varchar(255) DEFAULT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(1) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `language_code` varchar(15) DEFAULT NULL,
  `char_set` varchar(15) DEFAULT NULL,
  `direction` tinyint(1) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `chataccess` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `avis_language`
--

INSERT INTO `avis_language` VALUES
(1, 'English', '', 1, 0, 1, 'english.php', 'en', 'utf8', 0, 0, 1),
(2, 'Dutch', '', 0, 0, 2, 'dutch.php', 'nl', 'utf8', 0, 1, 0),
(3, 'French', '', 0, 0, 3, 'french.php', 'fr', 'utf8', 0, 1, 0),
(4, 'German', '', 0, 0, 4, 'german.php', 'de', 'utf8', 0, 1, 0),
(5, 'Russian', '', 0, 0, 5, 'russian.php', 'ru', 'utf8', 0, 1, 0),
(6, 'Spanish', '', 0, 0, 6, 'spanish.php', 'es', 'utf8', 0, 1, 0),
(7, 'Swedish', '', 0, 0, 7, 'swedish.php', 'se', 'utf8', 0, 1, 0),
(8, 'Turkish', '', 0, 0, 8, 'turkish.php', 'tr', 'utf8', 0, 1, 0),
(9, 'Italian', '', 0, 0, 9, 'italian.php', 'it', 'utf8', 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_language_data`
--

CREATE TABLE `avis_language_data` (
  `language_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `location` int(4) NOT NULL DEFAULT '0',
  `title` text,
  `language_id` int(15) DEFAULT '0',
  `data_id` int(15) DEFAULT '0',
  PRIMARY KEY (`language_data_id`),
  KEY `location` (`location`,`language_id`,`data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1099 ;

--
-- Dumping data for table `avis_language_data`
--

INSERT INTO `avis_language_data` VALUES
(1, 0, 'Open', 1, 1),
(2, 0, 'Awaiting', 1, 2),
(3, 0, 'Closed', 1, 3),
(4, 0, 'Resolved', 1, 4),
(5, 0, 'Open', 2, 1),
(6, 0, 'In afwachting', 2, 2),
(7, 0, 'Gesloten', 2, 3),
(8, 0, 'Ouvert', 3, 1),
(9, 0, 'En attente', 3, 2),
(10, 0, 'FermÃ©', 3, 3),
(11, 0, 'GeÃ¶ffnet', 4, 1),
(12, 0, 'Erwartung', 4, 2),
(13, 0, 'Geschlossen', 4, 3),
(14, 0, 'Ð¾Ñ‚ÐºÑ€Ñ‹Ñ‚Ð¾', 5, 1),
(15, 0, 'Ð² Ð¾Ð¶Ð¸Ð´Ð°Ð½Ð¸Ð¸', 5, 2),
(16, 0, 'Ð·Ð°ÐºÑ€Ñ‹Ñ‚Ð¾', 5, 3),
(17, 0, 'abierto', 6, 1),
(18, 0, 'En espera', 6, 2),
(19, 0, 'cerrado', 6, 3),
(20, 0, 'Ã¶ppen', 7, 1),
(21, 0, 'VÃ¤ntar', 7, 2),
(22, 0, 'stÃ¤ngt', 7, 3),
(23, 0, 'aÃ§Ä±k', 8, 1),
(24, 0, 'Bekleniyor', 8, 2),
(25, 0, 'kapalÄ±', 8, 3),
(26, 0, 'aperto', 9, 1),
(27, 0, 'In attesa', 9, 2),
(28, 0, 'chiuso', 9, 3),
(29, 1, 'Low', 1, 1),
(30, 1, 'Medium', 1, 2),
(31, 1, 'High', 1, 3),
(32, 1, 'Critical', 1, 4),
(33, 1, 'Laag', 2, 1),
(34, 1, 'Medium', 2, 2),
(35, 1, 'hoog', 2, 3),
(36, 1, 'kritisch', 2, 4),
(37, 1, 'Faible', 3, 1),
(38, 1, 'Moyen', 3, 2),
(39, 1, 'Haute', 3, 3),
(40, 1, 'Critique', 3, 4),
(41, 1, 'Niedrig', 4, 1),
(42, 1, 'Mittel', 4, 2),
(43, 1, 'Hoch', 4, 3),
(44, 1, 'Kritisch', 4, 4),
(45, 1, 'Ð½Ð¸Ð·ÐºÐ¸Ð¹', 5, 1),
(46, 1, 'Ð¡Ñ€ÐµÐ´Ð½ÑÑ', 5, 2),
(47, 1, 'Ð’Ñ‹ÑÐ¾ÐºÐ¾', 5, 3),
(48, 1, 'ÐºÑ€Ð¸Ñ‚Ð¸Ñ‡ÐµÑÐºÐ¸Ð¹', 5, 4),
(49, 1, 'bajo', 6, 1),
(50, 1, 'Medio', 6, 2),
(51, 1, 'Alto', 6, 3),
(52, 1, 'CrÃ­tico', 6, 4),
(53, 1, 'lÃ¥g', 7, 1),
(54, 1, 'Medium', 7, 2),
(55, 1, 'HÃ¶g', 7, 3),
(56, 1, 'Kritisk', 7, 4),
(57, 1, 'dÃ¼ÅŸÃ¼k', 8, 1),
(58, 1, 'Orta', 8, 2),
(59, 1, 'YÃ¼ksek', 8, 3),
(60, 1, 'kritik', 8, 4),
(61, 1, 'basso', 9, 1),
(62, 1, 'medio', 9, 2),
(63, 1, 'alto', 9, 3),
(64, 1, 'critico', 9, 4),
(65, 2, 'Issue', 1, 1),
(66, 2, 'Question', 1, 2),
(67, 2, 'Bug', 1, 3),
(68, 2, 'Probleem', 2, 1),
(69, 2, 'Vraag', 2, 2),
(70, 2, 'Kever', 2, 3),
(71, 2, 'Question', 3, 1),
(72, 2, 'Question', 3, 2),
(73, 2, 'Insecte', 3, 3),
(74, 2, 'Ausgabe', 4, 1),
(75, 2, 'Frage', 4, 2),
(76, 2, 'Fehler', 4, 3),
(77, 2, 'Ð¿Ñ€Ð¾Ð±Ð»ÐµÐ¼Ð°', 5, 1),
(78, 2, 'Ð²Ð¾Ð¿Ñ€Ð¾Ñ¿', 5, 2),
(79, 2, 'Ð¾ÑˆÐ¸Ð±ÐºÐ°', 5, 3),
(80, 2, 'cuestiÃ³n', 6, 1),
(81, 2, 'pregunta', 6, 2),
(82, 2, 'Bug', 6, 3),
(83, 2, 'Problem', 7, 1),
(84, 2, 'frÃ¥ga', 7, 2),
(85, 2, 'Bug', 7, 3),
(86, 2, 'konu', 8, 1),
(87, 2, 'soru', 8, 2),
(88, 2, 'bÃ¶cek', 8, 3),
(89, 2, 'problema', 9, 1),
(90, 2, 'domanda', 9, 2),
(91, 2, 'insetto', 9, 3),
(92, 3, 'White', 1, 1),
(93, 3, 'Red', 1, 3),
(94, 3, 'Green', 1, 2),
(95, 3, 'Wit', 2, 1),
(96, 3, 'Rood', 2, 3),
(97, 3, 'Groen', 2, 2),
(98, 3, 'Blanc', 3, 1),
(99, 3, 'Rouge', 3, 3),
(100, 3, 'Vert', 3, 2),
(101, 3, 'WeiÃŸ', 4, 1),
(102, 3, 'Rote', 4, 3),
(103, 3, 'GrÃ¼n', 4, 2),
(104, 3, 'Ð±ÐµÐ»Ñ‹Ð¹', 5, 1),
(105, 3, 'ÐºÑ€Ð°Ñ¿Ð½Ñ‹Ð¹', 5, 3),
(106, 3, 'Ð·ÐµÐ»ÐµÐ½Ñ‹Ð¹', 5, 2),
(107, 3, 'blanco', 6, 1),
(108, 3, 'rojo', 6, 3),
(109, 3, 'verde', 6, 2),
(110, 3, 'vit', 7, 1),
(111, 3, 'rÃ¶d', 7, 3),
(112, 3, 'grÃ¶n', 7, 2),
(113, 3, 'beyaz', 8, 1),
(114, 3, 'kÄ±rmÄ±zÄ±', 8, 3),
(115, 3, 'yeÅŸil', 8, 2),
(116, 3, 'bianco', 9, 1),
(117, 3, 'rosso', 9, 3),
(118, 3, 'verde', 9, 2),
(119, 5, 'Services', 1, 1),
(120, 5, 'Diensten', 2, 1),
(121, 5, 'Services', 3, 1),
(122, 5, 'Dienstleistungen', 4, 1),
(123, 5, 'Ð£ï¿½?Ð»ÑƒÐ³Ð¸', 5, 1),
(124, 5, 'Servicios', 6, 1),
(125, 5, 'TjÃ¤nster', 7, 1),
(126, 5, 'Hizmetler', 8, 1),
(127, 5, 'Servizi', 9, 1),
(128, 5, 'Hardware', 1, 2),
(129, 5, 'Hardware', 2, 2),
(130, 5, 'MatÃ©riel', 3, 2),
(131, 5, 'Hardware', 4, 2),
(132, 5, 'ï¿½?Ð¿Ð¿Ð°Ñ€Ð°Ñ‚Ð½Ñ‹Ð¹', 5, 2),
(133, 5, 'Hardware', 6, 2),
(134, 5, 'HÃ¥rdvara', 7, 2),
(135, 5, 'DonanÄ±m', 8, 2),
(136, 5, 'Hardware', 9, 2),
(137, 5, 'Software', 1, 3),
(138, 5, 'Software', 2, 3),
(139, 5, 'Logiciel', 3, 3),
(140, 5, 'Software', 4, 3),
(141, 5, 'ÐŸÑ€Ð¾Ð³Ñ€Ð°Ð¼Ð¼Ð½Ð¾Ðµ Ð¾Ð±Ðµï¿½?Ð¿ÐµÑ‡ÐµÐ½Ð¸Ðµ', 5, 3),
(142, 5, 'Software', 6, 3),
(143, 5, 'Programvara', 7, 3),
(144, 5, 'YazÄ±lÄ±m', 8, 3),
(145, 5, 'Software', 9, 3),
(146, 5, 'Consumable', 1, 4),
(147, 5, 'Verbruiksartikelen', 2, 4),
(148, 5, 'Consommable', 3, 4),
(149, 5, 'Verbrauchsgut', 4, 4),
(150, 5, 'ÐŸÐ¾Ñ‚Ñ€ÐµÐ±Ð»ï¿½?ÐµÐ¼Ñ‹Ð¹', 5, 4),
(151, 5, 'Consumible', 6, 4),
(152, 5, 'FÃ¶rbrukningsartikel', 7, 4),
(153, 5, 'TÃ¼ketilir', 8, 4),
(154, 5, 'Consumabili', 9, 4),
(155, 5, 'Network', 1, 5),
(156, 5, 'Netwerk', 2, 5),
(157, 5, 'RÃ©seau', 3, 5),
(158, 5, 'Netzwerk', 4, 5),
(159, 5, 'Ð¡ÐµÑ‚ÑŒ', 5, 5),
(160, 5, 'Red', 6, 5),
(161, 5, 'NÃ¤tverk', 7, 5),
(162, 5, 'ÅŸebeke', 8, 5),
(163, 5, 'Rete', 9, 5),
(164, 5, 'Document', 1, 6),
(165, 5, 'Document', 2, 6),
(166, 5, 'Document', 3, 6),
(167, 5, 'Dokument', 4, 6),
(168, 5, 'Ð”Ð¾ÐºÑƒÐ¼ÐµÐ½Ñ‚', 5, 6),
(169, 5, 'Documento', 6, 6),
(170, 5, 'Dokument', 7, 6),
(171, 5, 'Belge', 8, 6),
(172, 5, 'Documento', 9, 6),
(173, 5, 'Other', 1, 7),
(174, 5, 'Ander', 2, 7),
(175, 5, 'Autre', 3, 7),
(176, 5, 'Andere', 4, 7),
(177, 5, 'Ð”Ñ€ÑƒÐ³Ð¾Ð¹', 5, 7),
(178, 5, 'Otro', 6, 7),
(179, 5, 'Annat', 7, 7),
(180, 5, 'DiÄŸer', 8, 7),
(181, 5, 'Altro', 9, 7),
(182, 5, 'Workstation', 1, 8),
(183, 5, 'Workstation', 2, 8),
(184, 5, 'Workstation', 3, 8),
(185, 5, 'Workstation', 4, 8),
(186, 5, 'Workstation', 5, 8),
(187, 5, 'Workstation', 6, 8),
(188, 5, 'Workstation', 7, 8),
(189, 5, 'Workstation', 8, 8),
(190, 5, 'Workstation', 9, 8),
(191, 5, 'Virtual Hosts', 1, 9),
(192, 5, 'Virtual Hosts', 2, 9),
(193, 5, 'Virtual Hosts', 3, 9),
(194, 5, 'Virtual Hosts', 4, 9),
(195, 5, 'Virtual Hosts', 5, 9),
(196, 5, 'Virtual Hosts', 6, 9),
(197, 5, 'Virtual Hosts', 7, 9),
(198, 5, 'Virtual Hosts', 8, 9),
(199, 5, 'Virtual Hosts', 9, 9),
(200, 5, 'Virtual Machines', 1, 10),
(201, 5, 'Virtual Machines', 2, 10),
(202, 5, 'Virtual Machines', 3, 10),
(203, 5, 'Virtual Machines', 4, 10),
(204, 5, 'Virtual Machines', 5, 10),
(205, 5, 'Virtual Machines', 6, 10),
(206, 5, 'Virtual Machines', 7, 10),
(207, 5, 'Virtual Machines', 8, 10),
(208, 5, 'Virtual Machines', 9, 10),
(209, 5, 'Desktops', 1, 11),
(210, 5, 'Desktops', 2, 11),
(211, 5, 'Desktops', 3, 11),
(212, 5, 'Desktops', 4, 11),
(213, 5, 'Desktops', 5, 11),
(214, 5, 'Desktops', 6, 11),
(215, 5, 'Desktops', 7, 11),
(216, 5, 'Desktops', 8, 11),
(217, 5, 'Desktops', 9, 11),
(218, 5, 'Laptops', 1, 12),
(219, 5, 'Laptops', 2, 12),
(220, 5, 'Laptops', 3, 12),
(221, 5, 'Laptops', 4, 12),
(222, 5, 'Laptops', 5, 12),
(223, 5, 'Laptops', 6, 12),
(224, 5, 'Laptops', 7, 12),
(225, 5, 'Laptops', 8, 12),
(226, 5, 'Laptops', 9, 12),
(227, 5, 'Mobiles', 1, 13),
(228, 5, 'Mobiles', 2, 13),
(229, 5, 'Mobiles', 3, 13),
(230, 5, 'Mobiles', 4, 13),
(231, 5, 'Mobiles', 5, 13),
(232, 5, 'Mobiles', 6, 13),
(233, 5, 'Mobiles', 7, 13),
(234, 5, 'Mobiles', 8, 13),
(235, 5, 'Mobiles', 9, 13),
(236, 6, 'In use', 1, 1),
(237, 6, 'In gebruik', 2, 1),
(238, 6, 'UtilisÃ©', 3, 1),
(239, 6, 'Im Einsatz', 4, 1),
(240, 6, 'Ð’ Ð¸ï¿½?Ð¿Ð¾Ð»ÑŒÐ·Ð¾Ð²Ð°Ð½Ð¸Ð¸', 5, 1),
(241, 6, 'En uso', 6, 1),
(242, 6, 'Vid anvÃƒÂ¤ndning', 7, 1),
(243, 6, 'KullanÃ„Â±mda', 8, 1),
(244, 6, 'In uso', 9, 1),
(245, 6, 'In Transit', 1, 3),
(246, 6, 'Onderweg', 2, 3),
(247, 6, 'En Transit', 3, 3),
(248, 6, 'In Transit', 4, 3),
(249, 6, 'Ð’ ÐŸÑƒÑ‚Ð¸', 5, 3),
(250, 6, 'En Camino', 6, 3),
(251, 6, 'I Transit', 7, 3),
(252, 6, 'Transit Olarak', 8, 3),
(253, 6, 'In Transito', 9, 3),
(254, 6, 'In stock', 1, 4),
(255, 6, 'Op voorraad', 2, 4),
(256, 6, 'En stock', 3, 4),
(257, 6, 'VorrÃ¤tig', 4, 4),
(258, 6, 'Ð’ Ð½Ð°Ð»Ð¸Ñ‡Ð¸Ð¸', 5, 4),
(259, 6, 'En existencia', 6, 4),
(260, 6, 'I lager', 7, 4),
(261, 6, 'Stokta var', 8, 4),
(262, 6, 'Disponibile', 9, 4),
(263, 6, 'Missing', 1, 2),
(264, 6, 'Vermist', 2, 2),
(265, 6, 'Manquant', 3, 2),
(266, 6, 'Fehlt', 4, 2),
(267, 6, 'ÐžÑ‚ï¿½?ÑƒÑ‚ï¿½?Ñ‚Ð²ÑƒÑŽÑ‰Ð¸Ð¹', 5, 2),
(268, 6, 'Que falta', 6, 2),
(269, 6, 'Saknas', 7, 2),
(270, 6, 'Eksik', 8, 2),
(271, 6, 'Mancante', 9, 2),
(272, 6, 'Retired', 1, 5),
(273, 6, 'Gepensioneerd', 2, 5),
(274, 6, 'RetraitÃ©', 3, 5),
(275, 6, 'Im Ruhestand', 4, 5),
(276, 6, 'Ð’ Ð¾Ñ‚ï¿½?Ñ‚Ð°Ð²ÐºÐµ', 5, 5),
(277, 6, 'Jubilado', 6, 5),
(278, 6, 'Pensionerad', 7, 5),
(279, 6, 'Emekli', 8, 5),
(280, 6, 'Pensionato', 9, 5),
(281, 6, 'Closed', 1, 6),
(282, 6, 'Closed', 2, 6),
(283, 6, 'Closed', 3, 6),
(284, 6, 'Closed', 4, 6),
(285, 6, 'Closed', 5, 6),
(286, 6, 'Closed', 6, 6),
(287, 6, 'Closed', 7, 6),
(288, 6, 'Closed', 9, 6),
(289, 7, 'Open Source', 1, 1),
(290, 7, 'Open Source', 2, 1),
(291, 7, 'Open Source', 3, 1),
(292, 7, 'Open Source', 4, 1),
(293, 7, 'ÐžÑ‚ÐºÑ€Ñ‹Ñ‚Ñ‹Ð¼ Ð¸ï¿½?Ñ…Ð¾Ð´Ð½Ñ‹Ð¼ ÐºÐ¾Ð´Ð¾Ð¼', 5, 1),
(294, 7, 'CÃ³digo Abierto', 6, 1),
(295, 7, 'Ã–ppen KÃ¤lla', 7, 1),
(296, 7, 'AÃ§Ä±k Kaynak', 8, 1),
(297, 7, 'Open Source', 9, 1),
(298, 7, 'Commercial', 1, 2),
(299, 7, 'Commercieel', 2, 2),
(300, 7, 'Commercial', 3, 2),
(301, 7, 'Kommerziell', 4, 2),
(302, 7, 'ÐšÐ¾Ð¼Ð¼ÐµÑ€Ñ‡Ðµï¿½?ÐºÐ°ï¿½?', 5, 2),
(303, 7, 'Comercial', 6, 2),
(304, 7, 'Kommersiell', 7, 2),
(305, 7, 'Ticari', 8, 2),
(306, 7, 'Commerciale', 9, 2),
(307, 8, 'Lease', 1, 1),
(308, 8, 'Huurcontract', 2, 1),
(309, 8, 'Bail', 3, 1),
(310, 8, 'Mietvertrag', 4, 1),
(311, 8, 'ï¿½?Ñ€ÐµÐ½Ð´Ð°', 5, 1),
(312, 8, 'Arrendamiento', 6, 1),
(313, 8, 'Lease', 7, 1),
(314, 8, 'Kiralama', 8, 1),
(315, 8, 'Locazione', 9, 1),
(316, 8, 'Software License', 1, 2),
(317, 8, 'Software License', 2, 2),
(318, 8, 'Software License', 3, 2),
(319, 8, 'Software-Lizenz', 4, 2),
(320, 8, 'Ð¾Ð±ï¿½?Ð»ÑƒÐ¶Ð¸Ð²Ð°Ð½Ð¸Ðµ', 5, 2),
(321, 8, 'Licencia de Software', 6, 2),
(322, 8, 'Software License', 7, 2),
(323, 8, 'YazÄ±lÄ±m LisansÄ±', 8, 2),
(324, 8, 'Software License', 9, 2),
(325, 8, 'Maintenance', 1, 3),
(326, 8, 'Onderhoud', 2, 3),
(327, 8, 'Entretien', 3, 3),
(328, 8, 'Wartung', 4, 3),
(329, 8, 'ï¿½?Ðµï¿½?Ð¾Ð²ÐµÑ€ÑˆÐµÐ½Ð½Ð¾Ð»ÐµÑ‚Ð½Ð¸Ð¹', 5, 3),
(330, 8, 'Mantenimiento', 6, 3),
(331, 8, 'UnderhÃ¥ll', 7, 3),
(332, 8, 'BakÄ±m', 8, 3),
(333, 8, 'Manutenzione', 9, 3),
(334, 9, 'Affect business', 1, 1),
(335, 9, 'Laag', 2, 1),
(336, 9, 'Faible', 3, 1),
(337, 9, 'Niedrig', 4, 1),
(338, 9, 'Ð’Ñ‹ï¿½?Ð¾ÐºÐ¸Ð¹', 5, 1),
(339, 9, 'Bajo', 6, 1),
(340, 9, 'LÃ¥g', 7, 1),
(341, 9, 'DÃ¼ÅŸÃ¼k', 8, 1),
(342, 9, 'Basso', 9, 1),
(343, 9, 'User affect', 1, 2),
(344, 9, 'User affect', 2, 2),
(345, 9, 'Moyen', 3, 2),
(346, 9, 'User affect', 4, 2),
(347, 9, 'ÐžÑ‚ÐºÑ€Ñ‹Ñ‚Ñ‹Ð¼ Ð¸ï¿½?Ñ…Ð¾Ð´Ð½Ñ‹Ð¼ ÐºÐ¾Ð´Ð¾Ð¼', 5, 2),
(348, 9, 'Medio', 6, 2),
(349, 9, 'User affect', 7, 2),
(350, 9, 'Orta', 8, 2),
(351, 9, 'Medio', 9, 2),
(352, 9, 'Affect group', 1, 3),
(353, 9, 'Hoog', 2, 3),
(354, 9, 'Ã‰levÃ©', 3, 3),
(355, 9, 'Hoch', 4, 3),
(356, 9, 'ÐšÐ¾Ð¼Ð¼ÐµÑ€Ñ‡Ðµï¿½?ÐºÐ°ï¿½?', 5, 3),
(357, 9, 'Alto', 6, 3),
(358, 9, 'HÃ¶g', 7, 3),
(359, 9, 'YÃ¼ksek', 8, 3),
(360, 9, 'Alto', 9, 3),
(361, 10, 'Low', 1, 1),
(362, 10, 'Laag', 2, 1),
(363, 10, 'Faible', 3, 1),
(364, 10, 'Niedrig', 4, 1),
(365, 10, 'ï¿½?Ð¸Ð·ÐºÐ¸Ð¹', 5, 1),
(366, 10, 'Bajo', 6, 1),
(367, 10, 'LÃ¥g', 7, 1),
(368, 10, 'DÃ¼ÅŸÃ¼k', 8, 1),
(369, 10, 'Basso', 9, 1),
(370, 10, 'Medium', 1, 2),
(371, 10, 'Medium', 2, 2),
(372, 10, 'Moyen', 3, 2),
(373, 10, 'Medium', 4, 2),
(374, 10, 'Ð¡Ñ€ÐµÐ´Ð°', 5, 2),
(375, 10, 'Medio', 6, 2),
(376, 10, 'Medium', 7, 2),
(377, 10, 'Orta', 8, 2),
(378, 10, 'Medio', 9, 2),
(379, 10, 'High', 1, 3),
(380, 10, 'Hoog', 2, 3),
(381, 10, 'Ã‰levÃ©', 3, 3),
(382, 10, 'Hoch', 4, 3),
(383, 10, 'Ð’Ñ‹ï¿½?Ð¾ÐºÐ¸Ð¹', 5, 3),
(384, 10, 'Alto', 6, 3),
(385, 10, 'HÃ¶g', 7, 3),
(386, 10, 'YÃ¼ksek', 8, 3),
(387, 10, 'Alto', 9, 3),
(388, 10, 'Very high', 1, 4),
(389, 10, 'Erg hoog', 2, 4),
(390, 10, 'TrÃ¨s haut', 3, 4),
(391, 10, 'Sehr hoch', 4, 4),
(392, 10, 'ÐžÑ‡ÐµÐ½ÑŒ Ð²Ñ‹ï¿½?Ð¾ÐºÐ¾', 5, 4),
(393, 10, 'Muy alto', 6, 4),
(394, 10, 'VÃ¤ldigt hÃ¶gt', 7, 4),
(395, 10, 'Ã‡ok yÃ¼ksek', 8, 4),
(396, 10, 'Molto alto', 9, 4),
(397, 11, 'Minor', 1, 1),
(398, 11, 'Mineur', 2, 1),
(399, 11, 'Mineur', 3, 1),
(400, 11, 'Moll', 4, 1),
(401, 11, 'ï¿½?Ðµï¿½?Ð¾Ð²ÐµÑ€ÑˆÐµÐ½Ð½Ð¾Ð»ÐµÑ‚Ð½Ð¸Ð¹', 5, 1),
(402, 11, 'Menor', 6, 1),
(403, 11, 'Minor', 7, 1),
(404, 11, 'KÃ¼Ã§Ã¼k', 8, 1),
(405, 11, 'Minore', 9, 1),
(406, 11, 'Standard', 1, 2),
(407, 11, 'Standaard', 2, 2),
(408, 11, 'Standard', 3, 2),
(409, 11, 'Standard', 4, 2),
(410, 11, 'Ð¡Ñ‚Ð°Ð½Ð´Ð°Ñ€Ñ‚', 5, 2),
(411, 11, 'EstÃ¡ndar', 6, 2),
(412, 11, 'Standard', 7, 2),
(413, 11, 'Standart', 8, 2),
(414, 11, 'Standard', 9, 2),
(415, 11, 'Major', 1, 3),
(416, 11, 'Groot', 2, 3),
(417, 11, 'Majeur', 3, 3),
(418, 11, 'Dur', 4, 3),
(419, 11, 'ÐšÑ€ÑƒÐ¿Ð½Ñ‹Ð¹', 5, 3),
(420, 11, 'Mayor', 6, 3),
(421, 11, 'StÃ¶rre', 7, 3),
(422, 11, 'BÃ¼yÃ¼k', 8, 3),
(423, 11, 'Maggiore', 9, 3),
(424, 11, 'Emergency', 1, 4),
(425, 11, 'Noodgeval', 2, 4),
(426, 11, 'Urgence', 3, 4),
(427, 11, 'Notfall', 4, 4),
(428, 11, 'ï¿½?Ð²Ð°Ñ€Ð¸Ð¹Ð½Ñ‹Ð¹', 5, 4),
(429, 11, 'Emergencia', 6, 4),
(430, 11, 'Emergencia', 7, 4),
(431, 11, 'Acil durum', 8, 4),
(432, 11, 'Emergenza', 9, 4),
(433, 12, 'Minor', 1, 1),
(434, 12, 'Mineur', 2, 1),
(435, 12, 'Mineur', 3, 1),
(436, 12, 'Moll', 4, 1),
(437, 12, 'ï¿½?Ðµï¿½?Ð¾Ð²ÐµÑ€ÑˆÐµÐ½Ð½Ð¾Ð»ÐµÑ‚Ð½Ð¸Ð¹', 5, 1),
(438, 12, 'Menor', 6, 1),
(439, 12, 'Minor', 7, 1),
(440, 12, 'KÃ¼Ã§Ã¼k', 8, 1),
(441, 12, 'Minore', 9, 1),
(442, 12, 'Major', 1, 3),
(443, 12, 'Groot', 2, 3),
(444, 12, 'Majeur', 3, 3),
(445, 12, 'Dur', 4, 3),
(446, 12, 'ï¿½?Ð²Ð°Ñ€Ð¸Ð¹Ð½Ñ‹Ð¹', 5, 3),
(447, 12, 'Mayor', 6, 3),
(448, 12, 'StÃ¶rre', 7, 3),
(449, 12, 'BÃ¼yÃ¼k', 8, 3),
(450, 12, 'Maggiore', 9, 3),
(451, 12, 'Standard', 1, 2),
(452, 12, 'Standaard', 2, 2),
(453, 12, 'Standard', 3, 2),
(454, 12, 'Standard', 4, 2),
(455, 12, 'ÐšÑ€ÑƒÐ¿Ð½Ñ‹Ð¹', 5, 2),
(456, 12, 'EstÃ¡ndar', 6, 2),
(457, 12, 'Standard', 7, 2),
(458, 12, 'Standart', 8, 2),
(459, 12, 'Standard', 9, 2),
(460, 12, 'Emergency', 1, 4),
(461, 12, 'Noodgeval', 2, 4),
(462, 12, 'Urgence', 3, 4),
(463, 12, 'Notfall', 4, 4),
(464, 12, 'Ð’ Ð¿Ñ€Ð¾Ð¸Ð·Ð²Ð¾Ð´ï¿½?Ñ‚Ð²Ðµ', 5, 4),
(465, 12, 'Emergencia', 6, 4),
(466, 12, 'Emergency', 7, 4),
(467, 12, 'Acil durum', 8, 4),
(468, 12, 'Emergenza', 9, 4),
(469, 13, 'In production', 1, 1),
(470, 13, 'In bewerking', 2, 1),
(471, 13, 'En production', 3, 1),
(472, 13, 'In Produktion', 4, 1),
(473, 13, 'Ð’ Ð¿Ñ€Ð¾Ð¸Ð·Ð²Ð¾Ð´ï¿½?Ñ‚Ð²Ðµ', 5, 1),
(474, 13, 'En producciÃ³n', 6, 1),
(475, 13, 'I produktion', 7, 1),
(476, 13, 'Ãœretimde', 8, 1),
(477, 13, 'In produzione', 9, 1),
(478, 13, 'In pipeline', 1, 2),
(479, 13, 'In pipeline', 2, 2),
(480, 13, 'Dans pipeline', 3, 2),
(481, 13, 'In Pipeline', 4, 2),
(482, 13, 'Ð’ Ñ‚Ñ€ÑƒÐ±Ð¾Ð¿Ñ€Ð¾Ð²Ð¾Ð´Ðµ', 5, 2),
(483, 13, 'En tuberÃ­a', 6, 2),
(484, 13, 'I pipeline', 7, 2),
(485, 13, 'Boru hattÄ± iÃ§inde', 8, 2),
(486, 13, 'In conduttura', 9, 2),
(487, 13, 'Retired', 1, 3),
(488, 13, 'Gepensioneerd', 2, 3),
(489, 13, 'RetraitÃ©', 3, 3),
(490, 13, 'Im Ruhestand', 4, 3),
(491, 13, 'Ð’ Ð¾Ñ‚ï¿½?Ñ‚Ð°Ð²ÐºÐµ', 5, 3),
(492, 13, 'Jubilado', 6, 3),
(493, 13, 'Pensionerad', 7, 3),
(494, 13, 'Emekli', 8, 3),
(495, 13, 'Pensionato', 9, 3),
(496, 14, 'Buy', 1, 1),
(497, 14, 'Kopen', 2, 1),
(498, 14, 'Acheter', 3, 1),
(499, 14, 'Kaufen', 4, 1),
(500, 14, 'ÐšÑƒÐ¿Ð¸Ñ‚ÑŒ', 5, 1),
(501, 14, 'Comprar', 6, 1),
(502, 14, 'KÃ¶pa', 7, 1),
(503, 14, 'SatÄ±n almak', 8, 1),
(504, 14, 'Acquistare', 9, 1),
(505, 14, 'Both', 1, 3),
(506, 14, 'Beide', 2, 3),
(507, 14, 'Les deux', 3, 3),
(508, 14, 'Beide', 4, 3),
(509, 14, 'ÐžÐ±Ðµ', 5, 3),
(510, 14, 'Ambos', 6, 3),
(511, 14, 'BÃ¥da', 7, 3),
(512, 14, 'Her ikisi de', 8, 3),
(513, 14, 'Entrambi', 9, 3),
(514, 14, 'Lease', 1, 2),
(515, 14, 'Huurcontract', 2, 2),
(516, 14, 'Bail', 3, 2),
(517, 14, 'Mietvertrag', 4, 2),
(518, 14, 'ï¿½?Ñ€ÐµÐ½Ð´Ð°', 5, 2),
(519, 14, 'Arrendamiento', 6, 2),
(520, 14, 'Lease', 7, 2),
(521, 14, 'Kiralama', 8, 2),
(522, 14, 'Locazione', 9, 2),
(523, 15, 'General', 1, 1),
(524, 15, 'algemeen', 2, 1),
(525, 15, 'gÃ©nÃ©ral', 3, 1),
(526, 15, 'General', 4, 1),
(527, 15, 'Ð“ÐµÐ½ÐµÑ€Ð°Ð»ÑŒÐ½Ð°Ñ¿', 5, 1),
(528, 15, 'General', 6, 1),
(529, 15, 'AllmÃ¤nt', 7, 1),
(530, 15, 'genel', 8, 1),
(531, 15, 'generale', 9, 1),
(532, 18, 'Software', 1, 1),
(533, 18, 'Hardware', 1, 2),
(534, 18, 'Software', 2, 1),
(535, 18, 'Hardware', 2, 2),
(536, 18, 'Logiciel', 3, 1),
(537, 18, 'MatÃ©riel', 3, 2),
(538, 18, 'Software', 4, 1),
(539, 18, 'Hardware', 4, 2),
(540, 18, 'Ð¿Ñ€Ð¾Ð³Ñ€Ð°Ð¼Ð¼Ð½Ð¾Ð³Ð¾ Ð¾Ð±ÐµÑÐ¿ÐµÑ‡ÐµÐ½Ð¸Ñ', 5, 1),
(541, 18, 'Ð°Ð¿Ð¿Ð°Ñ€Ð°Ñ‚Ð½Ñ‹Ðµ ÑÑ€ÐµÐ´ÑÑ‚Ð²Ð°', 5, 2),
(542, 18, 'Software', 6, 1),
(543, 18, 'Hardware', 6, 2),
(544, 18, 'Programvara', 7, 1),
(545, 18, 'HÃ¥rdvara', 7, 2),
(546, 18, 'YazÄ±lÄ±m', 8, 1),
(547, 18, 'DonanÄ±m', 8, 2),
(548, 18, 'Software', 9, 1),
(549, 18, 'Hardware', 9, 2),
(550, 19, 'Photoshop', 1, 1),
(551, 19, 'Microsoft office', 1, 2),
(552, 19, 'Printer', 1, 3),
(553, 19, 'Photoshop', 2, 1),
(554, 19, 'Microsoft kantoor', 2, 2),
(555, 19, 'Printer', 2, 3),
(556, 19, 'Photoshop', 3, 1),
(557, 19, 'Microsoft Bureau', 3, 2),
(558, 19, 'Imprimante', 3, 3),
(559, 19, 'Photoshop', 4, 1),
(560, 19, 'Microsoft BÃ¼ro', 4, 2),
(561, 19, 'Drucker', 4, 3),
(562, 19, 'Ñ„Ð¾Ñ‚Ð¾ÑˆÐ¾Ð¿', 5, 1),
(563, 19, 'Microsoft Ð¾Ñ„Ð¸Ñ', 5, 2),
(564, 19, 'Ð¿Ñ€Ð¸Ð½Ñ‚ÐµÑ€', 5, 3),
(565, 19, 'Photoshop', 6, 1),
(566, 19, 'Microsoft oficina', 6, 2),
(567, 19, 'impresora', 6, 3),
(568, 19, 'Photoshop', 7, 1),
(569, 19, 'Microsoft kontor', 7, 2),
(570, 19, 'Skrivare', 7, 3),
(571, 19, 'Photoshop', 8, 1),
(572, 19, 'Microsoft ofis', 8, 2),
(573, 19, 'Printer', 8, 3),
(574, 19, 'Photoshop', 9, 1),
(575, 19, 'Microsoft ufficio', 9, 2),
(576, 19, 'Stampante', 9, 3),
(577, 20, 'Install', 1, 1),
(578, 20, 'Upgrade', 1, 2),
(579, 20, 'Uninstall', 1, 3),
(580, 20, 'Install', 1, 4),
(581, 20, 'Upgrade', 1, 5),
(582, 20, 'Uninstall', 1, 6),
(583, 20, 'Installeren', 2, 1),
(584, 20, 'Upgrade', 2, 2),
(585, 20, 'Uninstall', 2, 3),
(586, 20, 'Installeren', 2, 4),
(587, 20, 'Upgrade', 2, 5),
(588, 20, 'Uninstall', 2, 6),
(589, 20, 'Installer', 3, 1),
(590, 20, 'AmÃ©lioration', 3, 2),
(591, 20, 'DÃ©sinstaller', 3, 3),
(592, 20, 'Installer', 3, 4),
(593, 20, 'AmÃ©lioration', 3, 5),
(594, 20, 'DÃ©sinstaller', 3, 6),
(595, 20, 'Installieren', 4, 1),
(596, 20, 'Aktualisierung', 4, 2),
(597, 20, 'Uninstall', 4, 3),
(598, 20, 'Installieren', 4, 4),
(599, 20, 'Aktualisierung', 4, 5),
(600, 20, 'Uninstall', 4, 6),
(601, 20, 'ÑƒÑÑ‚Ð°Ð½Ð°Ð²Ð»Ð¸Ð²Ð°Ñ‚ÑŒ', 5, 1),
(602, 20, 'ÐžÐ±Ð½Ð¾Ð²Ð¸Ñ‚ÑŒ', 5, 2),
(603, 20, 'Ð£Ð´Ð°Ð»ÐµÐ½Ð¸Ðµ', 5, 3),
(604, 20, 'ÑƒÑÑ‚Ð°Ð½Ð°Ð²Ð»Ð¸Ð²Ð°Ñ‚ÑŒ', 5, 4),
(605, 20, 'ÐžÐ±Ð½Ð¾Ð²Ð¸Ñ‚ÑŒ', 5, 5),
(606, 20, 'Ð£Ð´Ð°Ð»ÐµÐ½Ð¸Ðµ', 5, 6),
(607, 20, 'Instalar', 6, 1),
(608, 20, 'actualizaciÃ³n', 6, 2),
(609, 20, 'Desinstalar', 6, 3),
(610, 20, 'Instalar', 6, 4),
(611, 20, 'actualizaciÃ³n', 6, 5),
(612, 20, 'Desinstalar', 6, 6),
(613, 20, 'installera', 7, 1),
(614, 20, 'uppgradering', 7, 2),
(615, 20, 'avinstallera', 7, 3),
(616, 20, 'installera', 7, 4),
(617, 20, 'uppgradering', 7, 5),
(618, 20, 'avinstallera', 7, 6),
(619, 20, 'yÃ¼kleme', 8, 1),
(620, 20, 'YÃ¼kseltme', 8, 2),
(621, 20, 'KaldÄ±rma', 8, 3),
(622, 20, 'yÃ¼kleme', 8, 4),
(623, 20, 'YÃ¼kseltme', 8, 5),
(624, 20, 'KaldÄ±rma', 8, 6),
(625, 20, 'installare', 9, 1),
(626, 20, 'aggiornamento', 9, 2),
(627, 20, 'Disinstallare', 9, 3),
(628, 20, 'installare', 9, 4),
(629, 20, 'aggiornamento', 9, 5),
(630, 20, 'Disinstallare', 9, 6),
(631, 21, 'Level1', 1, 1),
(632, 21, 'Level2', 1, 2),
(633, 21, 'Level3', 1, 3),
(634, 21, 'Level1', 2, 1),
(635, 21, 'Level2', 2, 2),
(636, 21, 'Level3', 2, 3),
(637, 21, 'niveau1', 3, 1),
(638, 21, 'niveau2', 3, 2),
(639, 21, 'niveau3', 3, 3),
(640, 21, 'Level1', 4, 1),
(641, 21, 'Level2', 4, 2),
(642, 21, 'Level3', 4, 3),
(643, 21, '1-Ð¹ ÑƒÑ€Ð¾Ð²ÐµÐ½ÑŒ', 5, 1),
(644, 21, 'ÑƒÑ€Ð¾Ð²ÐµÐ½ÑŒ 2', 5, 2),
(645, 21, 'Ð£Ñ€Ð¾Ð²ÐµÐ½ÑŒ 3', 5, 3),
(646, 21, 'nivel1', 6, 1),
(647, 21, 'nivel2', 6, 2),
(648, 21, 'nivel3', 6, 3),
(649, 21, 'nivÃ¥1', 7, 1),
(650, 21, 'nivÃ¥2', 7, 2),
(651, 21, 'nivÃ¥3', 7, 3),
(652, 21, 'Seviye1', 8, 1),
(653, 21, 'Seviye2', 8, 2),
(654, 21, 'Seviye3', 8, 3),
(655, 21, 'livello1', 9, 1),
(656, 21, 'livello2', 9, 2),
(657, 21, 'livello3', 9, 3),
(658, 20, 'Installeren', 2, 7),
(659, 20, 'Installer', 3, 7),
(660, 20, 'Installieren', 4, 7),
(661, 20, 'ÑƒÑÑ‚Ð°Ð½Ð°Ð²Ð»Ð¸Ð²Ð°Ñ‚ÑŒ', 5, 7),
(662, 20, 'Instalar', 6, 7),
(663, 20, 'installera', 7, 7),
(664, 20, 'yÃ¼kleme', 8, 7),
(665, 20, 'Desinstalar', 6, 8),
(666, 20, 'Ð£Ð´Ð°Ð»ÐµÐ½Ð¸Ðµ', 5, 8),
(667, 20, 'Uninstall', 4, 8),
(668, 20, 'Install', 1, 7),
(669, 20, 'DÃƒÂ©sinstaller', 3, 8),
(670, 20, 'Uninstall', 2, 8),
(671, 20, 'Uninstall', 1, 8),
(672, 20, 'avinstallera', 7, 8),
(673, 20, 'KaldÃ„Â±rma', 8, 8),
(674, 20, 'Disinstallare', 9, 8),
(675, 20, 'installare', 9, 7),
(676, 25, 'Knowledgebase', 1, 1),
(677, 25, 'Kennis basis', 2, 1),
(678, 25, 'Base de connaissances', 3, 1),
(679, 25, 'Wissensbasis', 4, 1),
(680, 25, 'Ð‘Ð°Ð·Ð° Ð·Ð½Ð°Ð½Ð¸Ð¹', 5, 1),
(681, 25, 'Base de Conocimiento', 6, 1),
(682, 25, 'Kunskapsbas', 7, 1),
(683, 25, 'Bilgi tabanÄ±', 8, 1),
(684, 25, 'Knowledgebase', 9, 1),
(685, 25, 'Downloads', 1, 2),
(686, 25, 'downloads', 2, 2),
(687, 25, 'TÃ©lÃ©chargements', 3, 2),
(688, 25, 'Downloads', 4, 2),
(689, 25, 'Ð—Ð°Ð³Ñ€ÑƒÐ·ÐºÐ¸', 5, 2),
(690, 25, 'descargas', 6, 2),
(691, 25, 'nedladdningar', 7, 2),
(692, 25, 'Ä°ndirme', 8, 2),
(693, 25, 'download', 9, 2),
(694, 25, 'Livechat canned responses', 1, 3),
(695, 25, 'Livechat-standaardantwoorden', 2, 3),
(696, 25, 'RÃ©ponses en direct Livechat', 3, 3),
(697, 25, 'Gespeicherte Livechat-Antworten', 4, 3),
(698, 25, 'Livechat ÐºÐ¾Ð½ÑÐµÑ€Ð²Ð¸Ñ€Ð¾Ð²Ð°Ð½Ð½Ñ‹Ðµ Ð¾Ñ‚Ð²ÐµÑ‚Ñ‹', 5, 3),
(699, 25, 'Livechat respuestas enlatadas', 6, 3),
(700, 25, 'Livechat konserverade svar', 7, 3),
(701, 25, 'Livechat hazÄ±r yanÄ±tlar', 8, 3),
(702, 25, 'Livechat risposte in scatolas', 9, 3),
(703, 23, 'Feedback', 1, 1),
(704, 23, 'terugkoppeling', 2, 1),
(705, 23, 'Retour d''information', 3, 1),
(706, 23, 'Feedback', 4, 1),
(707, 23, 'ÐžÐ±Ñ€Ð°Ñ‚Ð½Ð°Ñ ÑÐ²ÑÐ·ÑŒ', 5, 1),
(708, 23, 'RealimentaciÃ³n', 6, 1),
(709, 23, 'Ã…terkoppling', 7, 1),
(710, 23, 'geribesleme', 8, 1),
(711, 23, 'Risposta', 9, 1),
(712, 24, 'Low', 1, 1),
(713, 24, 'Medium', 1, 2),
(714, 24, 'High', 1, 3),
(715, 24, 'Laag', 2, 1),
(716, 24, 'Medium', 2, 2),
(717, 24, 'hoog', 2, 3),
(718, 24, 'Faible', 3, 1),
(719, 24, 'Moyen', 3, 2),
(720, 24, 'Haute', 3, 3),
(721, 24, 'Niedrig', 4, 1),
(722, 24, 'Mittel', 4, 2),
(723, 24, 'Hoch', 4, 3),
(724, 24, 'Ð½Ð¸Ð·ÐºÐ¸Ð¹', 5, 1),
(725, 24, 'Ð¡Ñ€ÐµÐ´Ð½ÑÑ', 5, 2),
(726, 24, 'Ð’Ñ‹ÑÐ¾ÐºÐ¾', 5, 3),
(727, 24, 'bajo', 6, 1),
(728, 24, 'Medio', 6, 2),
(729, 24, 'Alto', 6, 3),
(730, 24, 'lÃ¥g', 7, 1),
(731, 24, 'Medium', 7, 2),
(732, 24, 'HÃ¶g', 7, 3),
(733, 24, 'dÃ¼ÅŸÃ¼k', 8, 1),
(734, 24, 'Orta', 8, 2),
(735, 24, 'YÃ¼ksek', 8, 3),
(736, 24, 'basso', 9, 1),
(737, 24, 'medio', 9, 2),
(738, 24, 'alto', 9, 3),
(739, 36, 'Enterprise', 1, 1),
(740, 36, 'Network', 1, 2),
(741, 36, 'Named', 1, 3),
(742, 36, 'Concurrent', 1, 4),
(743, 36, 'Subscription', 1, 5),
(744, 35, 'Available for distribution', 1, 1),
(745, 35, 'Distributed and consumed', 1, 2),
(746, 35, 'Harvested for re-use', 1, 3),
(747, 35, 'Re-allocated', 1, 4),
(748, 35, 'End-of-license removal', 1, 5),
(749, 37, 'Ordered', 1, 1),
(750, 37, 'Received', 1, 2),
(751, 37, 'In storage', 1, 3),
(752, 37, 'Deployed', 1, 4),
(753, 37, 'Retired', 1, 5),
(754, 37, 'Disposed', 1, 6),
(755, 34, 'Sold', 1, 1),
(756, 34, 'Donated', 1, 2),
(757, 34, 'Lost', 1, 3),
(758, 34, 'Destroyed', 1, 4),
(759, 39, 'General', 1, 1),
(760, 36, 'Onderneming', 2, 1),
(761, 36, 'Netwerk', 2, 2),
(762, 36, 'Genaamd', 2, 3),
(763, 36, 'gelijktijdig', 2, 4),
(764, 36, 'Abonnement', 2, 5),
(765, 35, 'Beschikbaar voor distributie', 2, 1),
(766, 35, 'Gedistribueerd en geconsumeerd', 2, 2),
(767, 35, 'Geoogst voor hergebruik', 2, 3),
(768, 35, 'Re-toegewezen', 2, 4),
(769, 35, 'Einde van licentie verwijderen', 2, 5),
(770, 37, 'bestelde', 2, 1),
(771, 37, 'Ontvangen', 2, 2),
(772, 37, 'In de opslag', 2, 3),
(773, 37, 'ingezet', 2, 4),
(774, 37, 'Gepensioneerd', 2, 5),
(775, 37, 'geneigd', 2, 6),
(776, 34, 'uitverkocht', 2, 1),
(777, 34, 'geschonken', 2, 2),
(778, 34, 'Verloren', 2, 3),
(779, 34, 'Vernietigd', 2, 4),
(780, 39, 'Algemeen', 2, 1),
(781, 36, 'Enterprise', 3, 1),
(782, 36, 'RÃ©seau', 3, 2),
(783, 36, 'nommÃ©', 3, 3),
(784, 36, 'Concurrent', 3, 4),
(785, 36, 'Abonnement', 3, 5),
(786, 35, 'Disponible pour la distribution', 3, 1),
(787, 35, 'DistribuÃ© et consommÃ©', 3, 2),
(788, 35, 'rÃ©coltÃ© pour Ãªtre rÃ©utilisÃ©', 3, 3),
(789, 35, 'rÃ©affectÃ©', 3, 4),
(790, 35, 'Retrait de la fin de la licence', 3, 5),
(791, 37, 'OrdonnÃ©', 3, 1),
(792, 37, 'ReÃ§u', 3, 2),
(793, 37, 'EntreposÃ©', 3, 3),
(794, 37, 'dÃ©ployÃ©', 3, 4),
(795, 37, 'retraitÃ©', 3, 5),
(796, 37, 'Disposed', 3, 6),
(797, 34, 'vendu', 3, 1),
(798, 34, 'Donated', 3, 2),
(799, 34, 'Perdu', 3, 3),
(800, 34, 'dÃ©truit', 3, 4),
(801, 39, 'GÃ©nÃ©ral', 3, 1),
(802, 36, 'Unternehmen', 4, 1),
(803, 36, 'Netzwerk', 4, 2),
(804, 36, 'Genannt', 4, 3),
(805, 36, 'Gleichzeitig', 4, 4),
(806, 36, 'Abonnement', 4, 5),
(807, 35, 'VerfÃ¼gbar fÃ¼r die Verteilungn', 4, 1),
(808, 35, 'Verteilt und konsumiert', 4, 2),
(809, 35, 'FÃ¼r die Wiederverwendung geerntet', 4, 3),
(810, 35, 'Neu zugeteilt', 4, 4),
(811, 35, 'Ende der Lizenz entfernt', 4, 5),
(812, 37, 'Bestellt', 4, 1),
(813, 37, 'Empfangen', 4, 2),
(814, 37, 'Auf Lager', 4, 3),
(815, 37, 'Bereitgestellt', 4, 4),
(816, 37, 'Im Ruhestand', 4, 5),
(817, 37, 'Entsorgt', 4, 6),
(818, 34, 'Verkauftu', 4, 1),
(819, 34, 'Gespendet', 4, 2),
(820, 34, 'Hat verloren', 4, 3),
(821, 34, 'ZerstÃ¶rt', 4, 4),
(822, 39, 'Allgemeines', 4, 1),
(823, 36, 'Ð¿Ñ€ÐµÐ´Ð¿Ñ€Ð¸ÑÑ‚Ð¸Ðµ', 5, 1),
(824, 36, 'ÑÐµÑ‚ÑŒ', 5, 2),
(825, 36, 'Ð½Ð°Ð·Ð²Ð°Ð½Ð½Ñ‹Ð¹', 5, 3),
(826, 36, 'Ð¿Ð°Ñ€Ð°Ð»Ð»ÐµÐ»ÑŒÐ½Ñ‹Ð¹', 5, 4),
(827, 36, 'ÐŸÐ¾Ð´Ð¿Ð¸ÑÐºÐ°', 5, 5),
(828, 35, 'Ð”Ð¾ÑÑ‚ÑƒÐ¿Ð½Ð¾ Ð´Ð»Ñ Ñ€Ð°ÑÐ¿Ñ€Ð¾ÑÑ‚Ñ€Ð°Ð½ÐµÐ½Ð¸Ñ', 5, 1),
(829, 35, 'Ð Ð°ÑÐ¿Ñ€ÐµÐ´ÐµÐ»ÐµÐ½Ñ‹ Ð¸ Ð¿Ð¾Ñ‚Ñ€ÐµÐ±Ð»ÐµÐ½Ñ‹', 5, 2),
(830, 35, 'Ð¡Ð¾Ð±Ñ€Ð°Ð½ Ð´Ð»Ñ Ð¿Ð¾Ð²Ñ‚Ð¾Ñ€Ð½Ð¾Ð³Ð¾ Ð¸ÑÐ¿Ð¾Ð»ÑŒÐ·Ð¾Ð²Ð°Ð½Ð¸Ñ', 5, 3),
(831, 35, 'ÐŸÐµÑ€ÐµÑ€Ð°ÑÐ¿Ñ€ÐµÐ´ÐµÐ»ÐµÐ½Ñ‹', 5, 4),
(832, 35, 'Ð£Ð´Ð°Ð»ÐµÐ½Ð¸Ðµ Ð² ÐºÐ¾Ð½Ñ†Ðµ Ð»Ð¸Ñ†ÐµÐ½Ð·Ð¸Ð¸', 5, 5),
(833, 37, 'ÐŸÑ€Ð¸ÐºÐ°Ð·Ð°Ð»', 5, 1),
(834, 37, 'ÐŸÐ¾Ð»ÑƒÑ‡ÐµÐ½Ð¾', 5, 2),
(835, 37, 'Ð’ Ñ…Ñ€Ð°Ð½Ð¸Ð»Ð¸Ñ‰Ðµ', 5, 3),
(836, 37, 'Ñ€Ð°Ð·Ð²ÐµÑ€Ð½ÑƒÑ‚Ñ‹Ð¹', 5, 4),
(837, 37, 'Ð’ Ð¾Ñ‚ÑÑ‚Ð°Ð²ÐºÐµ', 5, 5),
(838, 37, 'Ñ€Ð°ÑÐ¿Ð¾Ð»Ð¾Ð¶ÐµÐ½Ð½Ñ‹Ð¹', 5, 6),
(839, 34, 'ÐŸÑ€Ð¾Ð´Ð°Ð½Ð¾', 5, 1),
(840, 34, 'Ð¿Ð¾Ð¶ÐµÑ€Ñ‚Ð²Ð¾Ð²Ð°Ð½Ð½Ñ‹Ð¹', 5, 2),
(841, 34, 'ÐŸÐ¾Ñ‚ÐµÑ€ÑÐ»', 5, 3),
(842, 34, 'Ñ€Ð°Ð·Ñ€ÑƒÑˆÐµÐ½Ð½Ñ‹Ð¹', 5, 4),
(843, 39, 'Ð³ÐµÐ½ÐµÑ€Ð°Ð»ÑŒÐ½Ñ‹Ð¹', 5, 1),
(844, 36, 'Empresa', 6, 1),
(845, 36, 'Red', 6, 2),
(846, 36, 'Llamado', 6, 3),
(847, 36, 'Concurrente', 6, 4),
(848, 36, 'SuscripciÃ³n', 6, 5),
(849, 35, 'Disponible para su distribuciÃ³n.', 6, 1),
(850, 35, 'Distribuido y consumido.', 6, 2),
(851, 35, 'Cosechado para su reutilizaciÃ³n.', 6, 3),
(852, 35, 'Reasignado', 6, 4),
(853, 35, 'EliminaciÃ³n de fin de licencia', 6, 5),
(854, 37, 'Ordenado', 6, 1),
(855, 37, 'Recibido', 6, 2),
(856, 37, 'En almacen', 6, 3),
(857, 37, 'Desplegado', 6, 4),
(858, 37, 'Retirado', 6, 5),
(859, 37, 'Dispuesto', 6, 6),
(860, 34, 'Vendido', 6, 1),
(861, 34, 'Donado', 6, 2),
(862, 34, 'Perdido', 6, 3),
(863, 34, 'Destruido', 6, 4),
(864, 39, 'General', 6, 1),
(865, 36, 'FÃ¶retag', 7, 1),
(866, 36, 'NÃ¤tverk', 7, 2),
(867, 36, 'Som heter', 7, 3),
(868, 36, 'Samverkande', 7, 4),
(869, 36, 'Prenumeration', 7, 5),
(870, 35, 'Finns fÃ¶r distribution', 7, 1),
(871, 35, 'Distribueras och konsumeras', 7, 2),
(872, 35, 'SkÃ¶rdad fÃ¶r Ã¥teranvÃ¤ndning', 7, 3),
(873, 35, 'OmfÃ¶rdelas', 7, 4),
(874, 35, 'Avslutande av licens', 7, 5),
(875, 37, 'Beordrade', 7, 1),
(876, 37, 'Mottagen', 7, 2),
(877, 37, 'I fÃ¶rvar', 7, 3),
(878, 37, 'utplacerade', 7, 4),
(879, 37, 'Pensionerad', 7, 5),
(880, 37, 'anordnat', 7, 6),
(881, 34, 'SÃ¥ld', 7, 1),
(882, 34, 'done~~POS=TRUNC ', 7, 2),
(883, 34, 'FÃ¶rlorat', 7, 3),
(884, 34, 'FÃ¶rstÃ¶rd', 7, 4),
(885, 39, 'AllmÃ¤n', 7, 1),
(886, 36, 'kuruluÅŸ', 8, 1),
(887, 36, 'AÄŸ', 8, 2),
(888, 36, 'adlÄ±', 8, 3),
(889, 36, 'EÅŸzamanlÄ±', 8, 4),
(890, 36, 'abone', 8, 5),
(891, 35, 'DaÄŸÄ±tÄ±m iÃ§in uygun', 8, 1),
(892, 35, 'DaÄŸÄ±tÄ±lmÄ±ÅŸ ve tÃ¼ketilmiÅŸ', 8, 2),
(893, 35, 'Yeniden kullanÄ±m iÃ§in hasat edildi', 8, 3),
(894, 35, 'Yeniden tahsis', 8, 4),
(895, 35, 'Lisans sonu kaldÄ±rma', 8, 5),
(896, 37, 'dÃ¼zenli', 8, 1),
(897, 37, 'AlÄ±nan', 8, 2),
(898, 37, 'Depoda', 8, 3),
(899, 37, 'DaÄŸÄ±tÄ±lan', 8, 4),
(900, 37, 'Emekli', 8, 5),
(901, 37, 'Disposed', 8, 6),
(902, 34, 'SatÄ±ldÄ±', 8, 1),
(903, 34, 'baÄŸÄ±ÅŸlanan', 8, 2),
(904, 34, 'KayÄ±p', 8, 3),
(905, 34, 'Yerlebir edilmiÅŸ', 8, 4),
(906, 39, 'Genel', 8, 1),
(907, 36, 'impresa', 9, 1),
(908, 36, 'Rete', 9, 2),
(909, 36, 'Di nome', 9, 3),
(910, 36, 'concorrente', 9, 4),
(911, 36, 'Sottoscrizione', 9, 5),
(912, 35, 'Disponibile per la distribuzione', 9, 1),
(913, 35, 'Distribuito e consumato', 9, 2),
(914, 35, 'Vendemmiato per il riutilizzo', 9, 3),
(915, 35, 'Re-assegnati', 9, 4),
(916, 35, 'Rimozione dalla fine della licenza', 9, 5),
(917, 37, 'Ordinato', 9, 1),
(918, 37, 'ricevuto', 9, 2),
(919, 37, 'In deposito', 9, 3),
(920, 37, 'schierato', 9, 4),
(921, 37, 'Pensionato', 9, 5),
(922, 37, 'Disposto', 9, 6),
(923, 34, 'Venduto', 9, 1),
(924, 34, 'donato', 9, 2),
(925, 34, 'Perso', 9, 3),
(926, 34, 'Distrutto', 9, 4),
(927, 39, 'Generale', 9, 1),
(928, 38, 'All incidents', 1, 1),
(929, 38, 'Alle incidenten', 2, 1),
(930, 38, 'Tous les incidents', 3, 1),
(931, 38, 'Alle VorfÃ¤lle', 4, 1),
(932, 38, 'Ð’ÑÐµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 1),
(933, 38, 'Todos los incidentes', 6, 1),
(934, 38, 'Alla incidenter', 7, 1),
(935, 38, 'TÃ¼m olaylar', 8, 1),
(936, 38, 'Tutti gli incidenti', 9, 1),
(937, 38, 'New incidents', 1, 2),
(938, 38, 'Nieuwe incidenten', 2, 2),
(939, 38, 'Nouveaux incidents', 3, 2),
(940, 38, 'Neue VorfÃ¤lle', 4, 2),
(941, 38, 'ÐÐ¾Ð²Ñ‹Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 2),
(942, 38, 'Nuevos incidentes', 6, 2),
(943, 38, 'Nya incidenter', 7, 2),
(944, 38, 'Yeni olaylar', 8, 2),
(945, 38, 'Nuovi incidenti', 9, 2),
(946, 38, 'Overdue incidents', 1, 3),
(947, 38, 'Achterstallige incidenten', 2, 3),
(948, 38, 'Incidents en retard', 3, 3),
(949, 38, 'ÃœberfÃ¤llige VorfÃ¤lle', 4, 3),
(950, 38, 'Ð—Ð°Ð¿Ð¾Ð·Ð´Ð°Ð»Ñ‹Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 3),
(951, 38, 'Incidentes atrasados', 6, 3),
(952, 38, 'FÃ¶rsenade incidenter', 7, 3),
(953, 38, 'GecikmiÅŸ olaylar', 8, 3),
(954, 38, 'Incidenti in ritardo', 9, 3),
(955, 38, 'Assigned incidents', 1, 4),
(956, 38, 'Toegekende incidenten', 2, 4),
(957, 38, 'Incidents attribuÃ©s', 3, 4),
(958, 38, 'Zugewiesene VorfÃ¤lle', 4, 4),
(959, 38, 'ÐÐ°Ð·Ð½Ð°Ñ‡ÐµÐ½Ð½Ñ‹Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 4),
(960, 38, 'Incidentes asignados', 6, 4),
(961, 38, 'Tilldelade incidenter', 7, 4),
(962, 38, 'Atanan olaylar', 8, 4),
(963, 38, 'Incidenti assegnati', 9, 4),
(964, 38, 'Schedule incidents', 1, 21),
(965, 38, 'Plan incidenten', 2, 21),
(966, 38, 'Horaires d''incidents', 3, 21),
(967, 38, 'Planen Sie VorfÃ¤lle', 4, 21),
(968, 38, 'Ð Ð°ÑÐ¿Ð¸ÑÐ°Ð½Ð¸Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ð¾Ð²', 5, 21),
(969, 38, 'Programar incidentes', 6, 21),
(970, 38, 'SchemalÃ¤gga hÃ¤ndelser', 7, 21),
(971, 38, 'OlaylarÄ± planlayÄ±n', 8, 21),
(972, 38, 'Pianifica gli incidenti', 9, 21),
(973, 38, 'All service requests', 1, 35),
(974, 38, 'Alle serviceverzoeken', 2, 35),
(975, 38, 'Toutes les demandes de service', 3, 35),
(976, 38, 'Alle Serviceanfragen', 4, 35),
(977, 38, 'Ð’ÑÐµ Ð·Ð°Ð¿Ñ€Ð¾ÑÑ‹ Ð½Ð° Ð¾Ð±ÑÐ»ÑƒÐ¶Ð¸Ð²Ð°Ð½Ð¸Ðµ', 5, 35),
(978, 38, 'Todas las solicitudes de servicio', 6, 35),
(979, 38, 'Alla servicefÃ¶rfrÃ¥gningar', 7, 35),
(980, 38, 'TÃ¼m servis talepleri', 8, 35),
(981, 38, 'Tutte le richieste di servizio', 9, 35),
(982, 38, 'Favorite', 1, 33),
(983, 38, 'Favoriete', 2, 33),
(984, 38, 'PrÃ©fÃ©rÃ©', 3, 33),
(985, 38, 'Liebling', 4, 33),
(986, 38, 'Ð»ÑŽÐ±Ð¸Ð¼ÐµÑ†', 5, 33),
(987, 38, 'Favorito', 6, 33),
(988, 38, 'Favorit', 7, 33),
(989, 38, 'Favori', 8, 33),
(990, 38, 'Preferito', 9, 33),
(991, 38, 'Draft', 1, 7),
(992, 38, 'Droogte', 2, 7),
(993, 38, 'Brouillon', 3, 7),
(994, 38, 'Entwurf', 4, 7),
(995, 38, 'ÐŸÑ€Ð¾ÐµÐºÑ‚', 5, 7),
(996, 38, 'Borrador', 6, 7),
(997, 38, 'FÃ¶rslag', 7, 7),
(998, 38, 'taslak', 8, 7),
(999, 38, 'Bozza', 9, 7),
(1000, 38, 'Spam', 1, 6),
(1001, 38, 'Spam', 2, 6),
(1002, 38, 'Spam', 3, 6),
(1003, 38, 'Spam', 4, 6),
(1004, 38, 'Ð¡Ð¿Ð°Ð¼', 5, 6),
(1005, 38, 'Correo no deseado', 6, 6),
(1006, 38, 'spam', 7, 6),
(1007, 38, 'Ä°stenmeyen e', 8, 6),
(1008, 38, 'Spam', 9, 6),
(1009, 38, 'Trash', 1, 5),
(1010, 38, 'uitschot', 2, 5),
(1011, 38, 'Poubelle', 3, 5),
(1012, 38, 'MÃ¼ll', 4, 5),
(1013, 38, 'Ð´Ñ€ÑÐ½ÑŒ', 5, 5),
(1014, 38, 'Basura', 6, 5),
(1015, 38, 'SkrÃ¤p', 7, 5),
(1016, 38, 'Ã‡Ã¶p', 8, 5),
(1017, 38, 'Spazzatura', 9, 5),
(1018, 38, 'Archive', 1, 34),
(1019, 38, 'Archief', 2, 34),
(1020, 38, 'Archiver', 3, 34),
(1021, 38, 'Archiv', 4, 34),
(1022, 38, 'ÐÑ€Ñ…Ð¸Ð²', 5, 34),
(1023, 38, 'Archivo', 6, 34),
(1024, 38, 'arkiv', 7, 34),
(1025, 38, 'ArÅŸiv', 8, 34),
(1026, 38, 'Archivio', 9, 34),
(1027, 38, 'Recent replied incidents', 1, 28),
(1028, 38, 'Recente gereageerde incidenten', 2, 28),
(1029, 38, 'Incidents rÃ©cents', 3, 28),
(1030, 38, 'KÃ¼rzlich beantwortete VorfÃ¤lle', 4, 28),
(1031, 38, 'ÐÐµÐ´Ð°Ð²Ð½Ð¸Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹ Ñ Ð¾Ñ‚Ð²ÐµÑ‚Ð°Ð¼Ð¸', 5, 28),
(1032, 38, 'Incidentes recientes respondidos', 6, 28),
(1033, 38, 'Nyligen svarade incidenter', 7, 28),
(1034, 38, 'Son cevaplanan olaylar', 8, 28),
(1035, 38, 'Recenti incidenti di risposta', 9, 28),
(1036, 38, 'Open incidents', 1, 25),
(1037, 38, 'Open incidenten', 2, 25),
(1038, 38, 'Incidents ouverts', 3, 25),
(1039, 38, 'Offene VorfÃ¤lle', 4, 25),
(1040, 38, 'ÐžÑ‚ÐºÑ€Ñ‹Ñ‚Ñ‹Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 25),
(1041, 38, 'Incidentes abiertos', 6, 25),
(1042, 38, 'Ã–ppna incidenter', 7, 25),
(1043, 38, 'AÃ§Ä±k olaylar', 8, 25),
(1044, 38, 'Apri incidenti', 9, 25),
(1045, 38, 'Critical incidents', 1, 26),
(1046, 38, 'Kritieke incidenten', 2, 26),
(1047, 38, 'Incidents critiques', 3, 26),
(1048, 38, 'Kritische Ereignisse', 4, 26),
(1049, 38, 'ÐšÑ€Ð¸Ñ‚Ð¸Ñ‡ÐµÑÐºÐ¸Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 26),
(1050, 38, 'Incidentes crÃ­ticos', 6, 26),
(1051, 38, 'Kritiska hÃ¤ndelser', 7, 26),
(1052, 38, 'Kritik olaylar', 8, 26),
(1053, 38, 'Incidenti critici', 9, 26),
(1054, 38, 'Unassigned incidents', 1, 27),
(1055, 38, 'Niet-toegewezen incidenten', 2, 27),
(1056, 38, 'Incidents non attribuÃ©s', 3, 27),
(1057, 38, 'Nicht zugewiesene VorfÃ¤lle', 4, 27),
(1058, 38, 'ÐÐµÐ½Ð°Ð·Ð½Ð°Ñ‡ÐµÐ½Ð½Ñ‹Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 27),
(1059, 38, 'Incidentes no asignados', 6, 27),
(1060, 38, 'Otilldelade incidenter', 7, 27),
(1061, 38, 'AtanmamÄ±ÅŸ olaylar', 8, 27),
(1062, 38, 'Incidenti non assegnati', 9, 27),
(1063, 38, 'Recent closed incidents', 1, 29),
(1064, 38, 'Recente gesloten incidenten', 2, 29),
(1065, 38, 'Incidents fermÃ©s rÃ©cemment', 3, 29),
(1066, 38, 'KÃ¼rzlich abgeschlossene VorfÃ¤lle', 4, 29),
(1067, 38, 'ÐÐµÐ´Ð°Ð²Ð½Ð¸Ðµ Ð·Ð°ÐºÑ€Ñ‹Ñ‚Ñ‹Ðµ Ð¸Ð½Ñ†Ð¸Ð´ÐµÐ½Ñ‚Ñ‹', 5, 29),
(1068, 38, 'Incidentes cerrados recientes', 6, 29),
(1069, 38, 'Nyligen stÃ¤ngda hÃ¤ndelser', 7, 29),
(1070, 38, 'Son kapatÄ±lan olaylar', 8, 29),
(1071, 38, 'Recenti incidenti chiusi', 9, 29),
(1072, 38, 'All chats', 1, 36),
(1073, 38, 'Recent chats', 1, 37),
(1074, 38, 'Missed chats', 1, 38),
(1075, 38, 'Alle chats', 2, 36),
(1076, 38, 'Recente chats', 2, 37),
(1077, 38, 'gemiste chats', 2, 38),
(1078, 38, 'Toutes les discussions', 3, 36),
(1079, 38, 'Discussions rÃ©centes', 3, 37),
(1080, 38, 'Chats manquÃ©s', 3, 38),
(1081, 38, 'Alle Chats', 4, 36),
(1082, 38, 'Letzte Chats', 4, 37),
(1083, 38, 'Verpasste Chats', 4, 38),
(1084, 38, 'Ð’ÑÐµ Ñ‡Ð°Ñ‚Ñ‹', 5, 36),
(1085, 38, 'ÐÐµÐ´Ð°Ð²Ð½Ð¸Ðµ Ñ‡Ð°Ñ‚Ñ‹', 5, 37),
(1086, 38, 'ÐŸÑ€Ð¾Ð¿ÑƒÑ‰ÐµÐ½Ð½Ñ‹Ðµ Ñ‡Ð°Ñ‚Ñ‹', 5, 38),
(1087, 38, 'Todos los chats', 6, 36),
(1088, 38, 'Chats recientes', 6, 37),
(1089, 38, 'Chat perdido', 6, 38),
(1090, 38, 'Alla chattar', 7, 36),
(1091, 38, 'Senaste chattar', 7, 37),
(1092, 38, 'Missad chatt', 7, 38),
(1093, 38, 'tÃ¼m sohbetler', 8, 36),
(1094, 38, 'son sohbetler', 8, 37),
(1095, 38, 'CevapsÄ±z sohbetler', 8, 38),
(1096, 38, 'Tutte le chat', 9, 36),
(1097, 38, 'Chat recenti', 9, 37),
(1098, 38, 'Chat perse', 9, 38);

-- --------------------------------------------------------

--
-- Table structure for table `avis_language_values`
--

CREATE TABLE `avis_language_values` (
  `language_values_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) DEFAULT '0',
  `variable_id` int(11) DEFAULT '0',
  `description` tinytext,
  `is_custom` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`language_values_id`),
  KEY `language_id` (`language_id`,`variable_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7231 ;

--
-- Dumping data for table `avis_language_values`
--

INSERT INTO `avis_language_values` VALUES
(1, 1, 1, 'Add IP or IP range', 0),
(2, 0, 1, 'Add IP or IP range', 0),
(3, 0, 2, 'Login', 0),
(4, 1, 2, 'Login', 0),
(5, 0, 3, 'Client approval pending', 0),
(6, 1, 3, 'Client approval pending', 0),
(7, 0, 4, 'Forgot password', 0),
(8, 1, 4, 'Forgot password', 0),
(9, 0, 5, 'Register', 0),
(10, 1, 5, 'Register', 0),
(11, 0, 6, 'Solutions', 0),
(12, 1, 6, 'Solutions', 0),
(13, 0, 7, 'Posted by', 0),
(14, 1, 7, 'Posted by', 0),
(15, 0, 8, 'Posted on', 0),
(16, 1, 8, 'Posted on', 0),
(17, 0, 9, 'Incidents', 0),
(18, 1, 9, 'Incidents', 0),
(19, 0, 10, 'Creation date', 0),
(20, 1, 10, 'Creation date', 0),
(21, 0, 11, 'Modified on', 0),
(22, 1, 11, 'Modified on', 0),
(23, 0, 12, 'Data not found', 0),
(24, 1, 12, 'Data not found', 0),
(25, 0, 13, 'Change password', 0),
(26, 1, 13, 'Change password', 0),
(27, 0, 14, 'Old password', 0),
(28, 1, 14, 'Old password', 0),
(29, 0, 15, 'New password', 0),
(30, 1, 15, 'New password', 0),
(31, 0, 16, 'Confirm password', 0),
(32, 1, 16, 'Confirm password', 0),
(33, 0, 17, 'Update', 0),
(34, 1, 17, 'Update', 0),
(35, 0, 18, 'Clear', 0),
(36, 1, 18, 'Clear', 0),
(37, 0, 19, 'Client email address already registered', 0),
(38, 1, 19, 'Client email address already registered', 0),
(39, 0, 20, 'Add contact', 0),
(40, 1, 20, 'Add contact', 0),
(41, 0, 21, 'First name', 0),
(42, 1, 21, 'First name', 0),
(43, 0, 22, 'Last name', 0),
(44, 1, 22, 'Last name', 0),
(45, 0, 23, 'Email', 0),
(46, 1, 23, 'Email', 0),
(47, 0, 24, 'Username', 0),
(48, 1, 24, 'Username', 0),
(49, 0, 25, 'Password', 0),
(50, 1, 25, 'Password', 0),
(51, 0, 26, 'Access', 0),
(52, 1, 26, 'Access', 0),
(53, 0, 27, 'View parent and other sub contact incidents', 0),
(54, 1, 27, 'View parent and other sub contact incidents', 0),
(55, 1, 28, 'Reply parent and other sub contact incidents', 0),
(56, 0, 28, 'Reply parent and other sub contact incidents', 0),
(57, 0, 29, 'Add', 0),
(58, 1, 29, 'Add', 0),
(59, 0, 30, 'Reset', 0),
(60, 1, 30, 'Reset', 0),
(61, 0, 31, 'Custom fields', 0),
(62, 1, 31, 'Custom fields', 0),
(63, 0, 32, 'Submit', 0),
(64, 1, 32, 'Submit', 0),
(65, 0, 33, 'Credit for invoice: ', 0),
(66, 1, 33, 'Credit for invoice: ', 0),
(67, 0, 34, 'Pay now', 0),
(68, 1, 34, 'Pay now', 0),
(69, 0, 35, 'Home', 0),
(70, 1, 35, 'Home', 0),
(71, 0, 36, 'Submit incident', 0),
(72, 1, 36, 'Submit incident', 0),
(73, 0, 37, 'View incidents', 0),
(74, 1, 37, 'View incidents', 0),
(75, 0, 38, 'Purchase', 0),
(76, 1, 38, 'Purchase', 0),
(77, 1, 39, 'My packages', 0),
(78, 0, 39, 'My products', 0),
(79, 0, 40, 'My invoices', 0),
(80, 1, 40, 'My invoices', 0),
(81, 0, 41, 'Search incidents and knowledgebase articles', 0),
(82, 1, 41, 'Search incidents and knowledgebase articles', 0),
(83, 0, 42, 'Search', 0),
(84, 1, 42, 'Search', 0),
(85, 0, 43, 'Profile', 0),
(86, 1, 43, 'Profile', 0),
(87, 0, 44, 'Contacts', 0),
(88, 1, 44, 'Contacts', 0),
(89, 0, 45, 'Logout', 0),
(90, 1, 45, 'Logout', 0),
(91, 0, 46, 'Unpaid', 0),
(92, 1, 46, 'Unpaid', 0),
(93, 0, 47, 'Paid', 0),
(94, 1, 47, 'Paid', 0),
(95, 0, 48, 'Cancelled', 0),
(96, 1, 48, 'Cancelled', 0),
(97, 0, 49, 'In process', 0),
(98, 1, 49, 'In process', 0),
(99, 0, 50, 'Invoice', 0),
(100, 1, 50, 'Invoice', 0),
(101, 0, 51, 'Get PDF', 0),
(102, 1, 51, 'Get PDF', 0),
(103, 0, 52, 'Phone', 0),
(104, 1, 52, 'Phone', 0),
(105, 0, 53, 'Invoice ID', 0),
(106, 1, 53, 'Invoice ID', 0),
(107, 0, 54, 'Due date', 0),
(108, 1, 54, 'Due date', 0),
(109, 0, 55, 'Status', 0),
(110, 1, 55, 'Status', 0),
(111, 0, 56, 'Paid date', 0),
(112, 1, 56, 'Paid date', 0),
(113, 0, 57, 'Description', 0),
(114, 1, 57, 'Description', 0),
(115, 0, 58, 'Amount', 0),
(116, 1, 58, 'Amount', 0),
(117, 0, 59, 'Tax', 0),
(118, 1, 59, 'Tax', 0),
(119, 0, 60, 'Total due', 0),
(120, 1, 60, 'Total due', 0),
(121, 0, 61, 'Transaction ID', 0),
(122, 1, 61, 'Transaction ID', 0),
(123, 0, 62, 'Transaction date', 0),
(124, 1, 62, 'Transaction date', 0),
(125, 0, 63, 'Create date', 0),
(126, 1, 63, 'Create date', 0),
(127, 0, 64, 'Total', 0),
(128, 1, 64, 'Total', 0),
(129, 0, 65, 'Title', 0),
(130, 1, 65, 'Title', 0),
(131, 0, 66, 'Billing cycle', 0),
(132, 1, 66, 'Billing cycle', 0),
(133, 0, 67, 'Expiry date', 0),
(134, 1, 67, 'Expiry date', 0),
(135, 0, 68, 'Validity', 0),
(136, 1, 68, 'Validity', 0),
(137, 0, 69, 'Order now', 0),
(138, 1, 69, 'Order now', 0),
(139, 0, 70, 'Update profile', 0),
(140, 1, 70, 'Update profile', 0),
(141, 0, 71, 'Profile image', 0),
(142, 1, 71, 'Profile image', 0),
(143, 0, 72, 'Upload image', 0),
(144, 1, 72, 'Upload image', 0),
(145, 0, 73, 'Address', 0),
(146, 1, 73, 'Address', 0),
(147, 0, 74, 'City', 0),
(148, 1, 74, 'City', 0),
(149, 0, 75, 'State', 0),
(150, 1, 75, 'State', 0),
(151, 0, 76, 'Zip code', 0),
(152, 1, 76, 'Zip code', 0),
(153, 0, 77, 'Country', 0),
(154, 1, 77, 'Country', 0),
(155, 0, 78, 'Website', 0),
(156, 1, 78, 'Website', 0),
(157, 0, 79, 'Department', 0),
(158, 1, 79, 'Department', 0),
(159, 0, 80, 'Job title', 0),
(160, 1, 80, 'Job title', 0),
(161, 0, 81, 'Company website', 0),
(162, 1, 81, 'Company website', 0),
(163, 0, 82, 'Language', 0),
(164, 1, 82, 'Language', 0),
(165, 0, 83, 'Contact number', 0),
(166, 1, 83, 'Contact number', 0),
(167, 0, 84, 'Image verification', 0),
(168, 1, 84, 'Image verification', 0),
(169, 0, 85, 'Type the two words', 0),
(170, 1, 85, 'Type the two words', 0),
(171, 0, 86, 'Refresh', 0),
(172, 1, 86, 'Refresh', 0),
(173, 0, 87, 'Save', 0),
(174, 1, 87, 'Save', 0),
(175, 0, 88, 'Attachments', 0),
(176, 1, 88, 'Attachments', 0),
(177, 0, 89, 'Rating', 0),
(178, 1, 89, 'Rating', 0),
(179, 0, 90, 'Leave a comment', 0),
(180, 1, 90, 'Leave a comment', 0),
(181, 0, 91, 'Full name', 0),
(182, 1, 91, 'Full name', 0),
(183, 0, 92, 'Suggestion', 0),
(184, 1, 92, 'Suggestion', 0),
(185, 0, 93, 'Answer', 0),
(186, 1, 93, 'Answer', 0),
(187, 0, 94, 'Recent articles', 0),
(188, 1, 94, 'Recent articles', 0),
(189, 0, 95, 'Featured articles', 0),
(190, 1, 95, 'Featured articles', 0),
(191, 0, 96, 'Add article', 0),
(192, 1, 96, 'Add article', 0),
(193, 0, 97, 'Details', 0),
(194, 1, 97, 'Details', 0),
(195, 1, 98, 'Welcome to client support portal', 0),
(196, 0, 98, 'Welcome to client support portal', 0),
(197, 0, 99, 'Update contact', 0),
(198, 1, 99, 'Update contact', 0),
(199, 0, 100, 'Deleting client will delete its all incidents and its data.<br />Are you sure you want to proceed?', 0),
(200, 1, 100, 'Deleting client will delete its all incidents and its data.<br />Are you sure you want to proceed?', 0),
(201, 0, 101, 'Delete', 0),
(202, 1, 101, 'Delete', 0),
(203, 0, 102, 'Company name', 0),
(204, 1, 102, 'Company name', 0),
(205, 0, 103, 'Registration required', 0),
(206, 1, 103, 'Registration required', 0),
(207, 0, 104, 'Incident created successfully', 0),
(208, 1, 104, 'Incident created successfully', 0),
(209, 0, 105, 'Priority', 0),
(210, 1, 105, 'Priority', 0),
(211, 0, 106, 'Type', 0),
(212, 1, 106, 'Type', 0),
(213, 0, 107, 'Subject', 0),
(214, 1, 107, 'Subject', 0),
(215, 0, 108, 'Message', 0),
(216, 1, 108, 'Message', 0),
(217, 0, 109, 'Attach file', 0),
(218, 1, 109, 'Attach file', 0),
(219, 0, 110, 'Edit profile', 0),
(220, 1, 110, 'Edit profile', 0),
(221, 0, 111, 'Banned', 0),
(222, 1, 111, 'Banned', 0),
(223, 0, 112, 'Domain', 0),
(224, 1, 112, 'Domain', 0),
(225, 0, 113, 'Parent', 0),
(226, 1, 113, 'Parent', 0),
(227, 0, 114, 'Organization', 0),
(228, 1, 114, 'Organization', 0),
(229, 0, 115, 'Unsolved', 0),
(230, 1, 115, 'Unsolved', 0),
(231, 0, 116, 'Solved', 0),
(232, 1, 116, 'Solved', 0),
(233, 0, 117, 'Billing', 0),
(234, 1, 117, 'Billing', 0),
(235, 0, 118, 'Amount credit', 0),
(236, 1, 118, 'Amount credit', 0),
(237, 0, 119, 'Category title', 0),
(238, 1, 119, 'Category title', 0),
(239, 0, 120, 'Feedback', 0),
(240, 1, 120, 'Feedback', 0),
(241, 0, 121, 'Created on', 0),
(242, 1, 121, 'Created on', 0),
(243, 0, 122, 'Incident type', 0),
(244, 1, 122, 'Incident type', 0),
(245, 0, 123, 'Assigned to', 0),
(246, 1, 123, 'Assigned to', 0),
(247, 0, 124, 'Resolved', 0),
(248, 1, 124, 'Resolved', 0),
(249, 0, 125, 'Overdue', 0),
(250, 1, 125, 'Overdue', 0),
(251, 0, 126, 'Undue', 0),
(252, 1, 126, 'Undue', 0),
(253, 0, 127, 'Incident details', 0),
(254, 1, 127, 'Incident details', 0),
(255, 0, 128, 'Reply incident', 0),
(256, 1, 128, 'Reply incident', 0),
(257, 1, 129, 'Edit incident', 0),
(258, 0, 129, 'Edit incident', 0),
(259, 0, 130, 'Send feedback', 0),
(260, 1, 130, 'Send feedback', 0),
(261, 0, 131, 'Incident hash', 0),
(262, 1, 131, 'Incident hash', 0),
(263, 0, 132, 'Staff', 0),
(264, 1, 132, 'Staff', 0),
(265, 0, 133, 'Clients', 0),
(266, 1, 133, 'Clients', 0),
(267, 0, 134, 'Change priority', 0),
(268, 1, 134, 'Change priority', 0),
(269, 0, 135, 'Cancel', 0),
(270, 1, 135, 'Cancel', 0),
(271, 0, 136, 'Page', 0),
(272, 1, 136, 'Page', 0),
(273, 0, 137, 'Pending user', 0),
(274, 1, 137, 'Pending user', 0),
(275, 0, 138, 'Release management support', 0),
(276, 1, 138, 'Release management support', 0),
(277, 0, 139, 'Admin type', 0),
(278, 1, 139, 'Admin type', 0),
(279, 0, 140, 'Domain admin', 0),
(280, 1, 140, 'Domain admin', 0),
(281, 0, 141, 'Super admin', 0),
(282, 1, 141, 'Super admin', 0),
(283, 0, 142, 'Admin access', 0),
(284, 1, 142, 'Admin access', 0),
(285, 0, 143, 'Release planning', 0),
(286, 1, 143, 'Release planning', 0),
(287, 0, 144, 'Add staff', 0),
(288, 1, 144, 'Add staff', 0),
(289, 0, 145, 'Delete staff', 0),
(290, 1, 145, 'Delete staff', 0),
(291, 0, 146, 'All staff', 0),
(292, 1, 146, 'All staff', 0),
(293, 0, 147, 'Group name', 0),
(294, 1, 147, 'Group name', 0),
(295, 0, 148, 'Toolbar', 0),
(296, 1, 148, 'Toolbar', 0),
(297, 0, 149, 'Add staff group', 0),
(298, 1, 149, 'Add team', 0),
(299, 0, 150, 'Delete staff group', 0),
(300, 1, 150, 'Delete team', 0),
(301, 0, 151, 'Localization', 0),
(302, 1, 151, 'Localization', 0),
(303, 0, 152, 'Domain access', 0),
(304, 1, 152, 'Domain access', 0),
(305, 0, 153, 'All domains', 0),
(306, 1, 153, 'All domains', 0),
(307, 0, 154, 'Module', 0),
(308, 1, 154, 'Module', 0),
(309, 0, 155, 'System', 0),
(310, 1, 155, 'System', 0),
(311, 0, 156, 'Diagnostics', 0),
(312, 1, 156, 'Diagnostics', 0),
(313, 0, 157, 'Manage', 0),
(314, 1, 157, 'Manage', 0),
(315, 0, 158, 'View only', 0),
(316, 1, 158, 'View only', 0),
(317, 0, 159, 'Delete all', 0),
(318, 1, 159, 'Delete all', 0),
(319, 0, 160, 'Backup', 0),
(320, 1, 160, 'Backup', 0),
(321, 0, 161, 'License', 0),
(322, 1, 161, 'License', 0),
(323, 0, 162, 'License information', 0),
(324, 1, 162, 'License information', 0),
(325, 0, 163, 'List count', 0),
(326, 1, 163, 'List count', 0),
(327, 0, 164, 'Currently active', 0),
(328, 1, 164, 'Currently active', 0),
(329, 0, 165, 'Departments', 0),
(330, 1, 165, 'Departments', 0),
(331, 0, 166, 'Channel', 0),
(332, 1, 166, 'Channel', 0),
(333, 0, 167, 'Flag type', 0),
(334, 1, 167, 'Flag type', 0),
(335, 0, 168, 'Manage all staff', 0),
(336, 1, 168, 'Manage all staff', 0),
(337, 1, 169, 'Manage domain staff', 0),
(338, 0, 169, 'Manage domain staff', 0),
(339, 0, 170, 'Staff group', 0),
(340, 1, 170, 'Staff group', 0),
(341, 0, 171, 'Workflow', 0),
(342, 1, 171, 'Workflow', 0),
(343, 0, 172, 'Add SLA', 0),
(344, 1, 172, 'Add SLA', 0),
(345, 0, 173, 'Schedule', 0),
(346, 1, 173, 'Schedule', 0),
(347, 0, 174, 'Email queue', 0),
(348, 1, 174, 'Email queue', 0),
(349, 0, 175, 'Email templates', 0),
(350, 1, 175, 'Email templates', 0),
(351, 0, 176, 'Custom field', 0),
(352, 1, 176, 'Custom field', 0),
(353, 0, 177, 'Custom field group', 0),
(354, 1, 177, 'Custom field group', 0),
(355, 0, 178, 'Add custom field group', 0),
(356, 1, 178, 'Add custom field group', 0),
(357, 0, 179, 'Delete custom group', 0),
(358, 1, 179, 'Delete custom group', 0),
(359, 0, 180, 'Single login', 0),
(360, 1, 180, 'Single login', 0),
(361, 0, 181, 'Integrations', 0),
(362, 1, 181, 'Integrations', 0),
(363, 1, 182, 'Release build', 0),
(364, 0, 182, 'Release build', 0),
(365, 1, 183, 'Release deployment', 0),
(366, 0, 183, 'Release deployment', 0),
(367, 0, 184, 'Canvas URL', 0),
(368, 1, 184, 'Canvas URL', 0),
(369, 0, 185, 'Error log', 0),
(370, 1, 185, 'Error log', 0),
(371, 0, 186, 'Delete error log', 0),
(372, 1, 186, 'Delete error log', 0),
(373, 0, 187, 'Exception log', 0),
(374, 1, 187, 'Exception log', 0),
(375, 0, 188, 'Parser log', 0),
(376, 1, 188, 'Parser log', 0),
(377, 0, 189, 'Empty parser log', 0),
(378, 1, 189, 'Empty parser log', 0),
(379, 0, 190, 'Delete parser log', 0),
(380, 1, 190, 'Delete parser log', 0),
(381, 0, 191, 'Sendmail log', 0),
(382, 1, 191, 'Sendmail log', 0),
(383, 1, 192, 'Early life support or monitoring', 0),
(384, 0, 192, 'Early life support or monitoring', 0),
(385, 0, 193, 'API access', 0),
(386, 1, 193, 'API access', 0),
(387, 0, 194, 'Logs', 0),
(388, 1, 194, 'Logs', 0),
(389, 0, 195, 'Error', 0),
(390, 1, 195, 'Error', 0),
(391, 0, 196, 'Parser', 0),
(392, 1, 196, 'Parser', 0),
(393, 0, 197, 'Automation', 0),
(394, 1, 197, 'Automation', 0),
(395, 0, 198, 'Send email', 0),
(396, 1, 198, 'Send email', 0),
(397, 0, 199, 'Audit log', 0),
(398, 1, 199, 'Audit log', 0),
(399, 0, 200, 'History', 0),
(400, 1, 200, 'History', 0),
(401, 0, 201, 'Invoices', 0),
(402, 1, 201, 'Invoices', 0),
(403, 0, 202, 'Export to PDF', 0),
(404, 1, 202, 'Export to PDF', 0),
(405, 0, 203, 'Export', 0),
(406, 1, 203, 'Export', 0),
(407, 0, 204, 'Add alert', 0),
(408, 1, 204, 'Add alert', 0),
(409, 0, 205, 'Delete alert', 0),
(410, 1, 205, 'Delete alert', 0),
(411, 0, 206, 'Email template', 0),
(412, 1, 206, 'Email template', 0),
(413, 0, 207, 'All incidents', 0),
(414, 1, 207, 'All incidents', 0),
(415, 0, 208, 'New incidents', 0),
(416, 1, 208, 'New incidents', 0),
(417, 0, 209, 'Overdue incidents', 0),
(418, 1, 209, 'Overdue incidents', 0),
(419, 0, 210, 'Assigned incidents', 0),
(420, 1, 210, 'Assigned incidents', 0),
(421, 0, 211, 'Read', 0),
(422, 1, 211, 'Read', 0),
(423, 0, 212, 'Unread', 0),
(424, 1, 212, 'Unread', 0),
(425, 0, 213, 'Labels', 0),
(426, 1, 213, 'Labels', 0),
(427, 0, 214, 'Event', 0),
(428, 1, 214, 'Event', 0),
(429, 0, 215, 'Staff reply', 0),
(430, 1, 215, 'Staff reply', 0),
(431, 0, 216, 'Flag change', 0),
(432, 1, 216, 'Flag change', 0),
(433, 0, 217, 'Incident type change', 0),
(434, 1, 217, 'Incident type change', 0),
(435, 0, 218, 'Department change', 0),
(436, 1, 218, 'Department change', 0),
(437, 0, 219, 'Edit client', 0),
(438, 1, 219, 'Edit client', 0),
(439, 0, 220, 'Delete client', 0),
(440, 1, 220, 'Delete client', 0),
(441, 0, 221, 'Incident department change', 0),
(442, 1, 221, 'Incident department change', 0),
(443, 0, 222, 'Incident status change', 0),
(444, 1, 222, 'Incident status change', 0),
(445, 0, 223, 'Incident priority change', 0),
(446, 1, 223, 'Incident priority change', 0),
(447, 0, 224, 'Incident merge', 0),
(448, 1, 224, 'Incident merge', 0),
(449, 0, 225, 'Add note', 0),
(450, 1, 225, 'Add note', 0),
(451, 0, 226, 'Delete note', 0),
(452, 1, 226, 'Delete note', 0),
(453, 0, 227, 'Note add', 0),
(454, 1, 227, 'Note add', 0),
(455, 0, 228, 'Note type', 0),
(456, 1, 228, 'Note type', 0),
(457, 0, 229, 'Billing invoice add', 0),
(458, 1, 229, 'Billing invoice add', 0),
(459, 0, 230, 'Incident post delete', 0),
(460, 1, 230, 'Incident post delete', 0),
(461, 0, 231, 'Incident delete', 0),
(462, 1, 231, 'Incident delete', 0),
(463, 0, 232, 'Move to trash', 0),
(464, 1, 232, 'Move to trash', 0),
(465, 0, 233, 'Criteria', 0),
(466, 1, 233, 'Criteria', 0),
(467, 0, 234, 'Match any criteria', 0),
(468, 1, 234, 'Match any criteria', 0),
(469, 0, 235, 'Match all criteria', 0),
(470, 1, 235, 'Match all criteria', 0),
(471, 0, 236, 'Add criteria', 0),
(472, 1, 236, 'Add criteria', 0),
(473, 0, 237, 'Filters', 0),
(474, 1, 237, 'Filters', 0),
(475, 0, 238, 'Match criteria', 0),
(476, 1, 238, 'Match criteria', 0),
(477, 0, 239, 'Save as filter', 0),
(478, 1, 239, 'Save as filter', 0),
(479, 0, 240, 'Save as draft', 0),
(480, 1, 240, 'Save as draft', 0),
(481, 0, 241, 'Incident note', 0),
(482, 1, 241, 'Incident note', 0),
(483, 0, 242, 'Client note', 0),
(484, 1, 242, 'Client note', 0),
(485, 0, 243, 'Incident comment', 0),
(486, 1, 243, 'Incident comment', 0),
(487, 0, 244, 'Client name', 0),
(488, 1, 244, 'Client name', 0),
(489, 0, 245, 'Client email', 0),
(490, 1, 245, 'Client email', 0),
(491, 0, 246, 'Last activity', 0),
(492, 1, 246, 'Last activity', 0),
(493, 0, 247, 'SLA plan', 0),
(494, 1, 247, 'SLA plan', 0),
(495, 0, 248, 'Has attachment', 0),
(496, 1, 248, 'Has attachment', 0),
(497, 0, 249, 'Billing note', 0),
(498, 1, 249, 'Billing note', 0),
(499, 0, 250, 'Add billing note', 0),
(500, 1, 250, 'Add billing note', 0),
(501, 0, 251, 'Contain', 0),
(502, 1, 251, 'Contain', 0),
(503, 0, 252, 'Does not contain', 0),
(504, 1, 252, 'Does not contain', 0),
(505, 0, 253, 'Equal', 0),
(506, 1, 253, 'Equal', 0),
(507, 0, 254, 'Not equal', 0),
(508, 1, 254, 'Not equal', 0),
(509, 0, 255, 'Less than', 0),
(510, 1, 255, 'Less than ', 0),
(511, 0, 256, 'Greater than', 0),
(512, 1, 256, 'Greater than', 0),
(513, 0, 257, 'TRUE', 0),
(514, 1, 257, 'TRUE', 0),
(515, 0, 258, 'Alerts', 0),
(516, 1, 258, 'Alerts', 0),
(517, 0, 259, 'Views', 0),
(518, 1, 259, 'Views', 0),
(519, 0, 260, 'Incident count by category', 0),
(520, 1, 260, 'Incident count by category', 0),
(521, 0, 261, 'Client', 0),
(522, 1, 261, 'Client', 0),
(523, 0, 262, 'Operation', 0),
(524, 1, 262, 'Operation', 0),
(525, 0, 263, 'Date time', 0),
(526, 1, 263, 'Date time', 0),
(527, 0, 264, 'Date', 0),
(528, 1, 264, 'Date', 0),
(529, 0, 265, 'Operator', 0),
(530, 1, 265, 'Operator', 0),
(531, 0, 266, 'Add credit', 0),
(532, 1, 266, 'Add credit', 0),
(533, 0, 267, 'Preferences', 0),
(534, 1, 267, 'Preferences ', 0),
(535, 0, 268, 'Billing method', 0),
(536, 1, 268, 'Billing method', 0),
(537, 0, 269, 'Incident base', 0),
(538, 1, 269, 'Incident base', 0),
(539, 0, 270, 'Time base', 0),
(540, 1, 270, 'Time base', 0),
(541, 0, 271, 'Bill rate', 0),
(542, 1, 271, 'Bill rate', 0),
(543, 0, 272, 'Currency', 0),
(544, 1, 272, 'Currency', 0),
(545, 0, 273, 'On incident create', 0),
(546, 1, 273, 'On incident create', 0),
(547, 0, 274, 'Do not generate invoice', 0),
(548, 1, 274, 'Do not generate invoice', 0),
(549, 0, 275, 'Generate invoice', 0),
(550, 1, 275, 'Generate invoice', 0),
(551, 0, 276, 'Generate and send invoice', 0),
(552, 1, 276, 'Generate and send invoice', 0),
(553, 0, 277, 'Credit required', 0),
(554, 1, 277, 'Credit required', 0),
(555, 0, 278, 'Minutes', 0),
(556, 1, 278, 'Minutes', 0),
(557, 0, 279, 'Taxable', 0),
(558, 1, 279, 'Taxable', 0),
(559, 0, 280, 'Collapse setting', 0),
(560, 1, 280, 'Collapse setting', 0),
(561, 0, 281, 'Tax rule', 0),
(562, 1, 281, 'Tax rule', 0),
(563, 0, 282, 'View invoice', 0),
(564, 1, 282, 'View invoice', 0),
(565, 0, 283, 'Todays due', 0),
(566, 1, 283, 'Today ''s due', 0),
(567, 0, 284, 'Todays paid', 0),
(568, 1, 284, 'Today ''s paid', 0),
(569, 0, 285, 'Today', 0),
(570, 1, 285, 'Today', 0),
(571, 0, 286, 'Month', 0),
(572, 1, 286, 'Month', 0),
(573, 0, 287, 'Billing URL', 0),
(574, 1, 287, 'Billing URL', 0),
(575, 0, 288, 'Admin username', 0),
(576, 1, 288, 'Admin username', 0),
(577, 0, 289, 'Admin password', 0),
(578, 1, 289, 'Admin password', 0),
(579, 0, 290, 'Empty mobile error log', 0),
(580, 1, 290, 'Empty mobile error log', 0),
(581, 0, 291, 'Delete mobile log', 0),
(582, 1, 291, 'Delete mobile log', 0),
(583, 0, 292, 'Add blab', 0),
(584, 1, 292, 'Add blab', 0),
(585, 0, 293, 'Trends', 0),
(586, 1, 293, 'Trends', 0),
(587, 0, 294, 'Add image', 0),
(588, 1, 294, 'Add image', 0),
(589, 1, 295, 'Add video', 0),
(590, 0, 295, 'Add video', 0),
(591, 1, 296, 'Share with', 0),
(592, 0, 296, 'Share with', 0),
(593, 0, 297, 'Mobile error log', 0),
(594, 1, 297, 'Mobile error log', 0),
(595, 0, 298, 'View blabs', 0),
(596, 1, 298, 'View blabs', 0),
(597, 0, 299, 'Add to blab', 0),
(598, 1, 299, 'Add to blab', 0),
(599, 0, 300, 'Blab count', 0),
(600, 1, 300, 'Blab count', 0),
(601, 0, 301, 'Remove from list', 0),
(602, 1, 301, 'Remove from list', 0),
(603, 0, 302, 'Delete blab', 0),
(604, 1, 302, 'Delete blab', 0),
(605, 0, 303, 'Break line', 0),
(606, 1, 303, 'Break line', 0),
(607, 0, 304, 'Add breakline', 0),
(608, 1, 304, 'Add breakline', 0),
(609, 0, 305, 'Delete breakline', 0),
(610, 1, 305, 'Delete breakline', 0),
(611, 0, 306, 'Execution order', 0),
(612, 1, 306, 'Execution order', 0),
(613, 0, 307, 'Regular expression', 0),
(614, 1, 307, 'Regular expression', 0),
(615, 0, 308, 'Add task', 0),
(616, 1, 308, 'Add task', 0),
(617, 0, 309, 'Delete task', 0),
(618, 1, 309, 'Delete task', 0),
(619, 0, 310, 'Calendar', 0),
(620, 1, 310, 'Calendar', 0),
(621, 0, 311, 'Start date', 0),
(622, 1, 311, 'Start date', 0),
(623, 0, 312, 'Planned', 0),
(624, 1, 312, 'Planned', 0),
(625, 0, 313, 'Completed', 0),
(626, 1, 313, 'Completed', 0),
(627, 0, 314, 'In progress', 0),
(628, 1, 314, 'In progress', 0),
(629, 0, 315, 'Not started', 0),
(630, 1, 315, 'Not started', 0),
(631, 0, 316, 'Task type', 0),
(632, 1, 316, 'Task type', 0),
(633, 0, 317, 'Personal', 0),
(634, 1, 317, 'Personal', 0),
(635, 1, 318, 'Business', 0),
(636, 0, 318, 'Business', 0),
(637, 0, 319, 'Important', 0),
(638, 1, 319, 'Important', 0),
(639, 0, 320, 'Label', 0),
(640, 1, 320, 'Label', 0),
(641, 0, 321, 'High', 0),
(642, 1, 321, 'High', 0),
(643, 0, 322, 'Low', 0),
(644, 1, 322, 'Low', 0),
(645, 0, 323, 'Tasks', 0),
(646, 1, 323, 'Tasks', 0),
(647, 0, 324, 'Incident queues', 0),
(648, 1, 324, 'Incident queues', 0),
(649, 0, 325, 'Filter queues', 0),
(650, 1, 325, 'Filter queues', 0),
(651, 0, 326, 'Folders', 0),
(652, 1, 326, 'Folders', 0),
(653, 0, 327, 'Select department', 0),
(654, 1, 327, 'Select department', 0),
(655, 0, 328, 'Select domain', 0),
(656, 1, 328, 'Select domain', 0),
(657, 0, 329, 'Add channel', 0),
(658, 1, 329, 'Add channel', 0),
(659, 0, 330, 'Channel image', 0),
(660, 1, 330, 'Channel image', 0),
(661, 0, 331, 'Add language', 0),
(662, 1, 331, 'Add language', 0),
(663, 0, 332, 'Update language', 0),
(664, 1, 332, 'Update language', 0),
(665, 0, 333, 'Delete language', 0),
(666, 1, 333, 'Delete language', 0),
(667, 0, 334, 'PHP information', 0),
(668, 1, 334, 'PHP information', 0),
(669, 0, 335, 'Add client', 0),
(670, 1, 335, 'Add client', 0),
(671, 0, 336, 'Manage contact', 0),
(672, 1, 336, 'Manage contact', 0),
(673, 0, 337, 'Action', 0),
(674, 1, 337, 'Action', 0),
(675, 0, 338, 'Initials', 0),
(676, 1, 338, 'Initials', 0),
(677, 0, 339, 'Gender', 0),
(678, 1, 339, 'Gender', 0),
(679, 0, 340, 'Male', 0),
(680, 1, 340, 'Male', 0),
(681, 0, 341, 'Female', 0),
(682, 1, 341, 'Female', 0),
(683, 0, 342, 'Permanent address', 0),
(684, 1, 342, 'Permanent address', 0),
(685, 0, 343, 'Current address', 0),
(686, 1, 343, 'Current address', 0),
(687, 0, 344, 'Company email', 0),
(688, 1, 344, 'Company email', 0),
(689, 0, 345, 'New service request created', 0),
(690, 1, 345, 'New service request created', 0),
(691, 0, 346, 'Release closure', 0),
(692, 1, 346, 'Release closure', 0),
(693, 0, 347, 'Company fax', 0),
(694, 1, 347, 'Company fax', 0),
(695, 0, 348, 'Company address', 0),
(696, 1, 348, 'Company address', 0),
(697, 0, 349, 'Netmeeting ID', 0),
(698, 1, 349, 'Netmeeting ID', 0),
(699, 0, 350, 'Other IM', 0),
(700, 1, 350, 'Other IM', 0),
(701, 0, 351, 'Other contact', 0),
(702, 1, 351, 'Other contact', 0),
(703, 0, 352, 'Other fax', 0),
(704, 1, 352, 'Other fax', 0),
(705, 0, 353, 'Create invoice', 0),
(706, 1, 353, 'Create invoice', 0),
(707, 0, 354, 'Delete invoice', 0),
(708, 1, 354, 'Delete invoice', 0),
(709, 0, 355, 'Paid department', 0),
(710, 1, 355, 'Paid department', 0),
(711, 0, 356, 'Registered', 0),
(712, 1, 356, 'Registered', 0),
(713, 0, 357, 'Unregistered', 0),
(714, 1, 357, 'Unregistered', 0),
(715, 0, 358, 'Ban', 0),
(716, 1, 358, 'Ban', 0),
(717, 0, 359, 'Ban client', 0),
(718, 1, 359, 'Ban client', 0),
(719, 0, 360, 'Remove ban', 0),
(720, 1, 360, 'Remove ban', 0),
(721, 1, 361, 'Spammer', 0),
(722, 0, 361, 'Spammer', 0),
(723, 0, 362, 'Not spam', 0),
(724, 1, 362, 'Not spam', 0),
(725, 0, 363, 'Mark spam', 0),
(726, 1, 363, 'Mark spam', 0),
(727, 1, 364, 'Ban and delete', 0),
(728, 0, 364, 'Ban and delete', 0),
(729, 1, 365, 'Email notifications', 0),
(730, 0, 365, 'Email notifications', 0),
(731, 0, 366, 'Incident', 0),
(732, 1, 366, 'Incident', 0),
(733, 0, 367, 'Reply', 0),
(734, 1, 367, 'Reply', 0),
(735, 0, 368, 'Reply all', 0),
(736, 1, 368, 'Reply all', 0),
(737, 0, 369, 'Forward', 0),
(738, 1, 369, 'Forward', 0),
(739, 0, 370, 'Send reply', 0),
(740, 1, 370, 'Send reply', 0),
(741, 0, 371, 'Delete incident', 0),
(742, 1, 371, 'Delete incident', 0),
(743, 0, 372, 'Merge incident', 0),
(744, 1, 372, 'Merge incident', 0),
(745, 0, 373, 'Delete incident properties', 0),
(746, 1, 373, 'Delete incident properties', 0),
(747, 0, 374, 'Change properties', 0),
(748, 1, 374, 'Change properties', 0),
(749, 0, 375, 'Delete incident post', 0),
(750, 1, 375, 'Delete incident post', 0),
(751, 0, 376, 'Edit incident post', 0),
(752, 1, 376, 'Edit incident post', 0),
(753, 0, 377, 'Set due time', 0),
(754, 1, 377, 'Set due time', 0),
(755, 0, 378, 'Recipients', 0),
(756, 1, 378, 'Recipients', 0),
(757, 0, 379, 'Discard', 0),
(758, 1, 379, 'Discard', 0),
(759, 0, 380, 'Ascending', 0),
(760, 1, 380, 'Ascending', 0),
(761, 0, 381, 'Descending', 0),
(762, 1, 381, 'Descending', 0),
(763, 0, 382, 'View note', 0),
(764, 1, 382, 'View note', 0),
(765, 0, 383, 'Manage note', 0),
(766, 1, 383, 'Manage note', 0),
(767, 0, 384, 'Open new incident', 0),
(768, 1, 384, 'Open new incident', 0),
(769, 0, 385, 'Forward incident', 0),
(770, 1, 385, 'Forward incident', 0),
(771, 0, 386, 'Self assigned', 0),
(772, 1, 386, 'Self assigned', 0),
(773, 1, 387, 'Unassigned', 0),
(774, 0, 387, 'Unassigned', 0),
(775, 0, 388, 'Assigned', 0),
(776, 1, 388, 'Assigned', 0),
(777, 0, 389, 'Move to', 0),
(778, 1, 389, 'Move to', 0),
(779, 1, 390, 'Nobody and self assigned', 0),
(780, 0, 390, 'Unassigned and self assigned', 0),
(781, 0, 391, 'Overdue time', 0),
(782, 1, 391, 'Overdue time', 0),
(783, 0, 392, 'New', 0),
(784, 1, 392, 'New', 0),
(785, 0, 393, 'Note', 0),
(786, 1, 393, 'Note', 0),
(787, 0, 394, 'From', 0),
(788, 1, 394, 'From', 0),
(789, 0, 395, 'Incident ID', 0),
(790, 1, 395, 'Incident ID', 0),
(791, 0, 396, 'Incident priority', 0),
(792, 1, 396, 'Incident priority', 0),
(793, 0, 397, 'Incident status', 0),
(794, 1, 397, 'Incident status', 0),
(795, 0, 398, 'Add status', 0),
(796, 1, 398, 'Add status', 0),
(797, 0, 399, 'Delete incident status', 0),
(798, 1, 399, 'Delete incident status', 0),
(799, 0, 400, 'Incident created on', 0),
(800, 1, 400, 'Incident created on', 0),
(801, 0, 401, 'Incident modified on', 0),
(802, 1, 401, 'Incident modified on', 0),
(803, 0, 402, 'Resolve time', 0),
(804, 1, 402, 'Resolve time', 0),
(805, 0, 403, 'Linked tickets, problems,etc are not closed. Do you still want to proceed?', 0),
(806, 1, 403, 'Linked tickets, problems,etc are not closed. Do you still want to proceed?', 0),
(807, 0, 404, 'Incident post count', 0),
(808, 1, 404, 'Incident post count', 0),
(809, 0, 405, 'Client first name', 0),
(810, 1, 405, 'Client first name', 0),
(811, 0, 406, 'Client last name', 0),
(812, 1, 406, 'Client last name', 0),
(813, 0, 407, 'Client contact', 0),
(814, 1, 407, 'Client contact', 0),
(815, 0, 408, 'Client company', 0),
(816, 1, 408, 'Client company', 0),
(817, 1, 409, 'Client job title', 0),
(818, 0, 409, 'Client job title', 0),
(819, 0, 410, 'Client state', 0),
(820, 1, 410, 'Client state', 0),
(821, 0, 411, 'Client city', 0),
(822, 1, 411, 'Client city', 0),
(823, 0, 412, 'Client zip code', 0),
(824, 1, 412, 'Client zip code', 0),
(825, 0, 413, 'Client country', 0),
(826, 1, 413, 'Client country', 0),
(827, 0, 414, 'Is spam client', 0),
(828, 1, 414, 'Is spam client', 0),
(829, 0, 415, 'Is banned client', 0),
(830, 1, 415, 'Is banned client', 0),
(831, 0, 416, 'Client paid invoice count', 0),
(832, 1, 416, 'Client paid invoice count', 0),
(833, 1, 417, 'Client unpaid invoice count', 0),
(834, 0, 417, 'Client unpaid invoice count', 0),
(835, 0, 418, 'Staff first name', 0),
(836, 1, 418, 'Staff first name', 0),
(837, 0, 419, 'Staff last name', 0),
(838, 1, 419, 'Staff last name', 0),
(839, 0, 420, 'Staff email', 0),
(840, 1, 420, 'Staff email', 0),
(841, 1, 421, 'Staff job title', 0),
(842, 0, 421, 'Staff job title', 0),
(843, 0, 422, 'AVG. response time', 0),
(844, 1, 422, 'AVG. response time', 0),
(845, 0, 423, 'Total responses', 0),
(846, 1, 423, 'Total responses', 0),
(847, 0, 424, 'Staff group access', 0),
(848, 1, 424, 'Team access', 0),
(849, 0, 425, 'Staff list', 0),
(850, 1, 425, 'Staff list', 0),
(851, 0, 426, 'Back', 0),
(852, 1, 426, 'Back', 0),
(853, 0, 427, 'Incident autoclose time', 0),
(854, 1, 427, 'Incident autoclose time', 0),
(855, 0, 428, 'Incident average response time', 0),
(856, 1, 428, 'Incident average response time', 0),
(857, 0, 429, 'Incident follow up count', 0),
(858, 1, 429, 'Incident follow up count', 0),
(859, 0, 430, 'Incident IP address', 0),
(860, 1, 430, 'Incident IP address', 0),
(861, 0, 431, 'Incident is resolved', 0),
(862, 1, 431, 'Incident is resolved', 0),
(863, 0, 432, 'Incident reply to', 0),
(864, 1, 432, 'Incident reply to', 0),
(865, 0, 433, 'Incident time worked', 0),
(866, 1, 433, 'Incident time worked', 0),
(867, 0, 434, 'Incident total replies', 0),
(868, 1, 434, 'Incident total replies', 0),
(869, 1, 435, 'SLA overdue hours', 0),
(870, 0, 435, 'SLA overdue hours', 0),
(871, 1, 436, 'SLA plan resolution due hours', 0),
(872, 0, 436, 'SLA plan resolution due hours', 0),
(873, 0, 437, 'Linked changes are not closed. Do you still want to proceed?', 0),
(874, 1, 437, 'Linked changes are not closed. Do you still want to proceed?', 0),
(875, 0, 438, 'Number of attachments', 0),
(876, 1, 438, 'Number of attachments', 0),
(877, 0, 439, 'Allowed attachment extensions', 0),
(878, 1, 439, 'Allowed attachment extensions', 0),
(879, 0, 440, 'Max allowed size for attachment (in KB)', 0),
(880, 1, 440, 'Max allowed size for attachment (in KB)', 0),
(881, 0, 441, 'Add merged incident''s email as recipients', 0),
(882, 1, 441, 'Add merged incident''s email as recipients', 0),
(883, 0, 442, 'Visible to client', 0),
(884, 1, 442, 'Visible to client', 0),
(885, 0, 443, 'Fields available', 0),
(886, 1, 443, 'Fields available', 0),
(887, 0, 444, 'Fields selected', 0),
(888, 1, 444, 'Fields selected', 0),
(889, 0, 445, 'Last replier', 0),
(890, 1, 445, 'Last replier', 0),
(891, 0, 446, 'Add view', 0),
(892, 1, 446, 'Add view', 0),
(893, 0, 447, 'Delete view', 0),
(894, 1, 447, 'Delete view', 0),
(895, 0, 448, 'Summary', 0),
(896, 1, 448, 'Summary', 0),
(897, 0, 449, 'Personal details', 0),
(898, 1, 449, 'Personal details', 0),
(899, 0, 450, 'Home details', 0),
(900, 1, 450, 'Home details', 0),
(901, 0, 451, 'Company details', 0),
(902, 1, 451, 'Company details', 0),
(903, 0, 452, 'Add domain', 0),
(904, 1, 452, 'Add domain', 0),
(905, 0, 453, 'Update domain', 0),
(906, 1, 453, 'Update domain', 0),
(907, 0, 454, 'Domain name', 0),
(908, 1, 454, 'Domain name', 0),
(909, 0, 455, 'Delete domain', 0),
(910, 1, 455, 'Delete domain', 0),
(911, 0, 456, 'Add department', 0),
(912, 1, 456, 'Add department', 0),
(913, 0, 457, 'Update department', 0),
(914, 1, 457, 'Update department', 0),
(915, 0, 458, 'Delete department', 0),
(916, 1, 458, 'Delete department', 0),
(917, 0, 459, 'Is paid', 0),
(918, 1, 459, 'Is paid', 0),
(919, 0, 460, 'Autoresponder', 0),
(920, 1, 460, 'Autoresponder', 0),
(921, 0, 461, 'Auto responder signature', 0),
(922, 1, 461, 'Auto responder signature', 0),
(923, 0, 462, 'Domain URL', 0),
(924, 1, 462, 'Domain URL', 0),
(925, 0, 463, 'Set', 0),
(926, 1, 463, 'Set', 0),
(927, 0, 464, 'Client portal URL', 0),
(928, 1, 464, 'Client portal URL', 0),
(929, 0, 465, 'Default email', 0),
(930, 1, 465, 'Default email', 0),
(931, 0, 466, 'Default client portal language', 0),
(932, 1, 466, 'Default client portal language', 0),
(933, 1, 467, 'Client portal theme', 0),
(934, 0, 467, 'Client portal theme', 0),
(935, 0, 468, 'Client portal', 0),
(936, 1, 468, 'Client portal', 0),
(937, 0, 469, 'Update client portal', 0),
(938, 1, 469, 'Update client portal', 0),
(939, 0, 470, 'Outgoing email', 0),
(940, 1, 470, 'Outgoing email', 0),
(941, 0, 471, 'Timezone', 0),
(942, 1, 471, 'Timezone', 0),
(943, 0, 472, 'Chain of approvals', 0),
(944, 1, 472, 'Chain of approvals', 0),
(945, 0, 473, 'Auto approve registration', 0),
(946, 1, 473, 'Auto approve registration', 0),
(947, 0, 474, 'Enable captcha on register', 0),
(948, 1, 474, 'Enable captcha on register', 0),
(949, 0, 475, 'Approve', 0),
(950, 1, 475, 'Approve', 0),
(951, 0, 476, 'Disapproved', 0),
(952, 1, 476, 'Disapproved', 0),
(953, 0, 477, 'Pin', 0),
(954, 1, 477, 'Pin', 0),
(955, 0, 478, 'Login as client', 0),
(956, 1, 478, 'Login as client', 0),
(957, 0, 479, 'Create incident', 0),
(958, 1, 479, 'Create incident', 0),
(959, 0, 480, 'Group type', 0),
(960, 1, 480, 'Group type', 0),
(961, 0, 481, 'User registration', 0),
(962, 1, 481, 'User registration', 0),
(963, 0, 482, 'User incident creation', 0),
(964, 1, 482, 'User incident creation', 0),
(965, 0, 483, 'Staff incident creation', 0),
(966, 1, 483, 'Staff incident creation', 0),
(967, 0, 484, 'Department access', 0),
(968, 1, 484, 'Department access', 0),
(969, 0, 485, 'All departments', 0),
(970, 1, 485, 'All departments', 0),
(971, 0, 486, 'Add incident type', 0),
(972, 1, 486, 'Add incident type', 0),
(973, 0, 487, 'Delete incident type', 0),
(974, 1, 487, 'Delete incident type', 0),
(975, 0, 488, 'Fields', 0),
(976, 1, 488, 'Fields', 0),
(977, 0, 489, 'Field details', 0),
(978, 1, 489, 'Field details', 0),
(979, 0, 490, 'Field title', 0),
(980, 1, 490, 'Field title', 0),
(981, 0, 491, 'Default value', 0),
(982, 1, 491, 'Default value', 0),
(983, 0, 492, 'Field description', 0),
(984, 1, 492, 'Field description', 0),
(985, 0, 493, 'Is required', 0),
(986, 1, 493, 'Is required', 0),
(987, 0, 494, 'User editable', 0),
(988, 1, 494, 'User editable', 0),
(989, 0, 495, 'Staff editable', 0),
(990, 1, 495, 'Staff editable', 0),
(991, 0, 496, 'Numeric', 0),
(992, 1, 496, 'Numeric', 0),
(993, 0, 497, 'Alphabetic', 0),
(994, 1, 497, 'Alphabetic', 0),
(995, 0, 498, 'Alphanumeric', 0),
(996, 1, 498, 'Alphanumeric', 0),
(997, 0, 499, 'Option fields', 0),
(998, 1, 499, 'Option fields', 0),
(999, 0, 500, 'Add custom field', 0),
(1000, 1, 500, 'Add custom field', 0),
(1001, 0, 501, 'Delete custom field', 0),
(1002, 1, 501, 'Delete custom field', 0),
(1003, 0, 502, 'Customizations', 0),
(1004, 1, 502, 'Customizations', 0),
(1005, 0, 503, 'HTML tags', 0),
(1006, 1, 503, 'HTML tags', 0),
(1007, 0, 504, 'Text box', 0),
(1008, 1, 504, 'Text box', 0),
(1009, 0, 505, 'Text area', 0),
(1010, 1, 505, 'Text area', 0),
(1011, 1, 506, 'Checkbox', 0),
(1012, 0, 506, 'Checkbox', 0),
(1013, 1, 507, 'Radio', 0),
(1014, 0, 507, 'Radio', 0),
(1015, 0, 508, 'Select multiple', 0),
(1016, 1, 508, 'Select multiple', 0),
(1017, 0, 509, 'File', 0),
(1018, 1, 509, 'File', 0),
(1019, 0, 510, 'Regular expression validation', 0),
(1020, 1, 510, 'Regular expression validation', 0),
(1021, 0, 511, 'Add email template', 0),
(1022, 1, 511, 'Add email template', 0),
(1023, 0, 512, 'Delete email template', 0),
(1024, 1, 512, 'Delete email template', 0),
(1025, 0, 513, 'Add flag', 0),
(1026, 1, 513, 'Add flag', 0),
(1027, 0, 514, 'Delete flag', 0),
(1028, 1, 514, 'Delete flag', 0),
(1029, 0, 515, 'Flag name', 0),
(1030, 1, 515, 'Flag name', 0),
(1031, 0, 516, 'Flag color', 0),
(1032, 1, 516, 'Flag color', 0),
(1033, 0, 517, 'File name', 0),
(1034, 1, 517, 'File name', 0),
(1035, 0, 518, 'Language code', 0),
(1036, 1, 518, 'Language code', 0),
(1037, 0, 519, 'Character set', 0),
(1038, 1, 519, 'Character set', 0),
(1039, 0, 520, 'Code', 0),
(1040, 1, 520, 'Code', 0),
(1041, 0, 521, 'Right to left', 0),
(1042, 1, 521, 'Right to left', 0),
(1043, 0, 522, 'Left panel view', 0),
(1044, 1, 522, 'Left panel view', 0),
(1045, 0, 523, 'Sent email', 0),
(1046, 1, 523, 'Sent email', 0),
(1047, 0, 524, 'Toggle left panel', 0),
(1048, 1, 524, 'Toggle left panel', 0),
(1049, 0, 525, 'Settings', 0),
(1050, 1, 525, 'Settings', 0),
(1051, 0, 526, 'Pinned items', 0),
(1052, 1, 526, 'Pinned items', 0),
(1053, 0, 527, 'Quick view', 0),
(1054, 1, 527, 'Quick view', 0),
(1055, 0, 528, 'Mail queues', 0),
(1056, 1, 528, 'Mail queues', 0),
(1057, 0, 529, 'Add email queue', 0),
(1058, 1, 529, 'Add email queue', 0),
(1059, 0, 530, 'Delete mailqueue', 0),
(1060, 1, 530, 'Delete mailqueue', 0),
(1061, 0, 531, 'Fetch type', 0),
(1062, 1, 531, 'Fetch type', 0),
(1063, 0, 532, 'Login information', 0),
(1064, 1, 532, 'Login information', 0),
(1065, 0, 533, 'Host name', 0),
(1066, 1, 533, 'Host name', 0),
(1067, 0, 534, 'Table prefix', 0),
(1068, 1, 534, 'Table prefix', 0),
(1069, 0, 535, 'Port', 0),
(1070, 1, 535, 'Port', 0),
(1071, 0, 536, 'SSL type', 0),
(1072, 1, 536, 'SSL type', 0),
(1073, 0, 537, 'SMTP authentication', 0),
(1074, 1, 537, 'SMTP authentication', 0),
(1075, 0, 538, 'Leave a copy on server', 0),
(1076, 1, 538, 'Leave a copy on server', 0),
(1077, 0, 539, 'Queue title', 0),
(1078, 1, 539, 'Queue title', 0),
(1079, 0, 540, 'From name', 0),
(1080, 1, 540, 'From name', 0),
(1081, 0, 541, 'From email', 0),
(1082, 1, 541, 'From email', 0),
(1083, 0, 542, 'Queue setting', 0),
(1084, 1, 542, 'Queue setting', 0),
(1085, 0, 543, 'Signature', 0),
(1086, 1, 543, 'Signature', 0),
(1087, 0, 544, 'Comment submitted', 0),
(1088, 1, 544, 'Comment submitted', 0),
(1089, 0, 545, 'Release planner', 0),
(1090, 1, 545, 'Release planner', 0),
(1091, 0, 546, 'Categories', 0),
(1092, 1, 546, 'Categories', 0),
(1093, 0, 547, 'Comments', 0),
(1094, 1, 547, 'Comments', 0),
(1095, 0, 548, 'Article', 0),
(1096, 1, 548, 'Article', 0),
(1097, 0, 549, 'Allow comments', 0),
(1098, 1, 549, 'Allow comments', 0),
(1099, 0, 550, 'Allow ratings', 0),
(1100, 1, 550, 'Allow ratings', 0),
(1101, 0, 551, 'Default home page', 0),
(1102, 1, 551, 'Default home page', 0),
(1103, 0, 552, 'Allow attachment to clients', 0),
(1104, 1, 552, 'Allow attachment to clients', 0),
(1105, 0, 553, 'Login compulsory to client', 0),
(1106, 1, 553, 'Login compulsory to client', 0),
(1107, 0, 554, 'Autosubscribe after comment', 0),
(1108, 1, 554, 'Autosubscribe after comment', 0),
(1109, 0, 555, 'Root', 0),
(1110, 1, 555, 'Root', 0),
(1111, 0, 556, 'Parent category', 0),
(1112, 1, 556, 'Parent category', 0),
(1113, 0, 557, 'Knowledgebase', 0),
(1114, 1, 557, 'Knowledgebase', 0),
(1115, 0, 558, 'Question and answer', 0),
(1116, 1, 558, 'Question and answer', 0),
(1117, 0, 559, 'Order by', 0),
(1118, 1, 559, 'Order by', 0),
(1119, 0, 560, 'New first', 0),
(1120, 1, 560, 'New first', 0),
(1121, 0, 561, 'Old first', 0),
(1122, 1, 561, 'Old first', 0),
(1123, 0, 562, 'Modified first', 0),
(1124, 1, 562, 'Modified first', 0),
(1125, 0, 563, 'Visible to', 0),
(1126, 1, 563, 'Visible to', 0),
(1127, 0, 564, 'Everybody', 0),
(1128, 1, 564, 'Everybody', 0),
(1129, 0, 565, 'Staff only', 0),
(1130, 1, 565, 'Staff only', 0),
(1131, 0, 566, 'Logged in client', 0),
(1132, 1, 566, 'Logged in client', 0),
(1133, 1, 567, 'Is enabled', 0),
(1134, 0, 567, 'Is enabled', 0),
(1135, 0, 568, 'Post article', 0),
(1136, 1, 568, 'Post article', 0),
(1137, 0, 569, 'Author', 0),
(1138, 1, 569, 'Author', 0),
(1139, 0, 570, 'Add category', 0),
(1140, 1, 570, 'Add category', 0),
(1141, 0, 571, 'Article added', 0),
(1142, 1, 571, 'Article added', 0),
(1143, 0, 572, 'Release test manager', 0),
(1144, 1, 572, 'Release test manager', 0),
(1145, 0, 573, 'Delete article', 0),
(1146, 1, 573, 'Delete article', 0),
(1147, 0, 574, 'Self help suggestion', 0),
(1148, 1, 574, 'Solutions suggestion', 0),
(1149, 0, 575, 'Enable captcha on selfhelp', 0),
(1150, 1, 575, 'Enable captcha on solutions', 0),
(1151, 0, 576, 'Quick insert', 0),
(1152, 1, 576, 'Quick insert', 0),
(1153, 0, 577, 'More', 0),
(1154, 1, 577, 'More', 0),
(1155, 0, 578, 'Welcome', 0),
(1156, 1, 578, 'Welcome', 0),
(1157, 0, 579, 'Service request unassigned From', 0),
(1158, 1, 579, 'Service request unassigned From', 0),
(1159, 0, 580, 'Reports', 0),
(1160, 1, 580, 'Reports', 0),
(1161, 0, 581, 'Add report', 0),
(1162, 1, 581, 'Add report', 0),
(1163, 1, 582, 'Migration', 0),
(1164, 0, 582, 'Migration', 0),
(1165, 0, 583, 'Inbox', 0),
(1166, 1, 583, 'Inbox', 0),
(1167, 0, 584, 'Tags', 0),
(1168, 1, 584, 'Tags', 0),
(1169, 0, 585, 'Delete tag', 0),
(1170, 1, 585, 'Delete tag', 0),
(1171, 0, 586, 'Tag search', 0),
(1172, 1, 586, 'Tag search', 0),
(1173, 0, 587, 'Recent activities', 0),
(1174, 1, 587, 'Recent activities', 0),
(1175, 0, 588, 'Add module', 0),
(1176, 1, 588, 'Add module', 0),
(1177, 0, 589, 'Delete module', 0),
(1178, 1, 589, 'Delete module', 0),
(1179, 0, 590, 'Header title', 0),
(1180, 1, 590, 'Header title', 0),
(1181, 0, 591, 'Display on quick view', 0),
(1182, 1, 591, 'Display on quick view', 0),
(1183, 0, 592, 'Failed', 0),
(1184, 1, 592, 'Failed', 0),
(1185, 0, 593, 'Success', 0),
(1186, 1, 593, 'Success', 0),
(1187, 0, 594, 'Theme', 0),
(1188, 1, 594, 'Theme', 0),
(1189, 1, 595, 'Session timeout', 0),
(1190, 0, 595, 'Session timeout', 0),
(1191, 0, 596, 'In minutes', 0),
(1192, 1, 596, 'In minutes', 0),
(1193, 1, 597, 'Sound alert', 0),
(1194, 0, 597, 'Sound alert', 0),
(1195, 0, 598, 'HTML editor', 0),
(1196, 1, 598, 'HTML editor', 0),
(1197, 0, 599, 'Color', 0),
(1198, 1, 599, 'Color', 0),
(1199, 0, 600, 'Planner and Scheduler manager', 0),
(1200, 1, 600, 'Planner and Scheduler manager', 0),
(1201, 0, 601, 'Add priority', 0),
(1202, 1, 601, 'Add priority', 0),
(1203, 0, 602, 'Update priority', 0),
(1204, 1, 602, 'Update priority', 0),
(1205, 0, 603, 'Delete priority', 0),
(1206, 1, 603, 'Delete priority', 0),
(1207, 0, 604, 'Purchase or upgrade', 0),
(1208, 1, 604, 'Purchase or upgrade', 0),
(1209, 0, 605, 'Affected or Impacted by release', 0),
(1210, 1, 605, 'Affected or Impacted by release', 0),
(1211, 0, 606, 'Audience', 0),
(1212, 1, 606, 'Audience', 0),
(1213, 0, 607, 'Add schedule', 0),
(1214, 1, 607, 'Add schedule', 0),
(1215, 0, 608, 'Delete schedule', 0),
(1216, 1, 608, 'Delete schedule', 0),
(1217, 0, 609, 'Sunday', 0),
(1218, 1, 609, 'Sunday', 0),
(1219, 0, 610, 'Monday', 0),
(1220, 1, 610, 'Monday', 0),
(1221, 0, 611, 'Tuesday', 0),
(1222, 1, 611, 'Tuesday', 0),
(1223, 0, 612, 'Wednesday', 0),
(1224, 1, 612, 'Wednesday', 0),
(1225, 0, 613, 'Thursday', 0),
(1226, 1, 613, 'Thursday', 0),
(1227, 0, 614, 'Friday', 0),
(1228, 1, 614, 'Friday', 0),
(1229, 0, 615, 'Saturday', 0),
(1230, 1, 615, 'Saturday', 0),
(1231, 0, 616, 'Open 24 hours', 0),
(1232, 1, 616, 'Open 24 hours', 0),
(1233, 0, 617, 'Close', 0),
(1234, 1, 617, 'Close', 0),
(1235, 0, 618, 'Open', 0),
(1236, 1, 618, 'Open', 0),
(1237, 0, 619, 'Custom time', 0),
(1238, 1, 619, 'Custom time', 0),
(1239, 0, 620, 'Add workflow', 0),
(1240, 1, 620, 'Add workflow', 0),
(1241, 0, 621, 'Delete workflow', 0),
(1242, 1, 621, 'Delete workflow', 0),
(1243, 0, 622, 'Change department', 0),
(1244, 1, 622, 'Change department', 0),
(1245, 0, 623, 'No change', 0),
(1246, 1, 623, 'No change', 0),
(1247, 0, 624, 'Assign staff', 0),
(1248, 1, 624, 'Assign staff', 0),
(1249, 0, 625, 'Change status', 0),
(1250, 1, 625, 'Change status', 0),
(1251, 0, 626, 'Change flag', 0),
(1252, 1, 626, 'Change flag', 0),
(1253, 0, 627, 'Change incident type', 0),
(1254, 1, 627, 'Change incident type', 0),
(1255, 0, 628, 'Apply SLA', 0),
(1256, 1, 628, 'Apply SLA', 0),
(1257, 0, 629, 'Ignore email', 0),
(1258, 1, 629, 'Ignore email', 0),
(1259, 0, 630, 'Send autoresponder message', 0),
(1260, 1, 630, 'Send autoresponder message', 0),
(1261, 0, 631, 'Process incident alert rules', 0),
(1262, 1, 631, 'Process incident alert rules', 0),
(1263, 0, 632, 'Do not parse as incident reply', 0),
(1264, 1, 632, 'Do not parse as incident reply', 0),
(1265, 0, 633, 'Forward to', 0),
(1266, 1, 633, 'Forward to', 0),
(1267, 1, 634, 'Marked as banned', 0),
(1268, 0, 634, 'Marked as banned', 0),
(1269, 1, 635, 'Marked as spam', 0),
(1270, 0, 635, 'Marked as spam', 0),
(1271, 0, 636, 'Change', 0),
(1272, 1, 636, 'Change', 0),
(1273, 0, 637, 'On', 0),
(1274, 1, 637, 'On', 0),
(1275, 0, 638, 'Options', 0),
(1276, 1, 638, 'Options', 0),
(1277, 0, 639, 'None', 0),
(1278, 1, 639, 'None', 0),
(1279, 0, 640, 'Public', 0),
(1280, 1, 640, 'Public', 0),
(1281, 0, 641, 'Private', 0),
(1282, 1, 641, 'Private', 0),
(1283, 0, 642, 'Yes', 0),
(1284, 1, 642, 'Yes', 0),
(1285, 0, 643, 'No', 0),
(1286, 1, 643, 'No', 0),
(1287, 0, 644, 'Enable', 0),
(1288, 1, 644, 'Enable', 0),
(1289, 0, 645, 'Disable', 0),
(1290, 1, 645, 'Disable', 0),
(1291, 0, 646, 'Display order', 0),
(1292, 1, 646, 'Display order', 0),
(1293, 0, 647, 'Next', 0),
(1294, 1, 647, 'Next', 0),
(1295, 0, 648, 'Finish', 0),
(1296, 1, 648, 'Finish', 0),
(1297, 0, 649, 'Deletion of custom field group will delete custom fields in this custom group', 0),
(1298, 1, 649, 'Deletion of custom field group will delete custom fields in this custom group', 0),
(1299, 0, 650, 'Module should contain character from a to z only in small letters', 0),
(1300, 1, 650, 'Module should contain character from a to z only in small letters', 0),
(1301, 0, 651, 'To add custom fields you require minimum one custom field group', 0),
(1302, 1, 651, 'To add custom fields you require minimum one custom field group', 0),
(1303, 0, 652, 'Baseline', 0),
(1304, 1, 652, 'Baseline', 0),
(1305, 0, 653, 'Deleting department will delete all incidents under that department. This action is irreversible! <br /> Are you sure you want to proceed?', 0),
(1306, 1, 653, 'Deleting department will delete all incidents under that department. This action is irreversible! <br /> Are you sure you want to proceed?', 0),
(1307, 0, 654, 'Deleting domain will delete all departments clients and their incidents from this domain.<br />This operation is irreversible<br />are you sure you want to proceed?', 0),
(1308, 1, 654, 'Deleting domain will delete all departments clients and their incidents from this domain.<br />This operation is irreversible<br />Are you sure you want to proceed?', 0),
(1309, 0, 655, 'Deleting category will delete all its articles and comments on that articles. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(1310, 1, 655, 'Deleting category will delete all its articles and comments on that articles. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(1311, 0, 656, 'Deleting article will delete article and comments on it. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(1312, 1, 656, 'Deleting article will delete article and comments on it. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(1313, 0, 657, 'and', 0),
(1314, 1, 657, 'and', 0),
(1315, 0, 658, 'Calender', 0),
(1316, 1, 658, 'Calender', 0),
(1317, 0, 659, 'Calculate', 0),
(1318, 1, 659, 'Calculate', 0),
(1319, 0, 660, 'Can not change any property', 0),
(1320, 1, 660, 'Can not change any property', 0),
(1321, 0, 661, 'Complete all the steps and close all the linked changes before closing release', 0),
(1322, 1, 661, 'Complete all the steps and close all the linked changes before closing release', 0),
(1323, 0, 662, 'Required files not found for module', 0),
(1324, 1, 662, 'Required files not found for module', 0),
(1325, 0, 663, 'Customer', 0),
(1326, 1, 663, 'Customer', 0),
(1327, 0, 664, 'Setting not available', 0),
(1328, 1, 664, 'Setting not available', 0),
(1329, 0, 665, 'Empty sent mail log', 0),
(1330, 1, 665, 'Empty sent mail log', 0),
(1331, 0, 666, 'Log not selected', 0),
(1332, 1, 666, 'Log not selected', 0),
(1333, 0, 667, 'Error log is empty', 0),
(1334, 1, 667, 'Error log is empty', 0),
(1335, 0, 668, 'Exception log is empty', 0),
(1336, 1, 668, 'Exception log is empty', 0),
(1337, 0, 669, 'Incorrect response time', 0),
(1338, 1, 669, 'Incorrect response time', 0),
(1339, 0, 670, 'Incorrect resolution time', 0),
(1340, 1, 670, 'Incorrect resolution time', 0),
(1341, 0, 671, 'Amount is missing or invalid format', 0),
(1342, 1, 671, 'Amount is missing or invalid format', 0),
(1343, 0, 672, 'Deployment schedule', 0),
(1344, 1, 672, 'Deployment schedule', 0),
(1345, 0, 673, 'Incident ID missing', 0),
(1346, 1, 673, 'Incident ID missing', 0),
(1347, 0, 674, 'Filter title not set', 0),
(1348, 1, 674, 'Filter title not set', 0),
(1349, 0, 675, 'Sender not found', 0),
(1350, 1, 675, 'Sender not found', 0),
(1351, 0, 676, 'Tag name missing', 0),
(1352, 1, 676, 'Tag name missing', 0),
(1353, 0, 677, 'Invalid operation', 0),
(1354, 1, 677, 'Invalid operation', 0),
(1355, 0, 678, 'Select multiple incidents to merge', 0),
(1356, 1, 678, 'Select multiple incidents to merge', 0),
(1357, 0, 679, 'Strategy of deployment', 0),
(1358, 1, 679, 'Strategy of deployment', 0),
(1359, 0, 680, 'Invalid old password', 0),
(1360, 1, 680, 'Invalid old password', 0),
(1361, 0, 681, 'Staff not selected', 0),
(1362, 1, 681, 'Staff not selected', 0),
(1363, 0, 682, 'Build and Deployment manager', 0),
(1364, 1, 682, 'Build and Deployment manager', 0),
(1365, 0, 683, 'Testing approval', 0),
(1366, 1, 683, 'Testing approval', 0),
(1367, 0, 684, 'Risks or Disruptions Mitigation', 0),
(1368, 1, 684, 'Risks or Disruptions Mitigation', 0),
(1369, 0, 685, 'Password reset and sent to email', 0),
(1370, 1, 685, 'Password reset and sent to email', 0),
(1371, 0, 686, 'Ready to Deploy', 0),
(1372, 1, 686, 'Ready to Deploy', 0),
(1373, 0, 687, 'Field not selected', 0),
(1374, 1, 687, 'Field not selected', 0),
(1375, 0, 688, 'Event not selected', 0),
(1376, 1, 688, 'Event not selected', 0),
(1377, 0, 689, 'Migration data not selected', 0),
(1378, 1, 689, 'Migration data not selected', 0),
(1379, 0, 690, 'Financial assets', 0),
(1380, 1, 690, 'Financial assets', 0),
(1381, 0, 691, 'Your add-on domain limit has been reached. If you wish to add more add-on domains you will have to upgrade your vision helpdesk license to higher plan. Please renew', 0),
(1382, 1, 691, 'Your add-on domain limit has been reached. If you wish to add more add-on domains you will have to upgrade your vision helpdesk license to higher plan. Please renew', 0),
(1383, 0, 692, 'Core module can not be deleted', 0),
(1384, 1, 692, 'Core module can not be deleted', 0),
(1385, 0, 693, 'Incomplete information submitted', 0),
(1386, 1, 693, 'Incomplete information submitted', 0),
(1387, 0, 694, 'Quick view widget for this module not found', 0),
(1388, 1, 694, 'Quick view widget for this module not found', 0),
(1389, 0, 695, 'Empty error log', 0),
(1390, 1, 695, 'Empty error log', 0),
(1391, 0, 696, 'Processes and materials', 0),
(1392, 1, 696, 'Processes and materials', 0),
(1393, 0, 697, 'New client registered', 0),
(1394, 1, 697, 'New client registered', 0),
(1395, 0, 698, 'Domain not found', 0),
(1396, 1, 698, 'Domain not found', 0),
(1397, 0, 699, 'Department not found', 0),
(1398, 1, 699, 'Department not found', 0),
(1399, 0, 700, 'Staff ID not found', 0),
(1400, 1, 700, 'Staff ID not found', 0),
(1401, 0, 701, 'Incident replied', 0),
(1402, 1, 701, 'Incident replied', 0),
(1403, 0, 702, 'Department changed', 0),
(1404, 1, 702, 'Department changed', 0),
(1405, 0, 703, 'Incident type changed', 0),
(1406, 1, 703, 'Incident type changed', 0),
(1407, 0, 704, 'Flag changed', 0),
(1408, 1, 704, 'Flag changed', 0),
(1409, 0, 705, 'Incident assigned', 0),
(1410, 1, 705, 'Incident assigned', 0),
(1411, 0, 706, 'Incident moved to trash', 0),
(1412, 1, 706, 'Incident moved to trash', 0),
(1413, 0, 707, 'Incident forwarded', 0),
(1414, 1, 707, 'Incident forwarded', 0),
(1415, 0, 708, 'Incident deleted', 0),
(1416, 1, 708, 'Incident deleted', 0),
(1417, 0, 709, 'SLA changed', 0),
(1418, 1, 709, 'SLA changed', 0),
(1419, 0, 710, 'Spam marked', 0),
(1420, 1, 710, 'Spam marked', 0),
(1421, 0, 711, 'Removed spam mark', 0),
(1422, 1, 711, 'Removed spam mark', 0),
(1423, 0, 712, 'Can not remove first criteria', 0),
(1424, 1, 712, 'Can not remove first criteria', 0),
(1425, 0, 713, 'Display order must be numeric', 0),
(1426, 1, 713, 'Display order must be numeric', 0),
(1427, 0, 714, 'Service release details', 0),
(1428, 1, 714, 'Service release details', 0),
(1429, 0, 715, 'Use csv CI type', 0),
(1430, 1, 715, 'Use csv CI type', 0),
(1431, 0, 716, 'Reply count', 0),
(1432, 1, 716, 'Reply count', 0),
(1433, 0, 717, 'Monitoring start date', 0),
(1434, 1, 717, 'Monitoring start date', 0),
(1435, 0, 718, 'Monitoring end date', 0),
(1436, 1, 718, 'Monitoring end date', 0),
(1437, 0, 719, 'Monitoring review', 0),
(1438, 1, 719, 'Monitoring review', 0),
(1439, 0, 720, 'Debit', 0),
(1440, 1, 720, 'Debit', 0),
(1441, 0, 721, 'Group balance', 0),
(1442, 1, 721, 'Group balance', 0),
(1443, 0, 722, 'Group debit', 0);
INSERT INTO `avis_language_values` VALUES
(1444, 1, 722, 'Group debit', 0),
(1445, 0, 723, 'Paid invoice count', 0),
(1446, 1, 723, 'Paid invoice count', 0),
(1447, 0, 724, 'Unpaid invoice count', 0),
(1448, 1, 724, 'Unpaid invoice count', 0),
(1449, 0, 725, 'Confirmation - Knowledge transfer / training?', 0),
(1450, 1, 725, 'Confirmation - Knowledge transfer / training?', 0),
(1451, 0, 726, 'Quality requirement achieved?', 0),
(1452, 1, 726, 'Quality requirement achieved?', 0),
(1453, 0, 727, 'Post implementation review', 0),
(1454, 1, 727, 'Post implementation review', 0),
(1455, 0, 728, 'Closing date', 0),
(1456, 1, 728, 'Closing date', 0),
(1457, 0, 729, 'Properties', 0),
(1458, 1, 729, 'Properties', 0),
(1459, 0, 730, 'People', 0),
(1460, 1, 730, 'People', 0),
(1461, 0, 731, 'Module already exist', 0),
(1462, 1, 731, 'Module already exist', 0),
(1463, 0, 732, 'Default view can not delete', 0),
(1464, 1, 732, 'Default view can not delete', 0),
(1465, 0, 733, 'Search trash', 0),
(1466, 1, 733, 'Search trash', 0),
(1467, 0, 734, 'Search spam', 0),
(1468, 1, 734, 'Search spam', 0),
(1469, 0, 735, 'Trash', 0),
(1470, 1, 735, 'Trash', 0),
(1471, 0, 736, 'Spam', 0),
(1472, 1, 736, 'Spam', 0),
(1473, 0, 737, 'Print', 0),
(1474, 1, 737, 'Print', 0),
(1475, 0, 738, 'Incident not found may be deleted or not have access', 0),
(1476, 1, 738, 'Incident not found may be deleted or not have access', 0),
(1477, 0, 739, 'On overdue', 0),
(1478, 1, 739, 'On overdue', 0),
(1479, 0, 740, 'Option', 0),
(1480, 1, 740, 'Option', 0),
(1481, 0, 741, 'Delete filter', 0),
(1482, 1, 741, 'Delete filter', 0),
(1483, 1, 742, 'Draft', 0),
(1484, 0, 742, 'Drafts', 0),
(1485, 1, 743, 'is currently working on this incident.', 0),
(1486, 0, 743, 'Staff currently reading this incident', 0),
(1487, 0, 744, 'To share with all do not select staff', 0),
(1488, 1, 744, 'To share with all do not select staff', 0),
(1489, 0, 745, 'Go', 0),
(1490, 1, 745, 'Go', 0),
(1491, 0, 746, 'Delete report', 0),
(1492, 1, 746, 'Delete report', 0),
(1493, 0, 747, 'Staff username and email should be unique', 0),
(1494, 1, 747, 'Staff username and email should be unique', 0),
(1495, 0, 748, 'Delete sent mail log', 0),
(1496, 1, 748, 'Delete sent mail log', 0),
(1497, 0, 749, 'Client details', 0),
(1498, 1, 749, 'Client details', 0),
(1499, 1, 750, 'Client notes', 0),
(1500, 0, 750, 'Client notes', 0),
(1501, 1, 751, 'Products and services', 0),
(1502, 0, 751, 'Products and services', 0),
(1503, 0, 752, 'Package', 0),
(1504, 1, 752, 'Package', 0),
(1505, 1, 753, 'Dedicated IP', 0),
(1506, 0, 753, 'Dedicated IP', 0),
(1507, 0, 754, 'WHMCS client notes', 0),
(1508, 1, 754, 'WHMCS client notes', 0),
(1509, 0, 755, 'Error in WHMCS database selection', 0),
(1510, 1, 755, 'Error in WHMCS database selection', 0),
(1511, 0, 756, 'Error in WHMCS database connection', 0),
(1512, 1, 756, 'Error in WHMCS database connection', 0),
(1513, 0, 757, 'WHMCS integration details not set', 0),
(1514, 1, 757, 'WHMCS integration details not set', 0),
(1515, 0, 758, 'Version', 0),
(1516, 1, 758, 'Version', 0),
(1517, 0, 759, 'Branding free', 0),
(1518, 1, 759, 'Branding free', 0),
(1519, 0, 760, 'Invoice for incident', 0),
(1520, 1, 760, 'Invoice for incident', 0),
(1521, 0, 761, 'Invoice for time', 0),
(1522, 1, 761, 'Invoice for time', 0),
(1523, 0, 762, 'Bill amount', 0),
(1524, 1, 762, 'Bill amount', 0),
(1525, 0, 763, 'Edit transaction', 0),
(1526, 1, 763, 'Update transaction', 0),
(1527, 0, 764, 'Transactions', 0),
(1528, 1, 764, 'Transactions', 0),
(1529, 0, 765, 'Delete transaction', 0),
(1530, 1, 765, 'Delete transaction', 0),
(1531, 0, 766, 'Rate', 0),
(1532, 1, 766, 'Rate', 0),
(1533, 0, 767, 'Inclusive', 0),
(1534, 1, 767, 'Inclusive', 0),
(1535, 0, 768, 'Exclusive', 0),
(1536, 1, 768, 'Exclusive', 0),
(1537, 0, 769, 'Add tax rule', 0),
(1538, 1, 769, 'Add tax rule', 0),
(1539, 0, 770, 'Edit tax rule', 0),
(1540, 1, 770, 'Edit tax rule', 0),
(1541, 0, 771, 'Invalid rule', 0),
(1542, 1, 771, 'Invalid rule', 0),
(1543, 0, 772, 'Delete tax rule', 0),
(1544, 1, 772, 'Delete tax rule', 0),
(1545, 0, 773, 'View invoice to client', 0),
(1546, 1, 773, 'View invoice to client', 0),
(1547, 0, 774, 'Update release impact', 0),
(1548, 1, 774, 'Update release impact', 0),
(1549, 0, 775, 'Invoice to', 0),
(1550, 1, 775, 'Invoice to', 0),
(1551, 0, 776, 'Move to inbox', 0),
(1552, 1, 776, 'Move to inbox', 0),
(1553, 0, 777, 'Mark unpaid', 0),
(1554, 1, 777, 'Mark unpaid', 0),
(1555, 0, 778, 'Mark cancelled', 0),
(1556, 1, 778, 'Mark cancelled', 0),
(1557, 0, 779, 'Greater than or equal', 0),
(1558, 1, 779, 'Greater than or equal', 0),
(1559, 0, 780, 'Add item', 0),
(1560, 1, 780, 'Add item', 0),
(1561, 0, 781, 'Email templates mapping', 0),
(1562, 1, 781, 'Email templates mapping', 0),
(1563, 0, 782, 'Update release risk', 0),
(1564, 1, 782, 'Update release risk', 0),
(1565, 0, 783, 'Consumer key', 0),
(1566, 1, 783, 'Consumer key', 0),
(1567, 0, 784, 'Update release urgency', 0),
(1568, 1, 784, 'Update release urgency', 0),
(1569, 0, 785, 'Release stage completion', 0),
(1570, 1, 785, 'Release stage completion', 0),
(1571, 0, 786, 'Check your incident details at', 0),
(1572, 1, 786, 'Check your incident details at', 0),
(1573, 0, 787, 'Social media', 0),
(1574, 1, 787, 'Social media', 0),
(1575, 0, 788, 'Search content', 0),
(1576, 1, 788, 'Search content', 0),
(1577, 0, 789, 'Add social media', 0),
(1578, 1, 789, 'Add social media', 0),
(1579, 0, 790, 'Auto incident convert if mentioned', 0),
(1580, 1, 790, 'Auto incident convert if mentioned', 0),
(1581, 0, 791, 'Create an app with access read write and direct message from', 0),
(1582, 1, 791, 'Create an app with access read write and direct message from', 0),
(1583, 0, 792, 'Release role assignment', 0),
(1584, 1, 792, 'Release role assignment', 0),
(1585, 0, 793, 'And genereate required details from "details >> Create my access token"', 0),
(1586, 1, 793, 'And genereate required details from "details >> Create my access token"', 0),
(1587, 0, 794, 'Hidden', 0),
(1588, 1, 794, 'Hidden', 0),
(1589, 0, 795, 'Software type', 0),
(1590, 1, 795, 'Software type', 0),
(1591, 0, 796, 'SMS alert', 0),
(1592, 1, 796, 'SMS alert', 0),
(1593, 0, 797, 'Portal color', 0),
(1594, 1, 797, 'Portal color', 0),
(1595, 0, 798, 'Secret key for API', 0),
(1596, 1, 798, 'Secret key for API', 0),
(1597, 0, 799, 'Approved', 0),
(1598, 1, 799, 'Approved', 0),
(1599, 0, 800, 'Unapproved', 0),
(1600, 1, 800, 'Unapproved', 0),
(1601, 0, 801, 'Can not delete department. Domain atleast need one department', 0),
(1602, 1, 801, 'Can not delete department. Domain atleast need one department', 0),
(1603, 0, 802, 'Software category', 0),
(1604, 1, 802, 'Software category', 0),
(1605, 0, 803, 'Display after login', 0),
(1606, 1, 803, 'Display after login', 0),
(1607, 0, 804, 'Type here and enter', 0),
(1608, 1, 804, 'Type here and enter', 0),
(1609, 0, 805, 'Client portal logo', 0),
(1610, 1, 805, 'Client portal logo', 0),
(1611, 0, 806, 'Save reply', 0),
(1612, 1, 806, 'Save reply', 0),
(1613, 0, 807, 'Can not delete system default settings', 0),
(1614, 1, 807, 'Can not delete system default settings', 0),
(1615, 0, 808, 'Statistical reports', 0),
(1616, 1, 808, 'Statistical reports', 0),
(1617, 0, 809, 'Graphical', 0),
(1618, 1, 809, 'Graphical', 0),
(1619, 0, 810, 'Component', 0),
(1620, 1, 810, 'Component', 0),
(1621, 0, 811, 'Base DN', 0),
(1622, 1, 811, 'Base DN', 0),
(1623, 0, 812, 'Move incidents to any department', 0),
(1624, 1, 812, 'Move incidents to any department', 0),
(1625, 0, 813, 'Date format', 0),
(1626, 1, 813, 'Date format', 0),
(1627, 0, 814, 'Date time format', 0),
(1628, 1, 814, 'Date time format', 0),
(1629, 0, 815, 'Products', 0),
(1630, 1, 815, 'Products', 0),
(1631, 1, 816, 'Delete package', 0),
(1632, 0, 816, 'Delete package', 0),
(1633, 0, 817, 'Add product', 0),
(1634, 1, 817, 'Add product', 0),
(1635, 0, 818, 'Credit type', 0),
(1636, 1, 818, 'Credit type', 0),
(1637, 0, 819, 'Orders', 0),
(1638, 1, 819, 'Orders', 0),
(1639, 0, 820, 'Order', 0),
(1640, 1, 820, 'Order', 0),
(1641, 0, 821, 'Contract license type', 0),
(1642, 1, 821, 'Contract license type', 0),
(1643, 0, 822, 'Each word', 0),
(1644, 1, 822, 'Each word', 0),
(1645, 0, 823, 'Model', 0),
(1646, 1, 823, 'Model', 0),
(1647, 0, 824, 'Enable join before host', 0),
(1648, 1, 824, 'Enable join before host', 0),
(1649, 0, 825, 'Value', 0),
(1650, 1, 825, 'Value', 0),
(1651, 0, 826, 'Empty trash', 0),
(1652, 1, 826, 'Empty trash', 0),
(1653, 0, 827, 'As client', 0),
(1654, 1, 827, 'As client', 0),
(1655, 0, 828, 'Income', 0),
(1656, 1, 828, 'Income', 0),
(1657, 0, 829, 'Edit product', 0),
(1658, 1, 829, 'Edit product', 0),
(1659, 0, 830, 'Delete facebook integration', 0),
(1660, 1, 830, 'Delete facebook integration', 0),
(1661, 0, 831, 'Invalid information or format', 0),
(1662, 1, 831, 'Invalid information or format', 0),
(1663, 0, 832, 'AVG. SLA', 0),
(1664, 1, 832, 'AVG. SLA', 0),
(1665, 0, 833, 'Label already exist', 0),
(1666, 1, 833, 'Label already exists', 0),
(1667, 0, 834, 'Access denied can not add client', 0),
(1668, 1, 834, 'Access denied can not add client', 0),
(1669, 0, 835, 'Merge client', 0),
(1670, 1, 835, 'Merge client', 0),
(1671, 0, 836, 'Merge as contact', 0),
(1672, 1, 836, 'Merge as contact', 0),
(1673, 0, 837, 'Custom SLA plan', 0),
(1674, 1, 837, 'Custom SLA plan', 0),
(1675, 0, 838, 'Delete label', 0),
(1676, 1, 838, 'Delete label', 0),
(1677, 0, 839, 'On unresolved', 0),
(1678, 1, 839, 'On unresolved', 0),
(1679, 0, 840, 'Additional attribute', 0),
(1680, 1, 840, 'Additional attribute', 0),
(1681, 0, 841, 'Transaction key', 0),
(1682, 1, 841, 'Transaction key', 0),
(1683, 0, 842, 'Gateway mode', 0),
(1684, 1, 842, 'Gateway mode', 0),
(1685, 0, 843, 'Gateway transactions', 0),
(1686, 1, 843, 'Gateway transactions', 0),
(1687, 0, 844, 'Gateway transaction response details', 0),
(1688, 1, 844, 'Gateway transaction response details', 0),
(1689, 0, 845, 'Delete gateway transaction log', 0),
(1690, 1, 845, 'Delete gateway transaction log', 0),
(1691, 0, 846, 'Empty gateway transaction log', 0),
(1692, 1, 846, 'Empty gateway transaction log', 0),
(1693, 0, 847, 'Recurring', 0),
(1694, 1, 847, 'Recurring', 0),
(1695, 0, 848, 'Incident hash generation', 0),
(1696, 1, 848, 'Incident hash generation', 0),
(1697, 0, 849, 'Random', 0),
(1698, 1, 849, 'Random', 0),
(1699, 0, 850, 'Sequential', 0),
(1700, 1, 850, 'Sequential', 0),
(1701, 0, 851, 'Incident hash prefix', 0),
(1702, 1, 851, 'Incident hash prefix', 0),
(1703, 0, 852, 'Numbering starts from', 0),
(1704, 1, 852, 'Numbering starts from', 0),
(1705, 0, 853, 'Alphanumeric prefix data required', 0),
(1706, 1, 853, 'Alphanumeric prefix data required', 0),
(1707, 0, 854, 'Numeric data required for numbering starts from field', 0),
(1708, 1, 854, 'Numeric data required for numbering starts from field', 0),
(1709, 0, 855, 'Authentication error', 0),
(1710, 1, 855, 'Authentication error', 0),
(1711, 0, 856, 'Connection error', 0),
(1712, 1, 856, 'Connection error', 0),
(1713, 0, 857, 'Authentication or connection error', 0),
(1714, 1, 857, 'Authentication or connection error', 0),
(1715, 0, 858, 'Client search', 0),
(1716, 1, 858, 'Client search', 0),
(1717, 0, 859, 'Is approved', 0),
(1718, 1, 859, 'Is approved', 0),
(1719, 0, 860, 'Search solution articles', 0),
(1720, 1, 860, 'Search solution articles', 0),
(1721, 1, 861, 'Export all', 0),
(1722, 0, 861, 'Export all', 0),
(1723, 0, 862, 'Notifications', 0),
(1724, 1, 862, 'Notifications', 0),
(1725, 0, 863, 'Notification icon', 0),
(1726, 1, 863, 'Notification icon', 0),
(1727, 0, 864, 'Forward failed email', 0),
(1728, 1, 864, 'Forward failed email', 0),
(1729, 0, 865, 'Forward failed email to', 0),
(1730, 1, 865, 'Forward failed email to', 0),
(1731, 0, 866, 'Verify email queue', 0),
(1732, 1, 866, 'Verify email queue', 0),
(1733, 0, 867, 'Stop timer', 0),
(1734, 1, 867, 'Stop timer', 0),
(1735, 0, 868, 'Time tracked', 0),
(1736, 1, 868, 'Time tracked', 0),
(1737, 0, 869, 'Add time tracked', 0),
(1738, 1, 869, 'Add time tracked', 0),
(1739, 0, 870, '#Timetrack', 0),
(1740, 1, 870, '#Timetrack', 0),
(1741, 0, 871, 'Bill time', 0),
(1742, 1, 871, 'Bill time', 0),
(1743, 0, 872, 'Work time', 0),
(1744, 1, 872, 'Work time', 0),
(1745, 0, 873, 'Timetrack ID missing', 0),
(1746, 1, 873, 'Timetrack ID missing', 0),
(1747, 0, 874, 'Delete time tracked', 0),
(1748, 1, 874, 'Delete time tracked', 0),
(1749, 0, 875, 'Attribute', 0),
(1750, 1, 875, 'Attribute', 0),
(1751, 0, 876, 'Display inline images', 0),
(1752, 1, 876, 'Display inline images', 0),
(1753, 0, 877, 'Hide inline images', 0),
(1754, 1, 877, 'Hide inline images', 0),
(1755, 0, 878, 'SLA plan change', 0),
(1756, 1, 878, 'SLA plan change', 0),
(1757, 0, 879, 'Select incidents to export', 0),
(1758, 1, 879, 'Select incidents to export', 0),
(1759, 0, 880, 'Enter minimum 3 characters', 0),
(1760, 1, 880, 'Enter minimum 3 characters', 0),
(1761, 0, 881, 'Recent messages', 0),
(1762, 1, 881, 'Recent messages', 0),
(1763, 0, 882, 'Load more...', 0),
(1764, 1, 882, 'Load more...', 0),
(1765, 0, 883, 'Export CSV', 0),
(1766, 1, 883, 'Export CSV', 0),
(1767, 0, 884, 'Filter', 0),
(1768, 1, 884, 'Filter', 0),
(1769, 0, 885, 'List column', 0),
(1770, 1, 885, 'List column', 0),
(1771, 0, 886, 'Update view', 0),
(1772, 1, 886, 'Update view', 0),
(1773, 0, 887, 'Attachment', 0),
(1774, 1, 887, 'Attachment', 0),
(1775, 0, 888, 'Deletion cannot be done since it is already in use.', 0),
(1776, 1, 888, 'Deletion cannot be done since it is already in use.', 0),
(1777, 0, 889, 'Latest post', 0),
(1778, 1, 889, 'Latest post', 0),
(1779, 0, 890, 'Manage portal', 0),
(1780, 1, 890, 'Manage portal', 0),
(1781, 0, 891, 'Manage portal logo', 0),
(1782, 1, 891, 'Manage portal logo', 0),
(1783, 0, 892, 'Manage portal color', 0),
(1784, 1, 892, 'Manage portal color', 0),
(1785, 0, 893, 'New incident', 0),
(1786, 1, 893, 'New incident', 0),
(1787, 0, 894, 'Use assigned departments to team?', 0),
(1788, 1, 894, 'Use assigned departments to team?', 0),
(1789, 0, 895, 'Update staff', 0),
(1790, 1, 895, 'Update staff', 0),
(1791, 0, 896, 'Permissions', 0),
(1792, 1, 896, 'Permissions', 0),
(1793, 0, 897, 'Update staff group', 0),
(1794, 1, 897, 'Update team', 0),
(1795, 0, 898, 'Update admin access', 0),
(1796, 1, 898, 'Update admin access', 0),
(1797, 0, 899, 'Change owner', 0),
(1798, 1, 899, 'Change owner', 0),
(1799, 0, 900, 'Change type', 0),
(1800, 1, 900, 'Change type', 0),
(1801, 0, 901, 'Split incident', 0),
(1802, 1, 901, 'Split incident', 0),
(1803, 1, 902, 'Link / Unlink incidents', 0),
(1804, 0, 902, 'Link / Unlink incidents', 0),
(1805, 0, 903, 'Update status', 0),
(1806, 1, 903, 'Update status', 0),
(1807, 0, 904, 'Update workflow', 0),
(1808, 1, 904, 'Update workflow', 0),
(1809, 0, 905, 'Holidays', 0),
(1810, 1, 905, 'Holidays', 0),
(1811, 0, 906, 'Add holiday', 0),
(1812, 1, 906, 'Add holiday', 0),
(1813, 0, 907, 'Delete holiday', 0),
(1814, 1, 907, 'Delete holiday', 0),
(1815, 0, 908, 'Update holiday', 0),
(1816, 1, 908, 'Update holiday', 0),
(1817, 0, 909, 'Update incident type', 0),
(1818, 1, 909, 'Update incident type', 0),
(1819, 0, 910, 'Since', 0),
(1820, 1, 910, 'Since', 0),
(1821, 0, 911, 'Update schedule', 0),
(1822, 1, 911, 'Update schedule', 0),
(1823, 0, 912, 'Update flag', 0),
(1824, 1, 912, 'Update flag', 0),
(1825, 0, 913, 'Update SLA', 0),
(1826, 1, 913, 'Update SLA', 0),
(1827, 0, 914, 'Already in used', 0),
(1828, 1, 914, 'Already in used', 0),
(1829, 0, 915, 'Ignore', 0),
(1830, 1, 915, 'Ignore', 0),
(1831, 0, 916, 'Two SMS', 0),
(1832, 1, 916, 'Two SMS', 0),
(1833, 0, 917, 'Check approval before closing', 0),
(1834, 1, 917, 'Check approval before closing', 0),
(1835, 0, 918, 'Transaction log', 0),
(1836, 1, 918, 'Transaction log', 0),
(1837, 0, 919, 'Override details', 0),
(1838, 1, 919, 'Override details', 0),
(1839, 0, 920, 'Update email queue', 0),
(1840, 1, 920, 'Update email queue', 0),
(1841, 0, 921, 'Organizations', 0),
(1842, 1, 921, 'Organizations', 0),
(1843, 0, 922, 'Apply filter', 0),
(1844, 1, 922, 'Apply filter', 0),
(1845, 0, 923, 'Update custom field', 0),
(1846, 1, 923, 'Update custom field', 0),
(1847, 0, 924, 'Update custom field group', 0),
(1848, 1, 924, 'Update custom field group', 0),
(1849, 0, 925, 'Incident count by priority', 0),
(1850, 1, 925, 'Incident count by priority', 0),
(1851, 0, 926, 'Incident count by status', 0),
(1852, 1, 926, 'Incident count by status', 0),
(1853, 0, 927, 'Organization details', 0),
(1854, 1, 927, 'Organization details', 0),
(1855, 0, 928, 'Company', 0),
(1856, 1, 928, 'Company', 0),
(1857, 0, 929, 'Update email template', 0),
(1858, 1, 929, 'Update email template', 0),
(1859, 0, 930, 'Update alert', 0),
(1860, 1, 930, 'Update alert', 0),
(1861, 0, 931, 'Label name', 0),
(1862, 1, 931, 'Label name', 0),
(1863, 0, 932, 'Add label', 0),
(1864, 1, 932, 'Add label', 0),
(1865, 0, 933, 'Label color', 0),
(1866, 1, 933, 'Label color', 0),
(1867, 0, 934, 'Pages', 0),
(1868, 1, 934, 'Pages', 0),
(1869, 0, 935, 'Fetch pages', 0),
(1870, 1, 935, 'Fetch pages', 0),
(1871, 0, 936, 'Page not found', 0),
(1872, 1, 936, 'Page not found', 0),
(1873, 0, 937, 'Update label', 0),
(1874, 1, 937, 'Update label', 0),
(1875, 0, 938, 'Update module', 0),
(1876, 1, 938, 'Update module', 0),
(1877, 0, 939, 'Activity for an incident', 0),
(1878, 1, 939, 'Activity for an incident', 0),
(1879, 0, 940, 'Service request overview', 0),
(1880, 1, 940, 'Service request overview', 0),
(1881, 0, 941, 'Preference', 0),
(1882, 1, 941, 'Preference', 0),
(1883, 0, 942, 'Recent blabs', 0),
(1884, 1, 942, 'Recent blabs', 0),
(1885, 0, 943, 'Internal incident', 0),
(1886, 1, 943, 'Internal incident', 0),
(1887, 0, 944, 'Add comment', 0),
(1888, 1, 944, 'Add comment', 0),
(1889, 1, 945, 'Update invoice', 0),
(1890, 0, 945, 'Update invoice', 0),
(1891, 0, 946, 'Last 7 days incident activity', 0),
(1892, 1, 946, 'Last 7 days incident activity', 0),
(1893, 0, 947, 'Replied', 0),
(1894, 1, 947, 'Replied', 0),
(1895, 0, 948, 'Awaiting', 0),
(1896, 1, 948, 'Awaiting', 0),
(1897, 0, 949, 'Closed', 0),
(1898, 1, 949, 'Closed', 0),
(1899, 0, 950, 'Staff member', 0),
(1900, 1, 950, 'Staff member', 0),
(1901, 0, 951, 'Skills', 0),
(1902, 1, 951, 'Skills', 0),
(1903, 0, 952, 'Phone number', 0),
(1904, 1, 952, 'Phone number', 0),
(1905, 0, 953, 'Empty', 0),
(1906, 1, 953, 'Empty', 0),
(1907, 0, 954, 'Sent email log', 0),
(1908, 1, 954, 'Sent email log', 0),
(1909, 0, 955, 'Gateway transactions log', 0),
(1910, 1, 955, 'Gateway transactions log', 0),
(1911, 0, 956, 'Core module status can not be changed', 0),
(1912, 1, 956, 'Core module status can not be changed', 0),
(1913, 0, 957, 'Display pages', 0),
(1914, 1, 957, 'Display pages', 0),
(1915, 1, 958, 'Package ID', 0),
(1916, 0, 958, 'Product ID', 0),
(1917, 0, 959, 'Entry date', 0),
(1918, 1, 959, 'Entry date', 0),
(1919, 0, 960, 'Staff comment', 0),
(1920, 1, 960, 'Staff comment', 0),
(1921, 0, 961, 'Recent activity count', 0),
(1922, 1, 961, 'Recent activity count', 0),
(1923, 0, 962, 'Online staff', 0),
(1924, 1, 962, 'Online staff', 0),
(1925, 0, 963, 'Post', 0),
(1926, 1, 963, 'Post', 0),
(1927, 0, 964, 'Insert from URL...', 0),
(1928, 1, 964, 'Insert from URL...', 0),
(1929, 0, 965, 'Attached media', 0),
(1930, 1, 965, 'Attached media', 0),
(1931, 0, 966, 'Upload from local machine', 0),
(1932, 1, 966, 'Upload from local machine', 0),
(1933, 1, 967, 'Attach media', 0),
(1934, 0, 967, 'Attach media', 0),
(1935, 0, 968, 'Add organization', 0),
(1936, 1, 968, 'Add organization', 0),
(1937, 0, 969, 'Update organization', 0),
(1938, 1, 969, 'Update organization', 0),
(1939, 0, 970, 'Save filter', 0),
(1940, 1, 970, 'Save filter', 0),
(1941, 0, 971, 'Filter ID not found', 0),
(1942, 1, 971, 'Filter ID not found', 0),
(1943, 0, 972, 'Update filter', 0),
(1944, 1, 972, 'Update filter', 0),
(1945, 0, 973, 'Incident count by type', 0),
(1946, 1, 973, 'Incident count by type', 0),
(1947, 0, 974, 'Total articles', 0),
(1948, 1, 974, 'Total articles', 0),
(1949, 0, 975, 'Total categories', 0),
(1950, 1, 975, 'Total categories', 0),
(1951, 0, 976, 'Helpful articles', 0),
(1952, 1, 976, 'Helpful articles', 0),
(1953, 0, 977, 'Articles', 0),
(1954, 1, 977, 'Articles', 0),
(1955, 0, 978, 'Update comment', 0),
(1956, 1, 978, 'Update comment', 0),
(1957, 0, 979, 'Update category', 0),
(1958, 1, 979, 'Update category', 0),
(1959, 0, 980, 'Update article', 0),
(1960, 1, 980, 'Update article', 0),
(1961, 1, 981, 'Sorted by', 0),
(1962, 0, 981, 'Sorted by', 0),
(1963, 0, 982, 'Delete comment', 0),
(1964, 1, 982, 'Delete comment', 0),
(1965, 1, 983, 'Now', 0),
(1966, 0, 983, 'Now', 0),
(1967, 0, 984, 'Work', 0),
(1968, 1, 984, 'Work', 0),
(1969, 0, 985, 'Department SLA', 0),
(1970, 1, 985, 'Department SLA', 0),
(1971, 0, 986, 'Response', 0),
(1972, 1, 986, 'Response', 0),
(1973, 0, 987, 'Performance', 0),
(1974, 1, 987, 'Performance', 0),
(1975, 0, 988, 'Client SLA', 0),
(1976, 1, 988, 'Client SLA', 0),
(1977, 1, 989, 'Incident feedback per department', 0),
(1978, 0, 989, 'Incident ratings', 0),
(1979, 0, 990, 'Time tracking per staff', 0),
(1980, 1, 990, 'Time tracking per staff', 0),
(1981, 0, 991, 'Time tracking per department', 0),
(1982, 1, 991, 'Time tracking per department', 0),
(1983, 0, 992, 'Staff SLA', 0),
(1984, 1, 992, 'Staff SLA', 0),
(1985, 0, 993, 'Top performer', 0),
(1986, 1, 993, 'Top performer', 0),
(1987, 0, 994, 'Department statistics', 0),
(1988, 1, 994, 'Department statistics', 0),
(1989, 0, 995, 'Incident count by level', 0),
(1990, 1, 995, 'Incident count by level', 0),
(1991, 0, 996, 'Team', 0),
(1992, 1, 996, 'Team', 0),
(1993, 0, 997, 'Selected staff', 0),
(1994, 1, 997, 'Selected staff', 0),
(1995, 0, 998, 'Search blabs', 0),
(1996, 1, 998, 'Search blabs', 0),
(1997, 0, 999, 'Search staff', 0),
(1998, 1, 999, 'Search staff', 0),
(1999, 0, 1000, 'Year', 0),
(2000, 1, 1000, 'Year', 0),
(2001, 0, 1001, 'Email address', 0),
(2002, 1, 1001, 'Email address', 0),
(2003, 0, 1002, 'Website URL', 0),
(2004, 1, 1002, 'Website URL', 0),
(2005, 0, 1003, 'Logo URL', 0),
(2006, 1, 1003, 'Logo URL', 0),
(2007, 0, 1004, 'Pay to text', 0),
(2008, 1, 1004, 'Pay to text', 0),
(2009, 1, 1005, 'Ship to', 0),
(2010, 0, 1005, 'Ship to', 0),
(2011, 0, 1006, 'Priority title', 0),
(2012, 1, 1006, 'Priority title', 0),
(2013, 0, 1007, 'Note color', 0),
(2014, 1, 1007, 'Note color', 0),
(2015, 0, 1008, 'Domain name should be proper and valid', 0),
(2016, 1, 1008, 'Domain name should be proper and valid', 0),
(2017, 0, 1009, 'Client portal URL should be proper and valid', 0),
(2018, 1, 1009, 'Client portal URL should be proper and valid', 0),
(2019, 0, 1010, 'Status title', 0),
(2020, 1, 1010, 'Status title', 0),
(2021, 0, 1011, 'Remove admin access', 0),
(2022, 1, 1011, 'Remove admin access', 0),
(2023, 0, 1012, 'Admin can not be updated', 0),
(2024, 1, 1012, 'Admin can not be updated', 0),
(2025, 0, 1013, 'Labels / tags', 0),
(2026, 1, 1013, 'Labels / tags', 0),
(2027, 0, 1014, 'Only alphanumeric characters are allowed in title', 0),
(2028, 1, 1014, 'Only alphanumeric characters are allowed in title', 0),
(2029, 0, 1015, 'Select language', 0),
(2030, 1, 1015, 'Select language', 0),
(2031, 0, 1016, 'Default word/phrases', 0),
(2032, 1, 1016, 'Default word/phrases', 0),
(2033, 0, 1017, 'Dashboard', 0),
(2034, 1, 1017, 'Dashboard', 0),
(2035, 1, 1018, 'Channels', 0),
(2036, 0, 1018, 'Channels', 0),
(2037, 0, 1019, 'Incident types', 0),
(2038, 1, 1019, 'Incident types', 0),
(2039, 0, 1020, 'Display IP address to staff', 0),
(2040, 1, 1020, 'Display IP address to staff', 0),
(2041, 0, 1021, 'IP address', 0),
(2042, 1, 1021, 'IP address', 0),
(2043, 0, 1022, 'Note posted by', 0),
(2044, 1, 1022, 'Note posted by', 0),
(2045, 0, 1023, 'Comment posted by', 0),
(2046, 1, 1023, 'Comment posted by', 0),
(2047, 0, 1024, 'Blab count must be numeric', 0),
(2048, 1, 1024, 'Blab count must be numeric', 0),
(2049, 0, 1025, 'Due time must be in proper format', 0),
(2050, 1, 1025, 'Due time must be in proper format', 0),
(2051, 0, 1026, 'Recent activity count must be numeric', 0),
(2052, 1, 1026, 'Recent activity count must be numeric', 0),
(2053, 0, 1027, 'Number of attachment must be numeric', 0),
(2054, 1, 1027, 'Number of attachment must be numeric', 0),
(2055, 0, 1028, 'Maximum size for attachment must be numeric', 0),
(2056, 1, 1028, 'Maximum size for attachment must be numeric', 0),
(2057, 0, 1029, 'Required field - Incident hash prefix', 0),
(2058, 1, 1029, 'Required field - Incident hash prefix', 0),
(2059, 0, 1030, 'Required field - Numbering starts from', 0),
(2060, 1, 1030, 'Required field - Numbering starts from', 0),
(2061, 0, 1031, 'Incident post count must be numeric', 0),
(2062, 1, 1031, 'Incident post count must be numeric', 0),
(2063, 0, 1032, 'Forward to field is empty', 0),
(2064, 1, 1032, 'Forward to field is empty', 0),
(2065, 0, 1033, 'Email address missing or invalid email format in forward to field', 0),
(2066, 1, 1033, 'Email address missing or invalid email format in forward to field', 0),
(2067, 0, 1034, 'Mark as ban', 0),
(2068, 1, 1034, 'Mark as ban', 0),
(2069, 0, 1035, 'Mark as spam', 0),
(2070, 1, 1035, 'Mark as spam', 0),
(2071, 0, 1036, 'Execution order must be numeric', 0),
(2072, 1, 1036, 'Execution order must be numeric', 0),
(2073, 0, 1037, 'Can not remove default criteria', 0),
(2074, 1, 1037, 'Can not remove default criteria', 0),
(2075, 0, 1038, 'Autoresponder email', 0),
(2076, 1, 1038, 'Autoresponder email', 0),
(2077, 0, 1039, 'Update product', 0),
(2078, 1, 1039, 'Update product', 0),
(2079, 0, 1040, 'Update payment gateway', 0),
(2080, 1, 1040, 'Update payment gateway', 0),
(2081, 0, 1041, 'Update tax rule', 0),
(2082, 1, 1041, 'Update tax rule', 0),
(2083, 0, 1042, 'Transaction key field is empty', 0),
(2084, 1, 1042, 'Transaction key field is empty', 0),
(2085, 0, 1043, 'Add localization', 0),
(2086, 1, 1043, 'Add localization', 0),
(2087, 0, 1044, 'Search word / Phrases...', 0),
(2088, 1, 1044, 'Search word / Phrases...', 0),
(2089, 0, 1045, 'Language variable', 0),
(2090, 1, 1045, 'Language variable', 0),
(2091, 0, 1046, 'Language value', 0),
(2092, 1, 1046, 'Language value', 0),
(2093, 0, 1047, 'Language translation', 0),
(2094, 1, 1047, 'Language translation', 0),
(2095, 0, 1048, 'Language variable should be in capital letters', 0),
(2096, 1, 1048, 'Language variable should be in capital letters', 0),
(2097, 0, 1049, 'Language variable is already exist', 0),
(2098, 1, 1049, 'Language variable is already exist', 0),
(2099, 0, 1050, 'Enter word / phrases in search box', 0),
(2100, 1, 1050, 'Enter word / phrases in search box', 0),
(2101, 0, 1051, 'Delete localization', 0),
(2102, 1, 1051, 'Delete localization', 0),
(2103, 0, 1052, 'Per', 0),
(2104, 1, 1052, 'per', 0),
(2105, 0, 1053, 'Week', 0),
(2106, 1, 1053, 'Week', 0),
(2107, 0, 1054, 'Incidents by incident types', 0),
(2108, 1, 1054, 'Incidents by incident types', 0),
(2109, 0, 1055, 'Incidents by channels', 0),
(2110, 1, 1055, 'Incidents by channels', 0),
(2111, 0, 1056, 'Incidents by priorities', 0),
(2112, 1, 1056, 'Incidents by priorities', 0),
(2113, 0, 1057, 'Points', 0),
(2114, 1, 1057, 'Points', 0),
(2115, 0, 1058, 'Incident replied after overdue time', 0),
(2116, 1, 1058, 'Incident replied after overdue time', 0),
(2117, 0, 1059, 'Incident replied without SLA', 0),
(2118, 1, 1059, 'Incident replied without SLA', 0),
(2119, 0, 1060, 'Incident replied within due time', 0),
(2120, 1, 1060, 'Incident replied within due time', 0),
(2121, 0, 1061, 'All domain', 0),
(2122, 1, 1061, 'All domain', 0),
(2123, 0, 1062, 'Hide recipient and people', 0),
(2124, 1, 1062, 'Hide recipient and people', 0),
(2125, 0, 1063, 'Update channel', 0),
(2126, 1, 1063, 'Update channel', 0),
(2127, 0, 1064, 'Delete channel', 0),
(2128, 1, 1064, 'Delete channel', 0),
(2129, 0, 1065, 'Height', 0),
(2130, 1, 1065, 'Height', 0),
(2131, 0, 1066, 'Default channel can not be updated', 0),
(2132, 1, 1066, 'Default channel can not be updated', 0),
(2133, 0, 1067, 'Maximum image upload height/width is 25 px', 0),
(2134, 1, 1067, 'Maximum image upload height/width is 25 px', 0),
(2135, 0, 1068, 'Core channel status can not be changed', 0),
(2136, 1, 1068, 'Core channel status can not be changed', 0),
(2137, 0, 1069, 'Maintain', 0),
(2138, 1, 1069, 'Maintain', 0),
(2139, 0, 1070, 'Select staff for share', 0),
(2140, 1, 1070, 'Select staff for share', 0),
(2141, 0, 1071, 'Enable incident conversion', 0),
(2142, 1, 1071, 'Enable incident conversion', 0),
(2143, 0, 1072, 'Record not found', 0),
(2144, 1, 1072, 'Record not found', 0),
(2145, 0, 1073, 'Type title', 0),
(2146, 1, 1073, 'Type title', 0),
(2147, 0, 1074, 'Searching', 0),
(2148, 1, 1074, 'Searching', 0),
(2149, 0, 1075, 'Required fields are empty', 0),
(2150, 1, 1075, 'Required fields are empty', 0),
(2151, 0, 1076, 'Add tag', 0),
(2152, 1, 1076, 'Add tag', 0),
(2153, 0, 1077, 'Delete blab comment', 0),
(2154, 1, 1077, 'Delete blab comment', 0),
(2155, 0, 1078, 'Login time', 0),
(2156, 1, 1078, 'Login time', 0),
(2157, 0, 1079, 'Online', 0),
(2158, 1, 1079, 'Online', 0),
(2159, 0, 1080, 'Offline', 0),
(2160, 1, 1080, 'Offline', 0),
(2161, 0, 1081, 'Type comment here', 0),
(2162, 1, 1081, 'Type comment here', 0),
(2163, 0, 1082, 'Shared with', 0),
(2164, 1, 1082, 'Shared with', 0),
(2165, 0, 1083, 'Reply with quote', 0),
(2166, 1, 1083, 'Reply with quote', 0),
(2167, 0, 1084, 'Display note(s) on incident details', 0),
(2168, 1, 1084, 'Display note(s) on incident details', 0),
(2169, 0, 1085, 'Notes', 0),
(2170, 1, 1085, 'Notes', 0),
(2171, 0, 1086, 'Enter text', 0),
(2172, 1, 1086, 'Enter text', 0),
(2173, 0, 1087, 'Type to search existing clients email address', 0),
(2174, 1, 1087, 'Type to search existing clients email address', 0),
(2175, 0, 1088, 'Type here and press enter to save', 0),
(2176, 1, 1088, 'Type here and press enter to save', 0),
(2177, 0, 1089, 'Core organization status can not be changed', 0),
(2178, 1, 1089, 'Core organization status can not be changed', 0),
(2179, 0, 1090, 'Open and track support incident', 0),
(2180, 1, 1090, 'Open and track support incident', 0),
(2181, 0, 1091, 'Service request assigned to nobody', 0),
(2182, 1, 1091, 'Service request assigned to nobody', 0),
(2183, 0, 1092, 'Incident credit', 0),
(2184, 1, 1092, 'Incident credit', 0),
(2185, 0, 1093, 'Required data not submitted', 0),
(2186, 1, 1093, 'Required data not submitted', 0),
(2187, 0, 1094, '<div class="alert-success">Operation completed successfully</div>', 0),
(2188, 1, 1094, '<div class="alert-success">Operation completed successfully</div>', 0),
(2189, 0, 1095, '<div class="vis_msg_err">Error in operation</div>', 0),
(2190, 1, 1095, '<div class="vis_msg_err">Error in operation</div>', 0),
(2191, 0, 1096, 'Link', 0),
(2192, 1, 1096, 'Link', 0),
(2193, 0, 1097, 'Relates to', 0),
(2194, 1, 1097, 'Relates to', 0),
(2195, 0, 1098, 'Is related to', 0),
(2196, 1, 1098, 'Is related to', 0),
(2197, 0, 1099, 'Is a parent of', 0),
(2198, 1, 1099, 'Is a parent of', 0),
(2199, 0, 1100, 'Is a child of', 0),
(2200, 1, 1100, 'Is a child of', 0),
(2201, 0, 1101, 'Depends on', 0),
(2202, 1, 1101, 'Depends on', 0),
(2203, 0, 1102, 'Is depended on', 0),
(2204, 1, 1102, 'Is depended on', 0),
(2205, 0, 1103, 'Duplicates', 0),
(2206, 1, 1103, 'Duplicates', 0),
(2207, 0, 1104, 'Is duplicated by', 0),
(2208, 1, 1104, 'Is duplicated by', 0),
(2209, 0, 1105, 'Profile URL', 0),
(2210, 1, 1105, 'Profile URL', 0),
(2211, 0, 1106, 'Delete link', 0),
(2212, 1, 1106, 'Delete link', 0),
(2213, 0, 1107, 'Unlink', 0),
(2214, 1, 1107, 'Unlink', 0),
(2215, 0, 1108, 'Link incident', 0),
(2216, 1, 1108, 'Link incident', 0),
(2217, 0, 1109, 'Split', 0),
(2218, 1, 1109, 'Split', 0),
(2219, 0, 1110, 'Split incident post', 0),
(2220, 1, 1110, 'Split incident post', 0),
(2221, 0, 1111, 'Split into', 0),
(2222, 1, 1111, 'Split into', 0),
(2223, 0, 1112, 'Existing incident', 0),
(2224, 1, 1112, 'Existing incident', 0),
(2225, 0, 1113, 'Enter incident subject', 0),
(2226, 1, 1113, 'Enter incident subject', 0),
(2227, 0, 1114, 'Enter incident hash', 0),
(2228, 1, 1114, 'Enter incident hash', 0),
(2229, 0, 1115, 'Level title', 0),
(2230, 1, 1115, 'Level title', 0),
(2231, 0, 1116, 'Invoice date', 0),
(2232, 1, 1116, 'Invoice date', 0),
(2233, 0, 1117, 'Required details for checked fields', 0),
(2234, 1, 1117, 'Required details for checked fields', 0),
(2235, 0, 1118, 'Invoice items', 0),
(2236, 1, 1118, 'Invoice items', 0),
(2237, 0, 1119, 'Descriptions', 0),
(2238, 1, 1119, 'Descriptions', 0),
(2239, 0, 1120, 'Taxed', 0),
(2240, 1, 1120, 'Taxed', 0),
(2241, 0, 1121, 'Apply credit', 0),
(2242, 1, 1121, 'Apply credit', 0),
(2243, 0, 1122, 'Approval require', 0),
(2244, 1, 1122, 'Approval require', 0),
(2245, 0, 1123, 'Amount should be numeric', 0),
(2246, 1, 1123, 'Amount should be numeric', 0),
(2247, 0, 1124, 'Available credit', 0),
(2248, 1, 1124, 'Available credit', 0),
(2249, 0, 1125, 'Delete invoice item', 0),
(2250, 1, 1125, 'Delete invoice item', 0),
(2251, 0, 1126, 'Remove credit', 0),
(2252, 1, 1126, 'Remove credit', 0),
(2253, 0, 1127, 'Credit applied', 0),
(2254, 1, 1127, 'Credit applied', 0),
(2255, 0, 1128, 'Numeric value required for credit applied', 0),
(2256, 1, 1128, 'Numeric value required for credit applied', 0),
(2257, 0, 1129, 'Credit to be removed should not be greater than credit applied', 0),
(2258, 1, 1129, 'Credit to be removed should not be greater than credit applied', 0),
(2259, 0, 1130, 'You don''t have sufficient credit to apply', 0),
(2260, 1, 1130, 'You don''t have sufficient credit to apply', 0),
(2261, 0, 1131, 'Select email template', 0),
(2262, 1, 1131, 'Select email template', 0),
(2263, 0, 1132, 'Delete order', 0),
(2264, 1, 1132, 'Delete order', 0),
(2265, 0, 1133, 'You cannot apply more credit than the invoice total', 0),
(2266, 1, 1133, 'You cannot apply more credit than the invoice total', 0),
(2267, 0, 1134, 'Articles are not selected', 0),
(2268, 1, 1134, 'Articles are not selected', 0),
(2269, 0, 1135, 'Disapprove', 0),
(2270, 1, 1135, 'Disapprove', 0),
(2271, 0, 1136, 'Comments not selected', 0),
(2272, 1, 1136, 'Comments not selected', 0),
(2273, 1, 1137, 'Search solution', 0),
(2274, 0, 1137, 'Search solution....', 0),
(2275, 0, 1138, 'Enter article in search box', 0),
(2276, 1, 1138, 'Enter article in search box', 0),
(2277, 0, 1139, 'Social media details', 0),
(2278, 1, 1139, 'Social media details', 0),
(2279, 0, 1140, 'Ignored', 0),
(2280, 1, 1140, 'Ignored', 0),
(2281, 0, 1141, 'License control status', 0),
(2282, 1, 1141, 'License control status', 0),
(2283, 0, 1142, 'Gamification', 0),
(2284, 1, 1142, 'Gamification', 0),
(2285, 0, 1143, 'Add point', 0),
(2286, 1, 1143, 'Add point', 0),
(2287, 0, 1144, 'Bonus points', 0),
(2288, 1, 1144, 'Bonus points', 0),
(2289, 0, 1145, 'Award points', 0),
(2290, 1, 1145, 'Award points', 0),
(2291, 0, 1146, 'Staff levels', 0),
(2292, 1, 1146, 'Staff levels', 0),
(2293, 0, 1147, 'King', 0),
(2294, 1, 1147, 'King', 0),
(2295, 0, 1148, 'Queen', 0),
(2296, 1, 1148, 'Queen', 0),
(2297, 0, 1149, 'Rook', 0),
(2298, 1, 1149, 'Rook', 0),
(2299, 0, 1150, 'Bishop', 0),
(2300, 1, 1150, 'Bishop', 0),
(2301, 0, 1151, 'Knight', 0),
(2302, 1, 1151, 'Knight', 0),
(2303, 0, 1152, 'Pawn', 0),
(2304, 1, 1152, 'Pawn', 0),
(2305, 0, 1153, 'Points value must be numerical', 0),
(2306, 1, 1153, 'Points value must be numerical', 0),
(2307, 0, 1154, 'Quest', 0),
(2308, 1, 1154, 'Quest', 0),
(2309, 0, 1155, 'Add quest', 0),
(2310, 1, 1155, 'Add quest', 0),
(2311, 0, 1156, 'Quest type', 0),
(2312, 1, 1156, 'Quest type', 0),
(2313, 0, 1157, 'Solving incidents', 0),
(2314, 1, 1157, 'Solving incidents', 0),
(2315, 0, 1158, 'Quest objectives', 0),
(2316, 1, 1158, 'Quest objectives', 0),
(2317, 0, 1159, 'Solve', 0),
(2318, 1, 1159, 'Solve', 0),
(2319, 0, 1160, 'Badge', 0),
(2320, 1, 1160, 'Badge', 0),
(2321, 0, 1161, 'Name your quest', 0),
(2322, 1, 1161, 'Name your quest', 0),
(2323, 0, 1162, 'Quest description', 0),
(2324, 1, 1162, 'Quest description', 0),
(2325, 0, 1163, 'Article comment', 0),
(2326, 1, 1163, 'Article comment', 0),
(2327, 0, 1164, 'Incidents in a span of', 0),
(2328, 1, 1164, 'Incidents in a span of', 0),
(2329, 0, 1165, 'Matching below conditions', 0),
(2330, 1, 1165, 'Matching below conditions', 0),
(2331, 0, 1166, 'Solution base article in a span of', 0),
(2332, 1, 1166, 'Solution base article in a span of', 0),
(2333, 0, 1167, 'Create', 0),
(2334, 1, 1167, 'Create', 0),
(2335, 0, 1168, 'Delete quest', 0),
(2336, 1, 1168, 'Delete quest', 0),
(2337, 0, 1169, 'Update quest', 0),
(2338, 1, 1169, 'Update quest', 0),
(2339, 0, 1170, 'Select a badge', 0),
(2340, 1, 1170, 'Select a badge', 0),
(2341, 0, 1171, 'Badge is required', 0),
(2342, 1, 1171, 'Badge is required', 0),
(2343, 0, 1172, 'Invoice not selected', 0),
(2344, 1, 1172, 'Invoice not selected', 0),
(2345, 0, 1173, 'This incident is linked with other', 0),
(2346, 1, 1173, 'This incident is linked with other', 0),
(2347, 0, 1174, 'Transaction', 0),
(2348, 1, 1174, 'Transaction', 0),
(2349, 0, 1175, 'Update order', 0),
(2350, 1, 1175, 'Update order', 0),
(2351, 0, 1176, 'Payment status', 0),
(2352, 1, 1176, 'Payment status', 0),
(2353, 0, 1177, 'No invoice', 0),
(2354, 1, 1177, 'No invoice', 0),
(2355, 0, 1178, 'Add payment', 0),
(2356, 1, 1178, 'Add payment', 0),
(2357, 0, 1179, 'Numeric value required for all fields', 0),
(2358, 1, 1179, 'Numeric value required for all fields', 0),
(2359, 0, 1180, 'Enter text to search', 0),
(2360, 1, 1180, 'Enter text to search', 0),
(2361, 0, 1181, 'Nothing to display here yet...', 0),
(2362, 1, 1181, 'Nothing to display here yet...', 0),
(2363, 0, 1182, 'Today ''s', 0),
(2364, 1, 1182, 'Today ''s', 0),
(2365, 0, 1183, 'Search invoice', 0),
(2366, 1, 1183, 'Search invoice', 0),
(2367, 0, 1184, 'Filter result', 0),
(2368, 1, 1184, 'Filter result', 0),
(2369, 0, 1185, 'Sort by', 0),
(2370, 1, 1185, 'Sort by', 0),
(2371, 0, 1186, 'Select staff', 0),
(2372, 1, 1186, 'Select staff', 0),
(2373, 0, 1187, 'List count should be numeric', 0),
(2374, 1, 1187, 'List count should be numeric', 0),
(2375, 0, 1188, 'Active', 0),
(2376, 1, 1188, 'Active', 0),
(2377, 0, 1189, 'Pending', 0),
(2378, 1, 1189, 'Pending', 0),
(2379, 0, 1190, 'Incomplete', 0),
(2380, 1, 1190, 'Incomplete', 0),
(2381, 0, 1191, 'Invoice due on (days)', 0),
(2382, 1, 1191, 'Invoice due on (days)', 0),
(2383, 0, 1192, 'Numeric value required for invoice due on (days) field', 0),
(2384, 1, 1192, 'Numeric value required for invoice due on (days) field', 0),
(2385, 0, 1193, 'Numeric value required for bill rate field', 0),
(2386, 1, 1193, 'Numeric value required for bill rate field', 0),
(2387, 0, 1194, 'Overview', 0),
(2388, 1, 1194, 'Overview', 0),
(2389, 0, 1195, 'Total incidents', 0),
(2390, 1, 1195, 'Total incidents', 0),
(2391, 0, 1196, 'Total incidents replied', 0),
(2392, 1, 1196, 'Total incidents replied', 0),
(2393, 0, 1197, 'Incidents replied per hour', 0),
(2394, 1, 1197, 'Incidents replied per hour', 0),
(2395, 0, 1198, 'Total incidents closed', 0),
(2396, 1, 1198, 'Total incidents closed', 0),
(2397, 0, 1199, 'Total overdue incidents', 0),
(2398, 1, 1199, 'Total overdue incidents', 0),
(2399, 0, 1200, 'AVG. SLA maintained', 0),
(2400, 1, 1200, 'AVG. SLA maintained', 0),
(2401, 0, 1201, 'Yesterday', 0),
(2402, 1, 1201, 'Yesterday', 0),
(2403, 0, 1202, 'Selfhelp article', 0),
(2404, 1, 1202, 'Solutions article', 0),
(2405, 0, 1203, 'Incidents by status', 0),
(2406, 1, 1203, 'Incidents by status', 0),
(2407, 0, 1204, 'Text', 0),
(2408, 1, 1204, 'Text', 0),
(2409, 0, 1205, 'Last month', 0),
(2410, 1, 1205, 'Last month', 0),
(2411, 0, 1206, 'Last week', 0),
(2412, 1, 1206, 'Last week', 0),
(2413, 0, 1207, 'Credit should be numeric', 0),
(2414, 1, 1207, 'Credit should be numeric', 0),
(2415, 1, 1208, '<div class="alert-success">Password reset and new password sent to client</div>', 0),
(2416, 0, 1208, '<div class="alert-success">Password reset and new password sent to client</div>', 0),
(2417, 0, 1209, 'Resolusion', 0),
(2418, 1, 1209, 'Resolusion', 0),
(2419, 0, 1210, 'Locked', 0),
(2420, 1, 1210, 'Locked', 0),
(2421, 0, 1211, 'Unlocked', 0),
(2422, 1, 1211, 'Unlocked', 0),
(2423, 0, 1212, 'Client language', 0),
(2424, 1, 1212, 'Client language', 0),
(2425, 0, 1213, 'To email', 0),
(2426, 1, 1213, 'To email', 0),
(2427, 0, 1214, 'Delete pin', 0),
(2428, 1, 1214, 'Delete pin', 0),
(2429, 0, 1215, 'Incidents can not move from one domain to other domain', 0),
(2430, 1, 1215, 'Incidents can not move from one domain to other domain', 0),
(2431, 0, 1216, 'Send to', 0),
(2432, 1, 1216, 'Send to', 0),
(2433, 0, 1217, 'All team', 0),
(2434, 1, 1217, 'All teams', 0),
(2435, 0, 1218, 'Enter incident hash to merge', 0),
(2436, 1, 1218, 'Enter incident hash to merge', 0),
(2437, 0, 1219, 'Enter incident hash for link', 0),
(2438, 1, 1219, 'Enter incident hash for link', 0),
(2439, 0, 1220, 'Multiple owners', 0),
(2440, 1, 1220, 'Multiple owners', 0),
(2441, 0, 1221, 'Owners', 0),
(2442, 1, 1221, 'Owners', 0),
(2443, 0, 1222, 'Send notification for new blab', 0),
(2444, 1, 1222, 'Send notification for new blab', 0),
(2445, 0, 1223, 'Change label', 0),
(2446, 1, 1223, 'Change label', 0),
(2447, 0, 1224, 'Change channel', 0),
(2448, 1, 1224, 'Change channel', 0),
(2449, 1, 1225, 'Incidents belonging to other domain should not get merged', 0),
(2450, 0, 1225, 'Incidents from different domain can not be merged', 0),
(2451, 0, 1226, 'Forwarded to', 0),
(2452, 1, 1226, 'Forwarded to', 0),
(2453, 0, 1227, 'To', 0),
(2454, 1, 1227, 'To', 0),
(2455, 0, 1228, 'Replied to', 0),
(2456, 1, 1228, 'Replied to', 0),
(2457, 0, 1229, 'Security', 0),
(2458, 1, 1229, 'Security', 0),
(2459, 0, 1230, 'Send registration email', 0),
(2460, 1, 1230, 'Send registration email', 0),
(2461, 0, 1231, 'One option value should be required', 0),
(2462, 1, 1231, 'One option value should be required', 0),
(2463, 0, 1232, 'Auto generate password', 0),
(2464, 1, 1232, 'Auto generate password', 0),
(2465, 0, 1233, 'Add security', 0),
(2466, 1, 1233, 'Add security', 0),
(2467, 0, 1234, 'IP security', 0),
(2468, 1, 1234, 'IP security', 0),
(2469, 0, 1235, 'Password security', 0),
(2470, 1, 1235, 'Password security', 0),
(2471, 0, 1236, 'Is security IP active?', 0),
(2472, 1, 1236, 'Staff login IP restriction', 0),
(2473, 0, 1237, 'Single', 0),
(2474, 1, 1237, 'Single', 0),
(2475, 0, 1238, 'Range', 0),
(2476, 1, 1238, 'Range', 0),
(2477, 0, 1239, 'Resolusion on', 0),
(2478, 1, 1239, 'Resolusion on', 0),
(2479, 0, 1240, 'Password format', 0),
(2480, 1, 1240, 'Password format', 0),
(2481, 0, 1241, 'Show password', 0),
(2482, 1, 1241, 'Show password', 0),
(2483, 1, 1242, 'Image verification mismatch', 0),
(2484, 0, 1242, 'Image verification missmatch', 0),
(2485, 1, 1243, 'Display custom fields on incident details', 0),
(2486, 0, 1243, 'Display custom fileds on incident details', 0),
(2487, 0, 1244, 'More than one post required for split', 0),
(2488, 1, 1244, 'More than one post required for split', 0),
(2489, 0, 1245, '(Ex. 198.168.1.10-198.168.1.50)', 0),
(2490, 1, 1245, '(Range eg. 78.68.1.10-78.68.1.50)', 0),
(2491, 1, 1246, 'Allowed IP or IP range', 0),
(2492, 0, 1246, 'IP or IP range', 0),
(2493, 0, 1247, 'Delete security', 0),
(2494, 1, 1247, 'Delete security', 0),
(2495, 1, 1248, 'Invalid IP address range', 0),
(2496, 0, 1248, 'Invalid IP range', 0),
(2497, 0, 1249, 'Invalid IP address', 0),
(2498, 1, 1249, 'Invalid IP address', 0),
(2499, 1, 1250, 'Access denied for your IP', 0),
(2500, 0, 1250, 'Your IP address is blocked!', 0),
(2501, 0, 1251, 'Macros', 0),
(2502, 1, 1251, 'Macros', 0),
(2503, 0, 1252, 'Add macro', 0),
(2504, 1, 1252, 'Add macro', 0),
(2505, 0, 1253, 'Update macro', 0),
(2506, 1, 1253, 'Update macro', 0),
(2507, 0, 1254, 'IP or IP range list', 0),
(2508, 1, 1254, 'IP or IP range list', 0),
(2509, 0, 1255, 'Apply macro', 0),
(2510, 1, 1255, 'Apply macro', 0),
(2511, 0, 1256, 'Password strength', 0),
(2512, 1, 1256, 'Password strength', 0),
(2513, 0, 1257, 'Weak', 0),
(2514, 1, 1257, 'Weak', 0),
(2515, 0, 1258, 'Medium', 0),
(2516, 1, 1258, 'Medium', 0),
(2517, 0, 1259, 'Strong', 0),
(2518, 1, 1259, 'Strong', 0),
(2519, 0, 1260, 'Very strong', 0),
(2520, 1, 1260, 'Very strong', 0),
(2521, 0, 1261, 'Not allowed', 0),
(2522, 1, 1261, 'Not allowed', 0),
(2523, 0, 1262, 'Allowed', 0),
(2524, 1, 1262, 'Allowed', 0),
(2525, 0, 1263, 'Password strength not allowed', 0),
(2526, 1, 1263, 'Password strength not allowed', 0),
(2527, 0, 1264, 'Display settings', 0),
(2528, 1, 1264, 'Display settings', 0),
(2529, 0, 1265, 'Expense type', 0),
(2530, 1, 1265, 'Expense type', 0),
(2531, 0, 1266, 'Redirect URL', 0),
(2532, 1, 1266, 'Redirect URL', 0),
(2533, 0, 1267, 'Developer key', 0),
(2534, 1, 1267, 'Developer key', 0),
(2535, 0, 1268, 'Activity log', 0),
(2536, 1, 1268, 'Activity log', 0),
(2537, 0, 1269, 'Activity', 0),
(2538, 1, 1269, 'Activity', 0),
(2539, 0, 1270, 'Empty activity log', 0),
(2540, 1, 1270, 'Empty activity log', 0),
(2541, 1, 1271, 'Add survey group', 0),
(2542, 0, 1271, 'Add survey group', 0),
(2543, 1, 1272, 'Update survey group', 0),
(2544, 0, 1272, 'Update survey group', 0),
(2545, 1, 1273, 'Delete survey group', 0),
(2546, 0, 1273, 'Delete survey group', 0),
(2547, 0, 1274, 'Deletion of survey group will delete survey in this survey group', 0),
(2548, 1, 1274, 'Deletion of survey group will delete survey in this survey group', 0),
(2549, 0, 1275, 'Cost model', 0),
(2550, 1, 1275, 'Cost model', 0),
(2551, 0, 1276, 'Add survey', 0),
(2552, 1, 1276, 'Add survey', 0),
(2553, 0, 1277, 'Update survey', 0),
(2554, 1, 1277, 'Update survey', 0),
(2555, 0, 1278, 'Delete survey', 0),
(2556, 1, 1278, 'Delete survey', 0),
(2557, 0, 1279, 'Survey field', 0),
(2558, 1, 1279, 'Survey field', 0),
(2559, 0, 1280, 'Add survey field', 0),
(2560, 1, 1280, 'Add survey field', 0),
(2561, 0, 1281, 'Delete survey field', 0),
(2562, 1, 1281, 'Delete survey field', 0),
(2563, 0, 1282, 'Update survey field', 0),
(2564, 1, 1282, 'Update survey field', 0),
(2565, 0, 1283, 'Survey', 0),
(2566, 1, 1283, 'Survey', 0),
(2567, 0, 1284, 'You have already submited survey', 0),
(2568, 1, 1284, 'You have already submited survey', 0),
(2569, 0, 1285, 'Visitor', 0),
(2570, 1, 1285, 'Visitor', 0),
(2571, 0, 1286, 'Chat details', 0),
(2572, 1, 1286, 'Chat details', 0),
(2573, 0, 1287, 'Chat transcript', 0),
(2574, 1, 1287, 'Chat transcript', 0),
(2575, 0, 1288, 'Chat', 0),
(2576, 1, 1288, 'Chat', 0),
(2577, 1, 1289, 'Password and confirm password mismatch', 0),
(2578, 0, 1289, 'Password and confirm password mismatch', 0),
(2579, 0, 1290, 'Script', 0),
(2580, 1, 1290, 'Script', 0),
(2581, 0, 1291, 'Date from', 0),
(2582, 1, 1291, 'Date from', 0),
(2583, 0, 1292, 'Date to', 0),
(2584, 1, 1292, 'Date to', 0),
(2585, 0, 1293, 'Visitor email', 0),
(2586, 1, 1293, 'Visitor email', 0),
(2587, 0, 1294, 'Visitor name', 0),
(2588, 1, 1294, 'Visitor name', 0),
(2589, 0, 1295, 'Staff name', 0),
(2590, 1, 1295, 'Staff name', 0),
(2591, 0, 1296, 'Chat duration', 0),
(2592, 1, 1296, 'Chat duration', 0),
(2593, 0, 1297, 'Select module', 0),
(2594, 1, 1297, 'Select module', 0),
(2595, 1, 1298, 'Email address missing or invalid email format', 0),
(2596, 0, 1298, 'Email address missing or invalid email format', 0),
(2597, 0, 1299, 'Invalid login details', 0),
(2598, 1, 1299, 'Invalid login details', 0),
(2599, 1, 1300, 'Clean up', 0),
(2600, 0, 1300, 'Clean up', 0),
(2601, 0, 1301, 'Convert to incident', 0),
(2602, 1, 1301, 'Convert to incident', 0),
(2603, 0, 1302, 'System clean up', 0),
(2604, 1, 1302, 'System clean up', 0),
(2605, 0, 1303, 'Clean logs before', 0),
(2606, 1, 1303, 'Clean logs before', 0),
(2607, 0, 1304, 'Client email missing', 0),
(2608, 1, 1304, 'Client email missing', 0),
(2609, 0, 1305, 'This will empty the error log file', 0),
(2610, 1, 1305, 'This will empty the error log file', 0),
(2611, 0, 1306, 'Remove parser log before selected date', 0),
(2612, 1, 1306, 'Remove parser log before selected date', 0),
(2613, 0, 1307, 'Remove sent email log before selected date', 0),
(2614, 1, 1307, 'Remove sent email log before selected date', 0),
(2615, 0, 1308, 'Remove gateway transactions log before selected date', 0),
(2616, 1, 1308, 'Remove gateway transactions log before selected date', 0),
(2617, 0, 1309, 'Remove activity log before selected date', 0),
(2618, 1, 1309, 'Remove activity log before selected date', 0),
(2619, 0, 1310, 'This will remove incidents audit log before selected date leaving incidents as it is', 0),
(2620, 1, 1310, 'This will remove incidents audit log before selected date leaving incidents as it is', 0),
(2621, 0, 1311, 'Asset department', 0),
(2622, 1, 1311, 'Asset department', 0),
(2623, 0, 1312, 'Survey is disabled or removed.', 0),
(2624, 1, 1312, 'Survey is disabled or removed.', 0),
(2625, 0, 1313, 'Checkout', 0),
(2626, 1, 1313, 'Checkout', 0),
(2627, 1, 1314, 'Selected package', 0),
(2628, 0, 1314, 'Selected product', 0),
(2629, 0, 1315, 'Subtotal', 0),
(2630, 1, 1315, 'Subtotal', 0),
(2631, 0, 1316, 'Select survey', 0),
(2632, 1, 1316, 'Select survey', 0),
(2633, 0, 1317, 'Auto discovery', 0),
(2634, 1, 1317, 'Auto discovery', 0),
(2635, 0, 1318, 'Task title', 0),
(2636, 1, 1318, 'Task title', 0),
(2637, 0, 1319, 'Import', 0),
(2638, 1, 1319, 'Import', 0),
(2639, 0, 1320, 'File type must be CSV', 0),
(2640, 1, 1320, 'File type must be CSV', 0),
(2641, 0, 1321, 'Upload CSV', 0),
(2642, 1, 1321, 'Upload CSV', 0),
(2643, 0, 1322, 'Access denied', 0),
(2644, 1, 1322, 'Access denied', 0),
(2645, 0, 1323, 'Search string', 0),
(2646, 1, 1323, 'Search string', 0),
(2647, 0, 1324, 'Click here', 0),
(2648, 1, 1324, 'Click here', 0),
(2649, 0, 1325, 'Set schedule', 0),
(2650, 1, 1325, 'Set schedule', 0),
(2651, 0, 1326, 'Send login details to staff', 0),
(2652, 1, 1326, 'Send staff registration email', 0),
(2653, 0, 1327, 'Do not send email', 0),
(2654, 1, 1327, 'Do not send email', 0),
(2655, 0, 1328, 'Select client', 0),
(2656, 1, 1328, 'Select client', 0),
(2657, 0, 1329, 'GoToMeeting', 0),
(2658, 1, 1329, 'GoToMeeting', 0),
(2659, 0, 1330, 'Fields not selected', 0),
(2660, 1, 1330, 'Fields not selected', 0),
(2661, 0, 1331, 'Survey date', 0),
(2662, 1, 1331, 'Survey date', 0),
(2663, 0, 1332, 'Callback URL', 0),
(2664, 1, 1332, 'Callback URL', 0),
(2665, 0, 1333, 'Survey details', 0),
(2666, 1, 1333, 'Survey details', 0),
(2667, 0, 1334, 'Mark as complete', 0),
(2668, 1, 1334, 'Mark as complete', 0),
(2669, 0, 1335, 'Data wiping', 0),
(2670, 1, 1335, 'Data wiping', 0),
(2671, 0, 1336, 'Or', 0),
(2672, 1, 1336, 'Or', 0),
(2673, 0, 1337, 'Edit custom field', 0),
(2674, 1, 1337, 'Edit custom field', 0),
(2675, 0, 1338, 'Not specified', 0),
(2676, 1, 1338, 'Not specified', 0),
(2677, 0, 1339, 'Send data wiping request (This will show assets which require data wiping and user can complete data wiping process for this asset once it is done)', 0),
(2678, 1, 1339, 'Send data wiping request (This will show assets which require data wiping and user can complete data wiping process for this asset once it is done)', 0),
(2679, 0, 1340, 'Meeting ID', 0),
(2680, 1, 1340, 'Meeting ID', 0),
(2681, 0, 1341, 'Max participants', 0),
(2682, 1, 1341, 'Max participants', 0),
(2683, 0, 1342, 'Meeting key', 0),
(2684, 1, 1342, 'Meeting key', 0),
(2685, 0, 1343, 'Meeting type', 0),
(2686, 1, 1343, 'Meeting type', 0),
(2687, 0, 1344, 'Meeting unique key', 0),
(2688, 1, 1344, 'Meeting unique key', 0),
(2689, 0, 1345, 'Add meeting', 0),
(2690, 1, 1345, 'Add meeting', 0),
(2691, 0, 1346, 'Password required', 0),
(2692, 1, 1346, 'Password required', 0),
(2693, 0, 1347, 'Immediate', 0),
(2694, 1, 1347, 'Immediate', 0),
(2695, 0, 1348, 'Scheduled', 0),
(2696, 1, 1348, 'Scheduled', 0),
(2697, 0, 1349, 'Remote access', 0),
(2698, 1, 1349, 'Remote access', 0),
(2699, 0, 1350, 'GoToAssist', 0),
(2700, 1, 1350, 'GoToAssist', 0),
(2701, 0, 1351, 'Integration APP', 0),
(2702, 1, 1351, 'Integration APP', 0),
(2703, 0, 1352, 'Legislation and compliance requirements', 0),
(2704, 1, 1352, 'Legislation and compliance requirements', 0),
(2705, 0, 1353, 'Download', 0),
(2706, 1, 1353, 'Download', 0),
(2707, 0, 1354, 'Next overdue incidents', 0),
(2708, 1, 1354, 'Next overdue incidents', 0),
(2709, 0, 1355, '15 minutes', 0),
(2710, 1, 1355, '15 minutes', 0),
(2711, 0, 1356, '30 minutes', 0),
(2712, 1, 1356, '30 minutes', 0),
(2713, 0, 1357, '1 day', 0);
INSERT INTO `avis_language_values` VALUES
(2714, 1, 1357, '1 day', 0),
(2715, 0, 1358, 'Task', 0),
(2716, 1, 1358, 'Task', 0),
(2717, 0, 1359, 'Today ''s task', 0),
(2718, 1, 1359, 'Today ''s task', 0),
(2719, 0, 1360, 'My task', 0),
(2720, 1, 1360, 'My task', 0),
(2721, 0, 1361, 'Assigned task', 0),
(2722, 1, 1361, 'Assigned task', 0),
(2723, 0, 1362, 'Overdue task', 0),
(2724, 1, 1362, 'Overdue task', 0),
(2725, 1, 1363, 'Mark as cancel', 0),
(2726, 0, 1363, 'Marked as cancel', 0),
(2727, 0, 1364, 'Update task', 0),
(2728, 1, 1364, 'Update task', 0),
(2729, 0, 1365, 'This task is already mark as cancelled', 0),
(2730, 1, 1365, 'This task is already mark as cancelled', 0),
(2731, 0, 1366, 'This task is already mark as completed', 0),
(2732, 1, 1366, 'This task is already mark as completed', 0),
(2733, 0, 1367, 'Delete meeting', 0),
(2734, 1, 1367, 'Delete meeting', 0),
(2735, 0, 1368, 'Status of task is overdue', 0),
(2736, 1, 1368, 'Status of task is overdue', 0),
(2737, 0, 1369, 'Add user', 0),
(2738, 1, 1369, 'Add user', 0),
(2739, 0, 1370, 'View and manage invoices, orders, packages', 0),
(2740, 1, 1370, 'View and manage invoices, orders, packages', 0),
(2741, 0, 1371, 'Participant web link', 0),
(2742, 1, 1371, 'Participant web link', 0),
(2743, 0, 1372, 'Search task', 0),
(2744, 1, 1372, 'Search task', 0),
(2745, 0, 1373, 'Conference call information', 0),
(2746, 1, 1373, 'Conference call information', 0),
(2747, 0, 1374, 'Enter task title in search box', 0),
(2748, 1, 1374, 'Enter task title in search box', 0),
(2749, 0, 1375, 'Create meeting', 0),
(2750, 1, 1375, 'Create meeting', 0),
(2751, 0, 1376, 'Meetings', 0),
(2752, 1, 1376, 'Meetings', 0),
(2753, 0, 1377, 'Join URL', 0),
(2754, 1, 1377, 'Join URL', 0),
(2755, 0, 1378, 'Join date', 0),
(2756, 1, 1378, 'Join date', 0),
(2757, 0, 1379, 'Add assist', 0),
(2758, 1, 1379, 'Add assist', 0),
(2759, 0, 1380, 'My favorites', 0),
(2760, 1, 1380, 'My favorites', 0),
(2761, 0, 1381, 'Custom data', 0),
(2762, 1, 1381, 'Custom data', 0),
(2763, 0, 1382, 'Copy to clipboard', 0),
(2764, 1, 1382, 'Select to copy', 0),
(2765, 0, 1383, 'Group ID', 0),
(2766, 1, 1383, 'Group ID', 0),
(2767, 0, 1384, 'Set as featured article', 0),
(2768, 1, 1384, 'Set as featured article', 0),
(2769, 0, 1385, 'Assigned user ID', 0),
(2770, 1, 1385, 'Assigned user ID', 0),
(2771, 0, 1386, 'Assigned at', 0),
(2772, 1, 1386, 'Assigned at', 0),
(2773, 0, 1387, 'End customer link', 0),
(2774, 1, 1387, 'End customer link', 0),
(2775, 0, 1388, 'Supporter link', 0),
(2776, 1, 1388, 'Supporter link', 0),
(2777, 0, 1389, 'Created at', 0),
(2778, 1, 1389, 'Created at', 0),
(2779, 0, 1390, 'Valid until', 0),
(2780, 1, 1390, 'Valid until', 0),
(2781, 0, 1391, 'Disposal regulations', 0),
(2782, 1, 1391, 'Disposal regulations', 0),
(2783, 0, 1392, 'Privacy documents', 0),
(2784, 1, 1392, 'Privacy documents', 0),
(2785, 0, 1393, 'Search state', 0),
(2786, 1, 1393, 'Search state', 0),
(2787, 0, 1394, 'Expert name', 0),
(2788, 1, 1394, 'Expert name', 0),
(2789, 0, 1395, 'Expert email', 0),
(2790, 1, 1395, 'Expert email', 0),
(2791, 0, 1396, 'Merge into', 0),
(2792, 1, 1396, 'Merge into', 0),
(2793, 0, 1397, 'Reset password', 0),
(2794, 1, 1397, 'Reset password', 0),
(2795, 0, 1398, 'Nobody', 0),
(2796, 1, 1398, 'Nobody', 0),
(2797, 0, 1399, 'Download queue', 0),
(2798, 1, 1399, 'Download queue', 0),
(2799, 0, 1400, 'Add report in download queue', 0),
(2800, 1, 1400, 'Request report', 0),
(2801, 0, 1401, 'Report title', 0),
(2802, 1, 1401, 'Report title', 0),
(2803, 0, 1402, 'Delete selfhelp comment', 0),
(2804, 1, 1402, 'Delete solutions comment', 0),
(2805, 0, 1403, 'Completed date', 0),
(2806, 1, 1403, 'Completed date', 0),
(2807, 0, 1404, 'Are you sure you want to proceed?', 0),
(2808, 1, 1404, 'Are you sure you want to proceed?', 0),
(2809, 0, 1405, 'Username already exists', 0),
(2810, 1, 1405, 'Username already exists', 0),
(2811, 0, 1406, 'Delete WebEx meeting', 0),
(2812, 1, 1406, 'Delete WebEx meeting', 0),
(2813, 0, 1407, 'Site ID', 0),
(2814, 1, 1407, 'Site ID', 0),
(2815, 0, 1408, 'Partner ID', 0),
(2816, 1, 1408, 'Partner ID', 0),
(2817, 0, 1409, 'Total posts count', 0),
(2818, 1, 1409, 'Total posts count', 0),
(2819, 0, 1410, 'Total AVG. response time', 0),
(2820, 1, 1410, 'Total AVG. response time', 0),
(2821, 0, 1411, 'Total AVG. SLA maintained', 0),
(2822, 1, 1411, 'Total AVG. SLA maintained', 0),
(2823, 0, 1412, 'Total AVG. SLA time', 0),
(2824, 1, 1412, 'Total AVG. SLA time', 0),
(2825, 0, 1413, 'Total AVG. resolve time', 0),
(2826, 1, 1413, 'Total AVG. resolve time', 0),
(2827, 0, 1414, 'Worst', 0),
(2828, 1, 1414, 'Worst', 0),
(2829, 0, 1415, 'Normal', 0),
(2830, 1, 1415, 'Normal', 0),
(2831, 0, 1416, 'Total bill time', 0),
(2832, 1, 1416, 'Total bill time', 0),
(2833, 0, 1417, 'Total work time', 0),
(2834, 1, 1417, 'Total work time', 0),
(2835, 0, 1418, 'Total amount', 0),
(2836, 1, 1418, 'Total amount', 0),
(2837, 0, 1419, 'Survey URL to add in email template', 0),
(2838, 1, 1419, 'Survey URL to add in email template', 0),
(2839, 0, 1420, 'Physical location', 0),
(2840, 1, 1420, 'Physical location', 0),
(2841, 0, 1421, 'Maximum image upload width is 1000 px', 0),
(2842, 1, 1421, 'Maximum image upload width is 1000 px', 0),
(2843, 1, 1422, 'Please select custom date', 0),
(2844, 0, 1422, 'Please select from date and to date', 0),
(2845, 0, 1423, 'Storage location', 0),
(2846, 1, 1423, 'Storage location', 0),
(2847, 0, 1424, 'Affected version', 0),
(2848, 1, 1424, 'Affected version', 0),
(2849, 0, 1425, 'Release version', 0),
(2850, 1, 1425, 'Release version', 0),
(2851, 0, 1426, 'Release distribution', 0),
(2852, 1, 1426, 'Release distribution', 0),
(2853, 0, 1427, 'Technology', 0),
(2854, 1, 1427, 'Technology', 0),
(2855, 0, 1428, 'Deployment description', 0),
(2856, 1, 1428, 'Deployment description', 0),
(2857, 0, 1429, 'Closed incidents', 0),
(2858, 1, 1429, 'Closed incidents', 0),
(2859, 0, 1430, 'Service validation and testing', 0),
(2860, 1, 1430, 'Service validation and testing', 0),
(2861, 0, 1431, 'Select organization', 0),
(2862, 1, 1431, 'Select organization', 0),
(2863, 0, 1432, 'Account SID', 0),
(2864, 1, 1432, 'Account SID', 0),
(2865, 0, 1433, 'Service transition', 0),
(2866, 1, 1433, 'Service transition', 0),
(2867, 0, 1434, 'Release component aquisition', 0),
(2868, 1, 1434, 'Release component aquisition', 0),
(2869, 1, 1435, 'Organization incidents', 0),
(2870, 0, 1435, 'Organizations incidents', 0),
(2871, 0, 1436, 'Operation date', 0),
(2872, 1, 1436, 'Operation date', 0),
(2873, 0, 1437, 'Content', 0),
(2874, 1, 1437, 'Content', 0),
(2875, 0, 1438, 'Client survey', 0),
(2876, 1, 1438, 'Client survey', 0),
(2877, 0, 1439, 'Incident feedback per client', 0),
(2878, 1, 1439, 'Incident feedback per client', 0),
(2879, 0, 1440, 'Call', 0),
(2880, 1, 1440, 'Call', 0),
(2881, 0, 1441, 'Seconds', 0),
(2882, 1, 1441, 'Seconds', 0),
(2883, 0, 1442, 'Price unit', 0),
(2884, 1, 1442, 'Price unit', 0),
(2885, 0, 1443, 'Recording', 0),
(2886, 1, 1443, 'Recording', 0),
(2887, 0, 1444, 'Incoming', 0),
(2888, 1, 1444, 'Incoming', 0),
(2889, 0, 1445, 'Outgoing', 0),
(2890, 1, 1445, 'Outgoing', 0),
(2891, 0, 1446, 'Call details', 0),
(2892, 1, 1446, 'Call details', 0),
(2893, 0, 1447, 'Twilio message', 0),
(2894, 1, 1447, 'Twilio message', 0),
(2895, 0, 1448, 'Send date', 0),
(2896, 1, 1448, 'Send date', 0),
(2897, 0, 1449, 'Message details', 0),
(2898, 1, 1449, 'Message details', 0),
(2899, 0, 1450, 'Update date', 0),
(2900, 1, 1450, 'Update date', 0),
(2901, 0, 1451, 'Send message', 0),
(2902, 1, 1451, 'Send message', 0),
(2903, 0, 1452, 'Hangup', 0),
(2904, 1, 1452, 'Hangup', 0),
(2905, 0, 1453, 'Call list', 0),
(2906, 1, 1453, 'Call list', 0),
(2907, 0, 1454, 'Additional fields', 0),
(2908, 1, 1454, 'Additional fields', 0),
(2909, 0, 1455, 'Edit', 0),
(2910, 1, 1455, 'Edit', 0),
(2911, 0, 1456, 'Balance', 0),
(2912, 1, 1456, 'Balance', 0),
(2913, 0, 1457, 'Resolution time', 0),
(2914, 1, 1457, 'Resolution time', 0),
(2915, 0, 1458, 'Response time', 0),
(2916, 1, 1458, 'Response time', 0),
(2917, 0, 1459, 'Offline payment', 0),
(2918, 1, 1459, 'Offline payment', 0),
(2919, 0, 1460, 'Payment gateway', 0),
(2920, 1, 1460, 'Payment gateway', 0),
(2921, 0, 1461, 'Payment method', 0),
(2922, 1, 1461, 'Payment method', 0),
(2923, 0, 1462, 'Leaderboard', 0),
(2924, 1, 1462, 'Leaderboard', 0),
(2925, 0, 1463, 'Credit', 0),
(2926, 1, 1463, 'Credit', 0),
(2927, 1, 1464, 'How can we help you?', 0),
(2928, 0, 1464, 'How can we help?', 0),
(2929, 0, 1465, 'Incident builder report', 0),
(2930, 1, 1465, 'Incident builder report', 0),
(2931, 0, 1466, 'Definition', 0),
(2932, 1, 1466, 'Definition', 0),
(2933, 0, 1467, 'Add impact', 0),
(2934, 1, 1467, 'Add impact', 0),
(2935, 0, 1468, 'Delete CI type', 0),
(2936, 1, 1468, 'Delete CI type', 0),
(2937, 0, 1469, 'Update impact', 0),
(2938, 1, 1469, 'Update impact', 0),
(2939, 0, 1470, 'Service acceptance testing', 0),
(2940, 1, 1470, 'Service acceptance testing', 0),
(2941, 0, 1471, 'Delete impact', 0),
(2942, 1, 1471, 'Delete impact', 0),
(2943, 0, 1472, 'Add risk', 0),
(2944, 1, 1472, 'Add risk', 0),
(2945, 0, 1473, 'Risk', 0),
(2946, 1, 1473, 'Risk', 0),
(2947, 0, 1474, 'Update risk', 0),
(2948, 1, 1474, 'Update risk', 0),
(2949, 0, 1475, 'Rejected by approvers', 0),
(2950, 1, 1475, 'Rejected by approvers', 0),
(2951, 0, 1476, 'Delete risk', 0),
(2952, 1, 1476, 'Delete risk', 0),
(2953, 0, 1477, 'Delete change type', 0),
(2954, 1, 1477, 'Delete change type', 0),
(2955, 0, 1478, 'Add change type', 0),
(2956, 1, 1478, 'Add change type', 0),
(2957, 0, 1479, 'Update change type', 0),
(2958, 1, 1479, 'Update change type', 0),
(2959, 0, 1480, 'Release type', 0),
(2960, 1, 1480, 'Release type', 0),
(2961, 0, 1481, 'Delete release type', 0),
(2962, 1, 1481, 'Delete release type', 0),
(2963, 0, 1482, 'Update release type', 0),
(2964, 1, 1482, 'Update release type', 0),
(2965, 0, 1483, 'Add release type', 0),
(2966, 1, 1483, 'Add release type', 0),
(2967, 0, 1484, 'Contract type', 0),
(2968, 1, 1484, 'Contract type', 0),
(2969, 0, 1485, 'Asset state', 0),
(2970, 1, 1485, 'Asset state', 0),
(2971, 0, 1486, 'Add asset state', 0),
(2972, 1, 1486, 'Add asset state', 0),
(2973, 0, 1487, 'Update asset state', 0),
(2974, 1, 1487, 'Update asset state', 0),
(2975, 0, 1488, 'Delete asset state', 0),
(2976, 1, 1488, 'Delete asset state', 0),
(2977, 0, 1489, 'Request stage', 0),
(2978, 1, 1489, 'Request stage', 0),
(2979, 0, 1490, 'Add contract type', 0),
(2980, 1, 1490, 'Add contract type', 0),
(2981, 0, 1491, 'Update contract type', 0),
(2982, 1, 1491, 'Update contract type', 0),
(2983, 0, 1492, 'Vendor', 0),
(2984, 1, 1492, 'Vendor', 0),
(2985, 0, 1493, 'Add vendor', 0),
(2986, 1, 1493, 'Add vendor', 0),
(2987, 0, 1494, 'Update vendor', 0),
(2988, 1, 1494, 'Update vendor', 0),
(2989, 0, 1495, 'Delete vendor', 0),
(2990, 1, 1495, 'Delete vendor', 0),
(2991, 0, 1496, 'Partially completed, partial rollback', 0),
(2992, 1, 1496, 'Partially completed, partial rollback', 0),
(2993, 0, 1497, 'Rolled Back after Failures', 0),
(2994, 1, 1497, 'Rolled Back after Failures', 0),
(2995, 0, 1498, 'Completed with Failures', 0),
(2996, 1, 1498, 'Completed with Failures', 0),
(2997, 0, 1499, 'Completed Successfully', 0),
(2998, 1, 1499, 'Completed Successfully', 0),
(2999, 0, 1500, 'Asset', 0),
(3000, 1, 1500, 'Asset', 0),
(3001, 0, 1501, 'Primary contact', 0),
(3002, 1, 1501, 'Primary contact', 0),
(3003, 0, 1502, 'Delete request stage', 0),
(3004, 1, 1502, 'Delete request stage', 0),
(3005, 0, 1503, 'Add request stage', 0),
(3006, 1, 1503, 'Add request stage', 0),
(3007, 0, 1504, 'Lifecycle status', 0),
(3008, 1, 1504, 'Lifecycle status', 0),
(3009, 0, 1505, 'Update request stage', 0),
(3010, 1, 1505, 'Update request stage', 0),
(3011, 0, 1506, 'On asset expired', 0),
(3012, 1, 1506, 'On asset expired', 0),
(3013, 0, 1507, 'Finance management', 0),
(3014, 1, 1507, 'Financial management', 0),
(3015, 0, 1508, 'Finance type', 0),
(3016, 1, 1508, 'Finance type', 0),
(3017, 0, 1509, 'Delete finance type', 0),
(3018, 1, 1509, 'Delete finance type', 0),
(3019, 0, 1510, 'Add finance type', 0),
(3020, 1, 1510, 'Add finance type', 0),
(3021, 0, 1511, 'Update finance type', 0),
(3022, 1, 1511, 'Update finance type', 0),
(3023, 0, 1512, 'Add new depreciation', 0),
(3024, 1, 1512, 'Add new depreciation', 0),
(3025, 0, 1513, 'Disposition status', 0),
(3026, 1, 1513, 'Disposition status', 0),
(3027, 0, 1514, 'Select finance type', 0),
(3028, 1, 1514, 'Select finance type', 0),
(3029, 0, 1515, 'Send approvals for changes', 0),
(3030, 1, 1515, 'Send approvals for changes', 0),
(3031, 0, 1516, 'Delete finance', 0),
(3032, 1, 1516, 'Delete finance', 0),
(3033, 0, 1517, 'CI custom fields', 0),
(3034, 1, 1517, 'CI custom fields', 0),
(3035, 0, 1518, 'Close all incidents linked to changes / problem', 0),
(3036, 1, 1518, 'Close all incidents linked to changes / problem', 0),
(3037, 0, 1519, 'Update license type', 0),
(3038, 1, 1519, 'Update license type', 0),
(3039, 0, 1520, 'Add license type', 0),
(3040, 1, 1520, 'Add license type', 0),
(3041, 0, 1521, 'Delete license type', 0),
(3042, 1, 1521, 'Delete license type', 0),
(3043, 0, 1522, 'Delete CI custom field', 0),
(3044, 1, 1522, 'Delete CI custom field', 0),
(3045, 0, 1523, 'Add service custom field', 0),
(3046, 1, 1523, 'Add service custom field', 0),
(3047, 0, 1524, 'Delete product', 0),
(3048, 1, 1524, 'Delete product', 0),
(3049, 0, 1525, 'Add product status', 0),
(3050, 1, 1525, 'Add product status', 0),
(3051, 0, 1526, 'Product status', 0),
(3052, 1, 1526, 'Product status', 0),
(3053, 0, 1527, 'Update product status', 0),
(3054, 1, 1527, 'Update product status', 0),
(3055, 0, 1528, 'Update service custom field', 0),
(3056, 1, 1528, 'Update service custom field', 0),
(3057, 0, 1529, 'Add location', 0),
(3058, 1, 1529, 'Add location', 0),
(3059, 0, 1530, 'Close all problems linked to changes', 0),
(3060, 1, 1530, 'Close all problems linked to changes', 0),
(3061, 0, 1531, 'Mode of procurement', 0),
(3062, 1, 1531, 'Mode of procurement', 0),
(3063, 0, 1532, 'Add mode of procurement', 0),
(3064, 1, 1532, 'Add mode of procurement', 0),
(3065, 0, 1533, 'Update mode of procurement', 0),
(3066, 1, 1533, 'Update mode of procurement', 0),
(3067, 0, 1534, 'Delete mode of procurement', 0),
(3068, 1, 1534, 'Delete mode of procurement', 0),
(3069, 0, 1535, 'Stages', 0),
(3070, 1, 1535, 'Stages', 0),
(3071, 0, 1536, 'Add depreciation type', 0),
(3072, 1, 1536, 'Add depreciation type', 0),
(3073, 0, 1537, 'Update depreciation type', 0),
(3074, 1, 1537, 'Update depreciation type', 0),
(3075, 0, 1538, 'Delete depreciation type', 0),
(3076, 1, 1538, 'Delete depreciation type', 0),
(3077, 0, 1539, 'Is data wiping completed?', 0),
(3078, 1, 1539, 'Is data wiping completed?', 0),
(3079, 0, 1540, 'Contracts', 0),
(3080, 1, 1540, 'Contracts', 0),
(3081, 0, 1541, 'Contract number', 0),
(3082, 1, 1541, 'Contract number', 0),
(3083, 0, 1542, 'Phone number must be numeric', 0),
(3084, 1, 1542, 'Phone number must be numeric', 0),
(3085, 0, 1543, 'Delete location', 0),
(3086, 1, 1543, 'Delete location', 0),
(3087, 0, 1544, 'Add contract', 0),
(3088, 1, 1544, 'Add contract', 0),
(3089, 0, 1545, 'License count', 0),
(3090, 1, 1545, 'License count', 0),
(3091, 0, 1546, 'Sorry, can not delete Asset/CMDB until data wiping is completed.', 0),
(3092, 1, 1546, 'Sorry, can not delete Asset/CMDB until data wiping is completed.', 0),
(3093, 0, 1547, 'Notify contract expiry', 0),
(3094, 1, 1547, 'Notify contract expiry', 0),
(3095, 0, 1548, 'Notify before', 0),
(3096, 1, 1548, 'Notify before', 0),
(3097, 0, 1549, 'Notify to', 0),
(3098, 1, 1549, 'Notify to', 0),
(3099, 0, 1550, 'Choose file', 0),
(3100, 1, 1550, 'Choose file', 0),
(3101, 0, 1551, 'Two factor authentication', 0),
(3102, 1, 1551, 'Two factor authentication', 0),
(3103, 0, 1552, 'You have successfully verified your email', 0),
(3104, 1, 1552, 'You have successfully verified your email', 0),
(3105, 0, 1553, 'You have already verified your email', 0),
(3106, 1, 1553, 'You have already verified your email', 0),
(3107, 0, 1554, 'Client email verification pending', 0),
(3108, 1, 1554, 'Client email verification pending', 0),
(3109, 0, 1555, 'Update CI', 0),
(3110, 1, 1555, 'Update CI', 0),
(3111, 0, 1556, 'General ledger', 0),
(3112, 1, 1556, 'General ledger', 0),
(3113, 0, 1557, 'Additional attributes', 0),
(3114, 1, 1557, 'Additional attributes', 0),
(3115, 0, 1558, 'Select group type', 0),
(3116, 1, 1558, 'Select group type', 0),
(3117, 0, 1559, 'Check-in', 0),
(3118, 1, 1559, 'Check-in', 0),
(3119, 0, 1560, 'Notify before required', 0),
(3120, 1, 1560, 'Notify before required', 0),
(3121, 0, 1561, 'Check-out', 0),
(3122, 1, 1561, 'Check-out', 0),
(3123, 0, 1562, 'Select contract type', 0),
(3124, 1, 1562, 'Select contract type', 0),
(3125, 0, 1563, 'Contract number already used', 0),
(3126, 1, 1563, 'Contract number already used', 0),
(3127, 0, 1564, 'Delete contract', 0),
(3128, 1, 1564, 'Delete contract', 0),
(3129, 0, 1565, 'Auto approve comments or topics', 0),
(3130, 1, 1565, 'Auto approve comments or topics', 0),
(3131, 0, 1566, 'Scan now', 0),
(3132, 1, 1566, 'Scan now', 0),
(3133, 0, 1567, 'Attach CI', 0),
(3134, 1, 1567, 'Attach CI', 0),
(3135, 0, 1568, 'Scanning', 0),
(3136, 1, 1568, 'Scanning', 0),
(3137, 0, 1569, 'Please select to date', 0),
(3138, 1, 1569, 'Please select to date', 0),
(3139, 0, 1570, 'Service catalog', 0),
(3140, 1, 1570, 'Service catalog', 0),
(3141, 0, 1571, 'Edit CI product', 0),
(3142, 1, 1571, 'Edit CI product', 0),
(3143, 0, 1572, 'CI vendor', 0),
(3144, 1, 1572, 'CI vendor', 0),
(3145, 0, 1573, 'Warranty / Validity', 0),
(3146, 1, 1573, 'Warranty / Validity', 0),
(3147, 0, 1574, 'Select vendor', 0),
(3148, 1, 1574, 'Select vendor', 0),
(3149, 0, 1575, 'Select product', 0),
(3150, 1, 1575, 'Select product', 0),
(3151, 0, 1576, 'Attach', 0),
(3152, 1, 1576, 'Attach', 0),
(3153, 0, 1577, 'Item name', 0),
(3154, 1, 1577, 'Item name', 0),
(3155, 0, 1578, 'Price must be numeric', 0),
(3156, 1, 1578, 'Price must be numeric', 0),
(3157, 0, 1579, 'Quantity must be numeric', 0),
(3158, 1, 1579, 'Quantity must be numeric', 0),
(3159, 0, 1580, 'Add service category', 0),
(3160, 1, 1580, 'Add service category', 0),
(3161, 0, 1581, 'Problems', 0),
(3162, 1, 1581, 'Problems', 0),
(3163, 0, 1582, 'Update service category', 0),
(3164, 1, 1582, 'Update service category', 0),
(3165, 0, 1583, 'Purchase & Invoice Details', 0),
(3166, 1, 1583, 'Purchase & Invoice Details', 0),
(3167, 0, 1584, 'Search a requester', 0),
(3168, 1, 1584, 'Search a requester', 0),
(3169, 0, 1585, 'Due by', 0),
(3170, 1, 1585, 'Due by', 0),
(3171, 0, 1586, 'Agent', 0),
(3172, 1, 1586, 'Agent', 0),
(3173, 0, 1587, 'Add service item', 0),
(3174, 1, 1587, 'Add service item', 0),
(3175, 0, 1588, 'Quantity visible', 0),
(3176, 1, 1588, 'Quantity visible', 0),
(3177, 0, 1589, 'Published', 0),
(3178, 1, 1589, 'Published', 0),
(3179, 0, 1590, 'Visible to client portal', 0),
(3180, 1, 1590, 'Visible to client portal', 0),
(3181, 0, 1591, 'Problem', 0),
(3182, 1, 1591, 'Problem', 0),
(3183, 0, 1592, 'Open new problem', 0),
(3184, 1, 1592, 'Open new problem', 0),
(3185, 0, 1593, 'Update service item', 0),
(3186, 1, 1593, 'Update service item', 0),
(3187, 0, 1594, 'Cost must be numeric', 0),
(3188, 1, 1594, 'Cost must be numeric', 0),
(3189, 0, 1595, 'Delete service item', 0),
(3190, 1, 1595, 'Delete service item', 0),
(3191, 0, 1596, 'Delete payment gateway', 0),
(3192, 1, 1596, 'Delete payment gateway', 0),
(3193, 0, 1597, 'Delete service category', 0),
(3194, 1, 1597, 'Delete service category', 0),
(3195, 0, 1598, 'Field name', 0),
(3196, 1, 1598, 'Field name', 0),
(3197, 0, 1599, 'PO #', 0),
(3198, 1, 1599, 'PO #', 0),
(3199, 0, 1600, 'PO name', 0),
(3200, 1, 1600, 'PO name', 0),
(3201, 0, 1601, 'Assignment', 0),
(3202, 1, 1601, 'Assignment', 0),
(3203, 0, 1602, 'Delete service custom field', 0),
(3204, 1, 1602, 'Delete service custom field', 0),
(3205, 0, 1603, 'Service custom field', 0),
(3206, 1, 1603, 'Service custom field', 0),
(3207, 0, 1604, 'Item image', 0),
(3208, 1, 1604, 'Item image', 0),
(3209, 0, 1605, 'Changes', 0),
(3210, 1, 1605, 'Changes', 0),
(3211, 0, 1606, 'Service catalog', 0),
(3212, 1, 1606, 'Service catalog', 0),
(3213, 0, 1607, 'Request', 0),
(3214, 1, 1607, 'Request', 0),
(3215, 1, 1608, 'Submit for approval', 0),
(3216, 0, 1608, 'Submit for approval', 0),
(3217, 0, 1609, 'Invalid linkedin profile ID.', 0),
(3218, 1, 1609, 'Invalid linkedin profile ID.', 0),
(3219, 0, 1610, 'Invalid facebook profile ID.', 0),
(3220, 1, 1610, 'Invalid facebook profile ID.', 0),
(3221, 0, 1611, 'Invalid twitter profile ID', 0),
(3222, 1, 1611, 'Invalid twitter profile ID', 0),
(3223, 0, 1612, 'Invalid google profile ID', 0),
(3224, 1, 1612, 'Invalid google profile ID', 0),
(3225, 0, 1613, 'Item request', 0),
(3226, 1, 1613, 'Item request', 0),
(3227, 0, 1614, 'Place request', 0),
(3228, 1, 1614, 'Place request', 0),
(3229, 0, 1615, 'Reject', 0),
(3230, 1, 1615, 'Reject', 0),
(3231, 0, 1616, 'Request for', 0),
(3232, 1, 1616, 'Request for', 0),
(3233, 0, 1617, 'Terminate', 0),
(3234, 1, 1617, 'Terminate', 0),
(3235, 0, 1618, 'Cancelled', 0),
(3236, 1, 1618, 'Cancelled', 0),
(3237, 0, 1619, 'Service request', 0),
(3238, 1, 1619, 'Service request', 0),
(3239, 0, 1620, 'Send email to client', 0),
(3240, 1, 1620, 'Send email to client', 0),
(3241, 0, 1621, 'Assign team', 0),
(3242, 1, 1621, 'Assign team', 0),
(3243, 0, 1622, 'Creation time', 0),
(3244, 1, 1622, 'Creation time', 0),
(3245, 0, 1623, 'After', 0),
(3246, 1, 1623, 'After', 0),
(3247, 0, 1624, 'Before', 0),
(3248, 1, 1624, 'Before', 0),
(3249, 0, 1625, 'Send email to staff', 0),
(3250, 1, 1625, 'Send email to staff', 0),
(3251, 0, 1626, 'Resolution due time', 0),
(3252, 1, 1626, 'Resolution due time', 0),
(3253, 0, 1627, 'Core type status can not be changed.', 0),
(3254, 1, 1627, 'Core type status can not be changed.', 0),
(3255, 0, 1628, 'Email approval pending', 0),
(3256, 1, 1628, 'Email approval pending', 0),
(3257, 1, 1629, 'Upload file size upto', 0),
(3258, 0, 1629, 'Upload file size upto', 0),
(3259, 1, 1630, 'Attached extension is incorrect', 0),
(3260, 0, 1630, 'Attached extension is incorrect', 0),
(3261, 0, 1631, 'Submit new, view and reply self posted incidents', 0),
(3262, 1, 1631, 'Submit new, view and reply self posted incidents', 0),
(3263, 0, 1632, 'Problem not found may be deleted or not have access', 0),
(3264, 1, 1632, 'Problem not found may be deleted or not have access', 0),
(3265, 0, 1633, 'Purchase date', 0),
(3266, 1, 1633, 'Purchase date', 0),
(3267, 0, 1634, 'Root cause', 0),
(3268, 1, 1634, 'Root cause', 0),
(3269, 0, 1635, 'Symptoms', 0),
(3270, 1, 1635, 'Symptoms', 0),
(3271, 0, 1636, 'Permanent solution', 0),
(3272, 1, 1636, 'Permanent solution', 0),
(3273, 0, 1637, 'Workaround solution', 0),
(3274, 1, 1637, 'Workaround solution', 0),
(3275, 0, 1638, 'Problem analysis', 0),
(3276, 1, 1638, 'Problem analysis', 0),
(3277, 0, 1639, 'Add root cause', 0),
(3278, 1, 1639, 'Add root cause', 0),
(3279, 0, 1640, 'Problem details', 0),
(3280, 1, 1640, 'Problem details', 0),
(3281, 0, 1641, 'Problem note', 0),
(3282, 1, 1641, 'Problem note', 0),
(3283, 0, 1642, 'No root cause available', 0),
(3284, 1, 1642, 'No root cause available', 0),
(3285, 0, 1643, 'Add new', 0),
(3286, 1, 1643, 'Add new', 0),
(3287, 0, 1644, 'No impact available', 0),
(3288, 1, 1644, 'No impact available', 0),
(3289, 1, 1645, 'No symptoms available', 0),
(3290, 0, 1645, 'No symptons available', 0),
(3291, 0, 1646, 'Add a new solution', 0),
(3292, 1, 1646, 'Add a new solution', 0),
(3293, 0, 1647, 'Link solution to problem', 0),
(3294, 1, 1647, 'Link solution to problem', 0),
(3295, 0, 1648, 'Releases', 0),
(3296, 1, 1648, 'Releases', 0),
(3297, 0, 1649, 'Select multiple problems to link', 0),
(3298, 1, 1649, 'Select multiple problems to link', 0),
(3299, 0, 1650, 'Search problems', 0),
(3300, 1, 1650, 'Search problems', 0),
(3301, 0, 1651, 'Search release', 0),
(3302, 1, 1651, 'Search release', 0),
(3303, 0, 1652, 'Service item', 0),
(3304, 1, 1652, 'Service item', 0),
(3305, 0, 1653, 'Invoice number', 0),
(3306, 1, 1653, 'Invoice number', 0),
(3307, 0, 1654, 'No CI attached', 0),
(3308, 1, 1654, 'No CI attached', 0),
(3309, 0, 1655, 'No problem linked', 0),
(3310, 1, 1655, 'No problem linked', 0),
(3311, 0, 1656, 'Link problem', 0),
(3312, 1, 1656, 'Link problem', 0),
(3313, 0, 1657, 'Link change', 0),
(3314, 1, 1657, 'Link change', 0),
(3315, 0, 1658, 'Please search problem', 0),
(3316, 1, 1658, 'Please search problem', 0),
(3317, 0, 1659, 'Please search changes', 0),
(3318, 1, 1659, 'Please search changes', 0),
(3319, 0, 1660, 'Select CI type', 0),
(3320, 1, 1660, 'Select CI type', 0),
(3321, 0, 1661, 'Please select CI type or search CI item', 0),
(3322, 1, 1661, 'Please select CI type or search CI item', 0),
(3323, 0, 1662, 'Recipient and people', 0),
(3324, 1, 1662, 'Recipient and people', 0),
(3325, 0, 1663, 'Incident or time base', 0),
(3326, 1, 1663, 'Incident or time base', 0),
(3327, 0, 1664, 'Show only internal incidents', 0),
(3328, 1, 1664, 'Show only internal incidents', 0),
(3329, 0, 1665, 'Relationships', 0),
(3330, 1, 1665, 'Relationships', 0),
(3331, 0, 1666, 'Assets detail', 0),
(3332, 1, 1666, 'Assets detail', 0),
(3333, 0, 1667, 'Incidence', 0),
(3334, 1, 1667, 'Incidence', 0),
(3335, 0, 1668, 'Add CI vendor', 0),
(3336, 1, 1668, 'Add CI vendor', 0),
(3337, 0, 1669, 'Add CI product', 0),
(3338, 1, 1669, 'Add CI product', 0),
(3339, 0, 1670, 'Inverse relationship', 0),
(3340, 1, 1670, 'Inverse relationship', 0),
(3341, 0, 1671, 'Attach relationship', 0),
(3342, 1, 1671, 'Attach relationship', 0),
(3343, 0, 1672, 'Open new release', 0),
(3344, 1, 1672, 'Open new release', 0),
(3345, 0, 1673, 'Release', 0),
(3346, 1, 1673, 'Release', 0),
(3347, 0, 1674, 'Planned start date', 0),
(3348, 1, 1674, 'Planned start date', 0),
(3349, 0, 1675, 'Planned end date', 0),
(3350, 1, 1675, 'Planned end date', 0),
(3351, 0, 1676, 'Match and conditions', 0),
(3352, 1, 1676, 'Match and conditions', 0),
(3353, 0, 1677, 'Match or conditions', 0),
(3354, 1, 1677, 'Match or conditions', 0),
(3355, 0, 1678, 'Paid department not found', 0),
(3356, 1, 1678, 'Paid department not found', 0),
(3357, 0, 1679, 'Problem solution', 0),
(3358, 1, 1679, 'Problem solution', 0),
(3359, 0, 1680, 'Permanent', 0),
(3360, 1, 1680, 'Permanent', 0),
(3361, 0, 1681, 'Workaround', 0),
(3362, 1, 1681, 'Workaround', 0),
(3363, 0, 1682, 'Search problem solution', 0),
(3364, 1, 1682, 'Search problem solution', 0),
(3365, 0, 1683, 'Detach CI', 0),
(3366, 1, 1683, 'Detach CI', 0),
(3367, 0, 1684, 'Search incident', 0),
(3368, 1, 1684, 'Search incident', 0),
(3369, 0, 1685, 'Please search incident', 0),
(3370, 1, 1685, 'Please search incident', 0),
(3371, 0, 1686, 'No changes attached', 0),
(3372, 1, 1686, 'No changes attached', 0),
(3373, 0, 1687, 'No task attached', 0),
(3374, 1, 1687, 'No task attached', 0),
(3375, 0, 1688, 'Link task', 0),
(3376, 1, 1688, 'Link task', 0),
(3377, 0, 1689, 'Add new task', 0),
(3378, 1, 1689, 'Add new task', 0),
(3379, 0, 1690, 'Request for change', 0),
(3380, 1, 1690, 'Request for change', 0),
(3381, 0, 1691, 'Problem hash', 0),
(3382, 1, 1691, 'Problem hash', 0),
(3383, 0, 1692, 'Release hash', 0),
(3384, 1, 1692, 'Release hash', 0),
(3385, 0, 1693, 'Delete changes', 0),
(3386, 1, 1693, 'Delete changes', 0),
(3387, 0, 1694, 'Delete problem', 0),
(3388, 1, 1694, 'Delete problem', 0),
(3389, 0, 1695, 'Host', 0),
(3390, 1, 1695, 'Host', 0),
(3391, 0, 1696, 'Apply amount credit', 0),
(3392, 1, 1696, 'Apply amount credit', 0),
(3393, 0, 1697, 'Recent activity', 0),
(3394, 1, 1697, 'Recent activity', 0),
(3395, 0, 1698, 'Manage credit', 0),
(3396, 1, 1698, 'Manage credit', 0),
(3397, 0, 1699, 'Requirements', 0),
(3398, 1, 1699, 'Requirements', 0),
(3399, 0, 1700, 'Release details', 0),
(3400, 1, 1700, 'Release details', 0),
(3401, 0, 1701, 'Build plan', 0),
(3402, 1, 1701, 'Build plan', 0),
(3403, 0, 1702, 'Test plan', 0),
(3404, 1, 1702, 'Test plan', 0),
(3405, 0, 1703, 'No build plan available', 0),
(3406, 1, 1703, 'No build plan available', 0),
(3407, 0, 1704, 'No test plan available', 0),
(3408, 1, 1704, 'No test plan available', 0),
(3409, 0, 1705, 'Release approval', 0),
(3410, 1, 1705, 'Release approval', 0),
(3411, 0, 1706, 'Change filters', 0),
(3412, 1, 1706, 'Change filters', 0),
(3413, 0, 1707, 'Release filters', 0),
(3414, 1, 1707, 'Release filters', 0),
(3415, 0, 1708, 'Problem filters', 0),
(3416, 1, 1708, 'Problem filters', 0),
(3417, 0, 1709, 'Clients can not be merged across different companies', 0),
(3418, 1, 1709, 'Clients can not be merged across different companies', 0),
(3419, 0, 1710, 'Delete organization', 0),
(3420, 1, 1710, 'Delete organization', 0),
(3421, 0, 1711, 'To add survey fields you require minimum one survey field group', 0),
(3422, 1, 1711, 'To add survey fields you require minimum one survey field group', 0),
(3423, 0, 1712, 'Progress', 0),
(3424, 1, 1712, 'Progress', 0),
(3425, 0, 1713, 'Email has been sent to reset password', 0),
(3426, 1, 1713, 'Email has been sent to reset password', 0),
(3427, 0, 1714, 'Reset password link expired', 0),
(3428, 1, 1714, 'Reset password link expired', 0),
(3429, 0, 1715, 'Back to login', 0),
(3430, 1, 1715, 'Back to login', 0),
(3431, 0, 1716, 'Core priority status can not be changed', 0),
(3432, 1, 1716, 'Core priority status can not be changed', 0),
(3433, 0, 1717, 'Core status can not be changed', 0),
(3434, 1, 1717, 'Core status can not be changed', 0),
(3435, 0, 1718, 'Core flag status can not be changed', 0),
(3436, 1, 1718, 'Core flag status can not be changed', 0),
(3437, 0, 1719, 'Core view status can not be changed', 0),
(3438, 1, 1719, 'Core view status can not be changed', 0),
(3439, 0, 1720, 'Total cost', 0),
(3440, 1, 1720, 'Total cost', 0),
(3441, 0, 1721, 'Change not found may be deleted or not have access', 0),
(3442, 1, 1721, 'Change not found may be deleted or not have access', 0),
(3443, 0, 1722, 'Add problem', 0),
(3444, 1, 1722, 'Add problem', 0),
(3445, 0, 1723, 'Problem can not move from one domain to other domain', 0),
(3446, 1, 1723, 'Problem can not move from one domain to other domain', 0),
(3447, 0, 1724, 'Change can not move from one domain to other domain', 0),
(3448, 1, 1724, 'Change can not move from one domain to other domain', 0),
(3449, 0, 1725, 'New problem created', 0),
(3450, 1, 1725, 'New problem created', 0),
(3451, 0, 1726, 'New change created', 0),
(3452, 1, 1726, 'New change created', 0),
(3453, 0, 1727, 'Detach', 0),
(3454, 1, 1727, 'Detach', 0),
(3455, 0, 1728, 'Change details', 0),
(3456, 1, 1728, 'Change details', 0),
(3457, 0, 1729, 'Link release', 0),
(3458, 1, 1729, 'Link release', 0),
(3459, 0, 1730, 'Please search releases', 0),
(3460, 1, 1730, 'Please search releases', 0),
(3461, 0, 1731, 'Reason for change', 0),
(3462, 1, 1731, 'Reason for change', 0),
(3463, 0, 1732, 'No reason available', 0),
(3464, 1, 1732, 'No reason available', 0),
(3465, 0, 1733, 'Rollout plan', 0),
(3466, 1, 1733, 'Rollout plan', 0),
(3467, 0, 1734, 'Backout plan', 0),
(3468, 1, 1734, 'Backout plan', 0),
(3469, 0, 1735, 'Send', 0),
(3470, 1, 1735, 'Send', 0),
(3471, 0, 1736, 'Select payment gateway', 0),
(3472, 1, 1736, 'Select payment gateway', 0),
(3473, 0, 1737, 'Gateway transactions details', 0),
(3474, 1, 1737, 'Gateway transactions details', 0),
(3475, 0, 1738, 'Parser details', 0),
(3476, 1, 1738, 'Parser details', 0),
(3477, 0, 1739, 'Mail details', 0),
(3478, 1, 1739, 'Mail details', 0),
(3479, 0, 1740, 'Select date', 0),
(3480, 1, 1740, 'Select date', 0),
(3481, 0, 1741, 'Select month', 0),
(3482, 1, 1741, 'Select month', 0),
(3483, 0, 1742, 'January', 0),
(3484, 1, 1742, 'January', 0),
(3485, 0, 1743, 'February', 0),
(3486, 1, 1743, 'February', 0),
(3487, 0, 1744, 'March', 0),
(3488, 1, 1744, 'March', 0),
(3489, 0, 1745, 'April', 0),
(3490, 1, 1745, 'April', 0),
(3491, 0, 1746, 'May', 0),
(3492, 1, 1746, 'May', 0),
(3493, 0, 1747, 'June', 0),
(3494, 1, 1747, 'June', 0),
(3495, 0, 1748, 'July', 0),
(3496, 1, 1748, 'July', 0),
(3497, 0, 1749, 'August', 0),
(3498, 1, 1749, 'August', 0),
(3499, 0, 1750, 'September', 0),
(3500, 1, 1750, 'September', 0),
(3501, 0, 1751, 'October', 0),
(3502, 1, 1751, 'October', 0),
(3503, 0, 1752, 'November', 0),
(3504, 1, 1752, 'November', 0),
(3505, 0, 1753, 'December', 0),
(3506, 1, 1753, 'December', 0),
(3507, 0, 1754, 'Update password', 0),
(3508, 1, 1754, 'Update password', 0),
(3509, 0, 1755, 'Send reset password email', 0),
(3510, 1, 1755, 'Send reset password email', 0),
(3511, 0, 1756, 'Delete relationship', 0),
(3512, 1, 1756, 'Delete relationship', 0),
(3513, 0, 1757, 'PO-Invoice description', 0),
(3514, 1, 1757, 'PO-Invoice description', 0),
(3515, 0, 1758, 'Detach link problem', 0),
(3516, 1, 1758, 'Detach link problem', 0),
(3517, 0, 1759, 'Detach link change', 0),
(3518, 1, 1759, 'Detach link change', 0),
(3519, 0, 1760, 'Software properties', 0),
(3520, 1, 1760, 'Software properties', 0),
(3521, 0, 1761, 'Warranty', 0),
(3522, 1, 1761, 'Warranty', 0),
(3523, 0, 1762, 'Hardware properties', 0),
(3524, 1, 1762, 'Hardware properties', 0),
(3525, 0, 1763, 'Acquisition date', 0),
(3526, 1, 1763, 'Acquisition date', 0),
(3527, 0, 1764, 'Warranty expiry date', 0),
(3528, 1, 1764, 'Warranty expiry date', 0),
(3529, 0, 1765, 'Serial number', 0),
(3530, 1, 1765, 'Serial number', 0),
(3531, 0, 1766, 'License validity', 0),
(3532, 1, 1766, 'License validity', 0),
(3533, 0, 1767, 'Auto Renew', 0),
(3534, 1, 1767, 'Auto Renew', 0),
(3535, 0, 1768, 'Software license type', 0),
(3536, 1, 1768, 'Software license type', 0),
(3537, 0, 1769, 'License type', 0),
(3538, 1, 1769, 'License type', 0),
(3539, 0, 1770, 'Straight line', 0),
(3540, 1, 1770, 'Straight line', 0),
(3541, 0, 1771, 'Declining balance', 0),
(3542, 1, 1771, 'Declining balance', 0),
(3543, 0, 1772, 'Sum of years digit', 0),
(3544, 1, 1772, 'Sum of years digit', 0),
(3545, 0, 1773, 'Double declining balance', 0),
(3546, 1, 1773, 'Double declining balance', 0),
(3547, 0, 1774, 'Depreciation details', 0),
(3548, 1, 1774, 'Depreciation details', 0),
(3549, 0, 1775, 'Useful year must be numeric', 0),
(3550, 1, 1775, 'Useful year must be numeric', 0),
(3551, 0, 1776, 'Book value', 0),
(3552, 1, 1776, 'Book value', 0),
(3553, 0, 1777, 'Depreciation schedule', 0),
(3554, 1, 1777, 'Depreciation schedule', 0),
(3555, 0, 1778, 'Depreciation', 0),
(3556, 1, 1778, 'Depreciation', 0),
(3557, 0, 1779, 'Select depreciation method', 0),
(3558, 1, 1779, 'Select depreciation method', 0),
(3559, 0, 1780, 'Deleted', 0),
(3560, 1, 1780, 'Deleted', 0),
(3561, 0, 1781, 'Update staff department', 0),
(3562, 1, 1781, 'Update staff department', 0),
(3563, 0, 1782, 'Add remark', 0),
(3564, 1, 1782, 'Add remark', 0),
(3565, 0, 1783, 'ITIL event', 0),
(3566, 1, 1783, 'ITIL event', 0),
(3567, 0, 1784, 'New problem', 0),
(3568, 1, 1784, 'New problem', 0),
(3569, 0, 1785, 'Update problem department', 0),
(3570, 1, 1785, 'Update problem department', 0),
(3571, 0, 1786, 'Update problem status', 0),
(3572, 1, 1786, 'Update problem status', 0),
(3573, 0, 1787, 'Update problem priority', 0),
(3574, 1, 1787, 'Update problem priority', 0),
(3575, 0, 1788, 'Update problem impact', 0),
(3576, 1, 1788, 'Update problem impact', 0),
(3577, 0, 1789, 'Problem assign', 0),
(3578, 1, 1789, 'Problem assign', 0),
(3579, 0, 1790, 'Add problem impact', 0),
(3580, 1, 1790, 'Add problem impact', 0),
(3581, 0, 1791, 'Add problem symptoms', 0),
(3582, 1, 1791, 'Add problem symptoms', 0),
(3583, 0, 1792, 'Link permanent solution', 0),
(3584, 1, 1792, 'Link permanent solution', 0),
(3585, 0, 1793, 'Link workaround solution', 0),
(3586, 1, 1793, 'Link workaround solution', 0),
(3587, 0, 1794, 'New change', 0),
(3588, 1, 1794, 'New change', 0),
(3589, 0, 1795, 'Open new service request', 0),
(3590, 1, 1795, 'Open new service request', 0),
(3591, 0, 1796, 'Update change status', 0),
(3592, 1, 1796, 'Update change status', 0),
(3593, 0, 1797, 'Update change priority', 0),
(3594, 1, 1797, 'Update change priority', 0),
(3595, 0, 1798, 'Update change impact', 0),
(3596, 1, 1798, 'Update change impact', 0),
(3597, 0, 1799, 'Update change risk', 0),
(3598, 1, 1799, 'Update change risk', 0),
(3599, 0, 1800, 'Change assign', 0),
(3600, 1, 1800, 'Change assign', 0),
(3601, 0, 1801, 'Add change impact', 0),
(3602, 1, 1801, 'Add change impact', 0),
(3603, 0, 1802, 'Add rollout plan', 0),
(3604, 1, 1802, 'Add rollout plan', 0),
(3605, 0, 1803, 'Add backout plan', 0),
(3606, 1, 1803, 'Add backout plan', 0),
(3607, 0, 1804, 'Identification', 0),
(3608, 1, 1804, 'Identification', 0),
(3609, 0, 1805, 'Update release status', 0),
(3610, 1, 1805, 'Update release status', 0),
(3611, 0, 1806, 'Update release priority', 0),
(3612, 1, 1806, 'Update release priority', 0),
(3613, 0, 1807, 'Release assign', 0),
(3614, 1, 1807, 'Release assign', 0),
(3615, 0, 1808, 'Add build plan', 0),
(3616, 1, 1808, 'Add build plan', 0),
(3617, 0, 1809, 'Add test plan', 0),
(3618, 1, 1809, 'Add test plan', 0),
(3619, 0, 1810, 'Change approval', 0),
(3620, 1, 1810, 'Change approval', 0),
(3621, 0, 1811, 'Contract approval', 0),
(3622, 1, 1811, 'Contract approval', 0),
(3623, 1, 1812, 'Call client', 0),
(3624, 0, 1812, 'Call client', 0),
(3625, 1, 1813, 'Email client', 0),
(3626, 0, 1813, 'Email client', 0),
(3627, 1, 1814, 'Client type', 0),
(3628, 0, 1814, 'Client type', 0),
(3629, 0, 1815, 'Remaining life', 0),
(3630, 1, 1815, 'Remaining life', 0),
(3631, 0, 1816, 'Accumulated depreciation', 0),
(3632, 1, 1816, 'Accumulated depreciation', 0),
(3633, 0, 1817, 'Depreciation expense', 0),
(3634, 1, 1817, 'Depreciation expense', 0),
(3635, 0, 1818, 'URL must be valid', 0),
(3636, 1, 1818, 'URL must be valid', 0),
(3637, 0, 1819, 'Restore', 0),
(3638, 1, 1819, 'Restore', 0),
(3639, 0, 1820, 'No access', 0),
(3640, 1, 1820, 'No access', 0),
(3641, 0, 1821, 'Map Field', 0),
(3642, 1, 1821, 'Map Field', 0),
(3643, 0, 1822, 'Select image', 0),
(3644, 1, 1822, 'Select image', 0),
(3645, 0, 1823, 'Invalid end date', 0),
(3646, 1, 1823, 'Invalid end date', 0),
(3647, 0, 1824, 'Delete contract type', 0),
(3648, 1, 1824, 'Delete contract type', 0),
(3649, 0, 1825, 'Modify recipient and people', 0),
(3650, 1, 1825, 'Modify recipient and people', 0),
(3651, 0, 1826, 'Time tracking', 0),
(3652, 1, 1826, 'Time tracking', 0),
(3653, 0, 1827, 'Add CI type', 0),
(3654, 1, 1827, 'Add CI type', 0),
(3655, 0, 1828, 'Update CI type', 0),
(3656, 1, 1828, 'Update CI type', 0),
(3657, 0, 1829, 'Update location', 0),
(3658, 1, 1829, 'Update location', 0),
(3659, 0, 1830, 'Product catalog', 0),
(3660, 1, 1830, 'Product catalog', 0),
(3661, 0, 1831, 'Add package', 0),
(3662, 1, 1831, 'Add package', 0),
(3663, 0, 1832, 'Update package', 0),
(3664, 1, 1832, 'Update package', 0),
(3665, 0, 1833, 'Delete product status', 0),
(3666, 1, 1833, 'Delete product status', 0),
(3667, 0, 1834, 'Deleting service category will also delete its service items', 0),
(3668, 1, 1834, 'Deleting service category will also delete its service items', 0),
(3669, 0, 1835, 'Reply / Reply all incident', 0),
(3670, 1, 1835, 'Reply / Reply all incident', 0),
(3671, 0, 1836, 'Install details', 0),
(3672, 1, 1836, 'Install details', 0),
(3673, 0, 1837, 'Edit asset', 0),
(3674, 1, 1837, 'Edit asset', 0),
(3675, 0, 1838, 'Approval status', 0),
(3676, 1, 1838, 'Approval status', 0),
(3677, 0, 1839, 'Requested', 0),
(3678, 1, 1839, 'Requested', 0),
(3679, 0, 1840, 'Rejected', 0),
(3680, 1, 1840, 'Rejected', 0),
(3681, 0, 1841, 'Approvals', 0),
(3682, 1, 1841, 'Approvals', 0),
(3683, 0, 1842, 'No approvals available', 0),
(3684, 1, 1842, 'No approvals available', 0),
(3685, 0, 1843, 'Request for approval', 0),
(3686, 1, 1843, 'Request for approval', 0),
(3687, 0, 1844, 'Sent on', 0),
(3688, 1, 1844, 'Sent on', 0),
(3689, 0, 1845, 'Approved on', 0),
(3690, 1, 1845, 'Approved on', 0),
(3691, 0, 1846, 'Cancelled on', 0),
(3692, 1, 1846, 'Cancelled on', 0),
(3693, 0, 1847, 'Rejected on', 0),
(3694, 1, 1847, 'Rejected on', 0),
(3695, 0, 1848, 'Send reminder', 0),
(3696, 1, 1848, 'Send reminder', 0),
(3697, 0, 1849, 'Remarks', 0),
(3698, 1, 1849, 'Remarks', 0),
(3699, 0, 1850, 'Add release', 0),
(3700, 1, 1850, 'Add release', 0),
(3701, 0, 1851, 'Change hash', 0),
(3702, 1, 1851, 'Change hash', 0),
(3703, 0, 1852, 'Alert message', 0),
(3704, 1, 1852, 'Alert message', 0),
(3705, 0, 1853, 'If field already in use,it will not to be disabled', 0),
(3706, 1, 1853, 'If field already in use,it will not to be disabled', 0),
(3707, 0, 1854, 'Hr', 0),
(3708, 1, 1854, 'Hr', 0),
(3709, 0, 1855, 'Install status', 0),
(3710, 1, 1855, 'Install status', 0),
(3711, 0, 1856, 'Loading', 0),
(3712, 1, 1856, 'Loading', 0),
(3713, 0, 1857, 'Asset components', 0),
(3714, 1, 1857, 'Asset components', 0),
(3715, 0, 1858, 'L to R', 0),
(3716, 1, 1858, 'L to R', 0),
(3717, 0, 1859, 'Last', 0),
(3718, 1, 1859, 'Last', 0),
(3719, 0, 1860, 'Live', 0),
(3720, 1, 1860, 'Live', 0),
(3721, 0, 1861, 'Search CI item', 0),
(3722, 1, 1861, 'Search CI item', 0),
(3723, 0, 1862, 'Merge from', 0),
(3724, 1, 1862, 'Merge from', 0),
(3725, 0, 1863, 'In progress task', 0),
(3726, 1, 1863, 'In progress task', 0),
(3727, 0, 1864, 'Completed task', 0),
(3728, 1, 1864, 'Completed task', 0),
(3729, 0, 1865, 'Cancelled task', 0),
(3730, 1, 1865, 'Cancelled task', 0),
(3731, 0, 1866, 'Low priority task', 0),
(3732, 1, 1866, 'Low priority task', 0),
(3733, 0, 1867, 'Medium priority task', 0),
(3734, 1, 1867, 'Medium priority task', 0),
(3735, 0, 1868, 'High priority task', 0),
(3736, 1, 1868, 'High priority task', 0),
(3737, 0, 1869, 'Min', 0),
(3738, 1, 1869, 'Min', 0),
(3739, 0, 1870, 'Move details', 0),
(3740, 1, 1870, 'Move details', 0),
(3741, 0, 1871, 'Move status', 0),
(3742, 1, 1871, 'Move status', 0),
(3743, 0, 1872, 'Quantity', 0),
(3744, 1, 1872, 'Quantity', 0),
(3745, 0, 1873, 'Cost', 0),
(3746, 1, 1873, 'Cost', 0),
(3747, 0, 1874, 'Enter task title', 0),
(3748, 1, 1874, 'Enter task title', 0),
(3749, 0, 1875, 'Add task description', 0),
(3750, 1, 1875, 'Add task description', 0),
(3751, 0, 1876, 'Staff access', 0),
(3752, 1, 1876, 'Staff access', 0),
(3753, 0, 1877, 'Search tasks', 0),
(3754, 1, 1877, 'Search tasks', 0),
(3755, 0, 1878, 'Search changes', 0),
(3756, 1, 1878, 'Search changes', 0),
(3757, 0, 1879, 'Mobile number should be numeric', 0),
(3758, 1, 1879, 'Mobile number should be numeric', 0),
(3759, 0, 1880, 'SMTP settings are already added for all departments, please edit or delete existing SMTP settings to add new entry.', 0),
(3760, 1, 1880, 'SMTP settings are already added for all departments, please edit or delete existing SMTP settings to add new entry.', 0),
(3761, 0, 1881, 'Client reply', 0),
(3762, 1, 1881, 'Client reply', 0),
(3763, 0, 1882, 'Client deleted', 0),
(3764, 1, 1882, 'Client deleted', 0),
(3765, 0, 1883, 'Client add', 0),
(3766, 1, 1883, 'Client add', 0),
(3767, 0, 1884, 'Delete facebook page', 0),
(3768, 1, 1884, 'Delete facebook page', 0),
(3769, 0, 1885, 'ITIL hash generation', 0),
(3770, 1, 1885, 'ITIL hash generation', 0),
(3771, 0, 1886, 'Services prefix', 0),
(3772, 1, 1886, 'Services prefix', 0),
(3773, 0, 1887, 'Problems prefix', 0),
(3774, 1, 1887, 'Problems prefix', 0),
(3775, 0, 1888, 'Changes prefix', 0),
(3776, 1, 1888, 'Changes prefix', 0),
(3777, 0, 1889, 'Releases prefix', 0),
(3778, 1, 1889, 'Releases prefix', 0),
(3779, 0, 1890, 'Contracts prefix', 0),
(3780, 1, 1890, 'Contracts prefix', 0),
(3781, 0, 1891, 'Mute participants upon entry', 0),
(3782, 1, 1891, 'Mute participants upon entry', 0),
(3783, 0, 1892, 'Incident moved to inbox from trash', 0),
(3784, 1, 1892, 'Incident moved to inbox from trash', 0),
(3785, 0, 1893, 'SLA time should not be negative', 0),
(3786, 1, 1893, 'SLA time should not be negative', 0),
(3787, 0, 1894, 'Edit page', 0),
(3788, 1, 1894, 'Edit page', 0),
(3789, 0, 1895, 'Deleting facebook app will also delete its pages', 0),
(3790, 1, 1895, 'Deleting facebook app will also delete its pages', 0),
(3791, 0, 1896, 'Gotomeeting details', 0),
(3792, 1, 1896, 'Gotomeeting details', 0),
(3793, 0, 1897, 'Enter valid incident hash', 0),
(3794, 1, 1897, 'Enter valid incident hash', 0),
(3795, 0, 1898, 'New client', 0),
(3796, 1, 1898, 'New client', 0),
(3797, 0, 1899, 'New article', 0),
(3798, 1, 1899, 'New article', 0),
(3799, 0, 1900, 'New comment', 0),
(3800, 1, 1900, 'New comment', 0),
(3801, 0, 1901, 'New blab', 0),
(3802, 1, 1901, 'New blab', 0),
(3803, 0, 1902, 'Task assigned', 0),
(3804, 1, 1902, 'Task assigned', 0),
(3805, 0, 1903, 'Task comment', 0),
(3806, 1, 1903, 'Task comment', 0),
(3807, 0, 1904, 'New order', 0),
(3808, 1, 1904, 'New order', 0),
(3809, 0, 1905, 'Invoice created', 0),
(3810, 1, 1905, 'Invoice created', 0),
(3811, 0, 1906, 'Invoice description', 0),
(3812, 1, 1906, 'Invoice description', 0),
(3813, 0, 1907, 'Delete product vendor', 0),
(3814, 1, 1907, 'Delete product vendor', 0),
(3815, 0, 1908, 'Mail details log', 0),
(3816, 1, 1908, 'Mail details log', 0),
(3817, 0, 1909, 'Staff name and profile image', 0),
(3818, 1, 1909, 'Staff name and profile image', 0),
(3819, 0, 1910, 'Services hash prefix must be alphanumeric', 0),
(3820, 1, 1910, 'Services hash prefix must be alphanumeric', 0),
(3821, 0, 1911, 'Problems hash prefix field is empty', 0),
(3822, 1, 1911, 'Problems hash prefix field is empty', 0),
(3823, 0, 1912, 'Problems hash prefix must be alphanumeric', 0),
(3824, 1, 1912, 'Problems hash prefix must be alphanumeric', 0),
(3825, 0, 1913, 'Changes hash prefix field is empty', 0),
(3826, 1, 1913, 'Changes hash prefix field is empty', 0),
(3827, 0, 1914, 'Changes hash prefix must be alphanumeric', 0),
(3828, 1, 1914, 'Changes hash prefix must be alphanumeric', 0),
(3829, 0, 1915, 'Contracts hash prefix field is empty', 0),
(3830, 1, 1915, 'Contracts hash prefix field is empty', 0),
(3831, 0, 1916, 'Contracts hash prefix must be alphanumeric', 0),
(3832, 1, 1916, 'Contracts hash prefix must be alphanumeric', 0),
(3833, 0, 1917, 'Numbering start from must be alphanumeric', 0),
(3834, 1, 1917, 'Numbering start from must be alphanumeric', 0),
(3835, 0, 1918, 'Values should not be negative', 0),
(3836, 1, 1918, 'Values should not be negative', 0),
(3837, 0, 1919, 'New release created', 0),
(3838, 1, 1919, 'New release created', 0),
(3839, 0, 1920, 'Changes linked', 0),
(3840, 1, 1920, 'Changes linked', 0),
(3841, 0, 1921, 'Incident split', 0),
(3842, 1, 1921, 'Incident split', 0),
(3843, 0, 1922, 'Incident linked to', 0),
(3844, 1, 1922, 'Incident linked to', 0),
(3845, 0, 1923, 'Search service item', 0),
(3846, 1, 1923, 'Search service item', 0),
(3847, 0, 1924, 'Service category', 0),
(3848, 1, 1924, 'Service category', 0),
(3849, 0, 1925, 'Duration must be less than or equal to 3 months', 0),
(3850, 1, 1925, 'Duration must be less than or equal to 3 months', 0),
(3851, 0, 1926, 'From date must be less than to date', 0),
(3852, 1, 1926, 'From date must be less than to date', 0),
(3853, 1, 1927, 'Service result', 0),
(3854, 0, 1927, 'Service search result', 0),
(3855, 0, 1928, 'Mark paid', 0),
(3856, 1, 1928, 'Mark paid', 0),
(3857, 0, 1929, 'No data found', 0),
(3858, 1, 1929, 'No data found', 0),
(3859, 0, 1930, 'Delete release', 0),
(3860, 1, 1930, 'Delete release', 0),
(3861, 0, 1931, 'Incident rating', 0),
(3862, 1, 1931, 'Incident rating', 0),
(3863, 0, 1932, 'Select service category', 0),
(3864, 1, 1932, 'Select service category', 0),
(3865, 0, 1933, 'Incident post deleted', 0),
(3866, 1, 1933, 'Incident post deleted', 0),
(3867, 0, 1934, 'Service request for', 0),
(3868, 1, 1934, 'Service request for', 0),
(3869, 0, 1935, 'Incident post not available', 0),
(3870, 1, 1935, 'Incident post not available', 0),
(3871, 0, 1936, 'Financial details', 0),
(3872, 1, 1936, 'Financial details', 0),
(3873, 0, 1937, 'Contact must be numeric', 0),
(3874, 1, 1937, 'Contact must be numeric', 0),
(3875, 0, 1938, 'Estimated delivery in days', 0),
(3876, 1, 1938, 'Estimated delivery in days', 0),
(3877, 0, 1939, 'Releases can not move from one domain to other domain', 0),
(3878, 1, 1939, 'Releases can not move from one domain to other domain', 0),
(3879, 0, 1940, 'Salesforce', 0),
(3880, 1, 1940, 'Salesforce', 0),
(3881, 0, 1941, 'Badge earn', 0),
(3882, 1, 1941, 'Badge earn', 0),
(3883, 0, 1942, 'No badge', 0),
(3884, 1, 1942, 'No badge', 0),
(3885, 0, 1943, 'Add new twilio number', 0),
(3886, 1, 1943, 'Add new twilio number', 0),
(3887, 0, 1944, 'Key', 0),
(3888, 1, 1944, 'Key', 0),
(3889, 0, 1945, 'Twilio number', 0),
(3890, 1, 1945, 'Twilio number', 0),
(3891, 0, 1946, 'Barcode/QR code generation', 0),
(3892, 1, 1946, 'Barcode/QR code generation', 0),
(3893, 0, 1947, 'Welcome message', 0),
(3894, 1, 1947, 'Welcome message', 0),
(3895, 0, 1948, 'Invalid phone number', 0),
(3896, 1, 1948, 'Invalid phone number', 0),
(3897, 0, 1949, 'Allow outbound calls to contacts', 0),
(3898, 1, 1949, 'Allow outbound calls to contacts', 0),
(3899, 0, 1950, 'Call forwarding', 0),
(3900, 1, 1950, 'Call forwarding', 0),
(3901, 0, 1951, 'To phone number', 0),
(3902, 1, 1951, 'To phone number', 0),
(3903, 0, 1952, 'To staff browser', 0),
(3904, 1, 1952, 'To staff browser', 0),
(3905, 0, 1953, 'Forwarding number', 0),
(3906, 1, 1953, 'Forwarding number', 0),
(3907, 0, 1954, 'Update twilio number', 0),
(3908, 1, 1954, 'Update twilio number', 0),
(3909, 0, 1955, 'Invalid twilio details', 0),
(3910, 1, 1955, 'Invalid twilio details', 0),
(3911, 0, 1956, 'All', 0),
(3912, 1, 1956, 'All', 0),
(3913, 0, 1957, 'Key message', 0),
(3914, 1, 1957, 'Key message', 0),
(3915, 0, 1958, 'Press zero to connect to sales department', 0),
(3916, 1, 1958, 'Press zero to connect to sales department', 0),
(3917, 0, 1959, 'Comma separated phone numbers e.g. +18007845478,+919865741000', 0),
(3918, 1, 1959, 'Comma separated phone numbers e.g. +18007845478,+919865741000', 0),
(3919, 0, 1960, 'Tag already in used', 0),
(3920, 1, 1960, 'Tag already in used', 0),
(3921, 0, 1961, 'Client ID', 0),
(3922, 1, 1961, 'Client ID', 0),
(3923, 0, 1962, 'Client secret', 0),
(3924, 1, 1962, 'Client secret', 0),
(3925, 0, 1963, 'Checked in by', 0),
(3926, 1, 1963, 'Checked in by', 0),
(3927, 0, 1964, 'Campaigns name', 0),
(3928, 1, 1964, 'Campaigns name', 0),
(3929, 0, 1965, 'Do not have an account?', 0),
(3930, 1, 1965, 'Do not have an account?', 0),
(3931, 0, 1966, 'Consumer secret', 0),
(3932, 1, 1966, 'Consumer secret', 0),
(3933, 0, 1967, 'Close incident', 0),
(3934, 1, 1967, 'Close incident', 0),
(3935, 0, 1968, 'License owner', 0),
(3936, 1, 1968, 'License owner', 0),
(3937, 0, 1969, 'Number of companies', 0),
(3938, 1, 1969, 'Number of companies', 0),
(3939, 0, 1970, 'Number of assets', 0),
(3940, 1, 1970, 'Number of assets', 0),
(3941, 0, 1971, 'Copyright', 0),
(3942, 1, 1971, 'Copyright', 0),
(3943, 0, 1972, 'Post your comments here...', 0),
(3944, 1, 1972, 'Post your comments here...', 0),
(3945, 0, 1973, 'Status changed from', 0),
(3946, 1, 1973, 'Status changed from', 0),
(3947, 0, 1974, 'Priority changed from', 0),
(3948, 1, 1974, 'Priority changed from', 0),
(3949, 0, 1975, 'Department changed from', 0),
(3950, 1, 1975, 'Department changed from', 0),
(3951, 0, 1976, 'Incident type changed from', 0),
(3952, 1, 1976, 'Incident type changed from', 0),
(3953, 0, 1977, 'Flag changed from', 0),
(3954, 1, 1977, 'Flag changed from', 0),
(3955, 0, 1978, 'Incident unassigned from', 0),
(3956, 1, 1978, 'Incident unassigned from', 0),
(3957, 0, 1979, 'Incident assigned to nobody', 0),
(3958, 1, 1979, 'Incident assigned to nobody', 0),
(3959, 0, 1980, 'SLA set to', 0),
(3960, 1, 1980, 'SLA set to', 0),
(3961, 0, 1981, 'Applied custom SLA plan', 0),
(3962, 1, 1981, 'Applied custom SLA plan', 0),
(3963, 0, 1982, 'Not spam marked', 0),
(3964, 1, 1982, 'Not spam marked', 0),
(3965, 0, 1983, 'New task attached', 0),
(3966, 1, 1983, 'New task attached', 0),
(3967, 0, 1984, 'Detached attached task', 0),
(3968, 1, 1984, 'Detached attached task', 0),
(3969, 0, 1985, 'New CI attached', 0),
(3970, 1, 1985, 'New CI attached', 0),
(3971, 0, 1986, 'Detached attached CI', 0),
(3972, 1, 1986, 'Detached attached CI', 0),
(3973, 0, 1987, 'New problem attached', 0),
(3974, 1, 1987, 'New problem attached', 0),
(3975, 0, 1988, 'Detached attached problem', 0),
(3976, 1, 1988, 'Detached attached problem', 0),
(3977, 0, 1989, 'New change attached', 0);
INSERT INTO `avis_language_values` VALUES
(3978, 1, 1989, 'New change attached', 0),
(3979, 0, 1990, 'Detached attached change', 0),
(3980, 1, 1990, 'Detached attached change', 0),
(3981, 0, 1991, 'Incident post split with', 0),
(3982, 1, 1991, 'Incident post split with', 0),
(3983, 0, 1992, 'SLA changed from', 0),
(3984, 1, 1992, 'SLA changed from', 0),
(3985, 0, 1993, 'Linked to', 0),
(3986, 1, 1993, 'Linked to', 0),
(3987, 0, 1994, 'Accept', 0),
(3988, 1, 1994, 'Accept', 0),
(3989, 0, 1995, 'Caller on', 0),
(3990, 1, 1995, 'Caller on', 0),
(3991, 0, 1996, 'Connecting', 0),
(3992, 1, 1996, 'Connecting', 0),
(3993, 0, 1997, 'Call connected', 0),
(3994, 1, 1997, 'Call connected', 0),
(3995, 0, 1998, 'Call ended', 0),
(3996, 1, 1998, 'Call ended', 0),
(3997, 0, 1999, 'Search client name or phone number', 0),
(3998, 1, 1999, 'Search client name or phone number', 0),
(3999, 0, 2000, 'E.g. +019876543210', 0),
(4000, 1, 2000, 'E.g. +019876543210', 0),
(4001, 0, 2001, 'Custom report', 0),
(4002, 1, 2001, 'Custom report', 0),
(4003, 0, 2002, 'Incident unassigned', 0),
(4004, 1, 2002, 'Incident unassigned', 0),
(4005, 0, 2003, 'Checked out by', 0),
(4006, 1, 2003, 'Checked out by', 0),
(4007, 0, 2004, 'Widget', 0),
(4008, 1, 2004, 'Widget', 0),
(4009, 0, 2005, 'Button name', 0),
(4010, 1, 2005, 'Button name', 0),
(4011, 0, 2006, 'Clone', 0),
(4012, 1, 2006, 'Clone', 0),
(4013, 0, 2007, 'Order date', 0),
(4014, 1, 2007, 'Order date', 0),
(4015, 0, 2008, 'More conversation', 0),
(4016, 1, 2008, 'More conversation', 0),
(4017, 0, 2009, 'Fetch chat', 0),
(4018, 1, 2009, 'Fetch chat', 0),
(4019, 0, 2010, 'Please enter visitor email address', 0),
(4020, 1, 2010, 'Please enter visitor email address', 0),
(4021, 0, 2011, 'Not maintain', 0),
(4022, 1, 2011, 'Not maintain', 0),
(4023, 0, 2012, 'Resolution SLA', 0),
(4024, 1, 2012, 'Resolution SLA', 0),
(4025, 0, 2013, 'Response SLA', 0),
(4026, 1, 2013, 'Response SLA', 0),
(4027, 0, 2014, 'Total AVG. response SLA maintained', 0),
(4028, 1, 2014, 'Total AVG. response SLA maintained', 0),
(4029, 0, 2015, 'Total AVG. resolution SLA maintained', 0),
(4030, 1, 2015, 'Total AVG. resolution SLA maintained', 0),
(4031, 0, 2016, 'Freshbooks domain', 0),
(4032, 1, 2016, 'Freshbooks domain', 0),
(4033, 0, 2017, 'Projects', 0),
(4034, 1, 2017, 'Projects', 0),
(4035, 0, 2018, 'Amount outstanding', 0),
(4036, 1, 2018, 'Amount outstanding', 0),
(4037, 0, 2019, 'Discount', 0),
(4038, 1, 2019, 'Discount', 0),
(4039, 0, 2020, 'Search by', 0),
(4040, 1, 2020, 'Search by', 0),
(4041, 0, 2021, 'Satellite helpdesk', 0),
(4042, 1, 2021, 'Satellite helpdesk', 0),
(4043, 0, 2022, 'Insightly', 0),
(4044, 1, 2022, 'Insightly', 0),
(4045, 0, 2023, 'Add insightly', 0),
(4046, 1, 2023, 'Add insightly', 0),
(4047, 0, 2024, 'Update insightly', 0),
(4048, 1, 2024, 'Update insightly', 0),
(4049, 0, 2025, 'Insightly API URL', 0),
(4050, 1, 2025, 'Insightly API URL', 0),
(4051, 0, 2026, 'Organization email', 0),
(4052, 1, 2026, 'Organization email', 0),
(4053, 0, 2027, 'Role', 0),
(4054, 1, 2027, 'Role', 0),
(4055, 0, 2028, 'Help', 0),
(4056, 1, 2028, 'Help', 0),
(4057, 0, 2029, 'Search solutions', 0),
(4058, 1, 2029, 'Search solutions', 0),
(4059, 0, 2030, 'No record found', 0),
(4060, 1, 2030, 'No record found', 0),
(4061, 0, 2031, 'Select and copy', 0),
(4062, 1, 2031, 'Select and copy', 0),
(4063, 0, 2032, 'Widget code', 0),
(4064, 1, 2032, 'Widget code', 0),
(4065, 0, 2033, 'Preview', 0),
(4066, 1, 2033, 'Preview', 0),
(4067, 0, 2034, 'Rounded', 0),
(4068, 1, 2034, 'Rounded', 0),
(4069, 0, 2035, 'Square', 0),
(4070, 1, 2035, 'Square', 0),
(4071, 0, 2036, 'Button type', 0),
(4072, 1, 2036, 'Button type', 0),
(4073, 0, 2037, 'Right bottom', 0),
(4074, 1, 2037, 'Right bottom', 0),
(4075, 0, 2038, 'Left bottom', 0),
(4076, 1, 2038, 'Left bottom', 0),
(4077, 0, 2039, 'Right top', 0),
(4078, 1, 2039, 'Right top', 0),
(4079, 0, 2040, 'Widget position', 0),
(4080, 1, 2040, 'Widget position', 0),
(4081, 0, 2041, 'Feature', 0),
(4082, 1, 2041, 'Feature', 0),
(4083, 0, 2042, 'Both', 0),
(4084, 1, 2042, 'Both', 0),
(4085, 0, 2043, 'Request submitted', 0),
(4086, 1, 2043, 'Request submitted', 0),
(4087, 0, 2044, 'Field missing', 0),
(4088, 1, 2044, 'Field missing', 0),
(4089, 0, 2045, 'Property', 0),
(4090, 1, 2045, 'Property', 0),
(4091, 0, 2046, 'Secret key', 0),
(4092, 1, 2046, 'Secret key', 0),
(4093, 0, 2047, 'Publishable key', 0),
(4094, 1, 2047, 'Publishable key', 0),
(4095, 0, 2048, 'Base value', 0),
(4096, 1, 2048, 'Base value', 0),
(4097, 0, 2049, 'Publishable key missing', 0),
(4098, 1, 2049, 'Publishable key missing', 0),
(4099, 0, 2050, 'Facebook details missing', 0),
(4100, 1, 2050, 'Facebook details missing', 0),
(4101, 0, 2051, 'Links for incident', 0),
(4102, 1, 2051, 'Links for incident', 0),
(4103, 1, 2052, 'Email has been sent to verification link', 0),
(4104, 0, 2052, 'Email has been sent to verification link', 0),
(4105, 1, 2053, 'Resend verification link', 0),
(4106, 0, 2053, 'Resend verification link', 0),
(4107, 1, 2054, 'Operation can not be performed, client is not verify', 0),
(4108, 0, 2054, 'Operation can not be performed, client is not verify', 0),
(4109, 1, 2055, 'Operation can not be performed, client is not approve', 0),
(4110, 0, 2055, 'Operation can not be performed, client is not approve', 0),
(4111, 1, 2056, 'Operation can not be performed, client is spam', 0),
(4112, 0, 2056, 'Operation can not be performed, client is spam', 0),
(4113, 1, 2057, 'Operation can not be performed, client is ban', 0),
(4114, 0, 2057, 'Operation can not be performed, client is ban', 0),
(4115, 1, 2058, 'Not verified', 0),
(4116, 0, 2058, 'Not verified', 0),
(4117, 1, 2059, 'Verified', 0),
(4118, 0, 2059, 'Verified', 0),
(4119, 0, 2060, 'Current value', 0),
(4120, 1, 2060, 'Current value', 0),
(4121, 1, 2061, 'Create issue', 0),
(4122, 0, 2061, 'Create issue', 0),
(4123, 1, 2062, 'Issue type', 0),
(4124, 0, 2062, 'Issue type', 0),
(4125, 1, 2063, 'Issue hash', 0),
(4126, 0, 2063, 'Issue hash', 0),
(4127, 1, 2064, 'Link issue', 0),
(4128, 0, 2064, 'Link issue', 0),
(4129, 1, 2065, 'Unlink issue', 0),
(4130, 0, 2065, 'Unlink issue', 0),
(4131, 1, 2066, 'View issue in jira', 0),
(4132, 0, 2066, 'View issue in jira', 0),
(4133, 0, 2067, 'For new asset', 0),
(4134, 1, 2067, 'For new asset', 0),
(4135, 1, 2068, 'Due', 0),
(4136, 0, 2068, 'Due', 0),
(4137, 1, 2069, 'Package name', 0),
(4138, 0, 2069, 'Package name', 0),
(4139, 1, 2070, 'Term', 0),
(4140, 0, 2070, 'Term', 0),
(4141, 1, 2071, 'Create subtask', 0),
(4142, 0, 2071, 'Create subtask', 0),
(4143, 1, 2072, 'Child of', 0),
(4144, 0, 2072, 'Child of', 0),
(4145, 1, 2073, 'Subtask', 0),
(4146, 0, 2073, 'Subtask', 0),
(4147, 1, 2074, 'Target date', 0),
(4148, 0, 2074, 'Target date', 0),
(4149, 0, 2075, 'For existing asset', 0),
(4150, 1, 2075, 'For existing asset', 0),
(4151, 0, 2076, 'Barcode/QR code', 0),
(4152, 1, 2076, 'Barcode/QR code', 0),
(4153, 1, 2077, 'Time tracking per client', 1),
(4154, 0, 2077, 'Time tracking per client', 1),
(4155, 1, 2078, 'Time tracking per organization', 1),
(4156, 0, 2078, 'Time tracking per organization', 1),
(4157, 1, 2079, 'Recursive task', 0),
(4158, 0, 2079, 'Recursive task', 0),
(4159, 1, 2080, 'Mass reply', 0),
(4160, 0, 2080, 'Mass reply', 0),
(4161, 1, 2081, 'Reply all linked incidents', 0),
(4162, 0, 2081, 'Reply all linked incidents', 0),
(4163, 1, 2082, 'Changing organization status to disable will ban all clients & their incidents.<br/>This operation is irreversible<br />Are you sure you want to proceed?', 0),
(4164, 0, 2082, 'Changing organization status to disable will ban all clients & their incidents.<br/>This operation is irreversible<br />Are you sure you want to proceed?', 0),
(4165, 1, 2083, 'Organization can not set to other domain clients', 0),
(4166, 0, 2083, 'Organization can not set to other domain clients', 0),
(4167, 1, 2084, 'Move clients to any organization', 0),
(4168, 0, 2084, 'Move clients to any organization', 0),
(4169, 1, 2085, 'You have already submited feedback', 0),
(4170, 0, 2085, 'You have already submited feedback.', 0),
(4171, 1, 2086, 'Rate this incident', 0),
(4172, 0, 2086, 'Rate this incident', 0),
(4173, 1, 2087, 'Can client close incident', 0),
(4174, 0, 2087, 'Can client close incident', 0),
(4175, 1, 2088, 'Solution and incident search', 0),
(4176, 0, 2088, 'Solution and incident search', 0),
(4177, 0, 2089, 'Releases hash prefix must be alphanumeric', 0),
(4178, 1, 2089, 'Releases hash prefix must be alphanumeric', 0),
(4179, 1, 2090, 'unlinked from', 0),
(4180, 0, 2090, 'unlinked from', 0),
(4181, 1, 2091, 'Pinned', 0),
(4182, 0, 2091, 'Pinned', 0),
(4183, 1, 2092, 'Removed label', 0),
(4184, 0, 2092, 'Removed label', 0),
(4185, 1, 2093, 'Incident property updated', 0),
(4186, 0, 2093, 'Incident property updated', 0),
(4187, 1, 2094, 'Incident note added', 0),
(4188, 0, 2094, 'Incident note added', 0),
(4189, 1, 2095, 'Incident note deleted', 0),
(4190, 0, 2095, 'Incident note deleted', 0),
(4191, 1, 2096, 'Incident comment added', 0),
(4192, 0, 2096, 'Incident comment added', 0),
(4193, 1, 2097, 'Incident comment deleted', 0),
(4194, 0, 2097, 'Incident comment deleted', 0),
(4195, 1, 2098, 'Incident post updated', 0),
(4196, 0, 2098, 'Incident post updated', 0),
(4197, 1, 2099, 'Added new recipient', 0),
(4198, 0, 2099, 'Added new recipient', 0),
(4199, 1, 2100, 'Added new people', 0),
(4200, 0, 2100, 'Added new people', 0),
(4201, 1, 2101, 'Removed recipient', 0),
(4202, 0, 2101, 'Removed recipient', 0),
(4203, 1, 2102, 'Removed people', 0),
(4204, 0, 2102, 'Removed people', 0),
(4205, 1, 2103, 'Added new tag', 0),
(4206, 0, 2103, 'Added new tag', 0),
(4207, 0, 2104, 'Left to right', 0),
(4208, 1, 2104, 'Left to right', 0),
(4209, 1, 2105, 'Send notification for new task and task comment', 0),
(4210, 0, 2105, 'Send notification for new task and task comment', 0),
(4211, 0, 2106, 'Search topic', 0),
(4212, 1, 2106, 'Search topic', 0),
(4213, 0, 2107, 'All activity', 0),
(4214, 1, 2107, 'All activity', 0),
(4215, 0, 2108, 'Waiting for approval', 0),
(4216, 1, 2108, 'Waiting for approval', 0),
(4217, 0, 2109, 'My topics activity', 0),
(4218, 1, 2109, 'My topics activity', 0),
(4219, 0, 2110, 'All category', 0),
(4220, 1, 2110, 'All category', 0),
(4221, 0, 2111, 'Edit forum', 0),
(4222, 1, 2111, 'Edit forum', 0),
(4223, 0, 2112, 'Add forum category', 0),
(4224, 1, 2112, 'Add forum category', 0),
(4225, 0, 2113, 'Add forum', 0),
(4226, 1, 2113, 'Add forum', 0),
(4227, 0, 2114, 'Category delete', 0),
(4228, 1, 2114, 'Category delete', 0),
(4229, 0, 2115, 'Deleting this category will delete all forums and topics in it.', 0),
(4230, 1, 2115, 'Deleting this category will delete all forums and topics in it.', 0),
(4231, 0, 2116, 'Scanned', 0),
(4232, 1, 2116, 'Scanned', 0),
(4233, 0, 2117, 'Forum notification', 0),
(4234, 1, 2117, 'Forum notification', 0),
(4235, 0, 2118, 'Delete topic comment', 0),
(4236, 1, 2118, 'Delete topic comment', 0),
(4237, 0, 2119, 'Deleting topic will delete topic and comments on it. <br />This operation </br>is irreversible. <br />Are you sure you want to proceed?', 0),
(4238, 1, 2119, 'Deleting topic will delete topic and comments on it. <br />This operation </br>is irreversible. <br />Are you sure you want to proceed?', 0),
(4239, 0, 2120, 'Delete topic', 0),
(4240, 1, 2120, 'Delete topic', 0),
(4241, 0, 2121, 'Update topic', 0),
(4242, 1, 2121, 'Update topic', 0),
(4243, 0, 2122, 'Installed', 0),
(4244, 1, 2122, 'Installed', 0),
(4245, 0, 2123, 'Delete forum', 0),
(4246, 1, 2123, 'Delete forum', 0),
(4247, 0, 2124, 'Deleting forum will delete  all its topics and comments on that topic. <br />This operation is irreversible. <br />Are you  sure you want to proceed?', 0),
(4248, 1, 2124, 'Deleting forum will delete  all its topics and comments on that topic. <br />This operation is irreversible. <br />Are you  sure you want to proceed?', 0),
(4249, 0, 2125, 'Unlock', 0),
(4250, 1, 2125, 'Unlock', 0),
(4251, 0, 2126, 'New topics', 0),
(4252, 1, 2126, 'New topics', 0),
(4253, 0, 2127, 'Topic followers', 0),
(4254, 1, 2127, 'Topic followers', 0),
(4255, 0, 2128, 'Forums', 0),
(4256, 1, 2128, 'Forums', 0),
(4257, 0, 2129, 'Add topic', 0),
(4258, 1, 2129, 'Add topic', 0),
(4259, 0, 2130, 'Topic title', 0),
(4260, 1, 2130, 'Topic title', 0),
(4261, 0, 2131, 'Post topic in', 0),
(4262, 1, 2131, 'Post topic in', 0),
(4263, 0, 2132, 'Attach files', 0),
(4264, 1, 2132, 'Attach files', 0),
(4265, 0, 2133, 'Created by', 0),
(4266, 1, 2133, 'Created by', 0),
(4267, 0, 2134, 'Vote', 0),
(4268, 1, 2134, 'Vote', 0),
(4269, 0, 2135, 'Comment', 0),
(4270, 1, 2135, 'Comment', 0),
(4271, 0, 2136, 'Follow', 0),
(4272, 1, 2136, 'Follow', 0),
(4273, 0, 2137, 'Unfollow', 0),
(4274, 1, 2137, 'Unfollow', 0),
(4275, 0, 2138, 'Delete forum activity', 0),
(4276, 1, 2138, 'Delete forum activity', 0),
(4277, 0, 2139, 'New topic', 0),
(4278, 1, 2139, 'New topic', 0),
(4279, 0, 2140, 'New topic comment', 0),
(4280, 1, 2140, 'New topic comment', 0),
(4281, 0, 2141, 'Topic', 0),
(4282, 1, 2141, 'Topic', 0),
(4283, 0, 2142, 'Popularity', 0),
(4284, 1, 2142, 'Popularity', 0),
(4285, 0, 2143, 'Required to add forum category', 0),
(4286, 1, 2143, 'Required to add forum category', 0),
(4287, 0, 2144, 'Required to add forum', 0),
(4288, 1, 2144, 'Required to add forum', 0),
(4289, 0, 2145, 'Post topic', 0),
(4290, 1, 2145, 'Post topic', 0),
(4291, 0, 2146, 'Show modified topic up', 0),
(4292, 1, 2146, 'Show modified topic up', 0),
(4293, 0, 2147, 'Schedule incident', 0),
(4294, 1, 2147, 'Schedule incident', 0),
(4295, 0, 2148, 'Schedule date', 0),
(4296, 1, 2148, 'Schedule date', 0),
(4297, 0, 2149, 'Schedule date must be greater than current date', 0),
(4298, 1, 2149, 'Schedule date must be greater than current date', 0),
(4299, 0, 2150, 'End date must be greater than schedule date', 0),
(4300, 1, 2150, 'End date must be greater than schedule date', 0),
(4301, 0, 2151, 'Repeat schedule', 0),
(4302, 1, 2151, 'Repeat schedule', 0),
(4303, 0, 2152, 'New scheduled incident created', 0),
(4304, 1, 2152, 'New scheduled incident created', 0),
(4305, 0, 2153, 'Verify email', 0),
(4306, 1, 2153, 'Verify email', 0),
(4307, 0, 2154, 'Search result', 0),
(4308, 1, 2154, 'Search result', 0),
(4309, 0, 2155, 'Recent', 0),
(4310, 1, 2155, 'Recent', 0),
(4311, 0, 2156, 'Popular', 0),
(4312, 1, 2156, 'Popular', 0),
(4313, 0, 2157, 'Un-answered', 0),
(4314, 1, 2157, 'Un-answered', 0),
(4315, 0, 2158, 'Add category', 0),
(4316, 1, 2158, 'Add category', 0),
(4317, 0, 2159, 'Delete category', 0),
(4318, 1, 2159, 'Delete category', 0),
(4319, 0, 2160, 'Deleting category will also delete its subcategory and items', 0),
(4320, 1, 2160, 'Deleting category will also delete its subcategory and items', 0),
(4321, 0, 2161, 'Update category', 0),
(4322, 1, 2161, 'Update category', 0),
(4323, 0, 2162, 'Add subcategory', 0),
(4324, 1, 2162, 'Add subcategory', 0),
(4325, 0, 2163, 'Update subcategory', 0),
(4326, 1, 2163, 'Update subcategory', 0),
(4327, 0, 2164, 'Delete subcategory', 0),
(4328, 1, 2164, 'Delete subcategory', 0),
(4329, 0, 2165, 'Deleting subcategory will also delete its items', 0),
(4330, 1, 2165, 'Deleting subcategory will also delete its items', 0),
(4331, 0, 2166, 'Add item', 0),
(4332, 1, 2166, 'Add item', 0),
(4333, 0, 2167, 'Delete item', 0),
(4334, 1, 2167, 'Delete item', 0),
(4335, 0, 2168, 'Update item', 0),
(4336, 1, 2168, 'Update item', 0),
(4337, 0, 2169, 'Deleting item', 0),
(4338, 1, 2169, 'Deleting item', 0),
(4339, 0, 2170, 'Add level', 0),
(4340, 1, 2170, 'Add level', 0),
(4341, 0, 2171, 'Delete level', 0),
(4342, 1, 2171, 'Delete level', 0),
(4343, 0, 2172, 'Update level', 0),
(4344, 1, 2172, 'Update level', 0),
(4345, 0, 2173, 'Deleting level', 0),
(4346, 1, 2173, 'Deleting level', 0),
(4347, 0, 2174, 'Please enable category from incident module to access category.<br/> Setting > Module > Incident > category', 0),
(4348, 1, 2174, 'Please enable category from incident module to access category.<br/> Setting > Module > Incident > category', 0),
(4349, 0, 2175, 'Please enable incident level from incident module to access level.<br/> Setting > Module > Incident > Incident level', 0),
(4350, 1, 2175, 'Please enable incident level from incident module to access level.<br/> Setting > Module > Incident > Incident level', 0),
(4351, 0, 2176, 'Suggest search', 0),
(4352, 1, 2176, 'Suggest search', 0),
(4353, 0, 2177, 'Location', 0),
(4354, 1, 2177, 'Location', 0),
(4355, 0, 2178, 'Most commented', 0),
(4356, 1, 2178, 'Most commented', 0),
(4357, 0, 2179, 'Installed on', 0),
(4358, 1, 2179, 'Installed on', 0),
(4359, 0, 2180, 'Change category', 0),
(4360, 1, 2180, 'Change category', 0),
(4361, 0, 2181, 'Change subcategory', 0),
(4362, 1, 2181, 'Change subcategory', 0),
(4363, 0, 2182, 'Change item', 0),
(4364, 1, 2182, 'Change item', 0),
(4365, 0, 2183, 'Change level', 0),
(4366, 1, 2183, 'Change level', 0),
(4367, 0, 2184, 'Change location', 0),
(4368, 1, 2184, 'Change location', 0),
(4369, 0, 2185, 'Select', 0),
(4370, 1, 2185, 'Select', 0),
(4371, 0, 2186, 'Category', 0),
(4372, 1, 2186, 'Category', 0),
(4373, 0, 2187, 'Subcategory', 0),
(4374, 1, 2187, 'Subcategory', 0),
(4375, 0, 2188, 'Item', 0),
(4376, 1, 2188, 'Item', 0),
(4377, 0, 2189, 'Level', 0),
(4378, 1, 2189, 'Level', 0),
(4379, 0, 2190, 'Installation', 0),
(4380, 1, 2190, 'Installation', 0),
(4381, 0, 2191, 'Manage portal and client portal', 0),
(4382, 1, 2191, 'Manage portal and client portal', 0),
(4383, 0, 2192, 'Display subcategory', 0),
(4384, 1, 2192, 'Display subcategory', 0),
(4385, 0, 2193, 'Display item', 0),
(4386, 1, 2193, 'Display item', 0),
(4387, 0, 2194, 'Incident level changed', 0),
(4388, 1, 2194, 'Incident level changed', 0),
(4389, 0, 2195, 'Category changed', 0),
(4390, 1, 2195, 'Category changed', 0),
(4391, 0, 2196, 'Subcategory changed', 0),
(4392, 1, 2196, 'Subcategory changed', 0),
(4393, 0, 2197, 'Location changed', 0),
(4394, 1, 2197, 'Location changed', 0),
(4395, 0, 2198, 'This comment is waiting for approval.', 0),
(4396, 1, 2198, 'This comment is waiting for approval.', 0),
(4397, 0, 2199, 'Recurrence', 0),
(4398, 1, 2199, 'Recurrence', 0),
(4399, 0, 2200, 'Category change', 0),
(4400, 1, 2200, 'Category change', 0),
(4401, 0, 2201, 'Subcategory change', 0),
(4402, 1, 2201, 'Subcategory change', 0),
(4403, 0, 2202, 'Item change', 0),
(4404, 1, 2202, 'Item change', 0),
(4405, 0, 2203, 'Level change', 0),
(4406, 1, 2203, 'Level change', 0),
(4407, 0, 2204, 'Location change', 0),
(4408, 1, 2204, 'Location change', 0),
(4409, 0, 2205, 'Incident schedule', 0),
(4410, 1, 2205, 'Incident schedule', 0),
(4411, 0, 2206, 'Uninstalled', 0),
(4412, 1, 2206, 'Uninstalled', 0),
(4413, 0, 2207, 'Forum activity', 0),
(4414, 1, 2207, 'Forum activity', 0),
(4415, 0, 2208, 'Approved topics', 0),
(4416, 1, 2208, 'Approved topics', 0),
(4417, 0, 2209, 'Followed topics', 0),
(4418, 1, 2209, 'Followed topics', 0),
(4419, 0, 2210, 'Forum signature', 0),
(4420, 1, 2210, 'Forum signature', 0),
(4421, 0, 2211, 'Ok', 0),
(4422, 1, 2211, 'Ok', 0),
(4423, 0, 2212, 'Forum comment notification', 0),
(4424, 1, 2212, 'Forum comment notification', 0),
(4425, 0, 2213, 'Pending topics', 0),
(4426, 1, 2213, 'Pending topics', 0),
(4427, 0, 2214, 'Default page after login', 0),
(4428, 1, 2214, 'Default page after login', 0),
(4429, 0, 2215, 'Default page before login', 0),
(4430, 1, 2215, 'Default page before login', 0),
(4431, 0, 2216, 'User type', 0),
(4432, 1, 2216, 'User type', 0),
(4433, 0, 2217, 'Previous', 0),
(4434, 1, 2217, 'Previous', 0),
(4435, 0, 2218, 'Your comment is awaiting moderation.', 0),
(4436, 1, 2218, 'Your comment is awaiting moderation.', 0),
(4437, 0, 2219, 'Your topic is awaiting moderation', 0),
(4438, 1, 2219, 'Your topic is awaiting moderation', 0),
(4439, 0, 2220, 'Repeat', 0),
(4440, 1, 2220, 'Repeat', 0),
(4441, 0, 2221, 'Occurance(s) left', 0),
(4442, 1, 2221, 'Occurance(s) left', 0),
(4443, 0, 2222, 'Queue outgoing emails for delivery', 0),
(4444, 1, 2222, 'Queue outgoing emails for delivery', 0),
(4445, 0, 2223, 'No link incident found', 0),
(4446, 1, 2223, 'No link incident found', 0),
(4447, 0, 2224, 'Removed', 0),
(4448, 1, 2224, 'Removed', 0),
(4449, 0, 2225, 'Overuse', 0),
(4450, 1, 2225, 'Overuse', 0),
(4451, 0, 2226, 'Pause SLA', 0),
(4452, 1, 2226, 'Pause SLA', 0),
(4453, 0, 2227, 'Resume SLA', 0),
(4454, 1, 2227, 'Resume SLA', 0),
(4455, 0, 2228, 'SLA paused', 0),
(4456, 1, 2228, 'SLA paused', 0),
(4457, 0, 2229, 'SLA resumed', 0),
(4458, 1, 2229, 'SLA resumed', 0),
(4459, 0, 2230, 'Pause / Resume SLA', 0),
(4460, 1, 2230, 'Pause / Resume SLA', 0),
(4461, 0, 2231, 'With', 0),
(4462, 1, 2231, 'With', 0),
(4463, 0, 2232, 'Type here', 0),
(4464, 1, 2232, 'Type here', 0),
(4465, 0, 2233, 'Related solutions', 0),
(4466, 1, 2233, 'Related solutions', 0),
(4467, 0, 2234, 'Destination', 0),
(4468, 1, 2234, 'Destination', 0),
(4469, 0, 2235, 'Issue ID', 0),
(4470, 1, 2235, 'Issue ID', 0),
(4471, 0, 2236, 'Is migrated', 0),
(4472, 1, 2236, 'Is migrated', 0),
(4473, 0, 2237, 'Create issue with redmine', 0),
(4474, 1, 2237, 'Create issue with redmine', 0),
(4475, 0, 2238, 'Tracker', 0),
(4476, 1, 2238, 'Tracker', 0),
(4477, 0, 2239, 'Issue', 0),
(4478, 1, 2239, 'Issue', 0),
(4479, 0, 2240, 'Project name', 0),
(4480, 1, 2240, 'Project name', 0),
(4481, 0, 2241, 'Issue linked successfully', 0),
(4482, 1, 2241, 'Issue linked successfully', 0),
(4483, 0, 2242, 'Select issue', 0),
(4484, 1, 2242, 'Select issue', 0),
(4485, 0, 2243, 'Select tracker', 0),
(4486, 1, 2243, 'Select tracker', 0),
(4487, 0, 2244, 'View issue in redmine', 0),
(4488, 1, 2244, 'View issue in redmine', 0),
(4489, 0, 2245, 'Enabled', 0),
(4490, 1, 2245, 'Enabled', 0),
(4491, 0, 2246, 'Disabled', 0),
(4492, 1, 2246, 'Disabled', 0),
(4493, 0, 2247, 'Auto generate organization', 0),
(4494, 1, 2247, 'Auto generate organization', 0),
(4495, 0, 2248, 'Ignore organization (use comma to add multiple organization )', 0),
(4496, 1, 2248, 'Ignore organization (use comma to add multiple organization )', 0),
(4497, 0, 2249, 'Append incident post', 0),
(4498, 1, 2249, 'Append incident post', 0),
(4499, 0, 2250, 'Visible to left panel', 0),
(4500, 1, 2250, 'Visible to left panel', 0),
(4501, 0, 2251, 'Default', 0),
(4502, 1, 2251, 'Default', 0),
(4503, 0, 2252, 'Both incident creation', 0),
(4504, 1, 2252, 'Both incident creation', 0),
(4505, 0, 2253, 'Show online staff', 0),
(4506, 1, 2253, 'Show online staff', 0),
(4507, 0, 2254, 'Based on incident hash in subject line', 0),
(4508, 1, 2254, 'Based on incident hash in subject line', 0),
(4509, 0, 2255, 'Based on incident subject', 0),
(4510, 1, 2255, 'Based on incident subject', 0),
(4511, 0, 2256, 'Additional emails', 0),
(4512, 1, 2256, 'Additional emails', 0),
(4513, 0, 2257, 'Field can not be blank', 0),
(4514, 1, 2257, 'Field can not be blank', 0),
(4515, 0, 2258, 'Email already exists', 0),
(4516, 1, 2258, 'Email already exists', 0),
(4517, 0, 2259, 'Fax', 0),
(4518, 1, 2259, 'Fax', 0),
(4519, 0, 2260, 'Mobile number', 0),
(4520, 1, 2260, 'Mobile number', 0),
(4521, 0, 2261, 'Template', 0),
(4522, 1, 2261, 'Template', 0),
(4523, 0, 2262, 'On last activity', 0),
(4524, 1, 2262, 'On last activity', 0),
(4525, 0, 2263, 'SLA state', 0),
(4526, 1, 2263, 'SLA state', 0),
(4527, 1, 2264, 'Favicon', 0),
(4528, 0, 2264, 'Favicon', 0),
(4529, 1, 2265, 'Invalid characters', 0),
(4530, 0, 2265, 'Invalid characters', 0),
(4531, 1, 2266, 'Resend', 0),
(4532, 0, 2266, 'Resend', 0),
(4533, 1, 2267, 'Task list count', 0),
(4534, 0, 2267, 'Task list count', 0),
(4535, 1, 2268, 'Display amount on time track', 0),
(4536, 0, 2268, 'Display amount on time track', 0),
(4537, 1, 2269, 'Numeric value required for minutes field', 0),
(4538, 0, 2269, 'Numeric value required for minutes field', 0),
(4539, 1, 2270, 'Manager', 0),
(4540, 0, 2270, 'Manager', 0),
(4541, 0, 2271, 'Advanced search', 0),
(4542, 1, 2271, 'Advanced search', 0),
(4543, 0, 2272, 'Flag', 0),
(4544, 1, 2272, 'Flag', 0),
(4545, 0, 2273, 'Owner', 0),
(4546, 1, 2273, 'Owner', 0),
(4547, 0, 2274, 'Report', 0),
(4548, 1, 2274, 'Report', 0),
(4549, 0, 2275, 'Incident by status', 0),
(4550, 1, 2275, 'Incident by status', 0),
(4551, 0, 2276, 'Incidents by priority', 0),
(4552, 1, 2276, 'Incidents by priority', 0),
(4553, 0, 2277, 'Incident by type', 0),
(4554, 1, 2277, 'Incident by type', 0),
(4555, 0, 2278, 'Incident by owner', 0),
(4556, 1, 2278, 'Incident by owner', 0),
(4557, 0, 2279, 'Select duration', 0),
(4558, 1, 2279, 'Select duration', 0),
(4559, 0, 2280, 'Last 30 days', 0),
(4560, 1, 2280, 'Last 30 days', 0),
(4561, 0, 2281, 'Last 7 days', 0),
(4562, 1, 2281, 'Last 7 days', 0),
(4563, 0, 2282, 'Last 24 hours', 0),
(4564, 1, 2282, 'Last 24 hours', 0),
(4565, 0, 2283, 'Migrated from', 0),
(4566, 1, 2283, 'Migrated from', 0),
(4567, 0, 2284, 'On going audit', 0),
(4568, 1, 2284, 'On going audit', 0),
(4569, 0, 2285, 'Asset state wise summary', 0),
(4570, 1, 2285, 'Asset state wise summary', 0),
(4571, 0, 2286, 'New updates', 0),
(4572, 1, 2286, 'New updates', 0),
(4573, 0, 2287, 'Auto approve comments', 0),
(4574, 1, 2287, 'Auto approve comments', 0),
(4575, 1, 2288, 'Incident by organization', 0),
(4576, 0, 2288, 'Incident by organization', 0),
(4577, 1, 2289, 'Incident by client', 0),
(4578, 0, 2289, 'Incident by client', 0),
(4579, 0, 2290, 'Auto mapping of software-contract', 0),
(4580, 1, 2290, 'Auto mapping of software-contract', 0),
(4581, 1, 2291, 'view result', 0),
(4582, 0, 2291, 'view result', 0),
(4583, 1, 2292, 'Generate', 0),
(4584, 0, 2292, 'Generate', 0),
(4585, 1, 2293, 'Custom', 0),
(4586, 0, 2293, 'Custom', 0),
(4587, 0, 2294, 'Analysis', 0),
(4588, 1, 2294, 'Analysis', 0),
(4589, 0, 2295, 'Update Exotel App', 0),
(4590, 1, 2295, 'Update Exotel App', 0),
(4591, 0, 2296, 'Approval', 0),
(4592, 1, 2296, 'Approval', 0),
(4593, 0, 2297, 'Exophone required', 0),
(4594, 1, 2297, 'Exophone required', 0),
(4595, 0, 2298, 'Charter', 0),
(4596, 1, 2298, 'Charter', 0),
(4597, 0, 2299, 'Connect customer to agent', 0),
(4598, 1, 2299, 'Connect customer to agent', 0),
(4599, 0, 2300, 'Connect customer to flow', 0),
(4600, 1, 2300, 'Connect customer to flow', 0),
(4601, 0, 2301, 'Send bulk SMS', 0),
(4602, 1, 2301, 'Send bulk SMS', 0),
(4603, 0, 2302, 'Time limit', 0),
(4604, 1, 2302, 'Time limit', 0),
(4605, 0, 2303, 'Time out', 0),
(4606, 1, 2303, 'Time out', 0),
(4607, 0, 2304, 'Optional', 0),
(4608, 1, 2304, 'Optional', 0),
(4609, 0, 2305, 'Caller-id', 0),
(4610, 1, 2305, 'Caller-id', 0),
(4611, 0, 2306, 'Call type', 0),
(4612, 1, 2306, 'Call type', 0),
(4613, 0, 2307, 'Trans', 0),
(4614, 1, 2307, 'Trans', 0),
(4615, 0, 2308, 'Promo', 0),
(4616, 1, 2308, 'Promo', 0),
(4617, 0, 2309, 'Connect', 0),
(4618, 1, 2309, 'Connect', 0),
(4619, 0, 2310, 'Design', 0),
(4620, 1, 2310, 'Design', 0),
(4621, 0, 2311, 'Select caller-id', 0),
(4622, 1, 2311, 'Select caller-id', 0),
(4623, 0, 2312, 'Enter from number', 0),
(4624, 1, 2312, 'Enter from number', 0),
(4625, 0, 2313, 'Enter to number', 0),
(4626, 1, 2313, 'Enter to number', 0),
(4627, 0, 2314, 'Body', 0),
(4628, 1, 2314, 'Body', 0),
(4629, 0, 2315, 'Send SMS', 0),
(4630, 1, 2315, 'Send SMS', 0),
(4631, 0, 2316, 'Enter body', 0),
(4632, 1, 2316, 'Enter body', 0),
(4633, 0, 2317, 'Auto incident creation', 0),
(4634, 1, 2317, 'Auto incident creation', 0),
(4635, 0, 2318, 'End date', 0),
(4636, 1, 2318, 'End date', 0),
(4637, 0, 2319, 'Duration', 0),
(4638, 1, 2319, 'Duration', 0),
(4639, 0, 2320, 'Price', 0),
(4640, 1, 2320, 'Price', 0),
(4641, 0, 2321, 'Direction', 0),
(4642, 1, 2321, 'Direction', 0),
(4643, 0, 2322, 'Sent date', 0),
(4644, 1, 2322, 'Sent date', 0),
(4645, 0, 2323, 'Msg body', 0),
(4646, 1, 2323, 'Msg body', 0),
(4647, 0, 2324, 'SMS details', 0),
(4648, 1, 2324, 'SMS details', 0),
(4649, 0, 2325, 'Outward-call', 0),
(4650, 1, 2325, 'Outward-call', 0),
(4651, 0, 2326, 'Inward-call', 0),
(4652, 1, 2326, 'Inward-call', 0),
(4653, 0, 2327, 'Outward-msg', 0),
(4654, 1, 2327, 'Outward-msg', 0),
(4655, 0, 2328, 'Inward-msg', 0),
(4656, 1, 2328, 'Inward-msg', 0),
(4657, 0, 2329, 'Order report', 0),
(4658, 1, 2329, 'Order report', 0),
(4659, 0, 2330, 'Billing status', 0),
(4660, 1, 2330, 'Billing status', 0),
(4661, 0, 2331, 'Select status', 0),
(4662, 1, 2331, 'Select status', 0),
(4663, 0, 2332, 'Total invoices', 0),
(4664, 1, 2332, 'Total invoices', 0),
(4665, 0, 2333, 'Total paid', 0),
(4666, 1, 2333, 'Total paid', 0),
(4667, 0, 2334, 'Build', 0),
(4668, 1, 2334, 'Build', 0),
(4669, 0, 2335, 'Staff bonus point report', 0),
(4670, 1, 2335, 'Staff bonus point report', 0),
(4671, 0, 2336, 'Staff point report', 0),
(4672, 1, 2336, 'Staff point report', 0),
(4673, 0, 2337, 'Client transaction report', 0),
(4674, 1, 2337, 'Client transaction report', 0),
(4675, 0, 2338, 'Client wise order report', 0),
(4676, 1, 2338, 'Client wise order report', 0),
(4677, 0, 2339, 'Transaction report', 0),
(4678, 1, 2339, 'Transaction report', 0),
(4679, 0, 2340, 'First response time', 0),
(4680, 1, 2340, 'First response time', 0),
(4681, 0, 2341, 'Invoice report', 0),
(4682, 1, 2341, 'Invoice report', 0),
(4683, 0, 2342, 'Total incident', 0),
(4684, 1, 2342, 'Total incident', 0),
(4685, 0, 2343, 'Total open', 0),
(4686, 1, 2343, 'Total open', 0),
(4687, 0, 2344, 'Total close', 0),
(4688, 1, 2344, 'Total close', 0),
(4689, 0, 2345, 'Total in progress', 0),
(4690, 1, 2345, 'Total in progress', 0),
(4691, 0, 2346, 'Department name', 0),
(4692, 1, 2346, 'Department name', 0),
(4693, 0, 2347, 'Other than open and close', 0),
(4694, 1, 2347, 'Other than open and close', 0),
(4695, 0, 2348, 'Update custom report', 0),
(4696, 1, 2348, 'Update custom report', 0),
(4697, 0, 2349, 'Create custom report', 0),
(4698, 1, 2349, 'Create custom report', 0),
(4699, 0, 2350, 'View custom report', 0),
(4700, 1, 2350, 'View custom report', 0),
(4701, 0, 2351, 'Total response time', 0),
(4702, 1, 2351, 'Total response time', 0),
(4703, 0, 2352, 'Paid status', 0),
(4704, 1, 2352, 'Paid status', 0),
(4705, 0, 2353, 'Reference incident', 0),
(4706, 1, 2353, 'Reference incident', 0),
(4707, 0, 2354, 'Order id', 0),
(4708, 1, 2354, 'Order id', 0),
(4709, 0, 2355, 'Duration point', 0),
(4710, 1, 2355, 'Duration point', 0),
(4711, 0, 2356, 'Incidents grouped by channel', 0),
(4712, 1, 2356, 'Incidents grouped by channel', 0),
(4713, 0, 2357, 'Deleted incident', 0),
(4714, 1, 2357, 'Deleted incident', 0),
(4715, 0, 2358, 'Deleted date', 0),
(4716, 1, 2358, 'Deleted date', 0),
(4717, 0, 2359, 'Merged date', 0),
(4718, 1, 2359, 'Merged date', 0),
(4719, 0, 2360, 'Merged incidents', 0),
(4720, 1, 2360, 'Merged incidents', 0),
(4721, 0, 2361, 'Channel name', 0),
(4722, 1, 2361, 'Channel name', 0),
(4723, 0, 2362, 'Total number of incidents', 0),
(4724, 1, 2362, 'Total number of incidents', 0),
(4725, 0, 2363, 'Resolved date', 0),
(4726, 1, 2363, 'Resolved date', 0),
(4727, 0, 2364, 'Problems solved per staff', 0),
(4728, 1, 2364, 'Problems solved per staff', 0),
(4729, 0, 2365, 'Problem from', 0),
(4730, 1, 2365, 'Problem from', 0),
(4731, 0, 2366, 'Custom field report for user incident creation', 0),
(4732, 1, 2366, 'Custom field report for user incident creation', 0),
(4733, 0, 2367, 'Field value', 0),
(4734, 1, 2367, 'Field value', 0),
(4735, 0, 2368, 'Custom field report for user registration', 0),
(4736, 1, 2368, 'Custom field report for user registration', 0),
(4737, 0, 2369, 'Reply date', 0),
(4738, 1, 2369, 'Reply date', 0),
(4739, 0, 2370, 'Total point', 0),
(4740, 1, 2370, 'Total point', 0),
(4741, 0, 2371, 'Current rank', 0),
(4742, 1, 2371, 'Current rank', 0),
(4743, 0, 2372, 'Total unanswered incidents', 0),
(4744, 1, 2372, 'Total unanswered incidents', 0),
(4745, 0, 2373, 'Incident escalation group by staff', 0),
(4746, 1, 2373, 'Incident escalation group by staff', 0),
(4747, 0, 2374, 'Incident escalation group by department', 0),
(4748, 1, 2374, 'Incident escalation group by department', 0),
(4749, 0, 2375, 'Next assigned', 0),
(4750, 1, 2375, 'Next assigned', 0),
(4751, 0, 2376, 'Export type', 0),
(4752, 1, 2376, 'Export type', 0),
(4753, 0, 2377, 'Schedule report', 0),
(4754, 1, 2377, 'Schedule report', 0),
(4755, 0, 2378, 'Schedule type', 0),
(4756, 1, 2378, 'Schedule type', 0),
(4757, 0, 2379, 'Parent client should receive a copy of emails submitted by this contact', 0),
(4758, 1, 2379, 'Parent client should receive a copy of emails submitted by this contact', 0),
(4759, 0, 2380, 'Receive a copy of emails submitted by parent client and other contacts', 0),
(4760, 1, 2380, 'Receive a copy of emails submitted by parent client and other contacts', 0),
(4761, 0, 2381, 'Total incidents resolved', 0),
(4762, 1, 2381, 'Total incidents resolved', 0),
(4763, 0, 2382, 'Login activity', 0),
(4764, 1, 2382, 'Login activity', 0),
(4765, 0, 2383, 'Staff activities', 0),
(4766, 1, 2383, 'Staff activities', 0),
(4767, 0, 2384, 'Staff activity tracking', 0),
(4768, 1, 2384, 'Staff activity tracking', 0),
(4769, 0, 2385, 'Average response time group by staff', 0),
(4770, 1, 2385, 'Average response time group by staff', 0),
(4771, 0, 2386, 'Last replier time', 0),
(4772, 1, 2386, 'Last replier time', 0),
(4773, 0, 2387, 'Create new', 0),
(4774, 1, 2387, 'Create new', 0),
(4775, 0, 2388, 'Custom reports', 0),
(4776, 1, 2388, 'Custom reports', 0),
(4777, 0, 2389, 'Display count', 0),
(4778, 1, 2389, 'Display count', 0),
(4779, 0, 2390, 'CMDB created', 0),
(4780, 1, 2390, 'CMDB created', 0),
(4781, 0, 2391, 'Department set to', 0),
(4782, 1, 2391, 'Department set to', 0),
(4783, 0, 2392, 'CI type set to', 0),
(4784, 1, 2392, 'CI type set to', 0),
(4785, 0, 2393, 'Impact set to', 0),
(4786, 1, 2393, 'Impact set to', 0),
(4787, 0, 2394, 'Location set to', 0),
(4788, 1, 2394, 'Location set to', 0),
(4789, 0, 2395, 'set to', 0),
(4790, 1, 2395, 'set to', 0),
(4791, 0, 2396, 'CMDB updated', 0),
(4792, 1, 2396, 'CMDB updated', 0),
(4793, 0, 2397, 'Updated to', 0),
(4794, 1, 2397, 'Updated to', 0),
(4795, 0, 2398, 'Client with maximum incident', 0),
(4796, 1, 2398, 'Client with maximum incident', 0),
(4797, 0, 2399, 'Top', 0),
(4798, 1, 2399, 'Top', 0),
(4799, 0, 2400, 'Client with max incident reply', 0),
(4800, 1, 2400, 'Client with max incident reply', 0),
(4801, 0, 2401, 'Domain incident overview', 0),
(4802, 1, 2401, 'Domain incident overview', 0),
(4803, 0, 2402, 'Staff quest performer', 0),
(4804, 1, 2402, 'Staff quest performer', 0),
(4805, 0, 2403, 'Forum', 0),
(4806, 1, 2403, 'Forum', 0),
(4807, 0, 2404, 'Submit an incident', 0),
(4808, 1, 2404, 'Submit an incident', 0),
(4809, 0, 2405, 'Can''t find what you''re looking for? Let us help you', 0),
(4810, 1, 2405, 'Can''t find what you''re looking for? Let us help you', 0),
(4811, 0, 2406, 'Stride alert', 0),
(4812, 1, 2406, 'Stride alert', 0),
(4813, 0, 2407, 'Slack alert', 0),
(4814, 1, 2407, 'Slack alert', 0),
(4815, 0, 2408, 'Match found', 0),
(4816, 1, 2408, 'Match found', 0),
(4817, 0, 2409, 'Contact number already exists', 0),
(4818, 1, 2409, 'Contact number already exists', 0),
(4819, 0, 2410, 'Total client', 0),
(4820, 1, 2410, 'Total client', 0),
(4821, 0, 2411, 'Organization ID missing', 0),
(4822, 1, 2411, 'Organization ID missing', 0),
(4823, 0, 2412, 'Cases', 0),
(4824, 1, 2412, 'Cases', 0),
(4825, 0, 2413, 'Most commented article', 0),
(4826, 1, 2413, 'Most commented article', 0),
(4827, 0, 2414, 'Most viewed articles', 0),
(4828, 1, 2414, 'Most viewed articles', 0),
(4829, 0, 2415, 'Most rated articles', 0),
(4830, 1, 2415, 'Most rated articles', 0),
(4831, 0, 2416, 'Forms', 0),
(4832, 1, 2416, 'Forms', 0),
(4833, 0, 2417, 'Add form', 0),
(4834, 1, 2417, 'Add form', 0),
(4835, 0, 2418, 'Delete form group', 0),
(4836, 1, 2418, 'Delete form group', 0),
(4837, 0, 2419, 'Deletion of form group will delete form fields in this form group', 0),
(4838, 1, 2419, 'Deletion of form group will delete form fields in this form group', 0),
(4839, 0, 2420, 'Update form group', 0),
(4840, 1, 2420, 'Update form group', 0),
(4841, 0, 2421, 'Form fields', 0),
(4842, 1, 2421, 'Form fields', 0),
(4843, 0, 2422, 'Add form field', 0),
(4844, 1, 2422, 'Add form field', 0),
(4845, 0, 2423, 'Delete form field', 0),
(4846, 1, 2423, 'Delete form field', 0),
(4847, 0, 2424, 'Placeholder', 0),
(4848, 1, 2424, 'Placeholder', 0),
(4849, 0, 2425, 'Tooltip', 0),
(4850, 1, 2425, 'Tooltip', 0),
(4851, 0, 2426, 'Image', 0),
(4852, 1, 2426, 'Image', 0),
(4853, 0, 2427, 'Test', 0),
(4854, 1, 2427, 'Test', 0),
(4855, 0, 2428, 'HTML attribute', 0),
(4856, 1, 2428, 'HTML attribute', 0),
(4857, 0, 2429, 'Display title', 0),
(4858, 1, 2429, 'Display title', 0),
(4859, 0, 2430, 'Form type', 0),
(4860, 1, 2430, 'Form type', 0),
(4861, 0, 2431, 'Note: For email based form, three fields will be auto added to form (First name, Last name and Email)', 0),
(4862, 1, 2431, 'Note: For email based form, three fields will be auto added to form (First name, Last name and Email)', 0),
(4863, 0, 2432, 'Note: For call based form, three fields will be auto added to form (First name, Last name and Contact number)', 0),
(4864, 1, 2432, 'Note: For call based form, three fields will be auto added to form (First name, Last name and Contact number)', 0),
(4865, 0, 2433, 'Enable captcha', 0),
(4866, 1, 2433, 'Enable captcha', 0),
(4867, 0, 2434, 'Form URL', 0),
(4868, 1, 2434, 'Form URL', 0),
(4869, 0, 2435, 'Iframe URL', 0),
(4870, 1, 2435, 'Iframe URL', 0),
(4871, 0, 2436, 'Display in line', 0),
(4872, 1, 2436, 'Display in line', 0),
(4873, 1, 2437, 'Is editor', 0),
(4874, 0, 2437, 'Is editor', 0),
(4875, 0, 2438, 'No of attachments', 0),
(4876, 1, 2438, 'No of attachments', 0),
(4877, 0, 2439, 'Thank you ...!', 0),
(4878, 1, 2439, 'Thank you ...!', 0),
(4879, 0, 2440, 'Invalid email', 0),
(4880, 1, 2440, 'Invalid email', 0),
(4881, 0, 2441, 'Enter only numeric characters', 0),
(4882, 1, 2441, 'Enter only numeric characters', 0),
(4883, 0, 2442, 'Enter only alphabetics', 0),
(4884, 1, 2442, 'Enter only alphabetics', 0),
(4885, 0, 2443, 'Enter only alphanumeric characters', 0),
(4886, 1, 2443, 'Enter only alphanumeric characters', 0),
(4887, 0, 2444, 'Form name', 0),
(4888, 1, 2444, 'Form name', 0),
(4889, 0, 2445, 'Operational/live', 0),
(4890, 1, 2445, 'Operational/live', 0),
(4891, 0, 2446, 'Edit form field', 0),
(4892, 1, 2446, 'Edit form field', 0),
(4893, 0, 2447, 'Update form field', 0),
(4894, 1, 2447, 'Update form field', 0),
(4895, 0, 2448, 'Mail queue not exist', 0),
(4896, 1, 2448, 'Mail queue not exist', 0),
(4897, 0, 2449, 'Client email not verified ', 0),
(4898, 1, 2449, 'Client email not verified ', 0),
(4899, 0, 2450, 'Contact access', 0),
(4900, 1, 2450, 'Contact access', 0),
(4901, 0, 2451, 'Client registration error', 0),
(4902, 1, 2451, 'Client registration error', 0),
(4903, 0, 2452, 'Incident creation error', 0),
(4904, 1, 2452, 'Incident creation error', 0),
(4905, 0, 2453, 'Form not available..!', 0),
(4906, 1, 2453, 'Form not available..!', 0),
(4907, 0, 2454, 'Problems grouped by status', 0),
(4908, 1, 2454, 'Problems grouped by status', 0),
(4909, 0, 2455, 'Problems grouped by priority', 0),
(4910, 1, 2455, 'Problems grouped by priority', 0),
(4911, 0, 2456, 'Problems grouped by impact', 0),
(4912, 1, 2456, 'Problems grouped by impact', 0),
(4913, 0, 2457, 'Invoice hash', 0),
(4914, 1, 2457, 'Invoice hash', 0),
(4915, 0, 2458, 'Redirect to incident listing on reply', 0),
(4916, 1, 2458, 'Redirect to incident listing on reply', 0),
(4917, 0, 2459, 'Client missing or invalid client for merge', 0),
(4918, 1, 2459, 'Client missing or invalid client for merge', 0),
(4919, 0, 2460, 'Fields marked with <span class="vh-red">*</span> are mandatory', 0),
(4920, 1, 2460, 'Fields marked with <span class="vh-red">*</span> are mandatory', 0),
(4921, 0, 2461, 'Scheduled report', 0),
(4922, 1, 2461, 'Scheduled report', 0),
(4923, 0, 2462, 'Task email notification', 0),
(4924, 1, 2462, 'Task email notification', 0),
(4925, 0, 2463, 'Not started task', 0),
(4926, 1, 2463, 'Not started task', 0),
(4927, 0, 2464, 'Disable client portal', 0),
(4928, 1, 2464, 'Disable client portal', 0),
(4929, 0, 2465, 'Problems per department', 0),
(4930, 1, 2465, 'Problems per department', 0),
(4931, 0, 2466, 'Changes per domain', 0),
(4932, 1, 2466, 'Changes per domain', 0),
(4933, 0, 2467, 'Releases per department', 0),
(4934, 1, 2467, 'Releases per department', 0),
(4935, 0, 2468, 'SLA & escalation', 0),
(4936, 1, 2468, 'SLA & escalation', 0),
(4937, 0, 2469, 'Virtual agent and survey', 0),
(4938, 1, 2469, 'Virtual agent and survey', 0),
(4939, 0, 2470, 'Staff assigned tasks', 0),
(4940, 1, 2470, 'Staff assigned tasks', 0),
(4941, 0, 2471, 'Asset name', 0),
(4942, 1, 2471, 'Asset name', 0),
(4943, 0, 2472, 'Assets used by client', 0),
(4944, 1, 2472, 'Assets used by client', 0),
(4945, 0, 2473, 'Assets managed by staff', 0),
(4946, 1, 2473, 'Assets managed by staff', 0),
(4947, 0, 2474, 'Incident link report', 0),
(4948, 1, 2474, 'Incident link report', 0),
(4949, 0, 2475, 'Task comment report', 0),
(4950, 1, 2475, 'Task comment report', 0),
(4951, 0, 2476, 'Assets linked to incidents', 0),
(4952, 1, 2476, 'Assets linked to incidents', 0),
(4953, 0, 2477, 'Type to existing incident hash', 0),
(4954, 1, 2477, 'Type to existing incident hash', 0),
(4955, 0, 2478, 'Task linked', 0),
(4956, 1, 2478, 'Task linked', 0),
(4957, 0, 2479, 'CI linked', 0),
(4958, 1, 2479, 'CI linked', 0),
(4959, 0, 2480, 'Problem linked', 0),
(4960, 1, 2480, 'Problem linked', 0),
(4961, 0, 2481, 'Change linked', 0),
(4962, 1, 2481, 'change linked', 0),
(4963, 0, 2482, 'Releases linked to changes', 0),
(4964, 1, 2482, 'Releases linked to changes', 0),
(4965, 0, 2483, 'Changes resolved by staff', 0),
(4966, 1, 2483, 'Changes resolved by staff', 0),
(4967, 0, 2484, 'Total replied incident', 0),
(4968, 1, 2484, 'Total replied incident', 0),
(4969, 0, 2485, 'Close incident date', 0),
(4970, 1, 2485, 'Close incident date', 0),
(4971, 0, 2486, 'Mark read', 0),
(4972, 1, 2486, 'Mark read', 0),
(4973, 0, 2487, 'Mark unread', 0),
(4974, 1, 2487, 'Mark unread', 0),
(4975, 0, 2488, 'Retiring', 0),
(4976, 1, 2488, 'Retiring', 0),
(4977, 0, 2489, 'Department wise SLA', 0),
(4978, 1, 2489, 'Department wise SLA', 0),
(4979, 0, 2490, 'AVG. resolution time', 0),
(4980, 1, 2490, 'AVG. resolution time', 0),
(4981, 0, 2491, 'Staff work', 0),
(4982, 1, 2491, 'Staff work', 0),
(4983, 0, 2492, 'Staff AVG. response time', 0),
(4984, 1, 2492, 'Staff AVG. response time', 0),
(4985, 0, 2493, 'Quest top performer', 0),
(4986, 1, 2493, 'Quest top performer', 0),
(4987, 0, 2494, 'Billing summary', 0),
(4988, 1, 2494, 'Billing summary', 0),
(4989, 0, 2495, 'Retired', 0),
(4990, 1, 2495, 'Retired', 0),
(4991, 0, 2496, 'Lifecycle stage', 0),
(4992, 1, 2496, 'Lifecycle stage', 0),
(4993, 0, 2497, 'Guest email', 0),
(4994, 1, 2497, 'Guest email', 0),
(4995, 0, 2498, 'Add event', 0),
(4996, 1, 2498, 'Add event', 0),
(4997, 0, 2499, 'Event details', 0),
(4998, 1, 2499, 'Event details', 0),
(4999, 0, 2500, 'Task details', 0),
(5000, 1, 2500, 'Task details', 0),
(5001, 0, 2501, 'Task list', 0),
(5002, 1, 2501, 'Task list', 0),
(5003, 0, 2502, 'Events', 0),
(5004, 1, 2502, 'Events', 0),
(5005, 0, 2503, 'Client overview', 0),
(5006, 1, 2503, 'Client overview', 0),
(5007, 0, 2504, 'Client invoices', 0),
(5008, 1, 2504, 'Client invoices', 0),
(5009, 0, 2505, 'Total unpaid', 0),
(5010, 1, 2505, 'Total unpaid', 0),
(5011, 0, 2506, 'Total cancelled', 0),
(5012, 1, 2506, 'Total cancelled', 0),
(5013, 0, 2507, 'Total in process', 0),
(5014, 1, 2507, 'Total in process', 0),
(5015, 0, 2508, 'Incident by channel', 0),
(5016, 1, 2508, 'Incident by channel', 0),
(5017, 0, 2509, 'Queue summary', 0),
(5018, 1, 2509, 'Queue summary', 0),
(5019, 0, 2510, 'Total reports in queue', 0),
(5020, 1, 2510, 'Total reports in queue', 0),
(5021, 0, 2511, 'My reports in queue', 0),
(5022, 1, 2511, 'My reports in queue', 0),
(5023, 0, 2512, 'My completed reports', 0),
(5024, 1, 2512, 'My completed reports', 0),
(5025, 0, 2513, 'reports in queue', 0),
(5026, 1, 2513, 'reports in queue', 0),
(5027, 0, 2514, 'Start date not be less than today''s date', 0),
(5028, 1, 2514, 'Start date not be less than today''s date', 0),
(5029, 0, 2515, 'Modified date', 0),
(5030, 1, 2515, 'Modified date', 0),
(5031, 0, 2516, 'View', 0),
(5032, 1, 2516, 'View', 0),
(5033, 0, 2517, 'Staff leaderboard', 0),
(5034, 1, 2517, 'Staff leaderboard', 0),
(5035, 0, 2518, 'Solved incidents', 0),
(5036, 1, 2518, 'Solved incidents', 0),
(5037, 0, 2519, 'AVG. First reply time', 0),
(5038, 1, 2519, 'AVG. First reply time', 0),
(5039, 0, 2520, 'Network scan', 0),
(5040, 1, 2520, 'Network scan', 0),
(5041, 0, 2521, 'AVG. SLA maintain', 0),
(5042, 1, 2521, 'AVG. SLA maintain', 0),
(5043, 0, 2522, 'Create filter', 0),
(5044, 1, 2522, 'Create filter', 0),
(5045, 0, 2523, 'Submitted by', 0),
(5046, 1, 2523, 'Submitted by', 0),
(5047, 0, 2524, 'Type to search existing staffs email address', 0),
(5048, 1, 2524, 'Type to search existing staffs email address', 0),
(5049, 0, 2525, 'Resolved by', 0),
(5050, 1, 2525, 'Resolved by', 0),
(5051, 0, 2526, 'Add / Link software', 0),
(5052, 1, 2526, 'Add / Link software', 0),
(5053, 0, 2527, 'Was this article helpful?', 0),
(5054, 1, 2527, 'Was this article helpful?', 0),
(5055, 0, 2528, 'out of', 0),
(5056, 1, 2528, 'out of', 0),
(5057, 0, 2529, 'found this helpful', 0),
(5058, 1, 2529, 'found this helpful', 0),
(5059, 0, 2530, 'Article like', 0),
(5060, 1, 2530, 'Article like', 0),
(5061, 0, 2531, 'Client feedback', 0),
(5062, 1, 2531, 'Client feedback', 0),
(5063, 0, 2532, 'Organization name', 0),
(5064, 1, 2532, 'Organization name', 0),
(5065, 0, 2533, 'Contact number is missing or invalid format', 0),
(5066, 1, 2533, 'Contact number is missing or invalid format', 0),
(5067, 0, 2534, 'Account', 0),
(5068, 1, 2534, 'Account', 0),
(5069, 0, 2535, 'Harvest', 0),
(5070, 1, 2535, 'Harvest', 0),
(5071, 0, 2536, 'Create invoice with harvest', 0),
(5072, 1, 2536, 'Create invoice with harvest', 0),
(5073, 0, 2537, 'Issue date', 0),
(5074, 1, 2537, 'Issue date', 0),
(5075, 0, 2538, 'User', 0),
(5076, 1, 2538, 'User', 0),
(5077, 0, 2539, 'Select top for generate', 0),
(5078, 1, 2539, 'Select top for generate', 0),
(5079, 0, 2540, 'Select all read', 0),
(5080, 1, 2540, 'Select all read', 0),
(5081, 0, 2541, 'Select all unread', 0),
(5082, 1, 2541, 'Select all unread', 0),
(5083, 0, 2542, 'File does not exist.', 0),
(5084, 1, 2542, 'File does not exist.', 0),
(5085, 0, 2543, 'Select field for generate', 0),
(5086, 1, 2543, 'Select field for generate', 0),
(5087, 0, 2544, 'Add / Update attribute', 0),
(5088, 1, 2544, 'Add / Update attribute', 0),
(5089, 0, 2545, 'Incident replied by staff report', 0),
(5090, 1, 2545, 'Incident replied by staff report', 0),
(5091, 0, 2546, 'Incident forwarded by staff report', 0),
(5092, 1, 2546, 'Incident forwarded by staff report', 0),
(5093, 0, 2547, 'Forward count', 0),
(5094, 1, 2547, 'Forward count', 0),
(5095, 0, 2548, 'Add incident read entry to audit log', 0),
(5096, 1, 2548, 'Add incident read entry to audit log', 0),
(5097, 0, 2549, 'Incident read', 0),
(5098, 1, 2549, 'Incident read', 0),
(5099, 0, 2550, 'Incident viewed by staff report', 0),
(5100, 1, 2550, 'Incident viewed by staff report', 0),
(5101, 0, 2551, 'Assets linked to problems', 0),
(5102, 1, 2551, 'Assets linked to problems', 0),
(5103, 0, 2552, 'Assets group by status', 0),
(5104, 1, 2552, 'Assets group by status', 0),
(5105, 0, 2553, 'Not expired', 0),
(5106, 1, 2553, 'Not expired', 0),
(5107, 0, 2554, 'Assets by location', 0),
(5108, 1, 2554, 'Assets by location', 0),
(5109, 0, 2555, 'Task by status', 0),
(5110, 1, 2555, 'Task by status', 0),
(5111, 0, 2556, 'Assets by asset type', 0),
(5112, 1, 2556, 'Assets by asset type', 0),
(5113, 0, 2557, 'Assets by asset product', 0),
(5114, 1, 2557, 'Assets by asset product', 0),
(5115, 0, 2558, 'Hardware assets by state', 0),
(5116, 1, 2558, 'Hardware assets by state', 0),
(5117, 0, 2559, 'Assets by depreciation', 0),
(5118, 1, 2559, 'Assets by depreciation', 0),
(5119, 0, 2560, 'Relationship management', 0),
(5120, 1, 2560, 'Relationship management', 0),
(5121, 0, 2561, 'Assets depreciation notification', 0),
(5122, 1, 2561, 'Assets depreciation notification', 0),
(5123, 0, 2562, 'Remaining warranty', 0),
(5124, 1, 2562, 'Remaining warranty', 0),
(5125, 0, 2563, 'Show', 0),
(5126, 1, 2563, 'Show', 0),
(5127, 0, 2564, 'Unassigned incidents', 0),
(5128, 1, 2564, 'Unassigned incidents', 0),
(5129, 0, 2565, 'Multiple assigned incidents', 0),
(5130, 1, 2565, 'Multiple assigned incidents', 0),
(5131, 0, 2566, 'More than', 0),
(5132, 1, 2566, 'More than', 0),
(5133, 0, 2567, 'Select team', 0),
(5134, 1, 2567, 'Select team', 0),
(5135, 0, 2568, 'Send incident approval', 0),
(5136, 1, 2568, 'Send incident approval', 0),
(5137, 0, 2569, 'Change incident approve status', 0),
(5138, 1, 2569, 'Change incident approve status', 0),
(5139, 0, 2570, 'Send incident approval reminder', 0),
(5140, 1, 2570, 'Send incident approval reminder', 0),
(5141, 0, 2571, 'Portal URL', 0),
(5142, 1, 2571, 'Portal URL', 0),
(5143, 0, 2572, 'Create contacts in Vtiger', 0),
(5144, 1, 2572, 'Create contacts in Vtiger', 0),
(5145, 0, 2573, 'Round robin', 0),
(5146, 1, 2573, 'Round robin', 0),
(5147, 0, 2574, 'Add round robin', 0),
(5148, 1, 2574, 'Add round robin', 0),
(5149, 0, 2575, 'Update round robin', 0),
(5150, 1, 2575, 'Update round robin', 0),
(5151, 0, 2576, 'Delete round robin', 0),
(5152, 1, 2576, 'Delete round robin', 0),
(5153, 0, 2577, 'Escalation rule', 0),
(5154, 1, 2577, 'Escalation rule', 0),
(5155, 0, 2578, 'If a incident remains un-assigned for more than:', 0),
(5156, 1, 2578, 'If a incident remains un-assigned for more than:', 0),
(5157, 0, 2579, 'Send escalation email', 0),
(5158, 1, 2579, 'Send escalation email', 0),
(5159, 0, 2580, 'Round robin assign', 0),
(5160, 1, 2580, 'Round robin assign', 0),
(5161, 0, 2581, 'Round robin participants', 0),
(5162, 1, 2581, 'Round robin participants', 0),
(5163, 0, 2582, 'View round robin participants', 0),
(5164, 1, 2582, 'View round robin participants', 0),
(5165, 0, 2583, 'Accepting', 0),
(5166, 1, 2583, 'Accepting', 0),
(5167, 0, 2584, 'Not accepting', 0),
(5168, 1, 2584, 'Not accepting', 0),
(5169, 0, 2585, 'Incident assignment', 0),
(5170, 1, 2585, 'Incident assignment', 0),
(5171, 0, 2586, 'Voice mail', 0),
(5172, 1, 2586, 'Voice mail', 0),
(5173, 0, 2587, 'Single sign on', 0),
(5174, 1, 2587, 'Single sign on', 0),
(5175, 0, 2588, 'Return to URL', 0),
(5176, 1, 2588, 'Return to URL', 0),
(5177, 0, 2589, 'Remote logout URL', 0),
(5178, 1, 2589, 'Remote logout URL', 0),
(5179, 0, 2590, 'SSO type', 0),
(5180, 1, 2590, 'SSO type', 0),
(5181, 1, 2591, 'Assets used by guest', 0),
(5182, 0, 2591, 'Assets used by guest', 0),
(5183, 0, 2592, 'Certificate fingerprint', 0),
(5184, 1, 2592, 'Certificate fingerprint', 0),
(5185, 0, 2593, 'Contact', 0),
(5186, 1, 2593, 'Contact', 0),
(5187, 0, 2594, 'Create incident with vtiger', 0),
(5188, 1, 2594, 'Create incident with vtiger', 0),
(5189, 0, 2595, 'Enable twilio messaging', 0),
(5190, 1, 2595, 'Enable twilio messaging', 0),
(5191, 0, 2596, 'Required twilio configuration - Settings / Integrations / Twilio', 0),
(5192, 1, 2596, 'Required twilio configuration - Settings / Integrations / Twilio', 0),
(5193, 0, 2597, 'Create opportunities', 0),
(5194, 1, 2597, 'Create opportunities', 0),
(5195, 0, 2598, 'Sales stage', 0),
(5196, 1, 2598, 'Sales stage', 0),
(5197, 0, 2599, 'Staff can decide self round robin participation', 0),
(5198, 1, 2599, 'Staff can decide self round robin participation', 0),
(5199, 0, 2600, 'My drive', 0),
(5200, 1, 2600, 'My drive', 0),
(5201, 0, 2601, 'Drive list count', 0),
(5202, 1, 2601, 'Drive list count', 0),
(5203, 0, 2602, 'Incident attachments', 0),
(5204, 1, 2602, 'Incident attachments', 0),
(5205, 0, 2603, 'Enter staff''s email', 0),
(5206, 1, 2603, 'Enter staff''s email', 0),
(5207, 1, 2604, 'Assets expiry report', 0),
(5208, 0, 2604, 'Assets expiry report', 0),
(5209, 0, 2605, 'Total open incident', 0),
(5210, 1, 2605, 'Total open incident', 0),
(5211, 0, 2606, 'Incident view date', 0),
(5212, 1, 2606, 'Incident view date', 0),
(5213, 0, 2607, 'Please enter minimum 4 characters', 0),
(5214, 1, 2607, 'Please enter minimum 4 characters', 0),
(5215, 0, 2608, 'Hardware', 0),
(5216, 1, 2608, 'Hardware', 0),
(5217, 0, 2609, 'Software', 0);
INSERT INTO `avis_language_values` VALUES
(5218, 1, 2609, 'Software', 0),
(5219, 0, 2610, 'Organization wise invoice report', 0),
(5220, 1, 2610, 'Organization wise invoice report', 0),
(5221, 0, 2611, 'Modified incident custom fields data', 0),
(5222, 1, 2611, 'Modified incident custom fields data', 0),
(5223, 0, 2612, 'Day', 0),
(5224, 1, 2612, 'Day', 0),
(5225, 0, 2613, 'Days', 0),
(5226, 1, 2613, 'Days', 0),
(5227, 0, 2614, 'Hour', 0),
(5228, 1, 2614, 'Hour', 0),
(5229, 0, 2615, 'Hours', 0),
(5230, 1, 2615, 'Hours', 0),
(5231, 0, 2616, 'Total undue incident report', 0),
(5232, 1, 2616, 'Total undue incident report', 0),
(5233, 0, 2617, 'Search clients', 0),
(5234, 1, 2617, 'Search clients', 0),
(5235, 0, 2618, 'Incident CI relation', 0),
(5236, 1, 2618, 'Incident CI relation', 0),
(5237, 0, 2619, 'Problem CI relation', 0),
(5238, 1, 2619, 'Problem CI relation', 0),
(5239, 0, 2620, 'Changes CI relation', 0),
(5240, 1, 2620, 'Changes CI relation', 0),
(5241, 0, 2621, 'Tenant', 0),
(5242, 1, 2621, 'Tenant', 0),
(5243, 0, 2622, 'Clients by organization', 0),
(5244, 1, 2622, 'Clients by organization', 0),
(5245, 0, 2623, 'Helpdesk form header', 0),
(5246, 1, 2623, 'Helpdesk form header', 0),
(5247, 0, 2624, 'Incidents by label', 0),
(5248, 1, 2624, 'Incidents by label', 0),
(5249, 0, 2625, 'Staff leaderboard first AVG. response report', 0),
(5250, 1, 2625, 'Staff leaderboard first AVG. response report', 0),
(5251, 0, 2626, 'Staff leaderboard AVG. response report', 0),
(5252, 1, 2626, 'Staff leaderboard AVG. response report', 0),
(5253, 0, 2627, 'Staff leaderboard AVG. SLA maintain report', 0),
(5254, 1, 2627, 'Staff leaderboard AVG. SLA maintain report', 0),
(5255, 0, 2628, 'To add form fields you require minimum one form field group', 0),
(5256, 1, 2628, 'To add form fields you require minimum one form field group', 0),
(5257, 0, 2629, 'Activity for incidents by department', 0),
(5258, 1, 2629, 'Activity for incidents by department', 0),
(5259, 0, 2630, 'Search drive', 0),
(5260, 1, 2630, 'Search drive', 0),
(5261, 0, 2631, 'Upload', 0),
(5262, 1, 2631, 'Upload', 0),
(5263, 1, 2632, 'Assets by asset state', 0),
(5264, 0, 2632, 'Assets by asset state', 0),
(5265, 1, 2633, 'Assets by manufacturer', 0),
(5266, 0, 2633, 'Assets by manufacturer', 0),
(5267, 1, 2634, 'Assets by asset department', 0),
(5268, 0, 2634, 'Assets by asset department', 0),
(5269, 1, 2635, 'Asset baseline report', 0),
(5270, 0, 2635, 'Asset baseline report', 0),
(5271, 0, 2636, 'All files', 0),
(5272, 1, 2636, 'All files', 0),
(5273, 0, 2637, 'My files', 0),
(5274, 1, 2637, 'My files', 0),
(5275, 1, 2638, 'Asset cost report', 0),
(5276, 0, 2638, 'Asset cost report', 0),
(5277, 0, 2639, 'New incident created', 0),
(5278, 1, 2639, 'New incident created', 0),
(5279, 0, 2640, 'Status changed', 0),
(5280, 1, 2640, 'Status changed', 0),
(5281, 0, 2641, 'Priority changed', 0),
(5282, 1, 2641, 'Priority changed', 0),
(5283, 0, 2642, 'Domain list must not contain space', 0),
(5284, 1, 2642, 'Domain list must not contain space', 0),
(5285, 0, 2643, 'Domain list must not contain @', 0),
(5286, 1, 2643, 'Domain list must not contain @', 0),
(5287, 0, 2644, 'Domain list must not contain #', 0),
(5288, 1, 2644, 'Domain list must not contain #', 0),
(5289, 0, 2645, 'Specific', 0),
(5290, 1, 2645, 'Specific', 0),
(5291, 0, 2646, 'Manage round robin participants', 0),
(5292, 1, 2646, 'Manage round robin participants', 0),
(5293, 0, 2647, 'Max contact number length should be 20', 0),
(5294, 1, 2647, 'Max contact number length should be 20', 0),
(5295, 0, 2648, 'Domain list', 0),
(5296, 1, 2648, 'Domain list', 0),
(5297, 0, 2649, 'Comment date', 0),
(5298, 1, 2649, 'Comment date', 0),
(5299, 0, 2650, 'Bill time should be numeric', 0),
(5300, 1, 2650, 'Bill time should be numeric', 0),
(5301, 0, 2651, 'Work time should be numeric', 0),
(5302, 1, 2651, 'Work time should be numeric', 0),
(5303, 0, 2652, 'Database host', 0),
(5304, 1, 2652, 'Database host', 0),
(5305, 0, 2653, 'Database user', 0),
(5306, 1, 2653, 'Database user', 0),
(5307, 0, 2654, 'Database  password', 0),
(5308, 1, 2654, 'Database  password', 0),
(5309, 0, 2655, 'Database name', 0),
(5310, 1, 2655, 'Database name', 0),
(5311, 0, 2656, 'Asterisk configuration', 0),
(5312, 1, 2656, 'Asterisk configuration', 0),
(5313, 0, 2657, 'Asterisk databade configuration', 0),
(5314, 1, 2657, 'Asterisk databade configuration', 0),
(5315, 0, 2658, 'Connection timeout', 0),
(5316, 1, 2658, 'Connection timeout', 0),
(5317, 0, 2659, 'Read timeout', 0),
(5318, 1, 2659, 'Read timeout', 0),
(5319, 0, 2660, 'Calldate', 0),
(5320, 1, 2660, 'Calldate', 0),
(5321, 1, 2661, 'Migrated asset report', 0),
(5322, 0, 2661, 'Migrated asset report', 0),
(5323, 1, 2662, 'Assets by unauthorized changes', 0),
(5324, 0, 2662, 'Assets by unauthorized changes', 0),
(5325, 0, 2663, 'Service item wise report', 0),
(5326, 1, 2663, 'Service item wise report', 0),
(5327, 0, 2664, 'Dcontext', 0),
(5328, 1, 2664, 'Dcontext', 0),
(5329, 0, 2665, 'I have agreed with', 0),
(5330, 1, 2665, 'I have agreed with', 0),
(5331, 0, 2666, 'Lastapp', 0),
(5332, 1, 2666, 'Lastapp', 0),
(5333, 0, 2667, 'Lastdata', 0),
(5334, 1, 2667, 'Lastdata', 0),
(5335, 0, 2668, 'Billsec', 0),
(5336, 1, 2668, 'Billsec', 0),
(5337, 0, 2669, 'Disposition', 0),
(5338, 1, 2669, 'Disposition', 0),
(5339, 0, 2670, 'Amaflags', 0),
(5340, 1, 2670, 'Amaflags', 0),
(5341, 0, 2671, 'Accountcode', 0),
(5342, 1, 2671, 'Accountcode', 0),
(5343, 0, 2672, 'Please sign in to leave a comment', 0),
(5344, 1, 2672, 'Please sign in to leave a comment', 0),
(5345, 0, 2673, 'Userfield', 0),
(5346, 1, 2673, 'Userfield', 0),
(5347, 0, 2674, 'Recording file', 0),
(5348, 1, 2674, 'Recording file', 0),
(5349, 0, 2675, 'Replies to this post', 0),
(5350, 1, 2675, 'Replies to this post', 0),
(5351, 0, 2676, 'Say something', 0),
(5352, 1, 2676, 'Say something', 0),
(5353, 0, 2677, 'Outbound_cnum', 0),
(5354, 1, 2677, 'Outbound_cnum', 0),
(5355, 0, 2678, 'Outbound_cnam', 0),
(5356, 1, 2678, 'Outbound_cnam', 0),
(5357, 0, 2679, 'Sub category', 0),
(5358, 1, 2679, 'Sub category', 0),
(5359, 0, 2680, 'Type your message', 0),
(5360, 1, 2680, 'Type your message', 0),
(5361, 0, 2681, 'Linked ID', 0),
(5362, 1, 2681, 'Linked ID', 0),
(5363, 0, 2682, 'Recording path', 0),
(5364, 1, 2682, 'Recording path', 0),
(5365, 0, 2683, 'Asterisk dial plans', 0),
(5366, 1, 2683, 'Asterisk dial plans', 0),
(5367, 0, 2684, 'Add dialplan', 0),
(5368, 1, 2684, 'Add dialplan', 0),
(5369, 0, 2685, 'Assets will not get added for existing barcode', 0),
(5370, 1, 2685, 'Assets will not get added for existing barcode', 0),
(5371, 0, 2686, 'Async', 0),
(5372, 1, 2686, 'Async', 0),
(5373, 0, 2687, 'Required field', 0),
(5374, 1, 2687, 'Required field', 0),
(5375, 0, 2688, 'Call us', 0),
(5376, 1, 2688, 'Call us', 0),
(5377, 0, 2689, 'Task linked to incidents', 0),
(5378, 1, 2689, 'Task linked to incidents', 0),
(5379, 0, 2690, 'URL already exist. Enter unique URL', 0),
(5380, 1, 2690, 'URL already exist. Enter unique URL', 0),
(5381, 0, 2691, 'Non IT', 0),
(5382, 1, 2691, 'Non IT', 0),
(5383, 0, 2692, 'Note: The data after archive cannot be modified. You need to restore it back to make modifications.', 0),
(5384, 1, 2692, 'Note: The data after archive cannot be modified. You need to restore it back to make modifications.', 0),
(5385, 0, 2693, 'CI attached', 0),
(5386, 1, 2693, 'CI attached', 0),
(5387, 0, 2694, 'Size', 0),
(5388, 1, 2694, 'Size', 0),
(5389, 0, 2695, 'Delete file', 0),
(5390, 1, 2695, 'Delete file', 0),
(5391, 0, 2696, 'Authenticate', 0),
(5392, 1, 2696, 'Authenticate', 0),
(5393, 0, 2697, 'Of', 0),
(5394, 1, 2697, 'Of', 0),
(5395, 0, 2698, 'Operation can not be perform,ip is restricted', 0),
(5396, 1, 2698, 'Operation can not be perform,ip is restricted', 0),
(5397, 0, 2699, 'Operation can not be perform,staff is ip banned', 0),
(5398, 1, 2699, 'Operation can not be perform,staff is ip banned', 0),
(5399, 0, 2700, 'Other Information', 0),
(5400, 1, 2700, 'Other Information', 0),
(5401, 0, 2701, 'Parser log details', 0),
(5402, 1, 2701, 'Parser log details', 0),
(5403, 0, 2702, 'Tax enabled', 0),
(5404, 1, 2702, 'Tax enabled', 0),
(5405, 0, 2703, 'Compound tax', 0),
(5406, 1, 2703, 'Compound tax', 0),
(5407, 0, 2704, 'Tax rule settings', 0),
(5408, 1, 2704, 'Tax rule settings', 0),
(5409, 0, 2705, 'Room', 0),
(5410, 1, 2705, 'Room', 0),
(5411, 0, 2706, 'Sent notification', 0),
(5412, 1, 2706, 'Sent notification', 0),
(5413, 0, 2707, 'CI type', 0),
(5414, 1, 2707, 'CI type', 0),
(5415, 0, 2708, 'Select CI', 0),
(5416, 1, 2708, 'Select CI', 0),
(5417, 0, 2709, 'Merge invoice', 0),
(5418, 1, 2709, 'Merge invoice', 0),
(5419, 0, 2710, 'Merge time tracking entries', 0),
(5420, 1, 2710, 'Merge time tracking entries', 0),
(5421, 0, 2711, 'Merge notes', 0),
(5422, 1, 2711, 'Merge notes', 0),
(5423, 0, 2712, 'Merge comments', 0),
(5424, 1, 2712, 'Merge comments', 0),
(5425, 0, 2713, 'Select atleast one merge option', 0),
(5426, 1, 2713, 'Select atleast one merge option', 0),
(5427, 0, 2714, 'Update CI custom field', 1),
(5428, 1, 2714, 'Update CI custom field', 1),
(5429, 0, 2715, 'R to L', 0),
(5430, 1, 2715, 'R to L', 0),
(5431, 0, 2716, 'Add CI custom field', 1),
(5432, 1, 2716, 'Add CI custom field', 1),
(5433, 0, 2717, 'On reply auto incident lock and unlock', 1),
(5434, 1, 2717, 'On reply auto incident lock and unlock', 1),
(5435, 0, 2718, 'Please select at least one team or one staff.', 1),
(5436, 1, 2718, 'Please select at least one team or one staff.', 1),
(5437, 0, 2719, 'Merge post', 1),
(5438, 1, 2719, 'Merge post', 1),
(5439, 0, 2720, 'Status change report', 1),
(5440, 1, 2720, 'Status change report', 1),
(5441, 0, 2721, 'Custom field report for staff incident creation', 1),
(5442, 1, 2721, 'Custom field report for staff incident creation', 1),
(5443, 0, 2722, 'Required at least one CI custom field', 1),
(5444, 1, 2722, 'Required at least one CI custom field', 1),
(5445, 0, 2723, 'Custom field report for organization registration', 1),
(5446, 1, 2723, 'Custom field report for organization registration', 1),
(5447, 0, 2724, 'Invalid asset name', 0),
(5448, 1, 2724, 'Invalid asset name', 0),
(5449, 0, 2725, 'Implemented', 0),
(5450, 1, 2725, 'Implemented', 0),
(5451, 0, 2726, 'Deferred', 0),
(5452, 1, 2726, 'Deferred', 0),
(5453, 0, 2727, 'Contact name', 0),
(5454, 1, 2727, 'Contact name', 0),
(5455, 0, 2728, 'Street', 0),
(5456, 1, 2728, 'Street', 0),
(5457, 0, 2729, 'Postal', 0),
(5458, 1, 2729, 'Postal', 0),
(5459, 0, 2730, 'Skype name', 0),
(5460, 1, 2730, 'Skype name', 0),
(5461, 0, 2731, 'Number', 0),
(5462, 1, 2731, 'Number', 0),
(5463, 0, 2732, 'Ref', 0),
(5464, 1, 2732, 'Ref', 0),
(5465, 0, 2733, 'Direct', 0),
(5466, 1, 2733, 'Direct', 0),
(5467, 0, 2734, 'Region', 0),
(5468, 1, 2734, 'Region', 0),
(5469, 0, 2735, 'Total incident closed by staff', 0),
(5470, 1, 2735, 'Total incident closed by staff', 0),
(5471, 0, 2736, 'Flagged incidents', 0),
(5472, 1, 2736, 'Flagged incidents', 0),
(5473, 0, 2737, 'Select flag', 0),
(5474, 1, 2737, 'Select flag', 0),
(5475, 0, 2738, 'All flag', 0),
(5476, 1, 2738, 'All flag', 0),
(5477, 0, 2739, 'Add organization', 0),
(5478, 1, 2739, 'Add organization', 0),
(5479, 0, 2740, 'Edit organization', 0),
(5480, 1, 2740, 'Edit organization', 0),
(5481, 0, 2741, 'Delete organization', 0),
(5482, 1, 2741, 'Delete organization', 0),
(5483, 0, 2742, 'Assets', 0),
(5484, 1, 2742, 'Assets', 0),
(5485, 0, 2743, 'Name', 1),
(5486, 1, 2743, 'Name', 1),
(5487, 0, 2744, 'Impact', 1),
(5488, 1, 2744, 'Impact', 1),
(5489, 0, 2745, 'Assigned on', 1),
(5490, 1, 2745, 'Assigned on', 1),
(5491, 0, 2746, 'Expired', 1),
(5492, 1, 2746, 'Expired', 1),
(5493, 0, 2747, 'Used by', 1),
(5494, 1, 2747, 'Used by', 1),
(5495, 0, 2748, 'Managed by', 1),
(5496, 1, 2748, 'Managed by', 1),
(5497, 0, 2749, 'Salvage', 1),
(5498, 1, 2749, 'Salvage', 1),
(5499, 0, 2750, 'Depreciation type', 1),
(5500, 1, 2750, 'Depreciation type', 1),
(5501, 0, 2751, 'Useful life (in years)', 1),
(5502, 1, 2751, 'Useful life (in years)', 1),
(5503, 0, 2752, 'Product', 1),
(5504, 1, 2752, 'Product', 1),
(5505, 0, 2753, 'Manufacturer', 1),
(5506, 1, 2753, 'Manufacturer', 1),
(5507, 0, 2754, 'Warranty year', 1),
(5508, 1, 2754, 'Warranty year', 1),
(5509, 0, 2755, 'Warranty month', 1),
(5510, 1, 2755, 'Warranty month', 1),
(5511, 0, 2756, 'Asset tag', 1),
(5512, 1, 2756, 'Asset tag', 1),
(5513, 0, 2757, 'Last audit date', 1),
(5514, 1, 2757, 'Last audit date', 1),
(5515, 0, 2758, 'Installation path', 1),
(5516, 1, 2758, 'Installation path', 1),
(5517, 0, 2759, 'License key', 1),
(5518, 1, 2759, 'License key', 1),
(5519, 0, 2760, 'License expiry date', 1),
(5520, 1, 2760, 'License expiry date', 1),
(5521, 0, 2761, 'Installation date', 1),
(5522, 1, 2761, 'Installation date', 1),
(5523, 0, 2762, 'Task automation', 1),
(5524, 1, 2762, 'Task automation', 1),
(5525, 0, 2763, 'Fetch all ( self+client ) post', 0),
(5526, 1, 2763, 'Fetch all ( self+client ) post', 0),
(5527, 0, 2764, 'First page', 0),
(5528, 1, 2764, 'First page', 0),
(5529, 0, 2765, 'Last page', 0),
(5530, 1, 2765, 'Last page', 0),
(5531, 0, 2766, 'View article', 0),
(5532, 1, 2766, 'View article', 0),
(5533, 0, 2767, 'Add userlike', 0),
(5534, 1, 2767, 'Add userlike', 0),
(5535, 0, 2768, 'Update userlike', 0),
(5536, 1, 2768, 'Update userlike', 0),
(5537, 0, 2769, 'View comments', 0),
(5538, 1, 2769, 'View comments', 0),
(5539, 0, 2770, 'Manage comments', 0),
(5540, 1, 2770, 'Manage comments', 0),
(5541, 0, 2771, 'Manage macros', 0),
(5542, 1, 2771, 'Manage macros', 0),
(5543, 0, 2772, 'Manage schedule incident', 0),
(5544, 1, 2772, 'Manage schedule incident', 0),
(5545, 0, 2773, 'View alerts', 0),
(5546, 1, 2773, 'View alerts', 0),
(5547, 0, 2774, 'Manage views', 0),
(5548, 1, 2774, 'Manage views', 0),
(5549, 0, 2775, 'Module enabled', 0),
(5550, 1, 2775, 'Module enabled', 0),
(5551, 0, 2776, 'Start timer', 0),
(5552, 1, 2776, 'Start timer', 0),
(5553, 0, 2777, 'Conversation', 0),
(5554, 1, 2777, 'Conversation', 0),
(5555, 0, 2778, 'Approval request', 0),
(5556, 1, 2778, 'Approval request', 0),
(5557, 0, 2779, 'Modify properties', 0),
(5558, 1, 2779, 'Modify properties', 0),
(5559, 0, 2780, 'Integration title', 0),
(5560, 1, 2780, 'Integration title', 0),
(5561, 0, 2781, 'Total requests', 0),
(5562, 1, 2781, 'Total requests', 0),
(5563, 0, 2782, 'request send on', 0),
(5564, 1, 2782, 'request send on', 0),
(5565, 0, 2783, 'Start time(Creation time + Below time)', 0),
(5566, 1, 2783, 'Start time(Creation time + Below time)', 0),
(5567, 0, 2784, 'End time(Start time + Below time)', 0),
(5568, 1, 2784, 'End time(Start time + Below time)', 0),
(5569, 1, 2785, 'Hours numeric', 0),
(5570, 0, 2785, 'Hours numeric', 0),
(5571, 1, 2786, 'Days numeric', 0),
(5572, 0, 2786, 'Days numeric', 0),
(5573, 1, 2787, 'Channel changed from', 0),
(5574, 0, 2787, 'Channel changed from', 0),
(5575, 1, 2788, 'Due time', 0),
(5576, 0, 2788, 'Due time', 0),
(5577, 1, 2789, 'Recursive task title', 0),
(5578, 0, 2789, 'Recursive task title', 0),
(5579, 1, 2790, 'Task updated', 0),
(5580, 0, 2790, 'Task updated', 0),
(5581, 1, 2791, 'Task created', 0),
(5582, 0, 2791, 'Task created', 0),
(5583, 1, 2792, 'Schedule updated', 0),
(5584, 0, 2792, 'Schedule updated', 0),
(5585, 1, 2793, 'Task unassigned from', 0),
(5586, 0, 2793, 'Task unassigned from', 0),
(5587, 1, 2794, 'Task assigned to', 0),
(5588, 0, 2794, 'Task assigned to', 0),
(5589, 1, 2795, 'Added to favorite', 0),
(5590, 0, 2795, 'Added to favorite', 0),
(5591, 1, 2796, 'Removed from favorite', 0),
(5592, 0, 2796, 'Removed from favorite', 0),
(5593, 1, 2797, 'Task description updated', 0),
(5594, 0, 2797, 'Task description updated', 0),
(5595, 1, 2798, 'New occurance created', 0),
(5596, 0, 2798, 'New occurance created', 0),
(5597, 1, 2799, 'Task comment added', 0),
(5598, 0, 2799, 'Task comment added', 0),
(5599, 1, 2800, 'Occurance deleted', 0),
(5600, 0, 2800, 'Occurance deleted', 0),
(5601, 1, 2801, 'Sub task deleted', 0),
(5602, 0, 2801, 'Sub task deleted', 0),
(5603, 1, 2802, 'Task deleted', 0),
(5604, 0, 2802, 'Task deleted', 0),
(5605, 1, 2803, 'Detached task', 0),
(5606, 0, 2803, 'Detached task', 0),
(5607, 1, 2804, 'Task custom fields updated', 0),
(5608, 0, 2804, 'Task custom fields updated', 0),
(5609, 1, 2805, 'Comment deleted', 0),
(5610, 0, 2805, 'Comment deleted', 0),
(5611, 1, 2806, 'Less', 0),
(5612, 0, 2806, 'Less', 0),
(5613, 1, 2807, 'All categories', 0),
(5614, 0, 2807, 'All categories', 0),
(5615, 1, 2808, 'All forums', 0),
(5616, 0, 2808, 'All forums', 0),
(5617, 1, 2809, 'Remove sticky', 0),
(5618, 0, 2809, 'Remove sticky', 0),
(5619, 1, 2810, 'Mark as sticky', 0),
(5620, 0, 2810, 'Mark as sticky', 0),
(5621, 1, 2811, 'Translate', 0),
(5622, 0, 2811, 'Translate', 0),
(5623, 1, 2812, 'View all post', 0),
(5624, 0, 2812, 'View all post', 0),
(5625, 1, 2813, 'Delete billing rate', 0),
(5626, 0, 2813, 'Delete billing rate', 0),
(5627, 1, 2814, 'Billing rate', 0),
(5628, 0, 2814, 'Billing rate', 0),
(5629, 1, 2815, 'Apply billing rate', 0),
(5630, 0, 2815, 'Apply billing rate', 0),
(5631, 1, 2816, 'Customer satisfaction', 0),
(5632, 0, 2816, 'Customer satisfaction', 0),
(5633, 1, 2817, 'Access denied for your devices', 0),
(5634, 0, 2817, 'Access denied for your devices', 0),
(5635, 1, 2818, 'Add change', 0),
(5636, 0, 2818, 'Add change', 0),
(5637, 1, 2819, 'Staff activity', 0),
(5638, 0, 2819, 'Staff activity', 0),
(5639, 1, 2820, 'Devices', 0),
(5640, 0, 2820, 'Devices', 0),
(5641, 1, 2821, 'Import types', 0),
(5642, 0, 2821, 'Import types', 0),
(5643, 1, 2822, 'Description empty', 0),
(5644, 0, 2822, 'Description empty', 0),
(5645, 1, 2823, 'Please select staff or team', 0),
(5646, 0, 2823, 'Please select staff or team', 0),
(5647, 1, 2824, 'File attachment limit exceed', 0),
(5648, 0, 2824, 'File attachment limit exceed', 0),
(5649, 1, 2825, 'Seller ID', 0),
(5650, 0, 2825, 'Seller ID', 0),
(5651, 1, 2826, 'Client portal design', 0),
(5652, 0, 2826, 'Client portal design', 0),
(5653, 1, 2827, 'Forum topic', 0),
(5654, 0, 2827, 'Forum topic', 0),
(5655, 1, 2828, 'Forum post', 0),
(5656, 0, 2828, 'Forum post', 0),
(5657, 1, 2829, 'Solution list', 0),
(5658, 0, 2829, 'Solution list', 0),
(5659, 1, 2830, 'Footer', 0),
(5660, 0, 2830, 'Footer', 0),
(5661, 1, 2831, 'Custom client portal design', 0),
(5662, 0, 2831, 'Custom client portal design', 0),
(5663, 1, 2832, 'Portal design', 0),
(5664, 0, 2832, 'Portal design', 0),
(5665, 1, 2833, 'Data not available', 0),
(5666, 0, 2833, 'Data not available', 0),
(5667, 1, 2834, 'Time credit', 0),
(5668, 0, 2834, 'Time credit', 0),
(5669, 1, 2835, 'Recent post', 0),
(5670, 0, 2835, 'Recent post', 0),
(5671, 1, 2836, 'Sticky post', 0),
(5672, 0, 2836, 'Sticky post', 0),
(5673, 1, 2837, 'Recent categories', 0),
(5674, 0, 2837, 'Recent categories', 0),
(5675, 1, 2838, 'Lock', 0),
(5676, 0, 2838, 'Lock', 0),
(5677, 1, 2839, 'Keywords', 0),
(5678, 0, 2839, 'Keywords', 0),
(5679, 1, 2840, 'Please check any one', 0),
(5680, 0, 2840, 'Please check any one', 0),
(5681, 1, 2841, 'via client portal', 1),
(5682, 0, 2841, 'via client portal', 1),
(5683, 1, 2842, 'Incident merged', 1),
(5684, 0, 2842, 'Incident merged', 1),
(5685, 1, 2843, 'Incident assign', 1),
(5686, 0, 2843, 'Incident assign', 1),
(5687, 1, 2844, 'Credit summary', 0),
(5688, 0, 2844, 'Credit summary', 0),
(5689, 1, 2845, 'Insufficient credits', 0),
(5690, 0, 2845, 'Insufficient credits', 0),
(5691, 0, 2846, 'Incident count', 0),
(5692, 1, 2846, 'Incident count', 0),
(5693, 0, 2847, 'Add billing rate', 0),
(5694, 1, 2847, 'Add billing rate', 0),
(5695, 0, 2848, 'Update billing rate', 1),
(5696, 1, 2848, 'Update billing rate', 1),
(5697, 0, 2849, 'Time', 0),
(5698, 1, 2849, 'Time', 0),
(5699, 0, 2850, 'Payment for invoice', 0),
(5700, 1, 2850, 'Payment for invoice', 0),
(5701, 0, 2851, 'Start date must be less than end date', 0),
(5702, 1, 2851, 'Start date must be less than end date', 0),
(5703, 0, 2852, 'Captcha not verified', 1),
(5704, 1, 2852, 'Captcha not verified', 1),
(5705, 0, 2853, 'Re-assigned date', 0),
(5706, 1, 2853, 'Re-assigned date', 0),
(5707, 0, 2854, 'Ready for deploy?', 0),
(5708, 1, 2854, 'Ready for deploy?', 0),
(5709, 0, 2855, 'You have ', 0),
(5710, 1, 2855, 'You have ', 0),
(5711, 0, 2856, 'Start time', 0),
(5712, 1, 2856, 'Start time', 0),
(5713, 0, 2857, 'End time', 0),
(5714, 1, 2857, 'End time', 0),
(5715, 0, 2858, 'Subclients', 0),
(5716, 1, 2858, 'Subclients', 0),
(5717, 0, 2859, 'Item changed', 0),
(5718, 1, 2859, 'Item changed', 0),
(5719, 0, 2860, 'One time', 0),
(5720, 1, 2860, 'One time', 0),
(5721, 0, 2861, 'Monthly', 0),
(5722, 1, 2861, 'Monthly', 0),
(5723, 0, 2862, 'Quarterly', 0),
(5724, 1, 2862, 'Quarterly', 0),
(5725, 0, 2863, 'Semi annually', 0),
(5726, 1, 2863, 'Semi annually', 0),
(5727, 0, 2864, 'Annually', 0),
(5728, 1, 2864, 'Annually', 0),
(5729, 0, 2865, 'Update contract', 0),
(5730, 1, 2865, 'Update contract', 0),
(5731, 0, 2866, 'Contact number should be numeric', 0),
(5732, 1, 2866, 'Contact number should be numeric', 0),
(5733, 0, 2867, 'Conversations', 0),
(5734, 1, 2867, 'Conversations', 0),
(5735, 0, 2868, 'Post message not found', 0),
(5736, 1, 2868, 'Post message not found', 0),
(5737, 0, 2869, 'Required at least one recipient', 0),
(5738, 1, 2869, 'Required at least one recipient', 0),
(5739, 0, 2870, 'Required at least one day', 0),
(5740, 1, 2870, 'Required at least one day', 0),
(5741, 0, 2871, 'must be greater than', 0),
(5742, 1, 2871, 'must be greater than', 0),
(5743, 0, 2872, 'Half day', 0),
(5744, 1, 2872, 'Half day', 0),
(5745, 0, 2873, 'Changed', 0),
(5746, 1, 2873, 'Changed', 0),
(5747, 0, 2874, 'Reset resolution time', 0),
(5748, 1, 2874, 'Reset resolution time', 0),
(5749, 0, 2875, 'Working hours', 0),
(5750, 1, 2875, 'Working hours', 0),
(5751, 0, 2876, 'Urgency', 0),
(5752, 1, 2876, 'Urgency', 0),
(5753, 0, 2877, 'Child', 0),
(5754, 1, 2877, 'Child', 0),
(5755, 0, 2878, 'Salvage must be numeric', 0),
(5756, 1, 2878, 'Salvage must be numeric', 0),
(5757, 0, 2879, 'Select number of copies to clone', 0),
(5758, 1, 2879, 'Select number of copies to clone', 0),
(5759, 0, 2880, 'Display reason for incident closure', 0),
(5760, 1, 2880, 'Display reason for incident closure', 0),
(5761, 0, 2881, 'Reason for incident closure', 0),
(5762, 1, 2881, 'Reason for incident closure', 0),
(5763, 0, 2882, 'Change urgency', 0),
(5764, 1, 2882, 'Change urgency', 0),
(5765, 0, 2883, 'Change impact ', 0),
(5766, 1, 2883, 'Change impact ', 0),
(5767, 0, 2884, 'CAB user', 0),
(5768, 1, 2884, 'CAB user', 0),
(5769, 0, 2885, 'Multiple', 0),
(5770, 1, 2885, 'Multiple', 0),
(5771, 0, 2886, 'Incident already pinned', 0),
(5772, 1, 2886, 'Incident already pinned', 0),
(5773, 0, 2887, 'Justification for priority change', 0),
(5774, 1, 2887, 'Justification for priority change', 0),
(5775, 0, 2888, 'Display justification for priority change', 0),
(5776, 1, 2888, 'Display justification for priority change', 0),
(5777, 0, 2889, 'Added', 0),
(5778, 1, 2889, 'Added', 0),
(5779, 0, 2890, 'Proposed plan', 0),
(5780, 1, 2890, 'Proposed plan', 0),
(5781, 0, 2891, 'Business justification', 0),
(5782, 1, 2891, 'Business justification', 0),
(5783, 0, 2892, 'Module properties', 0),
(5784, 1, 2892, 'Module properties', 0),
(5785, 0, 2893, 'Save as solution', 0),
(5786, 1, 2893, 'Save as solution', 0),
(5787, 0, 2894, 'Review the request for change', 0),
(5788, 1, 2894, 'Review the request for change', 0),
(5789, 0, 2895, 'Is the change request practical, within scope and valid', 0),
(5790, 1, 2895, 'Is the change request practical, within scope and valid', 0),
(5791, 0, 2896, 'Does it have a clear description and business justification', 0),
(5792, 1, 2896, 'Does it have a clear description and business justification', 0),
(5793, 0, 2897, 'Change review', 0),
(5794, 1, 2897, 'Change review', 0),
(5795, 0, 2898, 'Add further details', 0),
(5796, 1, 2898, 'Add further details', 0),
(5797, 0, 2899, 'High-level implementation plan', 0),
(5798, 1, 2899, 'High-level implementation plan', 0),
(5799, 0, 2900, 'Technical implementation plan', 0),
(5800, 1, 2900, 'Technical implementation plan', 0),
(5801, 0, 2901, 'Resource plan', 0),
(5802, 1, 2901, 'Resource plan', 0),
(5803, 0, 2902, 'This system uses php mail function to send outgoing emails, if you wish to set smtp please add your smtp login details', 0),
(5804, 1, 2902, 'This system uses php mail function to send outgoing emails, if you wish to set smtp please add your smtp login details', 0),
(5805, 0, 2903, 'Communication plan', 0),
(5806, 1, 2903, 'Communication plan', 0),
(5807, 0, 2904, 'Acceptance plan', 0),
(5808, 1, 2904, 'Acceptance plan', 0),
(5809, 0, 2905, 'Monitoring plan', 0),
(5810, 1, 2905, 'Monitoring plan', 0),
(5811, 0, 2906, 'Updated', 0),
(5812, 1, 2906, 'Updated', 0),
(5813, 0, 2907, 'Deleting assets will delete all its child assets. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(5814, 1, 2907, 'Deleting assets will delete all its child assets. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(5815, 0, 2908, 'Invalid', 0),
(5816, 1, 2908, 'Invalid', 0),
(5817, 0, 2909, 'Requester', 0),
(5818, 1, 2909, 'Requester', 0),
(5819, 0, 2910, 'Implementer', 0),
(5820, 1, 2910, 'Implementer', 0),
(5821, 0, 2911, 'Tester', 0),
(5822, 1, 2911, 'Tester', 0),
(5823, 0, 2912, 'Approver', 0),
(5824, 1, 2912, 'Approver', 0),
(5825, 0, 2913, 'Record the meeting automatically on local computer', 0),
(5826, 1, 2913, 'Record the meeting automatically on local computer', 0),
(5827, 0, 2914, 'Supervisor', 0),
(5828, 1, 2914, 'Supervisor', 0),
(5829, 0, 2915, 'Coordinator', 0),
(5830, 1, 2915, 'Coordinator', 0),
(5831, 0, 2916, 'Change already closed', 0),
(5832, 1, 2916, 'Change already closed', 0),
(5833, 0, 2917, 'Complete all the steps and close all the linked incidents, problems and tasks before closing change', 0),
(5834, 1, 2917, 'Complete all the steps and close all the linked incidents, problems and tasks before closing change', 0),
(5835, 0, 2918, 'Technical assessment meeting', 0),
(5836, 1, 2918, 'Technical assessment meeting', 0),
(5837, 0, 2919, 'Review for risk avoidance and impact to the environment from a technical perspective', 0),
(5838, 1, 2919, 'Review for risk avoidance and impact to the environment from a technical perspective', 0),
(5839, 0, 2920, 'Ensure risks are reviewed and appropriate mitigation strategy in place', 0),
(5840, 1, 2920, 'Ensure risks are reviewed and appropriate mitigation strategy in place', 0),
(5841, 0, 2921, 'Review to provide technical approval, rejection or seek further clarification', 0),
(5842, 1, 2921, 'Review to provide technical approval, rejection or seek further clarification', 0),
(5843, 0, 2922, 'Technical information for changes to be assessed and prioritized accordingly', 0),
(5844, 1, 2922, 'Technical information for changes to be assessed and prioritized accordingly', 0),
(5845, 0, 2923, 'Review and reject', 0),
(5846, 1, 2923, 'Review and reject', 0),
(5847, 0, 2924, 'Change build and test', 0),
(5848, 1, 2924, 'Change build and test', 0),
(5849, 0, 2925, 'Coordinate build', 0),
(5850, 1, 2925, 'Coordinate build', 0),
(5851, 0, 2926, 'Perform build activities', 0),
(5852, 1, 2926, 'Perform build activities', 0),
(5853, 0, 2927, 'Coordinate testing', 0),
(5854, 1, 2927, 'Coordinate testing', 0),
(5855, 0, 2928, 'Execute test activities log', 0),
(5856, 1, 2928, 'Execute test activities log', 0),
(5857, 0, 2929, 'Review and resolve defects', 0),
(5858, 1, 2929, 'Review and resolve defects', 0),
(5859, 0, 2930, 'Update supporting change documentation', 0),
(5860, 1, 2930, 'Update supporting change documentation', 0),
(5861, 0, 2931, 'Sign off build / Test review build / Test options', 0),
(5862, 1, 2931, 'Sign off build / Test review build / Test options', 0),
(5863, 0, 2932, 'Cancel change record', 0),
(5864, 1, 2932, 'Cancel change record', 0),
(5865, 0, 2933, 'Emergency', 0),
(5866, 1, 2933, 'Emergency', 0),
(5867, 0, 2934, 'Plans', 0),
(5868, 1, 2934, 'Plans', 0),
(5869, 0, 2935, 'Implementation approval', 0),
(5870, 1, 2935, 'Implementation approval', 0),
(5871, 0, 2936, 'Implement change', 0),
(5872, 1, 2936, 'Implement change', 0),
(5873, 0, 2937, 'Monitor change', 0),
(5874, 1, 2937, 'Monitor change', 0),
(5875, 0, 2938, 'Current step', 0),
(5876, 1, 2938, 'Current step', 0),
(5877, 0, 2939, 'Total data count to be archived', 0),
(5878, 1, 2939, 'Total data count to be archived', 0),
(5879, 0, 2940, 'Creator', 0),
(5880, 1, 2940, 'Creator', 0),
(5881, 0, 2941, 'Changes assessed for risk avoidance, priority and impact', 0),
(5882, 1, 2941, 'Changes assessed for risk avoidance, priority and impact', 0),
(5883, 0, 2942, 'Review changes (prior) with a view to provide approval, rejection or seek further clarification', 0),
(5884, 1, 2942, 'Review changes (prior) with a view to provide approval, rejection or seek further clarification', 0),
(5885, 0, 2943, 'Supported by members who represent a cross section of the organizations represented and impacted', 0),
(5886, 1, 2943, 'Supported by members who represent a cross section of the organizations represented and impacted', 0),
(5887, 0, 2944, 'Participates in identifying and approving standard changes that are then added to the approved standard change list', 0),
(5888, 1, 2944, 'Participates in identifying and approving standard changes that are then added to the approved standard change list', 0),
(5889, 0, 2945, 'Provide input to the coordination of change schedules', 0),
(5890, 1, 2945, 'Provide input to the coordination of change schedules', 0),
(5891, 0, 2946, 'Ensure CAB activities adhere to all relevant policies, process and procedures', 0),
(5892, 1, 2946, 'Ensure CAB activities adhere to all relevant policies, process and procedures', 0),
(5893, 0, 2947, 'Coordinate and implement change', 0),
(5894, 1, 2947, 'Coordinate and implement change', 0),
(5895, 0, 2948, 'Execute post implementation verification', 0),
(5896, 1, 2948, 'Execute post implementation verification', 0),
(5897, 0, 2949, 'Implementation status', 0),
(5898, 1, 2949, 'Implementation status', 0),
(5899, 0, 2950, 'Execute back-out', 0),
(5900, 1, 2950, 'Execute back-out', 0),
(5901, 0, 2951, 'Trigger configuration management update', 0),
(5902, 1, 2951, 'Trigger configuration management update', 0),
(5903, 0, 2952, 'Trigger implementation monitoring', 0),
(5904, 1, 2952, 'Trigger implementation monitoring', 0),
(5905, 0, 2953, 'Evaluate the change for success, failure, potential issues (e.g. performance or business impact) against criteria detailed in the monitoring plan', 0),
(5906, 1, 2953, 'Evaluate the change for success, failure, potential issues (e.g. performance or business impact) against criteria detailed in the monitoring plan', 0),
(5907, 0, 2954, 'Results are documented and if any issues are identified these are reviewed with the change manager', 0),
(5908, 1, 2954, 'Results are documented and if any issues are identified these are reviewed with the change manager', 0),
(5909, 0, 2955, 'Further details', 0),
(5910, 1, 2955, 'Further details', 0),
(5911, 0, 2956, 'If the business is negatively impacted a decision is made to log a request to incident management for a new incident.In addition the change record may also be passed back to evaluate the need to execute the back out plan.', 0),
(5912, 1, 2956, 'If the business is negatively impacted a decision is made to log a request to incident management for a new incident.In addition the change record may also be passed back to evaluate the need to execute the back out plan.', 0),
(5913, 0, 2957, 'On completion of the change, the results should be reported for evaluation to those responsible for managing changes, and then presented as a completed change for stakeholder agreement (including the closing of related incidents, problems or known errors)', 0),
(5914, 1, 2957, 'On completion of the change, the results should be reported for evaluation to those responsible for managing changes, and then presented as a completed change for stakeholder agreement (including the closing of related incidents, problems or known errors)', 0),
(5915, 0, 2958, 'Close all the linked', 0),
(5916, 1, 2958, 'Close all the linked', 0),
(5917, 0, 2959, 'Impact details', 0),
(5918, 1, 2959, 'Impact details', 0),
(5919, 0, 2960, 'Impact details for impact change', 0),
(5920, 1, 2960, 'Impact details for impact change', 0),
(5921, 0, 2961, 'Is a CAB user?', 0),
(5922, 1, 2961, 'Is a CAB user?', 0),
(5923, 0, 2962, 'Client email verification', 0),
(5924, 1, 2962, 'Client email verification', 0),
(5925, 0, 2963, 'Expected closing date', 0),
(5926, 1, 2963, 'Expected closing date', 0),
(5927, 0, 2964, 'Already added', 0),
(5928, 1, 2964, 'Already added', 0),
(5929, 0, 2965, 'Favorite', 0),
(5930, 1, 2965, 'Favorite', 0),
(5931, 0, 2966, 'Add to favorite', 0),
(5932, 1, 2966, 'Add to favorite', 0),
(5933, 0, 2967, 'Remove favorite', 0),
(5934, 1, 2967, 'Remove favorite', 0),
(5935, 0, 2968, 'End date must be greater than start date', 0),
(5936, 1, 2968, 'End date must be greater than start date', 0),
(5937, 0, 2969, 'Instructions', 0),
(5938, 1, 2969, 'Instructions', 0),
(5939, 0, 2970, 'Identify', 0),
(5940, 1, 2970, 'Identify', 0),
(5941, 0, 2971, 'Identification note', 0),
(5942, 1, 2971, 'Identification note', 0),
(5943, 0, 2972, 'Resource', 0),
(5944, 1, 2972, 'Resource', 0),
(5945, 0, 2973, 'Manage by', 0),
(5946, 1, 2973, 'Manage by', 0),
(5947, 0, 2974, 'Management', 0),
(5948, 1, 2974, 'Management', 0),
(5949, 0, 2975, 'Internal manpower in hours', 0),
(5950, 1, 2975, 'Internal manpower in hours', 0),
(5951, 0, 2976, 'Total costs', 0),
(5952, 1, 2976, 'Total costs', 0),
(5953, 0, 2977, 'Installation costs', 0),
(5954, 1, 2977, 'Installation costs', 0),
(5955, 0, 2978, 'Training costs', 0),
(5956, 1, 2978, 'Training costs', 0),
(5957, 0, 2979, 'Maintenance costs', 0),
(5958, 1, 2979, 'Maintenance costs', 0),
(5959, 0, 2980, 'Proposed date', 0),
(5960, 1, 2980, 'Proposed date', 0),
(5961, 0, 2981, 'Delivered by', 0),
(5962, 1, 2981, 'Delivered by', 0),
(5963, 0, 2982, 'Proposed delivery date', 0),
(5964, 1, 2982, 'Proposed delivery date', 0),
(5965, 0, 2983, 'Risk assessment', 0),
(5966, 1, 2983, 'Risk assessment', 0),
(5967, 0, 2984, 'Expected downtime start', 0),
(5968, 1, 2984, 'Expected downtime start', 0),
(5969, 0, 2985, 'Expected downtime end', 0),
(5970, 1, 2985, 'Expected downtime end', 0),
(5971, 0, 2986, 'Downtime hours', 0),
(5972, 1, 2986, 'Downtime hours', 0),
(5973, 0, 2987, 'Remark', 0),
(5974, 1, 2987, 'Remark', 0),
(5975, 0, 2988, 'Approved by', 0),
(5976, 1, 2988, 'Approved by', 0),
(5977, 0, 2989, 'Identify and analysis', 0),
(5978, 1, 2989, 'Identify and analysis', 0),
(5979, 0, 2990, 'Delivery manager', 0),
(5980, 1, 2990, 'Delivery manager', 0),
(5981, 0, 2991, 'Task date', 0),
(5982, 1, 2991, 'Task date', 0),
(5983, 0, 2992, 'Timeline', 0),
(5984, 1, 2992, 'Timeline', 0),
(5985, 0, 2993, 'Go to step', 0),
(5986, 1, 2993, 'Go to step', 0),
(5987, 0, 2994, 'Changes grouped by status', 0),
(5988, 1, 2994, 'Changes grouped by status', 0),
(5989, 0, 2995, 'Changes grouped by priority', 0),
(5990, 1, 2995, 'Changes grouped by priority', 0),
(5991, 0, 2996, 'Changes grouped by impact', 0),
(5992, 1, 2996, 'Changes grouped by impact', 0),
(5993, 0, 2997, 'Release manager', 0),
(5994, 1, 2997, 'Release manager', 0),
(5995, 0, 2998, 'New release attached', 0),
(5996, 1, 2998, 'New release attached', 0),
(5997, 0, 2999, 'Detached attached release', 0),
(5998, 1, 2999, 'Detached attached release', 0),
(5999, 0, 3000, 'Note added', 0),
(6000, 1, 3000, 'Note added', 0),
(6001, 0, 3001, 'Note deleted', 0),
(6002, 1, 3001, 'Note deleted', 0),
(6003, 0, 3002, 'Not closed', 0),
(6004, 1, 3002, 'Not closed', 0),
(6005, 0, 3003, 'Not responded', 0),
(6006, 1, 3003, 'Not responded', 0),
(6007, 0, 3004, 'Known error', 0),
(6008, 1, 3004, 'Known error', 0),
(6009, 0, 3005, 'Production', 0),
(6010, 1, 3005, 'Production', 0),
(6011, 0, 3006, 'Development', 0),
(6012, 1, 3006, 'Development', 0),
(6013, 0, 3007, 'Department wise invoice report', 0),
(6014, 1, 3007, 'Department wise invoice report', 0),
(6015, 0, 3008, 'Domain wise invoice report', 0),
(6016, 1, 3008, 'Domain wise invoice report', 0),
(6017, 0, 3009, 'Schedule of post implementation reviews', 0),
(6018, 1, 3009, 'Schedule of post implementation reviews', 0),
(6019, 0, 3010, 'Test date', 0),
(6020, 1, 3010, 'Test date', 0),
(6021, 0, 3011, 'Build date', 0),
(6022, 1, 3011, 'Build date', 0),
(6023, 0, 3012, 'Implementation date', 0),
(6024, 1, 3012, 'Implementation date', 0),
(6025, 0, 3013, 'Is clone of', 0),
(6026, 1, 3013, 'Is clone of', 0),
(6027, 0, 3014, 'time track', 0),
(6028, 1, 3014, 'time track', 0),
(6029, 0, 3015, 'Modified', 0),
(6030, 1, 3015, 'Modified', 0),
(6031, 0, 3016, 'Change plan date', 0),
(6032, 1, 3016, 'Change plan date', 0),
(6033, 0, 3017, 'Projected service outage', 0),
(6034, 1, 3017, 'Projected service outage', 0),
(6035, 0, 3018, 'Archive', 0),
(6036, 1, 3018, 'Archive', 0),
(6037, 0, 3019, 'Reference', 0),
(6038, 1, 3019, 'Reference', 0),
(6039, 0, 3020, 'Required meeting password ', 0),
(6040, 1, 3020, 'Required meeting password ', 0),
(6041, 0, 3021, 'Total pending ', 0),
(6042, 1, 3021, 'Total pending ', 0),
(6043, 0, 3022, 'Leave us a message', 0),
(6044, 1, 3022, 'Leave us a message', 0),
(6045, 0, 3023, 'Scan asset', 0),
(6046, 1, 3023, 'Scan asset', 0),
(6047, 0, 3024, 'Scanning will start as soon as the asset agent starts at remote device.', 0),
(6048, 1, 3024, 'Scanning will start as soon as the asset agent starts at remote device.', 0),
(6049, 0, 3025, 'Search activity', 0),
(6050, 1, 3025, 'Search activity', 0),
(6051, 0, 3026, 'Packages', 0),
(6052, 1, 3026, 'Packages', 0),
(6053, 0, 3027, 'Send registration key', 0),
(6054, 1, 3027, 'Send registration key', 0),
(6055, 0, 3028, 'Select project', 0),
(6056, 1, 3028, 'Select project', 0),
(6057, 0, 3029, 'Review', 0),
(6058, 1, 3029, 'Review', 0),
(6059, 0, 3030, 'Problem incident trend analysis', 0),
(6060, 1, 3030, 'Problem incident trend analysis', 0),
(6061, 0, 3031, 'Change incident trend analysis', 0),
(6062, 1, 3031, 'Change incident trend analysis', 0),
(6063, 0, 3032, 'Release incident trend analysis', 0),
(6064, 1, 3032, 'Release incident trend analysis', 0),
(6065, 0, 3033, 'Mode of contact', 0),
(6066, 1, 3033, 'Mode of contact', 0),
(6067, 0, 3034, 'Web portal', 0),
(6068, 1, 3034, 'Web portal', 0),
(6069, 0, 3035, 'Problem incident relation', 0),
(6070, 1, 3035, 'Problem incident relation', 0),
(6071, 0, 3036, 'Root cause updated', 0),
(6072, 1, 3036, 'Root cause updated', 0),
(6073, 0, 3037, 'Symptoms updated', 0),
(6074, 1, 3037, 'Symptoms updated', 0),
(6075, 0, 3038, 'Reason for change updated', 0),
(6076, 1, 3038, 'Reason for change updated', 0),
(6077, 0, 3039, 'Rollout plan updated', 0),
(6078, 1, 3039, 'Rollout plan updated', 0),
(6079, 0, 3040, 'Backout plan updated', 0),
(6080, 1, 3040, 'Backout plan updated', 0),
(6081, 0, 3041, 'Build plan updated', 0),
(6082, 1, 3041, 'Build plan updated', 0),
(6083, 0, 3042, 'Test plan updated', 0),
(6084, 1, 3042, 'Test plan updated', 0),
(6085, 0, 3043, 'Problem overdue', 0),
(6086, 1, 3043, 'Problem overdue', 0),
(6087, 0, 3044, 'Changes overdue', 0),
(6088, 1, 3044, 'Changes overdue', 0),
(6089, 0, 3045, 'Release overdue', 0),
(6090, 1, 3045, 'Release overdue', 0),
(6091, 0, 3046, 'Known error updated', 0),
(6092, 1, 3046, 'Known error updated', 0),
(6093, 0, 3047, 'Change type updated', 0),
(6094, 1, 3047, 'Change type updated', 0),
(6095, 0, 3048, 'Release type updated', 0),
(6096, 1, 3048, 'Release type updated', 0),
(6097, 0, 3049, 'Property changed - impact', 0),
(6098, 1, 3049, 'Property changed - impact', 0),
(6099, 0, 3050, 'Problem assigned', 0),
(6100, 1, 3050, 'Problem assigned', 0),
(6101, 0, 3051, 'Release assigned', 0),
(6102, 1, 3051, 'Release assigned', 0),
(6103, 0, 3052, 'Change assigned', 0),
(6104, 1, 3052, 'Change assigned', 0),
(6105, 0, 3053, 'Permanent solution linked', 0),
(6106, 1, 3053, 'Permanent solution linked', 0),
(6107, 0, 3054, 'Workarround solution linked', 0),
(6108, 1, 3054, 'Workarround solution linked', 0),
(6109, 0, 3055, 'Reminder', 0),
(6110, 1, 3055, 'Reminder', 0),
(6111, 0, 3056, 'Session', 0),
(6112, 1, 3056, 'Session', 0),
(6113, 0, 3057, 'List view', 0),
(6114, 1, 3057, 'List view', 0),
(6115, 0, 3058, 'Newly registered', 0),
(6116, 1, 3058, 'Newly registered', 0),
(6117, 0, 3059, 'Replies', 0),
(6118, 1, 3059, 'Replies', 0),
(6119, 0, 3060, 'Started', 0),
(6120, 1, 3060, 'Started', 0),
(6121, 0, 3061, 'Next 7 days', 0),
(6122, 1, 3061, 'Next 7 days', 0),
(6123, 0, 3062, 'KiB', 0),
(6124, 1, 3062, 'KiB', 0),
(6125, 0, 3063, 'Drive', 0),
(6126, 1, 3063, 'Drive', 0),
(6127, 0, 3064, 'Insert', 0),
(6128, 1, 3064, 'Insert', 0),
(6129, 0, 3065, 'Use csv organization', 0),
(6130, 1, 3065, 'Use csv organization', 0),
(6131, 0, 3066, 'Column mapping', 0),
(6132, 1, 3066, 'Column mapping', 0),
(6133, 0, 3067, 'Featured', 0),
(6134, 1, 3067, 'Featured', 0),
(6135, 0, 3068, 'View all articles and sections', 0),
(6136, 1, 3068, 'View all articles and sections', 0),
(6137, 0, 3069, 'Grid view', 0),
(6138, 1, 3069, 'Grid view', 0),
(6139, 0, 3070, 'Weeks', 0),
(6140, 1, 3070, 'Weeks', 0),
(6141, 0, 3071, 'Data archive', 0),
(6142, 1, 3071, 'Data archive', 0),
(6143, 0, 3072, 'Archive data before', 0),
(6144, 1, 3072, 'Archive data before', 0),
(6145, 0, 3073, 'Archive data from', 0),
(6146, 1, 3073, 'Archive data from', 0),
(6147, 0, 3074, 'Vision helpdesk SMTP', 0),
(6148, 1, 3074, 'Vision helpdesk SMTP', 0),
(6149, 0, 3075, 'Trusted domain list', 0),
(6150, 1, 3075, 'Trusted domain list', 0),
(6151, 0, 3076, 'Default SMTP mail', 0),
(6152, 1, 3076, 'Default SMTP mail', 0),
(6153, 0, 3077, 'Dropbox', 0),
(6154, 1, 3077, 'Dropbox', 0),
(6155, 0, 3078, 'Yellow', 0),
(6156, 1, 3078, 'Yellow', 0),
(6157, 0, 3079, 'Green', 0),
(6158, 1, 3079, 'Green', 0),
(6159, 0, 3080, 'Red', 0),
(6160, 1, 3080, 'Red', 0),
(6161, 0, 3081, 'Blue', 0),
(6162, 1, 3081, 'Blue', 0),
(6163, 0, 3082, 'Service request resolved report', 0),
(6164, 1, 3082, 'Service request resolved report', 0),
(6165, 0, 3083, 'Enter privacy policy url', 0),
(6166, 1, 3083, 'Enter privacy policy url', 0),
(6167, 0, 3084, 'Enter valid url', 0),
(6168, 1, 3084, 'Enter valid url', 0),
(6169, 0, 3085, 'Privacy policy', 0),
(6170, 1, 3085, 'Privacy policy', 0),
(6171, 0, 3086, 'Check privacy policy', 0),
(6172, 1, 3086, 'Check privacy policy', 0),
(6173, 0, 3087, 'My assets', 0),
(6174, 1, 3087, 'My assets', 0),
(6175, 0, 3088, 'You got a blab', 0),
(6176, 1, 3088, 'You got a blab', 0),
(6177, 0, 3089, 'Configuration manager', 0),
(6178, 1, 3089, 'Configuration manager', 0),
(6179, 0, 3090, 'Knowledge manager', 0),
(6180, 1, 3090, 'Knowledge manager', 0),
(6181, 0, 3091, 'Project manager', 0),
(6182, 1, 3091, 'Project manager', 0),
(6183, 0, 3092, 'Total resolved', 0),
(6184, 1, 3092, 'Total resolved', 0),
(6185, 0, 3093, 'Test manager', 0),
(6186, 1, 3093, 'Test manager', 0),
(6187, 0, 3094, 'Once', 0),
(6188, 1, 3094, 'Once', 0),
(6189, 0, 3095, 'Daily', 0),
(6190, 1, 3095, 'Daily', 0),
(6191, 0, 3096, 'Weekly', 0),
(6192, 1, 3096, 'Weekly', 0),
(6193, 0, 3097, 'Manual invoice', 0),
(6194, 1, 3097, 'Manual invoice', 0),
(6195, 0, 3098, 'Radio button', 0),
(6196, 1, 3098, 'Radio button', 0),
(6197, 0, 3099, 'Select box', 0),
(6198, 1, 3099, 'Select box', 0),
(6199, 0, 3100, 'Width', 0),
(6200, 1, 3100, 'Width', 0),
(6201, 0, 3101, 'Years', 0),
(6202, 1, 3101, 'Years', 0),
(6203, 0, 3102, 'You do not have permission to access this page', 0),
(6204, 1, 3102, 'You do not have permission to access this page', 0),
(6205, 0, 3103, 'Type to search asset name', 0),
(6206, 1, 3103, 'Type to search asset name', 0),
(6207, 0, 3104, 'Incident and Service request hash generation', 0),
(6208, 1, 3104, 'Incident and Service request hash generation', 0),
(6209, 0, 3105, 'Asset audit is going on', 0),
(6210, 1, 3105, 'Asset audit is going on', 0),
(6211, 0, 3106, 'Already exist', 0),
(6212, 1, 3106, 'Already exist', 0),
(6213, 0, 3107, 'Solved well', 0),
(6214, 1, 3107, 'Solved well', 0),
(6215, 0, 3108, 'Did not solved well', 0),
(6216, 1, 3108, 'Did not solved well', 0),
(6217, 0, 3109, 'Can do better for next', 0),
(6218, 1, 3109, 'Can do better for next', 0),
(6219, 0, 3110, 'Failure prevention', 0),
(6220, 1, 3110, 'Failure prevention', 0),
(6221, 0, 3111, 'Supplier involvement present', 0),
(6222, 1, 3111, 'Supplier involvement present', 0),
(6223, 0, 3112, 'Assets not available', 0),
(6224, 1, 3112, 'Assets not available', 0),
(6225, 0, 3113, 'Authentication successful', 0),
(6226, 1, 3113, 'Authentication successful', 0),
(6227, 0, 3114, 'Authentication to server failed', 0),
(6228, 1, 3114, 'Authentication to server failed', 0),
(6229, 0, 3115, 'By', 0),
(6230, 1, 3115, 'By', 0),
(6231, 0, 3116, 'Changed ip address restriction', 0),
(6232, 1, 3116, 'Changed ip address restriction', 0),
(6233, 0, 3117, 'Client already verified', 0),
(6234, 1, 3117, 'Client already verified', 0),
(6235, 0, 3118, 'Connected to server', 0),
(6236, 1, 3118, 'Connected to server', 0),
(6237, 0, 3119, 'Connecting to server failed', 0),
(6238, 1, 3119, 'Connecting to server failed', 0),
(6239, 0, 3120, 'Contract approved by', 0),
(6240, 1, 3120, 'Contract approved by', 0),
(6241, 0, 3121, 'Contract auto-renew status', 0),
(6242, 1, 3121, 'Contract auto-renew status', 0),
(6243, 0, 3122, 'Contract status changed to', 0),
(6244, 1, 3122, 'Contract status changed to', 0),
(6245, 0, 3123, 'Contract updated', 0),
(6246, 1, 3123, 'Contract updated', 0),
(6247, 0, 3124, 'Cost changed from', 0),
(6248, 1, 3124, 'Cost changed from', 0),
(6249, 0, 3125, 'Custom filter', 0),
(6250, 1, 3125, 'Custom filter', 0),
(6251, 0, 3126, 'File removed successfully', 0),
(6252, 1, 3126, 'File removed successfully', 0),
(6253, 0, 3127, 'Forwarded', 0),
(6254, 1, 3127, 'Forwarded', 0),
(6255, 0, 3128, 'Invalid client id or domain', 0),
(6256, 1, 3128, 'Invalid client id or domain', 0),
(6257, 0, 3129, 'Level changed from', 0),
(6258, 1, 3129, 'Level changed from', 0),
(6259, 0, 3130, 'License count changed', 0),
(6260, 1, 3130, 'License count changed', 0),
(6261, 0, 3131, 'Merged to', 0),
(6262, 1, 3131, 'Merged to', 0),
(6263, 0, 3132, 'Moved to inbox from trash', 0),
(6264, 1, 3132, 'Moved to inbox from trash', 0),
(6265, 0, 3133, 'Moved to trash', 0),
(6266, 1, 3133, 'Moved to trash', 0),
(6267, 0, 3134, 'Not applicable', 0),
(6268, 1, 3134, 'Not applicable', 0),
(6269, 0, 3135, 'Not resolved', 0),
(6270, 1, 3135, 'Not resolved', 0),
(6271, 0, 3136, 'Can not attach more than', 0),
(6272, 1, 3136, 'Can not attach more than', 0),
(6273, 0, 3137, 'Please upload valid image file', 0),
(6274, 1, 3137, 'Please upload valid image file', 0),
(6275, 0, 3138, 'Post split with', 0),
(6276, 1, 3138, 'Post split with', 0),
(6277, 0, 3139, 'Select day to schedule task', 0),
(6278, 1, 3139, 'Select day to schedule task', 0),
(6279, 0, 3140, 'You can attach maximum', 0),
(6280, 1, 3140, 'You can attach maximum', 0),
(6281, 0, 3141, 'Total cost changed from', 0),
(6282, 1, 3141, 'Total cost changed from', 0),
(6283, 0, 3142, 'Contracts hash generation', 0),
(6284, 1, 3142, 'Contracts hash generation', 0),
(6285, 0, 3143, 'From', 0),
(6286, 1, 3143, 'From', 0),
(6287, 0, 3144, 'To', 0),
(6288, 1, 3144, 'To', 0),
(6289, 0, 3145, 'Calendar list', 0),
(6290, 1, 3145, 'Calendar list', 0),
(6291, 0, 3146, 'Virtual agent', 0),
(6292, 1, 3146, 'Virtual agent', 0),
(6293, 0, 3147, 'Topic flow', 0),
(6294, 1, 3147, 'Topic flow', 0),
(6295, 0, 3148, 'Append conversation', 0),
(6296, 1, 3148, 'Append conversation', 0),
(6297, 0, 3149, 'Do you wish to end the conversation?', 0),
(6298, 1, 3149, 'Do you wish to end the conversation?', 0),
(6299, 0, 3150, 'Add step', 0),
(6300, 1, 3150, 'Add step', 0),
(6301, 0, 3151, 'Simple', 0),
(6302, 1, 3151, 'Simple', 0),
(6303, 0, 3152, 'Conditional', 0),
(6304, 1, 3152, 'Conditional', 0),
(6305, 0, 3153, 'Go to #Step', 0),
(6306, 1, 3153, 'Go to #Step', 0),
(6307, 0, 3154, '#Step', 0),
(6308, 1, 3154, '#Step', 0),
(6309, 0, 3155, 'Can not delete first step or option', 0),
(6310, 1, 3155, 'Can not delete first step or option', 0),
(6311, 0, 3156, 'Conversation with virtual agent', 0),
(6312, 1, 3156, 'Conversation with virtual agent', 0),
(6313, 0, 3157, 'Virtual agents', 0),
(6314, 1, 3157, 'Virtual agents', 0),
(6315, 0, 3158, 'Topics', 0),
(6316, 1, 3158, 'Topics', 0),
(6317, 0, 3159, 'To add new topic you need minimum one virtual agent', 0),
(6318, 1, 3159, 'To add new topic you need minimum one virtual agent', 0),
(6319, 0, 3160, 'Please select CSV', 0),
(6320, 1, 3160, 'Please select CSV', 0),
(6321, 0, 3161, 'Virtual agent display text', 0),
(6322, 1, 3161, 'Virtual agent display text', 0),
(6323, 0, 3162, 'Question text (Am I helpful?) ', 0),
(6324, 1, 3162, 'Question text (Am I helpful?) ', 0),
(6325, 0, 3163, 'Service request hash', 0),
(6326, 1, 3163, 'Service request hash', 0),
(6327, 0, 3164, 'Closing message', 0),
(6328, 1, 3164, 'Closing message', 0),
(6329, 0, 3165, 'Data not found text', 0),
(6330, 1, 3165, 'Data not found text', 0),
(6331, 0, 3166, 'Virtual agent name', 0),
(6332, 1, 3166, 'Virtual agent name', 0),
(6333, 0, 3167, 'Virtual agent display image', 0),
(6334, 1, 3167, 'Virtual agent display image', 0),
(6335, 0, 3168, 'Position', 0),
(6336, 1, 3168, 'Position', 0),
(6337, 0, 3169, 'Virtual agent code', 0),
(6338, 1, 3169, 'Virtual agent code', 0),
(6339, 0, 3170, 'Graphical reports', 0),
(6340, 1, 3170, 'Graphical reports', 0),
(6341, 0, 3171, 'Customize columns for custom report', 0),
(6342, 1, 3171, 'Customize columns for custom report', 0),
(6343, 0, 3172, 'On contract auto-renew', 0),
(6344, 1, 3172, 'On contract auto-renew', 0),
(6345, 0, 3173, 'Restored from archive', 0),
(6346, 1, 3173, 'Restored from archive', 0),
(6347, 0, 3174, 'Organization overview', 0),
(6348, 1, 3174, 'Organization overview', 0),
(6349, 0, 3175, 'Contract renewed', 0),
(6350, 1, 3175, 'Contract renewed', 0),
(6351, 0, 3176, 'Incident hash prefix already exist', 0),
(6352, 1, 3176, 'Incident hash prefix already exist', 0),
(6353, 0, 3177, 'Service hash prefix already exist', 0),
(6354, 1, 3177, 'Service hash prefix already exist', 0),
(6355, 0, 3178, 'Added new contract', 0),
(6356, 1, 3178, 'Added new contract', 0),
(6357, 0, 3179, 'Apply time credits', 0),
(6358, 1, 3179, 'Apply time credits', 0),
(6359, 0, 3180, 'Activity for service request', 0),
(6360, 1, 3180, 'Activity for service request', 0),
(6361, 0, 3181, 'Activity for service request by department', 0),
(6362, 1, 3181, 'Activity for service request by department', 0),
(6363, 0, 3182, 'Service request staff AVG. resolution time', 0),
(6364, 1, 3182, 'Service request staff AVG. resolution time', 0),
(6365, 0, 3183, 'Staff leaderboard AVG. resolution report', 0),
(6366, 1, 3183, 'Staff leaderboard AVG. resolution report', 0),
(6367, 0, 3184, 'Total unanswered service request', 0),
(6368, 1, 3184, 'Total unanswered service request', 0),
(6369, 0, 3185, 'Incident count by urgency', 0),
(6370, 1, 3185, 'Incident count by urgency', 0),
(6371, 0, 3186, 'Urgency title', 0),
(6372, 1, 3186, 'Urgency title', 0),
(6373, 0, 3187, 'Custom field report for user service request creation', 0),
(6374, 1, 3187, 'Custom field report for user service request creation', 0),
(6375, 0, 3188, 'Custom field report for staff service request creation', 0),
(6376, 1, 3188, 'Custom field report for staff service request creation', 0),
(6377, 0, 3189, 'Staff AVG. resolution time', 0),
(6378, 1, 3189, 'Staff AVG. resolution time', 0),
(6379, 0, 3190, 'Incident count by flag', 0),
(6380, 1, 3190, 'Incident count by flag', 0),
(6381, 0, 3191, 'Incident count by label', 0),
(6382, 1, 3191, 'Incident count by label', 0),
(6383, 0, 3192, 'Incident count by subcategory', 0),
(6384, 1, 3192, 'Incident count by subcategory', 0),
(6385, 0, 3193, 'Incident count by item', 0),
(6386, 1, 3193, 'Incident count by item', 0),
(6387, 0, 3194, 'Incident count by impact', 0),
(6388, 1, 3194, 'Incident count by impact', 0),
(6389, 0, 3195, 'Incident count by channel', 0);
INSERT INTO `avis_language_values` VALUES
(6390, 1, 3195, 'Incident count by channel', 0),
(6391, 0, 3196, 'Incident count by location', 0),
(6392, 1, 3196, 'Incident count by location', 0),
(6393, 0, 3197, 'Deleted service request', 0),
(6394, 1, 3197, 'Deleted service request', 0),
(6395, 0, 3198, 'Total AVG. resolution time', 0),
(6396, 1, 3198, 'Total AVG. resolution time', 0),
(6397, 0, 3199, 'Service request AVG. resolution time', 0),
(6398, 1, 3199, 'Service request AVG. resolution time', 0),
(6399, 0, 3200, 'Total close / resolved service request', 0),
(6400, 1, 3200, 'Total close / resolved service request', 0),
(6401, 0, 3201, 'Service request assigned', 0),
(6402, 1, 3201, 'Service request assigned', 0),
(6403, 0, 3202, 'Service request moved to trash', 0),
(6404, 1, 3202, 'Service request moved to trash', 0),
(6405, 0, 3203, 'Service request moved to inbox from trash', 0),
(6406, 1, 3203, 'Service request moved to inbox from trash', 0),
(6407, 0, 3204, 'Service request deleted', 0),
(6408, 1, 3204, 'Service request deleted', 0),
(6409, 0, 3205, 'Service request post split with', 0),
(6410, 1, 3205, 'Service request post split with', 0),
(6411, 0, 3206, 'Service request property updated', 0),
(6412, 1, 3206, 'Service request property updated', 0),
(6413, 0, 3207, 'Service request note added', 0),
(6414, 1, 3207, 'Service request note added', 0),
(6415, 0, 3208, 'Service request note deleted', 0),
(6416, 1, 3208, 'Service request note deleted', 0),
(6417, 0, 3209, 'Service request comment added', 0),
(6418, 1, 3209, 'Service request comment added', 0),
(6419, 0, 3210, 'Service request comment deleted', 0),
(6420, 1, 3210, 'Service request comment deleted', 0),
(6421, 0, 3211, 'Service request post updated', 0),
(6422, 1, 3211, 'Service request post updated', 0),
(6423, 0, 3212, 'New scheduled service request created', 0),
(6424, 1, 3212, 'New scheduled service request created', 0),
(6425, 0, 3213, 'Service request level changed', 0),
(6426, 1, 3213, 'Service request level changed', 0),
(6427, 0, 3214, 'Service request read', 0),
(6428, 1, 3214, 'Service request read', 0),
(6429, 0, 3215, 'Send service request approval', 0),
(6430, 1, 3215, 'Send service request approval', 0),
(6431, 0, 3216, 'Send service request approval reminder', 0),
(6432, 1, 3216, 'Send service request approval reminder', 0),
(6433, 0, 3217, 'Modified service request custom fields data', 0),
(6434, 1, 3217, 'Modified service request custom fields data', 0),
(6435, 0, 3218, 'Total service request replied', 0),
(6436, 1, 3218, 'Total service request replied', 0),
(6437, 0, 3219, 'Total service request resolved', 0),
(6438, 1, 3219, 'Total service request resolved', 0),
(6439, 0, 3220, 'Table structure did not match', 0),
(6440, 1, 3220, 'Table structure did not match', 0),
(6441, 0, 3221, 'Total close / resolved incidents', 0),
(6442, 1, 3221, 'Total close / resolved incidents', 0),
(6443, 0, 3222, 'Change service request approve status', 0),
(6444, 1, 3222, 'Change service request approve status', 0),
(6445, 0, 3223, 'Service request forwarded', 0),
(6446, 1, 3223, 'Service request forwarded', 0),
(6447, 0, 3224, 'Total closed/resolved incident', 0),
(6448, 1, 3224, 'Total closed/resolved incident', 0),
(6449, 0, 3225, 'Total AVG. resolution', 0),
(6450, 1, 3225, 'Total AVG. resolution', 0),
(6451, 0, 3226, 'Visitor details', 0),
(6452, 1, 3226, 'Visitor details', 0),
(6453, 0, 3227, 'File attachment enable for staff', 0),
(6454, 1, 3227, 'File attachment enable for staff', 0),
(6455, 0, 3228, 'File attachment enable for client', 0),
(6456, 1, 3228, 'File attachment enable for client', 0),
(6457, 0, 3229, 'Live Chat access', 0),
(6458, 1, 3229, 'Live Chat access', 0),
(6459, 0, 3230, 'Live Chat', 0),
(6460, 1, 3230, 'Live Chat', 0),
(6461, 0, 3231, 'Take chat', 0),
(6462, 1, 3231, 'Take chat', 0),
(6463, 0, 3232, 'Forward chat', 0),
(6464, 1, 3232, 'Forward chat', 0),
(6465, 0, 3233, 'Join', 0),
(6466, 1, 3233, 'Join', 0),
(6467, 0, 3234, 'Join invisible', 0),
(6468, 1, 3234, 'Join invisible', 0),
(6469, 0, 3235, 'Invite operator', 0),
(6470, 1, 3235, 'Invite operator', 0),
(6471, 0, 3236, 'View chats', 0),
(6472, 1, 3236, 'View chats', 0),
(6473, 0, 3237, 'Visitor history', 0),
(6474, 1, 3237, 'Visitor history', 0),
(6475, 0, 3238, 'This will remove visitor history', 0),
(6476, 1, 3238, 'This will remove visitor history', 0),
(6477, 0, 3239, 'Enter key will send message', 0),
(6478, 1, 3239, 'Enter key will send message', 0),
(6479, 0, 3240, 'Connect to Live Chat', 0),
(6480, 1, 3240, 'Connect to Live Chat', 0),
(6481, 0, 3241, 'Active on chat', 0),
(6482, 1, 3241, 'Active on chat', 0),
(6483, 0, 3242, 'Chat status', 0),
(6484, 1, 3242, 'Chat status', 0),
(6485, 0, 3243, 'Busy', 0),
(6486, 1, 3243, 'Busy', 0),
(6487, 0, 3244, 'Away', 0),
(6488, 1, 3244, 'Away', 0),
(6489, 0, 3245, 'Chat setting', 0),
(6490, 1, 3245, 'Chat setting', 0),
(6491, 0, 3246, 'Auto acceptance', 0),
(6492, 1, 3246, 'Auto acceptance', 0),
(6493, 0, 3247, 'Show profile image', 0),
(6494, 1, 3247, 'Show profile image', 0),
(6495, 0, 3248, 'Referrer', 0),
(6496, 1, 3248, 'Referrer', 0),
(6497, 0, 3249, 'Visited pages', 0),
(6498, 1, 3249, 'Visited pages', 0),
(6499, 0, 3250, 'Visit time', 0),
(6500, 1, 3250, 'Visit time', 0),
(6501, 0, 3251, 'Latitude', 0),
(6502, 1, 3251, 'Latitude', 0),
(6503, 0, 3252, 'Longitude', 0),
(6504, 1, 3252, 'Longitude', 0),
(6505, 0, 3253, 'Browser', 0),
(6506, 1, 3253, 'Browser', 0),
(6507, 0, 3254, 'Queued message', 0),
(6508, 1, 3254, 'Queued message', 0),
(6509, 0, 3255, 'Offline message', 0),
(6510, 1, 3255, 'Offline message', 0),
(6511, 0, 3256, 'Display picture', 0),
(6512, 1, 3256, 'Display picture', 0),
(6513, 0, 3257, 'Chat widget', 0),
(6514, 1, 3257, 'Chat widget', 0),
(6515, 0, 3258, 'Greetings message', 0),
(6516, 1, 3258, 'Greetings message', 0),
(6517, 0, 3259, 'Max 200 character', 0),
(6518, 1, 3259, 'Max 200 character', 0),
(6519, 0, 3260, 'Max 100 character', 0),
(6520, 1, 3260, 'Max 100 character', 0),
(6521, 0, 3261, 'Prechat message', 0),
(6522, 1, 3261, 'Prechat message', 0),
(6523, 0, 3262, 'Prechat custom field', 0),
(6524, 1, 3262, 'Prechat custom field', 0),
(6525, 0, 3263, 'Update prechat custom field', 0),
(6526, 1, 3263, 'Update prechat custom field', 0),
(6527, 0, 3264, 'Live Chat widget ID', 0),
(6528, 1, 3264, 'Live Chat widget ID', 0),
(6529, 0, 3265, 'Add prechat custom field', 0),
(6530, 1, 3265, 'Add prechat custom field', 0),
(6531, 0, 3266, 'Add new prechat custom field', 0),
(6532, 1, 3266, 'Add new prechat custom field', 0),
(6533, 0, 3267, 'Delete prechat custom field', 0),
(6534, 1, 3267, 'Delete prechat custom field', 0),
(6535, 0, 3268, 'Live Chat code', 0),
(6536, 1, 3268, 'Live Chat code', 0),
(6537, 0, 3269, 'Chat views', 0),
(6538, 1, 3269, 'Chat views', 0),
(6539, 0, 3270, 'Ticket views', 0),
(6540, 1, 3270, 'Ticket views', 0),
(6541, 0, 3271, 'Add chat view', 0),
(6542, 1, 3271, 'Add chat view', 0),
(6543, 0, 3272, 'Visits', 0),
(6544, 1, 3272, 'Visits', 0),
(6545, 0, 3273, 'Live Chat hash generation', 0),
(6546, 1, 3273, 'Live Chat hash generation', 0),
(6547, 0, 3274, 'Device', 0),
(6548, 1, 3274, 'Device', 0),
(6549, 0, 3275, 'OS', 0),
(6550, 1, 3275, 'OS', 0),
(6551, 0, 3276, 'Useragent', 0),
(6552, 1, 3276, 'Useragent', 0),
(6553, 0, 3277, 'Continent', 0),
(6554, 1, 3277, 'Continent', 0),
(6555, 0, 3278, 'Country code', 0),
(6556, 1, 3278, 'Country code', 0),
(6557, 0, 3279, 'ISP', 0),
(6558, 1, 3279, 'ISP', 0),
(6559, 0, 3280, 'Business name', 0),
(6560, 1, 3280, 'Business name', 0),
(6561, 0, 3281, 'Business website', 0),
(6562, 1, 3281, 'Business website', 0),
(6563, 0, 3282, 'Chat visitors', 0),
(6564, 1, 3282, 'Chat visitors', 0),
(6565, 0, 3283, 'My chats', 0),
(6566, 1, 3283, 'My chats', 0),
(6567, 0, 3284, 'Online visitors', 0),
(6568, 1, 3284, 'Online visitors', 0),
(6569, 0, 3285, 'All chats', 0),
(6570, 1, 3285, 'All chats', 0),
(6571, 0, 3286, 'Live Chat prefix', 0),
(6572, 1, 3286, 'Live Chat prefix', 0),
(6573, 0, 3287, 'Subject line', 0),
(6574, 1, 3287, 'Subject line', 0),
(6575, 0, 3288, 'Inactivity time for staff', 0),
(6576, 1, 3288, 'Inactivity time for staff', 0),
(6577, 0, 3289, 'Inactivity time for visitor', 0),
(6578, 1, 3289, 'Inactivity time for visitor', 0),
(6579, 0, 3290, 'Live Chat hash prefix must be alphanumeric', 0),
(6580, 1, 3290, 'Live Chat hash prefix must be alphanumeric', 0),
(6581, 0, 3291, 'Live Chat hash prefix field is empty', 0),
(6582, 1, 3291, 'Live Chat hash prefix field is empty', 0),
(6583, 0, 3292, 'Total unresolved incidents', 0),
(6584, 1, 3292, 'Total unresolved incidents', 0),
(6585, 0, 3293, 'Accept chat', 0),
(6586, 1, 3293, 'Accept chat', 0),
(6587, 0, 3294, 'End chat', 0),
(6588, 1, 3294, 'End chat', 0),
(6589, 0, 3295, 'Are you sure you want to end this chat?', 0),
(6590, 1, 3295, 'Are you sure you want to end this chat?', 0),
(6591, 0, 3296, 'Leave chat', 0),
(6592, 1, 3296, 'Leave chat', 0),
(6593, 0, 3297, 'Can not delete client as client has ongoing chat', 0),
(6594, 1, 3297, 'Can not delete client as client has ongoing chat', 0),
(6595, 0, 3298, 'Sound notification', 0),
(6596, 1, 3298, 'Sound notification', 0),
(6597, 0, 3299, 'New chat', 0),
(6598, 1, 3299, 'New chat', 0),
(6599, 0, 3300, 'New message', 0),
(6600, 1, 3300, 'New message', 0),
(6601, 0, 3301, 'New visitor', 0),
(6602, 1, 3301, 'New visitor', 0),
(6603, 0, 3302, 'Send and receive message', 0),
(6604, 1, 3302, 'Send and receive message', 0),
(6605, 0, 3303, 'Default bill rate', 0),
(6606, 1, 3303, 'Default bill rate', 0),
(6607, 0, 3304, 'Are you sure you want to leave chat?', 0),
(6608, 1, 3304, 'Are you sure you want to leave chat?', 0),
(6609, 0, 3305, 'Available', 0),
(6610, 1, 3305, 'Available', 0),
(6611, 0, 3306, 'Start chat', 0),
(6612, 1, 3306, 'Start chat', 0),
(6613, 0, 3307, 'File not sent, please try again...!', 0),
(6614, 1, 3307, 'File not sent, please try again...!', 0),
(6615, 0, 3308, 'has joined the chat', 0),
(6616, 1, 3308, 'has joined the chat', 0),
(6617, 0, 3309, 'Message not sent, please try again...!', 0),
(6618, 1, 3309, 'Message not sent, please try again...!', 0),
(6619, 0, 3310, 'Task linked to problems', 0),
(6620, 1, 3310, 'Task linked to problems', 0),
(6621, 0, 3311, 'Task linked to changes', 0),
(6622, 1, 3311, 'Task linked to changes', 0),
(6623, 0, 3312, 'Task linked to releases', 0),
(6624, 1, 3312, 'Task linked to releases', 0),
(6625, 0, 3313, 'Live Chat article', 0),
(6626, 1, 3313, 'Live Chat article', 0),
(6627, 0, 3314, 'All article', 0),
(6628, 1, 3314, 'All article', 0),
(6629, 0, 3315, 'Custom field based task report', 0),
(6630, 1, 3315, 'Custom field based task report', 0),
(6631, 0, 3316, 'Chat has already ended', 0),
(6632, 1, 3316, 'Chat has already ended', 0),
(6633, 0, 3317, 'Task by priority', 0),
(6634, 1, 3317, 'Task by priority', 0),
(6635, 0, 3318, 'Time track based on bill rate', 0),
(6636, 1, 3318, 'Time track based on bill rate', 0),
(6637, 0, 3319, 'Incidents grouped by Live Chat', 0),
(6638, 1, 3319, 'Incidents grouped by Live Chat', 0),
(6639, 0, 3320, 'Your are offline', 0),
(6640, 1, 3320, 'Your are offline', 0),
(6641, 0, 3321, 'chat forwarded', 0),
(6642, 1, 3321, 'chat forwarded', 0),
(6643, 0, 3322, 'has forwarded the chat to', 0),
(6644, 1, 3322, 'has forwarded the chat to', 0),
(6645, 0, 3323, 'has invited chat to', 0),
(6646, 1, 3323, 'has invited chat to', 0),
(6647, 0, 3324, 'forward chat accepted', 0),
(6648, 1, 3324, 'forward chat accepted', 0),
(6649, 0, 3325, 'has accept the forwarded chat', 0),
(6650, 1, 3325, 'has accept the forwarded chat', 0),
(6651, 0, 3326, 'chat invited', 0),
(6652, 1, 3326, 'chat invited', 0),
(6653, 0, 3327, 'chat taken', 0),
(6654, 1, 3327, 'chat taken', 0),
(6655, 0, 3328, 'chat joined', 0),
(6656, 1, 3328, 'chat joined', 0),
(6657, 0, 3329, 'has taken the chat', 0),
(6658, 1, 3329, 'has taken the chat', 0),
(6659, 0, 3330, 'invite chat request accepted', 0),
(6660, 1, 3330, 'invite chat request accepted', 0),
(6661, 0, 3331, 'has joined invite the chat request', 0),
(6662, 1, 3331, 'has joined invite the chat request', 0),
(6663, 0, 3332, 'chat joined invisibly', 0),
(6664, 1, 3332, 'chat joined invisibly', 0),
(6665, 0, 3333, 'has joined the chat invisibly', 0),
(6666, 1, 3333, 'has joined the chat invisibly', 0),
(6667, 0, 3334, 'chat leaved', 0),
(6668, 1, 3334, 'chat leaved', 0),
(6669, 0, 3335, 'has leaved the chat', 0),
(6670, 1, 3335, 'has leaved the chat', 0),
(6671, 0, 3336, 'Display sub title', 0),
(6672, 1, 3336, 'Display sub title', 0),
(6673, 0, 3337, '[File uploaded]', 0),
(6674, 1, 3337, '[File uploaded]', 0),
(6675, 0, 3338, 'New message from', 0),
(6676, 1, 3338, 'New message from', 0),
(6677, 0, 3339, 'No Conversations...', 0),
(6678, 1, 3339, 'No Conversations...', 0),
(6679, 0, 3340, 'Chat is end', 0),
(6680, 1, 3340, 'Chat is end', 0),
(6681, 0, 3341, 'Chat started', 0),
(6682, 1, 3341, 'Chat started', 0),
(6683, 0, 3342, 'On date', 0),
(6684, 1, 3342, 'On date', 0),
(6685, 0, 3343, 'Staff left the chat', 0),
(6686, 1, 3343, 'Staff left the chat', 0),
(6687, 0, 3344, 'Missed chat - Client left the chat', 0),
(6688, 1, 3344, 'Missed chat - Client left the chat', 0),
(6689, 0, 3345, 'Missed chat - Staffs logout', 0),
(6690, 1, 3345, 'Missed chat - Staffs logout', 0),
(6691, 0, 3346, 'Missed chat - Staffs not available', 0),
(6692, 1, 3346, 'Missed chat - Staffs not available', 0),
(6693, 0, 3347, 'Forwarded the chat to', 0),
(6694, 1, 3347, 'Forwarded the chat to', 0),
(6695, 0, 3348, 'Category type', 0),
(6696, 1, 3348, 'Category type', 0),
(6697, 0, 3349, 'Theme Color', 0),
(6698, 1, 3349, 'Theme Color', 0),
(6699, 0, 3350, 'Show submit incident form if staff is offline', 0),
(6700, 1, 3350, 'Show submit incident form if staff is offline', 0),
(6701, 0, 3351, 'Append post', 0),
(6702, 1, 3351, 'Append post', 0),
(6703, 0, 3352, 'Forwarded by', 0),
(6704, 1, 3352, 'Forwarded by', 0),
(6705, 0, 3353, 'Sent', 0),
(6706, 1, 3353, 'Sent', 0),
(6707, 0, 3354, 'Sending...', 0),
(6708, 1, 3354, 'Sending...', 0),
(6709, 0, 3355, 'Thank you for submitting offline message, Our staff will get in touch with you as soon as possible', 0),
(6710, 1, 3355, 'Thank you for submitting offline message, Our staff will get in touch with you as soon as possible', 0),
(6711, 0, 3356, 'Order hash', 0),
(6712, 1, 3356, 'Order hash', 0),
(6713, 0, 3357, 'Am i helpful ?', 0),
(6714, 1, 3357, 'Am i helpful ?', 0),
(6715, 0, 3358, 'Update details', 0),
(6716, 1, 3358, 'Update details', 0),
(6717, 0, 3359, 'Enter OTP', 0),
(6718, 1, 3359, 'Enter OTP', 0),
(6719, 0, 3360, 'Resend OTP', 0),
(6720, 1, 3360, 'Resend OTP', 0),
(6721, 0, 3361, 'Please check your email OTP resent on your email-Id.', 0),
(6722, 1, 3361, 'Please check your email OTP resent on your email-Id.', 0),
(6723, 0, 3362, 'Please check your email OTP sent on your email-Id.', 0),
(6724, 1, 3362, 'Please check your email OTP sent on your email-Id.', 0),
(6725, 0, 3363, 'Something went wrong!!! We are reloading..', 0),
(6726, 1, 3363, 'Something went wrong!!! We are reloading..', 0),
(6727, 0, 3364, 'Invalid OTP', 0),
(6728, 1, 3364, 'Invalid OTP', 0),
(6729, 0, 3365, 'Client details updated', 0),
(6730, 1, 3365, 'Client details updated', 0),
(6731, 0, 3366, 'Forward on', 0),
(6732, 1, 3366, 'Forward on', 0),
(6733, 0, 3367, 'Network disconnected', 0),
(6734, 1, 3367, 'Network disconnected', 0),
(6735, 0, 3368, 'Reconnecting', 0),
(6736, 1, 3368, 'Reconnecting', 0),
(6737, 0, 3369, 'Initiate date', 0),
(6738, 1, 3369, 'Initiate date', 0),
(6739, 0, 3370, 'New chat from', 0),
(6740, 1, 3370, 'New chat from', 0),
(6741, 0, 3371, 'has started the chat', 0),
(6742, 1, 3371, 'has started the chat', 0),
(6743, 0, 3372, 'Department wise chat report', 0),
(6744, 1, 3372, 'Department wise chat report', 0),
(6745, 0, 3373, 'Missed chat', 0),
(6746, 1, 3373, 'Missed chat', 0),
(6747, 0, 3374, 'Completed chat', 0),
(6748, 1, 3374, 'Completed chat', 0),
(6749, 0, 3375, 'Total missed chat', 0),
(6750, 1, 3375, 'Total missed chat', 0),
(6751, 0, 3376, 'Total completed chat', 0),
(6752, 1, 3376, 'Total completed chat', 0),
(6753, 0, 3377, 'Total duration', 0),
(6754, 1, 3377, 'Total duration', 0),
(6755, 0, 3378, 'Missed chat department wise report', 0),
(6756, 1, 3378, 'Missed chat department wise report', 0),
(6757, 0, 3379, 'Completed chat department wise report', 0),
(6758, 1, 3379, 'Completed chat department wise report', 0),
(6759, 0, 3380, 'Staff wise chat report', 0),
(6760, 1, 3380, 'Staff wise chat report', 0),
(6761, 0, 3381, 'Visitor report', 0),
(6762, 1, 3381, 'Visitor report', 0),
(6763, 0, 3382, 'Referrer based report', 0),
(6764, 1, 3382, 'Referrer based report', 0),
(6765, 0, 3383, 'Visitor wise report', 0),
(6766, 1, 3383, 'Visitor wise report', 0),
(6767, 0, 3384, 'Completed chat staff wise report', 0),
(6768, 1, 3384, 'Completed chat staff wise report', 0),
(6769, 0, 3385, 'Client wise chat report', 0),
(6770, 1, 3385, 'Client wise chat report', 0),
(6771, 0, 3386, 'Organization wise chat report', 0),
(6772, 1, 3386, 'Organization wise chat report', 0),
(6773, 0, 3387, 'Time spent by client', 0),
(6774, 1, 3387, 'Time spent by client', 0),
(6775, 0, 3388, 'Client with max chats', 0),
(6776, 1, 3388, 'Client with max chats', 0),
(6777, 0, 3389, 'Custom report for visitors', 0),
(6778, 1, 3389, 'Custom report for visitors', 0),
(6779, 0, 3390, 'Prechat custom field report', 0),
(6780, 1, 3390, 'Prechat custom field report', 0),
(6781, 0, 3391, 'Switch to client', 0),
(6782, 1, 3391, 'Switch to client', 0),
(6783, 0, 3392, 'Missed chat staff wise report', 0),
(6784, 1, 3392, 'Missed chat staff wise report', 0),
(6785, 0, 3393, 'Staff forward chat report', 0),
(6786, 1, 3393, 'Staff forward chat report', 0),
(6787, 0, 3394, 'Staff productivity per chat report', 0),
(6788, 1, 3394, 'Staff productivity per chat report', 0),
(6789, 0, 3395, 'Visit pages wise visitor report', 0),
(6790, 1, 3395, 'Visit pages wise visitor report', 0),
(6791, 0, 3396, 'Missed chat reason', 0),
(6792, 1, 3396, 'Missed chat reason', 0),
(6793, 0, 3397, 'Time spend on chat', 0),
(6794, 1, 3397, 'Time spend on chat', 0),
(6795, 0, 3398, 'Can not merge client as client has ongoing chat.', 0),
(6796, 1, 3398, 'Can not merge client as client has ongoing chat.', 0),
(6797, 0, 3399, 'Can not merge contact as client has ongoing chat.', 0),
(6798, 1, 3399, 'Can not merge contact as client has ongoing chat.', 0),
(6799, 0, 3400, 'chat ended', 0),
(6800, 1, 3400, 'chat ended', 0),
(6801, 0, 3401, 'has ended the chat', 0),
(6802, 1, 3401, 'has ended the chat', 0),
(6803, 0, 3402, 'Mute', 0),
(6804, 1, 3402, 'Mute', 0),
(6805, 0, 3403, 'has left the chat', 0),
(6806, 1, 3403, 'has left the chat', 0),
(6807, 0, 3404, 'How may I help you today?', 0),
(6808, 1, 3404, 'How may I help you today?', 0),
(6809, 1, 3405, 'Route request to staff', 0),
(6810, 0, 3405, 'Route request to staff', 0),
(6811, 0, 3406, 'left the chat', 0),
(6812, 1, 3406, 'left the chat', 0),
(6813, 0, 3407, 'just now', 0),
(6814, 1, 3407, 'just now', 0),
(6815, 0, 3408, 'Chats', 0),
(6816, 1, 3408, 'Chats', 0),
(6817, 0, 3409, 'Ask for rating', 0),
(6818, 1, 3409, 'Ask for rating', 0),
(6819, 0, 3410, 'Chat rating', 0),
(6820, 1, 3410, 'Chat rating', 0),
(6821, 0, 3411, 'Rate this chat', 0),
(6822, 1, 3411, 'Rate this chat', 0),
(6823, 0, 3412, 'No rating', 0),
(6824, 1, 3412, 'No rating', 0),
(6825, 0, 3413, 'Smiley icon', 0),
(6826, 1, 3413, 'Smiley icon', 0),
(6827, 0, 3414, 'Star rating', 0),
(6828, 1, 3414, 'Star rating', 0),
(6829, 0, 3415, 'Bad', 0),
(6830, 1, 3415, 'Bad', 0),
(6831, 0, 3416, 'Good', 0),
(6832, 1, 3416, 'Good', 0),
(6833, 0, 3417, 'Average', 0),
(6834, 1, 3417, 'Average', 0),
(6835, 0, 3418, 'Rating type', 0),
(6836, 1, 3418, 'Rating type', 0),
(6837, 0, 3419, 'Rating request sent', 0),
(6838, 1, 3419, 'Rating request sent', 0),
(6839, 0, 3420, 'Total chat', 0),
(6840, 1, 3420, 'Total chat', 0),
(6841, 0, 3421, 'Total AVG spend time', 0),
(6842, 1, 3421, 'Total AVG spend time', 0),
(6843, 0, 3422, 'Left date', 0),
(6844, 1, 3422, 'Left date', 0),
(6845, 0, 3423, 'Total visitors', 0),
(6846, 1, 3423, 'Total visitors', 0),
(6847, 0, 3424, 'Numeric value required for Create invoice before (days) field', 0),
(6848, 1, 3424, 'Numeric value required for Create invoice before (days) field', 0),
(6849, 0, 3425, 'Create invoice before (days)', 0),
(6850, 1, 3425, 'Create invoice before (days)', 0),
(6851, 0, 3426, 'Billing log', 0),
(6852, 1, 3426, 'Billing log', 0),
(6853, 0, 3427, 'Staff joined', 0),
(6854, 1, 3427, 'Staff joined', 0),
(6855, 0, 3428, 'Delete billing log', 0),
(6856, 1, 3428, 'Delete billing log', 0),
(6857, 0, 3429, 'Empty billing log', 0),
(6858, 1, 3429, 'Empty billing log', 0),
(6859, 0, 3430, 'Incident category wise SLA', 0),
(6860, 1, 3430, 'Incident category wise SLA', 0),
(6861, 0, 3431, 'Organization wise SLA', 0),
(6862, 1, 3431, 'Organization wise SLA', 0),
(6863, 0, 3432, 'Prechat form', 0),
(6864, 1, 3432, 'Prechat form', 0),
(6865, 0, 3433, 'Canned responses', 0),
(6866, 1, 3433, 'Canned responses', 0),
(6867, 0, 3434, 'Incident type wise SLA', 0),
(6868, 1, 3434, 'Incident type wise SLA', 0),
(6869, 0, 3435, 'Incident priority wise SLA', 0),
(6870, 1, 3435, 'Incident priority wise SLA', 0),
(6871, 0, 3436, 'Incident or Service hash', 0),
(6872, 1, 3436, 'Incident or Service hash', 0),
(6873, 0, 3437, 'Visitor navigation report', 0),
(6874, 1, 3437, 'Visitor navigation report', 0),
(6875, 0, 3438, 'Page url', 0),
(6876, 1, 3438, 'Page url', 0),
(6877, 0, 3439, 'No. of hits', 0),
(6878, 1, 3439, 'No. of hits', 0),
(6879, 0, 3440, 'Private message', 0),
(6880, 1, 3440, 'Private message', 0),
(6881, 0, 3441, 'Message template', 0),
(6882, 1, 3441, 'Message template', 0),
(6883, 0, 3442, 'Show online staff bar', 0),
(6884, 1, 3442, 'Show online staff bar', 0),
(6885, 0, 3443, 'End chat on idle (in minutes)', 0),
(6886, 1, 3443, 'End chat on idle (in minutes)', 0),
(6887, 0, 3444, 'Max chat acceptance limit', 0),
(6888, 1, 3444, 'Max chat acceptance limit', 0),
(6889, 0, 3445, 'Chat display name', 0),
(6890, 1, 3445, 'Chat display name', 0),
(6891, 0, 3446, 'Set display name', 0),
(6892, 1, 3446, 'Set display name', 0),
(6893, 0, 3447, 'Chat automation', 0),
(6894, 1, 3447, 'Chat automation', 0),
(6895, 0, 3448, 'Chat messages', 0),
(6896, 1, 3448, 'Chat messages', 0),
(6897, 0, 3449, 'is mandatory Privacy policy / GDPR ?', 0),
(6898, 1, 3449, 'is mandatory Privacy policy / GDPR ?', 0),
(6899, 0, 3450, 'SLA plan based report', 0),
(6900, 1, 3450, 'SLA plan based report', 0),
(6901, 0, 3451, 'No of chat / visitor', 0),
(6902, 1, 3451, 'No of chat / visitor', 0),
(6903, 1, 3452, 'I have read and agree to', 0),
(6904, 0, 3452, 'I have read and agree to', 0),
(6905, 1, 3453, 'Privacy policy accepted on', 0),
(6906, 0, 3453, 'Privacy policy accepted on', 0),
(6907, 1, 3454, 'Check privacy policy as data is provided', 0),
(6908, 0, 3454, 'Check privacy policy as data is provided', 0),
(6909, 1, 3455, 'Add a file from...', 0),
(6910, 0, 3455, 'Add a file from...', 0),
(6911, 1, 3457, 'Your computer', 0),
(6912, 0, 3457, 'Your computer', 0),
(6913, 1, 3458, 'Route request to team', 0),
(6914, 0, 3458, 'Route request to team', 0),
(6915, 1, 3459, 'Day wise report', 0),
(6916, 0, 3459, 'Day wise report', 0),
(6917, 1, 3460, 'Hourly base report', 0),
(6918, 0, 3460, 'Hourly base report', 0),
(6919, 1, 3461, 'Chat per visitor', 0),
(6920, 0, 3461, 'Chat per visitor', 0),
(6921, 1, 3462, 'Chat initiated from', 0),
(6922, 0, 3462, 'Chat initiated from', 0),
(6923, 1, 3463, 'Enter subject', 0),
(6924, 0, 3463, 'Enter subject', 0),
(6925, 1, 3464, 'Page visit', 0),
(6926, 0, 3464, 'Page visit', 0),
(6927, 1, 3465, 'Chat initiate', 0),
(6928, 0, 3465, 'Chat initiate', 0),
(6929, 1, 3466, 'Chat closing', 0),
(6930, 0, 3466, 'Chat closing', 0),
(6931, 1, 3467, 'Update chat automation', 0),
(6932, 0, 3467, 'Update chat automation', 0),
(6933, 1, 3468, 'Add chat automation', 0),
(6934, 0, 3468, 'Add chat automation', 0),
(6935, 1, 3469, 'Ongoing Chats', 0),
(6936, 0, 3469, 'Ongoing Chats', 0),
(6937, 1, 3470, 'Page revisit', 0),
(6938, 0, 3470, 'Page revisit', 0),
(6939, 1, 3471, 'Idle time', 0),
(6940, 0, 3471, 'Idle time', 0),
(6941, 1, 3472, 'New visit', 0),
(6942, 0, 3472, 'New visit', 0),
(6943, 1, 3473, 'Page title', 0),
(6944, 0, 3473, 'Page title', 0),
(6945, 1, 3474, 'Online time', 0),
(6946, 0, 3474, 'Online time', 0),
(6947, 1, 3475, 'Chat forward request', 0),
(6948, 0, 3475, 'Chat forward request', 0),
(6949, 1, 3476, 'Chat invitation', 0),
(6950, 0, 3476, 'Chat invitation', 0),
(6951, 1, 3477, 'Invited by', 0),
(6952, 0, 3477, 'Invited by', 0),
(6953, 1, 3478, 'Staff disconnected', 0),
(6954, 0, 3478, 'Staff disconnected', 0),
(6955, 1, 3479, 'Enable Live Chat agent', 0),
(6956, 0, 3479, 'Enable Live Chat agent', 0),
(6957, 1, 3480, 'Rate must be numeric', 0),
(6958, 0, 3480, 'Rate must be numeric', 0),
(6959, 1, 3481, 'Calculate time track', 0),
(6960, 0, 3481, 'Calculate time track', 0),
(6961, 1, 3482, 'Updating CI type may delete some data of asset. <br />Are you sure you want to proceed?', 0),
(6962, 0, 3482, 'Updating CI type may delete some data of asset. <br />Are you sure you want to proceed?', 0),
(6963, 1, 3483, 'Show status on end chat', 0),
(6964, 0, 3483, 'Show status on end chat', 0),
(6965, 1, 3484, 'Invite', 0),
(6966, 0, 3484, 'Invite', 0),
(6967, 1, 3485, 'Visitor''s map', 0),
(6968, 0, 3485, 'Visitor''s map', 0),
(6969, 1, 3486, 'Rating received', 0),
(6970, 0, 3486, 'Rating received', 0),
(6971, 0, 3487, 'PC user', 1),
(6972, 1, 3487, 'PC user', 1),
(6973, 0, 3488, 'Must be numeric and greater than 0', 1),
(6974, 1, 3488, 'Must be numeric and greater than 0', 1),
(6975, 0, 3489, 'Note: Role accesses are applicable as per the selected product only.', 0),
(6976, 1, 3489, 'Note: Role accesses are applicable as per the selected product only.', 0),
(6977, 0, 3490, 'Multiple domains not applicable to the selected product', 0),
(6978, 1, 3490, 'Multiple domains not applicable to the selected product', 0),
(6979, 0, 3491, 'Actual department wise sla report', 0),
(6980, 1, 3491, 'Actual department wise sla report', 0),
(6981, 0, 3492, 'Multiple domains not applicable to the team assigned to PROHD staff', 0),
(6982, 1, 3492, 'Multiple domains not applicable to the team assigned to PROHD staff', 0),
(6983, 0, 3493, 'All staff chat count', 0),
(6984, 1, 3493, 'All staff chat count', 0),
(6985, 0, 3494, 'Virtual agent not available', 0),
(6986, 1, 3494, 'Virtual agent not available', 0),
(6987, 0, 3495, 'Virtual agent feedback report', 0),
(6988, 1, 3495, 'Virtual agent feedback report', 0),
(6989, 0, 3496, 'Is helpful? (No)', 0),
(6990, 1, 3496, 'Is helpful? (No)', 0),
(6991, 0, 3497, 'Is helpful? (Yes)', 0),
(6992, 1, 3497, 'Is helpful? (Yes)', 0),
(6993, 0, 3498, 'Mapped', 0),
(6994, 1, 3498, 'Mapped', 0),
(6995, 0, 3499, 'Not mapped', 0),
(6996, 1, 3499, 'Not mapped', 0),
(6997, 0, 3500, 'Articles count', 0),
(6998, 1, 3500, 'Articles count', 0),
(6999, 0, 3501, 'Keyword will get deleted from all the articles.<br/>Are you sure you want to proceed?', 0),
(7000, 1, 3501, 'Keyword will get deleted from all the articles.<br/>Are you sure you want to proceed?', 0),
(7001, 0, 3502, 'Mapped articles', 0),
(7002, 1, 3502, 'Mapped articles', 0),
(7003, 0, 3503, 'Select categories', 0),
(7004, 1, 3503, 'Select categories', 0),
(7005, 0, 3504, 'Map', 0),
(7006, 1, 3504, 'Map', 0),
(7007, 0, 3505, 'Keyword', 0),
(7008, 1, 3505, 'Keyword', 0),
(7009, 0, 3506, 'Create new incident and close', 0),
(7010, 1, 3506, 'Create new incident and close', 0),
(7011, 0, 3507, 'Day report', 0),
(7012, 1, 3507, 'Day report', 0),
(7013, 0, 3508, 'Append', 0),
(7014, 1, 3508, 'Append', 0),
(7015, 0, 3509, 'Visitors', 0),
(7016, 1, 3509, 'Visitors', 0),
(7017, 0, 3510, 'Staff wise availability', 0),
(7018, 1, 3510, 'Staff wise availability', 0),
(7019, 0, 3511, 'Search engines', 0),
(7020, 1, 3511, 'Search engines', 0),
(7021, 0, 3512, 'Department wise availability', 0),
(7022, 1, 3512, 'Department wise availability', 0),
(7023, 0, 3513, 'Staff accepted chat', 0),
(7024, 1, 3513, 'Staff accepted chat', 0),
(7025, 0, 3514, 'Search phrases', 0),
(7026, 1, 3514, 'Search phrases', 0),
(7027, 0, 3515, 'Entry pages', 0),
(7028, 1, 3515, 'Entry pages', 0),
(7029, 0, 3516, 'Referrers (URL)', 0),
(7030, 1, 3516, 'Referrers (URL)', 0),
(7031, 0, 3517, 'Show emoji', 0),
(7032, 1, 3517, 'Show emoji', 0),
(7033, 0, 3518, 'Enable end chat for client', 0),
(7034, 1, 3518, 'Enable end chat for client', 0),
(7035, 0, 3519, 'Append and close', 0),
(7036, 1, 3519, 'Append and close', 0),
(7037, 0, 3520, 'Number of Live Chat agent', 0),
(7038, 1, 3520, 'Number of Live Chat agent', 0),
(7039, 0, 3521, 'Live Chat license expiry date', 0),
(7040, 1, 3521, 'Live Chat license expiry date', 0),
(7041, 0, 3522, 'Chat log', 0),
(7042, 1, 3522, 'Chat log', 0),
(7043, 0, 3523, 'Remove chat log before selected date', 0),
(7044, 1, 3523, 'Remove chat log before selected date', 0),
(7045, 0, 3524, 'Live Chat agent', 0),
(7046, 1, 3524, 'Live Chat agent', 0),
(7047, 0, 3525, 'Dashboard and day report for manager', 0),
(7048, 1, 3525, 'Dashboard and day report for manager', 0),
(7049, 0, 3526, 'Delete chat', 0),
(7050, 1, 3526, 'Delete chat', 0),
(7051, 0, 3527, 'Remove discarded chat before selected date', 0),
(7052, 1, 3527, 'Remove discarded chat before selected date', 0),
(7053, 0, 3528, 'Staff not available', 0),
(7054, 1, 3528, 'Staff not available', 0),
(7055, 0, 3529, 'Queue message', 0),
(7056, 1, 3529, 'Queue message', 0),
(7057, 0, 3530, 'Staff left', 0),
(7058, 1, 3530, 'Staff left', 0),
(7059, 0, 3531, 'Client left', 0),
(7060, 1, 3531, 'Client left', 0),
(7061, 0, 3532, 'Discard chat log', 0),
(7062, 1, 3532, 'Discard chat log', 0),
(7063, 0, 3533, 'This conversation or transcript will be deleted from system.', 0),
(7064, 1, 3533, 'This conversation or transcript will be deleted from system.', 0),
(7065, 0, 3534, 'Queue', 0),
(7066, 1, 3534, 'Queue', 0),
(7067, 0, 3535, 'Awaiting chat(s) in queue', 0),
(7068, 1, 3535, 'Awaiting chat(s) in queue', 0),
(7069, 0, 3536, 'Show typing visibility', 0),
(7070, 1, 3536, 'Show typing visibility', 0),
(7071, 0, 3537, 'Show tags and label on end chat', 0),
(7072, 1, 3537, 'Show tags and label on end chat', 0),
(7073, 0, 3538, 'Show client typing text', 0),
(7074, 1, 3538, 'Show client typing text', 0),
(7075, 0, 3539, 'Save canned response', 0),
(7076, 1, 3539, 'Save canned response', 0),
(7077, 0, 3540, 'IP geo location key', 0),
(7078, 1, 3540, 'IP geo location key', 0),
(7079, 0, 3541, 'Save reply as canned response', 0),
(7080, 1, 3541, 'Save reply as canned response', 0),
(7081, 0, 3542, 'Canned response text', 0),
(7082, 1, 3542, 'Canned response text', 0),
(7083, 0, 3543, 'Shortcuts (hit enter to add another one)', 0),
(7084, 1, 3543, 'Shortcuts (hit enter to add another one)', 0),
(7085, 0, 3544, 'To use the canned response in a chat,type # and your shortcut', 0),
(7086, 1, 3544, 'To use the canned response in a chat,type # and your shortcut', 0),
(7087, 0, 3545, 'Enable livechat script', 0),
(7088, 1, 3545, 'Enable livechat script', 0),
(7089, 0, 3546, 'Ask for details', 0),
(7090, 1, 3546, 'Ask for details', 0),
(7091, 0, 3547, 'Chat survey', 0),
(7092, 1, 3547, 'Chat survey', 0),
(7093, 0, 3548, 'Chat survey field', 0),
(7094, 1, 3548, 'Chat survey field', 0),
(7095, 0, 3549, 'Add chat survey field', 0),
(7096, 1, 3549, 'Add chat survey field', 0),
(7097, 0, 3550, 'Delete chat survey field', 0),
(7098, 1, 3550, 'Delete chat survey field', 0),
(7099, 0, 3551, 'Update chat survey field', 0),
(7100, 1, 3551, 'Update chat survey field', 0),
(7101, 0, 3552, 'Chat survey details', 0),
(7102, 1, 3552, 'Chat survey details', 0),
(7103, 0, 3553, 'Chat survey date', 0),
(7104, 1, 3553, 'Chat survey date', 0),
(7105, 0, 3554, 'Select / Deselect all', 0),
(7106, 1, 3554, 'Select / Deselect all', 0),
(7107, 0, 3555, 'Incident Credit', 0),
(7108, 1, 3555, 'Incident Credit', 0),
(7109, 0, 3556, 'Acknowledgement', 0),
(7110, 1, 3556, 'Acknowledgement', 0),
(7111, 0, 3557, 'Acceptable Status', 0),
(7112, 1, 3557, 'Acceptable Status', 0),
(7113, 0, 4000, 'Service request first response report', 0),
(7114, 1, 4000, 'Service request first response report', 0),
(7115, 0, 4001, 'Free', 0),
(7116, 1, 4001, 'Free', 0),
(7117, 0, 4002, 'Prepaid', 0),
(7118, 1, 4002, 'Prepaid', 0),
(7119, 0, 4003, 'Postpaid', 0),
(7120, 1, 4003, 'Postpaid', 0),
(7121, 0, 4004, 'Role asssignment', 0),
(7122, 1, 4004, 'Role asssignment', 0),
(7123, 0, 4005, 'Stage completion', 0),
(7124, 1, 4005, 'Stage completion', 0),
(7125, 0, 4006, 'Update problem known error', 0),
(7126, 1, 4006, 'Update problem known error', 0),
(7127, 0, 4007, 'Hybrid', 0),
(7128, 1, 4007, 'Hybrid', 0),
(7129, 0, 4008, 'Total tax', 0),
(7130, 1, 4008, 'Total tax', 0),
(7131, 0, 4009, 'Track as asset', 0),
(7132, 1, 4009, 'Track as asset', 0),
(7133, 0, 4010, 'Reset theme', 0),
(7134, 1, 4010, 'Reset theme', 0),
(7135, 0, 4011, 'Primary lightest color', 0),
(7136, 1, 4011, 'Primary lightest color', 0),
(7137, 0, 4012, 'Primary color', 0),
(7138, 1, 4012, 'Primary color', 0),
(7139, 0, 4013, 'Update property', 0),
(7140, 1, 4013, 'Update property', 0),
(7141, 0, 4014, 'Subclient', 0),
(7142, 1, 4014, 'Subclient', 0),
(7143, 0, 4015, 'Editor', 0),
(7144, 1, 4015, 'Editor', 0),
(7145, 0, 4016, 'Type subject here atleast 3 words', 0),
(7146, 1, 4016, 'Type subject here atleast 3 words', 0),
(7147, 0, 4017, 'Type to search from existing data', 0),
(7148, 1, 4017, 'Type to search from existing data', 0),
(7149, 0, 4018, 'Update properties', 0),
(7150, 1, 4018, 'Update properties', 0),
(7151, 0, 4019, 'Bold', 0),
(7152, 1, 4019, 'Bold', 0),
(7153, 0, 4020, 'Italic', 0),
(7154, 1, 4020, 'Italic', 0),
(7155, 0, 4021, 'Staff portal theme', 0),
(7156, 1, 4021, 'Staff portal theme', 0),
(7157, 0, 4022, 'Logo', 0),
(7158, 1, 4022, 'Logo', 0),
(7159, 0, 4023, 'Group', 0),
(7160, 1, 4023, 'Group', 0),
(7161, 0, 4024, 'Oldest', 0),
(7162, 1, 4024, 'Oldest', 0),
(7163, 0, 4025, 'Newest', 0),
(7164, 1, 4025, 'Newest', 0),
(7165, 0, 4026, 'See all the notifications', 0),
(7166, 1, 4026, 'See all the notifications', 0),
(7167, 0, 4027, 'Upload file', 0),
(7168, 1, 4027, 'Upload file', 0),
(7169, 0, 4028, 'Authorize', 0),
(7170, 1, 4028, 'Authorize', 0),
(7171, 0, 4029, 'Out of scope', 0),
(7172, 1, 4029, 'Out of scope', 0),
(7173, 0, 4030, 'Remove', 0),
(7174, 1, 4030, 'Remove', 0),
(7175, 0, 4031, 'Quick setup', 0),
(7176, 1, 4031, 'Quick setup', 0),
(7177, 0, 4032, 'Branding', 0),
(7178, 1, 4032, 'Branding', 0),
(7179, 0, 4033, 'Remind letter', 0),
(7180, 1, 4033, 'Remind letter', 0),
(7181, 0, 4034, 'Dont ask me again', 0),
(7182, 1, 4034, 'Dont ask me again', 0),
(7183, 0, 4035, 'Search staff or group', 0),
(7184, 1, 4035, 'Search staff or group', 0),
(7185, 0, 4036, 'Use personal meeting ID', 0),
(7186, 1, 4036, 'Use personal meeting ID', 0),
(7187, 0, 4037, 'Welcome to blab widgets', 0),
(7188, 1, 4037, 'Welcome to blab widgets', 0),
(7189, 0, 4038, 'Create group', 0),
(7190, 1, 4038, 'Create group', 0),
(7191, 0, 4039, 'Enter group name', 0),
(7192, 1, 4039, 'Enter group name', 0),
(7193, 0, 4040, 'Whole phrase', 0),
(7194, 1, 4040, 'Whole phrase', 0),
(7195, 0, 4041, 'Error in create group', 0),
(7196, 1, 4041, 'Error in create group', 0),
(7197, 0, 4042, 'Chat & collaborate with your team.', 0),
(7198, 1, 4042, 'Chat & collaborate with your team.', 0),
(7199, 0, 4043, 'Sent email tracking', 0),
(7200, 1, 4043, 'Sent email tracking', 0),
(7201, 0, 4044, 'Releases grouped by status', 0),
(7202, 1, 4044, 'Releases grouped by status', 0),
(7203, 0, 4045, 'Releases grouped by priority', 0),
(7204, 1, 4045, 'Releases grouped by priority', 0),
(7205, 0, 4046, 'Releases grouped by impact', 0),
(7206, 1, 4046, 'Releases grouped by impact', 0),
(7207, 0, 4047, 'Happy customer', 0),
(7208, 1, 4047, 'Happy customer', 0),
(7209, 0, 4048, 'Unhappy customer', 0),
(7210, 1, 4048, 'Unhappy customer', 0),
(7211, 0, 4049, 'Fetch Staff IP address using API', 0),
(7212, 1, 4049, 'Fetch Staff IP address using API', 0),
(7213, 0, 4050, 'Brute force attack IP ban', 0),
(7214, 1, 4050, 'Brute force attack IP ban', 0),
(7215, 0, 4051, 'Max incorrect login attempt', 0),
(7216, 1, 4051, 'Max incorrect login attempt', 0),
(7217, 0, 4052, 'Forced expire staff password', 0),
(7218, 1, 4052, 'Forced expire staff password', 0),
(7219, 0, 4053, 'Expire password in (days)', 0),
(7220, 1, 4053, 'Expire password in (days)', 0),
(7221, 0, 4054, 'Your password has been expired. Please enter your email to reset the password.', 0),
(7222, 1, 4054, 'Your password has been expired. Please enter your email to reset the password.', 0),
(7223, 0, 4055, 'Note: For SaaS or Load balancer setup, please enable the Fetch Staff IP address using API setting under the IP security tab.', 0),
(7224, 1, 4055, 'Note: For SaaS or Load balancer setup, please enable the Fetch Staff IP address using API setting under the IP security tab.', 0),
(7225, 0, 4056, 'password should not be same as username', 0),
(7226, 1, 4056, 'password should not be same as username', 0),
(7227, 0, 4057, 'Please select at least one', 0),
(7228, 1, 4057, 'Please select at least one', 0),
(7229, 0, 4058, 'Assets custom field report', 0),
(7230, 1, 4058, 'Assets custom field report', 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_language_variables`
--

CREATE TABLE `avis_language_variables` (
  `variable_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext,
  `location_area` int(11) DEFAULT '0',
  `is_itil` int(11) NOT NULL DEFAULT '0',
  `default_id` int(11) DEFAULT '0',
  `is_custom` int(11) NOT NULL DEFAULT '0',
  `module_id` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`variable_id`),
  KEY `variable_id` (`variable_id`),
  KEY `location_area` (`location_area`),
  KEY `is_itil` (`is_itil`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3616 ;

--
-- Dumping data for table `avis_language_variables`
--

INSERT INTO `avis_language_variables` VALUES
(1, 'ADDIPORRANGE', 2, 0, 1, 0, 8),
(2, 'TXTLOGIN', 1, 0, 2, 0, 0),
(3, 'TXTAPPROVALPENDING', 1, 0, 3, 0, 0),
(4, 'TXTFORGOTPASSWORD', 1, 0, 4, 0, 0),
(5, 'TXTREGISTER', 1, 0, 5, 0, 0),
(6, 'TXTSELFHELP', 1, 0, 6, 0, 0),
(7, 'TXTPOSTEDBY', 1, 0, 7, 0, 4),
(8, 'TXTPOSTON', 1, 0, 8, 0, 0),
(9, 'TXTTICKETS', 1, 0, 9, 0, 0),
(10, 'TXTCREATIONDATE', 1, 0, 10, 0, 0),
(11, 'TXTMODIFIEDON', 1, 0, 11, 0, 0),
(12, 'MSGDATANOTFND', 1, 0, 12, 0, 0),
(13, 'TXTCHNGPASS', 1, 0, 13, 0, 0),
(14, 'TXTOLDPASSWORD', 1, 0, 14, 0, 0),
(15, 'TXTNEWPASSWORD', 1, 0, 15, 0, 0),
(16, 'TXTCONFIRMNEWPASSWORD', 1, 0, 16, 0, 0),
(17, 'TXTUPDATE', 1, 0, 17, 0, 0),
(18, 'TXTCLEAR', 1, 0, 18, 0, 0),
(19, 'MSGCLTEMAILEXIST', 1, 0, 19, 0, 0),
(20, 'TXTADDCONTACT', 1, 0, 20, 0, 0),
(21, 'TXTFIRSTNAME', 1, 0, 21, 0, 0),
(22, 'TXTLASTNAME', 1, 0, 22, 0, 0),
(23, 'TXTEMAIL', 1, 0, 23, 0, 0),
(24, 'TXTUSERNAME', 1, 0, 24, 0, 0),
(25, 'TXTPASSWORD', 1, 0, 25, 0, 0),
(26, 'TXTACCESS', 1, 0, 26, 0, 0),
(27, 'TXTTKTPSTGRM', 1, 0, 27, 0, 3),
(28, 'TXTRTKTPSTGRM', 1, 0, 28, 0, 3),
(29, 'TXTADD', 1, 0, 29, 0, 0),
(30, 'TXTRESET', 1, 0, 30, 0, 0),
(31, 'TXTCUSTOMFIELDS', 1, 0, 31, 0, 0),
(32, 'TXTSUBMIT', 1, 0, 32, 0, 0),
(33, 'MSGBALFORINV', 1, 0, 33, 0, 5),
(34, 'TXTPAYNOW', 1, 0, 34, 0, 5),
(35, 'TXTHOME', 1, 0, 35, 0, 0),
(36, 'TXTSUBMITTICKET', 1, 0, 36, 0, 0),
(37, 'TXTVIEWTICKETS', 1, 0, 37, 0, 0),
(38, 'TXTPURCHASE', 1, 0, 38, 0, 0),
(39, 'TXTMYPRODUCTS', 1, 0, 39, 0, 0),
(40, 'TXTMYINVOICES', 1, 0, 40, 0, 0),
(41, 'TXTSELFHELPTICKETSEARCH', 1, 0, 41, 0, 0),
(42, 'TXTSEARCH', 1, 0, 42, 0, 0),
(43, 'TXTPROFILE', 1, 0, 43, 0, 0),
(44, 'TXTCONTACTS', 1, 0, 44, 0, 0),
(45, 'TXTLOGOUT', 1, 0, 45, 0, 0),
(46, 'TXTUNPAID', 1, 0, 46, 0, 0),
(47, 'TXTPAID', 1, 0, 47, 0, 0),
(48, 'TXTCANCELED', 1, 0, 48, 0, 0),
(49, 'TXTINPROCESS', 1, 0, 49, 0, 0),
(50, 'TXTINVOICE', 1, 0, 50, 0, 0),
(51, 'TXTGETPDF', 1, 0, 51, 0, 0),
(52, 'TXTPHONE', 1, 0, 52, 0, 0),
(53, 'TXTINVOICEID', 1, 0, 53, 0, 0),
(54, 'TXTDUEDATE', 1, 0, 54, 0, 0),
(55, 'TXTSTATUS', 1, 0, 55, 0, 0),
(56, 'TXTPAIDDATE', 1, 0, 56, 0, 0),
(57, 'TXTDESCRIPTION', 1, 0, 57, 0, 0),
(58, 'TXTAMOUNT', 1, 0, 58, 0, 0),
(59, 'TXTTAXX', 1, 0, 59, 0, 0),
(60, 'TXTTOTALDUE', 1, 0, 60, 0, 0),
(61, 'TXTTRANSACTIONID', 1, 0, 61, 0, 0),
(62, 'TXTTRANSACTIONDATE', 1, 0, 62, 0, 0),
(63, 'TXTCREATEDATE', 1, 0, 63, 0, 0),
(64, 'TXTTOTAL', 1, 0, 64, 0, 0),
(65, 'TXTTITLE', 1, 0, 65, 0, 0),
(66, 'TXTBILLINGCYCLE', 1, 0, 66, 0, 0),
(67, 'TXTEXPIRYDATE', 1, 0, 67, 0, 0),
(68, 'TXTVALIDITY', 1, 0, 68, 0, 0),
(69, 'TXTORDERNOW', 1, 0, 69, 0, 0),
(70, 'TXTUPDATEPROFILE', 1, 0, 70, 0, 0),
(71, 'TXTPROFILEIMG', 1, 0, 71, 0, 0),
(72, 'TXTUPLOADIMG', 1, 0, 72, 0, 0),
(73, 'TXTADDRESS', 1, 0, 73, 0, 0),
(74, 'TXTCITY', 1, 0, 74, 0, 0),
(75, 'TXTSTATE', 1, 0, 75, 0, 0),
(76, 'TXTZIPCODE', 1, 0, 76, 0, 0),
(77, 'TXTCOUNTRY', 1, 0, 77, 0, 0),
(78, 'TXTWEBSITE', 1, 0, 78, 0, 0),
(79, 'TXTDEPARTMENT', 1, 0, 79, 0, 0),
(80, 'TXTJOBTITLE', 1, 0, 80, 0, 0),
(81, 'TXTCOMPANYWEBSITE', 1, 0, 81, 0, 0),
(82, 'TXTLANGUAGE', 1, 0, 82, 0, 0),
(83, 'TXTCONTACTNUMBER', 1, 0, 83, 0, 0),
(84, 'TXTIMGVERIFY', 1, 0, 84, 0, 0),
(85, 'TXTTYPTWWRD', 1, 0, 85, 0, 0),
(86, 'TXTREFRESH', 1, 0, 86, 0, 0),
(87, 'TXTSAVE', 1, 0, 87, 0, 0),
(88, 'TXTATTACHMENTS', 1, 0, 88, 0, 0),
(89, 'TXTRATING', 1, 0, 89, 0, 0),
(90, 'TXTLEAVECOMMENT', 1, 0, 90, 0, 0),
(91, 'TXTFULLNAME', 1, 0, 91, 0, 0),
(92, 'TXTSUGGESTION', 1, 0, 92, 0, 0),
(93, 'TXTANSWER', 1, 0, 93, 0, 4),
(94, 'TXTRECENTARTICLES', 1, 0, 94, 0, 0),
(95, 'TXTFEATUREDARTICLES', 1, 0, 95, 0, 0),
(96, 'TXTADDARTICLE', 1, 0, 96, 0, 0),
(97, 'TXTDETAILS', 1, 0, 97, 0, 0),
(98, 'MSGWELCOMELINE', 1, 0, 98, 0, 2),
(99, 'TXTUPDATECONTACT', 1, 0, 99, 0, 0),
(100, 'MSGCLTDELETE', 1, 0, 100, 0, 0),
(101, 'TXTDELETE', 1, 0, 101, 0, 0),
(102, 'TXTCOMPANYNAME', 1, 0, 102, 0, 0),
(103, 'TXTREGISTRATIONREQUIRED', 1, 0, 103, 0, 0),
(104, 'MSGSUCCOTKT', 1, 0, 104, 0, 2),
(105, 'TXTPRIORITY', 1, 0, 105, 0, 0),
(106, 'TXTTYPE', 1, 0, 106, 0, 0),
(107, 'TXTSUBJECT', 1, 0, 107, 0, 0),
(108, 'TXTMESSAGE', 1, 0, 108, 0, 0),
(109, 'TXTATTACHFILE', 1, 0, 109, 0, 0),
(110, 'TXTEDITPROFILE', 1, 0, 110, 0, 0),
(111, 'TXTBANNED', 1, 0, 111, 0, 0),
(112, 'TXTDOMAIN', 1, 0, 112, 0, 0),
(113, 'TXTPARENT', 1, 0, 113, 0, 0),
(114, 'TXTORGANIZATION', 1, 0, 114, 0, 0),
(115, 'TXTUNSOLVED', 1, 0, 115, 0, 0),
(116, 'TXTSOLVED', 1, 0, 116, 0, 0),
(117, 'TXTBILLING', 1, 0, 117, 0, 0),
(118, 'TXTCASHBAL', 1, 0, 118, 0, 5),
(119, 'TXTRPTRCATGRYTITLE', 1, 0, 119, 0, 7),
(120, 'TXTUSERFEEDBACK', 1, 0, 120, 0, 0),
(121, 'TXTCREATEDON', 1, 0, 121, 0, 0),
(122, 'TXTTICKETTYPE', 1, 0, 122, 0, 0),
(123, 'TXTASSIGNTO', 1, 0, 123, 0, 0),
(124, 'TXTRPTRRESOLVED', 1, 0, 124, 0, 0),
(125, 'TXTOVERDUE', 1, 0, 125, 0, 0),
(126, 'TXTUNDUE', 1, 0, 126, 0, 0),
(127, 'TXTTICKETDETAILS', 1, 0, 127, 0, 0),
(128, 'TXTREPLYTICKET', 1, 0, 128, 0, 0),
(129, 'TXTEDITTICKET', 1, 0, 129, 0, 2),
(130, 'TXTSENDFEEDBACK', 1, 0, 130, 0, 0),
(131, 'TXTTICKETHASH', 1, 0, 131, 0, 0),
(132, 'TXTSTAFF', 1, 0, 132, 0, 0),
(133, 'TXTCLIENTS', 1, 0, 133, 0, 0),
(134, 'TXTCHANGEPRIORITY', 1, 0, 134, 0, 0),
(135, 'TXTCANCEL', 1, 0, 135, 0, 0),
(136, 'TXTPAGE', 1, 0, 136, 0, 0),
(137, 'TXTRPTRPENDINGUSR', 2, 0, 137, 0, 3),
(138, 'TXTRELEASEMNGTSUPPORT', 2, 1, 138, 0, 0),
(139, 'TXTADMINTYPE', 2, 0, 139, 0, 8),
(140, 'TXTDOMAINADMIN', 2, 0, 140, 0, 8),
(141, 'TXTSUPERADMIN', 2, 0, 141, 0, 8),
(142, 'TXTADMINACCESS', 2, 0, 142, 0, 0),
(143, 'TXTRELEASEPLANNING', 2, 1, 143, 0, 0),
(144, 'TXTADDSTAFF', 2, 0, 144, 0, 0),
(145, 'TXTDELSTAFF', 2, 0, 145, 0, 8),
(146, 'TXTALLSTAFF', 2, 0, 146, 0, 0),
(147, 'TXTGROUPNAME', 2, 0, 147, 0, 6),
(148, 'TXTTOOLBAR', 2, 0, 148, 0, 8),
(149, 'TXTADDSTAFFGROUP', 2, 0, 149, 0, 0),
(150, 'TXTDELSTAFFGROUP', 2, 0, 150, 0, 8),
(151, 'TXTLOCALISATION', 2, 0, 151, 0, 0),
(152, 'TXTDOMAINACCESS', 2, 0, 152, 0, 0),
(153, 'TXTALLDOMAINS', 2, 0, 153, 0, 0),
(154, 'TXTMODULE', 2, 0, 154, 0, 0),
(155, 'TXTSYSTEM', 2, 0, 155, 0, 0),
(156, 'TXTDIAGNOSTICS', 2, 0, 156, 0, 0),
(157, 'TXTMANAGE', 2, 0, 157, 0, 0),
(158, 'TXTVIEWONLY', 2, 0, 158, 0, 8),
(159, 'TXTDELETEALL', 2, 0, 159, 0, 0),
(160, 'TXTBACKUP', 2, 0, 160, 0, 0),
(161, 'TXTLICENSE', 2, 0, 161, 0, 0),
(162, 'TXTLICENSEINFORMATION', 2, 0, 162, 0, 8),
(163, 'TXTLISTCOUNT', 2, 0, 163, 0, 0),
(164, 'TXTCURRENTLYACTIVE', 2, 0, 164, 0, 0),
(165, 'TXTDEPARTMENTS', 2, 0, 165, 0, 0),
(166, 'TXTCHANNEL', 1, 0, 166, 0, 0),
(167, 'TXTFLAGTYPE', 2, 0, 167, 0, 0),
(168, 'TXTMANAGEALLSTAFF', 2, 0, 168, 0, 8),
(169, 'TXTMANAGEDOMAINSTAFF', 2, 0, 169, 0, 8),
(170, 'TXTSTAFFGROUP', 2, 0, 170, 0, 0),
(171, 'TXTWORKFLOW', 2, 0, 171, 0, 0),
(172, 'TXTADDSLA', 2, 0, 172, 0, 0),
(173, 'TXTSCHEDULE', 2, 0, 173, 0, 0),
(174, 'TXTEMAILQUEUE', 2, 0, 174, 0, 0),
(175, 'TXTEMAILTEMPLATES', 2, 0, 175, 0, 0),
(176, 'TXTCUSTOMFIELD', 2, 0, 176, 0, 0),
(177, 'TXTCUSTOMGROUP', 2, 0, 177, 0, 0),
(178, 'TXTADDCUSTOMGROUP', 2, 0, 178, 0, 0),
(179, 'TXTDELETECUSTOMGROUP', 2, 0, 179, 0, 8),
(180, 'TXTSINGLELOGIN', 2, 0, 180, 0, 0),
(181, 'TXTINTEGRATIONS', 2, 0, 181, 0, 0),
(182, 'TXTRELEASEBUILD', 2, 1, 182, 0, 0),
(183, 'TXTRELEASEDEPLOYMENT', 2, 1, 183, 0, 0),
(184, 'TXTCANVASURL', 2, 0, 184, 0, 8),
(185, 'TXTERRORLOG', 2, 0, 185, 0, 0),
(186, 'TXTDELERRLOG', 2, 0, 186, 0, 8),
(187, 'TXTEXPLOG', 2, 0, 187, 0, 8),
(188, 'TXTPARSERLOG', 2, 0, 188, 0, 0),
(189, 'TXTEMTPARSLOG', 2, 0, 189, 0, 8),
(190, 'TXTDELPARSLOG', 2, 0, 190, 0, 8),
(191, 'TXTSENDMAILLOG', 2, 0, 191, 0, 8),
(192, 'TXTEARLYLIFESUPPORT', 2, 1, 192, 0, 0),
(193, 'TXTAPIACCESS', 2, 0, 193, 0, 8),
(194, 'TXTLOGS', 2, 0, 194, 0, 0),
(195, 'TXTERROR', 2, 0, 195, 0, 8),
(196, 'TXTPARSER', 2, 0, 196, 0, 8),
(197, 'TXTAUTOMATION', 2, 0, 197, 0, 0),
(198, 'TXTSENDEMAIL', 2, 0, 198, 0, 0),
(199, 'TXTAUDITLOG', 2, 0, 199, 0, 0),
(200, 'TXTHISTORY', 2, 0, 200, 0, 0),
(201, 'TXTINVOICES', 1, 0, 201, 0, 0),
(202, 'TXTEXPORTTOPDF', 2, 0, 202, 0, 0),
(203, 'TXTEXPORT', 2, 0, 203, 0, 0),
(204, 'TXTADDALERT', 2, 0, 204, 0, 1),
(205, 'TXTDELETEALERT', 2, 0, 205, 0, 1),
(206, 'TXTEMAILTEMPLATE', 2, 0, 206, 0, 0),
(207, 'TXTALLTICKETS', 2, 0, 207, 0, 0),
(208, 'TXTNEWTICKETS', 2, 0, 208, 0, 1),
(209, 'TXTOVERDUETICKET', 2, 0, 209, 0, 0),
(210, 'TXTASSIGNEDTICKETS', 2, 0, 210, 0, 1),
(211, 'TXTREAD', 1, 0, 211, 0, 0),
(212, 'TXTUNREAD', 1, 0, 212, 0, 0),
(213, 'TXTLABELS', 2, 0, 213, 0, 0),
(214, 'TXTEVENT', 2, 0, 214, 0, 0),
(215, 'TXTNEWSTAFFREPLY', 1, 0, 215, 0, 0),
(216, 'TXTFLAGCHANGE', 2, 0, 216, 0, 0),
(217, 'TXTTYPECHANGE', 2, 0, 217, 0, 0),
(218, 'TXTDEPARTMENTCHANGE', 2, 0, 218, 0, 0),
(219, 'TXTCLIENTEDIT', 2, 0, 219, 0, 8),
(220, 'TXTCLIENTDELETE', 2, 0, 220, 0, 0),
(221, 'TXTTICKETDEPARTMENTCHANGE', 2, 0, 221, 0, 0),
(222, 'TXTTICKETSTATUSCHANGE', 2, 0, 222, 0, 0),
(223, 'TXTTICKETPRIORITYCHANGE', 2, 0, 223, 0, 0),
(224, 'TXTTICKETMERGE', 2, 0, 224, 0, 0),
(225, 'TXTNOTEADD', 2, 0, 225, 0, 0),
(226, 'TXTDELETENOTE', 2, 0, 226, 0, 0),
(227, 'TXTNOTEADDED', 2, 0, 227, 0, 0),
(228, 'TXTNOTETYPE', 2, 0, 228, 0, 2),
(229, 'TXTBILLINGINVOICEADD', 2, 0, 229, 0, 5),
(230, 'TXTTICKETPOSTDELETE', 2, 0, 230, 0, 0),
(231, 'TXTTICKETDELETE', 2, 0, 231, 0, 2),
(232, 'TXTMOVETOTRASH', 2, 0, 232, 0, 0),
(233, 'TXTCRITERIA', 2, 0, 233, 0, 0),
(234, 'TXTMATCHANYCRITERIA', 2, 0, 234, 0, 8),
(235, 'TXTMATCHALLCRITERIA', 2, 0, 235, 0, 8),
(236, 'TXTADDCRITERIA', 2, 0, 236, 0, 0),
(237, 'TXTFILTERS', 1, 0, 237, 0, 0),
(238, 'TXTMATCHCRITERIA', 2, 0, 238, 0, 0),
(239, 'TXTSAVEASFILTER', 2, 0, 239, 0, 0),
(240, 'TXTSAVEASDRAFT', 2, 0, 240, 0, 2),
(241, 'TXTTICKETNOTE', 2, 0, 241, 0, 0),
(242, 'TXTCLIENTNOTE', 2, 0, 242, 0, 2),
(243, 'TXTTICKETCOMMENT', 2, 0, 243, 0, 0),
(244, 'TXTCLIENTNAME', 2, 0, 244, 0, 0),
(245, 'TXTCLIENTEMAIL', 2, 0, 245, 0, 0),
(246, 'TXTLASTACTIVITY', 2, 0, 246, 0, 0),
(247, 'TXTSLAPLAN', 2, 0, 247, 0, 0),
(248, 'TXTHASATTACHMENT', 2, 0, 248, 0, 0),
(249, 'TXTBILLINGNOTE', 2, 0, 249, 0, 0),
(250, 'TXTADDBILLINGNOTE', 2, 0, 250, 0, 0),
(251, 'TXTCONTAIN', 2, 0, 251, 0, 0),
(252, 'TXTDOESNOTCONTAIN', 2, 0, 252, 0, 0),
(253, 'TXTEQUAL', 2, 0, 253, 0, 0),
(254, 'TXTNOTEQUAL', 2, 0, 254, 0, 0),
(255, 'TXTLESSTHAN', 2, 0, 255, 0, 0),
(256, 'TXTGREATERTHAN', 2, 0, 256, 0, 0),
(257, 'TXTTRUE', 2, 0, 257, 0, 0),
(258, 'TXTALERTS', 2, 0, 258, 0, 0),
(259, 'TXTVIEWS', 2, 0, 259, 0, 0),
(260, 'TXTINCIDENTCATEGROYBYREPORT', 1, 0, 260, 0, 0),
(261, 'TXTCLIENT', 1, 0, 261, 0, 0),
(262, 'TXTOPERATION', 2, 0, 262, 0, 0),
(263, 'TXTDATETIME', 2, 0, 263, 0, 0),
(264, 'TXTDATE', 1, 0, 264, 0, 0),
(265, 'TXTOPERATOR', 2, 0, 265, 0, 0),
(266, 'TXTADDBALANCE', 2, 0, 266, 0, 0),
(267, 'TXTPREFERENCES', 2, 0, 267, 0, 1),
(268, 'TXTBILLINGMETHOD', 2, 0, 268, 0, 0),
(269, 'TXTTICKETBASE', 2, 0, 269, 0, 0),
(270, 'TXTTIMEBASE', 2, 0, 270, 0, 0),
(271, 'TXTBILLRATE', 2, 0, 271, 0, 0),
(272, 'TXTCURRENCY', 2, 0, 272, 0, 0),
(273, 'TXTONTICKETCREATE', 2, 0, 273, 0, 0),
(274, 'TXTDONOTGENERATEINVOICE', 2, 0, 274, 0, 0),
(275, 'TXTGENERATEINVOICE', 2, 0, 275, 0, 0),
(276, 'TXTGENERATEANDSENDINVOICE', 2, 0, 276, 0, 5),
(277, 'TXTBALANCEREQUIRED', 2, 0, 277, 0, 0),
(278, 'TXTMIN', 1, 0, 278, 0, 0),
(279, 'TXTTAXABLE', 2, 0, 279, 0, 0),
(280, 'TXTCOLLAPSESETTING', 1, 0, 280, 0, 0),
(281, 'TXTTAX', 1, 0, 281, 0, 0),
(282, 'TXTVIEWINVOICE', 1, 0, 282, 0, 0),
(283, 'TXTTODAYSDUE', 2, 0, 283, 0, 0),
(284, 'TXTTODAYSPAID', 2, 0, 284, 0, 0),
(285, 'TXTTODAY', 2, 0, 285, 0, 0),
(286, 'TXTMONTH', 2, 0, 286, 0, 0),
(287, 'TXTBILLURL', 2, 0, 287, 0, 0),
(288, 'TXTADMUSER', 2, 0, 288, 0, 8),
(289, 'TXTADMPASS', 2, 0, 289, 0, 8),
(290, 'TXTEMTMOBERRLOG', 2, 0, 290, 0, 8),
(291, 'TXTDELMOBERRLOG', 2, 0, 291, 0, 8),
(292, 'TXTADDBLAB', 2, 0, 292, 0, 6),
(293, 'TXTTRENDS', 2, 0, 293, 0, 7),
(294, 'TXTADDIMAGE', 2, 0, 294, 0, 0),
(295, 'TXTADDVIDEO', 2, 0, 295, 0, 0),
(296, 'TXTSHAREDWITH', 2, 0, 296, 0, 4),
(297, 'TXTMOBERRLOG', 2, 0, 297, 0, 0),
(298, 'TXTVIEWBLABS', 2, 0, 298, 0, 6),
(299, 'TXTADDTOBLAB', 2, 0, 299, 0, 6),
(300, 'TXTBLABCOUNT', 2, 0, 300, 0, 0),
(301, 'TXTREMOVEFROMLIST', 2, 0, 301, 0, 0),
(302, 'TXTDELETEBLAB', 2, 0, 302, 0, 6),
(303, 'TXTBREAKLINES', 2, 0, 303, 0, 0),
(304, 'TXTADDBREAKLINE', 2, 0, 304, 0, 8),
(305, 'TXTDELBREAKLINE', 2, 0, 305, 0, 8),
(306, 'TXTEXECUTIONORDER', 2, 0, 306, 0, 0),
(307, 'TXTREGULAREXPRESSION', 2, 0, 307, 0, 0),
(308, 'TXTADDTASK', 2, 0, 308, 0, 0),
(309, 'TXTDELETETASK', 2, 0, 309, 0, 0),
(310, 'TXTCALENDAR', 2, 0, 310, 0, 1),
(311, 'TXTSTARTDATE', 1, 0, 311, 0, 0),
(312, 'TXTPLANNED', 2, 0, 312, 0, 0),
(313, 'TXTCOMPLETED', 1, 0, 313, 0, 0),
(314, 'TXTINPROGRESS', 1, 0, 314, 0, 0),
(315, 'TXTNOTSTARTED', 1, 0, 315, 0, 0),
(316, 'TXTTASKTYPE', 2, 0, 316, 0, 1),
(317, 'TXTPERSONAL', 2, 0, 317, 0, 0),
(318, 'TXTBUSINESS', 2, 0, 318, 0, 1),
(319, 'TXTIMPORTANT', 2, 0, 319, 0, 0),
(320, 'TXTLABEL', 2, 0, 320, 0, 0),
(321, 'TXTHIGH', 1, 0, 321, 0, 0),
(322, 'TXTLOW', 1, 0, 322, 0, 0),
(323, 'TXTTASKS', 2, 0, 323, 0, 0),
(324, 'TXTTICKETQUEUE', 2, 0, 324, 0, 0),
(325, 'TXTFILTERQUEUES', 2, 0, 325, 0, 0),
(326, 'TXTFOLDERS', 2, 0, 326, 0, 0),
(327, 'TXTSELECTDEPARTMENT', 2, 0, 327, 0, 0),
(328, 'TXTSELECTDOMAIN', 2, 0, 328, 0, 0),
(329, 'TXTADDCHANNEL', 2, 0, 329, 0, 0),
(330, 'TXTCHANNELIMAGE', 2, 0, 330, 0, 0),
(331, 'TXTADDLANGUAGE', 2, 0, 331, 0, 0),
(332, 'TXTUPDATELANGUAGE', 2, 0, 332, 0, 0),
(333, 'TXTDELLANG', 2, 0, 333, 0, 0),
(334, 'TXTPHPINFORMATION', 2, 0, 334, 0, 8),
(335, 'TXTADDCLIENT', 2, 0, 335, 0, 0),
(336, 'TXTMANAGECONTACT', 2, 0, 336, 0, 3),
(337, 'TXTACTION', 2, 0, 337, 0, 0),
(338, 'TXTINITIALS', 2, 0, 338, 0, 0),
(339, 'TXTGENDER', 1, 0, 339, 0, 0),
(340, 'TXTMALE', 1, 0, 340, 0, 0),
(341, 'TXTFEMALE', 1, 0, 341, 0, 0),
(342, 'TXTPERMANETADDRESS', 2, 0, 342, 0, 0),
(343, 'TXTCURRENTADDRESS', 2, 0, 343, 0, 0),
(344, 'TXTCOMPANYEMAIL', 2, 0, 344, 0, 0),
(345, 'TXTSERVICEREQUESTCREATED', 2, 0, 345, 0, 0),
(346, 'TXTRELEASECLOSURE', 2, 1, 346, 0, 0),
(347, 'TXTCOMPANYFAX', 2, 0, 347, 0, 0),
(348, 'TXTCOMPANYADDRESS', 2, 0, 348, 0, 0),
(349, 'TXTNETMEETINGID', 2, 0, 349, 0, 0),
(350, 'TXTOTHERIM', 2, 0, 350, 0, 0),
(351, 'TXTOTHERCONTACT', 2, 0, 351, 0, 0),
(352, 'TXTOTHERFAX', 2, 0, 352, 0, 0),
(353, 'TXTADDINVOICE', 2, 0, 353, 0, 0),
(354, 'TXTDELETEINVOICE', 2, 0, 354, 0, 0),
(355, 'TXTPAIDDEPARTMENT', 2, 0, 355, 0, 0),
(356, 'TXTREGISTERED', 2, 0, 356, 0, 0),
(357, 'TXTUNREGISTERED', 2, 0, 357, 0, 0),
(358, 'TXTBAN', 2, 0, 358, 0, 0),
(359, 'TXTBANCLIENT', 2, 0, 359, 0, 0),
(360, 'TXTREMOVEBAN', 2, 0, 360, 0, 0),
(361, 'TXTSPAMMER', 2, 0, 361, 0, 0),
(362, 'TXTREMOVESPAM', 2, 0, 362, 0, 0),
(363, 'TXTMARKSPAM', 2, 0, 363, 0, 0),
(364, 'TXTBANANDDELETE', 2, 0, 364, 0, 3),
(365, 'TXTEMAILNOTIFICATIONS', 2, 0, 365, 0, 8),
(366, 'TXTTICKET', 1, 0, 366, 0, 0),
(367, 'TXTREPLY', 1, 0, 367, 0, 0),
(368, 'TXTREPLYALL', 2, 0, 368, 0, 2),
(369, 'TXTFORWARD', 2, 0, 369, 0, 0),
(370, 'TXTSENDREPLY', 2, 0, 370, 0, 2),
(371, 'TXTDELETETICKET', 2, 0, 371, 0, 0),
(372, 'TXTMERGETICKET', 2, 0, 372, 0, 0),
(373, 'TXTDELETETICKETPROPERTIES', 2, 0, 373, 0, 0),
(374, 'TXTCHANGEPROPERTIES', 2, 0, 374, 0, 0),
(375, 'TXTDELETETICKETPOST', 2, 0, 375, 0, 0),
(376, 'TXTEDITTICKETPOST', 2, 0, 376, 0, 8),
(377, 'TXTSETDUETIME', 2, 0, 377, 0, 2),
(378, 'TXTRECIPIENTS', 2, 0, 378, 0, 2),
(379, 'TXTDISCARD', 2, 0, 379, 0, 0),
(380, 'TXTASCENDING', 2, 0, 380, 0, 0),
(381, 'TXTDESCENDING', 2, 0, 381, 0, 0),
(382, 'TXTVIEWTICKETNOTE', 2, 0, 382, 0, 0),
(383, 'TXTMANAGETICKETNOTE', 2, 0, 383, 0, 0),
(384, 'TXTOPENNEWTICKETS', 2, 0, 384, 0, 0),
(385, 'TXTFORWARDTICKET', 2, 0, 385, 0, 0),
(386, 'TXTSELFASSIGNED', 2, 0, 386, 0, 0),
(387, 'TXTUSSIGNED', 1, 0, 387, 0, 0),
(388, 'TXTASSIGNED', 2, 0, 388, 0, 0),
(389, 'TXTMOVETO', 2, 0, 389, 0, 0),
(390, 'TXTUNASSIGNEDANDSELFASSIGNED', 2, 0, 390, 0, 8),
(391, 'TXTOVERDUETIME', 2, 0, 391, 0, 0),
(392, 'TXTNEW', 1, 0, 392, 0, 0),
(393, 'TXTNOTE', 2, 0, 393, 0, 0),
(394, 'TXTFROM', 1, 0, 394, 0, 0),
(395, 'TXTTICKETID', 2, 0, 395, 0, 3),
(396, 'TXTTICKETPRIORITY', 2, 0, 396, 0, 0),
(397, 'TXTTICKETSTATUS', 2, 0, 397, 0, 0),
(398, 'TXTADDSTATUS', 2, 0, 398, 0, 0),
(399, 'TXTDELTKTSTATUS', 2, 0, 399, 0, 8),
(400, 'TXTTICKETCREATEDON', 2, 0, 400, 0, 2),
(401, 'TXTTICKETMODIFIEDON', 2, 0, 401, 0, 2),
(402, 'TXTRESOLVETIME', 2, 0, 402, 0, 2),
(403, 'MSGCLINKNOTCLOSE', 2, 1, 403, 0, 10),
(404, 'TXTTICKETPOSTCOUNT', 2, 0, 404, 0, 0),
(405, 'TXTCLIENTFIRSTNAME', 2, 0, 405, 0, 3),
(406, 'TXTCLIENTLASTNAME', 2, 0, 406, 0, 3),
(407, 'TXTCLIENTCONTACT', 2, 0, 407, 0, 3),
(408, 'TXTCLIENTCOMPANY', 2, 0, 408, 0, 3),
(409, 'TXTCLIENTJOBTITLE', 2, 0, 409, 0, 3),
(410, 'TXTCLIENTSTATE', 2, 0, 410, 0, 3),
(411, 'TXTCLIENTCITY', 2, 0, 411, 0, 3),
(412, 'TXTCLIENTZIPCODE', 2, 0, 412, 0, 3),
(413, 'TXTCLIENTCOUNTRY', 2, 0, 413, 0, 3),
(414, 'TXTISSPAMCLIENT', 2, 0, 414, 0, 3),
(415, 'TXTISBANNEDCLIENT', 2, 0, 415, 0, 3),
(416, 'TXTCLIENTPAIDINVOICECOUNT', 2, 0, 416, 0, 3),
(417, 'TXTCLIENTUNPAIDINVOICECOUNT', 2, 0, 417, 0, 3),
(418, 'TXTSTAFFFIRSTNAME', 2, 0, 418, 0, 1),
(419, 'TXTSTAFFLASTNAME', 2, 0, 419, 0, 1),
(420, 'TXTSTAFFEMAIL', 2, 0, 420, 0, 1),
(421, 'TXTSTAFFJOBTITLE', 2, 0, 421, 0, 1),
(422, 'TXTAVGRESPONSE', 2, 0, 422, 0, 0),
(423, 'TXTTOTALRESPONSES', 2, 0, 423, 0, 0),
(424, 'TXTSTAFFGROUPACCESS', 2, 0, 424, 0, 8),
(425, 'TXTSTAFFLIST', 2, 0, 425, 0, 8),
(426, 'TXTBACK', 1, 0, 426, 0, 0),
(427, 'TXTTICKETAUTOCLOSETIME', 2, 0, 427, 0, 2),
(428, 'TXTTICKETAVERAGERESPONSETIME', 2, 0, 428, 0, 0),
(429, 'TXTTICKETFOLLOWUPCOUNT', 2, 0, 429, 0, 2),
(430, 'TXTTICKETIPADDRESS', 2, 0, 430, 0, 2),
(431, 'TXTTICKETISRESOLVED', 2, 0, 431, 0, 2),
(432, 'TXTTICKETREPLYTO', 2, 0, 432, 0, 2),
(433, 'TXTTICKETTIMEWORKED', 2, 0, 433, 0, 0),
(434, 'TXTTICKETTOTALREPLIES', 2, 0, 434, 0, 0),
(435, 'TXTSLAOVERDUEHOURS', 2, 0, 435, 0, 0),
(436, 'TXTSLAPLANRESOLUTIONDUEHOURS', 2, 0, 436, 0, 0),
(437, 'MSGRLINKNOTCLOSE', 2, 1, 437, 0, 10),
(438, 'TXTNUMBEROFATTACHMENTS', 2, 0, 438, 0, 8),
(439, 'TXTALLOWEDEXTENSIONS', 2, 0, 439, 0, 8),
(440, 'TXTMAXALLOWEDSIZEFORATTACHMENT', 2, 0, 440, 0, 8),
(441, 'TXTADDMERGEDTICKETSEMAILASRECIPENTS', 2, 0, 441, 0, 0),
(442, 'TXTVISIBLETOCLIENT', 2, 0, 442, 0, 0),
(443, 'TXTFIELDSAVAILABLE', 2, 0, 443, 0, 1),
(444, 'TXTFIELDSSELECTED', 2, 0, 444, 0, 1),
(445, 'TXTLASTREPLIER', 2, 0, 445, 0, 0),
(446, 'TXTADDVIEW', 2, 0, 446, 0, 0),
(447, 'TXTDELETEVIEW', 2, 0, 447, 0, 1),
(448, 'TXTSUMMARY', 1, 0, 448, 0, 0),
(449, 'TXTPERSNDET', 2, 0, 449, 0, 1),
(450, 'TXTHMDETAIL', 2, 0, 450, 0, 0),
(451, 'TXTCOMPDETAIL', 2, 0, 451, 0, 0),
(452, 'TXTADDDOMAIN', 2, 0, 452, 0, 8),
(453, 'TXTUPDATEDOMAIN', 2, 0, 453, 0, 8),
(454, 'TXTDOMAINNAME', 2, 0, 454, 0, 8),
(455, 'TXTDELDOMAIN', 2, 0, 455, 0, 8),
(456, 'TXTADDDEPARTMENT', 2, 0, 456, 0, 8),
(457, 'TXTUPDATEDEPARTMENT', 2, 0, 457, 0, 8),
(458, 'TXTDELETEDEPARTMENT', 2, 0, 458, 0, 8),
(459, 'TXTISPAID', 2, 0, 459, 0, 0),
(460, 'TXTAUTORESPONDER', 2, 0, 460, 0, 0),
(461, 'TXTAUTORESPONDERSIGNATURE', 2, 0, 461, 0, 0),
(462, 'TXTDOMAINURL', 2, 0, 462, 0, 0),
(463, 'TXTSET', 2, 0, 463, 0, 0),
(464, 'TXTSUPPORTPORTALURL', 2, 0, 464, 0, 8),
(465, 'TXTDEFAULTEMAIL', 2, 0, 465, 0, 8),
(466, 'TXTDEFAULTLANGUAGE', 2, 0, 466, 0, 8),
(467, 'TXTCLIENTPORTALTHEME', 2, 0, 467, 0, 8),
(468, 'TXTCLIENTPORTAL', 2, 0, 468, 0, 0),
(469, 'TXTUPDATECLIENTPORTAL', 2, 0, 469, 0, 8),
(470, 'TXTOUTGOINGEMAIL', 2, 0, 470, 0, 0),
(471, 'TXTTIMEZONE', 2, 0, 471, 0, 0),
(472, 'TXTCHAINAPPROVAL', 2, 1, 472, 0, 0),
(473, 'TXTAUTOAPPROVEREGISTRATION', 2, 0, 473, 0, 8),
(474, 'TXTENABLECAPTCHAONREGISTER', 2, 0, 474, 0, 0),
(475, 'TXTAPPROVE', 1, 0, 475, 0, 0),
(476, 'TXTDISAPPROVED', 2, 0, 476, 0, 0),
(477, 'TXTADDTOPIN', 2, 0, 477, 0, 0),
(478, 'TXTLOGINASCLIENT', 2, 0, 478, 0, 0),
(479, 'TXTADDTICKET', 1, 0, 479, 0, 0),
(480, 'TXTGROUPTYPE', 2, 0, 480, 0, 0),
(481, 'TXTUSERREGISTRATION', 2, 0, 481, 0, 8),
(482, 'TXTUSERTICKETCREATION', 2, 0, 482, 0, 8),
(483, 'TXTSTAFFTICKETCREATION', 2, 0, 483, 0, 8),
(484, 'TXTDEPARTMENTACCESS', 2, 0, 484, 0, 0),
(485, 'TXTALLDEPARTMENTS', 2, 0, 485, 0, 0),
(486, 'TXTADDTICKETTYPE', 2, 0, 486, 0, 8),
(487, 'TXTDELTKTTYPE', 2, 0, 487, 0, 8),
(488, 'TXTFIELDS', 2, 0, 488, 0, 0),
(489, 'TXTFIELDDETAILS', 2, 0, 489, 0, 0),
(490, 'TXTFIELDTITLE', 2, 0, 490, 0, 0),
(491, 'TXTDEFAULTVALUE', 2, 0, 491, 0, 0),
(492, 'TXTFIELDDESCRIPTION', 2, 0, 492, 0, 0),
(493, 'TXTISREQUIRED', 2, 0, 493, 0, 0),
(494, 'TXTUSEREDITABLE', 2, 0, 494, 0, 8),
(495, 'TXTSTAFFEDITABLE', 2, 0, 495, 0, 8),
(496, 'TXTNUMERIC', 2, 0, 496, 0, 0),
(497, 'TXTALPHABETIC', 2, 0, 497, 0, 0),
(498, 'TXTALPHANUMERIC', 2, 0, 498, 0, 0),
(499, 'TXTOPTIONFIELDS', 2, 0, 499, 0, 0),
(500, 'TXTADDNEWCUSTOMFIELD', 2, 0, 500, 0, 8),
(501, 'TXTDELETECUSTOMFIELD', 2, 0, 501, 0, 8),
(502, 'TXTCUSTOMIZATIONS', 2, 0, 502, 0, 0),
(503, 'TXTHTMLTAGS', 2, 0, 503, 0, 0),
(504, 'TXTTEXTBOX', 2, 0, 504, 0, 8),
(505, 'TXTTEXTAREA', 2, 0, 505, 0, 8),
(506, 'TXTCHECKBOX', 2, 0, 506, 0, 8),
(507, 'TXTRADIO', 2, 0, 507, 0, 8),
(508, 'TXTSELECTMULTIPLE', 2, 0, 508, 0, 2),
(509, 'TXTFILE', 2, 0, 509, 0, 0),
(510, 'TXTREGULAREXPRESSIONVALIDATION', 2, 0, 510, 0, 8),
(511, 'TXTADDEMAILTEMPLATE', 2, 0, 511, 0, 8),
(512, 'TXTDELETEETEMPLATE', 2, 0, 512, 0, 8),
(513, 'TXTADDFLAG', 2, 0, 513, 0, 8),
(514, 'TXTDELFLAG', 2, 0, 514, 0, 8),
(515, 'TXTFLAGNAME', 2, 0, 515, 0, 8),
(516, 'TXTFLAGCOLOR', 2, 0, 516, 0, 8),
(517, 'TXTFILENAME', 2, 0, 517, 0, 8),
(518, 'TXTLANGUGAGECODE', 2, 0, 518, 0, 0),
(519, 'TXTCHARACTERSET', 2, 0, 519, 0, 0),
(520, 'TXTLANGUAGECODE', 2, 0, 520, 0, 0),
(521, 'TXTRIGHTTOLEFT', 2, 0, 521, 0, 8),
(522, 'TXTLEFTPANELVIEW', 2, 0, 522, 0, 8),
(523, 'TXTSENTMAIL', 2, 0, 523, 0, 0),
(524, 'TXTTOGGLELEFTPANEL', 2, 0, 524, 0, 8),
(525, 'TXTSETTINGS', 2, 0, 525, 0, 0),
(526, 'TXTPINNEDITEM', 2, 0, 526, 0, 1),
(527, 'TXTQUICKVIEW', 2, 0, 527, 0, 8),
(528, 'TXTMAILQUEUES', 2, 0, 528, 0, 8),
(529, 'TXTADDMAILQUEUE', 2, 0, 529, 0, 8),
(530, 'TXTDELMAILQ', 2, 0, 530, 0, 8),
(531, 'TXTFETCHTYPE', 2, 0, 531, 0, 8),
(532, 'TXTLOGININFORMATION', 2, 0, 532, 0, 8),
(533, 'TXTHOSTNAME', 2, 0, 533, 0, 8),
(534, 'TXTTABLEPREFIX', 2, 0, 534, 0, 8),
(535, 'TXTPORT', 2, 0, 535, 0, 8),
(536, 'TXTSSL', 2, 0, 536, 0, 8),
(537, 'TXTSMTPAUTHENTICATION', 2, 0, 537, 0, 8),
(538, 'TXTLEAVEACOPYONSERVER', 2, 0, 538, 0, 8),
(539, 'TXTQUEUETITLE', 2, 0, 539, 0, 8),
(540, 'TXTFROMNAME', 2, 0, 540, 0, 8),
(541, 'TXTFROMEMAIL', 2, 0, 541, 0, 8),
(542, 'TXTQUEUESETTING', 2, 0, 542, 0, 8),
(543, 'TXTSIGNATURE', 2, 0, 543, 0, 0),
(544, 'TXTCOMMENTSUB', 2, 0, 544, 0, 0),
(545, 'TXTRELEASEPLANNER', 2, 1, 545, 0, 10),
(546, 'TXTCATEGORIES', 2, 0, 546, 0, 0),
(547, 'TXTCOMMENTS', 1, 0, 547, 0, 0),
(548, 'TXTARTICLE', 2, 0, 548, 0, 0),
(549, 'TXTALLOWCOMMENTS', 2, 0, 549, 0, 0),
(550, 'TXTALLOWRATINGS', 2, 0, 550, 0, 0),
(551, 'TXTSTICKTOHOMEPAGE', 2, 0, 551, 0, 8),
(552, 'TXTALLOWATTACHMENTTOCLIENTS', 2, 0, 552, 0, 4),
(553, 'TXTLOGINCOMPULSORYTOCLIENT', 2, 0, 553, 0, 0),
(554, 'TXTAUTOSUBSCRIBEAFTERCOMMENT', 2, 0, 554, 0, 0),
(555, 'TXTROOT', 2, 0, 555, 0, 0),
(556, 'TXTPARENTCATEGORY', 2, 0, 556, 0, 0),
(557, 'TXTKNOWLEDGEBASE', 1, 0, 557, 0, 0),
(558, 'TXTQUESTIONANDANSWER', 2, 0, 558, 0, 0),
(559, 'TXTORDERBY', 2, 0, 559, 0, 0),
(560, 'TXTNEWFIRST', 2, 0, 560, 0, 0),
(561, 'TXTOLDFIRST', 2, 0, 561, 0, 0),
(562, 'TXTMODIFIEDFIRST', 2, 0, 562, 0, 0),
(563, 'TXTVISIBLETO', 2, 0, 563, 0, 0),
(564, 'TXTEVERYBODY', 2, 0, 564, 0, 0),
(565, 'TXTSTAFFONLY', 2, 0, 565, 0, 0),
(566, 'TXTLOGGEDINCLIENT', 2, 0, 566, 0, 0),
(567, 'TXTISENABLED', 2, 0, 567, 0, 0),
(568, 'TXTPOSTARTICLE', 2, 0, 568, 0, 4),
(569, 'TXTAUTHOR', 2, 0, 569, 0, 0),
(570, 'TXTADDCATEGORY', 2, 0, 570, 0, 0),
(571, 'TXTADDEDARTICLE', 2, 0, 571, 0, 4),
(572, 'TXTRELEASETESTMNGR', 2, 1, 572, 0, 10),
(573, 'TXTDELARTICLE', 2, 0, 573, 0, 4),
(574, 'TXTSELFHELPSUGGESTION', 2, 0, 574, 0, 8),
(575, 'TXTENABLECAPTCHAONCOMMENT', 2, 0, 575, 0, 8),
(576, 'TXTQUICKINSERT', 2, 0, 576, 0, 8),
(577, 'TXTMORE', 1, 0, 577, 0, 0),
(578, 'TXTWELCOME', 2, 0, 578, 0, 0),
(579, 'TXTSERVICEUNASSIGNEDFROM', 2, 0, 579, 0, 7),
(580, 'TXTREPORTS', 1, 0, 580, 0, 0),
(581, 'TXTADDREPORT', 2, 0, 581, 0, 7),
(582, 'TXTMIGRATION', 2, 0, 582, 0, 8),
(583, 'TXTINBOX', 2, 0, 583, 0, 0),
(584, 'TXTTAGS', 2, 0, 584, 0, 0),
(585, 'TXTDELETETAGS', 2, 0, 585, 0, 2),
(586, 'TXTTAGSEARCH', 2, 0, 586, 0, 8),
(587, 'TXTRECENTACTIVITIES', 2, 0, 587, 0, 8),
(588, 'TXTADDMODULE', 2, 0, 588, 0, 8),
(589, 'TXTDELMODULE', 2, 0, 589, 0, 8),
(590, 'TXTHEADERTITLE', 2, 0, 590, 0, 8),
(591, 'TXTDISPLAYONQUICKVIEW', 2, 0, 591, 0, 8),
(592, 'TXTFAILED', 1, 0, 592, 0, 0),
(593, 'TXTSUCCESS', 2, 0, 593, 0, 0),
(594, 'TXTTHEME', 2, 0, 594, 0, 8),
(595, 'TXTSESSIONTIMEOUT', 2, 0, 595, 0, 8),
(596, 'TXTINMINUTES', 2, 0, 596, 0, 0),
(597, 'TXTSOUNDALERT', 2, 0, 597, 0, 0),
(598, 'TXTHTMLEDITOR', 2, 0, 598, 0, 8),
(599, 'TXTCOLOR', 2, 0, 599, 0, 8),
(600, 'TXTPLANNERSCHEDULAR', 2, 1, 600, 0, 0),
(601, 'TXTADDPRIORITY', 2, 0, 601, 0, 8),
(602, 'TXTUPDATEPRIORITY', 2, 0, 602, 0, 8),
(603, 'TXTDELPRIORITY', 2, 0, 603, 0, 8),
(604, 'TXTPURCHASEORUPGRADE', 2, 0, 604, 0, 0),
(605, 'TXTAFFECTEDBYRELEASE', 2, 1, 605, 0, 10),
(606, 'TXTAUDIENCE', 2, 1, 606, 0, 10),
(607, 'TXTADDSCHEDULE', 2, 0, 607, 0, 8),
(608, 'TXTDELETESCHEDULE', 2, 0, 608, 0, 8),
(609, 'TXTSUNDAY', 2, 0, 609, 0, 0),
(610, 'TXTMONDAY', 2, 0, 610, 0, 0),
(611, 'TXTTUESDAY', 2, 0, 611, 0, 0),
(612, 'TXTWEDNESDAY', 2, 0, 612, 0, 0),
(613, 'TXTTHURSDAY', 2, 0, 613, 0, 0),
(614, 'TXTFRIDAY', 2, 0, 614, 0, 0),
(615, 'TXTSATURDAY', 2, 0, 615, 0, 0),
(616, 'TXTOPEN24HOURS', 2, 0, 616, 0, 8),
(617, 'TXTCLOSE', 1, 0, 617, 0, 0),
(618, 'TXTOPEN', 2, 0, 618, 0, 0),
(619, 'TXTCUSTOMTIME', 2, 0, 619, 0, 8),
(620, 'TXTADDWORKFLOW', 2, 0, 620, 0, 8),
(621, 'TXTDELWRKFLOW', 2, 0, 621, 0, 8),
(622, 'TXTCHANGEDEPARTMENT', 2, 0, 622, 0, 0),
(623, 'TXTNOCHANGE', 2, 0, 623, 0, 0),
(624, 'TXTASSIGNSTAFF', 2, 0, 624, 0, 0),
(625, 'TXTCHANGESTATUS', 2, 0, 625, 0, 0),
(626, 'TXTCHANGEFLAG', 2, 0, 626, 0, 0),
(627, 'TXTCHANGETICKETTYPE', 2, 0, 627, 0, 0),
(628, 'TXTCHANGESLA', 2, 0, 628, 0, 0),
(629, 'TXTIGNOREEMAIL', 2, 0, 629, 0, 8),
(630, 'TXTSENDAUTORESPONDERMESSAGE', 2, 0, 630, 0, 8),
(631, 'TXTPROCESSTICKETALERTRULES', 2, 0, 631, 0, 8),
(632, 'MSGDONOTPARSEASTICKETREPLY', 2, 0, 632, 0, 8),
(633, 'TXTFORWORDTO', 2, 0, 633, 0, 8),
(634, 'TXTMARKEDASBANNED', 2, 0, 634, 0, 3),
(635, 'TXTMARKEDASSPAM', 2, 0, 635, 0, 0),
(636, 'TXTCHANGE', 1, 0, 636, 0, 0),
(637, 'TXTON', 2, 0, 637, 0, 0),
(638, 'TXTOPTIONS', 2, 0, 638, 0, 0),
(639, 'TXTNONE', 2, 0, 639, 0, 0),
(640, 'TXTPUBLIC', 2, 0, 640, 0, 0),
(641, 'TXTPRIVATE', 2, 0, 641, 0, 0),
(642, 'TXTYES', 1, 0, 642, 0, 0),
(643, 'TXTNO', 1, 0, 643, 0, 0),
(644, 'TXTENABLE', 2, 0, 644, 0, 0),
(645, 'TXTDISABLE', 2, 0, 645, 0, 0),
(646, 'TXTDISPLAYORDER', 2, 0, 646, 0, 0),
(647, 'TXTNEXT', 2, 0, 647, 0, 0),
(648, 'TXTFINISH', 2, 0, 648, 0, 0),
(649, 'MSGCUSTOMGRPDEL', 2, 0, 649, 0, 8),
(650, 'MSGMODSHCONCHARFRMATOZOLY', 2, 0, 650, 0, 8),
(651, 'MSGCUSTRQGR', 2, 0, 651, 0, 0),
(652, 'TXTBASELINE', 2, 0, 652, 0, 0),
(653, 'MSGDEPTDEL', 2, 0, 653, 0, 8),
(654, 'MSGDELDOM', 2, 0, 654, 0, 8),
(655, 'MSGDELCAT', 2, 0, 655, 0, 4),
(656, 'MSGDELART', 2, 0, 656, 0, 4),
(657, 'TXTAND', 2, 0, 657, 0, 0),
(658, 'TXTCALENDER', 2, 0, 658, 0, 0),
(659, 'TXTCALCULATE', 2, 0, 659, 0, 0),
(660, 'TXTCANNOTCHANGEPRO', 2, 0, 660, 0, 0),
(661, 'TXTCOMPLETELINKCHANGREL', 2, 1, 661, 0, 10),
(662, 'MSGREQFILNTFNDFRMOD', 2, 0, 662, 0, 8),
(663, 'TXTCUSTOMER', 2, 1, 663, 0, 0),
(664, 'MSGSETTUNAVIL', 2, 0, 664, 0, 8),
(665, 'MSGMTMLOG', 2, 0, 665, 0, 8),
(666, 'MSGLGNTSEL', 2, 0, 666, 0, 0),
(667, 'MSGERRLGEMT', 2, 0, 667, 0, 8),
(668, 'MSGEXPLGEMT', 2, 0, 668, 0, 8),
(669, 'MSGDUETIMENTSET', 2, 0, 669, 0, 0),
(670, 'MSGRESTIMENTSET', 2, 0, 670, 0, 0),
(671, 'MSGINVLAIDAMT', 2, 0, 671, 0, 0),
(672, 'TXTDEPLOYSCHEDULE', 2, 1, 672, 0, 10),
(673, 'MSGTKTIDMISS', 2, 0, 673, 0, 0),
(674, 'MSGFLRTTTMISS', 2, 0, 674, 0, 0),
(675, 'MSGSNDRMISS', 2, 0, 675, 0, 0),
(676, 'MSGTAGNMMISS', 2, 0, 676, 0, 2),
(677, 'MSGINVOPT', 2, 0, 677, 0, 0),
(678, 'MSGSNGLTKT', 2, 0, 678, 0, 2),
(679, 'TXTDEPLOYSTRATEGY', 2, 1, 679, 0, 10),
(680, 'MSGINVLDOLDPWD', 2, 0, 680, 0, 1),
(681, 'MSGSTFNTSEL', 2, 0, 681, 0, 6),
(682, 'TXTBUILDDEPLOY', 2, 1, 682, 0, 0),
(683, 'TXTTESTINGAPPROVAL', 2, 1, 683, 0, 10),
(684, 'TXTDISRUPTIONMITIGATION', 2, 1, 684, 0, 10),
(685, 'MSGPASSSET', 2, 0, 685, 0, 0),
(686, 'TXTREADYTODEPLOY', 2, 1, 686, 0, 10),
(687, 'MSGFLDNTSEL', 2, 0, 687, 0, 1),
(688, 'MSGEVTNTSEL', 2, 0, 688, 0, 0),
(689, 'MSGMGRTDANTSEL', 2, 0, 689, 0, 8),
(690, 'TXTFINANCIALASSET', 2, 1, 690, 0, 10),
(691, 'MSGPURCHASEORUPGRADEMES', 2, 0, 691, 0, 0),
(692, 'MSGCOREMODULEDELETE', 2, 0, 692, 0, 8),
(693, 'MSGINCOMPLETEINFO', 2, 0, 693, 0, 0),
(694, 'MSGQUICKWIDGETNOTFND', 2, 0, 694, 0, 0),
(695, 'MSGEMPTYERRLOG', 2, 0, 695, 0, 8),
(696, 'TXTPROCESSEDMATERIAL', 2, 1, 696, 0, 10),
(697, 'MSGCLIENTADDED', 2, 0, 697, 0, 0),
(698, 'MSGDOMAINNOTFOUND', 2, 0, 698, 0, 0),
(699, 'MSGDEPTNTFND', 2, 0, 699, 0, 0),
(700, 'MSGSTFNTFND', 2, 0, 700, 0, 0),
(701, 'MSGTKTRPLD', 2, 0, 701, 0, 0),
(702, 'MSGDEPTCHNG', 2, 0, 702, 0, 0),
(703, 'MSGTKTTYPCHG', 2, 0, 703, 0, 0),
(704, 'MSGFLGCHG', 2, 0, 704, 0, 0),
(705, 'MSGTKTASSIG', 2, 0, 705, 0, 0),
(706, 'MSGTKTTRSH', 2, 0, 706, 0, 0),
(707, 'MSGTKTFRWD', 2, 0, 707, 0, 0),
(708, 'MSGTKTDELETED', 2, 0, 708, 0, 0),
(709, 'MSGSLACHG', 2, 0, 709, 0, 0),
(710, 'MSGSPAMMRK', 2, 0, 710, 0, 0),
(711, 'MSGUNSPAM', 2, 0, 711, 0, 0),
(712, 'MSGCANNOTREMOVEFIRSTCRIRERIA', 2, 0, 712, 0, 0),
(713, 'MSGREQFILDISORDERNUM', 2, 0, 713, 0, 0),
(714, 'TXTSERVICERELEASEDETAILS', 2, 1, 714, 0, 10),
(715, 'TXTUSECSVCITYPE', 2, 0, 715, 0, 14),
(716, 'vis_ticket_post_count', 2, 0, 716, 0, 7),
(717, 'TXTMONITORINGSTARTDATE', 2, 1, 717, 0, 10),
(718, 'TXTMONITORINGENDDATE', 2, 1, 718, 0, 10),
(719, 'TXTMONITORINGREVIEW', 2, 1, 719, 0, 10),
(720, 'vis_client_debit', 2, 0, 720, 0, 7),
(721, 'vis_client_group_credit', 2, 0, 721, 0, 7),
(722, 'vis_client_group_debit', 2, 0, 722, 0, 7),
(723, 'vis_client_paid_invoice_count', 2, 0, 723, 0, 7),
(724, 'vis_client_unpaid_invoice_count', 2, 0, 724, 0, 5),
(725, 'TXTCONFIRMKNWOLEDGE', 2, 1, 725, 0, 10),
(726, 'TXTQUALITYREQUIREMENT', 2, 1, 726, 0, 10),
(727, 'TXTPOSTIMPLREVIEW', 2, 1, 727, 0, 10),
(728, 'TXTCLOSINGDATE', 2, 1, 728, 0, 0),
(729, 'TXTPROPERTIES', 2, 0, 729, 0, 0),
(730, 'TXTPEOPLE', 2, 0, 730, 0, 0),
(731, 'MSGMDLEXST', 2, 0, 731, 0, 8),
(732, 'MSGVIVCNTDEL', 2, 0, 732, 0, 8),
(733, 'TXTSEARCHTRASH', 2, 0, 733, 0, 0),
(734, 'TXTSEARCHSPAM', 2, 0, 734, 0, 0),
(735, 'TXTTRASH', 2, 0, 735, 0, 0),
(736, 'TXTSPAM', 2, 0, 736, 0, 0),
(737, 'TXTPRINT', 1, 0, 737, 0, 0),
(738, 'MSGTKTNTACC', 2, 0, 738, 0, 2),
(739, 'TXTONOVERDUE', 2, 0, 739, 0, 0),
(740, 'TXTOPTION', 2, 0, 740, 0, 8),
(741, 'TXTDELETEFILTER', 2, 0, 741, 0, 2),
(742, 'TXTDRAFT', 2, 0, 742, 0, 0),
(743, 'TXTTKTLOCK', 2, 0, 743, 0, 0),
(744, 'TXTTOSHAREWITHALLDONOTSELECTSTAFF', 2, 0, 744, 0, 0),
(745, 'TXTGO', 2, 0, 745, 0, 0),
(746, 'TXTDELETEREPORT', 2, 0, 746, 0, 7),
(747, 'MSGSTAFFSAMEDETAILS', 2, 0, 747, 0, 0),
(748, 'MSGDELMLOG', 2, 0, 748, 0, 8),
(749, 'TXTCLIENTDETAILS', 2, 0, 749, 0, 0),
(750, 'TXTCLIENTNOTES', 2, 0, 750, 0, 0),
(751, 'TXTPRODANDSER', 2, 0, 751, 0, 0),
(752, 'TXTPACKAGE', 2, 0, 752, 0, 0),
(753, 'TXTDEDICATEDIP', 2, 0, 753, 0, 0),
(754, 'TXTWHMCSCLIENTNOTES', 2, 0, 754, 0, 0),
(755, 'MSGERRINWHDTABASSEL', 2, 0, 755, 0, 0),
(756, 'MSGERRINWHDTABASCON', 2, 0, 756, 0, 0),
(757, 'MSGWHINTDETNTSET', 2, 0, 757, 0, 8),
(758, 'TXTVERSION', 2, 0, 758, 0, 0),
(759, 'TXTBRANDING', 2, 0, 759, 0, 0),
(760, 'MSGINVADDFORTKT', 2, 0, 760, 0, 0),
(761, 'MSGINVDESC1', 2, 0, 761, 0, 0),
(762, 'MSGINVDESC2', 2, 0, 762, 0, 5),
(763, 'TXTEDITTRANSACTION', 2, 0, 763, 0, 5),
(764, 'TXTTRANSACTIONS', 2, 0, 764, 0, 0),
(765, 'TXTDELTRANSACTION', 2, 0, 765, 0, 5),
(766, 'TXTRATE', 2, 0, 766, 0, 0),
(767, 'TXTINCLUSIVE', 1, 0, 767, 0, 0),
(768, 'TXTEXCLUSIVE', 1, 0, 768, 0, 0),
(769, 'TXTADDTAX', 2, 0, 769, 0, 8),
(770, 'TXTEDITTAX', 2, 0, 770, 0, 8),
(771, 'MSGINVRATE', 2, 0, 771, 0, 8),
(772, 'TXTDELTAX', 2, 0, 772, 0, 8),
(773, 'TXTVIEWINVOICETOCLI', 2, 0, 773, 0, 8),
(774, 'TXTRELEASEUPDATEIMPACT', 2, 1, 774, 0, 0),
(775, 'TXTINVOICETO', 2, 0, 775, 0, 5),
(776, 'TXTMOVETOINBOX', 2, 0, 776, 0, 2),
(777, 'TXTMARKUNPAID', 2, 0, 777, 0, 5),
(778, 'TXTMARKCANCEL', 2, 0, 778, 0, 5),
(779, 'TXTGREATEREQLTHAN', 2, 0, 779, 0, 0),
(780, 'TXTADDITEM', 2, 0, 780, 0, 5),
(781, 'TXTEMAILTEMPLATESMAP', 2, 0, 781, 0, 0),
(782, 'TXTRELEASEUPDATERISK', 2, 1, 782, 0, 0),
(783, 'TXTCONKEY', 2, 0, 783, 0, 8),
(784, 'TXTRELEASEUPDATEURGENCY', 2, 1, 784, 0, 0),
(785, 'TXTRELEASESTAGECOMPLETION', 2, 1, 785, 0, 0),
(786, 'MSGCHECKTICKETDTL', 2, 0, 786, 0, 0),
(787, 'TXTSOCIALMEDIA', 2, 0, 787, 0, 0),
(788, 'TXTSEARCHCONTENT', 2, 0, 788, 0, 0),
(789, 'TXTADDSOCIALMEDIA', 2, 0, 789, 0, 0),
(790, 'TXTAUTOTICKETCONVERT', 2, 0, 790, 0, 8),
(791, 'TXTCREATEAPP', 2, 0, 791, 0, 0),
(792, 'TXTRELEASEROLEASSIGN', 2, 1, 792, 0, 0),
(793, 'TXTGENERATEREQDETAILS', 2, 0, 793, 0, 8),
(794, 'TXTHIDDEN', 2, 0, 794, 0, 8),
(795, 'TXTSOFTWARETYPE', 2, 0, 795, 0, 0),
(796, 'TXTSMSALERT', 2, 0, 796, 0, 0),
(797, 'TXTPORTALCOLOR', 2, 0, 797, 0, 8),
(798, 'TXTMD5PSS', 2, 0, 798, 0, 8),
(799, 'TXTAPPROVED', 1, 0, 799, 0, 0),
(800, 'TXTUNAPPROVED', 2, 0, 800, 0, 0),
(801, 'MSGDEPTDELLMT', 2, 0, 801, 0, 8),
(802, 'TXTSOFTWARECATEGORY', 2, 0, 802, 0, 0),
(803, 'TXTVIEWAFTERLOGING', 2, 0, 803, 0, 8),
(804, 'TXTTYPEHERE', 2, 0, 804, 0, 0),
(805, 'TXTPORTALLOGO', 2, 0, 805, 0, 8),
(806, 'TXTSAVEREPLY', 2, 0, 806, 0, 0),
(807, 'MSGDELETEDEF', 2, 0, 807, 0, 8),
(808, 'TXTDATA', 2, 0, 808, 0, 7),
(809, 'TXTGRAPICAL', 2, 0, 809, 0, 7),
(810, 'TXTCOMPONENT', 2, 0, 810, 0, 0),
(811, 'TXTBASEDN', 2, 0, 811, 0, 8),
(812, 'TXTMOVETICKETS', 2, 0, 812, 0, 0),
(813, 'TXTDATEFORMAT', 2, 0, 813, 0, 8),
(814, 'TXTDATETIMEFORMAT', 2, 0, 814, 0, 8),
(815, 'TXTPRODUCTS', 1, 0, 815, 0, 0),
(816, 'TXTDELPRODUCT', 2, 0, 816, 0, 8),
(817, 'TXTADDPRODUCT', 2, 0, 817, 0, 8),
(818, 'TXTCREDITTYPE', 2, 0, 818, 0, 0),
(819, 'TXTORDERS', 2, 0, 819, 0, 0),
(820, 'TXTORDER', 1, 0, 820, 0, 0),
(821, 'TXTCONTRLICETYPE', 2, 0, 821, 0, 0),
(822, 'TXTEACHWORD', 2, 0, 822, 0, 0),
(823, 'TXTMODEL', 2, 0, 823, 0, 0),
(824, 'TXTENABLEJOINBEFORHOST', 2, 0, 824, 0, 0),
(825, 'TXTVALUE', 2, 0, 825, 0, 14),
(826, 'TXTEMPTYTRASH', 2, 0, 826, 0, 2),
(827, 'TXTASCLIENT', 2, 0, 827, 0, 2),
(828, 'TXTINCOME', 2, 0, 828, 0, 5),
(829, 'TXTEDITPRODUCT', 2, 0, 829, 0, 8),
(830, 'TXTDELFBINT', 2, 0, 830, 0, 8),
(831, 'TXTINVLIDFIELD', 2, 0, 831, 0, 8),
(832, 'TXTAVGSLA', 2, 0, 832, 0, 7),
(833, 'TXTLABELEXIST', 2, 0, 833, 0, 8),
(834, 'TXTCNTCLIENTAD', 2, 0, 834, 0, 0),
(835, 'TKTMRGCLIENT', 2, 0, 835, 0, 0),
(836, 'TKTMRGCONTACT', 2, 0, 836, 0, 0),
(837, 'TXTCUSTDUETIME', 2, 0, 837, 0, 0),
(838, 'TXTDELETELABEL', 2, 0, 838, 0, 2),
(839, 'TXTONUNRESOLVED', 2, 0, 839, 0, 0),
(840, 'TXTADDITIONALATTRIBUTE', 2, 0, 840, 0, 14),
(841, 'TXTTRANSACTIONKEY', 2, 0, 841, 0, 8),
(842, 'TXTGATEWAYMODE', 2, 0, 842, 0, 8),
(843, 'TXTGATEWAYTRANSACTIONS', 2, 0, 843, 0, 0),
(844, 'TXTGATEWAYTRANSACTIONDETAILS', 2, 0, 844, 0, 8),
(845, 'MSGDELETEGATEWAYTXNLOG', 2, 0, 845, 0, 8),
(846, 'MSGTRUNCATEGATEWAYTXNLOG', 2, 0, 846, 0, 8),
(847, 'TXTRECURRING', 2, 0, 847, 0, 0),
(848, 'TXTTICKETHASHGENERATION', 2, 0, 848, 0, 2),
(849, 'TXTRANDOM', 2, 0, 849, 0, 8),
(850, 'TXTSEQUENTIAL', 2, 0, 850, 0, 8),
(851, 'TXTPREFIX', 2, 0, 851, 0, 8),
(852, 'TXTNUMERINGSTARTSFROM', 2, 0, 852, 0, 8),
(853, 'MSGTICKETHASHPREFIXERROR', 2, 0, 853, 0, 8),
(854, 'MSGTICKETNUMERINGSTARTSFROMERROR', 2, 0, 854, 0, 8),
(855, 'TXTAUTHENTICATIONERROR', 1, 0, 855, 0, 0),
(856, 'TXTCONNECTIONERROR', 1, 0, 856, 0, 0),
(857, 'TXTSMTPAUTHENTICATIONERROR', 2, 0, 857, 0, 8),
(858, 'TXTCLIENTSEARCH', 2, 0, 858, 0, 3),
(859, 'TXTISAPPROVE', 2, 0, 859, 0, 8),
(860, 'TXTSELFHELPSEARCH', 2, 0, 860, 0, 2),
(861, 'TXTEXPORTALL', 2, 0, 861, 0, 0),
(862, 'TXTNOTIFICATION', 2, 0, 862, 0, 0),
(863, 'TXTDISPLAYNOTIFICATION', 2, 0, 863, 0, 0),
(864, 'TXTISFORWARDEMAIL', 2, 0, 864, 0, 8),
(865, 'TXTFORWARDEMAIL', 2, 0, 865, 0, 8),
(866, 'TXTVERIFYEMAILQUEUE', 2, 0, 866, 0, 8),
(867, 'TXTSTOPTIMER', 2, 0, 867, 0, 2),
(868, 'TXTTIMETRACK', 2, 0, 868, 0, 0),
(869, 'TXTADDTIMETRACK', 2, 0, 869, 0, 0),
(870, 'TXTTIMETRACKID', 2, 0, 870, 0, 0),
(871, 'TXTBILLTIME', 2, 0, 871, 0, 0),
(872, 'TXTWORKTIME', 2, 0, 872, 0, 0),
(873, 'MSGTTVMISS', 2, 0, 873, 0, 2),
(874, 'TXTDELETETIMETRACK', 2, 0, 874, 0, 2),
(875, 'TXTATTRIBUTE', 2, 0, 875, 0, 0),
(876, 'TXTSHOWINLINEIMG', 2, 0, 876, 0, 0),
(877, 'TXTHIDEINLINEIMG', 2, 0, 877, 0, 0),
(878, 'TXTSLACHANGE', 2, 0, 878, 0, 0),
(879, 'MSGSNGLTKTEXPORT', 2, 0, 879, 0, 2),
(880, 'TXTGLOBALSEARCHERROR', 1, 0, 880, 0, 0),
(881, 'TXTSTAFFNOTIFICATION', 2, 0, 881, 0, 0),
(882, 'TXTLOADMORE', 1, 0, 882, 0, 0),
(883, 'TXTEXPORTCSV', 2, 0, 883, 0, 7),
(884, 'TXTFILTERLIST', 1, 0, 884, 0, 0),
(885, 'TXTLISTCOLUMN', 2, 0, 885, 0, 0),
(886, 'TXTUPDATEVIEW', 2, 0, 886, 0, 0),
(887, 'TXTATTACHMENT', 2, 0, 887, 0, 0),
(888, 'MSGCANNOTDEL', 2, 0, 888, 0, 0),
(889, 'TXTLATESTPOST', 2, 0, 889, 0, 0),
(890, 'TXTMANAGEPORTAL', 2, 0, 890, 0, 0),
(891, 'TXTMANAGEPORTALLOGO', 2, 0, 891, 0, 8),
(892, 'TXTMANAGEPORTALCOLOR', 2, 0, 892, 0, 8),
(893, 'TXTNEWTICKET', 2, 0, 893, 0, 0),
(894, 'TXTASGNDEPT', 2, 0, 894, 0, 8),
(895, 'TXTUPDATESTAFF', 2, 0, 895, 0, 8),
(896, 'TXTPERMISSION', 2, 0, 896, 0, 0),
(897, 'TXTUPDATESTAFFGROUP', 2, 0, 897, 0, 8),
(898, 'TXTUPDATEADMINACCESS', 2, 0, 898, 0, 8),
(899, 'TXTCHANGEOWNER', 2, 0, 899, 0, 0),
(900, 'TXTCHANGETYPE', 2, 0, 900, 0, 0),
(901, 'TXTSPLITTICKET', 2, 0, 901, 0, 0),
(902, 'TXTLINKUNLINKTICKET', 2, 0, 902, 0, 8),
(903, 'TXTUPDATESTATUS', 2, 0, 903, 0, 0),
(904, 'TXTUPDATEWORKFLOW', 2, 0, 904, 0, 8),
(905, 'TXTHOLIDAYS', 2, 0, 905, 0, 0),
(906, 'TXTADDHOLIDAY', 2, 0, 906, 0, 8),
(907, 'TXTDELETEHOLIDAY', 2, 0, 907, 0, 8),
(908, 'TXTUPDATEHOLIDAY', 2, 0, 908, 0, 8),
(909, 'TXTUPDATETYPE', 2, 0, 909, 0, 0),
(910, 'TXTSINCE', 2, 0, 910, 0, 0),
(911, 'TXTUPDATESCHEDULE', 2, 0, 911, 0, 8),
(912, 'TXTUPDATEFLAG', 2, 0, 912, 0, 8),
(913, 'TXTUPDATESLA', 2, 0, 913, 0, 8),
(914, 'TXTALREADYINUSE', 2, 0, 914, 0, 0),
(915, 'TXTIGNORE', 2, 0, 915, 0, 0),
(916, 'TXTTWOSMS', 2, 0, 916, 0, 8),
(917, 'TXTCHECKAPPROVALBEFORECLOSE', 2, 0, 917, 0, 8),
(918, 'TXTTRANSACTIONLOG', 2, 0, 918, 0, 8),
(919, 'TXTOVERRIDEDETAILS', 2, 0, 919, 0, 8),
(920, 'TXTUPDATEMAILQUEUE', 2, 0, 920, 0, 8),
(921, 'TXTORGANIZATIONS', 2, 0, 921, 0, 0),
(922, 'TXTAPPLYFILTER', 2, 0, 922, 0, 0),
(923, 'TXTUPDATECUSTOMFIELD', 2, 0, 923, 0, 8),
(924, 'TXTUPDATECUSTOMGROUP', 2, 0, 924, 0, 8),
(925, 'TXTINCIDENTPRIORITYBYREPORT', 2, 0, 925, 0, 7),
(926, 'TXTINCIDENTSTATUSBYREPORT', 2, 0, 926, 0, 7),
(927, 'TXTORGANIZATIONDETAILS', 2, 0, 927, 0, 0),
(928, 'TXTCOMPANY', 2, 0, 928, 0, 0),
(929, 'TXTUPDATEEMAILTEMPLATE', 2, 0, 929, 0, 8),
(930, 'TXTUPDATEALERT', 2, 0, 930, 0, 0),
(931, 'TXTLABELNAME', 2, 0, 931, 0, 8),
(932, 'TXTADDLABEL', 2, 0, 932, 0, 0),
(933, 'TXTLABELCOLOR', 2, 0, 933, 0, 8),
(934, 'TXTPAGES', 2, 0, 934, 0, 0),
(935, 'TXTFETCHPAGES', 2, 0, 935, 0, 0),
(936, 'TXTPAGENOTFOUND', 1, 0, 936, 0, 0),
(937, 'TXTUPDATELABEL', 2, 0, 937, 0, 0),
(938, 'TXTUPDATEMODULE', 2, 0, 938, 0, 8),
(939, 'TXTTICKETACTIVITY', 2, 0, 939, 0, 7),
(940, 'TXTSERVREQOVERVIEW', 2, 0, 940, 0, 7),
(941, 'TXTPREFERENCE', 2, 0, 941, 0, 3),
(942, 'TXTRECENTBLABS', 2, 0, 942, 0, 6),
(943, 'TXTINTERNALTICKET', 2, 0, 943, 0, 0),
(944, 'TXTADDCOMMENT', 1, 0, 944, 0, 0),
(945, 'TXTUPDATEINVOICE', 2, 0, 945, 0, 0),
(946, 'TXTLASTTICKETACTIVITY', 2, 0, 946, 0, 2),
(947, 'TXTREPLIED', 2, 0, 947, 0, 0),
(948, 'TXTAWAITING', 2, 0, 948, 0, 0),
(949, 'TXTCLOSED', 2, 0, 949, 0, 0),
(950, 'TXTSTAFFMEMBER', 2, 0, 950, 0, 1),
(951, 'TXTSKILLS', 2, 0, 951, 0, 0),
(952, 'TXTPHONENO', 2, 0, 952, 0, 0),
(953, 'TXTEMPTY', 2, 0, 953, 0, 0),
(954, 'TXTSENTMAILLOG', 2, 0, 954, 0, 0),
(955, 'TXTGATEWAYTRANSACTIONSLOG', 2, 0, 955, 0, 0),
(956, 'MSGCOREMODULESTATUS', 2, 0, 956, 0, 8),
(957, 'TXTDISPPAGES', 2, 0, 957, 0, 8),
(958, 'TXTPRODUCTID', 2, 0, 958, 0, 8),
(959, 'TXTENTRYDATE', 2, 0, 959, 0, 0),
(960, 'TXTSTAFFCOMMENT', 2, 0, 960, 0, 0),
(961, 'TXTRECENTACTIVITYCOUNT', 2, 0, 961, 0, 0),
(962, 'TXTONLINESTAFF', 2, 0, 962, 0, 0),
(963, 'TXTPOST', 1, 0, 963, 0, 0),
(964, 'TXTINSERTURL', 2, 0, 964, 0, 0),
(965, 'TXTATTACHEDMEDIA', 2, 0, 965, 0, 4),
(966, 'TXTUPLOADFROMLOCAL', 2, 0, 966, 0, 0),
(967, 'TXTATTACHMEDIA', 2, 0, 967, 0, 0),
(968, 'TXTADDORGANIZATION', 2, 0, 968, 0, 0),
(969, 'TXTUPDATEORGANIZATION', 2, 0, 969, 0, 0),
(970, 'TXTSAVEFILTER', 2, 0, 970, 0, 0),
(971, 'MSGFILTIDNTFND', 2, 0, 971, 0, 0),
(972, 'TXTUPDATEFILTER', 2, 0, 972, 0, 0),
(973, 'TXTINCIDENTTYPEBYREPORT', 2, 0, 973, 0, 7),
(974, 'TXTTOTARTICLES', 2, 0, 974, 0, 4),
(975, 'TXTTOTCATEGORY', 2, 0, 975, 0, 0),
(976, 'TXTHELPFULLARTICLES', 2, 0, 976, 0, 4),
(977, 'TXTARTICLES', 2, 0, 977, 0, 0),
(978, 'TXTUPDATECOMMENT', 2, 0, 978, 0, 0),
(979, 'TXTUPDATECATEGORY', 2, 0, 979, 0, 0),
(980, 'TXTUPDATEARTICLE', 2, 0, 980, 0, 0),
(981, 'TXTSORTEDBY', 2, 0, 981, 0, 4),
(982, 'TXTDELCOMMENT', 2, 0, 982, 0, 0),
(983, 'TXTNOW', 2, 0, 983, 0, 0),
(984, 'TXTWORK', 2, 0, 984, 0, 0),
(985, 'TXTDEPTSLA', 2, 0, 985, 0, 7),
(986, 'TXTRESPONSE', 2, 0, 986, 0, 7),
(987, 'TXTPERFORMANCE', 2, 0, 987, 0, 7),
(988, 'TXTCLIENTSLA', 2, 0, 988, 0, 7),
(989, 'TXTTKTRATINGS', 2, 0, 989, 0, 7),
(990, 'TXTTRACKINGSTAFF', 2, 0, 990, 0, 7),
(991, 'TXTTRACKINGDEPT', 2, 0, 991, 0, 7),
(992, 'TXTSTAFFSLA', 2, 0, 992, 0, 7),
(993, 'TXTTOPPERFORMER', 2, 0, 993, 0, 7),
(994, 'TXTDEPTSTATI', 2, 0, 994, 0, 7),
(995, 'TXTINCIDENTLEVELBYREPORT', 2, 0, 995, 0, 7),
(996, 'TXTTEAM', 2, 0, 996, 0, 0),
(997, 'TXTSELECTEDSTAFF', 2, 0, 997, 0, 0),
(998, 'TXTSEARCHBLABS', 2, 0, 998, 0, 6),
(999, 'TXTSEARCHSTAFF', 2, 0, 999, 0, 0),
(1000, 'TXTYEAR', 2, 0, 1000, 0, 0),
(1001, 'TXTEMAILADDRESS', 2, 0, 1001, 0, 0),
(1002, 'TXTWEBSITEURL', 2, 0, 1002, 0, 0),
(1003, 'TXTLOGOURL', 2, 0, 1003, 0, 8),
(1004, 'TXTPAYTOTEXT', 2, 0, 1004, 0, 8),
(1005, 'TXTSHIPTO', 2, 0, 1005, 0, 0),
(1006, 'TXTRPTRPRIORITYTITLE', 2, 0, 1006, 0, 7),
(1007, 'TXTNOTEHEADERCOLOR', 2, 0, 1007, 0, 0),
(1008, 'MSGDOMAINVAL', 2, 0, 1008, 0, 8),
(1009, 'MSGCLPORTURL', 2, 0, 1009, 0, 8),
(1010, 'TXTRPTRSTATUSTITLE', 2, 0, 1010, 0, 7),
(1011, 'TXTRMADMACC', 2, 0, 1011, 0, 8),
(1012, 'MSGADMNOTUP', 2, 0, 1012, 0, 0),
(1013, 'TXTLABELSTAGS', 2, 0, 1013, 0, 8),
(1014, 'MSGTILALPHNUM', 2, 0, 1014, 0, 0),
(1015, 'TXTLANGUAGE_SELECT', 2, 0, 1015, 0, 0),
(1016, 'TXTDEFAULTVARIABLES', 2, 0, 1016, 0, 8),
(1017, 'TXTDASHBOARD', 2, 0, 1017, 0, 0),
(1018, 'TXTCHANNELS', 2, 0, 1018, 0, 2),
(1019, 'TXTTICKETTYPES', 2, 0, 1019, 0, 2),
(1020, 'TXTDISPLAYIPADDRESSTOSTAFF', 2, 0, 1020, 0, 0),
(1021, 'TXTIPADDRESS', 2, 0, 1021, 0, 0),
(1022, 'TXTNOTEPOSTEDBY', 2, 0, 1022, 0, 2),
(1023, 'TXTCOMMENTPOSTEDBY', 2, 0, 1023, 0, 2),
(1024, 'MSGBLABCNTNUM', 2, 0, 1024, 0, 0),
(1025, 'MSGDUETIMEFORMAT', 2, 0, 1025, 0, 8),
(1026, 'MSGRECENTACTIVITYNUM', 2, 0, 1026, 0, 8),
(1027, 'MSGATTACHMENTNUM', 2, 0, 1027, 0, 8),
(1028, 'MSGMAXATTACHMENTNUM', 2, 0, 1028, 0, 8),
(1029, 'MSGTKTHASHPREFIX', 2, 0, 1029, 0, 8),
(1030, 'MSGTKTSTARTEMPTY', 2, 0, 1030, 0, 8),
(1031, 'MSGTKTPOSTCNTNUM', 2, 0, 1031, 0, 8),
(1032, 'MSGFORWARDTO', 2, 0, 1032, 0, 2),
(1033, 'MSGFORWARDEMAILMISS', 2, 0, 1033, 0, 8),
(1034, 'TXTMARKASBAN', 2, 0, 1034, 0, 8),
(1035, 'TXTMARKASSPAM', 2, 0, 1035, 0, 8),
(1036, 'MSGREQFILEXEORDERNUM', 2, 0, 1036, 0, 0),
(1037, 'MSGDEFAULTCRITERIA', 2, 0, 1037, 0, 0),
(1038, 'TXTAUTORESPONDEREMAIL', 2, 0, 1038, 0, 8),
(1039, 'TXTUPDATEPRODUCT', 2, 0, 1039, 0, 0),
(1040, 'TXTUPDATEPPAYMNT', 2, 0, 1040, 0, 8),
(1041, 'TXTUPDATETAX', 2, 0, 1041, 0, 8),
(1042, 'MSGTRANSACTIONKEYEMPTY', 2, 0, 1042, 0, 8),
(1043, 'TXTADDLOCALISATION', 2, 0, 1043, 0, 8),
(1044, 'TXTSEARCHWORDPHRESES', 2, 0, 1044, 0, 8),
(1045, 'TXTLANGVAR', 2, 0, 1045, 0, 8),
(1046, 'TXTLANGVAL', 2, 0, 1046, 0, 8),
(1047, 'MSGLANGTRANS', 2, 0, 1047, 0, 8),
(1048, 'MSGLANGVARCAP', 2, 0, 1048, 0, 8),
(1049, 'MSGLANGVARAVIL', 2, 0, 1049, 0, 8),
(1050, 'MSGSERBOX', 2, 0, 1050, 0, 8),
(1051, 'TXTDELLOCAL', 2, 0, 1051, 0, 8),
(1052, 'TXTPER', 2, 0, 1052, 0, 0),
(1053, 'TXTWEEK', 2, 0, 1053, 0, 0),
(1054, 'TXTTICKETSBYTYPE', 2, 0, 1054, 0, 7),
(1055, 'TXTTICKETSBYCHANNELS', 2, 0, 1055, 0, 7),
(1056, 'TXTTICKETSBYPRIORITIES', 2, 0, 1056, 0, 7),
(1057, 'TXTPOINTS', 2, 0, 1057, 0, 0),
(1058, 'TXTTKTREPLIEDAFTEROVERDUETIME', 2, 0, 1058, 0, 7),
(1059, 'TXTTKTREPLIEDWITHOUTSLA', 2, 0, 1059, 0, 7),
(1060, 'TXTTKTREPLIEDWITHINDUETIME', 2, 0, 1060, 0, 7),
(1061, 'TXTALLDOMAIN', 2, 0, 1061, 0, 0),
(1062, 'TXTHIDERECIPIENTNPEOPLE', 2, 0, 1062, 0, 7),
(1063, 'TXTUPDATECHANNEL', 2, 0, 1063, 0, 0),
(1064, 'TXTDELCHANNEL', 2, 0, 1064, 0, 0),
(1065, 'TXTHEIGHT', 2, 0, 1065, 0, 14),
(1066, 'MSGCHLNOTUP', 2, 0, 1066, 0, 0),
(1067, 'MSGIMGSIZE', 2, 0, 1067, 0, 8),
(1068, 'MSGCORECHANNELSTATUS', 2, 0, 1068, 0, 0),
(1069, 'TXTMAINTAIN', 2, 0, 1069, 0, 0),
(1070, 'MSGSTAFFMISS', 2, 0, 1070, 0, 8),
(1071, 'MSGENABLETICKCONV', 2, 0, 1071, 0, 8),
(1072, 'MSGRECORDNOTFOUND', 1, 0, 1072, 0, 0),
(1073, 'TXTRPTRTYPETITLE', 2, 0, 1073, 0, 7),
(1074, 'MSGSEARCHING', 2, 0, 1074, 0, 0),
(1075, 'MSGREQFLDSEMTY', 2, 0, 1075, 0, 0),
(1076, 'TXTADDTAG', 2, 0, 1076, 0, 0),
(1077, 'TXTDELETEBLABCOMMENT', 2, 0, 1077, 0, 6),
(1078, 'TXTLOGINTIME', 2, 0, 1078, 0, 8),
(1079, 'TXTONLINE', 2, 0, 1079, 0, 0),
(1080, 'TXTOFFLINE', 2, 0, 1080, 0, 0),
(1081, 'TXTTYPECOMMENTHERE', 2, 0, 1081, 0, 0),
(1082, 'TXTBLABSHAREDWITH', 2, 0, 1082, 0, 6),
(1083, 'TXTREPLYWITHQUOTE', 2, 0, 1083, 0, 0),
(1084, 'TXTDISPLAYNOTEONTICKETDETAILS', 2, 0, 1084, 0, 2),
(1085, 'TXTNOTES', 2, 0, 1085, 0, 0),
(1086, 'TXTENTTXTLOGO', 2, 0, 1086, 0, 8),
(1087, 'TXTTYPETOSEARCHEXISTINGCLIENTSEMAILADDRESS', 2, 0, 1087, 0, 0),
(1088, 'TXTTYPEHEREANDPRESSENTERTOSAVE', 2, 0, 1088, 0, 0),
(1089, 'MSGCOREORGSTATUS', 2, 0, 1089, 0, 3),
(1090, 'MSGWELCOMELINEONE', 1, 0, 1090, 0, 2),
(1091, 'TXTSERVICEASSIGNEDTONOBODY', 2, 0, 1091, 0, 7),
(1092, 'TXTTKTBAL', 1, 0, 1092, 0, 0),
(1093, 'MSGINFOMISS', 1, 0, 1093, 0, 0),
(1094, 'MSGSUCCOPRT', 1, 0, 1094, 0, 0),
(1095, 'MSGERROPRT', 1, 0, 1095, 0, 0),
(1096, 'TXTLINK', 2, 0, 1096, 0, 0),
(1097, 'TXTRELATESTO', 2, 0, 1097, 0, 0),
(1098, 'TXTISRELATEDTO', 2, 0, 1098, 0, 0),
(1099, 'TXTISAPARENTOF', 2, 0, 1099, 0, 0),
(1100, 'TXTISACHILDOF', 2, 0, 1100, 0, 0),
(1101, 'TXTDEPENDSON', 2, 0, 1101, 0, 0),
(1102, 'TXTISDEPENDEDON', 2, 0, 1102, 0, 0),
(1103, 'TXTDUPLICATES', 2, 0, 1103, 0, 0),
(1104, 'TXTISADUPLICATEDBY', 2, 0, 1104, 0, 0),
(1105, 'TXTPROFURL', 2, 0, 1105, 0, 0),
(1106, 'TXTDELETELINK', 2, 0, 1106, 0, 2),
(1107, 'TXTUNLINK', 2, 0, 1107, 0, 2),
(1108, 'TXTLINKTICKET', 2, 0, 1108, 0, 0),
(1109, 'TXTSPLIT', 2, 0, 1109, 0, 2),
(1110, 'TXTSPLITTICKETPOST', 2, 0, 1110, 0, 2),
(1111, 'TXTSPLITINTO', 2, 0, 1111, 0, 2),
(1112, 'TXTEXISTINGTICKET', 2, 0, 1112, 0, 2),
(1113, 'TXTENTERTICKETSUBJECT', 2, 0, 1113, 0, 2),
(1114, 'TXTENTERTICKETHASH', 2, 0, 1114, 0, 2),
(1115, 'TXTRPTRLEVELTITLE', 2, 0, 1115, 0, 7),
(1116, 'TXTINVOICEDATE', 1, 0, 1116, 0, 0),
(1117, 'TXTIMACERR', 2, 0, 1117, 0, 0),
(1118, 'TXTINVOICEITEMS', 2, 0, 1118, 0, 5),
(1119, 'TXTDESCRIPTIONS', 2, 0, 1119, 0, 0),
(1120, 'TXTTAXED', 2, 0, 1120, 0, 5),
(1121, 'TXTAPPLYCREDIT', 2, 0, 1121, 0, 5),
(1122, 'TXTAPPROVALREQ', 2, 0, 1122, 0, 2),
(1123, 'MSGINVAMT', 2, 0, 1123, 0, 0),
(1124, 'TXTAVAILABLECREDIT', 2, 0, 1124, 0, 5),
(1125, 'TXTDELINVOICEITEM', 2, 0, 1125, 0, 5),
(1126, 'TXTREMOVECREDIT', 2, 0, 1126, 0, 5),
(1127, 'TXTCREDITAPPLIED', 2, 0, 1127, 0, 5),
(1128, 'MSGNUMCREDITVAL', 2, 0, 1128, 0, 5),
(1129, 'MSGGREATERCREDITREMOVE', 2, 0, 1129, 0, 5),
(1130, 'MSGNOTSUFFICIENTCREDIT', 2, 0, 1130, 0, 5),
(1131, 'TXTSELECTMAILTEMPLATE', 2, 0, 1131, 0, 5),
(1132, 'TXTDELORDER', 2, 0, 1132, 0, 5),
(1133, 'MSGNOMORECREDITTHANTOTAL', 2, 0, 1133, 0, 5),
(1134, 'MSGARTNTSEL', 2, 0, 1134, 0, 4),
(1135, 'TXTDISAPPROVE', 2, 0, 1135, 0, 0),
(1136, 'MSGCOMNTSEL', 2, 0, 1136, 0, 4),
(1137, 'MSGSERART', 1, 0, 1137, 0, 0),
(1138, 'MSGSERARTBOX', 2, 0, 1138, 0, 4),
(1139, 'TXTSOCIALMEDIADETAILS', 2, 0, 1139, 0, 0),
(1140, 'TXTIGNORED', 2, 0, 1140, 0, 0),
(1141, 'TXTLICENSECONTROL', 2, 0, 1141, 0, 0),
(1142, 'TXTGAMIFICATION', 2, 0, 1142, 0, 0),
(1143, 'TXTADDPOINT', 2, 0, 1143, 0, 8),
(1144, 'TXTBONUSPOINT', 2, 0, 1144, 0, 0),
(1145, 'TXTAWARDPOINT', 2, 0, 1145, 0, 8),
(1146, 'TXTSTAFFLEVEL', 2, 0, 1146, 0, 8),
(1147, 'TXTKING', 2, 0, 1147, 0, 8),
(1148, 'TXTQUEEN', 2, 0, 1148, 0, 8),
(1149, 'TXTROOK', 2, 0, 1149, 0, 8),
(1150, 'TXTBISHOP', 2, 0, 1150, 0, 8),
(1151, 'TXTKNIGHT', 2, 0, 1151, 0, 8),
(1152, 'TXTPAWN', 2, 0, 1152, 0, 8),
(1153, 'TXTNUMERICVALIDATIONERROR', 2, 0, 1153, 0, 8),
(1154, 'TXTQUEST', 2, 0, 1154, 0, 0),
(1155, 'TXTQUESTADD', 2, 0, 1155, 0, 8),
(1156, 'TXTQUESTTYPE', 2, 0, 1156, 0, 0),
(1157, 'TXTRESOLVINGTYPE', 2, 0, 1157, 0, 0),
(1158, 'TXTQUESTOBJECTIVE', 2, 0, 1158, 0, 8),
(1159, 'TXTRESOLVE', 2, 0, 1159, 0, 8),
(1160, 'TXTBADGE', 2, 0, 1160, 0, 0),
(1161, 'TXTNAMEYOURQUEST', 2, 0, 1161, 0, 8),
(1162, 'TXTQUESTDESCRIPTION', 2, 0, 1162, 0, 8),
(1163, 'TXTARTICLECOUNT', 2, 0, 1163, 0, 8),
(1164, 'TXTTICKETSLOVEDSPAN', 2, 0, 1164, 0, 8),
(1165, 'TXTTICKETMATCHINGBELOWCONTAIN', 2, 0, 1165, 0, 8),
(1166, 'TXTARTICLEQUESTTIMEKNOW', 2, 0, 1166, 0, 8),
(1167, 'TXTCREATE', 2, 0, 1167, 0, 0),
(1168, 'TXTDELQUEST', 2, 0, 1168, 0, 8),
(1169, 'TXTUPDATEQUEST', 2, 0, 1169, 0, 8),
(1170, 'TXTSELECTBADGE', 2, 0, 1170, 0, 8),
(1171, 'TXTBADGEIMAGEMSG', 2, 0, 1171, 0, 8),
(1172, 'MSGINVOICENOTSELECTED', 2, 0, 1172, 0, 0),
(1173, 'TXTTHISTICKETISLINKEDWITHOTHER', 2, 0, 1173, 0, 0),
(1174, 'TXTTRANSACTION', 2, 0, 1174, 0, 5),
(1175, 'TXTUPDATEORDER', 2, 0, 1175, 0, 5),
(1176, 'TXTPAYMENTSTATUS', 2, 0, 1176, 0, 0),
(1177, 'TXTNOINVOICE', 2, 0, 1177, 0, 0),
(1178, 'TXTADDINVOICEPAYMENT', 2, 0, 1178, 0, 5),
(1179, 'MSGNUMERICDATAREQ', 2, 0, 1179, 0, 0),
(1180, 'MSGSERACHTEXTEMPTY', 1, 0, 1180, 0, 0),
(1181, 'TXTNOTHINGTODISPLAY', 1, 0, 1181, 0, 0),
(1182, 'TXTTODAYS', 2, 0, 1182, 0, 0),
(1183, 'TXTSEARCHINVOICE', 2, 0, 1183, 0, 5),
(1184, 'TXTFILTERRESULT', 2, 0, 1184, 0, 0),
(1185, 'TXTSORTBY', 1, 0, 1185, 0, 0),
(1186, 'TXTSELECTSTAFF', 2, 0, 1186, 0, 0),
(1187, 'MSGLISTCNTNUMERIC', 2, 0, 1187, 0, 0),
(1188, 'TXTACTIVE', 1, 0, 1188, 0, 0),
(1189, 'TXTPENDING', 1, 0, 1189, 0, 0),
(1190, 'TXTINCOMPLETE', 1, 0, 1190, 0, 0),
(1191, 'TXTINVOICEDUEONDAYS', 2, 0, 1191, 0, 8),
(1192, 'MSGNUMERICVALIDATIONFORINVDUE', 2, 0, 1192, 0, 8),
(1193, 'MSGNUMERICVALIDATIONFORBILLRT', 2, 0, 1193, 0, 8),
(1194, 'TXTOVERVIEW', 2, 0, 1194, 0, 0),
(1195, 'TXTTOTALTICKETS', 2, 0, 1195, 0, 7),
(1196, 'TXTTOTALTICKETSREPLIED', 2, 0, 1196, 0, 7),
(1197, 'TICKETSREPLEDPERHOUR', 2, 0, 1197, 0, 7),
(1198, 'TXTTOTALTICKETSCLOSED', 2, 0, 1198, 0, 7),
(1199, 'TXTOTALOVERDUETICKETS', 2, 0, 1199, 0, 7),
(1200, 'TXTAVGSLAMAINTAINED', 2, 0, 1200, 0, 7),
(1201, 'TXTYESTERDAY', 2, 0, 1201, 0, 8),
(1202, 'TXTSELFHELFARTICLE', 2, 0, 1202, 0, 0),
(1203, 'TXTTICKSBYSTATUS', 2, 0, 1203, 0, 7),
(1204, 'TXTTEXT', 2, 0, 1204, 0, 0),
(1205, 'TXTLASTMONTH', 2, 0, 1205, 0, 0),
(1206, 'TXTLASTWEEK', 2, 0, 1206, 0, 0),
(1207, 'MSGINVCRED', 2, 0, 1207, 0, 5),
(1208, 'MSGPWDRESET', 2, 0, 1208, 0, 3),
(1209, 'TXTRESOLUSION', 2, 0, 1209, 0, 2),
(1210, 'TXTLOCKED', 2, 0, 1210, 0, 0),
(1211, 'TXTUNLOCKED', 2, 0, 1211, 0, 0),
(1212, 'TXTCLIENTLANGUAGE', 2, 0, 1212, 0, 0),
(1213, 'TXTTOEMAIL', 2, 0, 1213, 0, 0),
(1214, 'TXTDELPIN', 2, 0, 1214, 0, 1),
(1215, 'MSGMOVETODEPT', 2, 0, 1215, 0, 2),
(1216, 'TXTSENDTO', 2, 0, 1216, 0, 0),
(1217, 'TXTALLTEAM', 2, 0, 1217, 0, 8),
(1218, 'MSGTICKHASHTOMRG', 2, 0, 1218, 0, 2),
(1219, 'MSGTICKHASHLINK', 2, 0, 1219, 0, 0),
(1220, 'TXTMULTIPLEOWNERS', 2, 0, 1220, 0, 0),
(1221, 'TXTOWNERS', 2, 0, 1221, 0, 0),
(1222, 'TXTSENDNOTIFORNEWBLAB', 2, 0, 1222, 0, 0),
(1223, 'TXTCHANGELABEL', 2, 0, 1223, 0, 8),
(1224, 'TXTCHANGECHANNEL', 2, 0, 1224, 0, 8),
(1225, 'MSGTICKFRMDIFFDOMNOTMERGE', 2, 0, 1225, 0, 2),
(1226, 'TXTFORWARDEDTO', 1, 0, 1226, 0, 2),
(1227, 'TXTTO', 1, 0, 1227, 0, 0),
(1228, 'TXTREPLIEDTO', 1, 0, 1228, 0, 0),
(1229, 'TXTSECURITY', 2, 0, 1229, 0, 0),
(1230, 'MSGSENDREGISTRATIONEMAIL', 2, 0, 1230, 0, 3),
(1231, 'MSGOPTIONVALREQ', 2, 0, 1231, 0, 8),
(1232, 'MSGAUTOGENERATEPASSWORD', 2, 0, 1232, 0, 0),
(1233, 'TXTADDSECURITY', 2, 0, 1233, 0, 8),
(1234, 'TXTIPSECURITY', 2, 0, 1234, 0, 8),
(1235, 'TXTPASSWORDSECURITY', 2, 0, 1235, 0, 8),
(1236, 'TXTSECURITYIPCHK', 2, 0, 1236, 0, 8),
(1237, 'TXTSINGLE', 2, 0, 1237, 0, 8),
(1238, 'TXTRANGE', 2, 0, 1238, 0, 8);
INSERT INTO `avis_language_variables` VALUES
(1239, 'TXTRESOLUSIONON', 2, 0, 1239, 0, 2),
(1240, 'TXTPASSWORDFORMAT', 2, 0, 1240, 0, 0),
(1241, 'MSGSHOWPASSWORD', 2, 0, 1241, 0, 0),
(1242, 'MSGIMGVERIFY', 1, 0, 1242, 0, 0),
(1243, 'TXTDISPLAYCUSTOMONTICKETDETAILS', 2, 0, 1243, 0, 2),
(1244, 'MSGMORETHANONEREQFORSPLIT', 2, 0, 1244, 0, 2),
(1245, 'TXTIPEX', 2, 0, 1245, 0, 8),
(1246, 'TXTIPORIPRANGE', 2, 0, 1246, 0, 8),
(1247, 'TXTDELSECURITY', 2, 0, 1247, 0, 8),
(1248, 'MSGINVALIDIPR', 2, 0, 1248, 0, 8),
(1249, 'MSGINVALIDIP', 2, 0, 1249, 0, 8),
(1250, 'MSGIPBAN', 2, 0, 1250, 0, 0),
(1251, 'TXTMACROS', 2, 0, 1251, 0, 0),
(1252, 'TXTADDMACRO', 2, 0, 1252, 0, 1),
(1253, 'TXTUPDATEMACRO', 2, 0, 1253, 0, 1),
(1254, 'TXTIPORIPRANGELIST', 2, 0, 1254, 0, 8),
(1255, 'TXTAPPLYMACRO', 2, 0, 1255, 0, 0),
(1256, 'TXTPASSWORDSRENGTH', 1, 0, 1256, 0, 0),
(1257, 'TXTWEAK', 1, 0, 1257, 0, 0),
(1258, 'TXTMEDIUM', 1, 0, 1258, 0, 0),
(1259, 'TXTSTRONG', 1, 0, 1259, 0, 0),
(1260, 'TXTVERYSTRONG', 1, 0, 1260, 0, 0),
(1261, 'TXTNOTALLOWED', 1, 0, 1261, 0, 0),
(1262, 'TXTALLOWED', 1, 0, 1262, 0, 0),
(1263, 'TXTPASSWORDNOTALLOWED', 1, 0, 1263, 0, 0),
(1264, 'TXTDISPLAYSETTINGS', 2, 0, 1264, 0, 0),
(1265, 'TXTEXPENSETYPE', 2, 0, 1265, 0, 8),
(1266, 'TXTREDIRECTURL', 2, 0, 1266, 0, 8),
(1267, 'TXTDEVELOPERKEY', 2, 0, 1267, 0, 8),
(1268, 'TXTACTIVITYLOG', 2, 0, 1268, 0, 0),
(1269, 'TXTACTIVITY', 2, 0, 1269, 0, 0),
(1270, 'MSGEMACTIVITYLOG', 2, 0, 1270, 0, 8),
(1271, 'TXTADDSURVEYGRP', 2, 0, 1271, 0, 8),
(1272, 'TXTUPDATESURVEYGRP', 2, 0, 1272, 0, 8),
(1273, 'TXTDELETESURVEYGROUP', 2, 0, 1273, 0, 8),
(1274, 'MSGDELSURVEYGRP', 1, 0, 1274, 0, 8),
(1275, 'TXTCOSTMODEL', 2, 0, 1275, 0, 8),
(1276, 'TXTADDSURVEY', 2, 0, 1276, 0, 8),
(1277, 'TXTUPDATESURVEY', 2, 0, 1277, 0, 8),
(1278, 'TXTDELETESURVEY', 2, 0, 1278, 0, 8),
(1279, 'TXTSURVEYFIELD', 2, 0, 1279, 0, 0),
(1280, 'TXTADDSURVEYFIELD', 2, 0, 1280, 0, 8),
(1281, 'TXTDELETESURVEYFIELD', 2, 0, 1281, 0, 8),
(1282, 'TXTUPDATESURVEYFIELD', 2, 0, 1282, 0, 8),
(1283, 'TXTSURVEY', 1, 0, 1283, 0, 0),
(1284, 'MSGALREADYSUBMIT', 1, 0, 1284, 0, 0),
(1285, 'TXTVISITOR', 2, 0, 1285, 0, 0),
(1286, 'TXTCHATDETAILS', 2, 0, 1286, 0, 8),
(1287, 'TXTCHATTRANSCRIPT', 2, 0, 1287, 0, 8),
(1288, 'TXTCHAT', 2, 0, 1288, 0, 0),
(1289, 'MSGPASSMISSMTCH', 1, 0, 1289, 0, 0),
(1290, 'TXTSCRIPT', 2, 0, 1290, 0, 8),
(1291, 'TXTDATEFROM', 2, 0, 1291, 0, 0),
(1292, 'TXTDATETO', 2, 0, 1292, 0, 0),
(1293, 'TXTVISITOREMAIL', 2, 0, 1293, 0, 8),
(1294, 'TXTVISITORNAME', 2, 0, 1294, 0, 8),
(1295, 'TXTSTAFFNAME', 2, 0, 1295, 0, 0),
(1296, 'TXTCHATDURATION', 2, 0, 1296, 0, 8),
(1297, 'TXTSELECTMODULE', 2, 0, 1297, 0, 8),
(1298, 'MSGEMAILMISS', 1, 0, 1298, 0, 0),
(1299, 'MSGINVALIDLOGINDETAILS', 1, 0, 1299, 0, 0),
(1300, 'TXTCLEANUP', 2, 0, 1300, 0, 8),
(1301, 'TXTCONVERTTOTICKET', 2, 0, 1301, 0, 0),
(1302, 'TXTSYSTEMCLEANUP', 2, 0, 1302, 0, 0),
(1303, 'TXTUPTODATE', 2, 0, 1303, 0, 8),
(1304, 'MSGCLIENDEMLMISS', 1, 0, 1304, 0, 0),
(1305, 'TXTCLEANERROLOG', 2, 0, 1305, 0, 8),
(1306, 'TXTCLEANPARSERLOG', 2, 0, 1306, 0, 8),
(1307, 'TXTCLEANSENTMAIL', 2, 0, 1307, 0, 8),
(1308, 'TXTCLEANGATWAYTLOG', 2, 0, 1308, 0, 8),
(1309, 'TXTCLEANACTIVITYLOG', 2, 0, 1309, 0, 8),
(1310, 'TXTCLEANAUDITLOG', 2, 0, 1310, 0, 8),
(1311, 'TXTASSETDEPARTMENT', 1, 0, 1311, 0, 0),
(1312, 'MSGSURVEYERR', 1, 0, 1312, 0, 8),
(1313, 'TXTCHECKOUT', 1, 0, 1313, 0, 0),
(1314, 'TXTSELECTEDPRODUCT', 1, 0, 1314, 0, 0),
(1315, 'TXTSUBTOTAL', 1, 0, 1315, 0, 5),
(1316, 'TXTSELSURVEY', 2, 0, 1316, 0, 7),
(1317, 'TXTDISCOVERY', 2, 0, 1317, 0, 0),
(1318, 'TXTTASKTITLE', 2, 0, 1318, 0, 0),
(1319, 'TXTIMPORT', 2, 0, 1319, 0, 0),
(1320, 'MSGSLECTUPLOADCSVFILE', 2, 0, 1320, 0, 0),
(1321, 'TXTSELECTCSV', 2, 0, 1321, 0, 0),
(1322, 'MSGACCSSDND', 1, 0, 1322, 0, 0),
(1323, 'TXTSEARCHSTRING', 2, 0, 1323, 0, 0),
(1324, 'TXTCLICKHERE', 2, 0, 1324, 0, 0),
(1325, 'TXTSETSCHEDULE', 2, 0, 1325, 0, 1),
(1326, 'TXTSENDLOGINDETAILS', 2, 0, 1326, 0, 8),
(1327, 'TXTDONOTSENDEMAIL', 2, 0, 1327, 0, 8),
(1328, 'MSGSELCLIENT', 2, 0, 1328, 0, 8),
(1329, 'TXTGOTOMEETINGS', 2, 0, 1329, 0, 0),
(1330, 'MSGFIELDSNTSELECTED', 2, 0, 1330, 0, 0),
(1331, 'TXTSURVEYDATE', 2, 0, 1331, 0, 0),
(1332, 'TXTCALLBACKURL', 2, 0, 1332, 0, 8),
(1333, 'TXTSURVEYDETAILS', 2, 0, 1333, 0, 0),
(1334, 'TXTMARKASCOMPLETE', 2, 0, 1334, 0, 0),
(1335, 'TXTDATAWIPING', 2, 0, 1335, 0, 0),
(1336, 'TXTOR', 1, 0, 1336, 0, 0),
(1337, 'TXTEDITCUSTOMFIELD', 1, 0, 1337, 0, 0),
(1338, 'TXTNOTSPECIFIED', 2, 0, 1338, 0, 8),
(1339, 'TXTSENDDATAWIPINGREQ', 2, 0, 1339, 0, 14),
(1340, 'TXTMEETINGID', 2, 0, 1340, 0, 0),
(1341, 'TXTMAXPARTICIPANTS', 2, 0, 1341, 0, 0),
(1342, 'TXTMEETINGKEY', 2, 0, 1342, 0, 0),
(1343, 'TXTMEETINGTYPE', 2, 0, 1343, 0, 0),
(1344, 'TXTMEETINGUNIQUEID', 2, 0, 1344, 0, 0),
(1345, 'TXTADDMEETING', 2, 0, 1345, 0, 0),
(1346, 'TXTPASSWORDREQUIRED', 2, 0, 1346, 0, 8),
(1347, 'TXTIMMEDIATE', 2, 0, 1347, 0, 0),
(1348, 'TXTSCHEDULED', 2, 0, 1348, 0, 0),
(1349, 'TXTREMOTEACCESS', 2, 0, 1349, 0, 0),
(1350, 'TXTGOTOASSIST', 2, 0, 1350, 0, 0),
(1351, 'TXTINTEGRATIONAPP', 2, 0, 1351, 0, 1),
(1352, 'TXTLEGISLATIONCOMPLIANCE', 2, 0, 1352, 0, 0),
(1353, 'TXTDOWNLOAD', 2, 0, 1353, 0, 0),
(1354, 'TXTNEXTOVERDUETICKETS', 2, 0, 1354, 0, 2),
(1355, 'TXTFIFTEENMINUTES', 2, 0, 1355, 0, 0),
(1356, 'TXTTHIRTYMINUTES', 2, 0, 1356, 0, 0),
(1357, 'TXTONEDAY', 2, 0, 1357, 0, 0),
(1358, 'TXTTASK', 2, 0, 1358, 0, 0),
(1359, 'TXTTODAYTASK', 2, 0, 1359, 0, 1),
(1360, 'TXTMYTASK', 2, 0, 1360, 0, 0),
(1361, 'TXTASSIGNEDTASK', 2, 0, 1361, 0, 0),
(1362, 'TXTOVERDUETASK', 2, 0, 1362, 0, 0),
(1363, 'TXTMARKASCANCEL', 2, 0, 1363, 0, 0),
(1364, 'TXTUPDATETASK', 2, 0, 1364, 0, 0),
(1365, 'MSGTASKMARKASCANCELLED', 2, 0, 1365, 0, 0),
(1366, 'MSGTASKMARKASCOMPLETED', 2, 0, 1366, 0, 0),
(1367, 'TXTDELETEGOTOMEETING', 2, 0, 1367, 0, 0),
(1368, 'MSGTASKOVERDUE', 2, 0, 1368, 0, 1),
(1369, 'TXTADDUSER', 2, 0, 1369, 0, 0),
(1370, 'TXTBILLINGACCESS', 1, 0, 1370, 0, 0),
(1371, 'TXTWEBLINK', 2, 0, 1371, 0, 0),
(1372, 'MSGSEARCHTASK', 2, 0, 1372, 0, 0),
(1373, 'TXTCONFERENCECALLINFO', 2, 0, 1373, 0, 0),
(1374, 'MSGSERACHTASKBOX', 2, 0, 1374, 0, 0),
(1375, 'TXTCREATEMEETING', 2, 0, 1375, 0, 0),
(1376, 'TXTMEETING', 2, 0, 1376, 0, 0),
(1377, 'TXTJOINURL', 2, 0, 1377, 0, 0),
(1378, 'TXTJOINDATE', 2, 0, 1378, 0, 0),
(1379, 'TXTADDASSIST', 2, 0, 1379, 0, 8),
(1380, 'TXTMYFAVOURITES', 2, 0, 1380, 0, 0),
(1381, 'TXTCUSTOMDATA', 2, 0, 1381, 0, 0),
(1382, 'TXTCOPYTOCLIPBOARD', 2, 0, 1382, 0, 0),
(1383, 'TXTGROUPID', 2, 0, 1383, 0, 8),
(1384, 'TXTSETASFEATUREDARTICLE', 2, 0, 1384, 0, 0),
(1385, 'TXTASSIGNEDUSERID', 2, 0, 1385, 0, 0),
(1386, 'TXTASSIGNEDAT', 2, 0, 1386, 0, 0),
(1387, 'TXTENDCUSTOMERLINK', 2, 0, 1387, 0, 0),
(1388, 'TXTSUPPORTERLINK', 2, 0, 1388, 0, 0),
(1389, 'TXTCREATEDAT', 2, 0, 1389, 0, 0),
(1390, 'TXTVALIDUNTIL', 2, 0, 1390, 0, 0),
(1391, 'TXTDISPOSALREGULATION', 2, 0, 1391, 0, 0),
(1392, 'TXTPRIVACYDOC', 2, 0, 1392, 0, 0),
(1393, 'TXTSEARCHSTATE', 2, 0, 1393, 0, 0),
(1394, 'TXTEXPERTNAME', 2, 0, 1394, 0, 0),
(1395, 'TXTEXPERTEMAIL', 2, 0, 1395, 0, 0),
(1396, 'TXTMERGEINTO', 2, 0, 1396, 0, 2),
(1397, 'TXTRESETPASSWORD', 1, 0, 1397, 0, 0),
(1398, 'TXTUNASSIGNED', 1, 0, 1398, 0, 0),
(1399, 'TXTDOWNLOADQUEUE', 2, 0, 1399, 0, 7),
(1400, 'TXTSAVEREPORT', 2, 0, 1400, 0, 7),
(1401, 'TXTREPORTTITLE', 2, 0, 1401, 0, 0),
(1402, 'TXTDELETESELFHELPCOMMENT', 2, 0, 1402, 0, 4),
(1403, 'TXTCOMPLETEDDATE', 2, 0, 1403, 0, 7),
(1404, 'MSGSURE', 1, 0, 1404, 0, 0),
(1405, 'MSGCLTUSERNAMEEXIST', 1, 0, 1405, 0, 0),
(1406, 'TXTDELETEWEBEX', 2, 0, 1406, 0, 8),
(1407, 'TXTSITEID', 2, 0, 1407, 0, 8),
(1408, 'TXTPARTNERID', 2, 0, 1408, 0, 8),
(1409, 'TXTTOTALPOSTCOUNT', 2, 0, 1409, 0, 7),
(1410, 'TXTTOTALAVGRESPONSETIME', 2, 0, 1410, 0, 7),
(1411, 'TXTTOTALAVGSLAMAINTAINED', 2, 0, 1411, 0, 7),
(1412, 'TXTTOTALAVGSLATIME', 2, 0, 1412, 0, 7),
(1413, 'TXTTOTALAVGRESOLVETIME', 2, 0, 1413, 0, 7),
(1414, 'TXTWORST', 2, 0, 1414, 0, 0),
(1415, 'TXTNORMAL', 2, 0, 1415, 0, 0),
(1416, 'TXTTOTALBILLTIME', 2, 0, 1416, 0, 0),
(1417, 'TXTTOTALWORKTIME', 2, 0, 1417, 0, 0),
(1418, 'TXTTOTALAMOUNT', 2, 0, 1418, 0, 0),
(1419, 'TXTSURVEYURL', 2, 0, 1419, 0, 8),
(1420, 'TXTPHYSICALLOC', 1, 0, 1420, 0, 0),
(1421, 'MSGMAXIMAGEWIDTHSIZE', 2, 0, 1421, 0, 0),
(1422, 'TXTSELECTDATE', 2, 0, 1422, 0, 0),
(1423, 'TXTSTORAGELOC', 1, 0, 1423, 0, 0),
(1424, 'TXTAFFECTEDVERSION', 2, 1, 1424, 0, 0),
(1425, 'TXTRELEASEVERSION', 2, 1, 1425, 0, 0),
(1426, 'TXTRELEASEDISTRIBUTION', 2, 1, 1426, 0, 0),
(1427, 'TXTTECHNOLOGY', 2, 1, 1427, 0, 0),
(1428, 'TXTDEPLOYDESC', 2, 1, 1428, 0, 0),
(1429, 'TXTCLOSETKT', 2, 0, 1429, 0, 7),
(1430, 'TXTVALIDATIONANDTESTING', 2, 0, 1430, 0, 10),
(1431, 'TXTSELORG', 2, 0, 1431, 0, 0),
(1432, 'TXTACCOUNTSID', 2, 0, 1432, 0, 8),
(1433, 'TXTSERVICETRANSITION', 2, 0, 1433, 0, 10),
(1434, 'TXTRELEASECOMPOAQC', 2, 1, 1434, 0, 0),
(1435, 'TXTORGNIZATIONTICKET', 2, 0, 1435, 0, 7),
(1436, 'TXTOPERATIONDATE', 2, 0, 1436, 0, 0),
(1437, 'TXTCONTENT', 1, 0, 1437, 0, 0),
(1438, 'TXTCLIENTSURVEY', 2, 0, 1438, 0, 7),
(1439, 'TXTTICKETRATINGPERCLIENT', 2, 0, 1439, 0, 7),
(1440, 'TXTCALL', 1, 0, 1440, 0, 0),
(1441, 'TXTSECONDS', 2, 0, 1441, 0, 0),
(1442, 'TXTPRICEUNIT', 2, 0, 1442, 0, 0),
(1443, 'TXTRECORDING', 2, 0, 1443, 0, 0),
(1444, 'TXTINCOMING', 2, 0, 1444, 0, 0),
(1445, 'TXTOUTGOING', 2, 0, 1445, 0, 0),
(1446, 'TXTCALLDETAILS', 2, 0, 1446, 0, 0),
(1447, 'TXTTWILIOMSG', 2, 0, 1447, 0, 0),
(1448, 'TXTSENDDATE', 1, 0, 1448, 0, 0),
(1449, 'TXTMSGDEATILS', 2, 0, 1449, 0, 0),
(1450, 'TXTUPDATEDATE', 2, 0, 1450, 0, 0),
(1451, 'TXTSENDMESSAGE', 2, 0, 1451, 0, 0),
(1452, 'TXTHANGUP', 2, 0, 1452, 0, 0),
(1453, 'TXTCALLLIST', 2, 0, 1453, 0, 0),
(1454, 'TXTADDITIONALFIELDS', 1, 0, 1454, 0, 0),
(1455, 'TXTEDIT', 1, 0, 1455, 0, 0),
(1456, 'TXTBALANCE', 1, 0, 1456, 0, 0),
(1457, 'TXTRESOLUTIONTIME', 1, 0, 1457, 0, 0),
(1458, 'TXTDUETIME', 1, 0, 1458, 0, 0),
(1459, 'TXTOFFLINEPAYMENT', 1, 0, 1459, 0, 5),
(1460, 'TXTGATEWAY', 1, 0, 1460, 0, 0),
(1461, 'TXTPAYMENTMETHOD', 1, 0, 1461, 0, 5),
(1462, 'TXTLEADERBOARD', 2, 0, 1462, 0, 7),
(1463, 'TXTCREDIT', 1, 0, 1463, 0, 0),
(1464, 'TXTHOWCANWEHELP', 1, 0, 1464, 0, 0),
(1465, 'TXTINCIDENTBUILDRPT', 2, 0, 1465, 0, 7),
(1466, 'TXTDEFINATION', 1, 0, 1466, 0, 2),
(1467, 'TXTADDIMPACT', 2, 0, 1467, 0, 8),
(1468, 'TXTDELCONFIGURATIONITEM', 2, 0, 1468, 0, 8),
(1469, 'TXTUPDATEIMPACT', 2, 0, 1469, 0, 8),
(1470, 'TXTSERVICEACCTESTING', 2, 1, 1470, 0, 0),
(1471, 'TXTDELIMPACT', 2, 0, 1471, 0, 8),
(1472, 'TXTADDRISK', 2, 0, 1472, 0, 0),
(1473, 'TXTRISK', 1, 0, 1473, 0, 0),
(1474, 'TXTUPDATERISK', 2, 0, 1474, 0, 8),
(1475, 'TXTREJECTEDBYAPPROVER', 1, 1, 1475, 0, 0),
(1476, 'TXTDELRISK', 2, 0, 1476, 0, 8),
(1477, 'TXTDELCHANGETYPE', 2, 1, 1477, 0, 8),
(1478, 'TXTADDCHANGETYPE', 2, 1, 1478, 0, 8),
(1479, 'TXTUPDATECHANGETYPE', 2, 1, 1479, 0, 0),
(1480, 'TXTRELEASETYPE', 2, 1, 1480, 0, 0),
(1481, 'TXTDELRELEASETYPE', 2, 1, 1481, 0, 8),
(1482, 'TXTUPDATERELEASETYPE', 2, 1, 1482, 0, 0),
(1483, 'TXTADDRELEASETYPE', 2, 1, 1483, 0, 8),
(1484, 'TXTCONTRACTTYPE', 2, 0, 1484, 0, 0),
(1485, 'TXTASSETSTATE', 2, 0, 1485, 0, 0),
(1486, 'TXTADDASSETSTATE', 2, 0, 1486, 0, 8),
(1487, 'TXTUPDATEASSETSTATE', 2, 0, 1487, 0, 8),
(1488, 'TXTDELASSETSTATE', 2, 0, 1488, 0, 8),
(1489, 'TXTREQUESTSTAGE', 2, 1, 1489, 0, 10),
(1490, 'TXTADDCONTRACTTYPE', 2, 0, 1490, 0, 8),
(1491, 'TXTUPDATECONTRACTTYPE', 2, 0, 1491, 0, 8),
(1492, 'TXTVENDOR', 1, 0, 1492, 0, 0),
(1493, 'TXTADDVENDOR', 2, 0, 1493, 0, 8),
(1494, 'TXTUPDATEVENDOR', 2, 0, 1494, 0, 8),
(1495, 'TXTDELVENDOR', 2, 0, 1495, 0, 8),
(1496, 'TXTPARTIALLYCOMPLETED', 2, 1, 1496, 0, 0),
(1497, 'TXTROLLBACKAFTERFAILURE', 2, 1, 1497, 0, 0),
(1498, 'TXTCOMPLETEDWITHFAILURE', 2, 1, 1498, 0, 0),
(1499, 'TXTCOMPLETEDSUCCESSFULLY', 2, 1, 1499, 0, 0),
(1500, 'TXTASSET', 1, 0, 1500, 0, 0),
(1501, 'TXTPRICONTACT', 2, 0, 1501, 0, 8),
(1502, 'TXTDELREQUESTSTAGE', 2, 0, 1502, 0, 7),
(1503, 'TXTADDREQUESTSTAGE', 2, 0, 1503, 0, 7),
(1504, 'TXTLIFECYCLESTATUS', 1, 0, 1504, 0, 0),
(1505, 'TXTUPDATEREQUESTSTAGE', 2, 0, 1505, 0, 7),
(1506, 'TXTONASSETEXPIRE', 2, 0, 1506, 0, 8),
(1507, 'TXTFINANCEMANAGEMENT', 2, 0, 1507, 0, 0),
(1508, 'TXTFINANCETYPE', 2, 0, 1508, 0, 8),
(1509, 'TXTDELFINANCETYPE', 2, 0, 1509, 0, 8),
(1510, 'TXTADDFINANCETYPE', 2, 0, 1510, 0, 8),
(1511, 'TXTUPDATEFINANCETYPE', 2, 0, 1511, 0, 8),
(1512, 'TXTADDDEPRECIATION', 2, 0, 1512, 0, 8),
(1513, 'TXTDISPOSITIONSTATUS', 1, 0, 1513, 0, 0),
(1514, 'TXTSELECTFINANCETYPE', 2, 0, 1514, 0, 8),
(1515, 'TXTSENDAPPROVALFORCHANGES', 2, 0, 1515, 0, 8),
(1516, 'TXTDELFINANCE', 2, 0, 1516, 0, 8),
(1517, 'TXTCICUSTOMFIELD', 2, 0, 1517, 0, 8),
(1518, 'TXTCLOSEALLTICKETSLINKEDTOCHGPRB', 2, 1, 1518, 0, 8),
(1519, 'TXTUPDATELICENSETYPE', 2, 0, 1519, 0, 8),
(1520, 'TXTADDLICENSETYPE', 2, 0, 1520, 0, 8),
(1521, 'TXTDELLICENSETYPE', 2, 0, 1521, 0, 8),
(1522, 'TXTDELCICUSTOMFIELD', 2, 0, 1522, 0, 8),
(1523, 'TXTADDCICUSTOMFIELD', 2, 0, 1523, 0, 8),
(1524, 'TXTDELCIPRODUCT', 2, 0, 1524, 0, 8),
(1525, 'TXTADDCIPRODSTATUS', 2, 0, 1525, 0, 8),
(1526, 'TXTCIPRODSTATUS', 2, 0, 1526, 0, 0),
(1527, 'TXTUPDATECIPRODSTATUS', 2, 0, 1527, 0, 8),
(1528, 'TXTUPDATECICUSTOMFIELD', 2, 0, 1528, 0, 8),
(1529, 'TXTADDLOCATION', 2, 0, 1529, 0, 8),
(1530, 'TXTCLOSEALLPRBLINKEDTOCHG', 2, 1, 1530, 0, 0),
(1531, 'TXTPROCUREMODE', 2, 0, 1531, 0, 0),
(1532, 'TXTADDPROCUREMODE', 2, 0, 1532, 0, 8),
(1533, 'TXTUPDATEPROCUREMODE', 2, 0, 1533, 0, 8),
(1534, 'TXTDELPROCUREMODE', 2, 0, 1534, 0, 8),
(1535, 'TXTSTAGES', 2, 0, 1535, 0, 0),
(1536, 'TXTADDDEPRECIATIONTYPE', 2, 0, 1536, 0, 8),
(1537, 'TXTUPDATEDEPRECIATIONTYPE', 2, 0, 1537, 0, 8),
(1538, 'TXTDELDEPRECIATIONTYPE', 2, 0, 1538, 0, 8),
(1539, 'TXTISDATACOMPLETED', 2, 0, 1539, 0, 14),
(1540, 'TXTCONTRACT', 2, 0, 1540, 0, 0),
(1541, 'TXTCONTRACTNUMBER', 2, 0, 1541, 0, 0),
(1542, 'TXTPHONENUM', 2, 0, 1542, 0, 0),
(1543, 'TXTDELLOCATION', 2, 0, 1543, 0, 8),
(1544, 'TXTADDCONTRACT', 2, 0, 1544, 0, 14),
(1545, 'TXTLICENSECOUNT', 2, 0, 1545, 0, 0),
(1546, 'MSGDATAWIPINGCOMPLETEFIRST', 2, 0, 1546, 0, 14),
(1547, 'TXTNOTIFYEXPIRY', 2, 0, 1547, 0, 14),
(1548, 'TXTNOTIFYBEFORE', 2, 0, 1548, 0, 14),
(1549, 'TXTNOTIFYTO', 2, 0, 1549, 0, 14),
(1550, 'TXTCHOOSEFILE', 2, 0, 1550, 0, 0),
(1551, 'TXTTWOFACTORAUTHENTICATION', 2, 0, 1551, 0, 8),
(1552, 'TXTSUCCVERIFY', 1, 0, 1552, 0, 2),
(1553, 'TXTERRVERIFY', 1, 0, 1553, 0, 2),
(1554, 'TXTVERIFICATIONPENDING', 1, 0, 1554, 0, 0),
(1555, 'TXTUPDATECI', 2, 0, 1555, 0, 0),
(1556, 'TXTGENERALLEDGER', 1, 0, 1556, 0, 0),
(1557, 'TXTADDITIONALATTR', 2, 0, 1557, 0, 14),
(1558, 'TXTSELECTGROUPTYPE', 2, 0, 1558, 0, 8),
(1559, 'TXTCHECKIN', 2, 0, 1559, 0, 14),
(1560, 'MSGREQNOTIEXP', 2, 0, 1560, 0, 8),
(1561, 'TXTCHECKEDOUT', 2, 0, 1561, 0, 14),
(1562, 'MSGREQCNTRTTYP', 2, 0, 1562, 0, 14),
(1563, 'MSGINVCNTRTNUM', 2, 0, 1563, 0, 14),
(1564, 'TXTDELCONTRACT', 2, 0, 1564, 0, 14),
(1565, 'TXTAUTOAPPROVECOMMENT', 2, 0, 1565, 0, 0),
(1566, 'TXTSCANNOW', 2, 0, 1566, 0, 0),
(1567, 'TXTATTACHCI', 2, 0, 1567, 0, 0),
(1568, 'TXTSCANING', 2, 0, 1568, 0, 14),
(1569, 'TXTPLEASESELECTTODATE', 2, 0, 1569, 0, 0),
(1570, 'TXTITILSERVICECATELOG', 1, 0, 1570, 0, 0),
(1571, 'TXTEDITCIPRODUCT', 2, 0, 1571, 0, 14),
(1572, 'TXTCIVENDOR', 2, 0, 1572, 0, 8),
(1573, 'TXTWARRANTYNVALIDITY', 2, 0, 1573, 0, 0),
(1574, 'TXTSELECTVENDOR', 2, 0, 1574, 0, 0),
(1575, 'TXTSELECTPRODUCT', 2, 0, 1575, 0, 0),
(1576, 'TXTATTACH', 1, 0, 1576, 0, 0),
(1577, 'TXTITEMNAME', 2, 0, 1577, 0, 0),
(1578, 'MSGPRICENUM', 2, 0, 1578, 0, 0),
(1579, 'MSGQUANTITYNUM', 2, 0, 1579, 0, 8),
(1580, 'TXTADDSERVICECATEGORY', 2, 0, 1580, 0, 0),
(1581, 'TXTPROBLEMS', 2, 1, 1581, 0, 0),
(1582, 'TXTUPDATESERVICECATEGORY', 2, 0, 1582, 0, 8),
(1583, 'TXTPURCHASEANDINVOICEDETAILS', 2, 0, 1583, 0, 14),
(1584, 'TXTSEARCHREQUESTER', 2, 1, 1584, 0, 0),
(1585, 'TXTDUEBY', 2, 0, 1585, 0, 0),
(1586, 'TXTAGENT', 2, 0, 1586, 0, 14),
(1587, 'TXTADDSERVICEITEM', 2, 0, 1587, 0, 8),
(1588, 'TXTQUANTITYVISIBLE', 2, 0, 1588, 0, 8),
(1589, 'TXTPUBLISHED', 2, 0, 1589, 0, 0),
(1590, 'TXTVISIBLETOCLIENTPORTAL', 2, 0, 1590, 0, 0),
(1591, 'TXTPROBLEM', 2, 1, 1591, 0, 0),
(1592, 'TXTOPENNEWPROBLEM', 2, 1, 1592, 0, 10),
(1593, 'TXTUPDATESERVICEITEM', 2, 0, 1593, 0, 8),
(1594, 'MSGCOSTNUM', 2, 0, 1594, 0, 0),
(1595, 'TXTDELSERVICEITEM', 2, 0, 1595, 0, 8),
(1596, 'TXTDELETEPAYGATEWAY', 2, 0, 1596, 0, 8),
(1597, 'TXTDELSERVICECATEGORY', 2, 0, 1597, 0, 8),
(1598, 'TXTFIELDNAME', 2, 0, 1598, 0, 7),
(1599, 'TXTPOHASH', 2, 0, 1599, 0, 14),
(1600, 'TXTPONAME', 2, 0, 1600, 0, 14),
(1601, 'TXTASSIGNMENT', 2, 1, 1601, 0, 0),
(1602, 'TXTDELSERVICECUSTOMFIELD', 2, 0, 1602, 0, 8),
(1603, 'TXTSERVICECUSTOMFIELD', 2, 0, 1603, 0, 8),
(1604, 'TXTITEMIMAGE', 2, 0, 1604, 0, 0),
(1605, 'TXTCHANGES', 1, 1, 1605, 0, 0),
(1606, 'TXTITILSERVICECATALOG', 1, 0, 1606, 0, 0),
(1607, 'TXTITILREQUEST', 1, 0, 1607, 0, 0),
(1608, 'TXTSUBMITAPROVAL', 2, 0, 1608, 0, 0),
(1609, 'MSGLINKEDINIDMISS', 2, 0, 1609, 0, 1),
(1610, 'MSGFACEBOOKID', 2, 0, 1610, 0, 1),
(1611, 'MSGTWITTERID', 2, 0, 1611, 0, 1),
(1612, 'MSGGOOGLEIDMISS', 2, 0, 1612, 0, 1),
(1613, 'TXTITILITEMREQUEST', 1, 0, 1613, 0, 0),
(1614, 'TXTITILPLACEREQUEST', 1, 0, 1614, 0, 2),
(1615, 'TXTITILREJECT', 1, 0, 1615, 0, 0),
(1616, 'TXTITILREQUESTFOR', 1, 1, 1616, 0, 10),
(1617, 'TXTITILTERMINATE', 2, 0, 1617, 0, 14),
(1618, 'TXTITILCANCELED', 2, 0, 1618, 0, 14),
(1619, 'TXTITILREQUESTSERVICE', 1, 0, 1619, 0, 0),
(1620, 'TXTSENDEMAILTOCLIENT', 2, 0, 1620, 0, 0),
(1621, 'TXTASSIGNTEAM', 2, 0, 1621, 0, 0),
(1622, 'TXTCREATIONTIME', 2, 0, 1622, 0, 0),
(1623, 'TXTAFTER', 2, 0, 1623, 0, 0),
(1624, 'TXTBEFORE', 2, 0, 1624, 0, 0),
(1625, 'TXTSENDEMAILTOSTAFF', 2, 0, 1625, 0, 0),
(1626, 'TXTRESOLUTIONDUETIME', 2, 0, 1626, 0, 0),
(1627, 'MSGCORETYPESTATUS', 2, 0, 1627, 0, 8),
(1628, 'MSGAPPROVEPENDING', 1, 0, 1628, 0, 0),
(1629, 'MSGSIZEERROR', 1, 0, 1629, 0, 0),
(1630, 'ERRORMSGEXTENSION', 1, 0, 1630, 0, 0),
(1631, 'TXTVIEWREPLYSELFTICKET', 1, 0, 1631, 0, 0),
(1632, 'MSGPRBNTACC', 2, 1, 1632, 0, 10),
(1633, 'TXTPURCHASEDATE', 2, 0, 1633, 0, 14),
(1634, 'TXTROOTCAUSE', 2, 1, 1634, 0, 10),
(1635, 'TXTSYMPTONS', 2, 1, 1635, 0, 0),
(1636, 'TXTPERMANANTSOLUTION', 2, 1, 1636, 0, 0),
(1637, 'TXTWORKAROUNDSOLUTION', 2, 1, 1637, 0, 0),
(1638, 'TXTPROBLEMANLSIS', 2, 1, 1638, 0, 10),
(1639, 'TXTADDROOTCAUSE', 2, 1, 1639, 0, 0),
(1640, 'TXTPROBLEMDETAILS', 2, 1, 1640, 0, 10),
(1641, 'TXTPROBLEMTNOTE', 2, 1, 1641, 0, 10),
(1642, 'TXTNOROOTCAUSE', 2, 1, 1642, 0, 10),
(1643, 'TXTADDNEW', 2, 0, 1643, 0, 0),
(1644, 'TXTNOIMPACT', 2, 1, 1644, 0, 10),
(1645, 'TXTNOSYMPTONS', 2, 1, 1645, 0, 10),
(1646, 'TXTADDNEWSOLUTION', 2, 1, 1646, 0, 10),
(1647, 'TXTLINKSOLUTION', 2, 1, 1647, 0, 10),
(1648, 'TXTRELEASES', 2, 1, 1648, 0, 0),
(1649, 'MSGSELECTMULTIPLEPROBLMESTOLINK', 2, 1, 1649, 0, 10),
(1650, 'TXTSEARCHPROBLEM', 2, 1, 1650, 0, 0),
(1651, 'TXTSEARCHRELEASE', 2, 1, 1651, 0, 0),
(1652, 'TXTSERVICEITEM', 1, 0, 1652, 0, 0),
(1653, 'TXTINVOICENUMBER', 1, 0, 1653, 0, 14),
(1654, 'TXTITILNOCIASSOCIATED', 2, 0, 1654, 0, 0),
(1655, 'TXTITILNOPROBLEMLINKED', 2, 1, 1655, 0, 2),
(1656, 'TXTLINKPROBLEM', 2, 1, 1656, 0, 0),
(1657, 'TXTITILLINKCHANGES', 2, 1, 1657, 0, 0),
(1658, 'TXTITILSEARCHPROBLEM', 2, 1, 1658, 0, 10),
(1659, 'TXTITILSEARCHCHANGES', 2, 1, 1659, 0, 10),
(1660, 'TXTITILSELECTCITYPE', 2, 0, 1660, 0, 0),
(1661, 'TXTITILSELECTCITYPEORITEM', 2, 0, 1661, 0, 0),
(1662, 'TXTRECIPIENTNPEOPLE', 2, 0, 1662, 0, 2),
(1663, 'TXTTICKETORTIMEBASE', 2, 0, 1663, 0, 8),
(1664, 'TXTSHOWONLYINTERNALTICKETS', 2, 0, 1664, 0, 2),
(1665, 'TXTITILREATIONSHIPS', 2, 0, 1665, 0, 0),
(1666, 'TXTASSETSDETAIL', 2, 0, 1666, 0, 14),
(1667, 'TXTITILINCIDENCE', 2, 0, 1667, 0, 0),
(1668, 'TXTITILADDCIVENDOR', 2, 0, 1668, 0, 8),
(1669, 'TXTITILADDCIPRODUCT', 2, 0, 1669, 0, 8),
(1670, 'TXTITILINVERSERELATIONSHIP', 2, 0, 1670, 0, 14),
(1671, 'TXTITILATTACHRELATIONSHIP', 2, 0, 1671, 0, 14),
(1672, 'TXTOPENNEWRELEASE', 2, 1, 1672, 0, 10),
(1673, 'TXTRELEASE', 2, 1, 1673, 0, 0),
(1674, 'TXTPLANNEDSTARTDATE', 2, 1, 1674, 0, 0),
(1675, 'TXTPLANNEDENDDATE', 2, 1, 1675, 0, 0),
(1676, 'TXTMATCHANDCONDITIONS', 2, 0, 1676, 0, 0),
(1677, 'TXTMATCHORCONDITIONS', 2, 0, 1677, 0, 0),
(1678, 'TXTPAIDDEPARTMENTNOTFOUND', 2, 0, 1678, 0, 0),
(1679, 'TXTPROBLEMSOLUTION', 2, 1, 1679, 0, 10),
(1680, 'TXTPERMANANT', 2, 1, 1680, 0, 10),
(1681, 'TXTWORKAROUND', 2, 1, 1681, 0, 10),
(1682, 'TXTSERACHPROBLEMSOLUTION', 2, 1, 1682, 0, 10),
(1683, 'TXTDETACHCI', 2, 0, 1683, 0, 0),
(1684, 'TXTSEARCHTICKET', 1, 0, 1684, 0, 0),
(1685, 'MSGSEARCHTICKET', 2, 0, 1685, 0, 10),
(1686, 'TXTNOCHANGESATTACHED', 2, 0, 1686, 0, 0),
(1687, 'TXTNOTASKATTACHED', 2, 0, 1687, 0, 0),
(1688, 'TXTLINKTASK', 2, 0, 1688, 0, 0),
(1689, 'TXTADDNEWTASK', 2, 0, 1689, 0, 1),
(1690, 'TXTOPENNEWCHANGE', 2, 1, 1690, 0, 10),
(1691, 'TXTPROBLEMHASH', 2, 1, 1691, 0, 0),
(1692, 'TXTRELEASEHASH', 2, 1, 1692, 0, 0),
(1693, 'TXTDELETECHANGE', 2, 1, 1693, 0, 10),
(1694, 'TXTDELETEPROBLEM', 1, 1, 1694, 0, 10),
(1695, 'TXTHOST', 2, 0, 1695, 0, 8),
(1696, 'TXTAPPLYAMOUNTCREDIT', 2, 0, 1696, 0, 5),
(1697, 'TXTRECENTACTIVITY', 2, 0, 1697, 0, 0),
(1698, 'TXTMANAGECREDIT', 2, 0, 1698, 0, 3),
(1699, 'TXTREQUERMENTS', 1, 0, 1699, 0, 2),
(1700, 'TXTRELEASEDETAILS', 2, 1, 1700, 0, 10),
(1701, 'TXTBUILDPLAN', 2, 1, 1701, 0, 0),
(1702, 'TXTTESTPLAN', 2, 1, 1702, 0, 0),
(1703, 'TXTNOBUILDPLAN', 2, 1, 1703, 0, 10),
(1704, 'TXTNOTESTPLAN', 2, 1, 1704, 0, 10),
(1705, 'TXTRELEASEAPPROVAL', 2, 1, 1705, 0, 8),
(1706, 'TXTCHANGEFILTERS', 2, 1, 1706, 0, 10),
(1707, 'TXTRELEASEFILTERS', 2, 1, 1707, 0, 10),
(1708, 'TXTPROBLEMFILTERS', 2, 1, 1708, 0, 10),
(1709, 'MSGCANNOTMERGEOTHERCLIENTEMAIL', 2, 0, 1709, 0, 3),
(1710, 'TXTDELETEORGANIZATION', 2, 0, 1710, 0, 3),
(1711, 'TXTSURVEYFIELDGROUPREQUIRED', 2, 0, 1711, 0, 8),
(1712, 'TXTPROGRESS', 2, 0, 1712, 0, 0),
(1713, 'MSGEMAILSENTTORESETPASSWORD', 1, 0, 1713, 0, 0),
(1714, 'MSGRESETPASSWORDLINKEXPIRED', 1, 0, 1714, 0, 0),
(1715, 'TXTBACKTOLOGIN', 1, 0, 1715, 0, 0),
(1716, 'MSGCOREPRIORITYSTATUS', 2, 0, 1716, 0, 0),
(1717, 'MSGCORESTATUS', 2, 0, 1717, 0, 0),
(1718, 'MSGCOREFLAGSTATUS', 2, 0, 1718, 0, 0),
(1719, 'MSGCOREVIEWSTATUS', 2, 0, 1719, 0, 0),
(1720, 'TXTTOTALCOST', 1, 0, 1720, 0, 0),
(1721, 'MSGCHANGESNOTACC', 2, 1, 1721, 0, 10),
(1722, 'TXTADDPROBLEM', 2, 1, 1722, 0, 10),
(1723, 'MSGPROBLEMMOVETODEPT', 2, 1, 1723, 0, 10),
(1724, 'MSGCHANGESMOVETODEPT', 2, 1, 1724, 0, 10),
(1725, 'MSGNEWPROBLEM', 2, 1, 1725, 0, 0),
(1726, 'MSGNEWCHANGE', 2, 1, 1726, 0, 0),
(1727, 'TXTDETACH', 2, 0, 1727, 0, 0),
(1728, 'TXTCHANGESDETAILS', 2, 1, 1728, 0, 10),
(1729, 'TXTLINKRELEASE', 2, 1, 1729, 0, 0),
(1730, 'TXTSEARCHRELEASES', 2, 1, 1730, 0, 10),
(1731, 'TXTCHANGEREASON', 2, 1, 1731, 0, 0),
(1732, 'TXTNOREASON', 2, 1, 1732, 0, 10),
(1733, 'TXTROLLOUTPLAN', 2, 1, 1733, 0, 0),
(1734, 'TXTBACKOUTPLAN', 2, 1, 1734, 0, 0),
(1735, 'TXTSEND', 1, 0, 1735, 0, 0),
(1736, 'TXTSELECTPAYMENTGATEWAY', 2, 0, 1736, 0, 0),
(1737, 'MSGGATEWAYTRANSACTIONDETAILS', 2, 0, 1737, 0, 8),
(1738, 'MSGPARSERDETAILS', 2, 0, 1738, 0, 8),
(1739, 'MSGMAILDETAILS', 2, 0, 1739, 0, 8),
(1740, 'MSGSELECTDATE', 2, 0, 1740, 0, 0),
(1741, 'MSGSELECTMONTH', 2, 0, 1741, 0, 0),
(1742, 'TXTJANUARY', 2, 0, 1742, 0, 8),
(1743, 'TXTFEBRUARY', 2, 0, 1743, 0, 8),
(1744, 'TXTMARCH', 2, 0, 1744, 0, 8),
(1745, 'TXTAPRIL', 2, 0, 1745, 0, 8),
(1746, 'TXTMAY', 2, 0, 1746, 0, 8),
(1747, 'TXTJUNE', 2, 0, 1747, 0, 8),
(1748, 'TXTJULY', 2, 0, 1748, 0, 8),
(1749, 'TXTAUGUST', 2, 0, 1749, 0, 8),
(1750, 'TXTSEPTEMBER', 2, 0, 1750, 0, 8),
(1751, 'TXTOCTOBER', 2, 0, 1751, 0, 8),
(1752, 'TXTNOVEMBER', 2, 0, 1752, 0, 8),
(1753, 'TXTDECEMBER', 2, 0, 1753, 0, 8),
(1754, 'TXTUPDATEPASSWORD', 1, 0, 1754, 0, 0),
(1755, 'TXTSENDRESETPASSWORDEMAIL', 1, 0, 1755, 0, 0),
(1756, 'TXTITILDELRELATIONSHIP', 2, 1, 1756, 0, 0),
(1757, 'TXTPOINVOICEDESCRIPTION', 2, 0, 1757, 0, 14),
(1758, 'TXTITILDETACHLINKPROBLEM', 2, 1, 1758, 0, 0),
(1759, 'TXTITILDETACHLINKCHANGES', 2, 1, 1759, 0, 0),
(1760, 'TXTITILSOFTWAREPROPERTY', 2, 0, 1760, 0, 14),
(1761, 'TXTITILWARRANTY', 2, 0, 1761, 0, 0),
(1762, 'TXTITILHARDWAREPROPERTY', 2, 0, 1762, 0, 14),
(1763, 'TXTITILACQUISITIONDATE', 1, 0, 1763, 0, 0),
(1764, 'TXTITILWARRANTYEXPDATE', 1, 0, 1764, 0, 0),
(1765, 'TXTITILSERIALNUMBER', 2, 0, 1765, 0, 0),
(1766, 'TXTITILLICENSEVALIDITY', 2, 0, 1766, 0, 0),
(1767, 'TXTAUTORENEW', 2, 0, 1767, 0, 14),
(1768, 'TXTSWLICENCETYPE', 2, 0, 1768, 0, 0),
(1769, 'TXTLICENSETYPE', 2, 0, 1769, 0, 0),
(1770, 'TXTITILSTRAIGHTLINE', 2, 0, 1770, 0, 0),
(1771, 'TXTITILDECLINEBALANCE', 2, 0, 1771, 0, 0),
(1772, 'TXTITILSUMOFYEARDIGIT', 2, 0, 1772, 0, 0),
(1773, 'TXTITILDOUBLEDECLINEBALANCE', 2, 0, 1773, 0, 0),
(1774, 'TXTITILDEPRECIATIONDETAILS', 2, 0, 1774, 0, 0),
(1775, 'MSGREQFILUSEFULYEARNUM', 2, 0, 1775, 0, 0),
(1776, 'TXTITILBOOKVALUE', 1, 0, 1776, 0, 14),
(1777, 'TXTITILDEPRECIATIONSCHEDULE', 2, 0, 1777, 0, 14),
(1778, 'TXTITILDEPRECIATION', 2, 0, 1778, 0, 0),
(1779, 'TXTSELECTDEPRECIATIONMETHOD', 2, 0, 1779, 0, 0),
(1780, 'TXTDELETED', 2, 0, 1780, 0, 0),
(1781, 'TXTUPDATESTAFFDEPARTMENT', 2, 0, 1781, 0, 8),
(1782, 'TXTADDREMARK', 1, 0, 1782, 0, 0),
(1783, 'TXTITILEVENT', 2, 1, 1783, 0, 0),
(1784, 'TXTNEWPROBLEM', 2, 1, 1784, 0, 0),
(1785, 'TXTUPDATEPROBLEMDEPT', 2, 1, 1785, 0, 0),
(1786, 'TXTUPDATEPROBLEMSTATUS', 2, 1, 1786, 0, 0),
(1787, 'TXTUPDATEPROBLEMPRIORITY', 2, 1, 1787, 0, 0),
(1788, 'TXTUPDATEPROBLEMIMPACT', 2, 1, 1788, 0, 0),
(1789, 'TXTPROBLEMASSIGN', 2, 1, 1789, 0, 0),
(1790, 'TXTADDPROBLEMIMPACT', 2, 1, 1790, 0, 0),
(1791, 'TXTADDPROBLEMSYMPTOMS', 2, 1, 1791, 0, 0),
(1792, 'TXTLINKPERMANENTSOLUTION', 2, 1, 1792, 0, 0),
(1793, 'TXTLINKWORKAROUNDSOLUTION', 2, 1, 1793, 0, 0),
(1794, 'TXTNEWCHANGE', 2, 1, 1794, 0, 0),
(1795, 'TXTOPENNEWSERVICEREQ', 1, 0, 1795, 0, 2),
(1796, 'TXTUPDATECHANGESTATUS', 2, 1, 1796, 0, 0),
(1797, 'TXTUPDATEPCHANGEPRIORITY', 2, 1, 1797, 0, 0),
(1798, 'TXTUPDATEPCHANGEIMPACT', 2, 1, 1798, 0, 0),
(1799, 'TXTUPDATEPCHANGERISK', 2, 1, 1799, 0, 0),
(1800, 'TXTCHANGEASSIGN', 2, 1, 1800, 0, 0),
(1801, 'TXTADDCHANGEIMPACT', 2, 1, 1801, 0, 0),
(1802, 'TXTADDROLLOUTPLAN', 2, 1, 1802, 0, 0),
(1803, 'TXTADDBACKOUTPLAN', 2, 1, 1803, 0, 0),
(1804, 'TXTIDENTIFICATION', 1, 0, 1804, 0, 0),
(1805, 'TXTUPDATERELEASESTATUS', 2, 1, 1805, 0, 0),
(1806, 'TXTUPDATEPRELEASEPRIORITY', 2, 1, 1806, 0, 0),
(1807, 'TXTRELEASEASSIGN', 2, 1, 1807, 0, 0),
(1808, 'TXTADDBUILDPLAN', 2, 1, 1808, 0, 0),
(1809, 'TXTADDTESTPLAN', 2, 1, 1809, 0, 0),
(1810, 'TXTCHANGEAPPROVAL', 2, 1, 1810, 0, 8),
(1811, 'TXTCONTRACTAPPROVAL', 2, 1, 1811, 0, 8),
(1812, 'TXTCALLCLIENT', 1, 0, 1812, 0, 0),
(1813, 'TXTEMAILCLIENT', 1, 0, 1813, 0, 0),
(1814, 'TXTCLIENTTYPE', 2, 0, 1814, 0, 0),
(1815, 'TXTITILREMAININGLIFE', 2, 1, 1815, 0, 14),
(1816, 'TXTITILACCUMULATEDDEPRECIATION', 2, 0, 1816, 0, 14),
(1817, 'TXTITILDEPRECIATIONEXPENSE', 2, 0, 1817, 0, 14),
(1818, 'MSGURLMUSTBEVALID', 2, 0, 1818, 0, 8),
(1819, 'TXTRESTORE', 2, 0, 1819, 0, 0),
(1820, 'TXTNOACCESS', 2, 0, 1820, 0, 0),
(1821, 'TXTMAPFIELD', 2, 0, 1821, 0, 14),
(1822, 'TXTSELECTIMAGE', 2, 0, 1822, 0, 0),
(1823, 'MSGINVALIDENDDATE', 2, 0, 1823, 0, 14),
(1824, 'TXTDELCONTRACTTYPE', 2, 0, 1824, 0, 8),
(1825, 'TXTMODIFYRECEPIENTANDPEOPLE', 2, 0, 1825, 0, 8),
(1826, 'TXTTIMETRACKING', 2, 0, 1826, 0, 0),
(1827, 'TXTADDCITYPE', 2, 0, 1827, 0, 8),
(1828, 'TXTUPDATECITYPE', 2, 0, 1828, 0, 8),
(1829, 'TXTUPDATELOCATION', 2, 0, 1829, 0, 8),
(1830, 'TXTPRODUCTCATALOG', 2, 0, 1830, 0, 0),
(1831, 'TXTADDPACKAGE', 2, 0, 1831, 0, 0),
(1832, 'TXTUPDATEPACKAGE', 2, 0, 1832, 0, 0),
(1833, 'TXTDELCIPRODSTATUS', 2, 0, 1833, 0, 8),
(1834, 'TXTDELSERVICECATEGORYDELSERVICEITEM', 2, 0, 1834, 0, 8),
(1835, 'TXTREPLYORREPLYALLTICKET', 2, 0, 1835, 0, 8),
(1836, 'TXTINSTALLDETAILS', 2, 0, 1836, 0, 0),
(1837, 'TXTEDITASSETS', 2, 0, 1837, 0, 14),
(1838, 'TXTAPPROVALSTATUS', 2, 0, 1838, 0, 0),
(1839, 'TXTREQUESTED', 2, 0, 1839, 0, 0),
(1840, 'TXTREJECTED', 2, 0, 1840, 0, 0),
(1841, 'TXTAPPROVALS', 2, 0, 1841, 0, 0),
(1842, 'TXTNOAPROVALS', 2, 0, 1842, 0, 0),
(1843, 'TXTREQUESTAPROVALS', 2, 0, 1843, 0, 0),
(1844, 'TXTSENTON', 2, 0, 1844, 0, 0),
(1845, 'TXTAPPROVEDON', 2, 0, 1845, 0, 0),
(1846, 'TXTCANCELEDON', 2, 0, 1846, 0, 0),
(1847, 'TXTREJECTEDON', 2, 0, 1847, 0, 0),
(1848, 'TXTSENDREMINDER', 2, 0, 1848, 0, 0),
(1849, 'TXTREMARKS', 2, 0, 1849, 0, 0),
(1850, 'TXTADDRELEASE', 2, 1, 1850, 0, 10),
(1851, 'TXTCHANGEHASH', 2, 1, 1851, 0, 0),
(1852, 'TXTALERTMESSAGE', 2, 0, 1852, 0, 0),
(1853, 'MSGCHANGESTATUSMESSAGE', 2, 0, 1853, 0, 0),
(1854, 'TXTHR', 2, 0, 1854, 0, 0),
(1855, 'TXTINSTALLSTATUS', 2, 0, 1855, 0, 2),
(1856, 'TXTLOADING', 1, 0, 1856, 0, 0),
(1857, 'TXTASSETCOMPONENT', 2, 0, 1857, 0, 14),
(1858, 'TXTLTOR', 2, 0, 1858, 0, 8),
(1859, 'TXTLAST', 2, 0, 1859, 0, 0),
(1860, 'TXTLIVE', 2, 0, 1860, 0, 8),
(1861, 'TXTITILSEARCHITEM', 2, 0, 1861, 0, 14),
(1862, 'TXTMERGEFROM', 2, 0, 1862, 0, 3),
(1863, 'TXTINPROGRESSTASK', 2, 0, 1863, 0, 1),
(1864, 'TXTCOMPLETEDTASK', 2, 0, 1864, 0, 1),
(1865, 'TXTCANCELLEDTASK', 2, 0, 1865, 0, 1),
(1866, 'TXTLOWPRIORITYTASK', 2, 0, 1866, 0, 1),
(1867, 'TXTMEDIUMPRIORITYTASK', 2, 0, 1867, 0, 1),
(1868, 'TXTHIGHPRIORITYTASK', 2, 0, 1868, 0, 1),
(1869, 'TXTMINSHORT', 2, 0, 1869, 0, 0),
(1870, 'TXTMOVEDETAILS', 2, 0, 1870, 0, 2),
(1871, 'TXTMOVESTATUS', 2, 0, 1871, 0, 2),
(1872, 'TXTQUANTITY', 1, 0, 1872, 0, 0),
(1873, 'TXTCOST', 1, 0, 1873, 0, 0),
(1874, 'TXTENTERTASKTITLE', 2, 0, 1874, 0, 1),
(1875, 'TXTADDTASKDESCRIPTION', 2, 0, 1875, 0, 1),
(1876, 'TXTSTAFFACCESS', 2, 0, 1876, 0, 0),
(1877, 'TXTSEARCHTASK', 2, 0, 1877, 0, 0),
(1878, 'TXTSEARCHCHANGES', 2, 1, 1878, 0, 10),
(1879, 'MSGMOBILENONUM', 2, 0, 1879, 0, 0),
(1880, 'MESSAGEFORSMTPADDOPERATION', 2, 0, 1880, 0, 8),
(1881, 'TXTNEWCLIENTREPLY', 1, 0, 1881, 0, 0),
(1882, 'MSGCLIENTREMOVED', 1, 0, 1882, 0, 0),
(1883, 'TXTCLIENTADD', 1, 0, 1883, 0, 0),
(1884, 'TXTDELFACEBOOKPAGE', 2, 0, 1884, 0, 8),
(1885, 'TXTHASHGENERATION', 2, 1, 1885, 0, 8),
(1886, 'TXTSERVICESPREFIX', 1, 0, 1886, 0, 8),
(1887, 'TXTPROBLEMSPREFIX', 2, 1, 1887, 0, 8),
(1888, 'TXTCHANGESPREFIX', 2, 1, 1888, 0, 8),
(1889, 'TXTRELEASESPREFIX', 2, 1, 1889, 0, 8),
(1890, 'TXTCONTRACTSPREFIX', 2, 0, 1890, 0, 8),
(1891, 'TXTMULTIPARTIANDUPIN', 2, 0, 1891, 0, 0),
(1892, 'TXTTKTMOVEINBOCFROMTRASH', 2, 0, 1892, 0, 0),
(1893, 'TXTTIMESHOULDNOTNEGATIVE', 2, 0, 1893, 0, 2),
(1894, 'TXTEDITPAGE', 2, 0, 1894, 0, 8),
(1895, 'MSGDELFBPAGES', 2, 0, 1895, 0, 8),
(1896, 'TXTGOTOMEETINGDETAILS', 2, 0, 1896, 0, 0),
(1897, 'MSGTICKHASHLINKERROR', 2, 0, 1897, 0, 0),
(1898, 'TXTNEWCLIENT', 2, 0, 1898, 0, 0),
(1899, 'TXTNEWARTICLE', 2, 0, 1899, 0, 0),
(1900, 'TXTNEWCOMMENT', 2, 0, 1900, 0, 0),
(1901, 'TXTNEWBLAB', 2, 0, 1901, 0, 6),
(1902, 'TXTTASKASSIGNED', 2, 0, 1902, 0, 0),
(1903, 'TXTTASKCOMMENT', 2, 0, 1903, 0, 0),
(1904, 'TXTNEWORDER', 2, 0, 1904, 0, 0),
(1905, 'TXTINVOICECREATED', 2, 0, 1905, 0, 0),
(1906, 'TXTINVOICEDESCRIPTION', 2, 0, 1906, 0, 0),
(1907, 'TXTDELPRODUCTVENDOR', 2, 0, 1907, 0, 8),
(1908, 'MSGMAILDETAILSLOG', 2, 0, 1908, 0, 8),
(1909, 'TXTSTAFFNAMEPROFILEIMAGE', 2, 0, 1909, 0, 0),
(1910, 'MSGSERVICESHASHPREFIXERROR', 2, 0, 1910, 0, 8),
(1911, 'MSGPROBLEMSHASHPREFIX', 2, 1, 1911, 0, 8),
(1912, 'MSGPROBLEMSHASHPREFIXERROR', 2, 1, 1912, 0, 8),
(1913, 'MSGCHANGESHASHPREFIX', 2, 1, 1913, 0, 8),
(1914, 'MSGCHANGESHASHPREFIXERROR', 2, 1, 1914, 0, 8),
(1915, 'MSGCONTRACTSHASHPREFIX', 2, 0, 1915, 0, 14),
(1916, 'MSGCONTRACTSHASHPREFIXERROR', 2, 0, 1916, 0, 14),
(1917, 'MSGITILNUMERINGSTARTSFROMERROR', 2, 0, 1917, 0, 8),
(1918, 'TXTVALUESNOTBENEGATIVE', 2, 0, 1918, 0, 0),
(1919, 'TXTNEWRELEASE', 2, 1, 1919, 0, 0),
(1920, 'MSGCHANGESLINKED', 2, 1, 1920, 0, 0),
(1921, 'MSGTICKETSPLIT', 2, 0, 1921, 0, 0),
(1922, 'MSGTICKETLINKED', 2, 0, 1922, 0, 0),
(1923, 'TXTSEARCHSERVICEITEM', 1, 0, 1923, 0, 0),
(1924, 'TXTSERVICECATEGORY', 1, 0, 1924, 0, 0),
(1925, 'MSGDURATIONLESSTHANTHREEMONTHS', 2, 0, 1925, 0, 0),
(1926, 'MSGFROMLESSTHANTO', 2, 0, 1926, 0, 0),
(1927, 'TXTSERVICESEARCHRESULT', 1, 0, 1927, 0, 0),
(1928, 'TXTMARKPAID', 2, 0, 1928, 0, 5),
(1929, 'TXTNOMATCHFOUND', 1, 0, 1929, 0, 0),
(1930, 'TXTDELETERELEASE', 2, 1, 1930, 0, 10),
(1931, 'TXTTICKETRATING', 2, 0, 1931, 0, 0),
(1932, 'TXTSELSERVICECATEGORY', 2, 0, 1932, 0, 0),
(1933, 'MSGTICKETPOSTDELETE', 2, 0, 1933, 0, 0),
(1934, 'TXTITILSERVICEREQUESTFOR', 1, 0, 1934, 0, 0),
(1935, 'TXTTICKETPOSTNOTAVAILABLE', 2, 0, 1935, 0, 0),
(1936, 'TXTFINANCEDETAILS', 2, 0, 1936, 0, 14),
(1937, 'MSGREQCONTACTNUM', 2, 0, 1937, 0, 8),
(1938, 'TXTESTIMATEDDELIVERY', 1, 0, 1938, 0, 0),
(1939, 'MSGRELEASEMOVETODEPT', 2, 1, 1939, 0, 10),
(1940, 'TXTSALESFORCE', 2, 0, 1940, 0, 0),
(1941, 'TXTBADGEEARN', 2, 0, 1941, 0, 7),
(1942, 'MSGNOBADGE', 2, 0, 1942, 0, 7),
(1943, 'TXTNEWTWILIO', 2, 0, 1943, 0, 8),
(1944, 'TXTKEY', 2, 0, 1944, 0, 0),
(1945, 'TXTTWILIONUMBER', 2, 0, 1945, 0, 8),
(1946, 'TXTBARCODEGENERATION', 2, 0, 1946, 0, 14),
(1947, 'TXTWELCOMEMSG', 2, 0, 1947, 0, 0),
(1948, 'TXTINVALIDPHONE', 1, 0, 1948, 0, 0),
(1949, 'TXTALLOWOUTBOUND', 2, 0, 1949, 0, 8),
(1950, 'TXTCALLFORWARDING', 2, 0, 1950, 0, 8),
(1951, 'TXTTOPHONE', 2, 0, 1951, 0, 8),
(1952, 'TXTTOSTAFFBROWSER', 2, 0, 1952, 0, 8),
(1953, 'TXTFORWARDINGNUM', 2, 0, 1953, 0, 8),
(1954, 'TXTUPDATETWILIO', 2, 0, 1954, 0, 8),
(1955, 'MSGINVALIDTWILIO', 2, 0, 1955, 0, 8),
(1956, 'TXTALL', 1, 0, 1956, 0, 0),
(1957, 'TXTKEYMSG', 2, 0, 1957, 0, 8),
(1958, 'TXTKEYMSGPLACEHOLDER', 2, 0, 1958, 0, 8),
(1959, 'MSGFORWARNUMBER', 2, 0, 1959, 0, 8),
(1960, 'MSGTAGALREDEYUSED', 2, 0, 1960, 0, 2),
(1961, 'TXTCLIENTID', 2, 0, 1961, 0, 8),
(1962, 'TXTCLIENTSECRETE', 2, 0, 1962, 0, 8),
(1963, 'TXTCHECKEDINBY', 2, 0, 1963, 0, 0),
(1964, 'TXTCAMPAIGNNAME', 2, 0, 1964, 0, 8),
(1965, 'TXTDONOTHAVEANACCOUNT', 1, 0, 1965, 0, 0),
(1966, 'TXTCONSUMERSECRETE', 2, 0, 1966, 0, 8),
(1967, 'TXTCLOSETICKET', 1, 0, 1967, 0, 0),
(1968, 'TXTLICENSEOWNER', 2, 0, 1968, 0, 8),
(1969, 'TXTNUMBEROFCOMPANIES', 2, 0, 1969, 0, 8),
(1970, 'TXTNUMBEROFSTAFFAGENTS', 2, 0, 1970, 0, 8),
(1971, 'TXTCOPYRIGHT', 2, 0, 1971, 0, 8),
(1972, 'TXTPOSTYOURCOMMENTHERE', 2, 0, 1972, 0, 1),
(1973, 'TXTSTATUSCHANGEDFROM', 2, 0, 1973, 0, 0),
(1974, 'TXTPRIORITYCHANGEDFROM', 2, 0, 1974, 0, 0),
(1975, 'TXTDEPARTMENTCHANGEDFROM', 2, 0, 1975, 0, 0),
(1976, 'TXTTICKETTYPECHANGEDFROM', 2, 0, 1976, 0, 0),
(1977, 'TXTFLAGCHANGEDFROM', 2, 0, 1977, 0, 0),
(1978, 'TXTTICKETUNASSIGNEDFROM', 2, 0, 1978, 0, 0),
(1979, 'TXTTICKETASSIGNEDTONOBODY', 2, 0, 1979, 0, 0),
(1980, 'TXTSLASETTO', 2, 0, 1980, 0, 0),
(1981, 'TXTAPPLIEDCUSTOMSLAPLAN', 2, 0, 1981, 0, 0),
(1982, 'TXTNOTSPAMMARKED', 2, 0, 1982, 0, 0),
(1983, 'TXTNEWTASKATTACHED', 2, 0, 1983, 0, 0),
(1984, 'TXTDETACHEDATTACHEDTASK', 2, 0, 1984, 0, 0),
(1985, 'TXTNEWCIATTACHED', 2, 0, 1985, 0, 0),
(1986, 'TXTDETACHEDATTACHEDCI', 2, 0, 1986, 0, 0),
(1987, 'TXTNEWPROBLEMATTACHED', 2, 1, 1987, 0, 0),
(1988, 'TXTDETACHEDATTACHEDPROBLEM', 2, 1, 1988, 0, 0),
(1989, 'TXTNEWCHANGEATTACHED', 2, 1, 1989, 0, 0),
(1990, 'TXTDETACHEDATTACHEDCHANGE', 2, 1, 1990, 0, 0),
(1991, 'TXTTICKETPOSTSPLITWITH', 2, 0, 1991, 0, 0),
(1992, 'TXTSLACHANGEDFROM', 2, 0, 1992, 0, 0),
(1993, 'TXTLINKEDTO', 2, 0, 1993, 0, 0),
(1994, 'TXTITILACCEPT', 2, 0, 1994, 0, 0),
(1995, 'TXTINCOMINGCALLON', 2, 0, 1995, 0, 0),
(1996, 'MSGCONNECTING', 2, 0, 1996, 0, 0),
(1997, 'MSGCALLCONNECTED', 2, 0, 1997, 0, 0),
(1998, 'MSGCALLENDED', 2, 0, 1998, 0, 0),
(1999, 'TXTSEARCHCLIENT', 2, 0, 1999, 0, 0),
(2000, 'TXTPHONEEG', 2, 0, 2000, 0, 0),
(2001, 'TXTCUSTOMREPORT', 2, 0, 2001, 0, 7),
(2002, 'TXTTICKETUNASSIGNED', 2, 0, 2002, 0, 1),
(2003, 'TXTCHECKEDOUTBY', 2, 0, 2003, 0, 14),
(2004, 'TXTWIDGET', 2, 0, 2004, 0, 0),
(2005, 'TXTBUTTONNAME', 1, 0, 2005, 0, 8),
(2006, 'TXTCLONE', 2, 0, 2006, 0, 0),
(2007, 'TXTORDERDATE', 2, 0, 2007, 0, 8),
(2008, 'TXTMORECONVERSATION', 2, 0, 2008, 0, 8),
(2009, 'TXTFETCHCHAT', 2, 0, 2009, 0, 8),
(2010, 'MSGENTERVISITOREMAILADDRESS', 2, 0, 2010, 0, 8),
(2011, 'TXTNOTMAINTAIN', 2, 0, 2011, 0, 0),
(2012, 'TXTRESOLUTIONTSLA', 2, 0, 2012, 0, 7),
(2013, 'TXTRESPONSESLA', 2, 0, 2013, 0, 7),
(2014, 'TXTTOTALAVGRESPONSESLAMAINTAIN', 2, 0, 2014, 0, 7),
(2015, 'TXTTOTALAVGRESOLUTIONSLAMAINTAIN', 2, 0, 2015, 0, 7),
(2016, 'TXTFRESHBOOKSDOMAIN', 2, 0, 2016, 0, 8),
(2017, 'TXTPROJECTS', 2, 0, 2017, 0, 0),
(2018, 'TXTAMOUNTOUTSTANDING', 2, 0, 2018, 0, 0),
(2019, 'TXTDISCOUNT', 2, 0, 2019, 0, 0),
(2020, 'TXTSEARCHBY', 2, 0, 2020, 0, 0),
(2021, 'TXTSATELLITEHELPDESK', 2, 0, 2021, 0, 8),
(2022, 'TXTINSIGHTLY', 2, 0, 2022, 0, 8),
(2023, 'TXTADDINSIGHTLY', 2, 0, 2023, 0, 8),
(2024, 'TXTUPDATEINSIGHTLY', 2, 0, 2024, 0, 8),
(2025, 'TXTINSIGHTLYAPIURL', 2, 0, 2025, 0, 8),
(2026, 'TXTORGANIZATIONEMAIL', 2, 0, 2026, 0, 0),
(2027, 'TXTROLE', 2, 0, 2027, 0, 0),
(2028, 'TXTWIDGETHELP', 1, 0, 2028, 0, 0),
(2029, 'TXTWIDGETSEARCHSOLUTIONS', 1, 0, 2029, 0, 4),
(2030, 'TXTWIDNORECORDFOUND', 1, 0, 2030, 0, 0),
(2031, 'TXTSELECTCODE', 2, 0, 2031, 0, 0),
(2032, 'TXTWIDGETCODE', 2, 0, 2032, 0, 8),
(2033, 'TXTWIDPREVIEW', 2, 0, 2033, 0, 8),
(2034, 'TXTWIDROUNDED', 2, 0, 2034, 0, 8),
(2035, 'TXTWIDSQUARE', 2, 0, 2035, 0, 8),
(2036, 'TXTWIDBUTTONTYPE', 2, 0, 2036, 0, 8),
(2037, 'TXTWIDRIGHTBOTTOM', 2, 0, 2037, 0, 0),
(2038, 'TXTWIDLEFTBOTTOM', 2, 0, 2038, 0, 0),
(2039, 'TXTWIDRIGHTTOP', 2, 0, 2039, 0, 0),
(2040, 'TXTWIDPOSITION', 2, 0, 2040, 0, 8),
(2041, 'TXTWIDFEATURE', 2, 0, 2041, 0, 8),
(2042, 'TXTWIDBOTH', 2, 0, 2042, 0, 8),
(2043, 'TXTWIDRQUESTSUBMITED', 1, 0, 2043, 0, 0),
(2044, 'TXTWIDFIELDMISSING', 1, 0, 2044, 0, 8),
(2045, 'TXTPROPERTY', 1, 0, 2045, 0, 0),
(2046, 'TXTSECRETKEY', 2, 0, 2046, 0, 8),
(2047, 'TXTPUBLISHABLEKEY', 2, 0, 2047, 0, 8),
(2048, 'TXTBASEVALUE', 2, 0, 2048, 0, 0),
(2049, 'MSGPUBLISHABLEKEYEMPTY', 2, 0, 2049, 0, 8),
(2050, 'MSGFACEBOOKERROR', 2, 0, 2050, 0, 8),
(2051, 'TXTTLINKSFORTICKET', 2, 0, 2051, 0, 2),
(2052, 'TXTMSGEMAILSENDTOVERIFICATIONLINK', 1, 0, 2052, 0, 0),
(2053, 'TXTRESENDVERIFICATIONLINK', 1, 0, 2053, 0, 0),
(2054, 'TXTERRORMSGCLIENTSTATUSISNOTVERIFY', 2, 0, 2054, 0, 3),
(2055, 'TXTERRORMSGCLIENTSTATUSISUNAPPROVE', 2, 0, 2055, 0, 3),
(2056, 'TXTERRORMSGCLIENTSTATUSISSPAM', 2, 0, 2056, 0, 3),
(2057, 'TXTERRORMSGCLIENTSTATUSISBAN', 1, 0, 2057, 0, 0),
(2058, 'TXTNOTVERIFIED', 2, 0, 2058, 0, 3),
(2059, 'TXTVERIFIED', 2, 0, 2059, 0, 3),
(2060, 'TXTCURRENTVALUE', 2, 0, 2060, 0, 0),
(2061, 'TXTCREATEISSUE', 2, 0, 2061, 0, 0),
(2062, 'TXTISSUETYPE', 2, 0, 2062, 0, 0),
(2063, 'TXTISSUEHASH', 2, 0, 2063, 0, 0),
(2064, 'TXTLINKISSUE', 2, 0, 2064, 0, 0),
(2065, 'TXTUNLINKISSUE', 2, 0, 2065, 0, 0),
(2066, 'TXTVIEWISSUEINJIRA', 2, 0, 2066, 0, 0),
(2067, 'TXTFORNEWASSET', 2, 0, 2067, 0, 14),
(2068, 'TXTDUE', 2, 0, 2068, 0, 0),
(2069, 'TXTPACKAGENAME', 2, 0, 2069, 0, 8),
(2070, 'TXTTERM', 2, 0, 2070, 0, 8),
(2071, 'TXTCREATESUBTASK', 2, 0, 2071, 0, 1),
(2072, 'TXTCHILDOF', 2, 0, 2072, 0, 0),
(2073, 'TXTSUBTASK', 2, 0, 2073, 0, 1),
(2074, 'TXTTARGATEDATE', 2, 0, 2074, 0, 0),
(2075, 'TXTFOREXISTINGASSET', 2, 0, 2075, 0, 14),
(2076, 'TXTBARCODEQRCODE', 1, 0, 2076, 0, 14),
(2077, 'TXTTRACKINGCLIENT', 2, 0, 2077, 0, 7),
(2078, 'TXTTRACKINGORG', 2, 0, 2078, 0, 7),
(2079, 'TXTRECURSIVETASK', 2, 0, 2079, 0, 1),
(2080, 'TXTMASSREPLY', 2, 0, 2080, 0, 2),
(2081, 'TXTREPLYALLLINKEDTICKET', 2, 1, 2081, 0, 10),
(2082, 'MSGCHANGESTATUSMESSAGEFORORANIZATION', 2, 0, 2082, 0, 1),
(2083, 'MSGMOVETOORG', 2, 0, 2083, 0, 1),
(2084, 'TXTMOVECLIENTORG', 2, 0, 2084, 0, 0),
(2085, 'MSGFEEDBACKERR', 1, 0, 2085, 0, 3),
(2086, 'TXTRATETICKET', 1, 0, 2086, 0, 2),
(2087, 'TXTCANCLIENTCLOSETICKET', 2, 0, 2087, 0, 8),
(2088, 'TXTSOLUTIONANDTICKETSEARCH', 2, 0, 2088, 0, 0),
(2089, 'MSGRELEASESHASHPREFIXERROR', 2, 1, 2089, 0, 8),
(2090, 'TXTUNLINKEDFROM', 2, 0, 2090, 0, 0),
(2091, 'TXTPINNED', 2, 0, 2091, 0, 0),
(2092, 'TXTREMOVEDLABEL', 2, 0, 2092, 0, 0),
(2093, 'MSGTICKETPROPERTYUPDATED', 2, 0, 2093, 0, 0),
(2094, 'MSGTICKETNOTEADDED', 2, 0, 2094, 0, 0),
(2095, 'MSGTICKETNOTEDELETED', 2, 0, 2095, 0, 0),
(2096, 'MSGTICKETCOMMENTADDED', 2, 0, 2096, 0, 0),
(2097, 'MSGTICKETCOMMENTDELETED', 2, 0, 2097, 0, 0),
(2098, 'MSGTICKETPOSTUPDATED', 2, 0, 2098, 0, 0),
(2099, 'MSGADDEDNEWRECIPIENT', 2, 0, 2099, 0, 0),
(2100, 'MSGADDEDNEWPEOPLE', 2, 0, 2100, 0, 0),
(2101, 'MSGREMOVEDRECIPIENT', 2, 0, 2101, 0, 0),
(2102, 'MSGREMOVEDPEOPLE', 2, 0, 2102, 0, 0),
(2103, 'MSGADDEDNEWTAG', 2, 0, 2103, 0, 0),
(2104, 'TXTLEFTTORIGHT', 2, 0, 2104, 0, 0),
(2105, 'TXTSENDNOTIFORNEWTASKANDTASKCOMMENT', 2, 0, 2105, 0, 1),
(2106, 'TXTSEARCHTOPICS', 2, 0, 2106, 0, 4),
(2107, 'TXTALLACTIVITY', 2, 0, 2107, 0, 12),
(2108, 'TXTWAITINGFORAPPROVAL', 2, 0, 2108, 0, 0),
(2109, 'TXTYOURTOPICACTIVITY', 2, 0, 2109, 0, 12),
(2110, 'TXTALLCATEGORY', 2, 0, 2110, 0, 12),
(2111, 'TXTEDITFORUM', 2, 0, 2111, 0, 12),
(2112, 'TXTADDFORUMCATEGORY', 2, 0, 2112, 0, 12),
(2113, 'TXTADDFORUM', 2, 0, 2113, 0, 12),
(2114, 'TXTDELETEFORUMCATEGORY', 2, 0, 2114, 0, 12),
(2115, 'MSGDELETEFORUMCATEGORY', 2, 0, 2115, 0, 12),
(2116, 'TXTSCANNED', 2, 0, 2116, 0, 14),
(2117, 'TXTSENDEMAILNOTIFICATION', 2, 0, 2117, 0, 0),
(2118, 'TXTDELETETOPICCOMMENT', 2, 0, 2118, 0, 12),
(2119, 'MSGDELETETOPIC', 2, 0, 2119, 0, 12),
(2120, 'TXTDELETETOPIC', 2, 0, 2120, 0, 12),
(2121, 'TXTUPDATETOPIC', 2, 0, 2121, 0, 12),
(2122, 'TXTINSTALLED', 2, 0, 2122, 0, 14),
(2123, 'TXTDELETEFORUM', 2, 0, 2123, 0, 12),
(2124, 'MSGDELETEFORUM', 2, 0, 2124, 0, 12),
(2125, 'TXTUNLOCK', 2, 0, 2125, 0, 0),
(2126, 'TXTNEWTOPICS', 2, 0, 2126, 0, 0),
(2127, 'TXTTOPICFOLLOWERS', 2, 0, 2127, 0, 12),
(2128, 'TXTFORUMS', 1, 0, 2128, 0, 0),
(2129, 'TXTADDTOPIC', 1, 0, 2129, 0, 12),
(2130, 'TXTTOPICTITLE', 1, 0, 2130, 0, 12),
(2131, 'TXTPOSTTOPICIN', 1, 0, 2131, 0, 12),
(2132, 'TXTATTACHFILES', 1, 0, 2132, 0, 0),
(2133, 'TXTCREATEDBY', 1, 0, 2133, 0, 0),
(2134, 'TXTVOTE', 1, 0, 2134, 0, 0),
(2135, 'TXTCOMMENT', 1, 0, 2135, 0, 0),
(2136, 'TXTFOLLOW', 1, 0, 2136, 0, 12),
(2137, 'TXTUNFOLLOW', 1, 0, 2137, 0, 12),
(2138, 'TXTDELETEFORUMACTIVITY', 2, 0, 2138, 0, 12),
(2139, 'TXTNEWTOPIC', 2, 0, 2139, 0, 0),
(2140, 'TXTNEWTOPICCOMMENT', 2, 0, 2140, 0, 0),
(2141, 'TXTTOPIC', 2, 0, 2141, 0, 0),
(2142, 'TXTPOPULARITY', 1, 0, 2142, 0, 12),
(2143, 'MSGREQADDFORUMCAT', 2, 0, 2143, 0, 12),
(2144, 'MSGREQADDFORUM', 2, 0, 2144, 0, 12),
(2145, 'TXTPOSTTOPIC', 2, 0, 2145, 0, 12),
(2146, 'TXTISTOPICMOVE', 2, 0, 2146, 0, 12),
(2147, 'TXTSCHEDULETICKET', 2, 0, 2147, 0, 0),
(2148, 'TXTSCHEDULEDATE', 2, 0, 2148, 0, 0),
(2149, 'MSGSCHEDULEDATE', 2, 0, 2149, 0, 0),
(2150, 'MSGSCHEDULEENDDATE', 2, 0, 2150, 0, 0),
(2151, 'TXTREPEATSCHEDULE', 2, 0, 2151, 0, 0),
(2152, 'MSGNEWSCHEDULETKTCRT', 2, 0, 2152, 0, 0),
(2153, 'TXTVERIFYEMAIL', 1, 0, 2153, 0, 0),
(2154, 'TXTSEARCHRESULT', 1, 0, 2154, 0, 0),
(2155, 'TXTRECENT', 1, 0, 2155, 0, 0),
(2156, 'TXTPOPULAR', 1, 0, 2156, 0, 0),
(2157, 'TXTUNANSWERED', 1, 0, 2157, 0, 0),
(2158, 'TXTADDTICKETCATEGORY', 2, 0, 2158, 0, 0),
(2159, 'TXTDELTICKETCATEGORY', 2, 0, 2159, 0, 0),
(2160, 'TXTDELTICKETCATEGORYMSG', 2, 0, 2160, 0, 8),
(2161, 'TXTUPDATETICKETCATEGORY', 2, 0, 2161, 0, 8),
(2162, 'TXTADDTICKETSUBCATEGORY', 2, 0, 2162, 0, 8),
(2163, 'TXTUPDATETICKETSUBCATEGORY', 2, 0, 2163, 0, 8),
(2164, 'TXTDELTICKETSUBCATEGORY', 2, 0, 2164, 0, 8),
(2165, 'TXTDELTICKETSUBCATEGORYMSG', 2, 0, 2165, 0, 8),
(2166, 'TXTADDTICKETITEM', 2, 0, 2166, 0, 8),
(2167, 'TXTDELTICKETITEM', 2, 0, 2167, 0, 8),
(2168, 'TXTUPDATETICKETITEM', 2, 0, 2168, 0, 8),
(2169, 'TXTDELTICKETITEMMSG', 2, 0, 2169, 0, 8),
(2170, 'TXTADDTICKETLEVEL', 2, 0, 2170, 0, 8),
(2171, 'TXTDELTICKETLEVEL', 2, 0, 2171, 0, 8),
(2172, 'TXTUPDATETICKETLEVEL', 2, 0, 2172, 0, 8),
(2173, 'TXTDELTICKETLEVELMSG', 2, 0, 2173, 0, 8),
(2174, 'MSGENABLETICKETCATEGORY', 2, 0, 2174, 0, 8),
(2175, 'MSGENABLETICKETLEVEL', 2, 0, 2175, 0, 8),
(2176, 'TXTSUGGESTSEARCH', 2, 0, 2176, 0, 0),
(2177, 'TXTLOCATION', 1, 0, 2177, 0, 0),
(2178, 'TXTMOSTCOMMENTED', 1, 0, 2178, 0, 0),
(2179, 'TXTINSTALLEDON', 1, 0, 2179, 0, 14),
(2180, 'TXTCHANGECATEGORY', 2, 0, 2180, 0, 0),
(2181, 'TXTCHANGESUBCATEGORY', 2, 0, 2181, 0, 0),
(2182, 'TXTCHANGEITEM', 2, 0, 2182, 0, 0),
(2183, 'TXTCHANGELEVEL', 2, 0, 2183, 0, 0),
(2184, 'TXTCHANGELOCATION', 2, 0, 2184, 0, 0),
(2185, 'TXTSELECT', 1, 0, 2185, 0, 0),
(2186, 'TXTTICKETCATEGORY', 1, 0, 2186, 0, 0),
(2187, 'TXTTICKETSUBCATEGORY', 1, 0, 2187, 0, 0),
(2188, 'TXTTICKETITEM', 1, 0, 2188, 0, 0),
(2189, 'TXTTICKETLEVEL', 1, 0, 2189, 0, 0),
(2190, 'TXTINSTALLATION', 1, 0, 2190, 0, 0),
(2191, 'TXTMANGAEANDCLIENTPORTAL', 2, 0, 2191, 0, 0),
(2192, 'TXTDISPSUBCATEGORY', 2, 0, 2192, 0, 0),
(2193, 'TXTDISPITEM', 2, 0, 2193, 0, 0),
(2194, 'MSGTICKETLEVELCHANGED', 2, 0, 2194, 0, 0),
(2195, 'MSGTICKETCATEGORYCHANGED', 2, 0, 2195, 0, 0),
(2196, 'MSGTICKETSUBCATEGORYCHANGED', 2, 0, 2196, 0, 0),
(2197, 'MSGITILLOCATIONCHANGED', 2, 0, 2197, 0, 0),
(2198, 'TXTUNAPPROVEMESSAGE', 2, 0, 2198, 0, 0),
(2199, 'TXTRECURRENCE', 2, 0, 2199, 0, 2),
(2200, 'TXTCATEGORYCHANGE', 2, 0, 2200, 0, 0),
(2201, 'TXTSUBCATEGORYCHANGE', 2, 0, 2201, 0, 0),
(2202, 'TXTITEMCHANGE', 2, 0, 2202, 0, 0),
(2203, 'TXTLEVELCHANGE', 2, 0, 2203, 0, 0),
(2204, 'TXTLOCATIONCHANGE', 2, 0, 2204, 0, 0),
(2205, 'TXTTICKETSCHEDULE', 2, 0, 2205, 0, 2),
(2206, 'TXTUNINSTALLED', 1, 0, 2206, 0, 14),
(2207, 'TXTFORUMACTIVITY', 1, 0, 2207, 0, 0),
(2208, 'TXTAPPROVEDTOPICS', 1, 0, 2208, 0, 12),
(2209, 'TXTFOLLOWEDTOPICS', 1, 0, 2209, 0, 12),
(2210, 'TXTFORUMSIGNATURE', 1, 0, 2210, 0, 0),
(2211, 'TXTOK', 1, 0, 2211, 0, 0),
(2212, 'MSGEMAILNOTIFICATION', 1, 0, 2212, 0, 0),
(2213, 'TXTPENDINGTOPICS', 1, 0, 2213, 0, 4),
(2214, 'TXTDEFAULTPAGEAFTERLOGIN', 2, 0, 2214, 0, 8),
(2215, 'TXTDEFAULTPAGEBEFORELOGIN', 2, 0, 2215, 0, 8),
(2216, 'TXTUSERTYPE', 2, 0, 2216, 0, 0),
(2217, 'TXTPREVIOUS', 2, 0, 2217, 0, 0),
(2218, 'MSGCOMMENTAWITINGMOD', 1, 0, 2218, 0, 12),
(2219, 'MSGTOPICAWITINGMOD', 1, 0, 2219, 0, 12),
(2220, 'TXTREPEAT', 2, 0, 2220, 0, 0),
(2221, 'TXTOCCURANCELEFT', 2, 0, 2221, 0, 1),
(2222, 'TXTQUEUEOUTGOINGMAILS', 2, 0, 2222, 0, 0),
(2223, 'MSGNOLINKTICKETFOUND', 2, 0, 2223, 0, 0),
(2224, 'TXTREMOVED', 1, 0, 2224, 0, 0),
(2225, 'TXTOVERUSE', 1, 0, 2225, 0, 14),
(2226, 'TXTPAUSESLA', 2, 0, 2226, 0, 0),
(2227, 'TXTRESUMESLA', 2, 0, 2227, 0, 0),
(2228, 'TXTSLAPAUSED', 2, 0, 2228, 0, 0),
(2229, 'TXTSLARESUMED', 2, 0, 2229, 0, 0),
(2230, 'TXTPAUSEORRESUMESLA', 2, 0, 2230, 0, 8),
(2231, 'TXTWITH', 2, 0, 2231, 0, 0),
(2232, 'TXTTYPEHEREART', 1, 0, 2232, 0, 0),
(2233, 'TXTARTICLESUGGESTIONS', 1, 0, 2233, 0, 0),
(2234, 'TXTDESTINATION', 2, 0, 2234, 0, 0),
(2235, 'TXTISSUEID', 2, 0, 2235, 0, 8),
(2236, 'TXTISMIGRATED', 2, 0, 2236, 0, 14),
(2237, 'TXTCREATEISSUEWITHREADMINE', 2, 0, 2237, 0, 8),
(2238, 'TXTTRACKER', 2, 0, 2238, 0, 8),
(2239, 'TXTISSUE', 2, 0, 2239, 0, 8),
(2240, 'TXTPROJECTNAME', 2, 0, 2240, 0, 8),
(2241, 'MSGISSUELIKED', 2, 0, 2241, 0, 8),
(2242, 'TXTSELECTISSUE', 2, 0, 2242, 0, 8),
(2243, 'TXTSELECTTRACKER', 2, 0, 2243, 0, 8),
(2244, 'TXTVIEWISSUEINREDMINE', 2, 0, 2244, 0, 8),
(2245, 'TXTENABLED', 1, 0, 2245, 0, 0),
(2246, 'TXTDISABLED', 1, 0, 2246, 0, 0),
(2247, 'TXTAUTOGENRATEORG', 2, 0, 2247, 0, 8),
(2248, 'TXTIGNOREORGANIZATION', 2, 0, 2248, 0, 8),
(2249, 'TXTENABLESUBJECTMATCHING', 2, 0, 2249, 0, 0),
(2250, 'TXTVISIBLRTOLEFTPANEL', 2, 0, 2250, 0, 8),
(2251, 'TXTDEFAULT', 2, 0, 2251, 0, 0),
(2252, 'TXTBOTHTICKETCREATION', 2, 0, 2252, 0, 8),
(2253, 'TXTSHOWONLINESTAFF', 2, 0, 2253, 0, 8),
(2254, 'TXTBASEDTICKHASSUBJLINE', 2, 0, 2254, 0, 8),
(2255, 'TXTBASEDTICKSUB', 2, 0, 2255, 0, 8),
(2256, 'TXTADDITIONALEMAILS', 1, 0, 2256, 0, 0),
(2257, 'TXTBLANKFIELD', 1, 0, 2257, 0, 0),
(2258, 'TXTEMAILALREADYEXIST', 1, 0, 2258, 0, 0),
(2259, 'TXTFAX', 1, 0, 2259, 0, 0),
(2260, 'TXTMOBILENUMBER', 1, 0, 2260, 0, 0),
(2261, 'TXTTEMPLATE', 2, 0, 2261, 0, 0),
(2262, 'TXTONLASTACTIVITY', 2, 0, 2262, 0, 0),
(2263, 'TXTSLASTATE', 2, 0, 2263, 0, 0),
(2264, 'TXTFAVICON', 2, 0, 2264, 0, 0),
(2265, 'MSGINVALIDCHARACTER', 2, 0, 2265, 0, 0),
(2266, 'TXTRESEND', 1, 0, 2266, 0, 0),
(2267, 'TXTTASKLISTCOUNT', 2, 0, 2267, 0, 0),
(2268, 'TXTDISPLAYAMOUNTONTIMETRACK', 2, 0, 2268, 0, 8),
(2269, 'MSGNUMERICVALIDATIONFORMINUTES', 2, 0, 2269, 0, 8),
(2270, 'TXTISMANAGER', 1, 0, 2270, 0, 0),
(2271, 'TXTADVSEARCH', 1, 0, 2271, 0, 0),
(2272, 'TXTFLAG', 1, 0, 2272, 0, 0),
(2273, 'TXTOWNER', 1, 0, 2273, 0, 0),
(2274, 'TXTREPORT', 1, 0, 2274, 0, 0),
(2275, 'TXTBYSTATUS', 1, 0, 2275, 0, 7),
(2276, 'TXTPRIPORTY', 1, 0, 2276, 0, 7),
(2277, 'TXTBYTYPE', 1, 0, 2277, 0, 7),
(2278, 'TXTBYOWNER', 1, 0, 2278, 0, 7),
(2279, 'TXTSELECTDURATION', 1, 0, 2279, 0, 7),
(2280, 'TXTLASTDAYS', 1, 0, 2280, 0, 7),
(2281, 'TXTLASTSEVENDAYS', 1, 0, 2281, 0, 0),
(2282, 'TXTLASTTWENTYFOURHOURS', 1, 0, 2282, 0, 7),
(2283, 'TXTMIGRATEDFROM', 1, 0, 2283, 0, 0),
(2284, 'TXTONGOINGAUDIT', 2, 0, 2284, 0, 8),
(2285, 'TXTASSETSTATEWISESUMMARY', 2, 0, 2285, 0, 14),
(2286, 'TXTNEWUPDATES', 2, 0, 2286, 0, 14),
(2287, 'TXTAUTOAPPOCOMMENT', 2, 0, 2287, 0, 0),
(2288, 'TXTCLIENTBYORGNATION', 1, 0, 2288, 0, 0),
(2289, 'TXTCLIENTBYTICKET', 1, 0, 2289, 0, 7),
(2290, 'TXTAUTOSOFTCONMAP', 2, 0, 2290, 0, 8),
(2291, 'TXTVIEWRESULT', 1, 0, 2291, 0, 7),
(2292, 'TXTGENERATE', 1, 0, 2292, 0, 0),
(2293, 'TXTCUSTOM', 1, 0, 2293, 0, 0),
(2294, 'TXTANALYSIS', 1, 0, 2294, 0, 2),
(2295, 'TXTUPDATEEXOTELAPP', 2, 0, 2295, 0, 8),
(2296, 'TXTAPPROVAL', 1, 0, 2296, 0, 0),
(2297, 'MSGEXOPHONEREQ', 2, 0, 2297, 0, 8),
(2298, 'TXTCHARTER', 2, 0, 2298, 0, 2),
(2299, 'TXTCONNECTCUSTTOAGENT', 2, 0, 2299, 0, 0),
(2300, 'TXTCONNECTCUSTTOFLOW', 2, 0, 2300, 0, 8),
(2301, 'TXTSENDBULKSMS', 2, 0, 2301, 0, 0),
(2302, 'TXTTIMELIMIT', 2, 0, 2302, 0, 8),
(2303, 'TXTOUT', 2, 0, 2303, 0, 0),
(2304, 'TXTOPTIONAL', 2, 0, 2304, 0, 8),
(2305, 'TXTCALLERID', 2, 0, 2305, 0, 8),
(2306, 'TXTCALLTYPE', 2, 0, 2306, 0, 8),
(2307, 'TXTTRANS', 2, 0, 2307, 0, 8),
(2308, 'TXTPROMO', 2, 0, 2308, 0, 8),
(2309, 'TXTCONNECT', 2, 0, 2309, 0, 8),
(2310, 'TXTDESIGN', 2, 0, 2310, 0, 2),
(2311, 'MSGSELECTCALLER', 2, 0, 2311, 0, 0),
(2312, 'MSGFROM', 2, 0, 2312, 0, 0),
(2313, 'MSGTO', 2, 0, 2313, 0, 0),
(2314, 'TXTMSGBODY', 2, 0, 2314, 0, 0),
(2315, 'TXTSENADSMS', 2, 0, 2315, 0, 0),
(2316, 'MSGBODY', 2, 0, 2316, 0, 0),
(2317, 'TXTAUTOTICKETECREATION', 2, 0, 2317, 0, 0),
(2318, 'TXTENDDATE', 1, 0, 2318, 0, 0),
(2319, 'TXTDURATION', 1, 0, 2319, 0, 0),
(2320, 'TXTPRICE', 1, 0, 2320, 0, 0),
(2321, 'TXTDIRECTION', 1, 0, 2321, 0, 0),
(2322, 'TXTSENSTDATE', 2, 0, 2322, 0, 0),
(2323, 'TXTBODY', 2, 0, 2323, 0, 0),
(2324, 'TXTSMSDETAILS', 2, 0, 2324, 0, 8),
(2325, 'TXTOUTWARDCALL', 2, 0, 2325, 0, 8),
(2326, 'TXTINWARDCALL', 2, 0, 2326, 0, 8),
(2327, 'TXTOUTWARDMSG', 2, 0, 2327, 0, 8),
(2328, 'TXTINWARDMSG', 2, 0, 2328, 0, 8),
(2329, 'TXTORDERREPORT', 2, 0, 2329, 0, 7),
(2330, 'TXTBILLINGSTATUS', 2, 0, 2330, 0, 7),
(2331, 'TXTSELECTSTATUS', 2, 0, 2331, 0, 7),
(2332, 'TXTTOTALINVOICEID', 2, 0, 2332, 0, 7),
(2333, 'TXTTOTALPAID', 2, 0, 2333, 0, 7),
(2334, 'TXTBUILD', 2, 0, 2334, 0, 2),
(2335, 'TXTBONUSPOINTREPOT', 2, 0, 2335, 0, 7),
(2336, 'TXTSTAFFPOINTREPORT', 2, 0, 2336, 0, 7),
(2337, 'TXTCLIENTTRANSACTIONREPORT', 2, 0, 2337, 0, 7),
(2338, 'TXTCLIENTORDERREPORT', 2, 0, 2338, 0, 7),
(2339, 'TXTTRANSACTIONREPORT', 2, 0, 2339, 0, 7),
(2340, 'TXTFIRSTRESPONSE', 2, 0, 2340, 0, 7),
(2341, 'TXTBILLINGINVOICEREPORT', 2, 0, 2341, 0, 7),
(2342, 'TXTTOTALTICKET', 2, 0, 2342, 0, 7),
(2343, 'TXTTOTALOPEN', 2, 0, 2343, 0, 7),
(2344, 'TXTTOTALCLOSE', 2, 0, 2344, 0, 7),
(2345, 'TXTTOTALPROGRESS', 2, 0, 2345, 0, 7),
(2346, 'TXTDEPARTMENTNAME', 2, 0, 2346, 0, 7),
(2347, 'TXTPROINPROGRESS', 2, 0, 2347, 0, 7),
(2348, 'TXTUPDATECUSTOM', 2, 0, 2348, 0, 7),
(2349, 'TXTCREATECUSTOMREPORT', 2, 0, 2349, 0, 7),
(2350, 'TXTCUSTOMVIEWREPORT', 2, 0, 2350, 0, 7),
(2351, 'TXTTOTALRESPONSE', 2, 0, 2351, 0, 7),
(2352, 'TXTPAIDSTATUS', 2, 0, 2352, 0, 7),
(2353, 'TXTREFERENCETICKET', 2, 0, 2353, 0, 7),
(2354, 'TXTORDERID', 2, 0, 2354, 0, 7),
(2355, 'TXTDURATIONPOINT', 2, 0, 2355, 0, 7),
(2356, 'TXTTKTCHNLGRP', 2, 0, 2356, 0, 7),
(2357, 'TXTDELETEDTICKETS', 2, 0, 2357, 0, 7),
(2358, 'TXTDELETEDATE', 2, 0, 2358, 0, 7),
(2359, 'TXTMERGEDDATE', 2, 0, 2359, 0, 7),
(2360, 'TXTMERGEDTICKETS', 2, 0, 2360, 0, 7),
(2361, 'CHNLNAME', 2, 0, 2361, 0, 7),
(2362, 'TXTTOTALNOTKT', 2, 0, 2362, 0, 7),
(2363, 'TXTRSLVDATE', 2, 0, 2363, 0, 0),
(2364, 'TXTITILPRBSOLVE', 2, 1, 2364, 0, 7),
(2365, 'TXTPRBFRM', 2, 1, 2365, 0, 0),
(2366, 'TXTCSTFLDRPT', 2, 0, 2366, 0, 7),
(2367, 'TXTFLDVAL', 2, 0, 2367, 0, 7),
(2368, 'TXTCSTRPTUSRREG', 2, 0, 2368, 0, 7),
(2369, 'TXTREPLYDATE', 2, 0, 2369, 0, 7),
(2370, 'TXTTOTALPOINT', 2, 0, 2370, 0, 7),
(2371, 'TXTCURRENTRANK', 2, 0, 2371, 0, 7),
(2372, 'TXTNOTANSWEREDTICKET', 2, 0, 2372, 0, 7);
INSERT INTO `avis_language_variables` VALUES
(2373, 'TXTTICKETESCGROUPSTAFFOWNER', 2, 0, 2373, 0, 7),
(2374, 'TXTTICKETESCGROUPDEPARTMENT', 2, 0, 2374, 0, 7),
(2375, 'TXTNEXTASSIGNED', 2, 0, 2375, 0, 2),
(2376, 'TXTEXPORTTYPE', 2, 0, 2376, 0, 0),
(2377, 'TXTSCHEDULEREPORT', 2, 0, 2377, 0, 7),
(2378, 'TXTSCHEDULETYPE', 2, 0, 2378, 0, 7),
(2379, 'TXTRECEIVECONTACTMAIL', 1, 0, 2379, 0, 0),
(2380, 'TXTRECIEVEPCLIENTANDCONTACTSMAIL', 1, 0, 2380, 0, 0),
(2381, 'TXTTOTALTICKETSRESOLVED', 2, 0, 2381, 0, 7),
(2382, 'TXTLOGINACTIVITY', 2, 0, 2382, 0, 7),
(2383, 'TXTSTAFFACTIVITIES', 2, 0, 2383, 0, 7),
(2384, 'TXTACTIVITYTRACKING', 2, 0, 2384, 0, 7),
(2385, 'TXTAVGRESPONSETIMEGROUPBYSTAFF', 2, 0, 2385, 0, 7),
(2386, 'TXTLASTREPLIERTIME', 2, 0, 2386, 0, 0),
(2387, 'TXTCREATENEW', 2, 0, 2387, 0, 8),
(2388, 'TXTCUSTOMREPORTS', 2, 0, 2388, 0, 7),
(2389, 'TXTDISPLAYCOUNT', 2, 0, 2389, 0, 7),
(2390, 'MSGNEWCMDB', 2, 0, 2390, 0, 0),
(2391, 'DEPTSETTO', 2, 0, 2391, 0, 14),
(2392, 'CITYPESETTO', 2, 0, 2392, 0, 14),
(2393, 'IMPACTSETTO', 2, 0, 2393, 0, 0),
(2394, 'TXTLOCSETTO', 2, 0, 2394, 0, 0),
(2395, 'TXTSETTO', 2, 0, 2395, 0, 0),
(2396, 'MSGUPDATECMDB', 2, 0, 2396, 0, 14),
(2397, 'TXTUPDATEDTO', 2, 0, 2397, 0, 0),
(2398, 'TXTCLIENTWITHMAXTICKET', 2, 0, 2398, 0, 7),
(2399, 'TXTMAXCOUNT', 2, 0, 2399, 0, 7),
(2400, 'TXTCLIENTWITHMAXREPLYTICKET', 2, 0, 2400, 0, 7),
(2401, 'TXTDOMAINREPORT', 2, 0, 2401, 0, 7),
(2402, 'TXTQUESTSTAFF', 2, 0, 2402, 0, 7),
(2403, 'TXTFORUM', 1, 0, 2403, 0, 0),
(2404, 'TXTSUBMITATICKET', 1, 0, 2404, 0, 3),
(2405, 'TXTLETSHELPU', 1, 0, 2405, 0, 4),
(2406, 'TXTHIPCHATALERT', 2, 0, 2406, 0, 0),
(2407, 'TXTSLACKALERT', 2, 0, 2407, 0, 8),
(2408, 'TXTMATCHFOUND', 2, 0, 2408, 0, 1),
(2409, 'MSGCONTACTNOEXISTED', 1, 0, 2409, 0, 3),
(2410, 'TXTTOTALCLIENT', 2, 0, 2410, 0, 0),
(2411, 'MSGORGIDMISS', 2, 0, 2411, 0, 3),
(2412, 'TXTCASES', 2, 0, 2412, 0, 0),
(2413, 'TXTMOSTCOMMETEDARTICLE', 2, 0, 2413, 0, 7),
(2414, 'TXTMOSTVIEWEDARTICLE', 2, 0, 2414, 0, 7),
(2415, 'TXTMOSTRAREDARTICLE', 2, 0, 2415, 0, 7),
(2416, 'TXTFORMGROUP', 2, 0, 2416, 0, 0),
(2417, 'TXTADDFORMGROUP', 2, 0, 2417, 0, 8),
(2418, 'TXTDELETEFORM', 2, 0, 2418, 0, 8),
(2419, 'MSGFORMGRPDEL', 2, 0, 2419, 0, 8),
(2420, 'TXTUPDATEFORMGROUP', 2, 0, 2420, 0, 8),
(2421, 'TXTFORMFIELD', 2, 0, 2421, 0, 0),
(2422, 'TXTADDNEWFORMFIELD', 2, 0, 2422, 0, 8),
(2423, 'TXTDELETEFORMFIELD', 2, 0, 2423, 0, 8),
(2424, 'TXTPLACEHOLDER', 2, 0, 2424, 0, 0),
(2425, 'TXTTOOLTIP', 2, 0, 2425, 0, 0),
(2426, 'TXTIMAGE', 2, 0, 2426, 0, 0),
(2427, 'TXTTEST', 2, 0, 2427, 0, 0),
(2428, 'TXTHTMLATTRIBUTE', 2, 0, 2428, 0, 8),
(2429, 'TXTDISPLAYTITLE', 2, 0, 2429, 0, 0),
(2430, 'TXTFORMTYPE', 2, 0, 2430, 0, 0),
(2431, 'MSGMANDATORYEMAILFIELD', 2, 0, 2431, 0, 0),
(2432, 'MSGMANDATORYCALLFIELD', 2, 0, 2432, 0, 0),
(2433, 'TXTEBABLECAPTCHA', 2, 0, 2433, 0, 0),
(2434, 'TXTHELPDESKURL', 2, 0, 2434, 0, 0),
(2435, 'TXTIFRAMEURL', 2, 0, 2435, 0, 8),
(2436, 'TXTISINLINE', 2, 0, 2436, 0, 8),
(2437, 'TXTISEDITOR', 2, 0, 2437, 0, 8),
(2438, 'TXTNOOFATTACHMENTS', 2, 0, 2438, 0, 8),
(2439, 'TXTTHANKYOU', 1, 0, 2439, 0, 0),
(2440, 'TXTINVALIDEMAIL', 1, 0, 2440, 0, 0),
(2441, 'TXTINVALIDNUMERIC', 1, 0, 2441, 0, 0),
(2442, 'TXTINVALIDAPHA', 1, 0, 2442, 0, 0),
(2443, 'TXTINVALIDALPGHANUM', 1, 0, 2443, 0, 0),
(2444, 'TXTFORMNAME', 1, 0, 2444, 0, 8),
(2445, 'TXTOPERATIONALLIVE', 2, 0, 2445, 0, 2),
(2446, 'TXTEDITFORMFIELD', 2, 0, 2446, 0, 8),
(2447, 'TXTUPDATEFORMFIELD', 2, 0, 2447, 0, 0),
(2448, 'TXTMAILQUEUENOTEXIST', 2, 0, 2448, 0, 8),
(2449, 'TXTCLIENTEMAILNOTVERIFIED', 2, 0, 2449, 0, 8),
(2450, 'TXTCONTACTACCESS', 2, 0, 2450, 0, 8),
(2451, 'TXTCLIENTREGISTRATIONERROR', 2, 0, 2451, 0, 8),
(2452, 'TXTTICKETCREATIONERROR', 2, 0, 2452, 0, 8),
(2453, 'MSGNOFORM', 1, 0, 2453, 0, 2),
(2454, 'TXTPROBLEMGROUPBYSTATUS', 2, 1, 2454, 0, 7),
(2455, 'TXTPROBLEMGROUPBYPRIORITY', 2, 1, 2455, 0, 7),
(2456, 'TXTPROBLEMGROUPBYIMPACT', 2, 1, 2456, 0, 7),
(2457, 'TXTINVOICEHASH', 2, 0, 2457, 0, 0),
(2458, 'TXTBACKTOLISTING', 2, 0, 2458, 0, 8),
(2459, 'MSGINVALIDCLIENTFORMERGE', 2, 0, 2459, 0, 3),
(2460, 'MSGMANDATORYFIELDS', 1, 0, 2460, 0, 0),
(2461, 'TXTSCHEDULEDREPORT', 2, 0, 2461, 0, 7),
(2462, 'TXTTASKNOTIFICATION', 2, 0, 2462, 0, 0),
(2463, 'TXTNOTSTARTEDTASK', 2, 0, 2463, 0, 0),
(2464, 'TXTHIDECLIENTPORTAL', 2, 0, 2464, 0, 8),
(2465, 'TXTPROBLEMSPERDEPT', 2, 1, 2465, 0, 7),
(2466, 'TXTCHANGESPERDEPT', 2, 1, 2466, 0, 7),
(2467, 'TXTRELEASESPERDEPT', 2, 1, 2467, 0, 7),
(2468, 'TXTSLAANDESCALATION', 2, 0, 2468, 0, 7),
(2469, 'TXTRATINGANDSURVEY', 2, 0, 2469, 0, 7),
(2470, 'TXTASSIGNSTAFFTASKREPORT', 2, 0, 2470, 0, 7),
(2471, 'TXTASSETNAME', 2, 0, 2471, 0, 0),
(2472, 'TXTASSETSUSEDBYCLIENT', 2, 0, 2472, 0, 7),
(2473, 'TXTASSETMANAGEDBYSTAFF', 2, 0, 2473, 0, 7),
(2474, 'TXTTICKETLINKREPORT', 2, 0, 2474, 0, 7),
(2475, 'TXTCOMMENTEDREPORT', 2, 0, 2475, 0, 7),
(2476, 'TXTASSETLINKTOTICKETS', 2, 0, 2476, 0, 7),
(2477, 'TXTTYPETOSEARCHEXISTINGTICKETHASH', 2, 0, 2477, 0, 0),
(2478, 'TXTTASKLINKED', 2, 0, 2478, 0, 1),
(2479, 'TXTCITEMLINKED', 2, 0, 2479, 0, 1),
(2480, 'TXTPROBLEMLINKED', 2, 1, 2480, 0, 0),
(2481, 'TXTCHANGESLINKED', 2, 1, 2481, 0, 10),
(2482, 'TXTRELEASELINKEDTOCHANGES', 2, 1, 2482, 0, 0),
(2483, 'TXTCHANGESRESOLVEDBYSTAFF', 2, 1, 2483, 0, 7),
(2484, 'TXTTOTALREPLIEDTICKET', 2, 0, 2484, 0, 7),
(2485, 'TXTCLOSETICKETDATE', 2, 0, 2485, 0, 7),
(2486, 'TXTMARKREAD', 2, 0, 2486, 0, 2),
(2487, 'TXTMARKUNREAD', 2, 0, 2487, 0, 2),
(2488, 'TXTRETIRING', 2, 0, 2488, 0, 2),
(2489, 'TXTDEPTSLAREPORT', 2, 0, 2489, 0, 7),
(2490, 'TXTAVGRESOLUTIONTIME', 2, 0, 2490, 0, 7),
(2491, 'TXTSTAFFWORK', 2, 0, 2491, 0, 7),
(2492, 'TXTSTAFFAVGRESPONSETIME', 2, 0, 2492, 0, 7),
(2493, 'TXTQUESTTOPPERFORMER', 2, 0, 2493, 0, 7),
(2494, 'TXTBILLINGSUMMARY', 2, 0, 2494, 0, 0),
(2495, 'TXTRETIRED', 2, 0, 2495, 0, 2),
(2496, 'TXTLIFECYCLESTAGE', 2, 0, 2496, 0, 0),
(2497, 'TXTGUESTEMAIL', 2, 0, 2497, 0, 0),
(2498, 'TXTADDCALENDEREVENT', 2, 0, 2498, 0, 0),
(2499, 'TXTGCALEVENTSDETAILS', 2, 0, 2499, 0, 0),
(2500, 'TXTGCALTASKSDETAILS', 2, 0, 2500, 0, 0),
(2501, 'TXTTASKLIST', 2, 0, 2501, 0, 0),
(2502, 'TXTEVENTS', 2, 0, 2502, 0, 0),
(2503, 'TXTCLIENTOVERVIEW', 2, 0, 2503, 0, 7),
(2504, 'TXTCLIENTINVOICESREPORT', 2, 0, 2504, 0, 7),
(2505, 'TXTTOTALUNPAID', 2, 0, 2505, 0, 7),
(2506, 'TXTTOTALCANCELLED', 2, 0, 2506, 0, 7),
(2507, 'TXTTOTALINPROCESS', 2, 0, 2507, 0, 7),
(2508, 'TXTTICKETBYCHANNEL', 2, 0, 2508, 0, 7),
(2509, 'TXTQUEUESUMMARY', 2, 0, 2509, 0, 0),
(2510, 'TXTTOTALREPORTQUEUE', 2, 0, 2510, 0, 7),
(2511, 'TXTMYREPORTQUEUE', 2, 0, 2511, 0, 7),
(2512, 'TXTMYCOMPLITEDQUEUE', 2, 0, 2512, 0, 7),
(2513, 'TXTREPORTINQUEUE', 2, 0, 2513, 0, 7),
(2514, 'MSGSTARTDATEVALIDATION', 2, 0, 2514, 0, 7),
(2515, 'TXTMODIFICATIONDATE', 1, 0, 2515, 0, 0),
(2516, 'TXTVIEW', 1, 0, 2516, 0, 0),
(2517, 'TXTSTAFFLEAD', 2, 0, 2517, 0, 7),
(2518, 'TXTSOLVEDTICKETS', 2, 0, 2518, 0, 7),
(2519, 'AVGFIRSTREPLY', 2, 0, 2519, 0, 7),
(2520, 'TXTNETWORKSCAN', 2, 0, 2520, 0, 8),
(2521, 'TXTAVGSLATIME', 2, 0, 2521, 0, 7),
(2522, 'TXTCREATEFILTER', 2, 0, 2522, 0, 0),
(2523, 'TXTSUBMITTEDBY', 1, 0, 2523, 0, 0),
(2524, 'TXTTYPETOSEARCHEXISTINGSTAFFSEMAILADDRESS', 2, 0, 2524, 0, 10),
(2525, 'TXTRESOLVEDBY', 2, 0, 2525, 0, 0),
(2526, 'TXTADDORLINKSOFTWARE', 2, 0, 2526, 0, 0),
(2527, 'TXTWASTHISARTICLEHELPFUL', 1, 0, 2527, 0, 4),
(2528, 'TXTOUTOF', 1, 0, 2528, 0, 0),
(2529, 'TXTFOUNDTHISHELPFUL', 1, 0, 2529, 0, 4),
(2530, 'TXTARTICLELIKE', 2, 0, 2530, 0, 8),
(2531, 'TXTFEEDBACKCLIENT', 2, 0, 2531, 0, 0),
(2532, 'TXTORGNAME', 2, 0, 2532, 0, 0),
(2533, 'MSGCONTACTNOINVALIDEORMISSING', 2, 0, 2533, 0, 0),
(2534, 'TXTACCOUNT', 2, 0, 2534, 0, 0),
(2535, 'TXTHARVEST', 2, 0, 2535, 0, 2),
(2536, 'TXTCREATEINVOICEWITHHARVEST', 2, 0, 2536, 0, 2),
(2537, 'TXTISSUEDATE', 2, 0, 2537, 0, 0),
(2538, 'TXTUSER', 2, 0, 2538, 0, 0),
(2539, 'TXTSELECTTOP', 2, 0, 2539, 0, 0),
(2540, 'TXTSELECTALLREAD', 2, 0, 2540, 0, 2),
(2541, 'TXTSELECTALLUNREAD', 2, 0, 2541, 0, 2),
(2542, 'MSGCSVFILENOTEXTST', 2, 0, 2542, 0, 8),
(2543, 'TXTSELECTFORGENERATE', 1, 0, 2543, 0, 0),
(2544, 'TXTADDORUPDATEATTRIBUTES', 2, 0, 2544, 0, 8),
(2545, 'TXTTICKETREPLIEDBYSTAFF', 2, 0, 2545, 0, 7),
(2546, 'TXTTICKETFORWARDEDBYSTAFF', 2, 0, 2546, 0, 7),
(2547, 'TXTFORWARDCOUNT', 2, 0, 2547, 0, 7),
(2548, 'TXTREADTICKETENTRYTOADUITLOG', 2, 0, 2548, 0, 8),
(2549, 'TXTREADTICKETFORSTAFF', 2, 0, 2549, 0, 0),
(2550, 'TXTTICKETVIEWEDBYSTAFF', 2, 0, 2550, 0, 7),
(2551, 'TXTASSETLINKTOPROBLEM', 2, 1, 2551, 0, 7),
(2552, 'TXTASSETGROUPSTATUS', 2, 0, 2552, 0, 7),
(2553, 'TXTNOTEXPIRED', 2, 0, 2553, 0, 0),
(2554, 'TXTASSETGROUPBYLOCATIONS', 2, 0, 2554, 0, 7),
(2555, 'TXTSTATUSTASK', 2, 0, 2555, 0, 7),
(2556, 'TXTASSETTYPE', 2, 0, 2556, 0, 7),
(2557, 'TXTASSTEPRODUCT', 2, 0, 2557, 0, 7),
(2558, 'TXTHARDWREASSETBYSTATE', 2, 0, 2558, 0, 7),
(2559, 'TXTASSETDEPRECIATION', 2, 0, 2559, 0, 7),
(2560, 'TXTRELATIONSHIPMNGT', 2, 0, 2560, 0, 8),
(2561, 'TXTASSETDEPRECIATIONNOTIFY', 2, 0, 2561, 0, 7),
(2562, 'TXTREMAININGWARRANTY', 2, 0, 2562, 0, 7),
(2563, 'TXTSHOW', 2, 0, 2563, 0, 0),
(2564, 'TXTTOTALUNASSIGNED', 2, 0, 2564, 0, 0),
(2565, 'TXTTOTALMULASSIGNED', 2, 0, 2565, 0, 0),
(2566, 'TXTMORETHAN', 2, 0, 2566, 0, 0),
(2567, 'TXTSELECTTEAM', 2, 0, 2567, 0, 2),
(2568, 'TXTSENDTICKETAPPROVAL', 2, 0, 2568, 0, 0),
(2569, 'TXTCHANGETICKETAPPROVALSTATUS', 2, 0, 2569, 0, 0),
(2570, 'TXTSENDTICKETAPPROVALREMINDER', 2, 0, 2570, 0, 0),
(2571, 'TXTPORTALURL', 2, 0, 2571, 0, 8),
(2572, 'TXTCREATECONTACTINVTIGER', 2, 0, 2572, 0, 8),
(2573, 'TXTROUNDROBIN', 2, 0, 2573, 0, 0),
(2574, 'TXTADDRONDROBIN', 2, 0, 2574, 0, 0),
(2575, 'TXTUPDATEROUNDROBIN', 2, 0, 2575, 0, 0),
(2576, 'TXTDELROUNDROBIN', 2, 0, 2576, 0, 0),
(2577, 'TXTESCALATIONRULE', 2, 0, 2577, 0, 0),
(2578, 'MSGTICKETASSIGNBYESCALATIONRULE', 2, 0, 2578, 0, 0),
(2579, 'MSGSENDESCALATIONEMAIL', 2, 0, 2579, 0, 0),
(2580, 'TXTAUTOASSIGN', 2, 0, 2580, 0, 0),
(2581, 'TXTAVILABLEAGENTS', 2, 0, 2581, 0, 0),
(2582, 'TXTAGENTAVAILABILITY', 2, 0, 2582, 0, 0),
(2583, 'TXTACCEPTING', 2, 0, 2583, 0, 0),
(2584, 'TXTNOTACCEPTING', 2, 0, 2584, 0, 0),
(2585, 'TXTTICKETASSIGNMENT', 2, 0, 2585, 0, 0),
(2586, 'TXTVOICEMAIL', 2, 0, 2586, 0, 0),
(2587, 'TXTSSO', 2, 0, 2587, 0, 8),
(2588, 'TXTREMOTELOGINURL', 2, 0, 2588, 0, 0),
(2589, 'TXTREMOTELOGOUTURL', 2, 0, 2589, 0, 0),
(2590, 'TXTSSOTYPE', 2, 0, 2590, 0, 0),
(2591, 'TXTASSETSUSEDBYGUEST', 2, 0, 2591, 0, 7),
(2592, 'TXTCERTIFICATEFPRINT', 2, 0, 2592, 0, 0),
(2593, 'TXTCONTACT', 2, 0, 2593, 0, 0),
(2594, 'TXTCREATETICKETEWITHVTIGER', 2, 0, 2594, 0, 8),
(2595, 'TXTTWILIOMESSAGE', 2, 0, 2595, 0, 8),
(2596, 'TXTCONFIGTWILIO', 2, 0, 2596, 0, 8),
(2597, 'TXTCREATEOPPORTUNITIES', 2, 0, 2597, 0, 0),
(2598, 'TXTSALSESTAGE', 2, 0, 2598, 0, 14),
(2599, 'TXTSELFAUTOTICKETASSIGN', 2, 0, 2599, 0, 8),
(2600, 'TXTMYDRIVE', 2, 0, 2600, 0, 0),
(2601, 'TXTDRIVELISTCOUNT', 2, 0, 2601, 0, 8),
(2602, 'TXTTICKETATTACHMENTS', 2, 0, 2602, 0, 0),
(2603, 'MSGREQSTAFFSEMAIL', 2, 0, 2603, 0, 12),
(2604, 'TXTASSETEXPIRYRPT', 2, 0, 2604, 0, 7),
(2605, 'TXTTOTALOPENTICKET', 2, 0, 2605, 0, 7),
(2606, 'TXTVIEWBYSTAFFDATE', 2, 0, 2606, 0, 7),
(2607, 'TXTGOOGLEDRIVESEARCHERROR', 2, 0, 2607, 0, 0),
(2608, 'TXTHARDWARE', 2, 0, 2608, 0, 0),
(2609, 'TXTSOFTWARE', 2, 0, 2609, 0, 0),
(2610, 'TXTINVOICEBYORGANIZATION', 2, 0, 2610, 0, 7),
(2611, 'MSGCUSTOMEFIELDDATAMODIFIED', 2, 0, 2611, 0, 0),
(2612, 'TXTDAY', 1, 0, 2612, 0, 0),
(2613, 'TXTDAYS', 1, 0, 2613, 0, 0),
(2614, 'TXTHOUR', 1, 0, 2614, 0, 0),
(2615, 'TXTHOURS', 1, 0, 2615, 0, 0),
(2616, 'TXTUNDUEREPORT', 2, 0, 2616, 0, 7),
(2617, 'TXTSEARCHCLIENTS', 2, 0, 2617, 0, 0),
(2618, 'TXTTICKETCIRELATION', 2, 0, 2618, 0, 7),
(2619, 'TXTPROBLEMCIRELATION', 2, 1, 2619, 0, 7),
(2620, 'TXTCHANGESCIRELATION', 2, 1, 2620, 0, 7),
(2621, 'TXTTENANT', 2, 0, 2621, 0, 8),
(2622, 'TXTCLIENTBYORGANIZATION', 2, 0, 2622, 0, 7),
(2623, 'TXTFORMHEADER', 2, 0, 2623, 0, 8),
(2624, 'TXTTICKETSBYLABEL', 2, 0, 2624, 0, 7),
(2625, 'TXTSTAFFLEADERFIRSTRESPONSE', 2, 0, 2625, 0, 7),
(2626, 'TXTSTAFFLEADERAVGRESPONSE', 2, 0, 2626, 0, 7),
(2627, 'TXTSTAFFLEADERAVDSLA', 2, 0, 2627, 0, 7),
(2628, 'MSGFORMRQGR', 2, 0, 2628, 0, 8),
(2629, 'TXTTICKETACTIVITYBYDEPTREP', 2, 0, 2629, 0, 7),
(2630, 'TXTSEARCHDRIVE', 2, 0, 2630, 0, 2),
(2631, 'TXTUPLOAD', 2, 0, 2631, 0, 0),
(2632, 'TXTASSETGRPBYASSETSTATE', 2, 0, 2632, 0, 7),
(2633, 'TXTASSETBYMFGRPT', 2, 0, 2633, 0, 7),
(2634, 'TXTASSETBYASSETDEPT', 2, 0, 2634, 0, 7),
(2635, 'TXTASSETBASELINERPT', 2, 0, 2635, 0, 7),
(2636, 'TXTALLFILE', 2, 0, 2636, 0, 0),
(2637, 'TXTMYFILE', 2, 0, 2637, 0, 0),
(2638, 'TXTASSETCOSTREPORT', 2, 0, 2638, 0, 7),
(2639, 'MSGNEWTKTCRT', 1, 0, 2639, 0, 0),
(2640, 'TXTSTATUSCHANGE', 1, 0, 2640, 0, 0),
(2641, 'TXTPRIORITYCHANGE', 1, 0, 2641, 0, 0),
(2642, 'TXTSPACEERRORDOMAINLIST', 2, 0, 2642, 0, 3),
(2643, 'TXTERRORDOMAINLIST', 2, 0, 2643, 0, 3),
(2644, 'TXTHASHERRORDOMAINLIST', 2, 0, 2644, 0, 3),
(2645, 'TXTSPECIFIC', 2, 0, 2645, 0, 4),
(2646, 'TXTMANAGEROUNDROBINPARTICIPANT', 2, 0, 2646, 0, 8),
(2647, 'TXTMAXCONTACT', 1, 0, 2647, 0, 2),
(2648, 'TXTDOMAINLIST', 2, 0, 2648, 0, 3),
(2649, 'TXTCOMMENTDATE', 2, 0, 2649, 0, 7),
(2650, 'MSGBILLINVTIME', 2, 0, 2650, 0, 2),
(2651, 'MSGWORKINVTIME', 2, 0, 2651, 0, 2),
(2652, 'TXTDBHOST', 2, 0, 2652, 0, 8),
(2653, 'TXTDBUSER', 2, 0, 2653, 0, 8),
(2654, 'TXTDBPASSWORD', 2, 0, 2654, 0, 8),
(2655, 'TXTDBNAME', 2, 0, 2655, 0, 8),
(2656, 'TXTASTCONFIGURATION', 2, 0, 2656, 0, 7),
(2657, 'TXTASTDBCONFIGURATION', 2, 0, 2657, 0, 0),
(2658, 'TXTCONNECTTIMEOUT', 1, 0, 2658, 0, 0),
(2659, 'TXTREADTIMEOUT', 2, 0, 2659, 0, 7),
(2660, 'TXTXCALLDATE', 2, 0, 2660, 0, 0),
(2661, 'TXTMIGRATEDASSETRPT', 2, 0, 2661, 0, 7),
(2662, 'TXTASSETBYUNAUTHCHNG', 2, 0, 2662, 0, 7),
(2663, 'TXTSERVICEITEMWISE', 2, 0, 2663, 0, 7),
(2664, 'TXTDCONTEXT', 2, 0, 2664, 0, 0),
(2665, 'TXTIHVAGREDWT', 1, 0, 2665, 0, 0),
(2666, 'TXTLASTAPP', 2, 0, 2666, 0, 0),
(2667, 'TXTLASTDATA', 2, 0, 2667, 0, 0),
(2668, 'TXTBILLSEC', 2, 0, 2668, 0, 0),
(2669, 'TXTDISPOSITION', 2, 0, 2669, 0, 0),
(2670, 'TXTAMAFLAGS', 2, 0, 2670, 0, 0),
(2671, 'TXTACCOUNTCODE', 2, 0, 2671, 0, 0),
(2672, 'TXTPLZSNINTOLEAVECOMENT', 1, 0, 2672, 0, 0),
(2673, 'TXTUSERFIELD', 2, 0, 2673, 0, 0),
(2674, 'TXTRECORDINGFILE', 2, 0, 2674, 0, 0),
(2675, 'TXTREPLIESTOTHISPOST', 1, 0, 2675, 0, 0),
(2676, 'TXTSAYSOMETHING', 1, 0, 2676, 0, 0),
(2677, 'TXTOUTBOUNDCNUM', 2, 0, 2677, 0, 0),
(2678, 'TXTOUTBOUNDCNAM', 2, 0, 2678, 0, 0),
(2679, 'TXTSUBCAT', 1, 0, 2679, 0, 4),
(2680, 'TXTTYPURMSG', 1, 0, 2680, 0, 0),
(2681, 'TXTLINKEDID', 2, 0, 2681, 0, 0),
(2682, 'TXTRECORDINGPATH', 2, 0, 2682, 0, 8),
(2683, 'TXTASTDIALPLANS', 2, 0, 2683, 0, 7),
(2684, 'TXTADDDIALPLAN', 2, 0, 2684, 0, 8),
(2685, 'TXTASSETEXISTNOTADD', 2, 0, 2685, 0, 14),
(2686, 'TXTASYNC', 2, 0, 2686, 0, 0),
(2687, 'MSQREQ', 1, 0, 2687, 0, 0),
(2688, 'TXTCALLUS', 1, 0, 2688, 0, 0),
(2689, 'TXTTASKATTACHTOTICKET', 2, 0, 2689, 0, 7),
(2690, 'MSGURLEXIST', 2, 0, 2690, 0, 0),
(2691, 'TXTNONIT', 2, 0, 2691, 0, 0),
(2692, 'TXTNOTARCHIVNOTMODIFYTHEN', 2, 0, 2692, 0, 8),
(2693, 'TXTCIATTACHED', 2, 0, 2693, 0, 0),
(2694, 'TXTSIZE', 2, 0, 2694, 0, 0),
(2695, 'TXTDELSELFDRIVE', 2, 0, 2695, 0, 4),
(2696, 'TXTAUTHENTICATE', 2, 0, 2696, 0, 8),
(2697, 'TXTOF', 2, 0, 2697, 0, 0),
(2698, 'TXTOPERATIONIPRESTRICTED', 2, 0, 2698, 0, 0),
(2699, 'TXTOPERATIONSTAFFIPBAN', 2, 0, 2699, 0, 0),
(2700, 'TXTOTHERINFO', 2, 0, 2700, 0, 14),
(2701, 'TXTPARSERLOGDETAILS', 2, 0, 2701, 0, 8),
(2702, 'TXTTAXENABLED', 2, 0, 2702, 0, 8),
(2703, 'TXTCOMPOUNDTAX', 2, 0, 2703, 0, 8),
(2704, 'TXTTAXRULESETTING', 2, 0, 2704, 0, 8),
(2705, 'TXTROOM', 2, 0, 2705, 0, 1),
(2706, 'TXTNOTIFICATIONTO', 2, 0, 2706, 0, 1),
(2707, 'TXTCITYPE', 1, 0, 2707, 0, 0),
(2708, 'TXTCISELECT', 1, 0, 2708, 0, 0),
(2709, 'TXTMERGEINVOICE', 2, 0, 2709, 0, 2),
(2710, 'TXTMERGETIMETRACK', 2, 0, 2710, 0, 2),
(2711, 'TXTMERGENOTES', 2, 0, 2711, 0, 2),
(2712, 'TXTMERGECOMMENTS', 2, 0, 2712, 0, 2),
(2713, 'TXTMERGEOPTIONS', 2, 0, 2713, 0, 2),
(2714, 'TXTUPDATECICICUSTOMFIELD', 2, 0, 2714, 0, 8),
(2715, 'TXTRTOL', 2, 0, 2715, 0, 8),
(2716, 'TXTADDNEWCICUSTOMFIELD', 2, 0, 2716, 0, 8),
(2717, 'TXTAUTOLOCK', 2, 0, 2717, 0, 8),
(2718, 'MSGSTAFFTEAM', 2, 0, 2718, 0, 1),
(2719, 'TXTMERGEPOST', 2, 0, 2719, 0, 2),
(2720, 'TXTSTATUSCHANGEREPORT', 2, 0, 2720, 0, 7),
(2721, 'TXTCFRFSTCRPT', 2, 0, 2721, 0, 7),
(2722, 'TXTREQUIEREDCIFIELD', 2, 0, 2722, 0, 8),
(2723, 'TXTCSTRPTORGREG', 2, 0, 2723, 0, 7),
(2724, 'MSGINVALIDASSETNAME', 2, 0, 2724, 0, 14),
(2725, 'TXTIMPLEMENTED', 2, 0, 2725, 0, 12),
(2726, 'TXTDIFERRED', 2, 0, 2726, 0, 12),
(2727, 'TXTCONAME', 2, 0, 2727, 0, 0),
(2728, 'TXTSTREET', 2, 0, 2728, 0, 0),
(2729, 'TXTPOSTAL', 2, 0, 2729, 0, 0),
(2730, 'TXTSKYPENAME', 2, 0, 2730, 0, 0),
(2731, 'TXTNUMBER', 2, 0, 2731, 0, 0),
(2732, 'TXTREF', 2, 0, 2732, 0, 0),
(2733, 'TXTDIRECT', 2, 0, 2733, 0, 0),
(2734, 'TXTREGION', 2, 0, 2734, 0, 0),
(2735, 'TXTTKTCLOSEDUSER', 2, 0, 2735, 0, 7),
(2736, 'TXTTICKETFLAGTOUSRREP', 2, 0, 2736, 0, 7),
(2737, 'TXTSELFLAG', 2, 0, 2737, 0, 7),
(2738, 'TXTALLFLAG', 2, 0, 2738, 0, 7),
(2739, 'TXTORGANIZATIONADD', 2, 0, 2739, 0, 8),
(2740, 'TXTORGANIZATIONEDIT', 2, 0, 2740, 0, 8),
(2741, 'TXTORGANIZATIONDELETE', 2, 0, 2741, 0, 8),
(2742, 'TXTASSETS', 1, 0, 2742, 0, 0),
(2743, 'TXTNAME', 1, 0, 2743, 0, 0),
(2744, 'TXTIMPACT', 1, 0, 2744, 0, 0),
(2745, 'TXTASSIGNEDON', 1, 0, 2745, 0, 0),
(2746, 'TXTEXPIRED', 1, 0, 2746, 0, 0),
(2747, 'TXTUSEDBY', 1, 0, 2747, 0, 0),
(2748, 'TXTMANAGEDBY', 1, 0, 2748, 0, 0),
(2749, 'TXTITILSALVAGE', 1, 0, 2749, 0, 0),
(2750, 'TXTITILDEPRECIATIONTYPE', 1, 0, 2750, 0, 0),
(2751, 'TXTUSEFULLIFE', 1, 0, 2751, 0, 0),
(2752, 'TXTCIPRODUCT', 1, 0, 2752, 0, 0),
(2753, 'TXTMANUFACTURER', 1, 0, 2753, 0, 0),
(2754, 'TXTWARRANTYTEAR', 1, 0, 2754, 0, 0),
(2755, 'TXTWARRANTYMONTH', 1, 0, 2755, 0, 0),
(2756, 'TXTASSETSTAG', 1, 0, 2756, 0, 0),
(2757, 'TXTITILLASTAUDITDATE', 1, 0, 2757, 0, 0),
(2758, 'TXTITILINSTALLATIONPATH', 1, 0, 2758, 0, 0),
(2759, 'TXTITILLICENSEKEY', 1, 0, 2759, 0, 0),
(2760, 'TXTITILLICENSEEXPDATE', 1, 0, 2760, 0, 0),
(2761, 'TXTITILINSTALLATIONDATE', 1, 0, 2761, 0, 0),
(2762, 'TXTTASKAUTO', 2, 0, 2762, 0, 0),
(2763, 'TXTFETCHALLPOST', 2, 0, 2763, 0, 8),
(2764, 'TXTFIRSTPAGE', 2, 0, 2764, 0, 0),
(2765, 'TXTLASTPAGE', 2, 0, 2765, 0, 0),
(2766, 'TXTVIEWARTICLE', 2, 0, 2766, 0, 0),
(2767, 'TXTUSERLIKEADD', 2, 0, 2767, 0, 8),
(2768, 'TXTUSERLIKEUPDATE', 2, 0, 2768, 0, 8),
(2769, 'TXTVIEWCOMMENTS', 2, 0, 2769, 0, 8),
(2770, 'TXTMANAGECOMMENTS', 2, 0, 2770, 0, 8),
(2771, 'TXTMANAGEMACROS', 2, 0, 2771, 0, 8),
(2772, 'TXTMANAGESCHEDULETICKET', 2, 0, 2772, 0, 8),
(2773, 'TXTVIEWALERTS', 2, 0, 2773, 0, 2),
(2774, 'TXTMANAGEVIEWS', 2, 0, 2774, 0, 0),
(2775, 'TXTMODULEENABLED', 2, 0, 2775, 0, 8),
(2776, 'TXTSTARTTIMER', 2, 0, 2776, 0, 2),
(2777, 'TXTCONVERSATION', 1, 0, 2777, 0, 0),
(2778, 'TXTAPPROAVLREQUEST', 2, 0, 2778, 0, 0),
(2779, 'TXTMODIFYPROPERTIES', 2, 0, 2779, 0, 0),
(2780, 'TXTINTEGRATIONTITLE', 2, 0, 2780, 0, 8),
(2781, 'TXTTOTALREQUESTS', 2, 0, 2781, 0, 0),
(2782, 'TXTREQUESTSENTON', 2, 0, 2782, 0, 0),
(2783, 'TXTSTARTTIMECREATIONPLUSBELOWTIME', 2, 0, 2783, 0, 0),
(2784, 'TXTENDTIMESTARTPLUSBELOWTIME', 2, 0, 2784, 0, 0),
(2785, 'MSGHOURNUMERIC', 2, 0, 2785, 0, 8),
(2786, 'MSGDAYNUMERIC', 2, 0, 2786, 0, 8),
(2787, 'TXTCHANNELCHANGEDFROM', 1, 0, 2787, 0, 0),
(2788, 'MSGDUETIME', 2, 0, 2788, 0, 0),
(2789, 'MSGRECURSTASKTITLE', 2, 0, 2789, 0, 1),
(2790, 'MSGTASKUPDATED', 2, 0, 2790, 0, 1),
(2791, 'MSGTASKCREATED', 2, 0, 2791, 0, 1),
(2792, 'MSGSCHEDULEUPDATED', 2, 0, 2792, 0, 0),
(2793, 'MSGTASKUNSSINGEDFROM', 2, 0, 2793, 0, 1),
(2794, 'MSGTASKASSINGEDTO', 2, 0, 2794, 0, 1),
(2795, 'MSGADDTOFAV', 2, 0, 2795, 0, 0),
(2796, 'MSGREMOVEFROMFAV', 2, 0, 2796, 0, 2),
(2797, 'MSGTASKDESCUPDATED', 2, 0, 2797, 0, 1),
(2798, 'MSGNEWOCCCREATED', 2, 0, 2798, 0, 1),
(2799, 'MSGTASKCOMMENTADDED', 2, 0, 2799, 0, 1),
(2800, 'MSGOCCARANCEDELETED', 2, 0, 2800, 0, 1),
(2801, 'MSGSUBTASKDELETED', 2, 0, 2801, 0, 1),
(2802, 'MSGTASKDELETED', 2, 0, 2802, 0, 1),
(2803, 'MSGTASKDETACHED', 2, 0, 2803, 0, 0),
(2804, 'MSGTASKCUSTOMFIELDSUPDATED', 2, 0, 2804, 0, 0),
(2805, 'MSGCOMMENTDELETED', 2, 0, 2805, 0, 2),
(2806, 'TXTLESS', 1, 0, 2806, 0, 0),
(2807, 'TXTALLCATEGORIES', 2, 0, 2807, 0, 0),
(2808, 'TXTALLFORUMS', 2, 0, 2808, 0, 12),
(2809, 'TXTREMOVESTICKY', 2, 0, 2809, 0, 12),
(2810, 'TXTMARKASSTICKY', 2, 0, 2810, 0, 12),
(2811, 'TXTTRANSLATE', 2, 0, 2811, 0, 0),
(2812, 'TXTVIEWALLPOST', 2, 0, 2812, 0, 12),
(2813, 'TXTDELBILLINGRATE', 2, 0, 2813, 0, 8),
(2814, 'TXTBILLINGRATE', 2, 0, 2814, 0, 0),
(2815, 'TXTAPPLYBILLINGRATE', 2, 0, 2815, 0, 0),
(2816, 'TXTCUSTSATISFACTION', 2, 0, 2816, 0, 0),
(2817, 'MSGDEVICESBAN', 2, 0, 2817, 0, 0),
(2818, 'TXTADDCHANGE', 2, 0, 2818, 0, 10),
(2819, 'TXTSTAFFACTIVITY', 2, 0, 2819, 0, 1),
(2820, 'TXTSTAFFDEVICES', 2, 0, 2820, 0, 1),
(2821, 'TXTIMPORTTYPES', 2, 0, 2821, 0, 3),
(2822, 'TXTDESCRIPTIONEMPTY', 2, 0, 2822, 0, 0),
(2823, 'TXTSELECTSTAFFORTEAM', 2, 0, 2823, 0, 2),
(2824, 'EXCEEDLIMIT', 2, 0, 2824, 0, 0),
(2825, 'TXTSID', 2, 0, 2825, 0, 0),
(2826, 'TXTCLIENTPORTALDESIGN', 2, 0, 2826, 0, 8),
(2827, 'TXTFORUMTOPIC', 2, 0, 2827, 0, 0),
(2828, 'TXTFORUMPOST', 2, 0, 2828, 0, 0),
(2829, 'TXTSELFHELPLIST', 2, 0, 2829, 0, 0),
(2830, 'TXTFOOTER', 2, 0, 2830, 0, 0),
(2831, 'TXTCUSTOMCLIENTPORTALDSGN', 2, 0, 2831, 0, 8),
(2832, 'TXTPORTALDESIGN', 2, 0, 2832, 0, 8),
(2833, 'MSGRECORDMISS', 1, 0, 2833, 0, 0),
(2834, 'TXTTIMECREDIT', 1, 0, 2834, 0, 0),
(2835, 'TXTRECENTPOST', 1, 0, 2835, 0, 12),
(2836, 'TXTSTICKYPOST', 1, 0, 2836, 0, 12),
(2837, 'TXTOTHERCATEGORIES', 1, 0, 2837, 0, 12),
(2838, 'TXTLOCK', 1, 0, 2838, 0, 0),
(2839, 'TXTKEYWORDS', 1, 0, 2839, 0, 0),
(2840, 'TXTPLEASECHECKANYONE', 2, 0, 2840, 0, 0),
(2841, 'TXTVIACLIENTPORTAL', 1, 0, 2841, 0, 0),
(2842, 'MSGTKTMRGD', 2, 0, 2842, 0, 0),
(2843, 'TXTTICKETASSIGNE', 1, 0, 2843, 0, 0),
(2844, 'TXTCREDITSUMMARY', 1, 0, 2844, 0, 0),
(2845, 'TXTINSUFFICIENTCREDIT', 1, 0, 2845, 0, 0),
(2846, 'TXTTICKETCOUNT', 1, 0, 2846, 0, 0),
(2847, 'TXTADDBILLRATE', 2, 0, 2847, 0, 8),
(2848, 'TXTUPDATEBILLRATE', 2, 0, 2848, 0, 8),
(2849, 'TXTTIME', 1, 0, 2849, 0, 0),
(2850, 'TXTPAYMENTFORINVOICE', 1, 0, 2850, 0, 5),
(2851, 'TXTSTARTDATELESSTHANENDDATE', 2, 0, 2851, 0, 10),
(2852, 'TXTCAPTCHANOTVERIFY', 1, 0, 2852, 0, 0),
(2853, 'TXTREASSIGNEDDATE', 2, 1, 2853, 0, 7),
(2854, 'TXTREADYFORDEPLOY', 2, 1, 2854, 0, 10),
(2855, 'TXTYOUHAVE', 2, 0, 2855, 0, 0),
(2856, 'TXTSTARTTIME', 2, 0, 2856, 0, 0),
(2857, 'TXTENDTIME', 2, 0, 2857, 0, 0),
(2858, 'TXTSUBCLIENTS', 2, 0, 2858, 0, 3),
(2859, 'MSGTICKETITEMCHANGED', 2, 0, 2859, 0, 0),
(2860, 'TXTVALIDITYONETIME', 1, 0, 2860, 0, 0),
(2861, 'TXTVALIDITYMONTHLY', 1, 0, 2861, 0, 0),
(2862, 'TXTVALIDITYQUARTERLY', 1, 0, 2862, 0, 0),
(2863, 'TXTVALIDITYSEMIANNUALLY', 1, 0, 2863, 0, 0),
(2864, 'TXTVALIDITYANNUALLY', 1, 0, 2864, 0, 0),
(2865, 'TXTUPDATECONTRACT', 2, 0, 2865, 0, 14),
(2866, 'MSGCONTNONUM', 2, 0, 2866, 0, 0),
(2867, 'TXTCONVERSATIONS', 2, 0, 2867, 0, 0),
(2868, 'MSGPOSTMESSAGENOTFOUND', 2, 0, 2868, 0, 2),
(2869, 'MSGREQRECPT', 2, 0, 2869, 0, 2),
(2870, 'MSGREQUIREDAY', 2, 0, 2870, 0, 2),
(2871, 'MSGGREATERTHAN', 1, 0, 2871, 0, 0),
(2872, 'TXTHALFDAY', 2, 0, 2872, 0, 8),
(2873, 'TXTCHANGED', 2, 0, 2873, 0, 0),
(2874, 'TXTRESTRTIME', 2, 0, 2874, 0, 8),
(2875, 'TXTWORKINGHOURS', 2, 0, 2875, 0, 8),
(2876, 'TXTURGENCY', 1, 0, 2876, 0, 0),
(2877, 'TXTCHLD', 2, 0, 2877, 0, 10),
(2878, 'MSGSALVAGENUMERIC', 2, 0, 2878, 0, 14),
(2879, 'TXTSELECTCLONE', 2, 0, 2879, 0, 14),
(2880, 'TXTDISPLAYCLOSUREREASON', 2, 0, 2880, 0, 0),
(2881, 'TXTCLOSUREREASON', 2, 0, 2881, 0, 0),
(2882, 'TXTCHANGEURGENCY', 2, 0, 2882, 0, 0),
(2883, 'TXTCHANGEIMPACT', 2, 0, 2883, 0, 0),
(2884, 'TXTCAB', 2, 1, 2884, 0, 0),
(2885, 'TXTMULTIPLE', 1, 0, 2885, 0, 0),
(2886, 'TXTISALRPIN', 2, 1, 2886, 0, 2),
(2887, 'TXTJUSTPRIORITYCHNG', 2, 1, 2887, 0, 0),
(2888, 'TXTDISJUSTPRIORITYCHNG', 2, 1, 2888, 0, 0),
(2889, 'TXTADDED', 2, 0, 2889, 0, 0),
(2890, 'TXTPROPOSEDPLAN', 2, 1, 2890, 0, 0),
(2891, 'TXTBUSINESSJUSTIFICATION', 2, 0, 2891, 0, 0),
(2892, 'TXTMODULEPROPERTIES', 2, 0, 2892, 0, 0),
(2893, 'TXTSAVESOLUTION', 2, 0, 2893, 0, 0),
(2894, 'TXTREVIEWCHANGEREQ', 2, 1, 2894, 0, 0),
(2895, 'TXTREQVALID', 2, 1, 2895, 0, 10),
(2896, 'TXTCHNGDESCLEAR', 2, 1, 2896, 0, 10),
(2897, 'TXTCHNGREVIEW', 2, 1, 2897, 0, 0),
(2898, 'TXTCHNGFURDETIALS', 2, 1, 2898, 0, 10),
(2899, 'TXTHIGHPLAN', 2, 1, 2899, 0, 0),
(2900, 'TXTTECHPLAN', 2, 1, 2900, 0, 0),
(2901, 'TXTRESOURCEPLAN', 2, 1, 2901, 0, 0),
(2902, 'TXTSYSUSEPHPMAILFORADDSMTP', 2, 0, 2902, 0, 8),
(2903, 'TXTCOMMPLAN', 2, 1, 2903, 0, 0),
(2904, 'TXTACCPLAN', 2, 1, 2904, 0, 0),
(2905, 'TXTMONITORPLAN', 2, 1, 2905, 0, 0),
(2906, 'TXTUPDATED', 1, 0, 2906, 0, 0),
(2907, 'MSGDELETEASSET', 2, 0, 2907, 0, 14),
(2908, 'MSGINVALID', 1, 0, 2908, 0, 0),
(2909, 'TXTREQUESTER', 2, 1, 2909, 0, 0),
(2910, 'TXTIMPLEMENTER', 2, 1, 2910, 0, 0),
(2911, 'TXTTESTER', 2, 1, 2911, 0, 0),
(2912, 'TXTAPPROVER', 2, 0, 2912, 0, 0),
(2913, 'TXTRECORDMEETAUTOONLOCALCOM', 2, 1, 2913, 0, 10),
(2914, 'TXTSUPERVISOR', 2, 1, 2914, 0, 0),
(2915, 'TXTCOORDINATOR', 2, 1, 2915, 0, 0),
(2916, 'TXTCHANGECLOSED', 2, 1, 2916, 0, 10),
(2917, 'MSGCLOSELINKS', 2, 1, 2917, 0, 10),
(2918, 'TXTTAM', 2, 1, 2918, 0, 0),
(2919, 'TXTREVIEWFORRISKAVOIDANCE', 2, 1, 2919, 0, 0),
(2920, 'TXTENSURERISK', 2, 1, 2920, 0, 0),
(2921, 'TXTREVIEWTECHNICALAPPROVAL', 2, 1, 2921, 0, 0),
(2922, 'TXTTECHNICALINFORMATION', 2, 1, 2922, 0, 0),
(2923, 'TXTREVIEWANDREJECT', 2, 1, 2923, 0, 0),
(2924, 'TXTCHANGEBUILDTEST', 2, 1, 2924, 0, 0),
(2925, 'TXTCOORDINATEBUILD', 2, 1, 2925, 0, 0),
(2926, 'TXTPERFORMBUILDACTIVITY', 2, 1, 2926, 0, 0),
(2927, 'TXTCOORDINATETESTING', 2, 1, 2927, 0, 0),
(2928, 'TXTEXECUTETESTACTIVITY', 2, 1, 2928, 0, 0),
(2929, 'TXTREVIEWRESOLVEDEFECTS', 2, 1, 2929, 0, 0),
(2930, 'TXTUPDATESUPPDOC', 2, 1, 2930, 0, 0),
(2931, 'TXTSIGNOFFBUILD', 2, 1, 2931, 0, 0),
(2932, 'TXTCANCELCHANGERECORD', 2, 1, 2932, 0, 0),
(2933, 'TXTEMERGENCY', 2, 0, 2933, 0, 0),
(2934, 'TXTPLANS', 2, 0, 2934, 0, 0),
(2935, 'TXTIMPLEMENTATIONAPPROVAL', 2, 1, 2935, 0, 0),
(2936, 'TXTIMPLEMENTCHANGE', 2, 1, 2936, 0, 0),
(2937, 'TXTMONITORCHANGE', 2, 1, 2937, 0, 0),
(2938, 'TXTCURRENTSTEP', 2, 1, 2938, 0, 0),
(2939, 'TXTTOTDATACNTARCHIVED', 2, 0, 2939, 0, 8),
(2940, 'TXTCREATOR', 2, 1, 2940, 0, 0),
(2941, 'TXTCHANGEASSESSED', 2, 1, 2941, 0, 0),
(2942, 'TXTREVIEWAPPROVAL', 2, 1, 2942, 0, 0),
(2943, 'TXTSUPPMEMBER', 2, 1, 2943, 0, 0),
(2944, 'TXTPARTCIPATES', 2, 1, 2944, 0, 0),
(2945, 'TXTCHANGESCHEDULE', 2, 1, 2945, 0, 0),
(2946, 'TXTCABACTIVITY', 2, 1, 2946, 0, 0),
(2947, 'TXTCOORDIMPLEMENTCHANGE', 2, 1, 2947, 0, 0),
(2948, 'TXTEXEPOSTIMPL', 2, 1, 2948, 0, 0),
(2949, 'TXTIMPLESTATUS', 2, 1, 2949, 0, 0),
(2950, 'TXTEXEBACKOUT', 2, 1, 2950, 0, 0),
(2951, 'TXTTRIGGERCONFIG', 2, 1, 2951, 0, 0),
(2952, 'TXTTRIGGERIMPLE', 2, 1, 2952, 0, 0),
(2953, 'TXTEVALCHANGE', 2, 1, 2953, 0, 0),
(2954, 'TXTCHANGERESULT', 2, 1, 2954, 0, 0),
(2955, 'TXTFURTHERDETAIL', 2, 1, 2955, 0, 0),
(2956, 'TXTBUSINESSIMAPCT', 2, 1, 2956, 0, 10),
(2957, 'TXTCLOSEALLRELATIONS', 2, 1, 2957, 0, 10),
(2958, 'TXTCLOSELINKED', 2, 1, 2958, 0, 10),
(2959, 'TXTIMPACTDETAILS', 2, 0, 2959, 0, 0),
(2960, 'TXTDTSIMPACTCHNG', 2, 0, 2960, 0, 0),
(2961, 'TXTISCAB', 2, 1, 2961, 0, 0),
(2962, 'TXTECLIENTEMAILVARIFICATION', 2, 0, 2962, 0, 8),
(2963, 'TXTCLOSINGTIME', 2, 0, 2963, 0, 0),
(2964, 'TXTISALRFAVORITE', 2, 0, 2964, 0, 2),
(2965, 'TXTFAVORITE', 2, 0, 2965, 0, 0),
(2966, 'TXTADDTOAVORITE', 2, 0, 2966, 0, 3),
(2967, 'TXTREMOVEFAVORITE', 2, 0, 2967, 0, 2),
(2968, 'MSGTASKENDDATE', 2, 0, 2968, 0, 1),
(2969, 'TXTINSTRUCTIONS', 2, 0, 2969, 0, 0),
(2970, 'TXTIDENTIFY', 2, 0, 2970, 0, 0),
(2971, 'TXTIDENTIFICATIONNOTE', 2, 0, 2971, 0, 0),
(2972, 'TXTRESOURCE', 2, 0, 2972, 0, 0),
(2973, 'TXTMANAGEBY', 2, 0, 2973, 0, 0),
(2974, 'TXTMANAGEMENT', 2, 0, 2974, 0, 0),
(2975, 'TXTINTERNALMANPOWER', 2, 0, 2975, 0, 0),
(2976, 'TXTTOTALCOSTS', 2, 0, 2976, 0, 0),
(2977, 'TXTINSTALLATIONCOSTS', 2, 0, 2977, 0, 0),
(2978, 'TXTTRAININGCOSTS', 2, 0, 2978, 0, 0),
(2979, 'TXTMAINTAINANCECOSTS', 2, 0, 2979, 0, 0),
(2980, 'TXTPROPOSEDDATE', 2, 0, 2980, 0, 10),
(2981, 'TXTDELIVEREDBY', 2, 0, 2981, 0, 0),
(2982, 'TXTPRODELIVERYDATE', 2, 0, 2982, 0, 0),
(2983, 'TXTRISKASSESSMENT', 2, 1, 2983, 0, 0),
(2984, 'TXTEXPDOWNTIMESTART', 2, 0, 2984, 0, 0),
(2985, 'TXTEXPDOWNTIMEEND', 2, 0, 2985, 0, 0),
(2986, 'TXTDOWNTIMEHOURS', 2, 0, 2986, 0, 0),
(2987, 'TXTREMARK', 2, 0, 2987, 0, 0),
(2988, 'TXTAPPROVEDBY', 2, 0, 2988, 0, 0),
(2989, 'TXTIDENTIFYANAYSIS', 2, 1, 2989, 0, 0),
(2990, 'TXTDELIVERYMNGR', 2, 1, 2990, 0, 0),
(2991, 'TXTTASKDATE', 2, 0, 2991, 0, 0),
(2992, 'TXTTIMELINE', 2, 1, 2992, 0, 0),
(2993, 'TXTCHANGESTEPDOWNGRADE', 2, 1, 2993, 0, 0),
(2994, 'TXTCHNAGEBYSTATUS', 2, 1, 2994, 0, 7),
(2995, 'TXTCHNAGEBYPRIORITY', 2, 1, 2995, 0, 7),
(2996, 'TXTCHNAGEBYIMPACT', 2, 1, 2996, 0, 7),
(2997, 'TXTRELEASEMNGR', 2, 1, 2997, 0, 0),
(2998, 'TXTNEWRELATTACHED', 2, 1, 2998, 0, 0),
(2999, 'TXTDETTACHATTACHREL', 2, 1, 2999, 0, 0),
(3000, 'TXTITILNOTEADD', 2, 0, 3000, 0, 0),
(3001, 'TXTITILNOTEDELETED', 2, 0, 3001, 0, 0),
(3002, 'TXTNOTCLOSED', 2, 0, 3002, 0, 2),
(3003, 'TXTNOTRESPONDED', 2, 0, 3003, 0, 0),
(3004, 'TXTKNOWNERROR', 2, 1, 3004, 0, 0),
(3005, 'TXTPRODUCTION', 2, 1, 3005, 0, 0),
(3006, 'TXTDEVELOPMENT', 2, 1, 3006, 0, 0),
(3007, 'TXTDEPTINVOICERPT', 2, 0, 3007, 0, 7),
(3008, 'TXTDOMAININVOICERPT', 2, 0, 3008, 0, 7),
(3009, 'TXTSCHEDULEPOSTIMP', 2, 1, 3009, 0, 10),
(3010, 'TXTTESTDATE', 2, 1, 3010, 0, 0),
(3011, 'TXTBUILDDATE', 2, 1, 3011, 0, 0),
(3012, 'TXTIMPLDATE', 2, 1, 3012, 0, 0),
(3013, 'TXTISCLONEOF', 2, 0, 3013, 0, 2),
(3014, 'TXTITIMETRACK', 2, 0, 3014, 0, 2),
(3015, 'TXTMODIFIED', 2, 0, 3015, 0, 0),
(3016, 'TXTCHANGEPLANDATE', 2, 1, 3016, 0, 10),
(3017, 'TXTPSO', 2, 1, 3017, 0, 0),
(3018, 'TXTARCHIVE', 2, 0, 3018, 0, 0),
(3019, 'TXTREFERENCE', 2, 0, 3019, 0, 7),
(3020, 'TXTREQMEETPASSWORD', 2, 0, 3020, 0, 0),
(3021, 'TXTTOTALPENDING', 2, 0, 3021, 0, 7),
(3022, 'TXTLEAVEAMSG', 1, 0, 3022, 0, 0),
(3023, 'TXTSCANASSET', 2, 0, 3023, 0, 14),
(3024, 'TXTSCANSTARTSOONATREMOTDEV', 2, 0, 3024, 0, 14),
(3025, 'TXTSEARCHACTIVITY', 2, 0, 3025, 0, 7),
(3026, 'TXTPACKAGES', 2, 0, 3026, 0, 0),
(3027, 'TXTSENDREGKEY', 2, 0, 3027, 0, 8),
(3028, 'TXTSELCTPROJECT', 2, 0, 3028, 0, 8),
(3029, 'TXTREVIEW', 2, 0, 3029, 0, 0),
(3030, 'TXTPROBTICKETTREND', 2, 1, 3030, 0, 7),
(3031, 'TXTCHNGTICKETTREND', 2, 1, 3031, 0, 7),
(3032, 'TXTRELTICKETTREND', 2, 1, 3032, 0, 7),
(3033, 'TXTMODEOFCONTACT', 1, 0, 3033, 0, 0),
(3034, 'TXTWEBPORTAL', 1, 0, 3034, 0, 2),
(3035, 'TXTPROBTICKETREL', 2, 1, 3035, 0, 7),
(3036, 'TXTROOTCAUSEUPDATED', 2, 1, 3036, 0, 10),
(3037, 'TXTSYMPTOMSUPD', 2, 1, 3037, 0, 10),
(3038, 'TXTREASONCHANGEUPD', 2, 1, 3038, 0, 10),
(3039, 'TXTROLLOUTPLANUPD', 2, 1, 3039, 0, 10),
(3040, 'TXTBACKOUTPLANUPD', 2, 1, 3040, 0, 10),
(3041, 'TXTBUILDPLANUPD', 2, 1, 3041, 0, 10),
(3042, 'TXTTESTPLANUPD', 2, 1, 3042, 0, 10),
(3043, 'TXTPROBLEMOVERDUE', 2, 1, 3043, 0, 10),
(3044, 'TXTCHANGESOVERDUE', 2, 1, 3044, 0, 10),
(3045, 'TXTRELEASEOVERDUE', 2, 1, 3045, 0, 0),
(3046, 'TXTKNOWNERRORUPDATED', 2, 1, 3046, 0, 10),
(3047, 'TXTCHANGETYPEUPD', 2, 1, 3047, 0, 10),
(3048, 'TXTRELEASETYPEUPD', 2, 1, 3048, 0, 10),
(3049, 'TXTIMPACTPRIORIYUPDTED', 2, 0, 3049, 0, 2),
(3050, 'TXTPROBLEMASSIGNED', 2, 1, 3050, 0, 10),
(3051, 'TXTRELEASEASSIGNED', 2, 1, 3051, 0, 0),
(3052, 'TXTCHANESASSIGNED', 2, 1, 3052, 0, 10),
(3053, 'TXTPERMANENTSOLLINKED', 2, 1, 3053, 0, 10),
(3054, 'TXTWORKARROUNDSOLLINKED', 2, 1, 3054, 0, 10),
(3055, 'TXTREMINDER', 2, 0, 3055, 0, 0),
(3056, 'TXTSESSION', 2, 0, 3056, 0, 0),
(3057, 'TXTLISTVIEW', 1, 0, 3057, 0, 0),
(3058, 'TXTNEWLYREGISTER', 2, 0, 3058, 0, 0),
(3059, 'TXTREPLIES', 2, 0, 3059, 0, 0),
(3060, 'TXTSTARTED', 2, 0, 3060, 0, 0),
(3061, 'TXTNEXTSEVENDAYS', 2, 0, 3061, 0, 0),
(3062, 'TXTKIB', 2, 0, 3062, 0, 0),
(3063, 'TXTDRIVE', 2, 0, 3063, 0, 0),
(3064, 'TXTINSERT', 2, 0, 3064, 0, 0),
(3065, 'TXTUSECSVORG', 2, 0, 3065, 0, 3),
(3066, 'TXTCLMMAPPING', 2, 0, 3066, 0, 0),
(3067, 'TXTFEATURED', 2, 0, 3067, 0, 0),
(3068, 'TXTVIEWALLSECTIONS', 1, 0, 3068, 0, 0),
(3069, 'TXTGRIDVIEW', 1, 0, 3069, 0, 0),
(3070, 'TXTWEEKS', 1, 0, 3070, 0, 8),
(3071, 'TXTDATAARCHIVE', 2, 0, 3071, 0, 0),
(3072, 'TXTARCHIVEDATABEFORE', 2, 0, 3072, 0, 8),
(3073, 'TXTARCHIVEDATAFROM', 2, 0, 3073, 0, 8),
(3074, 'TXTDEFAULTSMTP', 2, 0, 3074, 0, 0),
(3075, 'TXTTRUSTEDDOMAIN', 2, 0, 3075, 0, 8),
(3076, 'TXTDEFAULTSMTPMAIL', 2, 0, 3076, 0, 8),
(3077, 'TXTDROPBOX', 2, 0, 3077, 0, 0),
(3078, 'TXTYELLOW', 2, 0, 3078, 0, 0),
(3079, 'TXTGREEN', 2, 0, 3079, 0, 0),
(3080, 'TXTRED', 2, 0, 3080, 0, 0),
(3081, 'TXTBLUE', 2, 0, 3081, 0, 0),
(3082, 'TXTSERVREQRESOLVEREPORT', 2, 0, 3082, 0, 7),
(3083, 'TXTENTERPPURL', 2, 0, 3083, 0, 8),
(3084, 'TXTENTERVPPURL', 2, 0, 3084, 0, 8),
(3085, 'TXTPRIVACYPOLICY', 1, 0, 3085, 0, 0),
(3086, 'TXTCHECKPP', 1, 0, 3086, 0, 0),
(3087, 'TXTMYASSETS', 1, 0, 3087, 0, 0),
(3088, 'MSGNEWBLAB', 2, 0, 3088, 0, 1),
(3089, 'TXTCONFIGURATIONMNGR', 2, 1, 3089, 0, 8),
(3090, 'TXTKNOWLEDGEMNGR', 2, 1, 3090, 0, 8),
(3091, 'TXTPROJECTMNGR', 2, 1, 3091, 0, 8),
(3092, 'TXTTOTALRESOLVED', 2, 0, 3092, 0, 7),
(3093, 'TXTTESTMNGR', 2, 1, 3093, 0, 10),
(3094, 'TXTONCE', 2, 0, 3094, 0, 10),
(3095, 'TXTDAILY', 2, 0, 3095, 0, 0),
(3096, 'TXTWEEKLY', 2, 0, 3096, 0, 0),
(3097, 'TXTMANUALINVC', 2, 0, 3097, 0, 5),
(3098, 'TXTRADIOBUTTON', 2, 0, 3098, 0, 8),
(3099, 'TXTSELECTBOX', 2, 0, 3099, 0, 8),
(3100, 'TXTWIDTH', 2, 0, 3100, 0, 14),
(3101, 'TXTYEARS', 2, 0, 3101, 0, 14),
(3102, 'TXTNOPERMISIONTOPAGE', 2, 0, 3102, 0, 0),
(3103, 'TXTTYPESEARCHASSETNAME', 2, 0, 3103, 0, 0),
(3104, 'TXTSERVICESTICKETHASHGENERATION', 2, 0, 3104, 0, 8),
(3105, 'TXTASSETAUDITON', 2, 0, 3105, 0, 14),
(3106, 'MSGALREADYEXIST', 2, 0, 3106, 0, 0),
(3107, 'TXTSOLVEDWELL', 2, 1, 3107, 0, 0),
(3108, 'TXTDIDNTSOLVEDWELL', 2, 1, 3108, 0, 0),
(3109, 'TXTCANDOBETTERNEXT', 2, 1, 3109, 0, 0),
(3110, 'TXTFAILUREPREFVENTION', 2, 1, 3110, 0, 0),
(3111, 'TXTSUPPIERINVOLVE', 2, 1, 3111, 0, 0),
(3112, 'MSGASSETNOTAVAILABLE', 2, 0, 3112, 0, 0),
(3113, 'MSGAUTHSUCCESS', 2, 0, 3113, 0, 0),
(3114, 'MSGAUTHTOSERVERFAILED', 2, 0, 3114, 0, 0),
(3115, 'TXTBY', 2, 0, 3115, 0, 0),
(3116, 'MSGCHANGEDIPADDRRESTRICT', 2, 0, 3116, 0, 0),
(3117, 'MSGCLIENTVERIFIED', 2, 0, 3117, 0, 0),
(3118, 'MSGCONNECTEDTOSERVER', 2, 0, 3118, 0, 0),
(3119, 'MSGCONNECTEDSERVERFAILED', 2, 0, 3119, 0, 0),
(3120, 'MSGCONTRACTAPPROVEBY', 2, 0, 3120, 0, 0),
(3121, 'MSGCONTRACTAUTORENEWSTATUS', 2, 0, 3121, 0, 0),
(3122, 'MSGCONTRACTSTATUSCHANGED', 2, 0, 3122, 0, 0),
(3123, 'MSGCONTRACTUPDATED', 2, 0, 3123, 0, 0),
(3124, 'MSGCOSTCHANGEDFROM', 2, 0, 3124, 0, 0),
(3125, 'TXTCUSTOMFILTER', 2, 0, 3125, 0, 0),
(3126, 'MSGFILEREMOVEDSUCCESS', 2, 0, 3126, 0, 0),
(3127, 'MSGFORWARDED', 2, 0, 3127, 0, 0),
(3128, 'MSGINVALIDCLIENTIDORDOMAIN', 2, 0, 3128, 0, 0),
(3129, 'MSGLEVELCHANGEDFROM', 2, 0, 3129, 0, 0),
(3130, 'MSGLICENSECNTCHANGED', 2, 0, 3130, 0, 0),
(3131, 'TXTMERGEDTO', 2, 0, 3131, 0, 0),
(3132, 'MSGMOVEDTOINBOX', 2, 0, 3132, 0, 2),
(3133, 'MSGMOVEDTOTRASH', 2, 0, 3133, 0, 2),
(3134, 'MSGNOTAPPLICABLE', 2, 0, 3134, 0, 0),
(3135, 'MSGNOTRESOLVED', 2, 0, 3135, 0, 0),
(3136, 'MSGCANNOTATTACHMORE', 2, 0, 3136, 0, 0),
(3137, 'MSGUPLOADVALIDFILE', 2, 0, 3137, 0, 3),
(3138, 'MSGPOSTSPLITWITH', 2, 0, 3138, 0, 2),
(3139, 'MSGSELECTDAYTOSCHEDULE', 2, 0, 3139, 0, 0),
(3140, 'MSGUCANATTACHMAX', 2, 0, 3140, 0, 0),
(3141, 'MSGTOTALCOSTCHANGEDFROM', 2, 0, 3141, 0, 0),
(3142, 'TXTCONTRACTSHASHGENERATION', 2, 0, 3142, 0, 14),
(3143, 'TXTRECEPIENTFROM', 1, 0, 3143, 0, 0),
(3144, 'TXTRECEPIENTTO', 1, 0, 3144, 0, 0),
(3145, 'TXTCALENDARLIST', 2, 0, 3145, 0, 1),
(3146, 'TXTVIRTUALAGENT', 2, 0, 3146, 0, 0),
(3147, 'TXTTOPICFLOW', 2, 0, 3147, 0, 15),
(3148, 'TXTAPPENDCHAT', 1, 0, 3148, 0, 15),
(3149, 'TXTENDCONVERSATION', 1, 0, 3149, 0, 15),
(3150, 'TXTADDSTEP', 2, 0, 3150, 0, 15),
(3151, 'TXTSIMPLE', 2, 0, 3151, 0, 15),
(3152, 'TXTCONDITIONAL', 2, 0, 3152, 0, 15),
(3153, 'TXTGOTOSTEP', 2, 0, 3153, 0, 15),
(3154, 'TXTSTEP', 2, 0, 3154, 0, 15),
(3155, 'MSGCANNOTDELSTEPOPT', 2, 0, 3155, 0, 15),
(3156, 'MSGCONVERSATIONWITHVA', 1, 0, 3156, 0, 15),
(3157, 'TXTVIRTUALAGENTS', 2, 0, 3157, 0, 15),
(3158, 'TXTTOPICS', 2, 0, 3158, 0, 15),
(3159, 'MSGATELASTONEAGENT', 2, 0, 3159, 0, 15),
(3160, 'MSGSELECTCSV', 2, 0, 3160, 0, 8),
(3161, 'TXTSTARTUPTEXT', 2, 0, 3161, 0, 15),
(3162, 'TXTTICKETCREATION', 2, 0, 3162, 0, 15),
(3163, 'TXTSERVICEREQHASH', 2, 0, 3163, 0, 7),
(3164, 'TXTCLOSINGMESSAGE', 2, 0, 3164, 0, 15),
(3165, 'TXTNOTFOUNDTEXT', 2, 0, 3165, 0, 15),
(3166, 'TXTAGENTNAME', 2, 0, 3166, 0, 0),
(3167, 'TXTAGENTAVATAR', 2, 0, 3167, 0, 15),
(3168, 'TXTPOSITION', 2, 0, 3168, 0, 0),
(3169, 'TXTVIRTUALCODE', 2, 0, 3169, 0, 15),
(3170, 'TXTGRAPHICALREPORTS', 2, 0, 3170, 0, 7),
(3171, 'TXTCUSTOMIZECUSTREPORT', 2, 0, 3171, 0, 7),
(3172, 'TXTONCONTRACTAUTORENEW', 2, 0, 3172, 0, 8),
(3173, 'TXTRESTOREDFROMARCHIVE', 2, 0, 3173, 0, 14),
(3174, 'TXTORGOVERVIEW', 2, 0, 3174, 0, 7),
(3175, 'MSGCONTRACTAUTORENEWED', 2, 0, 3175, 0, 0),
(3176, 'MSGINCIDENTPREFIXEXIST', 2, 0, 3176, 0, 8),
(3177, 'MSGSERVICEPREFIXEXIST', 2, 0, 3177, 0, 8),
(3178, 'MSGCONTRACTNEWADDED', 2, 0, 3178, 0, 0),
(3179, 'MSGAPPLYTIMECREDIT', 2, 0, 3179, 0, 0),
(3180, 'TXTACTIVITYSERVICEREQRPT', 2, 0, 3180, 0, 7),
(3181, 'TXTDEPTBYACTIVITYSERVICEREQRPT', 2, 0, 3181, 0, 7),
(3182, 'TXTSERVICEREQUESTSTAFFAVGRESOLUTIONTIME', 2, 0, 3182, 0, 7),
(3183, 'TXTSTAFFLEADERAVGRESOLUTION', 2, 0, 3183, 0, 7),
(3184, 'TXTNOTANSSERREQ', 2, 1, 3184, 0, 7),
(3185, 'TXTINCIDENTURGENCYBYREPORT', 2, 0, 3185, 0, 7),
(3186, 'TXTRPTRURGENCYTITLE', 2, 0, 3186, 0, 7),
(3187, 'TXTCSTFLDSRVCRQRPT', 2, 0, 3187, 0, 7),
(3188, 'TXTCFRFSTSRCRQCRPT', 2, 0, 3188, 0, 7),
(3189, 'TXTSTAFFAVGRESOLUTIONTIME', 2, 0, 3189, 0, 7),
(3190, 'TXTINCIDENTFLAGBYREPORT', 2, 0, 3190, 0, 7),
(3191, 'TXTINCIDENTLABELBYREPORT', 2, 0, 3191, 0, 7),
(3192, 'TXTINCIDENTSUBCATEGORYBYREPORT', 2, 0, 3192, 0, 7),
(3193, 'TXTINCIDENTITEMBYREPORT', 2, 0, 3193, 0, 7),
(3194, 'TXTINCIDENTIMPACTBYREPORT', 2, 0, 3194, 0, 7),
(3195, 'TXTINCIDENTCHANNELBYREPORT', 2, 0, 3195, 0, 7),
(3196, 'TXTINCIDENTLOCATIONBYREPORT', 2, 0, 3196, 0, 7),
(3197, 'TXTITILREQUESTSERVICEDELETED', 2, 0, 3197, 0, 7),
(3198, 'TXTTOTALAVGRESOLUTIONTIME', 2, 0, 3198, 0, 7),
(3199, 'TXTSERVICEREQUESTAVERGERESOLUTIONTIME', 2, 0, 3199, 0, 0),
(3200, 'TXTTOTCLSRESSERREQT', 2, 0, 3200, 0, 7),
(3201, 'MSGSERASSIG', 2, 0, 3201, 0, 0),
(3202, 'MSGSERTRSH', 2, 0, 3202, 0, 0),
(3203, 'TXTSERMOVEINBOCFROMTRASH', 2, 0, 3203, 0, 0),
(3204, 'MSGSERDELETED', 2, 0, 3204, 0, 0),
(3205, 'TXTSERVICEPOSTSPLITWITH', 2, 0, 3205, 0, 0),
(3206, 'MSGSERVICEPROPERTYUPDATED', 2, 0, 3206, 0, 0),
(3207, 'MSGSERVICENOTEADDED', 2, 0, 3207, 0, 0),
(3208, 'MSGSERVICENOTEDELETED', 2, 0, 3208, 0, 0),
(3209, 'MSGSERVICECOMMENTADDED', 2, 0, 3209, 0, 0),
(3210, 'MSGSERVICECOMMENTDELETED', 2, 0, 3210, 0, 0),
(3211, 'MSGSERVICECPOSTUPDATED', 2, 0, 3211, 0, 0),
(3212, 'MSGNEWSCHEDULESERCRT', 2, 0, 3212, 0, 0),
(3213, 'MSGSERVICELEVELCHANGED', 2, 0, 3213, 0, 0),
(3214, 'TXTREADSERVICEFORSTAFF', 2, 0, 3214, 0, 0),
(3215, 'TXTSENDSERVICEAPPROVAL', 2, 0, 3215, 0, 0),
(3216, 'TXTSENDSERVICEAPPROVALREMINDER', 2, 0, 3216, 0, 0),
(3217, 'MSGCUSTOMESERFIELDDATAMODIFIED', 2, 0, 3217, 0, 0),
(3218, 'TXTTOTALSERVICEREQREPLIED', 2, 0, 3218, 0, 7),
(3219, 'TXTTOTALSERVICEREQRESOLVED', 2, 0, 3219, 0, 7),
(3220, 'MSGSTRUCTURENOTMATCH', 2, 0, 3220, 0, 8),
(3221, 'TXTTOTCLSRESINCIDENT', 2, 0, 3221, 0, 7),
(3222, 'TXTCHANGESERVICEAPPROVALSTATUS', 2, 0, 3222, 0, 0),
(3223, 'MSGSRVFRWD', 2, 0, 3223, 0, 0),
(3224, 'TOTALCLOSEDRESOLVEDTICKET', 2, 0, 3224, 0, 7),
(3225, 'TOTALAVGRESOLUTION', 2, 0, 3225, 0, 7),
(3226, 'TXTVISITORDETAILS', 2, 0, 3226, 0, 16),
(3227, 'TXTSTAFFFILEATTACHMENT', 2, 0, 3227, 0, 8),
(3228, 'TXTVISITORFILEATTACHMENT', 2, 0, 3228, 0, 8),
(3229, 'TXTLIVECHATACC', 2, 0, 3229, 0, 8),
(3230, 'TXTLIVECHAT', 1, 0, 3230, 0, 0),
(3231, 'TXTTAKECHAT', 2, 0, 3231, 0, 0),
(3232, 'TXTFORWARDCHAT', 2, 0, 3232, 0, 0),
(3233, 'TXTJOINCHAT', 2, 0, 3233, 0, 0),
(3234, 'TXTJOINCHATINVISIBLY', 2, 0, 3234, 0, 0),
(3235, 'TXTINVITEOPERATOR', 2, 0, 3235, 0, 0),
(3236, 'TXTVIEWCHATS', 2, 0, 3236, 0, 0),
(3237, 'TXTCHATHISTORY', 2, 0, 3237, 0, 8),
(3238, 'MSGOLDCHAT', 2, 0, 3238, 0, 8),
(3239, 'TXTENTERISSEND', 2, 0, 3239, 0, 8),
(3240, 'TXTCONNECTTOLIVECHAT', 1, 0, 3240, 0, 0),
(3241, 'TXTACTIVEONCHAT', 2, 0, 3241, 0, 0),
(3242, 'TXTCHATSTATUS', 2, 0, 3242, 0, 0),
(3243, 'TXTBUSY', 2, 0, 3243, 0, 0),
(3244, 'TXTAWAY', 2, 0, 3244, 0, 0),
(3245, 'TXTCHATSETTING', 2, 0, 3245, 0, 0),
(3246, 'TXTAUTOACCEPTANCE', 2, 0, 3246, 0, 0),
(3247, 'TXTSHOWPROFILEIMG', 2, 0, 3247, 0, 0),
(3248, 'TXTREFERRAL', 2, 0, 3248, 0, 0),
(3249, 'TXTLASTVISITPAGE', 2, 0, 3249, 0, 0),
(3250, 'TXTLASTVISITTIME', 2, 0, 3250, 0, 0),
(3251, 'TXTLATITUDE', 2, 0, 3251, 0, 0),
(3252, 'TXTLONGITUDE', 2, 0, 3252, 0, 0),
(3253, 'TXTBROWSER', 2, 0, 3253, 0, 0),
(3254, 'TXTQUEUEDMSG', 2, 0, 3254, 0, 16),
(3255, 'TXTOFFLINEMSG', 2, 0, 3255, 0, 16),
(3256, 'TXTDISPLAYPIC', 2, 0, 3256, 0, 16),
(3257, 'TXTCHATWIDGET', 2, 0, 3257, 0, 0),
(3258, 'TXTCHATINITIATEMSG', 2, 0, 3258, 0, 16),
(3259, 'MSG200CHAR', 2, 0, 3259, 0, 16),
(3260, 'MSG100CHAR', 2, 0, 3260, 0, 16),
(3261, 'TXTPRECHAT', 2, 0, 3261, 0, 0),
(3262, 'TXTPRECHATCUSTOMFLD', 2, 0, 3262, 0, 0),
(3263, 'TXTPRECHATCUSTOMFLDUPDATE', 2, 0, 3263, 0, 16),
(3264, 'TXTLIVECHATWIDGETID', 2, 0, 3264, 0, 16),
(3265, 'TXTADDPRECHATCUSTOMFLD', 2, 0, 3265, 0, 16),
(3266, 'TXTADDNEWPRECHATCUSTOMFLD', 2, 0, 3266, 0, 16),
(3267, 'TXTDELPRECHATCUSTOMFLD', 2, 0, 3267, 0, 16),
(3268, 'TXTLIVECHATCODE', 2, 0, 3268, 0, 16),
(3269, 'TXTCHATVIEWS', 2, 0, 3269, 0, 0),
(3270, 'TXTTICKETVIEWS', 2, 0, 3270, 0, 0),
(3271, 'TXTADDCHATVIEWS', 2, 0, 3271, 0, 0),
(3272, 'TXTVISITS', 2, 0, 3272, 0, 0),
(3273, 'TXTLIVECHATHASHGEN', 2, 0, 3273, 0, 0),
(3274, 'TXTDEVICE', 2, 0, 3274, 0, 0),
(3275, 'TXTOS', 2, 0, 3275, 0, 0),
(3276, 'TXTUSERAGENT', 2, 0, 3276, 0, 0),
(3277, 'TXTCONTINENT', 2, 0, 3277, 0, 0),
(3278, 'TXTCOUNTRYCODE', 2, 0, 3278, 0, 0),
(3279, 'TXTISP', 2, 0, 3279, 0, 0),
(3280, 'TXTBUSINESSNEME', 2, 0, 3280, 0, 0),
(3281, 'TXTBUSINESSWEBSITE', 2, 0, 3281, 0, 0),
(3282, 'TXTCHATVISITOR', 2, 0, 3282, 0, 16),
(3283, 'TXTMYCHATS', 2, 0, 3283, 0, 16),
(3284, 'TXTCHATBOARD', 2, 0, 3284, 0, 16),
(3285, 'TXTALLCHATS', 2, 0, 3285, 0, 16),
(3286, 'TXTLIVECHATPREFIX', 2, 0, 3286, 0, 0),
(3287, 'TXTSUBJECTLINE', 2, 0, 3287, 0, 0),
(3288, 'TXTINACTIVITYTIMESTAFF', 2, 0, 3288, 0, 0),
(3289, 'TXTINACTIVITYTIMEVISITOR', 2, 0, 3289, 0, 0),
(3290, 'TXTLCHASHPREFIXMUSTBEALPHANUME', 2, 0, 3290, 0, 0),
(3291, 'TXTLCHASHPREFIXFLDISEMPTY', 2, 0, 3291, 0, 0),
(3292, 'TXTTOTALUNSOLVED', 2, 0, 3292, 0, 0),
(3293, 'TXTACCEPTCHAT', 2, 0, 3293, 0, 0),
(3294, 'TXTENDCHAT', 1, 0, 3294, 0, 0),
(3295, 'TXTENDCHATMSG', 2, 0, 3295, 0, 16),
(3296, 'TXTLEAVECHAT', 2, 0, 3296, 0, 16),
(3297, 'TXTDELCLIENTCHAT', 2, 0, 3297, 0, 3),
(3298, 'TXTSOUNDNOTIFICATION', 2, 0, 3298, 0, 0),
(3299, 'TXTNEWCHAT', 2, 0, 3299, 0, 0),
(3300, 'TXTNEWMESSAGE', 2, 0, 3300, 0, 0),
(3301, 'TXTNEWVISITOR', 2, 0, 3301, 0, 0),
(3302, 'TXTSENDANDRECEIVEMSG', 2, 0, 3302, 0, 0),
(3303, 'TXTDEFAULTBRATE', 2, 0, 3303, 0, 0),
(3304, 'TXTMSGLEAVECHAT', 2, 0, 3304, 0, 16),
(3305, 'TXTAVAILABLE', 2, 0, 3305, 0, 0),
(3306, 'TXTSTARTCHAT', 2, 0, 3306, 0, 16),
(3307, 'TXTFILENOTSENTTRYAGAIN', 2, 0, 3307, 0, 0),
(3308, 'TXTHASJOINEDCHAT', 2, 0, 3308, 0, 0),
(3309, 'TXTFILENOTSENT', 2, 0, 3309, 0, 0),
(3310, 'TXTTASKATTACHTOPROBLEM', 2, 0, 3310, 0, 7),
(3311, 'TXTTASKATTACHTOCHANGES', 2, 0, 3311, 0, 7),
(3312, 'TXTTASKATTACHTORELEASES', 2, 0, 3312, 0, 7),
(3313, 'TXTLIVECHATSOLUTIONS', 2, 0, 3313, 0, 16),
(3314, 'TXTALLSOLUTIONS', 2, 0, 3314, 0, 16),
(3315, 'TXTCFRFSTTASKCRPT', 2, 0, 3315, 0, 7),
(3316, 'MSGCHATALREDYEND', 2, 0, 3316, 0, 16),
(3317, 'TXTPRIORITYTASK', 2, 0, 3317, 0, 7),
(3318, 'TXTTIMETRACKBSDBILLRATE', 2, 0, 3318, 0, 7),
(3319, 'TXTTKTLIVECHATGRP', 2, 0, 3319, 0, 0),
(3320, 'TXTYOURSTATUSOFFLINE', 2, 0, 3320, 0, 16),
(3321, 'TXTCHATFORWARDED', 2, 0, 3321, 0, 0),
(3322, 'TXTHASFORWTHECHATTO', 1, 0, 3322, 0, 0),
(3323, 'TXTHASINVITEDCHATTO', 2, 0, 3323, 0, 0),
(3324, 'TXTFORWARDCHATACCEPT', 2, 0, 3324, 0, 0),
(3325, 'TXTACCEPTTHEFORWARDCHAT', 2, 0, 3325, 0, 0),
(3326, 'TXTCHATINVITED', 2, 0, 3326, 0, 0),
(3327, 'TXTCHATTAKEN', 2, 0, 3327, 0, 0),
(3328, 'TXTCHATJOINED', 2, 0, 3328, 0, 0),
(3329, 'TXTHASTAKENCHAT', 2, 0, 3329, 0, 0),
(3330, 'TXTINVITECHATREQACCEPT', 2, 0, 3330, 0, 16),
(3331, 'TXTJOINEDINVCHATREQ', 2, 0, 3331, 0, 0),
(3332, 'TXTCHATJOINEDINVISIBLY', 2, 0, 3332, 0, 0),
(3333, 'TXTHASJOINCHATINVISI', 2, 0, 3333, 0, 0),
(3334, 'TXTCHATLEAVED', 2, 0, 3334, 0, 0),
(3335, 'TXTHASLEAVCHAT', 2, 0, 3335, 0, 0),
(3336, 'TXTMSGGRABVISITINTERST', 2, 0, 3336, 0, 0),
(3337, 'TXTNEWMSGFROMFILEUP', 2, 0, 3337, 0, 0),
(3338, 'TXTNEWMSGFROM', 2, 0, 3338, 0, 0),
(3339, 'TXTNOCONVERSATIONS', 2, 0, 3339, 0, 0),
(3340, 'TXTCHATISEND', 2, 0, 3340, 0, 0),
(3341, 'TXTCHATSTARTED', 2, 0, 3341, 0, 0),
(3342, 'TXTONDATE', 2, 0, 3342, 0, 0),
(3343, 'TXTSTAFFLEFTCHAT', 2, 0, 3343, 0, 0),
(3344, 'TXTMISCLNTLEFTCHAT', 2, 0, 3344, 0, 0),
(3345, 'TXTMISSTAFLGOUT', 2, 0, 3345, 0, 0),
(3346, 'TXTMISSTFNOTAVAL', 2, 0, 3346, 0, 0),
(3347, 'TXTFORWARDCHATTO', 2, 0, 3347, 0, 0),
(3348, 'TXTCATEGORYTYPE', 2, 0, 3348, 0, 0),
(3349, 'TXTTHEMECOLOR', 2, 0, 3349, 0, 0),
(3350, 'TXTVIEWTKTFORMSTAFOFFON', 2, 0, 3350, 0, 16),
(3351, 'TXTAPPENDPOST', 1, 0, 3351, 0, 16),
(3352, 'TXTFORWARDBY', 1, 0, 3352, 0, 0),
(3353, 'TXTSENT', 1, 0, 3353, 0, 0),
(3354, 'TXTSENDING', 1, 0, 3354, 0, 0),
(3355, 'TXTTHANKYUFORSUB', 1, 0, 3355, 0, 0),
(3356, 'TXTORDERHASH', 2, 0, 3356, 0, 0),
(3357, 'TXTAMIHELPFUL', 1, 0, 3357, 0, 0),
(3358, 'TXTUPDATEDTAIL', 1, 0, 3358, 0, 16),
(3359, 'TXTENTEROTP', 1, 0, 3359, 0, 16),
(3360, 'TXTRESENDOTP', 1, 0, 3360, 0, 16),
(3361, 'TXTCHECKEMAILRESENTOTP', 1, 0, 3361, 0, 16),
(3362, 'TXTCHECKEMAILSENTOTP', 1, 0, 3362, 0, 16),
(3363, 'TXTSOMETHINGWRONG', 1, 0, 3363, 0, 16),
(3364, 'TXTINVALIDOTP', 1, 0, 3364, 0, 16),
(3365, 'TXTCLNTDETAILUPDT', 1, 0, 3365, 0, 0),
(3366, 'TXTFORWARDON', 1, 0, 3366, 0, 7),
(3367, 'TXTNETWORKDISC', 1, 0, 3367, 0, 0),
(3368, 'TXTRECONECTING', 1, 0, 3368, 0, 0),
(3369, 'TXTINITIATEDATE', 1, 0, 3369, 0, 7),
(3370, 'TXTNEWCHATFROM', 1, 0, 3370, 0, 0),
(3371, 'TXTHASSTARTEDCHAT', 1, 0, 3371, 0, 0),
(3372, 'TXTDEPTWISECHAT', 2, 0, 3372, 0, 7),
(3373, 'TXTMISSEDCHAT', 2, 0, 3373, 0, 0),
(3374, 'TXTACTIVECHAT', 2, 0, 3374, 0, 7),
(3375, 'TXTTOTMISSEDCHAT', 2, 0, 3375, 0, 7),
(3376, 'TXTTOTACTIVECHAT', 2, 0, 3376, 0, 7),
(3377, 'TXTTOTDURATION', 2, 0, 3377, 0, 0),
(3378, 'TXTMISSEDCHATDEPTWISE', 2, 0, 3378, 0, 7),
(3379, 'TXTACTIVECHATDEPTWISE', 2, 0, 3379, 0, 7),
(3380, 'TXTSTAFFWISECHAT', 2, 0, 3380, 0, 7),
(3381, 'TXTVISITORREPORT', 2, 0, 3381, 0, 7),
(3382, 'TXTREFBASEREPORT', 2, 0, 3382, 0, 7),
(3383, 'TXTVISITBASREPORT', 2, 0, 3383, 0, 7),
(3384, 'TXTACTIVECHATSTAFFWISE', 2, 0, 3384, 0, 7),
(3385, 'TXTCLIENTWISECHRE', 2, 0, 3385, 0, 7),
(3386, 'TXTORGWISECHREP', 2, 0, 3386, 0, 7),
(3387, 'TXTTIMESPENTBYCL', 2, 0, 3387, 0, 7),
(3388, 'TXTCLWITHMAXCHAT', 2, 0, 3388, 0, 7),
(3389, 'TXTCUSTREPFORVISI', 2, 0, 3389, 0, 7),
(3390, 'TXTPRECHTCUSTFLDREP', 2, 0, 3390, 0, 7),
(3391, 'TXTSWITCHTOCLIENT', 2, 0, 3391, 0, 0),
(3392, 'TXTMISSCHATSTFWSRPT', 2, 0, 3392, 0, 7),
(3393, 'TXTSTFFORWARDCHARRPT', 2, 0, 3393, 0, 7),
(3394, 'TXTSTFPRODUCTIVERPT', 2, 0, 3394, 0, 7),
(3395, 'TXTVISITORPAGEWSRPT', 2, 0, 3395, 0, 7),
(3396, 'TXTMISSCHATREASON', 2, 0, 3396, 0, 7),
(3397, 'TXTPRODUCTIVETIME', 2, 0, 3397, 0, 7),
(3398, 'TXTMRGCLONGOCHT', 2, 0, 3398, 0, 3),
(3399, 'TXTMRGCONTONGOCHT', 2, 0, 3399, 0, 3),
(3400, 'TXTCHATENDED', 1, 0, 3400, 0, 0),
(3401, 'TXTHASENDEDCHAT', 1, 0, 3401, 0, 0),
(3402, 'TXTMUTE', 2, 0, 3402, 0, 0),
(3403, 'TXTHASLEFTCHAT', 1, 0, 3403, 0, 0),
(3404, 'TXTHOWMAYIHELPU', 1, 0, 3404, 0, 0),
(3405, 'TXTROUTEREQUESTTOSTAFF', 2, 0, 3405, 0, 0),
(3406, 'TXTLEFTCHAT', 1, 0, 3406, 0, 0),
(3407, 'TXTJUSTNOW', 1, 0, 3407, 0, 0),
(3408, 'TXTCHATS', 1, 0, 3408, 0, 0),
(3409, 'TXTASKFORRATING', 2, 0, 3409, 0, 0),
(3410, 'TXTCHATRATING', 1, 0, 3410, 0, 0),
(3411, 'TXTRATETHISCHAT', 1, 0, 3411, 0, 0),
(3412, 'TXTNORATING', 1, 0, 3412, 0, 0),
(3413, 'TXTSMILEYICON', 1, 0, 3413, 0, 0),
(3414, 'TXTSTARRATING', 1, 0, 3414, 0, 0),
(3415, 'TXTBAD', 1, 0, 3415, 0, 0),
(3416, 'TXTGOOD', 1, 0, 3416, 0, 0),
(3417, 'TXTAVERAGE', 1, 0, 3417, 0, 0),
(3418, 'TXTRATINGTYPE', 1, 0, 3418, 0, 0),
(3419, 'TXTRATINGRQSTSENDSUCCESS', 1, 0, 3419, 0, 0),
(3420, 'TXTTOTALCHAT', 1, 0, 3420, 0, 0),
(3421, 'TXTTOTALAVGSPENDTIME', 1, 0, 3421, 0, 7),
(3422, 'TXTLEFTDATE', 1, 0, 3422, 0, 7),
(3423, 'TXTTOTALVISITOR', 1, 0, 3423, 0, 0),
(3424, 'MSGNUMERICVALIDATIONFORINVBEF', 1, 0, 3424, 0, 0),
(3425, 'TXTINVOICEBEFOREONDAYS', 1, 0, 3425, 0, 0),
(3426, 'TXTBILLINGLOG', 1, 0, 3426, 0, 0),
(3427, 'TXTSTAFFJOINED', 1, 0, 3427, 0, 0),
(3428, 'MSGDELETEBILLINGLOG', 1, 0, 3428, 0, 0),
(3429, 'MSGTRUNCATEBILLINGLOG', 1, 0, 3429, 0, 0),
(3430, 'TXTCATEGORYSLA', 1, 0, 3430, 0, 7),
(3431, 'TXTORGANIZATIONSLA', 1, 0, 3431, 0, 7),
(3432, 'TXTPRECHATFORM', 1, 0, 3432, 0, 16),
(3433, 'TXTCANRESP', 1, 0, 3433, 0, 16),
(3434, 'TXTINCTYPESLA', 1, 0, 3434, 0, 7),
(3435, 'TXTINCPRIORITYSLA', 1, 0, 3435, 0, 7),
(3436, 'TXTINCISERVICEHASH', 1, 0, 3436, 0, 7),
(3437, 'TXTVISITNAVIREP', 2, 0, 3437, 0, 7),
(3438, 'TXTPAGEURL', 2, 0, 3438, 0, 0),
(3439, 'TXTNOOFHITS', 2, 0, 3439, 0, 7),
(3440, 'TXTPRIVATEMSG', 2, 0, 3440, 0, 0),
(3441, 'TXTMESSAGETEMPLATE', 2, 0, 3441, 0, 0),
(3442, 'TXTSHOWSTATUSBAR', 2, 0, 3442, 0, 0),
(3443, 'TXTENDCHATIDEAL', 2, 0, 3443, 0, 0),
(3444, 'TXTMAXACCPNAME', 2, 0, 3444, 0, 0),
(3445, 'TXTSETCHATDISPNAME', 2, 0, 3445, 0, 0),
(3446, 'TXTSETDISPNAME', 2, 0, 3446, 0, 0),
(3447, 'TXTCHATAUTOMATION', 2, 0, 3447, 0, 0),
(3448, 'TXTCHATMESSAGES', 2, 0, 3448, 0, 0),
(3449, 'TXTPPGDPR', 2, 0, 3449, 0, 8),
(3450, 'TXTSLAPLANBASEREPORT', 2, 0, 3450, 0, 7),
(3451, 'TXTNOFCHATVISITOR', 2, 0, 3451, 0, 7),
(3452, 'TXTIHAVEREADAGREETO', 1, 0, 3452, 0, 0),
(3453, 'TXTPPACCEPTEDON', 1, 0, 3453, 0, 3),
(3454, 'MSGCHECKPPDATAAVAILABLE', 1, 0, 3454, 0, 0),
(3455, 'TXTADDFILFROM', 2, 0, 3455, 0, 16),
(3456, 'TXTYOURCOMPUTER', 2, 0, 3457, 0, 16),
(3457, 'TXTROUTEREQUESTTOTEAM', 2, 0, 3458, 0, 0),
(3458, 'TXTDAYWISEREPORT', 2, 0, 3459, 0, 7),
(3459, 'TXTHOURLYBASEREPORT', 2, 0, 3460, 0, 7),
(3460, 'TXTCHATPERVISITIOR', 2, 0, 3461, 0, 7),
(3461, 'TXTCHATINITIATFROM', 2, 0, 3462, 0, 16),
(3462, 'TXTENTERSUBJECT', 1, 0, 3463, 0, 16),
(3463, 'TXTPAGEVISIT', 2, 0, 3464, 0, 16),
(3464, 'TXTCHATINITIATE', 2, 0, 3465, 0, 16),
(3465, 'TXTCHATCLOSING', 2, 0, 3466, 0, 16),
(3466, 'TXTUPDATECHATAUTOM', 2, 0, 3467, 0, 16),
(3467, 'TXTADDCHATAUTOM', 2, 0, 3468, 0, 16),
(3468, 'TXTONGOINGCHATS', 2, 0, 3469, 0, 0),
(3469, 'TXTPAGEREVISIT', 2, 0, 3470, 0, 16),
(3470, 'TXTIDLETIME', 2, 0, 3471, 0, 16),
(3471, 'TXTNEWVISIT', 2, 0, 3472, 0, 16),
(3472, 'TXTPAGETITLE', 2, 0, 3473, 0, 0),
(3473, 'TXTONLINETIME', 2, 0, 3474, 0, 0),
(3474, 'TXTCHFORWREQ', 2, 0, 3475, 0, 0),
(3475, 'TXTCHINVITATION', 2, 0, 3476, 0, 0),
(3476, 'TXTCHATINVITBY', 2, 0, 3477, 0, 0),
(3477, 'TXTSTAFFDISCONNTEDNTED', 1, 0, 3478, 0, 16),
(3478, 'TXTLIVECHATAGENT', 2, 0, 3479, 0, 0),
(3479, 'TXTRATENUMERIC', 2, 0, 3480, 0, 0),
(3480, 'TXTCALTRACKTIME', 2, 0, 3481, 0, 0),
(3481, 'MSGUPDATECI', 2, 0, 3482, 0, 14),
(3482, 'TXTSHWSTATUSONENDCHAT', 2, 0, 3483, 0, 0),
(3483, 'TXTINVITE', 2, 0, 3484, 0, 0),
(3484, 'TXTVISITORSMAP', 2, 0, 3485, 0, 0),
(3485, 'TXTRATINGRECEIVED', 2, 0, 3486, 0, 0),
(3486, 'TXTPCUSER', 2, 0, 3487, 0, 14),
(3487, 'TXTLOGINATTEMPTSTHREE', 2, 0, 3488, 0, 0),
(3488, 'MSGPRODROLENOTE', 2, 0, 3489, 0, 8),
(3489, 'MSGMULTIDOMAINERR', 2, 0, 3490, 0, 8),
(3490, 'TXTACTUALDEPARTSLAREPORT', 2, 0, 3491, 0, 7),
(3491, 'MSGMULTIDOMAINTEAMERR', 2, 0, 3492, 0, 8),
(3492, 'ALLSTAFFCHATCOUNT', 2, 0, 3493, 0, 7),
(3493, 'MSGVANOTAVAILABLE', 1, 0, 3494, 0, 15),
(3494, 'VAFEEDBACKREPORT', 2, 0, 3495, 0, 7),
(3495, 'VAFEEDBACKISHELPFULNO', 2, 0, 3496, 0, 7),
(3496, 'VAFEEDBACKISHELPFULYES', 2, 0, 3497, 0, 7),
(3497, 'TXTMAPPED', 2, 0, 3498, 0, 4),
(3498, 'TXTNOTMAPPED', 2, 0, 3499, 0, 4),
(3499, 'TXTARTICLESCOUNT', 2, 0, 3500, 0, 4),
(3500, 'KEYWDELARTICLE', 2, 0, 3501, 0, 4),
(3501, 'MAPPEDARTICLES', 2, 0, 3502, 0, 4),
(3502, 'TXTSELECTCATEGORIES', 2, 0, 3503, 0, 4),
(3503, 'TXTMAP', 2, 0, 3504, 0, 4);
INSERT INTO `avis_language_variables` VALUES
(3504, 'TXTKEYWORD', 2, 0, 3505, 0, 4),
(3505, 'TXTNEWKTNCLOSE', 1, 0, 3506, 0, 16),
(3506, 'TXTDAYREPORT', 2, 0, 3507, 0, 16),
(3507, 'TXTAPPEND', 1, 0, 3508, 0, 16),
(3508, 'TXTVISITORS', 2, 0, 3509, 0, 16),
(3509, 'TXTSTAFFWISWAVAILABILITY', 2, 0, 3510, 0, 16),
(3510, 'TXTSEARCHENGINE', 2, 0, 3511, 0, 16),
(3511, 'TXTDEPTWISEAVAILBILITY', 2, 0, 3512, 0, 16),
(3512, 'TXTSTAFFACCEPTCHAT', 2, 0, 3513, 0, 16),
(3513, 'TXTSEARCHPHRASES', 2, 0, 3514, 0, 16),
(3514, 'TXTENTRYPAGES', 2, 0, 3515, 0, 16),
(3515, 'TXTREFERURL', 2, 0, 3516, 0, 16),
(3516, 'TXTSHOWEMOJI', 2, 0, 3517, 0, 8),
(3517, 'TXTENAENDCONVFORCLIENT', 2, 0, 3518, 0, 8),
(3518, 'TXTAPPENDCHATNCLOSE', 2, 0, 3519, 0, 16),
(3519, 'TXTNUMBEROFLIVECHATAGENTS', 2, 0, 3520, 0, 8),
(3520, 'TXTLIVECHATEXPDATE', 2, 0, 3521, 0, 8),
(3521, 'TXTCHATLOG', 2, 0, 3522, 0, 8),
(3522, 'MSGOLDCHATLOG', 2, 0, 3523, 0, 8),
(3523, 'TXTLCAGENT', 2, 0, 3524, 0, 8),
(3524, 'TXTDSHDAYREPMAG', 2, 0, 3525, 0, 8),
(3525, 'TXTDELETECHAT', 2, 0, 3526, 0, 0),
(3526, 'TXTOLDDISCARDCHAT', 2, 0, 3527, 0, 0),
(3527, 'TXTSTAFFNOTAVAILABLE', 2, 0, 3528, 0, 0),
(3528, 'TXTQUEUEMSG', 2, 0, 3529, 0, 0),
(3529, 'TXTSTAFFLEFTS', 2, 0, 3530, 0, 0),
(3530, 'TXTCLIENTLEFTS', 2, 0, 3531, 0, 0),
(3531, 'TXTDISCARDCHATLOG', 2, 0, 3532, 0, 0),
(3532, 'TXTDELCHATSYSTEM', 2, 0, 3533, 0, 0),
(3533, 'TXTQUEUE', 2, 0, 3534, 0, 0),
(3534, 'MSGCHATINQUEUE', 2, 0, 3535, 0, 0),
(3535, 'TXTSHOWTYPEVIS', 2, 0, 3536, 0, 8),
(3536, 'TXTSHOWTAGSANDLABELONCHAT', 2, 0, 3537, 0, 0),
(3537, 'TXTSHOWTYPEVISTOSTAFF', 2, 0, 3538, 0, 8),
(3538, 'TXTSAVECANNEDRESPONSE', 2, 0, 3539, 0, 0),
(3539, 'TXTIPGEOLOCKEY', 2, 0, 3540, 0, 0),
(3540, 'TXTSAVEASCANREPLY', 2, 0, 3541, 0, 0),
(3541, 'TXTCANNEDRESTEXT', 2, 0, 3542, 0, 0),
(3542, 'TXTSHORTCUTS', 2, 0, 3543, 0, 0),
(3543, 'TXTSHORTCUTUSERESPONSE', 2, 0, 3544, 0, 0),
(3544, 'TXTENABLELIVECHATSCRIPT', 2, 0, 3545, 0, 0),
(3545, 'TXTASKFORDETAILS', 2, 0, 3546, 0, 16),
(3546, 'TXTCHATSURVEY', 2, 0, 3547, 0, 0),
(3547, 'TXTCHATSURVEYFIELD', 2, 0, 3548, 0, 0),
(3548, 'TXTCHATADDSURVEYFIELD', 2, 0, 3549, 0, 0),
(3549, 'TXTCHATDELETESURVEYFIELD', 2, 0, 3550, 0, 0),
(3550, 'TXTCHATUPDATESURVEYFIELD', 2, 0, 3551, 0, 0),
(3551, 'TXTCHATSURVEYDETAILS', 2, 0, 3552, 0, 0),
(3552, 'TXTCHATSURVEYDATE', 2, 0, 3553, 0, 0),
(3553, 'TXTCHECKUNCHECK', 2, 0, 3554, 0, 0),
(3554, 'TXTREQINCICRDFLD', 2, 0, 3555, 0, 0),
(3555, 'TXTACKNOWLEGEMENT', 2, 0, 3556, 0, 0),
(3556, 'TXTACCEPTABLESTATUS', 1, 0, 3557, 0, 0),
(3557, 'TXTSERVREQFIRSTRESPOREPORT', 2, 0, 4000, 0, 7),
(3558, 'TXTFREE', 2, 0, 4001, 0, 0),
(3559, 'TXTPREPAID', 2, 0, 4002, 0, 8),
(3560, 'TXTPOSTPAID', 2, 0, 4003, 0, 8),
(3561, 'TXTROLEASSIGNMENT', 2, 1, 4004, 0, 0),
(3562, 'TXTSTAGECOMPLETION', 2, 0, 4005, 0, 0),
(3563, 'TXTUPDATEPRBKNWNERR', 2, 1, 4006, 0, 0),
(3564, 'TXTHYBRID', 2, 0, 4007, 0, 0),
(3565, 'TXTTOTALTAX', 2, 0, 4008, 0, 0),
(3566, 'TXTTRACKASASSET', 2, 0, 4009, 0, 8),
(3567, 'TXTRESETTHEME', 2, 0, 4010, 0, 8),
(3568, 'TXTPRIMARYLIGHTCOLOR', 2, 0, 4011, 0, 8),
(3569, 'TXTPRIMARYCOLOR', 2, 0, 4012, 0, 8),
(3570, 'TXTUPDATEPROPERTY', 2, 0, 4013, 0, 0),
(3571, 'TXTSUBCLIENT', 2, 0, 4014, 0, 3),
(3572, 'TXTEDITOR', 2, 0, 4015, 0, 4),
(3573, 'TXTTYPESUBJECTHERE3WORD', 2, 0, 4016, 0, 0),
(3574, 'TXTTYPESEARCHEXISTDATA', 2, 0, 4017, 0, 10),
(3575, 'TXTUPDATEPROPERTIES', 2, 0, 4018, 0, 0),
(3576, 'TXTBOLD', 2, 0, 4019, 0, 8),
(3577, 'TXTITALIC', 2, 0, 4020, 0, 8),
(3578, 'TXTSTAFFTPORTALTHEME', 2, 0, 4021, 0, 8),
(3579, 'TXTLOGO', 2, 0, 4022, 0, 8),
(3580, 'TXTGROUP', 2, 0, 4023, 0, 0),
(3581, 'TXTOLDEST', 2, 0, 4024, 0, 4),
(3582, 'TXTNEWEST', 2, 0, 4025, 0, 4),
(3583, 'TXTSEEALLNOTIFICATION', 2, 0, 4026, 0, 0),
(3584, 'TXTUPLOADFILE', 2, 0, 4027, 0, 0),
(3585, 'TXTAUTHORIZE', 2, 0, 4028, 0, 10),
(3586, 'TXTOUTOFSCOPE', 2, 0, 4029, 0, 10),
(3587, 'TXTREMOVE', 2, 0, 4030, 0, 0),
(3588, 'TXTQUICKSETUP', 2, 0, 4031, 0, 1),
(3589, 'TXTBRAND', 2, 0, 4032, 0, 0),
(3590, 'TXTREMINDLETTER', 2, 0, 4033, 0, 0),
(3591, 'TXTDONTASKMEAGAIN', 2, 0, 4034, 0, 1),
(3592, 'TXTSEARCHSTAFFGEOUP', 2, 0, 4035, 0, 6),
(3593, 'TXTUSERPERSONALMEETID', 2, 0, 4036, 0, 0),
(3594, 'TXTWELCOMBLABWIDGET', 2, 0, 4037, 0, 6),
(3595, 'TXTCREATEGROUP', 2, 0, 4038, 0, 6),
(3596, 'TXTERRENTERGROUPNAME', 2, 0, 4039, 0, 6),
(3597, 'TXTWHOLEPHRASE', 2, 0, 4040, 0, 0),
(3598, 'TXTERRINCREATEGROUP', 2, 0, 4041, 0, 6),
(3599, 'TXTBLABWELMSG', 2, 0, 4042, 0, 0),
(3600, 'TXTMAILTRACKING', 2, 0, 4043, 0, 8),
(3601, 'TXTRELEASESBYSTATUS', 2, 1, 4044, 0, 0),
(3602, 'TXTRELEASESBYPRIORITY', 2, 1, 4045, 0, 0),
(3603, 'TXTRELEASESBYIMPACT', 2, 1, 4046, 0, 0),
(3604, 'TXTHAPPYCUSTOMER', 2, 0, 4047, 0, 7),
(3605, 'TXTUNHAPPYCUSTOMER', 2, 0, 4048, 0, 7),
(3606, 'TXTAPIIPCHECK', 2, 0, 4049, 0, 0),
(3607, 'TXTFORCEATTACKIPBAN', 2, 0, 4050, 0, 0),
(3608, 'TXTMAXINLOGINATTEMPTS', 2, 0, 4051, 0, 0),
(3609, 'TXTFORCEPASSRESET', 2, 0, 4052, 0, 0),
(3610, 'TXTNOOFDAYSRESET', 2, 0, 4053, 0, 0),
(3611, 'TXTPWDEXITENOTE', 2, 0, 4054, 0, 0),
(3612, 'MSGIPSECNOTE', 2, 0, 4055, 0, 0),
(3613, 'TXTUSERPASSWORDSAME', 2, 0, 4056, 0, 0),
(3614, 'MSGATLEASTONE', 2, 0, 4057, 0, 0),
(3615, 'TXTASSETSCUSTOMFIELD', 2, 0, 4058, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_assign_queue`
--

CREATE TABLE `avis_lc_assign_queue` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `queue_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_autoaccptance`
--

CREATE TABLE `avis_lc_autoaccptance` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `acceptance` tinyint(1) DEFAULT '0',
  `queue_flag` tinyint(1) DEFAULT '0',
  `modified_time` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_automation`
--

CREATE TABLE `avis_lc_automation` (
  `automation_id` int(15) NOT NULL AUTO_INCREMENT,
  `automation_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `event` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`automation_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_lc_automation`
--

INSERT INTO `avis_lc_automation` VALUES
(1, 'Default chat automation', 0, NULL, 1, 1, [[timestamp]], '0,4');

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_automation_action`
--

CREATE TABLE `avis_lc_automation_action` (
  `lc_action_id` int(15) NOT NULL AUTO_INCREMENT,
  `automation_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text,
  PRIMARY KEY (`lc_action_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `avis_lc_automation_action`
--

INSERT INTO `avis_lc_automation_action` VALUES
(1, 1, 1, '3'),
(2, 1, 2, '0'),
(3, 1, 3, ''),
(4, 1, 4, ''),
(5, 1, 5, '0'),
(6, 1, 6, '0'),
(7, 1, 7, '');

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_automation_criteria`
--

CREATE TABLE `avis_lc_automation_criteria` (
  `lc_criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `automation_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`lc_criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_lc_automation_criteria`
--

INSERT INTO `avis_lc_automation_criteria` VALUES
(1, 1, 0, 0, '', 'and'),
(2, 1, 0, 0, '', 'or');

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_chat`
--

CREATE TABLE `avis_lc_chat` (
  `conversation_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `rating` int(15) DEFAULT '0',
  `chat_status` int(15) DEFAULT '0' COMMENT '1-queued,2-started,3-closed,4-missed',
  `join_chat` varchar(255) DEFAULT '0',
  `join_invisible` varchar(255) DEFAULT '0',
  `forwardedto` varchar(255) DEFAULT '0',
  `online_staff` varchar(300) DEFAULT '',
  `chat_widget_id` int(15) DEFAULT '0',
  `referral_url` varchar(255) DEFAULT '',
  `agent_details` varchar(255) DEFAULT '',
  `ip_address` varchar(255) DEFAULT '',
  `initiate_time` varchar(255) DEFAULT '0',
  `start_time` varchar(255) DEFAULT '0',
  `end_time` varchar(255) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `visitor_id` int(15) DEFAULT '0',
  `uniqe_id` varchar(255) DEFAULT '',
  `prechat_survey` longtext,
  `status` varchar(255) DEFAULT '',
  `last_activity_time` varchar(255) DEFAULT '0',
  `language_id` int(15) DEFAULT '1',
  `time_zone` varchar(255) DEFAULT '',
  `chat_pid` int(15) DEFAULT '0' COMMENT 'linked to avis_lc_visitnavigation.pid',
  `chat_channel` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-portal,1-facebook,2-whatsapp',
  `channel_sid` varchar(255) NOT NULL DEFAULT '',
  `page_id` text,
  `endchattype` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1-end by staff,2-end by client,3-staffllogout,4-staff not available,5-client left auto,6-discarded',
  `queue_no` int(15) DEFAULT '0',
  PRIMARY KEY (`conversation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_chatlog`
--

CREATE TABLE `avis_lc_chatlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `chat_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_chatlog_archive`
--

CREATE TABLE `avis_lc_chatlog_archive` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `chat_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_chat_archive`
--

CREATE TABLE `avis_lc_chat_archive` (
  `conversation_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `rating` int(15) DEFAULT '0',
  `chat_status` int(15) DEFAULT '0' COMMENT '1-queued,2-started,3-closed,4-missed',
  `join_chat` varchar(255) DEFAULT '0',
  `join_invisible` varchar(255) DEFAULT '0',
  `forwardedto` int(15) DEFAULT '0',
  `online_staff` varchar(300) DEFAULT '',
  `chat_widget_id` int(15) DEFAULT '0',
  `referral_url` varchar(255) DEFAULT '',
  `agent_details` varchar(255) DEFAULT '',
  `ip_address` varchar(255) DEFAULT '',
  `initiate_time` varchar(255) DEFAULT '0',
  `start_time` varchar(255) DEFAULT '0',
  `end_time` varchar(255) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `visitor_id` int(15) DEFAULT '0',
  `uniqe_id` varchar(255) DEFAULT '',
  `prechat_survey` longtext,
  `status` varchar(255) DEFAULT '',
  `last_activity_time` varchar(255) DEFAULT '0',
  `language_id` int(15) DEFAULT '1',
  `time_zone` varchar(255) DEFAULT '',
  `chat_pid` int(15) DEFAULT '0' COMMENT 'linked to avis_lc_visitnavigation.pid',
  `chat_channel` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-portal,1-facebook,2-whatsapp',
  `channel_sid` varchar(255) NOT NULL DEFAULT '',
  `page_id` text,
  `endchattype` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1-end by staff,2-end by client,3-staffllogout,4-staff not available,5-client left auto,6-discarded',
  `queue_no` int(15) DEFAULT '0',
  PRIMARY KEY (`conversation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_customfield`
--

CREATE TABLE `avis_lc_customfield` (
  `customfield_id` int(15) NOT NULL AUTO_INCREMENT,
  `field_type` int(4) DEFAULT '1',
  `field_group` int(15) DEFAULT '0',
  `field_description` varchar(255) NOT NULL,
  `display_order` int(15) DEFAULT '0',
  `is_selected` tinyint(1) DEFAULT '0',
  `is_required` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '0',
  `group_type` tinyint(1) DEFAULT '0' COMMENT '1-prechatform,2-postchatform',
  `default_name` varchar(255) DEFAULT '',
  `widget_id` varchar(255) NOT NULL,
  `is_survey` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`customfield_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_customfield_data`
--

CREATE TABLE `avis_lc_customfield_data` (
  `customfield_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `chat_id` int(15) DEFAULT '0',
  `group_type` int(15) DEFAULT '0',
  `customfield_id` int(15) DEFAULT '0',
  `content` text,
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`customfield_data_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_discardchat`
--

CREATE TABLE `avis_lc_discardchat` (
  `conversation_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `join_chat` varchar(255) DEFAULT '0',
  `join_invisible` varchar(255) DEFAULT '0',
  `forwardedto` int(15) DEFAULT '0',
  `online_staff` varchar(300) DEFAULT '',
  `referral_url` varchar(255) DEFAULT '',
  `agent_details` varchar(255) DEFAULT '',
  `ip_address` varchar(255) DEFAULT '',
  `initiate_time` varchar(255) DEFAULT '0',
  `start_time` varchar(255) DEFAULT '0',
  `visitor_id` int(15) DEFAULT '0',
  `uniqe_id` varchar(255) DEFAULT '',
  `prechat_survey` longtext,
  `client_id` int(15) DEFAULT '0',
  `group_id` int(15) DEFAULT '0',
  `user_name` varchar(255) DEFAULT '0',
  `email` varchar(255) DEFAULT '0',
  PRIMARY KEY (`conversation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_language_data`
--

CREATE TABLE `avis_lc_language_data` (
  `language_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `location` int(4) NOT NULL DEFAULT '0',
  `title` text,
  `language_id` int(15) DEFAULT '0',
  `data_id` int(15) DEFAULT '0',
  PRIMARY KEY (`language_data_id`),
  KEY `location` (`location`,`language_id`,`data_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_message`
--

CREATE TABLE `avis_lc_message` (
  `mid` int(15) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(15) NOT NULL,
  `sender_type` tinyint(1) DEFAULT '0' COMMENT '0-staff, 1- client , 3- system',
  `sender_id` int(15) DEFAULT '0',
  `content` longtext NOT NULL,
  `message_type` tinyint(1) DEFAULT '0' COMMENT 'text-1,attachment-1,join-3,take-4,system-5,notification-5,rating_type-6,private_message-7',
  `enrty_time` varchar(255) NOT NULL,
  `read_flag` tinyint(1) DEFAULT '0',
  `deliver_flag` tinyint(1) DEFAULT '0',
  `sender_name` varchar(255) NOT NULL,
  `sender_image` varchar(255) NOT NULL,
  `msg_id` varchar(255) NOT NULL DEFAULT '0',
  `msg_read` int(11) DEFAULT '0',
  `pmto_id` int(15) DEFAULT '0',
  PRIMARY KEY (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_msg_template`
--

CREATE TABLE `avis_lc_msg_template` (
  `msg_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `display_order` int(11) NOT NULL,
  `language` int(11) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text,
  `parent_id` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '0',
  `is_custom` int(11) NOT NULL,
  PRIMARY KEY (`msg_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `avis_lc_msg_template`
--

INSERT INTO `avis_lc_msg_template` VALUES
(1, 'Greeting message', 0, 1, 'Greeting message', 'Welcome! How may I help you Today?', 1, 1, 0),
(2, 'Offline message', 0, 1, 'Offline message', 'Sorry! We are currently offline.. Leave us a message and we will get back to you.', 2, 1, 0),
(3, 'Page visit message', 0, 1, 'Page visit message', 'Hi, Good to have you here! Pls feel free to talk to our live chat agent.', 3, 1, 0),
(4, 'Closing message', 0, 1, 'Closing message', 'Thank you for contacting us! We hope we have answered your all questions.', 4, 1, 0),
(5, 'client has left the chat', 0, 1, 'client has left the chat', 'client has left the chat', 1, 1, 0),
(6, 'staff had left the chat', 0, 1, 'staff had left the chat', 'staff had left the chat', 1, 1, 0),
(7, 'staff not available', 0, 1, 'staff not available', 'staff not available', 1, 1, 0),
(8, 'Queue message', 0, 1, 'Queue message', 'One of our representative will be with you shortly. You are number {queue_number} in the queue. Thank you for your patience.', 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_notification_assign`
--

CREATE TABLE `avis_lc_notification_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `chat_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  `team_id` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_roundrobin`
--

CREATE TABLE `avis_lc_roundrobin` (
  `roundrobin_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `schedule_id` int(15) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  PRIMARY KEY (`roundrobin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_roundrobin_action`
--

CREATE TABLE `avis_lc_roundrobin_action` (
  `raction_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text,
  PRIMARY KEY (`raction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_roundrobin_criteria`
--

CREATE TABLE `avis_lc_roundrobin_criteria` (
  `rcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) NOT NULL DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`rcriteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_route_request`
--

CREATE TABLE `avis_lc_route_request` (
  `chat_id` int(11) NOT NULL,
  `staff_ids` int(11) NOT NULL,
  `dept` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `autoflag` int(11) NOT NULL COMMENT '1-automation,2-roundrobin'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_saveresponse`
--

CREATE TABLE `avis_lc_saveresponse` (
  `savereply_id` int(15) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  `content` text,
  `shortcut_key` varchar(255) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  PRIMARY KEY (`savereply_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_visitnavigation`
--

CREATE TABLE `avis_lc_visitnavigation` (
  `pid` int(15) NOT NULL AUTO_INCREMENT,
  `vid` int(15) DEFAULT '0',
  `visitor_id` int(15) DEFAULT '0',
  `pageurl` longtext,
  `pagetitle` longtext,
  `hit_time` varchar(255) DEFAULT '',
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_visitorhistory`
--

CREATE TABLE `avis_lc_visitorhistory` (
  `vid` int(15) NOT NULL AUTO_INCREMENT,
  `visitor_id` int(15) DEFAULT '0',
  `history` longtext,
  `referer` varchar(255) DEFAULT '',
  `start_time` varchar(255) DEFAULT '',
  `end_time` varchar(255) DEFAULT '',
  `enrty_time` varchar(255) DEFAULT '',
  PRIMARY KEY (`vid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_visitors`
--

CREATE TABLE `avis_lc_visitors` (
  `visitor_id` int(15) NOT NULL AUTO_INCREMENT,
  `businessName` varchar(255) DEFAULT '',
  `businessWebsite` varchar(255) DEFAULT '',
  `city` varchar(255) DEFAULT '',
  `continent` varchar(255) DEFAULT '',
  `country` varchar(255) DEFAULT '',
  `countryCode` varchar(255) DEFAULT '',
  `ipName` varchar(255) DEFAULT '',
  `ipType` varchar(255) DEFAULT '',
  `isp` varchar(255) DEFAULT '',
  `latitude` varchar(255) DEFAULT '',
  `longitude` varchar(255) DEFAULT '',
  `org` varchar(255) DEFAULT '',
  `ip` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `status` varchar(255) DEFAULT '',
  `useragent` varchar(255) DEFAULT '',
  `referral` varchar(255) DEFAULT '',
  `os` varchar(255) DEFAULT '',
  `timezone` varchar(255) DEFAULT '',
  `language` varchar(255) DEFAULT '',
  `chat_id` varchar(255) DEFAULT '',
  `client_id` int(15) DEFAULT '0',
  `last_visit_page` varchar(255) DEFAULT '',
  `last_visit_time` varchar(255) DEFAULT '',
  `visits` int(15) DEFAULT '0',
  `domainid` int(15) DEFAULT '0',
  `device` varchar(255) DEFAULT '',
  `browser` varchar(255) DEFAULT '',
  `sockets` text,
  `visitor_status` tinyint(1) NOT NULL DEFAULT '0',
  `visitor_invite_msg` text NOT NULL,
  `invited_staffid` int(15) NOT NULL,
  `chat_client` text NOT NULL,
  `last_activity_time` varchar(255) NOT NULL,
  PRIMARY KEY (`visitor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_lc_widget`
--

CREATE TABLE `avis_lc_widget` (
  `chat_widget_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `domain_id` int(15) DEFAULT '0',
  `language_id` int(15) DEFAULT '0',
  `theme_color` varchar(255) NOT NULL DEFAULT '',
  `display_title` varchar(512) NOT NULL DEFAULT '',
  `grab_message` varchar(512) NOT NULL DEFAULT '',
  `queued_message` varchar(512) NOT NULL DEFAULT '',
  `offline_message` int(15) DEFAULT '0',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `position` tinyint(1) NOT NULL DEFAULT '1',
  `initiate_message` int(15) DEFAULT '0',
  `is_enable` tinyint(1) NOT NULL DEFAULT '1',
  `prechat_status` tinyint(1) NOT NULL DEFAULT '1',
  `staffonoff_ticketform` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-off,1-on',
  `welcome_message` varchar(512) NOT NULL DEFAULT '',
  `department_id` int(15) DEFAULT '0',
  `show_online_staff_bar` varchar(512) NOT NULL DEFAULT '',
  `vis_staff_left_message` int(15) DEFAULT '0',
  `vis_client_left_message` int(15) DEFAULT '0',
  `vis_missed_chat` int(15) DEFAULT '0',
  `vis_q_no` int(15) DEFAULT '0',
  `col1` varchar(255) NOT NULL DEFAULT '',
  `col2` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`chat_widget_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ledgers`
--

CREATE TABLE `avis_ledgers` (
  `legder_id` int(15) NOT NULL AUTO_INCREMENT,
  `expensetype` int(15) NOT NULL,
  `cost_model` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `acc_no` varchar(255) NOT NULL,
  `acc_name` varchar(255) NOT NULL,
  `amount` varchar(255) NOT NULL,
  `location_id` int(15) NOT NULL,
  `entry_date` int(15) NOT NULL,
  `staff_id` int(15) NOT NULL,
  PRIMARY KEY (`legder_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_level_points`
--

CREATE TABLE `avis_level_points` (
  `level_id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(255) DEFAULT NULL,
  `level_points` varchar(15) DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `avis_level_points`
--

INSERT INTO `avis_level_points` VALUES
(1, 'Pawn', '100', 0),
(2, 'Knight', '2500', 0),
(3, 'Bishop', '10000', 0),
(4, 'Rook', '25000', 0),
(5, 'Queen', '50000', 0),
(6, 'King', '100000', 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_macros`
--

CREATE TABLE `avis_macros` (
  `macro_id` int(11) NOT NULL AUTO_INCREMENT,
  `macro_title` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT '0',
  `sla` int(11) DEFAULT '0',
  `type` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `priority` int(11) DEFAULT '0',
  `owner` text,
  `labels` text,
  `tags` text,
  `comment` text,
  `post_content` text,
  `staff_id` int(11) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `category_id` int(11) DEFAULT '0',
  `subcategory_id` int(11) DEFAULT '0',
  `item_id` int(11) DEFAULT '0',
  `level_id` int(11) DEFAULT '0',
  `location_id` int(11) DEFAULT '0',
  `access` int(10) DEFAULT '0',
  `flag_id` int(10) DEFAULT '0',
  `urgency` int(11) NOT NULL,
  `impact` int(11) NOT NULL,
  `domain` int(11) NOT NULL,
  `risktype` int(11) NOT NULL,
  `changetype` int(11) NOT NULL,
  `releasetype` int(11) NOT NULL,
  `knownerror` varchar(100) NOT NULL,
  `module` int(11) NOT NULL,
  PRIMARY KEY (`macro_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_mailqueue`
--

CREATE TABLE `avis_mailqueue` (
  `mailqueue_id` int(15) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `mailqueue_type` int(3) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `port_number` int(4) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `override_name` varchar(255) DEFAULT NULL,
  `override_email` varchar(255) DEFAULT NULL,
  `signature` text,
  `registered_client` tinyint(1) DEFAULT '0',
  `fetch_count` int(15) DEFAULT '20',
  `last_count` int(15) DEFAULT '0',
  `can_delete` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `forward_email_flag` tinyint(1) NOT NULL DEFAULT '0',
  `forward_email` varchar(255) DEFAULT NULL,
  `redirecturl` varchar(255) DEFAULT NULL,
  `accesstoken` text,
  `refreshtoken` text,
  `tenantid` text,
  PRIMARY KEY (`mailqueue_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_module`
--

CREATE TABLE `avis_module` (
  `module_id` int(15) NOT NULL AUTO_INCREMENT,
  `module` varchar(255) DEFAULT NULL,
  `module_name` varchar(255) DEFAULT NULL,
  `header_title` varchar(255) DEFAULT NULL,
  `access_type` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `quick_view` tinyint(1) DEFAULT '0',
  `quick_view_open` tinyint(1) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `avis_module`
--

INSERT INTO `avis_module` VALUES
(1, 'home', 'Home', 'Home', 1, 1, 0, 0, 1),
(2, 'ticket', 'Incidents', 'Inbox', 1, 1, 0, 1, 1),
(3, 'client', 'Clients', 'Clients', 1, 1, 0, 0, 1),
(4, 'solutions', 'Solutions', 'Solutions', 1, 1, 0, 0, 1),
(5, 'billing', 'Billing', 'Billing', 1, 0, 0, 0, 1),
(6, 'blabber', 'Blabby', 'Blabby', 1, 1, 1, 0, 1),
(7, 'report', 'Report', 'Reports', 1, 1, 1, 0, 1),
(8, 'setting', 'Settings', 'Settings', 1, 1, 0, 0, 0),
(9, 'gamification', 'Gamification', 'Gamification', 1, 1, 0, 0, 1),
(11, 'task', 'Tasks', 'Tasks', 1, 1, 1, 1, 1),
(10, 'itil', 'ITIL', 'ITIL', 1, 1, 0, 0, 1),
(12, 'forums', 'Forums', 'Forums', 1, 1, 0, 0, 1),
(13, 'drive', 'Drive', 'Drive', 1, 1, 1, 1, 1),
(14, 'asset', 'Assets', 'Assets', 1, 1, 0, 0, 1),
(15, 'virtualagent', 'Virtual agent', 'Virtual agent', 1, 0, 0, 0, 1),
(16, 'livechat', 'Livechat', 'Livechat', 1, 0, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_module_integrate`
--

CREATE TABLE `avis_module_integrate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_hash` varchar(50) DEFAULT NULL,
  `ticket_id` int(11) DEFAULT '0',
  `type` int(11) DEFAULT '0',
  `link_id` int(11) DEFAULT '0',
  `integration_type` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_notification`
--

CREATE TABLE `avis_notification` (
  `notification_id` int(15) NOT NULL AUTO_INCREMENT,
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `parent_id` int(15) DEFAULT '0',
  `access_ids` varchar(255) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  `operation_time` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_client` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`notification_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_notification_mobile`
--

CREATE TABLE `avis_notification_mobile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT '0',
  `type` int(8) DEFAULT '0',
  `flag` int(8) DEFAULT '0',
  `area` int(8) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_order`
--

CREATE TABLE `avis_order` (
  `order_id` int(15) NOT NULL AUTO_INCREMENT,
  `order_hash` int(15) DEFAULT '0',
  `product_id` int(15) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `balance` float(10,2) DEFAULT '0.00',
  `balance_type` tinyint(1) DEFAULT '0',
  `expiry` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `order_status` int(4) NOT NULL DEFAULT '2',
  `validity` int(4) NOT NULL DEFAULT '0',
  `nextinvoicesent` int(15) NOT NULL DEFAULT '0',
  `invoiceid` int(15) DEFAULT '0',
  `invoicehash` varchar(15) DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_pages`
--

CREATE TABLE `avis_pages` (
  `page_id` int(15) NOT NULL AUTO_INCREMENT,
  `app_id` int(15) NOT NULL,
  `unique_page_id` varchar(50) NOT NULL,
  `page_name` varchar(255) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `page_access_token` text,
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_parserlog`
--

CREATE TABLE `avis_parserlog` (
  `parserlog_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `ticket_post_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `mail_report` int(15) DEFAULT '0',
  `mailqueue_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `from_email` varchar(255) DEFAULT NULL,
  `to_email` varchar(255) DEFAULT NULL,
  `channel` int(4) DEFAULT '0',
  `message_id` varchar(255) DEFAULT NULL,
  `source_type` tinyint(3) DEFAULT '0',
  `filename` varchar(255) NOT NULL,
  `status` int(11) NOT NULL COMMENT '1=Success,2=Mail-queue not exist, 3=Client email Not varified, 4=registration_required,5=Contact access,6=client register error,7=ban_client,8=client approved pending,9=Ignore email,10=Staff access,11=incident creation error',
  PRIMARY KEY (`parserlog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_parser_data`
--

CREATE TABLE `avis_parser_data` (
  `parser_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `parserlog_id` int(15) NOT NULL DEFAULT '0',
  `mail_content` longtext,
  PRIMARY KEY (`parser_data_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_pinup`
--

CREATE TABLE `avis_pinup` (
  `pin_id` int(15) NOT NULL AUTO_INCREMENT,
  `pin_title` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `pin_value` varchar(255) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `pin_image` varchar(255) DEFAULT NULL,
  `channel_id` int(11) DEFAULT '0',
  PRIMARY KEY (`pin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_points_criteria`
--

CREATE TABLE `avis_points_criteria` (
  `point_criteria_id` int(11) NOT NULL AUTO_INCREMENT,
  `point_criteria` text,
  `point_id` int(11) DEFAULT '0',
  `points` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`point_criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `avis_points_criteria`
--

INSERT INTO `avis_points_criteria` VALUES
(1, 'Fast reply (< 10 min)', 1, '5'),
(2, 'Reply within SLA time', 2, '10'),
(3, 'Overdue incident reply', 3, '0'),
(4, 'Happy customer (> 3 like) of article', 1, '10'),
(5, 'Unhappy customer (< 3 like) of article', 2, '-10'),
(6, 'Selfhelp article', 3, '5'),
(7, 'Incident - Notes', 4, '10'),
(9, 'Forum topic', 6, '10'),
(10, 'Forum topic reply', 7, '10'),
(11, 'Per chat acceptance', 8, '5');

-- --------------------------------------------------------

--
-- Table structure for table `avis_product`
--

CREATE TABLE `avis_product` (
  `product_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `balance_type` tinyint(1) DEFAULT '0',
  `balance` int(4) DEFAULT '0',
  `validity` int(4) DEFAULT '0',
  `amount` decimal(10,2) DEFAULT '0.00',
  `is_recurring` tinyint(1) DEFAULT '0',
  `tax_applied` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_quest`
--

CREATE TABLE `avis_quest` (
  `quest_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(255) NOT NULL,
  `quest_title` varchar(255) DEFAULT NULL,
  `quest_type` varchar(255) DEFAULT NULL,
  `quest_points` varchar(15) DEFAULT NULL,
  `quest_discription` text,
  `quest_status` int(11) DEFAULT '0',
  `quest_duration` varchar(100) DEFAULT NULL,
  `quest_start_date` text,
  `image_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`quest_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_quest_criteria`
--

CREATE TABLE `avis_quest_criteria` (
  `criteria_id` int(11) NOT NULL AUTO_INCREMENT,
  `quest_id` int(11) DEFAULT '0',
  `base_criteria` int(11) DEFAULT '0',
  `sub_criteria` int(11) DEFAULT '0',
  `content` text,
  `criteria_type` int(11) DEFAULT '0',
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_rating`
--

CREATE TABLE `avis_rating` (
  `rating_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `rating_type` int(8) DEFAULT '0' COMMENT '1-star,2-emoji symbol',
  `optional` varchar(255) DEFAULT NULL,
  `is_enabled` int(6) DEFAULT '0',
  PRIMARY KEY (`rating_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_rating`
--

INSERT INTO `avis_rating` VALUES
(1, 'Star Rating', 1, 'By using this setting client can rate the incident in the format of star rating.', 0),
(2, 'smiley icon', 2, 'By using this setting client can rate the incident in the format of smiley icon.', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_reminder`
--

CREATE TABLE `avis_reminder` (
  `reminder_id` int(5) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `start_date` int(20) DEFAULT '0',
  `end_date` int(20) DEFAULT '0',
  `entry_date` int(20) DEFAULT '0',
  `module_id` int(11) DEFAULT '0',
  `parent_id` int(5) DEFAULT '0',
  `staff_id` int(5) DEFAULT '0',
  `scedule_type` tinyint(1) DEFAULT '0' COMMENT '0=Never, 1 = Daily, 2=weekly, 3=monthly',
  `days` varchar(250) CHARACTER SET utf8 DEFAULT NULL COMMENT '1=sun, 2=mon, 3=tue, 4=wen, 5=thu, 6=fri, 7=sat',
  `description` text COMMENT '0=problem,1=changes,2=release',
  `is_read` int(11) NOT NULL DEFAULT '0',
  `domain_id` int(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`reminder_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_remotescreen`
--

CREATE TABLE `avis_remotescreen` (
  `remoteapp_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `remoteapp_type` int(15) DEFAULT '0',
  `user_name` varchar(255) DEFAULT NULL,
  `user_password` varchar(255) DEFAULT NULL,
  `client_id` varchar(255) DEFAULT NULL,
  `extra_info` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`remoteapp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_report`
--

CREATE TABLE `avis_report` (
  `report_id` int(15) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `query` text,
  `sortby_1` int(4) DEFAULT '1',
  `sortby_2` int(4) DEFAULT '1',
  `sortby_3` int(4) DEFAULT '1',
  `groupby_1` int(4) DEFAULT '1',
  `groupby_2` int(4) DEFAULT '1',
  `groupby_3` int(4) DEFAULT '1',
  `report_type` tinyint(2) DEFAULT '0',
  `module` tinyint(2) DEFAULT '0',
  `page_count` int(4) DEFAULT '50',
  `concate_option` enum('and','or') DEFAULT 'and',
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_report_criteria`
--

CREATE TABLE `avis_report_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `report_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(4) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_report_field`
--

CREATE TABLE `avis_report_field` (
  `field_id` int(15) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(255) DEFAULT NULL,
  `report_id` int(15) DEFAULT '0',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_request_approvals`
--

CREATE TABLE `avis_request_approvals` (
  `request_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `parent_type` int(15) DEFAULT '0' COMMENT '0=incident,1=changes,2=release',
  `description` text,
  `entrydate` int(15) DEFAULT '0',
  PRIMARY KEY (`request_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_roundrobin`
--

CREATE TABLE `avis_roundrobin` (
  `roundrobin_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `schedule_id` int(15) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  PRIMARY KEY (`roundrobin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_roundrobin_action`
--

CREATE TABLE `avis_roundrobin_action` (
  `raction_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text,
  PRIMARY KEY (`raction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_roundrobin_criteria`
--

CREATE TABLE `avis_roundrobin_criteria` (
  `rcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) NOT NULL DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`rcriteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_schedule`
--

CREATE TABLE `avis_schedule` (
  `schedule_id` int(15) NOT NULL AUTO_INCREMENT,
  `schedule_name` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `sunday_time` varchar(255) DEFAULT '0',
  `monday_time` varchar(255) DEFAULT '0, 1440',
  `tuesday_time` varchar(255) DEFAULT '0, 1440',
  `wednesday_time` varchar(255) DEFAULT '0, 1440',
  `thursday_time` varchar(255) DEFAULT '0, 1440',
  `friday_time` varchar(255) DEFAULT '0, 1440',
  `saturday_time` varchar(255) DEFAULT '0, 1440',
  PRIMARY KEY (`schedule_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_schedule`
--

INSERT INTO `avis_schedule` VALUES
(1, '24x7 schedule', 1, '0, 1440', '0, 1440', '0, 1440', '0, 1440', '0, 1440', '0, 1440', '0, 1440');

-- --------------------------------------------------------

--
-- Table structure for table `avis_schedule_report`
--

CREATE TABLE `avis_schedule_report` (
  `rschedule_id` int(11) NOT NULL AUTO_INCREMENT,
  `report_type` int(2) DEFAULT '0',
  `report_title` varchar(255) DEFAULT NULL,
  `start_date` int(15) DEFAULT '0',
  `end_date` int(15) DEFAULT '0',
  `total_recurrence` int(15) DEFAULT '0',
  `schedule_type` tinyint(4) DEFAULT '0' COMMENT '0=once,1=daily,2=weekly, 3=monthly,4=quaterly,5=yearly',
  `export_type` int(11) DEFAULT '0' COMMENT '1=csv,2=html,3=xls',
  `send_email` tinyint(4) DEFAULT '0',
  `email_id` varchar(255) DEFAULT NULL,
  `creation_date` int(15) DEFAULT '0',
  `report_filter` text,
  `date_range_filter` text,
  `domain_id` int(11) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `staff_email` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rschedule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_selfhelp_article`
--

CREATE TABLE `avis_selfhelp_article` (
  `article_id` int(15) NOT NULL AUTO_INCREMENT,
  `article_title` text,
  `article_keywords` varchar(1000) DEFAULT NULL,
  `content` longtext,
  `parent_id` int(15) DEFAULT '0',
  `can_comment` tinyint(1) DEFAULT '1',
  `can_rate` tinyint(1) DEFAULT '1',
  `is_stick` tinyint(1) DEFAULT '0',
  `auto_subscribe` tinyint(1) DEFAULT '1',
  `can_attach` tinyint(1) DEFAULT '0',
  `need_login` tinyint(1) DEFAULT '0',
  `rate_count` int(15) DEFAULT '0',
  `rating` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `modified_date` int(15) DEFAULT '0',
  `author_id` int(15) DEFAULT '0',
  `author_type` tinyint(1) DEFAULT '0',
  `author` varchar(255) DEFAULT NULL,
  `author_image` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `article_url` varchar(255) DEFAULT NULL,
  `art_parent_id` int(15) DEFAULT '0',
  `language` int(15) DEFAULT '0',
  `view_count` int(15) DEFAULT '0',
  `like_count` int(15) NOT NULL DEFAULT '0',
  `art_likes` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_selfhelp_category`
--

CREATE TABLE `avis_selfhelp_category` (
  `selfhelp_id` int(15) NOT NULL AUTO_INCREMENT,
  `selfhelp_title` varchar(255) DEFAULT NULL,
  `description` text,
  `parent_id` int(15) DEFAULT '0',
  `content_type` int(4) DEFAULT '0',
  `display_order_type` int(4) DEFAULT '0',
  `display_status` int(4) DEFAULT '0' COMMENT '5-livechat',
  `article_access` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `domain_id` int(15) DEFAULT '0',
  `language_id` int(15) DEFAULT '0',
  `solution_id` int(5) NOT NULL DEFAULT '0',
  `client_display` varchar(100) DEFAULT NULL,
  `org_display` varchar(100) DEFAULT NULL,
  `display_order` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`selfhelp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_selfhelp_category`
--

INSERT INTO `avis_selfhelp_category` VALUES
(1, 'Knowledgebase', '', 0, 0, 0, 0, 0, 1, 1, 1, 0, '', '', 0),
(2, 'Downloads', '', 0, 0, 0, 0, 0, 1, 1, 1, 0, '', '', 0),
(3, 'Livechat canned responses', 'Livechat canned responses', 0, 0, 0, 5, 0, 1, 1, 1, 0, '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_selfhelp_comment`
--

CREATE TABLE `avis_selfhelp_comment` (
  `comment_id` int(15) NOT NULL AUTO_INCREMENT,
  `article_id` int(15) DEFAULT '0',
  `poster_id` int(15) DEFAULT '0',
  `poster_name` varchar(255) DEFAULT NULL,
  `poster_email` varchar(255) DEFAULT NULL,
  `poster_type` tinyint(1) DEFAULT '0',
  `content` text,
  `is_publish` tinyint(1) DEFAULT '1',
  `poster_image` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_sendmail_queue`
--

CREATE TABLE `avis_sendmail_queue` (
  `queue_id` int(15) NOT NULL AUTO_INCREMENT,
  `content` longtext CHARACTER SET utf8,
  `operation` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `staff_id` int(15) NOT NULL,
  `location` int(15) NOT NULL,
  `flag` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_sent_mail_log`
--

CREATE TABLE `avis_sent_mail_log` (
  `sent_mail_id` int(15) NOT NULL AUTO_INCREMENT,
  `mail_from` varchar(123) DEFAULT NULL,
  `mail_to` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `content` text,
  `mail_type` int(4) DEFAULT '0',
  `mail_status` tinyint(1) DEFAULT '0',
  `failure_reason` text,
  `send_date` int(15) DEFAULT '0',
  `mail_cc` varchar(255) DEFAULT NULL,
  `mail_bcc` varchar(255) DEFAULT NULL,
  `department_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  PRIMARY KEY (`sent_mail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_sessions`
--

CREATE TABLE `avis_sessions` (
  `session_id` varchar(63) DEFAULT NULL,
  `user_id` int(15) DEFAULT '0',
  `ip` varchar(31) DEFAULT NULL,
  `session_type` tinyint(2) DEFAULT '0',
  `last_operation` int(15) DEFAULT '0',
  `logintime` int(15) DEFAULT '0',
  `crontime` int(15) DEFAULT '0',
  `useragent` varchar(255) DEFAULT NULL,
  `referer` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `avis_settings`
--

CREATE TABLE `avis_settings` (
  `setting_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=64 ;

--
-- Dumping data for table `avis_settings`
--

INSERT INTO `avis_settings` VALUES
(1, 'language_id', '1', 0, 0, 0),
(2, 'last_mailqueue', '0', 0, 0, 0),
(3, 'mailqueue_count', '20', 0, 0, 0),
(4, 'vis_first_time_login', '3', 0, 0, 0),
(5, 'vis_queue_outgoing_mail_status', '0', 0, 0, 0),
(6, 'vis_show_email_tracking', '1', 0, 0, 0),
(7, 'vis_captcha', '1', 0, 0, 4),
(8, 'vis_captcha', '1', 1, 0, 4),
(9, 'vis_approve', '1', 0, 0, 12),
(10, 'vis_approve', '1', 1, 0, 12),
(11, 'vis_head_menu_selfhelp', '1', 1, 0, 0),
(12, 'vis_head_menu_submitticket', '1', 1, 0, 0),
(13, 'vis_head_menu_viewticket', '1', 1, 0, 0),
(14, 'vis_head_menu_login', '1', 1, 0, 0),
(15, 'vis_head_menu_register', '1', 1, 0, 0),
(16, 'vis_head_menu_service', '1', 1, 0, 0),
(17, 'vis_head_menu_forum', '1', 1, 0, 0),
(18, 'vis_head_menu_rating', '1', 1, 0, 0),
(19, 'vis_head_menu_staffNm', '1', 1, 0, 0),
(20, 'vis_head_menu_close_ticket', '1', 1, 0, 0),
(21, 'vis_head_menu_solution_ticket_search', '1', 1, 0, 0),
(22, 'vis_manage_logo', 'image', 1, 0, 0),
(23, 'vis_datetime_format', 'M-jS, Y G:i', 1, 0, 0),
(24, 'vis_satellite_helpdesk', '1', 0, 0, 0),
(25, 'vis_default_home_operation', 'selfhelp:home', 1, 0, 0),
(26, 'vis_theme_color', '#177bbb', 1, 0, 0),
(27, 'vis_default_page_after_login', 'selfhelp:home', 1, 0, 0),
(28, 'vis_suggetion', '3', 1, 0, 4),
(29, 'vis_allow_comments', '1', 1, 0, 4),
(30, 'vis_allow_ratings', '1', 1, 0, 4),
(31, 'vis_task_list_count', '5', 0, 0, 11),
(32, 'vis_task_mail_send', '1', 0, 0, 11),
(33, 'vis_staff_access_all', 'on', 1, 0, 12),
(34, 'vis_forum_staff', '0', 1, 0, 12),
(35, 'vis_operation', 'add_module', 0, 0, 13),
(36, 'vis_module', 'setting', 0, 0, 13),
(37, 'vis_module_name', 'drive', 0, 0, 13),
(38, 'vis_module_title', 'Drive', 0, 0, 13),
(39, 'vis_headtitle', 'Drive', 0, 0, 13),
(40, 'vis_drive_list_count', '5', 0, 0, 13),
(41, 'vis_drive_status', 'on', 0, 0, 13),
(42, 'vis_show_time_track_amount', '1', 0, 0, 2),
(43, 'vis_last_cron_time', NULL, 0, 0, 0),
(44, 'vis_show_urgency', '0', 1, 0, 2),
(45, 'vis_customreport_setting', '0', 0, 0, 0),
(46, 'vis_selfhelp_title_sugg', '1', 1, 0, 4),
(47, 'vis_security_password_expiry', '90', 0, 0, 0),
(48, 'vis_security_password_reset', '0', 0, 0, 0),
(49, 'vis_api_ipcheck', '0', 0, 0, 0),
(50, 'vis_force_ip_ban', '0', 0, 0, 0),
(51, 'vis_incorrect_login_attempts', '3', 0, 0, 0),
(52, 'attachment_enable_staff', '1', 1, 0, 16),
(53, 'attachment_enable_visitor', '0', 1, 0, 16),
(54, 'enter_issend', '1', 0, 0, 16),
(55, 'search_article', '1', 1, 0, 16),
(56, 'vis_selfhelp_title_sugg', '1', 1, 0, 16),
(57, 'vis_selfhelp_keyword_sugg', '1', 1, 0, 16),
(58, 'endchat_ticket_status_setting', '0', 1, 0, 16),
(59, 'vis_cal_time_track', '1', 1, 0, 16),
(60, 'vis_new_message_file', 'new_message.mp3###new_message.mp3', 1, 0, 16),
(61, 'vis_new_chat_file', 'new_chat.mp3###new_chat.mp3', 1, 0, 16),
(62, 'vis_new_visitor_file', 'new_visitor.mp3###new_visitor.mp3', 1, 0, 16),
(63, 'vis_send_receive_msg_file', 'send_receive_msg.mp3###send_receive_msg.mp3', 1, 0, 16);

-- --------------------------------------------------------

--
-- Table structure for table `avis_signature`
--

CREATE TABLE `avis_signature` (
  `signature_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `content` text,
  `is_forum` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`signature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_single_login`
--

CREATE TABLE `avis_single_login` (
  `single_login_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `login_type` int(15) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `db_name` varchar(255) DEFAULT NULL,
  `db_password` varchar(255) DEFAULT NULL,
  `db_prefix` varchar(31) DEFAULT NULL,
  `vis_metadata` text,
  `is_enabled` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`single_login_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_sla`
--

CREATE TABLE `avis_sla` (
  `sla_id` int(15) NOT NULL AUTO_INCREMENT,
  `sla_name` varchar(255) DEFAULT NULL,
  `overdue_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `schedule_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`sla_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_sla`
--

INSERT INTO `avis_sla` VALUES
(1, 'Default', 720, 1440, 1, 1),
(2, '5 Days SLA', 7200, 7200, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_smtpmail`
--

CREATE TABLE `avis_smtpmail` (
  `smtp_id` int(15) NOT NULL AUTO_INCREMENT,
  `smtp_port` int(4) DEFAULT '25',
  `smtp_host` varchar(255) DEFAULT NULL,
  `smtp_user` varchar(255) DEFAULT NULL,
  `smtp_password` varchar(255) DEFAULT NULL,
  `smtp_ssl` tinyint(2) DEFAULT '0',
  `authentication` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_id` varchar(255) DEFAULT NULL,
  `client_id` varchar(255) NOT NULL,
  `smtp_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=None 1=Outh2',
  `redirect_url` varchar(500) NOT NULL,
  `access_token` text NOT NULL,
  `expires_in` varchar(50) NOT NULL,
  `refresh_token` text NOT NULL,
  `created_on` varchar(50) NOT NULL,
  `tenantid` text NOT NULL,
  PRIMARY KEY (`smtp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_social_search`
--

CREATE TABLE `avis_social_search` (
  `search_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `media_type` int(4) DEFAULT '0',
  `content` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `status` tinyint(1) DEFAULT '0',
  `channel_id` int(15) DEFAULT '0',
  PRIMARY KEY (`search_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_staff`
--

CREATE TABLE `avis_staff` (
  `staff_id` int(15) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `initials` varchar(15) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `group_id` int(15) DEFAULT '0',
  `contact_number` varchar(255) DEFAULT NULL,
  `mobile_number` varchar(255) DEFAULT NULL,
  `temporary_address` text,
  `permanent_address` text,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip_code` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `website` text,
  `fax` varchar(255) DEFAULT NULL,
  `office_name` varchar(255) DEFAULT NULL,
  `office_email` varchar(255) DEFAULT NULL,
  `office_website` varchar(255) DEFAULT NULL,
  `other_contact_no` varchar(255) DEFAULT NULL,
  `other_fax` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `gender` tinyint(1) DEFAULT '0',
  `birthdate` int(15) DEFAULT '0',
  `netmeetingid` varchar(255) DEFAULT NULL,
  `other_im` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `session_time` int(4) DEFAULT '30',
  `timezone` varchar(6) DEFAULT '0',
  `timezone_dst` tinyint(1) DEFAULT '0',
  `sound_alert` tinyint(1) DEFAULT '1',
  `html_editor` tinyint(1) DEFAULT '1',
  `theme` varchar(255) DEFAULT 'nature',
  `image_name` varchar(255) DEFAULT NULL,
  `department_access` varchar(255) DEFAULT '0',
  `level_id` int(11) DEFAULT '0',
  `staff_point` varchar(15) DEFAULT '0',
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `google_id` varchar(255) DEFAULT NULL,
  `linkedin_id` varchar(255) DEFAULT NULL,
  `timezone_name` text,
  `password_auth` int(3) DEFAULT '0',
  `api_key` varchar(255) DEFAULT NULL,
  `schedule_id` int(12) DEFAULT '0',
  `roles` varchar(255) NOT NULL,
  `module` varchar(255) NOT NULL,
  `access` longtext NOT NULL,
  `is_cab` tinyint(2) NOT NULL DEFAULT '0',
  `leftview_setting` int(12) DEFAULT '0',
  `collapse_setting` tinyint(2) NOT NULL DEFAULT '0',
  `is_google_verify` tinyint(1) NOT NULL DEFAULT '0',
  `google_auth_code` varchar(255) NOT NULL,
  `authbackup` varchar(255) NOT NULL,
  `pwdupdatedon` int(15) DEFAULT '0',
  `chat_access` tinyint(1) DEFAULT '0',
  `is_chat_status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0=offline,1=online,2=busy,3=away',
  `is_acceptance` tinyint(2) NOT NULL DEFAULT '0',
  `is_show_profile` tinyint(2) NOT NULL DEFAULT '1',
  `chat_welcome_msg` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `max_chat_limit` int(15) DEFAULT '0',
  `product` tinyint(5) DEFAULT '0',
  `autobusy` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1=manual,0= auto',
  PRIMARY KEY (`staff_id`),
  KEY `group_id` (`group_id`),
  KEY `is_enabled` (`is_enabled`,`department_access`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_staff`
--

INSERT INTO `avis_staff` VALUES
(1, '[[admin_fname]]', '[[admin_lname]]', NULL, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, 1, 30, '0', 0, 1, 1, 'nature', NULL, '0', 0, '0', NULL, NULL, NULL, NULL, 'London, Monrovia, Nouakchott, Ouagadougou, Reykjavik, Sao Tome, St Helena', 0, NULL, 1, '1', '1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0', '{"0":"0","1":"1","2":"1","3":"1","4":"1","5":"1","6":"1","7":"1","8":"1","9":"1","10":"1","11":"1","12":"1","13":"1","14":"1","15":"1","16":"1","17":"1","18":"0","19":"0","20":"1","21":"1","22":"1","23":"0","24":"1","25":"1","26":"1","27":"1","28":"1","29":"1","30":"1","31":"1","32":"1","33":"1","34":"1","35":"1","36":"1","37":"1","38":"1","39":"1","40":"1","41":"1","42":"1","43":"1","44":"1","45":"1","46":"1","47":"0","48":"0","49":"0","50":"0","51":"0","52":"0","53":"0","54":"0","55":"0","56":"1","57":"1","58":"1","59":"1","60":"1","61":"1","62":"1","63":"1","64":"1","65":"1","66":"1","67":"1","68":"1","69":"0","70":"0","71":"0","72":"0","73":"0","74":"0","75":"0","76":"0","77":"0","78":"0","79":"1","80":"1","81":"1","82":"1","83":"1","84":"1","85":"1","86":"1","87":"1","88":"1","89":"1","90":"0","91":"0","92":"0","93":"0","94":"0","95":"0","96":"0","97":"0","98":"0","99":"0","100":"0","101":"0","102":"0","103":"1","104":"1","105":"1","106":"1","107":"1","108":"1","109":"1","110":"1","111":"1","112":"1","113":"1","114":"1","115":"1","116":"1","117":"1","118":"1","119":"1","120":"1","121":"1","122":"0","123":"1","124":"1","125":"1","126":"1","127":"1","128":"1","129":"1","130":"0","131":"1","132":"1","133":"1","134":"1","135":"1","136":"1","137":"1","138":"1","139":"1","140":"1","141":"1","142":"1","143":"1","144":"1","145":"1","146":"1","147":"1","148":"1","149":"1","150":"1","151":"1","152":"1","153":"1","154":"1","155":"1","156":"1","157":"1","158":"1","159":"1","160":"1","161":"1","162":"1","163":"1","164":"1","165":"1","166":"1","167":"1","168":"1","169":"1","170":"1","171":"1","172":"1","173":"1","174":"1","175":"1","176":"1","177":"1","178":"1","179":"1","180":"1","181":"1","182":"1","183":"1","184":"1","185":"1","186":"1","187":"1","188":"1","189":"0","190":"0","191":"0","192":"0","193":"0","194":"0","195":"0","196":"0","197":"0","198":"0","199":"0","200":"0","201":"0","202":"0"}', 0, 0, 0, 0, '', '', [[timestamp]], 1, 1, 0, 1, 'Welcome {clientfirstname}, How may I help you today?', '', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_staff_badge`
--

CREATE TABLE `avis_staff_badge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quest_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_staff_domain_mapping`
--

CREATE TABLE `avis_staff_domain_mapping` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_staff_domain_mapping`
--

INSERT INTO `avis_staff_domain_mapping` VALUES
(1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_staff_group`
--

CREATE TABLE `avis_staff_group` (
  `group_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access` longtext,
  `module` varchar(32) DEFAULT NULL,
  `department_access` text,
  `schedule_id` int(12) DEFAULT '0',
  `product_id` int(15) DEFAULT '0',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `avis_staff_group`
--

INSERT INTO `avis_staff_group` VALUES
(1, 'Default', 1, '0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0', '1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0', '0', 0, 0),
(2, 'Incident management', 1, '0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 0),
(3, 'Change management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 5),
(4, 'Problem management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 5),
(5, 'Release management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 5),
(6, 'Asset management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 4);

-- --------------------------------------------------------

--
-- Table structure for table `avis_staff_notification`
--

CREATE TABLE `avis_staff_notification` (
  `staff_notification_id` varchar(255) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `parent_id` int(15) DEFAULT '0',
  `access_ids` varchar(255) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  `operation_time` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_client` tinyint(4) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  `is_read` int(15) DEFAULT '0',
  `dashborad_read` int(15) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `avis_subaccount_settings`
--

CREATE TABLE `avis_subaccount_settings` (
  `subaccount_setting_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `setting_id` int(15) DEFAULT '0',
  `is_set` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`subaccount_setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_task`
--

CREATE TABLE `avis_task` (
  `task_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_title` varchar(255) DEFAULT NULL,
  `description` text,
  `startdate` text,
  `enddate` text,
  `task_status` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `task_repeat_schedule` int(15) DEFAULT '0',
  `task_repeat_occurence` varchar(255) DEFAULT NULL,
  `owner_favourite` varchar(255) DEFAULT NULL,
  `parent_id` int(20) DEFAULT '0',
  `is_repeat` int(11) NOT NULL DEFAULT '0',
  `recurrence_flag` int(11) NOT NULL DEFAULT '0',
  `task_email_flag` int(11) NOT NULL DEFAULT '0',
  `autotask_flag` tinyint(1) NOT NULL DEFAULT '0',
  `autotask_id` int(15) DEFAULT '0',
  `ticket_id` int(15) DEFAULT '0',
  `auto_parent_id` int(15) DEFAULT '0',
  `task_hash` varchar(255) DEFAULT NULL,
  `rectask_title` varchar(255) DEFAULT NULL,
  `task_schedule_hrs` int(15) DEFAULT '0',
  `urgency` int(11) NOT NULL DEFAULT '0',
  `impact` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_taskauditlog`
--

CREATE TABLE `avis_taskauditlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_hash` varchar(15) DEFAULT NULL,
  `task_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_task_assign`
--

CREATE TABLE `avis_task_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_task_comment`
--

CREATE TABLE `avis_task_comment` (
  `comment_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_id` int(15) DEFAULT '0',
  `content` text,
  `entry_date` int(15) DEFAULT '0',
  `owner` int(15) DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_tax`
--

CREATE TABLE `avis_tax` (
  `tax_id` int(4) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `tax_name` varchar(255) DEFAULT NULL,
  `exec_order` int(4) DEFAULT '0',
  `tax_type` tinyint(1) DEFAULT '0',
  `rate` decimal(10,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) DEFAULT '1',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`tax_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_tax_setting`
--

CREATE TABLE `avis_tax_setting` (
  `stax_id` int(4) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `tax_stype` tinyint(1) NOT NULL DEFAULT '0',
  `tax_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `compound_tax` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stax_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_team_access`
--

CREATE TABLE `avis_team_access` (
  `team_id` int(15) NOT NULL AUTO_INCREMENT,
  `team_name` varchar(255) NOT NULL,
  `department_access` varchar(255) NOT NULL,
  `schedule_id` int(12) NOT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`team_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_team_access`
--

INSERT INTO `avis_team_access` VALUES
(1, 'Default', '0', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket`
--

CREATE TABLE `avis_ticket` (
  `ticket_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `subject` text,
  `channel_id` int(15) DEFAULT '1',
  `type_id` int(4) NOT NULL DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `flag_id` int(15) DEFAULT '1',
  `language_id` int(15) DEFAULT '1',
  `attachment_count` int(15) DEFAULT '0',
  `post_count` int(15) DEFAULT '0',
  `last_replier_name` varchar(255) DEFAULT NULL,
  `last_replier_time` int(15) NOT NULL DEFAULT '0',
  `last_replier_email` varchar(255) DEFAULT NULL,
  `last_replier_id` varchar(511) DEFAULT NULL,
  `slaplan_id` int(15) DEFAULT '0',
  `due_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `source_from` tinyint(4) DEFAULT '0',
  `user_replied` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  `is_read` tinyint(1) DEFAULT '0',
  `is_deleted` tinyint(2) DEFAULT '0',
  `is_important` tinyint(1) DEFAULT '0',
  `recipients` text,
  `people` text,
  `draft_id` int(15) DEFAULT '0',
  `rating` int(4) DEFAULT '0',
  `integration_link` varchar(255) DEFAULT NULL,
  `schedule_id` int(15) DEFAULT '0',
  `level_id` int(15) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `closed_time` varchar(30) DEFAULT NULL,
  `pause_dtime` varchar(255) DEFAULT NULL,
  `pause_rtime` varchar(255) DEFAULT NULL,
  `sla_schedule_id` int(11) DEFAULT '0',
  `owner` varchar(255) DEFAULT NULL,
  `message_id` text,
  `applyslarespo_time` int(15) NOT NULL DEFAULT '0',
  `applyslaresol_time` int(15) NOT NULL DEFAULT '0',
  `urgency_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `impact_details` tinytext NOT NULL,
  `reason_for_closer` longtext,
  `priority_justification` longtext,
  `symptoms` longtext,
  `is_archive` tinyint(1) DEFAULT '0',
  `mode_of_contact` int(15) DEFAULT '0' COMMENT '1-mail,2-call,3-web portal',
  `is_dm` tinyint(4) NOT NULL DEFAULT '0',
  `asset_id` int(15) DEFAULT '0',
  PRIMARY KEY (`ticket_id`),
  UNIQUE KEY `ticket_hash_2` (`ticket_hash`),
  KEY `ticket_hash` (`ticket_hash`,`domain_id`),
  KEY `department_id` (`department_id`,`channel_id`,`flag_id`,`language_id`),
  KEY `is_spam` (`status_id`,`is_spam`,`is_deleted`,`draft_id`,`department_id`,`client_id`),
  KEY `receive_date` (`receive_date`,`modify_date`,`due_time`,`resolution_time`),
  KEY `client_id` (`client_id`),
  KEY `last_replier_id` (`last_replier_id`(255))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_ticket`
--

INSERT INTO `avis_ticket` VALUES
(2, 'ZSYJ-432161', 1, 1, 1, 1, 'Sample internal incident', 1, 1, [[timestamp]], [[timestamp]], 0, 1, 1, 0, 1, 'Administrator', 0, 'admin@test.com', '1', 1, 0, 0, 0, 0, 0, 0, 0, 0, NULL, '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', '', 0, '', '', 0, 0, 1, 1, 'Low impact remark', NULL, NULL, NULL, 0, 0, 0, 0),
(1, 'DEDU-770596', 1, 1, 1, 1, 'Sample incident', 5, 1, [[timestamp]], [[timestamp]], 1, 1, 1, 0, 1, 'Sample Customer', 0, 'customer@iamdemo.com', '1', 1, 0, 0, 0, 1, 0, 0, 0, 0, 'customer@iamdemo.com', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', '', 0, '', '', 0, 0, 1, 1, 'Low impact remark', NULL, NULL, NULL, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_approvals`
--

CREATE TABLE `avis_ticket_approvals` (
  `approvals_id` int(11) NOT NULL AUTO_INCREMENT,
  `approvals_type` tinyint(2) DEFAULT '0',
  `parent_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `approvals_status` tinyint(2) DEFAULT '0' COMMENT '0-requested, 1-approved, 2-cancelled, 3-rejected',
  `send_date` varchar(20) DEFAULT NULL,
  `status_date` varchar(20) DEFAULT NULL,
  `remark` text,
  `is_enabled` int(11) DEFAULT '0',
  `request_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  `user_type` tinyint(2) NOT NULL DEFAULT '0' COMMENT 'default 0= Staff ,1=client',
  `is_ignore` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1=ignored',
  PRIMARY KEY (`approvals_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_archive`
--

CREATE TABLE `avis_ticket_archive` (
  `ticket_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `subject` text,
  `channel_id` int(15) DEFAULT '1',
  `type_id` int(4) NOT NULL DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `flag_id` int(15) DEFAULT '1',
  `language_id` int(15) DEFAULT '1',
  `attachment_count` int(15) DEFAULT '0',
  `post_count` int(15) DEFAULT '0',
  `last_replier_name` varchar(255) DEFAULT NULL,
  `last_replier_time` int(15) NOT NULL DEFAULT '0',
  `last_replier_email` varchar(255) DEFAULT NULL,
  `last_replier_id` varchar(511) DEFAULT NULL,
  `slaplan_id` int(15) DEFAULT '0',
  `due_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `source_from` tinyint(4) DEFAULT '0',
  `user_replied` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  `is_read` tinyint(1) DEFAULT '0',
  `is_deleted` tinyint(2) DEFAULT '0',
  `is_important` tinyint(1) DEFAULT '0',
  `recipients` text,
  `people` text,
  `draft_id` int(15) DEFAULT '0',
  `rating` int(4) DEFAULT '0',
  `integration_link` varchar(255) DEFAULT NULL,
  `schedule_id` int(15) DEFAULT '0',
  `level_id` int(15) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `closed_time` varchar(30) DEFAULT NULL,
  `pause_dtime` varchar(255) DEFAULT NULL,
  `pause_rtime` varchar(255) DEFAULT NULL,
  `sla_schedule_id` int(11) DEFAULT '0',
  `owner` varchar(255) DEFAULT NULL,
  `message_id` text,
  `applyslarespo_time` int(15) NOT NULL DEFAULT '0',
  `applyslaresol_time` int(15) NOT NULL DEFAULT '0',
  `urgency_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `impact_details` tinytext NOT NULL,
  `reason_for_closer` longtext,
  `priority_justification` longtext,
  `symptoms` longtext,
  `is_archive` tinyint(1) DEFAULT '0',
  `mode_of_contact` int(15) DEFAULT '0' COMMENT '1-mail,2-call,3-web portal',
  `is_dm` tinyint(4) NOT NULL DEFAULT '0',
  `asset_id` int(15) DEFAULT '0',
  PRIMARY KEY (`ticket_id`),
  KEY `ticket_hash` (`ticket_hash`,`domain_id`),
  KEY `department_id` (`department_id`,`channel_id`,`flag_id`,`language_id`),
  KEY `is_spam` (`status_id`,`is_spam`,`is_deleted`,`draft_id`,`department_id`,`client_id`),
  KEY `receive_date` (`receive_date`,`modify_date`,`due_time`,`resolution_time`),
  KEY `client_id` (`client_id`),
  KEY `last_replier_id` (`last_replier_id`(255))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_assign`
--

CREATE TABLE `avis_ticket_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  `team_id` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_id`),
  UNIQUE KEY `ticket_owner` (`ticket_id`,`owner_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_ticket_assign`
--

INSERT INTO `avis_ticket_assign` VALUES
(1, 1, 0, 0),
(2, 2, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_category`
--

CREATE TABLE `avis_ticket_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_ticket_category`
--

INSERT INTO `avis_ticket_category` VALUES
(1, 0, 1, '0', 1, '0', '0', '0', '0'),
(2, 0, 2, '0', 1, '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_count`
--

CREATE TABLE `avis_ticket_count` (
  `department_id` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `total_count` int(15) DEFAULT '0',
  `group_id` int(15) DEFAULT '0',
  UNIQUE KEY `department_id` (`department_id`,`status_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_flag`
--

CREATE TABLE `avis_ticket_flag` (
  `flag_id` int(15) NOT NULL AUTO_INCREMENT,
  `flag_color` varchar(63) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`flag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_ticket_flag`
--

INSERT INTO `avis_ticket_flag` VALUES
(1, '#ffffff', 1, 1, 1, 0, '0'),
(2, '#00ff00', 1, 2, 1, 0, '0'),
(3, '#ff0000', 1, 3, 1, 0, '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_item`
--

CREATE TABLE `avis_ticket_item` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `subcategory_id` int(11) DEFAULT '0',
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `avis_ticket_item`
--

INSERT INTO `avis_ticket_item` VALUES
(1, 1, 0, 1, 1),
(2, 1, 0, 1, 2),
(3, 1, 0, 1, 3),
(4, 2, 0, 1, 4),
(5, 2, 0, 1, 5),
(6, 2, 0, 1, 6),
(7, 3, 0, 1, 7),
(8, 3, 0, 1, 8);

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_level`
--

CREATE TABLE `avis_ticket_level` (
  `level_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` tinyint(4) NOT NULL DEFAULT '0',
  `department_access` varchar(511) NOT NULL DEFAULT '0',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_ticket_level`
--

INSERT INTO `avis_ticket_level` VALUES
(1, 0, 1, 1, '0', '0', '0', '0', '0'),
(2, 0, 1, 2, '0', '0', '0', '0', '0'),
(3, 0, 1, 3, '0', '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_link`
--

CREATE TABLE `avis_ticket_link` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_ticket_id` int(11) DEFAULT '0',
  `link_type` tinyint(1) DEFAULT '0' COMMENT '1-relates to, 2-is related to, 3-is a parent of, 4-is a child of, 5-depends on, 6-is depended on, 7-duplicates, 8-is duplicated by,9-is clone of',
  `ticket_ids` text COMMENT 'Comma separated incident ids',
  `id_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Incident, 1-Problem',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_post`
--

CREATE TABLE `avis_ticket_post` (
  `post_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `content` longtext,
  `modify_date` int(15) DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `submitter_name` varchar(255) DEFAULT NULL,
  `submitter_email` varchar(255) DEFAULT NULL,
  `submitter` tinyint(1) DEFAULT '0' COMMENT '0-client, 1-staff',
  `submitter_id` int(15) DEFAULT '0',
  `ipaddress` varchar(63) DEFAULT NULL,
  `commentid` varchar(200) DEFAULT NULL,
  `forward` varchar(255) DEFAULT NULL,
  `read_mark` tinyint(1) DEFAULT '0',
  `is_visible` tinyint(1) DEFAULT '1',
  `draft_id` int(15) DEFAULT '0',
  `from_dept_email` varchar(100) DEFAULT NULL,
  `receiver_to` text,
  `receiver_cc` text,
  `receiver_bcc` text,
  `apply_macro` int(11) DEFAULT '0',
  `reply_forward` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-reply, 2-forward',
  `received_via` tinyint(1) DEFAULT '0' COMMENT '1-portal, 2-email, 3-api',
  `as_client` tinyint(1) DEFAULT '0' COMMENT '1-vis_as_client',
  `integration_link` varchar(255) DEFAULT NULL,
  `mail_id` int(15) DEFAULT '0',
  `email_status` varchar(255) DEFAULT NULL,
  `is_resolution` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1=yes',
  `chat_id` int(11) NOT NULL DEFAULT '0',
  `plain_content` longtext,
  `missed_chat` int(11) NOT NULL DEFAULT '0',
  `working_time` int(15) NOT NULL DEFAULT '0',
  `sla_maintain` int(15) NOT NULL DEFAULT '0',
  `is_dm` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_ticket_post`
--

INSERT INTO `avis_ticket_post` VALUES
(1, 2, 'This is sample incident message.<br>', NULL, [[timestamp]], 'Administrator', 'admin@test.com', 0, 1, '127.0.0.1', NULL, NULL, 0, 1, 0, 'Vision helpdesk <admin@test.com>', '', '', '', 0, 0, 1, 0, '', 0, NULL, 0, 0, NULL, 0, 0, 0, 0),
(2, 1, 'This is sample incident message', NULL, [[timestamp]], 'Sample Customer', 'customer@iamdemo.com', 1, 1, '127.0.0.1', NULL, NULL, 0, 1, 0, '', 'General', '', '', 0, 0, 1, 0, '', 0, NULL, 0, 0, NULL, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_post_archive`
--

CREATE TABLE `avis_ticket_post_archive` (
  `post_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `content` longtext,
  `modify_date` int(15) DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `submitter_name` varchar(255) DEFAULT NULL,
  `submitter_email` varchar(255) DEFAULT NULL,
  `submitter` tinyint(1) DEFAULT '0' COMMENT '0-client, 1-staff',
  `submitter_id` int(15) DEFAULT '0',
  `ipaddress` varchar(63) DEFAULT NULL,
  `commentid` varchar(200) DEFAULT NULL,
  `forward` varchar(255) DEFAULT NULL,
  `read_mark` tinyint(1) DEFAULT '0',
  `is_visible` tinyint(1) DEFAULT '1',
  `draft_id` int(15) DEFAULT '0',
  `from_dept_email` varchar(100) DEFAULT NULL,
  `receiver_to` text,
  `receiver_cc` text,
  `receiver_bcc` text,
  `apply_macro` int(11) DEFAULT '0',
  `reply_forward` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-reply, 2-forward',
  `received_via` tinyint(1) DEFAULT '0' COMMENT '1-portal, 2-email, 3-api',
  `as_client` tinyint(1) DEFAULT '0' COMMENT '1-vis_as_client',
  `integration_link` varchar(255) DEFAULT NULL,
  `mail_id` int(15) DEFAULT '0',
  `email_status` varchar(255) DEFAULT NULL,
  `is_resolution` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1=yes',
  `chat_id` int(11) NOT NULL DEFAULT '0',
  `plain_content` longtext,
  `missed_chat` int(11) NOT NULL DEFAULT '0',
  `working_time` int(15) NOT NULL DEFAULT '0',
  `sla_maintain` int(15) NOT NULL DEFAULT '0',
  `is_dm` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_priority`
--

CREATE TABLE `avis_ticket_priority` (
  `priority_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(25) DEFAULT '#788288',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`priority_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_ticket_priority`
--

INSERT INTO `avis_ticket_priority` VALUES
(1, '', 1, 0, 1, 1, '#008000', '0', '0', '0', '0', '0'),
(2, '', 1, 0, 2, 1, '#FF9911', '0', '0', '0', '0', '0'),
(3, '', 1, 0, 3, 1, '#FFA500', '0', '0', '0', '0', '0'),
(4, '', 1, 0, 4, 1, '#FF0000', '0', '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_remark`
--

CREATE TABLE `avis_ticket_remark` (
  `remark_id` int(15) NOT NULL AUTO_INCREMENT,
  `remark_type` int(4) DEFAULT '0' COMMENT '3-problem,4-change,5-release',
  `remark_subtype` int(4) DEFAULT '0',
  `remark_method` int(1) NOT NULL DEFAULT '0' COMMENT '0 for comment, 1 for error',
  `parent_id` int(15) DEFAULT '0',
  `content` text,
  `staff_id` int(15) DEFAULT '0',
  `remark_date` int(15) DEFAULT '0',
  `remark_header_bg_color` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`remark_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_schedule`
--

CREATE TABLE `avis_ticket_schedule` (
  `schedule_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT '0',
  `startdate` int(15) DEFAULT '0',
  `enddate` int(15) DEFAULT '0',
  `scedule_type` tinyint(1) DEFAULT '0' COMMENT '0=Never, 1 = Daily, 2=weekly, 3=monthly',
  `days` varchar(250) DEFAULT NULL COMMENT '1=sun, 2=mon, 3=tue, 4=wen, 5=thu, 6=fri, 7=sat',
  `creation_date` int(11) DEFAULT '0' COMMENT 'time stamp for create tickit once per day/week/month',
  `send_email` tinyint(1) DEFAULT '0' COMMENT '1=yes, 0= no',
  `auto_responder` tinyint(1) DEFAULT '0' COMMENT '1 = yes 0 = no',
  PRIMARY KEY (`schedule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_status`
--

CREATE TABLE `avis_ticket_status` (
  `status_id` int(15) NOT NULL AUTO_INCREMENT,
  `color` varchar(25) NOT NULL DEFAULT '#788288',
  `is_custom` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  `apply_sla` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `avis_ticket_status`
--

INSERT INTO `avis_ticket_status` VALUES
(1, '#008000', 1, 1, 1, 0, '0', '0', '0', '0', '0', 0),
(2, '#FF9911', 1, 2, 1, 0, '0', '0', '0', '0', '0', 0),
(3, '#FFA500', 1, 3, 1, 0, '0', '0', '0', '0', '0', 1),
(4, '#FF0000', 1, 4, 1, 0, '0', '-1', '-1', '-1', '-1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_subcategory`
--

CREATE TABLE `avis_ticket_subcategory` (
  `subcategory_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT '0',
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  PRIMARY KEY (`subcategory_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_ticket_subcategory`
--

INSERT INTO `avis_ticket_subcategory` VALUES
(1, 1, 0, 1, 1),
(2, 1, 0, 1, 2),
(3, 2, 0, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `avis_ticket_type`
--

CREATE TABLE `avis_ticket_type` (
  `type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `image` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_ticket_type`
--

INSERT INTO `avis_ticket_type` VALUES
(1, '', '', 1, 0, 1, '0', '0', '0', '0', '0'),
(2, '', '', 1, 0, 2, '0', '0', '0', '0', '0'),
(3, '', '', 1, 0, 3, '0', '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_time_tracker`
--

CREATE TABLE `avis_time_tracker` (
  `time_tracker_id` int(15) NOT NULL AUTO_INCREMENT,
  `bill_time` int(15) DEFAULT '0',
  `work_time` int(15) DEFAULT '0',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text,
  `ticket_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  `created_date` int(15) DEFAULT '0',
  `modified_date` int(15) DEFAULT '0',
  `billing_rate` int(5) DEFAULT '0',
  `credits_applied` int(2) DEFAULT '0',
  PRIMARY KEY (`time_tracker_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_token_drive`
--

CREATE TABLE `avis_token_drive` (
  `token_id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `creation_date` int(15) DEFAULT '0',
  `attach_id` int(11) DEFAULT '0',
  `attach_type` int(2) DEFAULT '0' COMMENT '0-attachment,1-drive',
  `vis_download_count` varchar(255) DEFAULT NULL,
  `vis_expiary_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`token_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_toolbar`
--

CREATE TABLE `avis_toolbar` (
  `toolbar_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `ticket_all` tinyint(1) DEFAULT '1',
  `ticket_new` tinyint(1) DEFAULT '1',
  `ticket_overdue` tinyint(1) DEFAULT '1',
  `ticket_add` tinyint(1) DEFAULT '1',
  `fitler` tinyint(1) DEFAULT '1',
  `label` tinyint(1) DEFAULT '1',
  `client_all` tinyint(1) DEFAULT '1',
  `client_add` tinyint(1) DEFAULT '1',
  `client_group` tinyint(1) DEFAULT '1',
  `client_group_add` tinyint(1) DEFAULT '1',
  `staff_profile` tinyint(1) DEFAULT '1',
  `staff_setting` tinyint(1) DEFAULT '1',
  `staff_alert` tinyint(1) DEFAULT '1',
  `staff_calendar` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`toolbar_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `avis_toolbar`
--

INSERT INTO `avis_toolbar` VALUES
(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_twilio`
--

CREATE TABLE `avis_twilio` (
  `twilio_id` int(11) NOT NULL AUTO_INCREMENT,
  `integration_id` int(11) DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `twilio_number` varchar(50) DEFAULT NULL,
  `app_sid` varchar(250) DEFAULT NULL,
  `message` varchar(250) DEFAULT NULL,
  `is_outbound` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`twilio_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_twilio_forward`
--

CREATE TABLE `avis_twilio_forward` (
  `forward_id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT '0',
  `forward_number` varchar(250) CHARACTER SET latin1 DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  PRIMARY KEY (`forward_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_twilio_staff`
--

CREATE TABLE `avis_twilio_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `twilio_id` int(11) DEFAULT '0',
  `key_press` int(11) DEFAULT '0',
  `key_messages` varchar(250) DEFAULT NULL,
  `department_id` int(11) DEFAULT '0',
  `staff` varchar(500) DEFAULT NULL,
  `forward_to` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_urgency`
--

CREATE TABLE `avis_urgency` (
  `urgency_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(25) DEFAULT '#788288',
  `department_access` varchar(255) DEFAULT '0',
  `asset_access` varchar(255) DEFAULT '0',
  `problem_access` varchar(255) DEFAULT '0',
  `changes_access` varchar(255) DEFAULT '0',
  `release_access` varchar(255) DEFAULT '0',
  PRIMARY KEY (`urgency_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `avis_urgency`
--

INSERT INTO `avis_urgency` VALUES
(1, 'Low', 1, 0, 1, 1, '#008000', '0', '0', '0', '0', '0'),
(2, 'Medium', 1, 0, 2, 1, '#FF9911', '0', '0', '0', '0', '0'),
(3, 'High', 1, 0, 3, 1, '#FF0000', '0', '0', '0', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_va_agent`
--

CREATE TABLE `avis_va_agent` (
  `va_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `domain_id` int(15) NOT NULL,
  `language_id` int(15) NOT NULL,
  `startup_text` text NOT NULL,
  `ticket_creation_text` varchar(255) NOT NULL,
  `welcome_msg` text NOT NULL,
  `closing_msg` text NOT NULL,
  `avatar_name` varchar(255) NOT NULL,
  `avatar_img` varchar(255) NOT NULL,
  `is_enable` tinyint(1) NOT NULL,
  `not_found_text` text NOT NULL,
  `va_position` int(15) NOT NULL,
  `connect_livechat` tinyint(1) NOT NULL DEFAULT '0',
  `theme_color` varchar(255) NOT NULL,
  PRIMARY KEY (`va_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_va_feedback`
--

CREATE TABLE `avis_va_feedback` (
  `fd_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `visitor_id` int(15) DEFAULT '0',
  `va_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `response` tinyint(5) DEFAULT '0' COMMENT '0-No,1-Yes',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`fd_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_va_topicflow`
--

CREATE TABLE `avis_va_topicflow` (
  `tf_id` int(15) NOT NULL AUTO_INCREMENT,
  `topic_id` int(15) NOT NULL,
  `step` int(15) NOT NULL,
  `type` int(5) NOT NULL,
  `text` text NOT NULL,
  `jumpto` int(15) NOT NULL,
  `jumpfrom` int(15) NOT NULL,
  `parent` int(15) NOT NULL,
  `field1` int(15) NOT NULL,
  `field2` int(15) NOT NULL,
  `field3` varchar(255) NOT NULL,
  `map_to` varchar(500) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_va_topics`
--

CREATE TABLE `avis_va_topics` (
  `topic_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `keywords` text NOT NULL,
  `va_id` int(15) NOT NULL,
  `active` tinyint(2) NOT NULL,
  `domain_access` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `field1` int(15) NOT NULL,
  `field2` int(15) NOT NULL,
  `field3` varchar(255) NOT NULL,
  PRIMARY KEY (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `avis_view`
--

CREATE TABLE `avis_view` (
  `view_id` int(15) NOT NULL AUTO_INCREMENT,
  `view_name` varchar(255) DEFAULT NULL,
  `display_order` int(4) DEFAULT '0',
  `owner` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `page_count` int(4) DEFAULT '0',
  `navigate_to` int(4) DEFAULT '0',
  `is_set` tinyint(1) DEFAULT '0',
  `is_default` tinyint(1) DEFAULT '0',
  `sort_by1` varchar(255) DEFAULT NULL,
  `sort_order1` enum('asc','desc') DEFAULT 'asc',
  `sort_by2` varchar(255) DEFAULT NULL,
  `sort_order2` enum('asc','desc') DEFAULT 'asc',
  `sort_by3` varchar(255) DEFAULT NULL,
  `sort_order3` enum('asc','desc') DEFAULT 'asc',
  `is_chat` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=ticket,1=chat',
  PRIMARY KEY (`view_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `avis_view`
--

INSERT INTO `avis_view` VALUES
(1, 'Default', 1, 0, 1, 20, NULL, 1, 1, 'user_replied', 'desc', 'modify_date', 'desc', 'due_time', 'asc', 0),
(2, 'Default chat view', 1, 0, 1, 20, NULL, 1, 1, '', 'asc', '', 'desc', '', 'asc', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_view_access`
--

CREATE TABLE `avis_view_access` (
  `access_id` int(15) NOT NULL AUTO_INCREMENT,
  `view_id` int(15) DEFAULT '0',
  `tab_id` int(15) DEFAULT '0',
  `sort_order` int(4) DEFAULT '0',
  PRIMARY KEY (`access_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `avis_view_access`
--

INSERT INTO `avis_view_access` VALUES
(1, 1, 1, NULL),
(2, 1, 2, NULL),
(3, 1, 3, NULL),
(4, 1, 5, NULL),
(5, 1, 6, NULL),
(6, 1, 10, NULL),
(7, 1, 9, NULL),
(8, 2, 54, NULL),
(9, 2, 37, NULL),
(10, 2, 35, NULL),
(11, 2, 34, NULL),
(12, 2, 55, NULL),
(13, 2, 36, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `avis_view_tab`
--

CREATE TABLE `avis_view_tab` (
  `view_tab_id` int(15) NOT NULL AUTO_INCREMENT,
  `tab_name` varchar(255) DEFAULT NULL,
  `tab_title` varchar(255) DEFAULT NULL,
  `is_chat` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0=ticket,1=chat',
  PRIMARY KEY (`view_tab_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=58 ;

--
-- Dumping data for table `avis_view_tab`
--

INSERT INTO `avis_view_tab` VALUES
(1, 'ticket_hash', 'TXTTICKETHASH', 0),
(2, 'subject', 'TXTSUBJECT', 0),
(3, 'email', 'TXTEMAIL', 0),
(4, 'domain_name', 'TXTDOMAIN', 0),
(5, 'department_name', 'TXTDEPARTMENT', 0),
(6, 'ticket_priority', 'TXTPRIORITY', 0),
(7, 'modify_date', 'TXTMODIFIEDON', 0),
(8, 'due_time', 'TXTDUETIME', 0),
(9, 'flag_color', 'TXTFLAG', 0),
(10, 'ticket_status', 'TXTSTATUS', 0),
(11, 'owner', 'TXTOWNER', 0),
(12, 'first_name', 'TXTFIRSTNAME', 0),
(13, 'last_name', 'TXTLASTNAME', 0),
(14, 'receive_date', 'TXTCREATEDATE', 0),
(15, 'language_name', 'TXTLANGUAGE', 0),
(16, 'last_replier_name', 'TXTLASTREPLIER', 0),
(17, 'ticket_type', 'TXTTICKETTYPE', 0),
(18, 'resolution_time', 'TXTRESOLUTIONTIME', 0),
(19, 'star', 'TXTRATING', 0),
(20, 'label', 'TXTLABEL', 0),
(21, 'link', 'TXTLINK', 0),
(22, 'attachment', 'TXTATTACHMENT', 0),
(23, 'organization', 'TXTORGANIZATION', 0),
(24, 'company_name', 'TXTCOMPANYNAME', 0),
(25, 'last_replier_time', 'TXTLASTREPLIERTIME', 0),
(26, 'ticket_category', 'TXTTICKETCATEGORY', 0),
(27, 'ticket_sub_cateogy', 'TXTTICKETSUBCATEGORY', 0),
(28, 'ticket_item', 'TXTTICKETITEM', 0),
(29, 'ticket_level', 'TXTTICKETLEVEL', 0),
(30, 'location', 'TXTLOCATION', 0),
(31, 'CI_attached', 'TXTCIATTACHED', 0),
(32, 'urgency', 'TXTURGENCY', 0),
(33, 'impact', 'TXTIMPACT', 0),
(34, 'referral', 'TXTREFERRAL', 1),
(35, 'ip', 'TXTIPADDRESS', 1),
(36, 'last_visit_page', 'TXTLASTVISITPAGE', 1),
(37, 'last_visit_time', 'TXTLASTACTIVITY', 1),
(38, 'latitude', 'TXTLATITUDE', 1),
(39, 'longitude', 'TXTLONGITUDE', 1),
(40, 'country', 'TXTCOUNTRY', 1),
(41, 'city', 'TXTCITY', 1),
(42, 'timezone', 'TXTTIMEZONE', 1),
(43, 'browser', 'TXTBROWSER', 1),
(44, 'visits', 'TXTVISITS', 1),
(45, 'device', 'TXTDEVICE', 1),
(46, 'os', 'TXTOS', 1),
(47, 'language', 'TXTLANGUAGE', 1),
(48, 'useragent', 'TXTUSERAGENT', 1),
(49, 'continent', 'TXTCONTINENT', 1),
(50, 'countryCode', 'TXTCOUNTRYCODE', 1),
(51, 'isp', 'TXTISP', 1),
(52, 'businessName', 'TXTBUSINESSNEME', 1),
(53, 'businessWebsite', 'TXTBUSINESSWEBSITE', 1),
(54, 'name', 'TXTNAME', 1),
(55, 'pagetitle', 'TXTPAGETITLE', 1),
(56, 'start_time', 'TXTONLINETIME', 1),
(57, 'domain_name', 'TXTDOMAIN', 1);

-- --------------------------------------------------------

--
-- Table structure for table `avis_workflow`
--

CREATE TABLE `avis_workflow` (
  `workflow_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `event` varchar(255) DEFAULT NULL,
  `reset_sla_res_time` int(5) DEFAULT '0' COMMENT 'Reset resolution time',
  PRIMARY KEY (`workflow_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `avis_workflow`
--

INSERT INTO `avis_workflow` VALUES
(1, 'Default workflow', 1, 'or', 1, 1, [[timestamp]], '0', 1),
(2, 'Client feedback on incident close', 2, NULL, 0, 1, [[timestamp]], '6', 0),
(3, 'Self assign incident on staff reply', 3, NULL, 0, 1, [[timestamp]], '2', 0),
(4, 'Apply 5 days workflow for auto close', 4, NULL, 0, 1, [[timestamp]], '14,15', 0),
(5, 'Auto close awaiting incidents after 5 days', 5, NULL, 0, 1, [[timestamp]], '14,15', 0),
(6, 'Default livechat workflow', 6, NULL, 1, 1, [[timestamp]], '0', 0);

-- --------------------------------------------------------

--
-- Table structure for table `avis_workflow_action`
--

CREATE TABLE `avis_workflow_action` (
  `waction_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text,
  PRIMARY KEY (`waction_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=157 ;

--
-- Dumping data for table `avis_workflow_action`
--

INSERT INTO `avis_workflow_action` VALUES
(1, 1, 1, '0'),
(2, 1, 2, ''),
(3, 1, 3, '1'),
(4, 1, 4, '0'),
(5, 1, 5, '0'),
(6, 1, 6, '0'),
(7, 1, 7, '1'),
(8, 1, 8, '0'),
(9, 1, 9, '0'),
(10, 1, 10, '1'),
(11, 1, 11, '1'),
(12, 1, 12, '0'),
(13, 1, 13, ''),
(14, 1, 14, '0'),
(15, 1, 15, '0'),
(16, 1, 16, ''),
(17, 1, 17, '0'),
(18, 1, 18, ''),
(19, 1, 19, '0'),
(20, 1, 20, ''),
(21, 2, 1, '0'),
(22, 2, 2, ''),
(23, 2, 3, '0'),
(24, 2, 4, '0'),
(25, 2, 5, '0'),
(26, 2, 6, '0'),
(27, 2, 7, '0'),
(28, 2, 9, '0'),
(29, 2, 10, '1'),
(30, 2, 11, '1'),
(31, 2, 12, '0'),
(32, 2, 13, ''),
(33, 2, 14, '0'),
(34, 2, 15, '0'),
(35, 2, 16, ''),
(36, 2, 17, '0'),
(37, 2, 18, ''),
(38, 2, 19, '0'),
(39, 2, 21, '0'),
(40, 2, 22, '0'),
(41, 2, 23, '0'),
(42, 2, 24, '0'),
(43, 2, 25, ''),
(44, 2, 26, '22'),
(45, 2, 27, ''),
(46, 2, 28, '0'),
(47, 3, 1, '0'),
(48, 3, 2, 'VIS_STAFF_ID'),
(49, 3, 3, '0'),
(50, 3, 4, '0'),
(51, 3, 5, '0'),
(52, 3, 6, '0'),
(53, 3, 7, '0'),
(54, 3, 9, '0'),
(55, 3, 10, '1'),
(56, 3, 11, '1'),
(57, 3, 12, '0'),
(58, 3, 13, ''),
(59, 3, 14, '0'),
(60, 3, 15, '0'),
(61, 3, 16, ''),
(62, 3, 17, '0'),
(63, 3, 18, ''),
(64, 3, 19, '0'),
(65, 3, 21, '0'),
(66, 3, 22, '0'),
(67, 3, 23, '0'),
(68, 3, 24, '0'),
(69, 3, 25, ''),
(70, 3, 26, '0'),
(71, 3, 27, ''),
(72, 3, 28, '0'),
(73, 4, 1, '0'),
(74, 4, 2, ''),
(75, 4, 3, '0'),
(76, 4, 4, '0'),
(77, 4, 5, '0'),
(78, 4, 6, '0'),
(79, 4, 7, '2'),
(80, 4, 9, '0'),
(81, 4, 10, '1'),
(82, 4, 11, '1'),
(83, 4, 12, '0'),
(84, 4, 13, ''),
(85, 4, 14, '0'),
(86, 4, 15, '0'),
(87, 4, 16, ''),
(88, 4, 17, '0'),
(89, 4, 18, ''),
(90, 4, 19, '0'),
(91, 4, 21, '0'),
(92, 4, 22, '0'),
(93, 4, 23, '0'),
(94, 4, 24, '0'),
(95, 4, 25, ''),
(96, 4, 26, '0'),
(97, 4, 27, ''),
(98, 4, 28, '0'),
(99, 5, 1, '0'),
(100, 5, 2, ''),
(101, 5, 3, '3'),
(102, 5, 4, '0'),
(103, 5, 5, '0'),
(104, 5, 6, '0'),
(105, 5, 7, '0'),
(106, 5, 9, '0'),
(107, 5, 10, '1'),
(108, 5, 11, '1'),
(109, 5, 12, '0'),
(110, 5, 13, ''),
(111, 5, 14, '0'),
(112, 5, 15, '0'),
(113, 5, 16, ''),
(114, 5, 17, '0'),
(115, 5, 18, ''),
(116, 5, 19, '0'),
(117, 5, 21, '0'),
(118, 5, 22, '0'),
(119, 5, 23, '0'),
(120, 5, 24, '0'),
(121, 5, 25, ''),
(122, 5, 26, '7'),
(123, 5, 27, ''),
(124, 5, 28, '0'),
(125, 6, 1, '0'),
(126, 6, 2, ''),
(127, 6, 3, '3'),
(128, 6, 4, '0'),
(129, 6, 5, '0'),
(130, 6, 6, '0'),
(131, 6, 7, '0'),
(132, 6, 9, '0'),
(133, 6, 10, '1'),
(134, 6, 11, '1'),
(135, 6, 12, '0'),
(136, 6, 13, ''),
(137, 6, 14, '0'),
(138, 6, 15, '0'),
(139, 6, 16, ''),
(140, 6, 17, '0'),
(141, 6, 18, ''),
(142, 6, 19, '0'),
(143, 6, 21, '0'),
(144, 6, 22, '0'),
(145, 6, 23, '0'),
(146, 6, 24, '0'),
(147, 6, 25, '0'),
(148, 6, 26, '0'),
(149, 6, 27, ''),
(150, 6, 28, '0'),
(151, 6, 29, '0'),
(152, 6, 30, '0'),
(153, 6, 31, '0'),
(154, 6, 32, ''),
(155, 6, 33, '0'),
(156, 6, 34, '0');

-- --------------------------------------------------------

--
-- Table structure for table `avis_workflow_criteria`
--

CREATE TABLE `avis_workflow_criteria` (
  `wcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`wcriteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `avis_workflow_criteria`
--

INSERT INTO `avis_workflow_criteria` VALUES
(1, 1, 0, 0, '', 'or'),
(2, 1, 0, 0, '', 'and'),
(3, 2, 8, 0, '3', 'and'),
(4, 2, 0, 0, '', 'or'),
(5, 3, 0, 0, '', 'and'),
(6, 3, 0, 0, '', 'or'),
(7, 4, 8, 0, '2', 'and'),
(8, 4, 0, 0, '', 'or'),
(9, 5, 15, 0, '', 'and'),
(10, 5, 8, 0, '2', 'and'),
(11, 5, 0, 0, '', 'or'),
(12, 6, 24, 0, '25', 'and'),
(13, 6, 0, 0, '', 'or');

-- --------------------------------------------------------

--
-- Table structure for table `avis_xml_log`
--

CREATE TABLE `avis_xml_log` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `modified_date` int(15) NOT NULL,
  `user_id` int(15) NOT NULL,
  `user_type` int(2) NOT NULL COMMENT '1-client 2-staff',
  `filedata` longtext NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
