<?php


class PHPExcel_Writer_Excel5_Workbook extends PHPExcel_Writer_Excel5_BIFFwriter
{
    private $parser;

    private $biffSize;

    private $xfWriters = array();

    private $palette;

    private $codepage;

    private $countryCode;

    private $phpExcel;

    private $fontWriters = array();

    private $addedFonts = array();

    private $numberFormats = array();

    private $addedNumberFormats = array();

    private $worksheetSizes = array();

    private $worksheetOffsets = array();

    private $stringTotal;

    private $stringUnique;

    private $stringTable;

    private $colors;

    private $escher;


    public function __construct(PHPExcel $phpExcel = null, &$str_total, &$str_unique, &$str_table, &$colors, $parser)
    {
        parent::__construct();

        $this->parser        = $parser;
        $this->biffSize     = 0;
        $this->palette      = array();
        $this->countryCode = -1;

        $this->stringTotal      = &$str_total;
        $this->stringUnique     = &$str_unique;
        $this->stringTable      = &$str_table;
        $this->colors        = &$colors;
        $this->setPaletteXl97();

        $this->phpExcel = $phpExcel;

        $this->codepage = 0x04B0;

        $countSheets = $phpExcel->getSheetCount();
        for ($i = 0; $i < $countSheets; ++$i) {
            $phpSheet = $phpExcel->getSheet($i);

            $this->parser->setExtSheet($phpSheet->getTitle(), $i);  // Register worksheet name with parser

            $supbook_index = 0x00;
            $ref = pack('vvv', $supbook_index, $i, $i);
            $this->parser->references[] = $ref;  // Register reference with parser

            if ($phpSheet->isTabColorSet()) {
                $this->addColor($phpSheet->getTabColor()->getRGB());
            }
        }

    }

    public function addXfWriter($style, $isStyleXf = false)
    {
        $xfWriter = new PHPExcel_Writer_Excel5_Xf($style);
        $xfWriter->setIsStyleXf($isStyleXf);

        $fontIndex = $this->addFont($style->getFont());

        $xfWriter->setFontIndex($fontIndex);

        $xfWriter->setFgColor($this->addColor($style->getFill()->getStartColor()->getRGB()));
        $xfWriter->setBgColor($this->addColor($style->getFill()->getEndColor()->getRGB()));
        $xfWriter->setBottomColor($this->addColor($style->getBorders()->getBottom()->getColor()->getRGB()));
        $xfWriter->setTopColor($this->addColor($style->getBorders()->getTop()->getColor()->getRGB()));
        $xfWriter->setRightColor($this->addColor($style->getBorders()->getRight()->getColor()->getRGB()));
        $xfWriter->setLeftColor($this->addColor($style->getBorders()->getLeft()->getColor()->getRGB()));
        $xfWriter->setDiagColor($this->addColor($style->getBorders()->getDiagonal()->getColor()->getRGB()));

        if ($style->getNumberFormat()->getBuiltInFormatCode() === false) {
            $numberFormatHashCode = $style->getNumberFormat()->getHashCode();

            if (isset($this->addedNumberFormats[$numberFormatHashCode])) {
                $numberFormatIndex = $this->addedNumberFormats[$numberFormatHashCode];
            } else {
                $numberFormatIndex = 164 + count($this->numberFormats);
                $this->numberFormats[$numberFormatIndex] = $style->getNumberFormat();
                $this->addedNumberFormats[$numberFormatHashCode] = $numberFormatIndex;
            }
        } else {
            $numberFormatIndex = (int) $style->getNumberFormat()->getBuiltInFormatCode();
        }

        $xfWriter->setNumberFormatIndex($numberFormatIndex);

        $this->xfWriters[] = $xfWriter;

        $xfIndex = count($this->xfWriters) - 1;
        return $xfIndex;
    }

    public function addFont(PHPExcel_Style_Font $font)
    {
        $fontHashCode = $font->getHashCode();
        if (isset($this->addedFonts[$fontHashCode])) {
            $fontIndex = $this->addedFonts[$fontHashCode];
        } else {
            $countFonts = count($this->fontWriters);
            $fontIndex = ($countFonts < 4) ? $countFonts : $countFonts + 1;

            $fontWriter = new PHPExcel_Writer_Excel5_Font($font);
            $fontWriter->setColorIndex($this->addColor($font->getColor()->getRGB()));
            $this->fontWriters[] = $fontWriter;

            $this->addedFonts[$fontHashCode] = $fontIndex;
        }
        return $fontIndex;
    }

    private function addColor($rgb)
    {
        if (!isset($this->colors[$rgb])) {
            if (count($this->colors) < 57) {
                $colorIndex = 8 + count($this->colors);
                $this->palette[$colorIndex] =
                    array(
                        hexdec(substr($rgb, 0, 2)),
                        hexdec(substr($rgb, 2, 2)),
                        hexdec(substr($rgb, 4)),
                        0
                    );
                $this->colors[$rgb] = $colorIndex;
            } else {
                $colorIndex = 0;
            }
        } else {
            $colorIndex = $this->colors[$rgb];
        }

        return $colorIndex;
    }

    private function setPaletteXl97()
    {
        $this->palette = array(
            0x08 => array(0x00, 0x00, 0x00, 0x00),
            0x09 => array(0xff, 0xff, 0xff, 0x00),
            0x0A => array(0xff, 0x00, 0x00, 0x00),
            0x0B => array(0x00, 0xff, 0x00, 0x00),
            0x0C => array(0x00, 0x00, 0xff, 0x00),
            0x0D => array(0xff, 0xff, 0x00, 0x00),
            0x0E => array(0xff, 0x00, 0xff, 0x00),
            0x0F => array(0x00, 0xff, 0xff, 0x00),
            0x10 => array(0x80, 0x00, 0x00, 0x00),
            0x11 => array(0x00, 0x80, 0x00, 0x00),
            0x12 => array(0x00, 0x00, 0x80, 0x00),
            0x13 => array(0x80, 0x80, 0x00, 0x00),
            0x14 => array(0x80, 0x00, 0x80, 0x00),
            0x15 => array(0x00, 0x80, 0x80, 0x00),
            0x16 => array(0xc0, 0xc0, 0xc0, 0x00),
            0x17 => array(0x80, 0x80, 0x80, 0x00),
            0x18 => array(0x99, 0x99, 0xff, 0x00),
            0x19 => array(0x99, 0x33, 0x66, 0x00),
            0x1A => array(0xff, 0xff, 0xcc, 0x00),
            0x1B => array(0xcc, 0xff, 0xff, 0x00),
            0x1C => array(0x66, 0x00, 0x66, 0x00),
            0x1D => array(0xff, 0x80, 0x80, 0x00),
            0x1E => array(0x00, 0x66, 0xcc, 0x00),
            0x1F => array(0xcc, 0xcc, 0xff, 0x00),
            0x20 => array(0x00, 0x00, 0x80, 0x00),
            0x21 => array(0xff, 0x00, 0xff, 0x00),
            0x22 => array(0xff, 0xff, 0x00, 0x00),
            0x23 => array(0x00, 0xff, 0xff, 0x00),
            0x24 => array(0x80, 0x00, 0x80, 0x00),
            0x25 => array(0x80, 0x00, 0x00, 0x00),
            0x26 => array(0x00, 0x80, 0x80, 0x00),
            0x27 => array(0x00, 0x00, 0xff, 0x00),
            0x28 => array(0x00, 0xcc, 0xff, 0x00),
            0x29 => array(0xcc, 0xff, 0xff, 0x00),
            0x2A => array(0xcc, 0xff, 0xcc, 0x00),
            0x2B => array(0xff, 0xff, 0x99, 0x00),
            0x2C => array(0x99, 0xcc, 0xff, 0x00),
            0x2D => array(0xff, 0x99, 0xcc, 0x00),
            0x2E => array(0xcc, 0x99, 0xff, 0x00),
            0x2F => array(0xff, 0xcc, 0x99, 0x00),
            0x30 => array(0x33, 0x66, 0xff, 0x00),
            0x31 => array(0x33, 0xcc, 0xcc, 0x00),
            0x32 => array(0x99, 0xcc, 0x00, 0x00),
            0x33 => array(0xff, 0xcc, 0x00, 0x00),
            0x34 => array(0xff, 0x99, 0x00, 0x00),
            0x35 => array(0xff, 0x66, 0x00, 0x00),
            0x36 => array(0x66, 0x66, 0x99, 0x00),
            0x37 => array(0x96, 0x96, 0x96, 0x00),
            0x38 => array(0x00, 0x33, 0x66, 0x00),
            0x39 => array(0x33, 0x99, 0x66, 0x00),
            0x3A => array(0x00, 0x33, 0x00, 0x00),
            0x3B => array(0x33, 0x33, 0x00, 0x00),
            0x3C => array(0x99, 0x33, 0x00, 0x00),
            0x3D => array(0x99, 0x33, 0x66, 0x00),
            0x3E => array(0x33, 0x33, 0x99, 0x00),
            0x3F => array(0x33, 0x33, 0x33, 0x00),
        );
    }

    public function writeWorkbook($pWorksheetSizes = null)
    {
        $this->worksheetSizes = $pWorksheetSizes;

        $total_worksheets = $this->phpExcel->getSheetCount();

        $this->storeBof(0x0005);
        $this->writeCodepage();
        $this->writeWindow1();

        $this->writeDateMode();
        $this->writeAllFonts();
        $this->writeAllNumberFormats();
        $this->writeAllXfs();
        $this->writeAllStyles();
        $this->writePalette();

        $part3 = '';
        if ($this->countryCode != -1) {
            $part3 .= $this->writeCountry();
        }
        $part3 .= $this->writeRecalcId();

        $part3 .= $this->writeSupbookInternal();
        $part3 .= $this->writeExternalsheetBiff8();
        $part3 .= $this->writeAllDefinedNamesBiff8();
        $part3 .= $this->writeMsoDrawingGroup();
        $part3 .= $this->writeSharedStringsTable();

        $part3 .= $this->writeEof();

        $this->calcSheetOffsets();
        for ($i = 0; $i < $total_worksheets; ++$i) {
            $this->writeBoundSheet($this->phpExcel->getSheet($i), $this->worksheetOffsets[$i]);
        }

        $this->_data .= $part3;

        return $this->_data;
    }

    private function calcSheetOffsets()
    {
        $boundsheet_length = 10;  // fixed length for a BOUNDSHEET record

        $offset            = $this->_datasize;

        $total_worksheets = count($this->phpExcel->getAllSheets());
        foreach ($this->phpExcel->getWorksheetIterator() as $sheet) {
            $offset += $boundsheet_length + strlen(PHPExcel_Shared_String::UTF8toBIFF8UnicodeShort($sheet->getTitle()));
        }

        for ($i = 0; $i < $total_worksheets; ++$i) {
            $this->worksheetOffsets[$i] = $offset;
            $offset += $this->worksheetSizes[$i];
        }
        $this->biffSize = $offset;
    }

    private function writeAllFonts()
    {
        foreach ($this->fontWriters as $fontWriter) {
            $this->append($fontWriter->writeFont());
        }
    }

    private function writeAllNumberFormats()
    {
        foreach ($this->numberFormats as $numberFormatIndex => $numberFormat) {
            $this->writeNumberFormat($numberFormat->getFormatCode(), $numberFormatIndex);
        }
    }

    private function writeAllXfs()
    {
        foreach ($this->xfWriters as $xfWriter) {
            $this->append($xfWriter->writeXf());
        }
    }

    private function writeAllStyles()
    {
        $this->writeStyle();
    }

    private function writeExternals()
    {
        $countSheets = $this->phpExcel->getSheetCount();
        $this->writeExternalCount($countSheets);

        for ($i = 0; $i < $countSheets; ++$i) {
            $this->writeExternalSheet($this->phpExcel->getSheet($i)->getTitle());
        }
    }

    private function writeNames()
    {
        $total_worksheets = $this->phpExcel->getSheetCount();

        for ($i = 0; $i < $total_worksheets; ++$i) {
            $sheetSetup = $this->phpExcel->getSheet($i)->getPageSetup();
            if ($sheetSetup->isPrintAreaSet()) {
                $printArea = PHPExcel_Cell::splitRange($sheetSetup->getPrintArea());
                $printArea = $printArea[0];
                $printArea[0] = PHPExcel_Cell::coordinateFromString($printArea[0]);
                $printArea[1] = PHPExcel_Cell::coordinateFromString($printArea[1]);

                $print_rowmin = $printArea[0][1] - 1;
                $print_rowmax = $printArea[1][1] - 1;
                $print_colmin = PHPExcel_Cell::columnIndexFromString($printArea[0][0]) - 1;
                $print_colmax = PHPExcel_Cell::columnIndexFromString($printArea[1][0]) - 1;

                $this->writeNameShort(
                    $i, // sheet index
                    0x06, // NAME type
                    $print_rowmin,
                    $print_rowmax,
                    $print_colmin,
                    $print_colmax
                );
            }
        }

        for ($i = 0; $i < $total_worksheets; ++$i) {
            $sheetSetup = $this->phpExcel->getSheet($i)->getPageSetup();

            if ($sheetSetup->isColumnsToRepeatAtLeftSet() && $sheetSetup->isRowsToRepeatAtTopSet()) {
                $repeat = $sheetSetup->getColumnsToRepeatAtLeft();
                $colmin = PHPExcel_Cell::columnIndexFromString($repeat[0]) - 1;
                $colmax = PHPExcel_Cell::columnIndexFromString($repeat[1]) - 1;

                $repeat = $sheetSetup->getRowsToRepeatAtTop();
                $rowmin = $repeat[0] - 1;
                $rowmax = $repeat[1] - 1;

                $this->writeNameLong(
                    $i, // sheet index
                    0x07, // NAME type
                    $rowmin,
                    $rowmax,
                    $colmin,
                    $colmax
                );

            } elseif ($sheetSetup->isColumnsToRepeatAtLeftSet() || $sheetSetup->isRowsToRepeatAtTopSet()) {
                if ($sheetSetup->isColumnsToRepeatAtLeftSet()) {
                    $repeat = $sheetSetup->getColumnsToRepeatAtLeft();
                    $colmin = PHPExcel_Cell::columnIndexFromString($repeat[0]) - 1;
                    $colmax = PHPExcel_Cell::columnIndexFromString($repeat[1]) - 1;
                } else {
                    $colmin = 0;
                    $colmax = 255;
                }

                if ($sheetSetup->isRowsToRepeatAtTopSet()) {
                    $repeat = $sheetSetup->getRowsToRepeatAtTop();
                    $rowmin = $repeat[0] - 1;
                    $rowmax = $repeat[1] - 1;
                } else {
                    $rowmin = 0;
                    $rowmax = 65535;
                }

                $this->writeNameShort(
                    $i, // sheet index
                    0x07, // NAME type
                    $rowmin,
                    $rowmax,
                    $colmin,
                    $colmax
                );
            }
        }
    }

    private function writeAllDefinedNamesBiff8()
    {
        $chunk = '';

        if (count($this->phpExcel->getNamedRanges()) > 0) {
            $namedRanges = $this->phpExcel->getNamedRanges();
            foreach ($namedRanges as $namedRange) {
                $range = PHPExcel_Cell::splitRange($namedRange->getRange());
                for ($i = 0; $i < count($range); $i++) {
                    $range[$i][0] = '\'' . str_replace("'", "''", $namedRange->getWorksheet()->getTitle()) . '\'!' . PHPExcel_Cell::absoluteCoordinate($range[$i][0]);
                    if (isset($range[$i][1])) {
                        $range[$i][1] = PHPExcel_Cell::absoluteCoordinate($range[$i][1]);
                    }
                }
                $range = PHPExcel_Cell::buildRange($range); // e.g. Sheet1!$A$1:$B$2

                try {
                    $error = $this->parser->parse($range);
                    $formulaData = $this->parser->toReversePolish();

                    if (isset($formulaData[0]) and ($formulaData[0] == "\x7A" or $formulaData[0] == "\x5A")) {
                        $formulaData = "\x3A" . substr($formulaData, 1);
                    }

                    if ($namedRange->getLocalOnly()) {
                        $scope = $this->phpExcel->getIndex($namedRange->getScope()) + 1;
                    } else {
                        $scope = 0;
                    }
                    $chunk .= $this->writeData($this->writeDefinedNameBiff8($namedRange->getName(), $formulaData, $scope, false));

                } catch (PHPExcel_Exception $e) {
                }
            }
        }

        $total_worksheets = $this->phpExcel->getSheetCount();

        for ($i = 0; $i < $total_worksheets; ++$i) {
            $sheetSetup = $this->phpExcel->getSheet($i)->getPageSetup();
            if ($sheetSetup->isColumnsToRepeatAtLeftSet() && $sheetSetup->isRowsToRepeatAtTopSet()) {
                $repeat = $sheetSetup->getColumnsToRepeatAtLeft();
                $colmin = PHPExcel_Cell::columnIndexFromString($repeat[0]) - 1;
                $colmax = PHPExcel_Cell::columnIndexFromString($repeat[1]) - 1;

                $repeat = $sheetSetup->getRowsToRepeatAtTop();
                $rowmin = $repeat[0] - 1;
                $rowmax = $repeat[1] - 1;

                $formulaData = pack('Cv', 0x29, 0x17); // tMemFunc
                $formulaData .= pack('Cvvvvv', 0x3B, $i, 0, 65535, $colmin, $colmax); // tArea3d
                $formulaData .= pack('Cvvvvv', 0x3B, $i, $rowmin, $rowmax, 0, 255); // tArea3d
                $formulaData .= pack('C', 0x10); // tList

                $chunk .= $this->writeData($this->writeDefinedNameBiff8(pack('C', 0x07), $formulaData, $i + 1, true));

            } elseif ($sheetSetup->isColumnsToRepeatAtLeftSet() || $sheetSetup->isRowsToRepeatAtTopSet()) {
                if ($sheetSetup->isColumnsToRepeatAtLeftSet()) {
                    $repeat = $sheetSetup->getColumnsToRepeatAtLeft();
                    $colmin = PHPExcel_Cell::columnIndexFromString($repeat[0]) - 1;
                    $colmax = PHPExcel_Cell::columnIndexFromString($repeat[1]) - 1;
                } else {
                    $colmin = 0;
                    $colmax = 255;
                }
                if ($sheetSetup->isRowsToRepeatAtTopSet()) {
                    $repeat = $sheetSetup->getRowsToRepeatAtTop();
                    $rowmin = $repeat[0] - 1;
                    $rowmax = $repeat[1] - 1;
                } else {
                    $rowmin = 0;
                    $rowmax = 65535;
                }

                $formulaData = pack('Cvvvvv', 0x3B, $i, $rowmin, $rowmax, $colmin, $colmax);

                $chunk .= $this->writeData($this->writeDefinedNameBiff8(pack('C', 0x07), $formulaData, $i + 1, true));
            }
        }

        for ($i = 0; $i < $total_worksheets; ++$i) {
            $sheetSetup = $this->phpExcel->getSheet($i)->getPageSetup();
            if ($sheetSetup->isPrintAreaSet()) {
                $printArea = PHPExcel_Cell::splitRange($sheetSetup->getPrintArea());
                $countPrintArea = count($printArea);

                $formulaData = '';
                for ($j = 0; $j < $countPrintArea; ++$j) {
                    $printAreaRect = $printArea[$j]; // e.g. A3:J6
                    $printAreaRect[0] = PHPExcel_Cell::coordinateFromString($printAreaRect[0]);
                    $printAreaRect[1] = PHPExcel_Cell::coordinateFromString($printAreaRect[1]);

                    $print_rowmin = $printAreaRect[0][1] - 1;
                    $print_rowmax = $printAreaRect[1][1] - 1;
                    $print_colmin = PHPExcel_Cell::columnIndexFromString($printAreaRect[0][0]) - 1;
                    $print_colmax = PHPExcel_Cell::columnIndexFromString($printAreaRect[1][0]) - 1;

                    $formulaData .= pack('Cvvvvv', 0x3B, $i, $print_rowmin, $print_rowmax, $print_colmin, $print_colmax);

                    if ($j > 0) {
                        $formulaData .= pack('C', 0x10); // list operator token ','
                    }
                }

                $chunk .= $this->writeData($this->writeDefinedNameBiff8(pack('C', 0x06), $formulaData, $i + 1, true));
            }
        }

        for ($i = 0; $i < $total_worksheets; ++$i) {
            $sheetAutoFilter = $this->phpExcel->getSheet($i)->getAutoFilter();
            $autoFilterRange = $sheetAutoFilter->getRange();
            if (!empty($autoFilterRange)) {
                $rangeBounds = PHPExcel_Cell::rangeBoundaries($autoFilterRange);

                $name = pack('C', 0x0D);

                $chunk .= $this->writeData($this->writeShortNameBiff8($name, $i + 1, $rangeBounds, true));
            }
        }

        return $chunk;
    }

    private function writeDefinedNameBiff8($name, $formulaData, $sheetIndex = 0, $isBuiltIn = false)
    {
        $record = 0x0018;

        $options = $isBuiltIn ? 0x20 : 0x00;

        $nlen = PHPExcel_Shared_String::CountCharacters($name);

        $name = substr(PHPExcel_Shared_String::UTF8toBIFF8UnicodeLong($name), 2);

        $sz = strlen($formulaData);

        $data = pack('vCCvvvCCCC', $options, 0, $nlen, $sz, 0, $sheetIndex, 0, 0, 0, 0)
            . $name . $formulaData;
        $length = strlen($data);

        $header = pack('vv', $record, $length);

        return $header . $data;
    }

    private function writeShortNameBiff8($name, $sheetIndex = 0, $rangeBounds, $isHidden = false)
    {
        $record = 0x0018;

        $options = ($isHidden  ? 0x21 : 0x00);

        $extra  = pack(
            'Cvvvvv',
            0x3B,
            $sheetIndex - 1,
            $rangeBounds[0][1] - 1,
            $rangeBounds[1][1] - 1,
            $rangeBounds[0][0] - 1,
            $rangeBounds[1][0] - 1
        );

        $sz = strlen($extra);

        $data = pack('vCCvvvCCCCC', $options, 0, 1, $sz, 0, $sheetIndex, 0, 0, 0, 0, 0)
            . $name . $extra;
        $length = strlen($data);

        $header = pack('vv', $record, $length);

        return $header . $data;
    }

    private function writeCodepage()
    {
        $record = 0x0042;             // Record identifier
        $length = 0x0002;             // Number of bytes to follow
        $cv  = $this->codepage;   // The code page

        $header = pack('vv', $record, $length);
        $data   = pack('v', $cv);

        $this->append($header . $data);
    }

    private function writeWindow1()
    {
        $record = 0x003D;   // Record identifier
        $length = 0x0012;   // Number of bytes to follow

        $xWn  = 0x0000;     // Horizontal position of window
        $yWn  = 0x0000;     // Vertical position of window
        $dxWn = 0x25BC;     // Width of window
        $dyWn = 0x1572;     // Height of window

        $grbit = 0x0038;    // Option flags

        $ctabsel = 1;       // Number of workbook tabs selected

        $wTabRatio = 0x0258;    // Tab to scrollbar ratio

        $itabFirst = 0;     // 1st displayed worksheet
        $itabCur   = $this->phpExcel->getActiveSheetIndex();    // Active worksheet

        $header = pack("vv", $record, $length);
        $data   = pack("vvvvvvvvv", $xWn, $yWn, $dxWn, $dyWn, $grbit, $itabCur, $itabFirst, $ctabsel, $wTabRatio);
        $this->append($header . $data);
    }

    private function writeBoundSheet($sheet, $offset)
    {
        $sheetname = $sheet->getTitle();
        $record    = 0x0085;                    // Record identifier

        switch ($sheet->getSheetState()) {
            case PHPExcel_Worksheet::SHEETSTATE_VISIBLE:
                $ss = 0x00;
                break;
            case PHPExcel_Worksheet::SHEETSTATE_HIDDEN:
                $ss = 0x01;
                break;
            case PHPExcel_Worksheet::SHEETSTATE_VERYHIDDEN:
                $ss = 0x02;
                break;
            default:
                $ss = 0x00;
                break;
        }

        $st = 0x00;

        $grbit = 0x0000;                    // Visibility and sheet type

        $data = pack("VCC", $offset, $ss, $st);
        $data .= PHPExcel_Shared_String::UTF8toBIFF8UnicodeShort($sheetname);

        $length = strlen($data);
        $header = pack("vv", $record, $length);
        $this->append($header . $data);
    }

    private function writeSupbookInternal()
    {
        $record    = 0x01AE;   // Record identifier
        $length    = 0x0004;   // Bytes to follow

        $header    = pack("vv", $record, $length);
        $data      = pack("vv", $this->phpExcel->getSheetCount(), 0x0401);
        return $this->writeData($header . $data);
    }

    private function writeExternalsheetBiff8()
    {
        $totalReferences = count($this->parser->references);
        $record = 0x0017;                     // Record identifier
        $length = 2 + 6 * $totalReferences;  // Number of bytes to follow

        $supbook_index = 0;           // FIXME: only using internal SUPBOOK record
        $header = pack("vv", $record, $length);
        $data   = pack('v', $totalReferences);
        for ($i = 0; $i < $totalReferences; ++$i) {
            $data .= $this->parser->references[$i];
        }
        return $this->writeData($header . $data);
    }

    private function writeStyle()
    {
        $record = 0x0293;   // Record identifier
        $length = 0x0004;   // Bytes to follow

        $ixfe    = 0x8000;  // Index to cell style XF
        $BuiltIn = 0x00;     // Built-in style
        $iLevel  = 0xff;     // Outline style level

        $header = pack("vv", $record, $length);
        $data   = pack("vCC", $ixfe, $BuiltIn, $iLevel);
        $this->append($header . $data);
    }

    private function writeNumberFormat($format, $ifmt)
    {
        $record = 0x041E;    // Record identifier

        $numberFormatString = PHPExcel_Shared_String::UTF8toBIFF8UnicodeLong($format);
        $length = 2 + strlen($numberFormatString);    // Number of bytes to follow


        $header = pack("vv", $record, $length);
        $data   = pack("v", $ifmt) .  $numberFormatString;
        $this->append($header . $data);
    }

    private function writeDateMode()
    {
        $record = 0x0022;   // Record identifier
        $length = 0x0002;   // Bytes to follow

        $f1904  = (PHPExcel_Shared_Date::getExcelCalendar() == PHPExcel_Shared_Date::CALENDAR_MAC_1904)
            ? 1
            : 0;   // Flag for 1904 date system

        $header = pack("vv", $record, $length);
        $data   = pack("v", $f1904);
        $this->append($header . $data);
    }

    private function writeExternalCount($cxals)
    {
        $record = 0x0016;   // Record identifier
        $length = 0x0002;   // Number of bytes to follow

        $header = pack("vv", $record, $length);
        $data   = pack("v", $cxals);
        $this->append($header . $data);
    }

    private function writeExternalSheet($sheetname)
    {
        $record = 0x0017;                     // Record identifier
        $length = 0x02 + strlen($sheetname);  // Number of bytes to follow

        $cch    = strlen($sheetname);         // Length of sheet name
        $rgch   = 0x03;                       // Filename encoding

        $header = pack("vv", $record, $length);
        $data   = pack("CC", $cch, $rgch);
        $this->append($header . $data . $sheetname);
    }

    private function writeNameShort($index, $type, $rowmin, $rowmax, $colmin, $colmax)
    {
        $record = 0x0018;       // Record identifier
        $length = 0x0024;       // Number of bytes to follow

        $grbit  = 0x0020;       // Option flags
        $chKey  = 0x00;         // Keyboard shortcut
        $cch    = 0x01;         // Length of text name
        $cce    = 0x0015;       // Length of text definition
        $ixals  = $index + 1;   // Sheet index
        $itab   = $ixals;       // Equal to ixals
        $cchCustMenu    = 0x00;         // Length of cust menu text
        $cchDescription = 0x00;         // Length of description text
        $cchHelptopic   = 0x00;         // Length of help topic text
        $cchStatustext  = 0x00;         // Length of status bar text
        $rgch           = $type;        // Built-in name type

        $unknown03 = 0x3b;
        $unknown04 = 0xffff - $index;
        $unknown05 = 0x0000;
        $unknown06 = 0x0000;
        $unknown07 = 0x1087;
        $unknown08 = 0x8005;

        $header = pack("vv", $record, $length);
        $data = pack("v", $grbit);
        $data .= pack("C", $chKey);
        $data .= pack("C", $cch);
        $data .= pack("v", $cce);
        $data .= pack("v", $ixals);
        $data .= pack("v", $itab);
        $data .= pack("C", $cchCustMenu);
        $data .= pack("C", $cchDescription);
        $data .= pack("C", $cchHelptopic);
        $data .= pack("C", $cchStatustext);
        $data .= pack("C", $rgch);
        $data .= pack("C", $unknown03);
        $data .= pack("v", $unknown04);
        $data .= pack("v", $unknown05);
        $data .= pack("v", $unknown06);
        $data .= pack("v", $unknown07);
        $data .= pack("v", $unknown08);
        $data .= pack("v", $index);
        $data .= pack("v", $index);
        $data .= pack("v", $rowmin);
        $data .= pack("v", $rowmax);
        $data .= pack("C", $colmin);
        $data .= pack("C", $colmax);
        $this->append($header . $data);
    }

    private function writeNameLong($index, $type, $rowmin, $rowmax, $colmin, $colmax)
    {
        $record          = 0x0018;       // Record identifier
        $length          = 0x003d;       // Number of bytes to follow
        $grbit           = 0x0020;       // Option flags
        $chKey           = 0x00;         // Keyboard shortcut
        $cch             = 0x01;         // Length of text name
        $cce             = 0x002e;       // Length of text definition
        $ixals           = $index + 1;   // Sheet index
        $itab            = $ixals;       // Equal to ixals
        $cchCustMenu     = 0x00;         // Length of cust menu text
        $cchDescription  = 0x00;         // Length of description text
        $cchHelptopic    = 0x00;         // Length of help topic text
        $cchStatustext   = 0x00;         // Length of status bar text
        $rgch            = $type;        // Built-in name type

        $unknown01       = 0x29;
        $unknown02       = 0x002b;
        $unknown03       = 0x3b;
        $unknown04       = 0xffff-$index;
        $unknown05       = 0x0000;
        $unknown06       = 0x0000;
        $unknown07       = 0x1087;
        $unknown08       = 0x8008;

        $header = pack("vv", $record, $length);
        $data = pack("v", $grbit);
        $data .= pack("C", $chKey);
        $data .= pack("C", $cch);
        $data .= pack("v", $cce);
        $data .= pack("v", $ixals);
        $data .= pack("v", $itab);
        $data .= pack("C", $cchCustMenu);
        $data .= pack("C", $cchDescription);
        $data .= pack("C", $cchHelptopic);
        $data .= pack("C", $cchStatustext);
        $data .= pack("C", $rgch);
        $data .= pack("C", $unknown01);
        $data .= pack("v", $unknown02);
        $data .= pack("C", $unknown03);
        $data .= pack("v", $unknown04);
        $data .= pack("v", $unknown05);
        $data .= pack("v", $unknown06);
        $data .= pack("v", $unknown07);
        $data .= pack("v", $unknown08);
        $data .= pack("v", $index);
        $data .= pack("v", $index);
        $data .= pack("v", 0x0000);
        $data .= pack("v", 0x3fff);
        $data .= pack("C", $colmin);
        $data .= pack("C", $colmax);
        $data .= pack("C", $unknown03);
        $data .= pack("v", $unknown04);
        $data .= pack("v", $unknown05);
        $data .= pack("v", $unknown06);
        $data .= pack("v", $unknown07);
        $data .= pack("v", $unknown08);
        $data .= pack("v", $index);
        $data .= pack("v", $index);
        $data .= pack("v", $rowmin);
        $data .= pack("v", $rowmax);
        $data .= pack("C", 0x00);
        $data .= pack("C", 0xff);
        $data .= pack("C", 0x10);
        $this->append($header . $data);
    }

    private function writeCountry()
    {
        $record = 0x008C;    // Record identifier
        $length = 4;         // Number of bytes to follow

        $header = pack('vv', $record, $length);
        $data = pack('vv', $this->countryCode, $this->countryCode);
        return $this->writeData($header . $data);
    }

    private function writeRecalcId()
    {
        $record = 0x01C1;    // Record identifier
        $length = 8;         // Number of bytes to follow

        $header = pack('vv', $record, $length);

        $data = pack('VV', 0x000001C1, 0x00001E667);

        return $this->writeData($header . $data);
    }

    private function writePalette()
    {
        $aref = $this->palette;

        $record = 0x0092;                // Record identifier
        $length = 2 + 4 * count($aref);  // Number of bytes to follow
        $ccv    = count($aref);          // Number of RGB values to follow
        $data = '';                      // The RGB data

        foreach ($aref as $color) {
            foreach ($color as $byte) {
                $data .= pack("C", $byte);
            }
        }

        $header = pack("vvv", $record, $length, $ccv);
        $this->append($header . $data);
    }

    private function writeSharedStringsTable()
    {
        $continue_limit = 8224;

        $recordDatas = array();

        $recordData = pack("VV", $this->stringTotal, $this->stringUnique);

        foreach (array_keys($this->stringTable) as $string) {

            $headerinfo = unpack("vlength/Cencoding", $string);

            $encoding = $headerinfo["encoding"];

            $finished = false;

            while ($finished === false) {

                if (strlen($recordData) + strlen($string) <= $continue_limit) {
                    $recordData .= $string;

                    if (strlen($recordData) + strlen($string) == $continue_limit) {
                        $recordDatas[] = $recordData;
                        $recordData = '';
                    }

                    $finished = true;
                } else {

                    $space_remaining = $continue_limit - strlen($recordData);

                    $min_space_needed = ($encoding == 1) ? 5 : 4;


                    if ($space_remaining < $min_space_needed) {
                        $recordDatas[] = $recordData;

                        $recordData = '';

                    } else {
                        $effective_space_remaining = $space_remaining;

                        if ($encoding == 1 && (strlen($string) - $space_remaining) % 2 == 1) {
                            --$effective_space_remaining;
                        }

                        $recordData .= substr($string, 0, $effective_space_remaining);

                        $string = substr($string, $effective_space_remaining); // for next cycle in while loop
                        $recordDatas[] = $recordData;

                        $recordData = pack('C', $encoding);
                    }
                }
            }
        }

        if (strlen($recordData) > 0) {
            $recordDatas[] = $recordData;
        }

        $chunk = '';
        foreach ($recordDatas as $i => $recordData) {
            $record = ($i == 0) ? 0x00FC : 0x003C;

            $header = pack("vv", $record, strlen($recordData));
            $data = $header . $recordData;

            $chunk .= $this->writeData($data);
        }

        return $chunk;
    }

    private function writeMsoDrawingGroup()
    {
        if (isset($this->escher)) {
            $writer = new PHPExcel_Writer_Excel5_Escher($this->escher);
            $data = $writer->close();

            $record = 0x00EB;
            $length = strlen($data);
            $header = pack("vv", $record, $length);

            return $this->writeData($header . $data);
        } else {
            return '';
        }
    }

    public function getEscher()
    {
        return $this->escher;
    }

    public function setEscher(PHPExcel_Shared_Escher $pValue = null)
    {
        $this->escher = $pValue;
    }
}
