var $list = $('#emojilist');

(function ($) {
	$.fn.emoji = function (params) {
		var defaults = {
			button: '<i class="vh vh-lg vh vh-smiley" aria-hidden="true"></i>',
			place: 'before',
			emojis: ['&#x1F642;', '&#x1F641;', '&#x1f600;', '&#x1f601;', '&#x1f602;', '&#x1f603;', '&#x1f604;', '&#x1f605;', '&#x1f606;', '&#x1f607;', '&#x1f608;', '&#x1f609;', '&#x1f60a;', '&#x1f60b;', '&#x1f60c;', '&#x1f60d;', '&#x1f60e;', '&#x1f60f;', '&#x1f610;', '&#x1f611;', '&#x1f612;', '&#x1f613;', '&#x1f614;', '&#x1f615;', '&#x1f616;', '&#x1f617;', '&#x1f618;', '&#x1f619;', '&#x1f61a;', '&#x1f61b;', '&#x1f61c;', '&#x1f61d;', '&#x1f61e;', '&#x1f61f;', '&#x1f620;', '&#x1f621;', '&#x1f622;', '&#x1f623;', '&#x1f624;', '&#x1f625;', '&#x1f626;', '&#x1f627;', '&#x1f628;', '&#x1f629;', '&#x1f62a;', '&#x1f62b;', '&#x1f62c;', '&#x1f62d;', '&#x1f62e;', '&#x1f62f;', '&#x1f630;', '&#x1f631;', '&#x1f632;', '&#x1f633;', '&#x1f634;', '&#x1f635;', '&#x1f636;', '&#x1f637;',  '&#x1f643;', '&#x1f644;', '&#x1F44C;','&#x1F44D;', '&#x1F44E;', '&#x1F648;', '&#x1F649;', '&#x1F64A;'],
			fontSize: '20px',
			listCSS: {position: 'absolute', 'background-color': '#fff', display: 'none',bottom:'30px', left:'30px',border: '1px solid #dee4e9', 'z-index': '1050', padding: '5px', 'box-shadow': '0 0 6px rgba(0,0,0,.2)' },
			rowSize: 10,
		};
		var settings = {};
		if (!params) {
			settings = defaults;
		} else {
			for (var n in defaults) {
				settings[n] = params[n] ? params[n] : defaults[n];
			}
		}

		this.each(function (n, input) {
			var $input = $(input);
			var $list = $('#emojilist');
			$list.html('');
			var $list = $('#emojilist'); 
			for (var n in settings.emojis) {
				if (n > 0 && n % settings.rowSize == 0) {
					$("<br>").appendTo($list);
				}
				var span=$("<span>");
				span.html(settings.emojis[n]);
				span.css({'cursor': 'pointer', 'font-size': '20px'});
				span.on('click',clickEmoji);
				span.appendTo($list);
			}
			//$list.insertAfter($input);
		});
		return this;
	};
}
)(jQuery);
function showEmoji() {
	var $list = $('#emojilist');
	if($list.val()==''){ 
		$list.emoji();
	}
	if($('#emojilist').is(':visible')){
		$list.hide();
		setTimeout(function () {
			$(document).unbind('click', closeEmoji);
		}, 1);
	}else{
		$list.show();
		setTimeout(function () {
			$(document).bind('click', closeEmoji);
		}, 1);
		
	}
	var input=$('.msgbox:visible');
	input.focus();
}

function closeEmoji() {
	var $list = $('#emojilist');
	$list.hide();
	$(document).unbind('click', closeEmoji);
}
function clickEmoji(ev) {
	var input=$('.msgbox:visible')[0];
	var msgdata=input.value;
	//msgdata= msgdata.replace(/'/g, "\'");
	if (input.selectionStart || input.selectionStart == '0') {
		var startPos = input.selectionStart;
		var endPos = input.selectionEnd;
		msgdata=msgdata.substring(0, startPos)
			+ ev.currentTarget.innerHTML
			+ msgdata.substring(endPos, msgdata.length);
	} else {
		msgdata+=ev.currentTarget.innerHTML;
	}
	input.value=msgdata;
	closeEmoji();
	input.focus();
	input.selectionStart = startPos + 2;
	input.selectionEnd = endPos + 2;
}

var asciiemoji={
   '1F620':           [ '>:(', '>:-(' ], 
  '1F60A':            [ ':")', ':-")' ],
  '1F494':     [ '</3', '<\\3' ],
  '1F615':         [ /*':\\',*/ ':-\\', /*':/',*/ ':-/' ], 
  '1F622':              [ ":'(", ":'-(", ':,(', ':,-(' ],
  '1F626':         [ ':(', ':-(' ],
  '2764':            [ '<3' ],
  '1F47F':              [ ']:(', ']:-(' ],
  '1F607':         [ 'o:)', 'O:)', 'o:-)', 'O:-)', '0:)', '0:-)' ],
  '1F602':              [ ":')", ":'-)", ':,)', ':,-)', ":'D", ":'-D", ':,D', ':,-D' ],
  '1F617':          [ ':*', ':-*' ],
  '1F606':         [ 'x-)', 'X-)' ],
  '1F610':     [ ':|', ':-|' ],
  '1F62E':       [ ':o', ':-o', ':O', ':-O' ],
  '1F621':             [ ':@', ':-@' ],
  '1F604':            [ ':D', ':-D' ],
  '1F603':           [ ':)', ':-)' ],
  '1F608':      [ ']:)', ']:-)' ],
  '1F62D':              [ ":,'(", ":,'-(", ';(', ';-(' ],
  '1F61B': [ ':P', ':-P' ],
  '1F60E':       [ '8-)', 'B-)' ],
  '1F613':            [ ',:(', ',:-(' ],
  '1F605':      [ ',:)', ',:-)' ],
  '1F612':         [ ':s', ':-S', ':z', ':-Z', ':$', ':-$' ],
  '1F609':             [ ';)', ';-)' ]
};

function converttoemoji(str) {
	for(var n in asciiemoji){
		var shortcode=n;
		var emoji=asciiemoji[n];
		shortcode='&#x'+shortcode+';';
		for(var k in emoji)
			str= str.replace(" "+emoji[k]+" ", shortcode);
	}
	return str;
}