<?php

/*
 * tnef_vcard.php
 *
 *  Bernd Wiegmann <bernd@wib-software.de>
 *  (c) 2003 (GNU GPL - see ../../COPYING)
 *
 */

/*
 *   $Header: /storage/repository/attachment_tnef/tnef_vcard.php,v 1.1 2003/07/31 15:24:25 bernd Exp $
 *
 *   $Log: tnef_vcard.php,v $
 *   Revision 1.1  2003/07/31 15:24:25  bernd
 *   Complete rework of tnef decoder
 *
 *
 */

$telefone_mapping = array (
			   TNEF_MAPI_PRIMARY_TEL_NUMBER    => "Primary Telefone",
			   TNEF_MAPI_HOME_TEL_NUMBER       => "Home Telefone",
			   TNEF_MAPI_HOME2_TEL_NUMBER      => "Home2 Telefone",
			   TNEF_MAPI_BUSINESS_TEL_NUMBER   => "Business Telefone",
			   TNEF_MAPI_BUSINESS2_TEL_NUMBER  => "Business2 Telefone",
			   TNEF_MAPI_MOBILE_TEL_NUMBER     => "Mobile Telefone",
			   TNEF_MAPI_RADIO_TEL_NUMBER      => "Radio Telefone",
			   TNEF_MAPI_CAR_TEL_NUMBER        => "Car Telefone",
			   TNEF_MAPI_OTHER_TEL_NUMBER      => "Other Telefone",
			   TNEF_MAPI_PAGER_TEL_NUMBER      => "Pager Telefone",
			   TNEF_MAPI_PRIMARY_FAX_NUMBER    => "Primary Fax",
			   TNEF_MAPI_BUSINESS_FAX_NUMBER   => "Business Fax",
			   TNEF_MAPI_HOME_FAX_NUMBER       => "Home Fax"
			   );

$homepage_mapping = array (
			   TNEF_MAPI_PERSONAL_HOME_PAGE    => "Personal Homepage",
			   TNEF_MAPI_BUSINESS_HOME_PAGE    => "Business Homepage",
			   TNEF_MAPI_OTHER_HOME_PAGE       => "Other Homepage"
			   );

define ("EMAIL_DISPLAY",       1);
define ("EMAIL_TRANSPORT",     2);
define ("EMAIL_EMAIL",         3);
define ("EMAIL_EMAIL2",        4);

$email_mapping = array (
			TNEF_MAPI_EMAIL1_DISPLAY           => array ( "eMail 1", EMAIL_DISPLAY ),
			TNEF_MAPI_EMAIL1_TRANSPORT         => array ( "eMail 1", EMAIL_TRANSPORT ),
			TNEF_MAPI_EMAIL1_EMAIL             => array ( "eMail 1", EMAIL_EMAIL ),
			TNEF_MAPI_EMAIL1_EMAIL2            => array ( "eMail 1", EMAIL_EMAIL2 ),
			TNEF_MAPI_EMAIL2_DISPLAY           => array ( "eMail 2", EMAIL_DISPLAY ),
			TNEF_MAPI_EMAIL2_TRANSPORT         => array ( "eMail 2", EMAIL_TRANSPORT ),
			TNEF_MAPI_EMAIL2_EMAIL             => array ( "eMail 2", EMAIL_EMAIL ),
			TNEF_MAPI_EMAIL2_EMAIL2            => array ( "eMail 2", EMAIL_EMAIL2 ),
			TNEF_MAPI_EMAIL3_DISPLAY           => array ( "eMail 3", EMAIL_DISPLAY ),
			TNEF_MAPI_EMAIL3_TRANSPORT         => array ( "eMail 3", EMAIL_TRANSPORT ),
			TNEF_MAPI_EMAIL3_EMAIL             => array ( "eMail 3", EMAIL_EMAIL ),
			TNEF_MAPI_EMAIL3_EMAIL2            => array ( "eMail 3", EMAIL_EMAIL2 )
			);

define ("ADDRESS_STREET",      "Street");
define ("ADDRESS_ZIP",         "Zip");
define ("ADDRESS_CITY",        "City");
define ("ADDRESS_COUNTRY",     "Country");
define ("ADDRESS_STATE",       "State");
define ("ADDRESS_PO_BOX",      "PO Box");

$address_mapping = array (
			  TNEF_MAPI_LOCALTY                => array ( "Address", ADDRESS_CITY ),
			  TNEF_MAPI_COUNTRY                => array ( "Address", ADDRESS_COUNTRY ),
			  TNEF_MAPI_POSTAL_CODE            => array ( "Address", ADDRESS_ZIP ),
			  TNEF_MAPI_STATE_OR_PROVINCE      => array ( "Address", ADDRESS_STATE ),
			  TNEF_MAPI_STREET_ADDRESS         => array ( "Address", ADDRESS_STREET ),
			  TNEF_MAPI_POST_OFFICE_BOX        => array ( "Address", ADDRESS_PO_BOX ),
			  TNEF_MAPI_HOME_ADDR_CITY         => array ( "Home Address", ADDRESS_CITY ),
			  TNEF_MAPI_HOME_ADDR_COUNTRY      => array ( "Home Address", ADDRESS_COUNTRY ),
			  TNEF_MAPI_HOME_ADDR_ZIP          => array ( "Home Address", ADDRESS_ZIP ),
			  TNEF_MAPI_HOME_ADDR_STATE        => array ( "Home Address", ADDRESS_STATE ),
			  TNEF_MAPI_HOME_ADDR_STREET       => array ( "Home Address", ADDRESS_STREET ),
			  TNEF_MAPI_HOME_ADDR_PO_BOX       => array ( "Home Address", ADDRESS_PO_BOX ),
			  TNEF_MAPI_OTHER_ADDR_CITY        => array ( "Other Address", ADDRESS_CITY ),
			  TNEF_MAPI_OTHER_ADDR_COUNTRY     => array ( "Other Address", ADDRESS_COUNTRY ),
			  TNEF_MAPI_OTHER_ADDR_ZIP         => array ( "Other Address", ADDRESS_ZIP ),
			  TNEF_MAPI_OTHER_ADDR_STATE       => array ( "Other Address", ADDRESS_STATE ),
			  TNEF_MAPI_OTHER_ADDR_STREET      => array ( "Other Address", ADDRESS_STREET ),
			  TNEF_MAPI_OTHER_ADDR_PO_BOX      => array ( "Other Address", ADDRESS_PO_BOX )
                         );

class TnefvCard {

  var $tnef_debug;
  var $name;
  var $type;
  var $content;
  var $metafile;
  var $created;
  var $modified;
  var $surname;
  var $given_name;
  var $middle_name;
  var $nickname;
  var $company;

  var $homepages;
  var $addresses;
  var $emails;
  var $telefones;

  function __construct($tnef_debug) {
    $this->tnef_debug = $tnef_debug;
    $this->name = "Untitled";
    $this->type = "text/x-vcard";
    $this->content = "";
    $this->telefones = array();
    $this->homepages = array();
    $this->emails = array();
    $this->addresses = array();
  }

  function getName()              { return $this->name;  }
  function getType()              { return $this->type;  }
  function getMetafile()          { return $this->metafile;   }
  function getSize()              { return strlen($this->content);   }
  function getContent()           { return $this->content;   }
  function getCreated()          { return $this->created;   }
  function getModified()         { return $this->modified;   }
  function getTelefones()        { return $this->telefones;   }
  function getSurname()           { return $this->surname;  }
  function getGivenName()         { return $this->given_name;  }
  function getMiddleName()        { return $this->middle_name;  }
  function getNickname()          { return $this->nickname;  }
  function getCompany()           { return $this->company;  }
  function getHomepages()        { return $this->homepages;  }
  function getEmails()           { return $this->emails;  }
  function getAddresses()        { return $this->addresses;  }

  function receiveTnefAttribute($attribute, $value, $length) {
  }

  function receiveMapiAttribute($attr_type, $attr_name, $value, $length) {
    switch($attr_name) {
    case TNEF_MAPI_DISPLAY_NAME:
      $this->name = $value;
      break;

    case TNEF_MAPI_SURNAME:
      $this->surname = $value;
      break;

    case TNEF_MAPI_GIVEN_NAME:
      $this->given_name = $value;
      break;

    case TNEF_MAPI_MIDDLE_NAME:
      $this->middle_name = $value;
      break;

    case TNEF_MAPI_NICKNAME:
      $this->nickname = $value;
      break;

    case TNEF_MAPI_COMPANY_NAME:
      $this->company = $value;
      break;

    default:
      $rc = $this->evaluateTelefoneAttribute($attr_type, $attr_name, $value, $length);
      if (!$rc) {
	$rc = $this->evaluateEmailAttribute($attr_type, $attr_name, $value, $length);
      }
      if (!$rc) {
	$rc = $this->evaluateAddressAttribute($attr_type, $attr_name, $value, $length);
      }
      if (!$rc) {
	$rc = $this->evaluateHomepageAttribute($attr_type, $attr_name, $value, $length);
      }
      break;
    }
  }

  function evaluateTelefoneAttribute($attr_type, $attr_name, $value, $length) {
    global $telefone_mapping;
    $rc = 0;

    if ($length > 0) {
      if (array_key_exists($attr_name, $telefone_mapping)) {
	$telefone_key = $telefone_mapping[$attr_name];
	$this->telefones[$telefone_key] = $value;
	$rc = 1;
	if ($this->tnef_debug) {
	  tnef_log("Setting telefone '$telefone_key' to value '$value'");
	}
      }
    }
    
    return $rc;
  }

  function evaluateEmailAttribute($attr_type, $attr_name, $value, $length) {
    global $email_mapping;
    $rc = 0;

    if ($length > 0) {
      if (array_key_exists($attr_name, $email_mapping)) {
	$email_key = $email_mapping[$attr_name];
	if (!array_key_exists($email_key[0], $this->emails)) {
	  $this->emails[$email_key[0]] = array ( EMAIL_DISPLAY => "", EMAIL_TRANSPORT => "", EMAIL_EMAIL => "", EMAIL_EMAIL2 => "");
	}
	$this->emails[$email_key[0]][$email_key[1]] = $value;
      }
    }

    return $rc;
  }

  function evaluateAddressAttribute($attr_type, $attr_name, $value, $length) {
    global $address_mapping;
    $rc = 0;

    if ($length > 0) {
      if (array_key_exists($attr_name, $address_mapping)) {
	$address_key = $address_mapping[$attr_name];
	if (!array_key_exists($address_key[0], $this->addresses)) {
	  $this->addresses[$address_key[0]] = array ( );
	}
	$this->addresses[$address_key[0]][$address_key[1]] = $value;
      }
    }

    return $rc;
  }

  function evaluateHomepageAttribute($attr_type, $attr_name, $value, $length) {
    global $homepage_mapping;
    $rc = 0;

    if ($length > 0) {
      if (array_key_exists($attr_name, $homepage_mapping)) {
	$homepage_key = $homepage_mapping[$attr_name];
	$this->homepages[$homepage_key] = $value;
	$rc = 1;
	if ($this->tnef_debug) {
	  tnef_log("Setting homepage '$homepage_key' to value '$value'");
	}
      }
    }
    
    return $rc;
  }

}

?>