<?php
return [
    'site_block' => [
        'id'              => ['varchar', 64, 'null' => 0],
        'content'         => ['mediumtext', 'null' => 0],
        'create_datetime' => ['datetime', 'null' => 0],
        'description'     => ['text', 'null' => 0],
        'sort'            => ['int', 11, 'null' => 0, 'default' => '0'],
        ':keys'           => [
            'PRIMARY' => 'id',
        ],
        ':options'        => ['engine' => 'MyISAM'],
    ],
    'site_blockpage' => [
        'id'              => ['int', 11, 'null' => 0, 'autoincrement' => 1],
        'parent_id'       => ['int', 11],
        'sort'            => ['int', 11, 'null' => 0, 'default' => '0'],
        'final_page_id'   => ['int', 11],
        'domain_id'       => ['int', 11, 'null' => 0],
        'name'            => ['varchar', 255],
        'title'           => ['text'],
        'url'             => ['varchar', 255, 'null' => 0],
        'full_url'        => ['varchar', 255, 'null' => 0],
        'status'          => ['enum', "'draft','final_unpublished','final_published'", 'null' => 0, 'default' => 'final_unpublished'],
        'theme'           => ['varchar', 64],
        'create_datetime' => ['datetime', 'null' => 0],
        'update_datetime' => ['datetime', 'null' => 0],
        ':keys'           => [
            'PRIMARY'       => 'id',
            'domain_id'     => ['domain_id', 'full_url'],
            'parent_id'     => ['parent_id', 'sort'],
            'final_page_id' => 'final_page_id',
        ],
    ],
    'site_blockpage_block_files' => [
        'file_id'  => ['int', 11, 'null' => 0],
        'block_id' => ['int', 11, 'null' => 0],
        'key'      => ['varchar', 255, 'null' => 0],
        ':keys'    => [
            'file_id'  => 'file_id',
            'block_id' => 'block_id',
        ],
    ],
    'site_blockpage_blocks' => [
        'id'        => ['int', 11, 'null' => 0, 'autoincrement' => 1],
        'page_id'   => ['int', 11, 'null' => 0],
        'parent_id' => ['int', 11],
        'child_key' => ['varchar', 255, 'null' => 0, 'default' => ''],
        'sort'      => ['int', 11, 'null' => 0],
        'type'      => ['varchar', 255, 'null' => 0],
        'global_id' => ['int', 11],
        'data'      => ['mediumtext'],
        'deleted'   => ['int', 11, 'null' => 0, 'default' => '0'],
        ':keys'     => [
            'PRIMARY' => 'id',
            'page_id' => ['page_id', 'sort'],
        ],
    ],
    'site_blockpage_file' => [
        'id'              => ['int', 11, 'null' => 0, 'autoincrement' => 1],
        'contact_id'      => ['int', 11, 'null' => 0],
        'create_datetime' => ['datetime', 'null' => 0],
        'delete_datetime' => ['datetime'],
        'name'            => ['varchar', 255, 'null' => 0],
        'ext'             => ['varchar', 10, 'null' => 0],
        'orig_name'       => ['varchar', 255, 'null' => 0],
        'size'            => ['int', 11, 'null' => 0],
        'width'           => ['int', 11],
        'height'          => ['int', 11],
        ':keys'           => [
            'PRIMARY'         => 'id',
            'delete_datetime' => 'delete_datetime',
        ],
    ],
    'site_blockpage_params' => [
        'page_id' => ['int', 11, 'null' => 0],
        'name'    => ['varchar', 255, 'null' => 0],
        'value'   => ['text', 'null' => 0],
        ':keys'   => [
            'page_id' => ['page_id', 'name', 'unique' => 1],
        ],
    ],
    'site_domain' => [
        'id'    => ['int', 11, 'null' => 0, 'autoincrement' => 1],
        'name'  => ['varchar', 255, 'null' => 0],
        'title' => ['varchar', 128, 'null' => 0, 'default' => ''],
        'style' => ['varchar', 255, 'null' => 0, 'default' => ''],
        ':keys' => [
            'PRIMARY' => 'id',
            'name'    => ['name', 'unique' => 1],
        ],
    ],
    'site_globalblock' => [
        'id'    => ['int', 11, 'null' => 0],
        'type'  => ['int', 11, 'null' => 0],
        'data'  => ['mediumtext'],
        ':keys' => [
            'PRIMARY' => 'id',
        ],
    ],
    'site_page' => [
        'id'                => ['int', 11, 'null' => 0, 'autoincrement' => 1],
        'domain_id'         => ['int', 11, 'null' => 0],
        'route'             => ['varchar', 64, 'null' => 0, 'default' => ''],
        'name'              => ['varchar', 255, 'null' => 0],
        'title'             => ['varchar', 255, 'null' => 0, 'default' => ''],
        'url'               => ['varchar', 255],
        'full_url'          => ['varchar', 255],
        'content'           => ['longtext', 'null' => 0],
        'create_datetime'   => ['datetime', 'null' => 0],
        'update_datetime'   => ['datetime', 'null' => 0],
        'create_contact_id' => ['int', 11, 'null' => 0],
        'sort'              => ['int', 11, 'null' => 0, 'default' => '0'],
        'status'            => ['tinyint', 1, 'null' => 0, 'default' => '0'],
        'parent_id'         => ['int', 11],
        ':keys'             => [
            'PRIMARY'   => 'id',
            'url'       => ['domain_id', 'route', 'full_url'],
            'parent_id' => 'parent_id',
        ],
    ],
    'site_page_params' => [
        'page_id' => ['int', 11, 'null' => 0],
        'name'    => ['varchar', 255, 'null' => 0],
        'value'   => ['text', 'null' => 0],
        ':keys'   => [
            'PRIMARY' => ['page_id', 'name'],
        ],
    ],
    'site_variable' => [
        'id'              => ['varchar', 64, 'null' => 0],
        'content'         => ['mediumtext', 'null' => 0],
        'create_datetime' => ['datetime', 'null' => 0],
        'description'     => ['text', 'null' => 0],
        'sort'            => ['int', 11, 'null' => 0, 'default' => '0'],
        ':keys'           => [
            'PRIMARY' => 'id',
        ],
        ':options'        => ['engine' => 'MyISAM'],
    ],
];
