<?php
/*
 * login_with_misfit.php
 *
 * @(#) $Id: login_with_misfit.php,v 1.1 2015/03/12 09:22:00 mlemos Exp $
 *
 */

/*
 *  Get the http.php file from http://www.phpclasses.org/httpclient
 */
require('http.php');
require('oauth_client.php');

$client = new oauth_client_class();
$client->debug = false;
$client->debug_http = true;
$client->server = 'Misfit';
$client->redirect_uri = 'http://'.$_SERVER['HTTP_HOST'].
    dirname(strtok($_SERVER['REQUEST_URI'], '?')).'/login_with_misfit.php';

$client->client_id = '';
$application_line = __LINE__;
$client->client_secret = '';

if (strlen($client->client_id) == 0
|| strlen($client->client_secret) == 0) {
    die('Please go to Misfit Apps page https://developers.misfit.com/apps , '.
        'create an application, and in the line '.$application_line.
        ' set the client_id to App ID/API Key and client_secret with App Secret');
}

/* API permissions
 */
$client->scope = 'email';
if (($success = $client->Initialize())) {
    if (($success = $client->Process())) {
        if (strlen($client->access_token)) {
            $success = $client->CallAPI(
                'https://api.misfitwearables.com/move/resource/v1/user/me/profile',
                'GET',
                array(),
                array('FailOnAccessError'=>true),
                $user
            );
        }
    }
    $success = $client->Finalize($success);
}
if ($client->exit) {
    exit;
}
if ($success) {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Misfit OAuth client results</title>
</head>
<body>
<?php
            echo '<h1>', HtmlSpecialChars($user->name),
    ' you have logged in successfully with Misfit!</h1>';
    echo '<pre>', HtmlSpecialChars(print_r($user, 1)), '</pre>';
    ?>
</body>
</html>
<?php
} else {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>OAuth client error</title>
</head>
<body>
<h1>OAuth client error</h1>
<pre>Error: <?php echo HtmlSpecialChars($client->error); ?></pre>
</body>
</html>
<?php
}

?>