<div
    id="<?= $this->getId() ?>"
    class="field-fileupload style-file-single <?= $singleFile ? 'is-populated' : '' ?> <?= $this->previewMode ? 'is-preview' : '' ?>"
    data-control="fileupload"
    data-upload-handler="<?= $this->getEventHandler('onUpload') ?>"
    data-template="#<?= $this->getId('template') ?>"
    data-error-template="#<?= $this->getId('errorTemplate') ?>"
    data-max-filesize="<?= $maxFilesize ?>"
    <?php if ($useCaption): ?>
        data-config-handler="<?= $this->getEventHandler('onLoadAttachmentConfig') ?>"
    <?php endif ?>
    <?php if ($acceptedFileTypes): ?>
        data-file-types="<?= $acceptedFileTypes ?>"
    <?php endif ?>
    <?= $this->formField->getAttributes() ?>
>

    <!-- Upload Button -->
    <button type="button" class="btn btn-default upload-button">
        <i class="icon-upload"></i>
    </button>

    <!-- Existing file -->
    <div class="upload-files-container">
        <?php if ($singleFile): ?>
            <div class="upload-object is-success" data-id="<?= $singleFile->id ?>" data-path="<?= $singleFile->pathUrl ?>">
                <div class="icon-container">
                    <i class="icon-file"></i>
                </div>
                <div class="info">
                    <h4 class="filename">
                        <span data-dz-name><?= e($singleFile->title ?: $singleFile->file_name) ?></span>
                    </h4>
                    <p class="size"><?= e($singleFile->sizeToString()) ?></p>
                </div>
                <div class="meta">
                    <a
                        href="javascript:;"
                        class="upload-remove-button"
                        data-request="<?= $this->getEventHandler('onRemoveAttachment') ?>"
                        data-request-confirm="<?= e(trans('backend::lang.fileupload.remove_confirm')) ?>"
                        data-request-data="file_id: '<?= $singleFile->id ?>'"
                        ><i class="icon-times"></i></a>
                </div>
            </div>
        <?php endif ?>
    </div>

    <!-- Empty message -->
    <div class="upload-empty-message">
        <span class="text-muted"><?= $prompt ?></span>
    </div>

</div>

<!-- Template for new file -->
<script type="text/template" id="<?= $this->getId('template') ?>">
    <div class="upload-object dz-preview dz-file-preview">
        <div class="icon-container">
            <i class="icon-file"></i>
            <img data-dz-thumbnail alt="" />
        </div>
        <div class="info">
            <h4 class="filename">
                <span data-dz-name></span>
            </h4>
            <p class="size" data-dz-size></p>
        </div>
        <div class="meta">
            <a
                href="javascript:;"
                class="upload-remove-button"
                data-request="<?= $this->getEventHandler('onRemoveAttachment') ?>"
                data-request-confirm="<?= e(trans('backend::lang.fileupload.remove_confirm')) ?>"
                ><i class="icon-times"></i></a>
            <div class="progress-bar"><span class="upload-progress" data-dz-uploadprogress></span></div>
            <div class="error-message"><span data-dz-errormessage></span></div>
        </div>
    </div>
</script>
