<?php

return [
    'app' => [
        'name' => 'Winter CMS',
        'tagline' => 'Terug naar de basis',
    ],
    'locale' => [
        'ar' => 'العربية',
        'be' => 'Беларуская',
        'bg' => 'Български',
        'ca' => 'Català',
        'cs' => 'Čeština',
        'da' => 'Dansk',
        'en' => 'English (United States)',
        'en-au' => 'English (Australia)',
        'en-ca' => 'English (Canada)',
        'en-gb' => 'English (United Kingdom)',
        'et' => 'Eesti',
        'de' => 'Deutsch',
        'el' => 'Ελληνικά',
        'es' => 'Español',
        'es-ar' => 'Español (Argentina)',
        'fa' => 'فارسی',
        'fr' => 'Français',
        'fr-ca' => 'Français (Canada)',
        'hu' => 'Magyar',
        'id' => 'Bahasa Indonesia',
        'it' => 'Italiano',
        'ja' => '日本語',
        'kr' => '한국어',
        'lt' => 'Lietuvių',
        'lv' => 'Latviešu',
        'nb-no' => 'Norsk (Bokmål)',
        'nl' => 'Nederlands',
        'pl' => 'Polski',
        'pt-br' => 'Português (Brasil)',
        'pt-pt' => 'Português (Portugal)',
        'ro' => 'Română',
        'rs' => 'Srpski',
        'ru' => 'Русский',
        'fi' => 'Suomi',
        'sv' => 'Svenska',
        'sk' => 'Slovenský',
        'sl' => 'Slovenščina',
        'th' => 'ไทย',
        'tr' => 'Türkçe',
        'uk' => 'Українська мова',
        'zh-cn' => '简体中文',
        'zh-tw' => '繁體中文',
        'vn' => 'Tiếng việt',
    ],
    'directory' => [
        'create_fail' => 'Map aanmaken mislukt: :name',
    ],
    'file' => [
        'create_fail' => 'Bestand aanmaken mislukt: :name',
    ],
    'combiner' => [
        'not_found' => "Het samenvoegbestand ':name' is niet gevonden.",
    ],
    'system' => [
        'name' => 'Systeem',
        'menu_label' => 'Systeem',
        'categories' => [
            'cms' => 'CMS',
            'misc' => 'Diversen',
            'logs' => 'Logboeken',
            'mail' => 'E-mail',
            'shop' => 'Winkel',
            'team' => 'Team',
            'users' => 'Gebruikers',
            'system' => 'Systeem',
            'social' => 'Sociaal',
            'backend' => 'Back-end',
            'events' => 'Events',
            'customers' => 'Klanten',
            'my_settings' => 'Mijn instellingen',
            'notifications' => 'Notifications',
        ],
    ],
    'theme' => [
        'label' => 'Thema',
        'unnamed' => 'Naamloos thema',
        'name' => [
            'label' => 'Thema naam',
            'help' => 'Gebruik bij het invoeren van de naam de unieke code van het thema. Bijvoorbeeld: Winter.Vanilla',
        ],
    ],
    'themes' => [
        'install' => 'Installeer themas',
        'search' => "Zoek thema's om te installeren...",
        'installed' => "Geïnstalleerde thema's",
        'no_themes' => "Er zijn geen thema's geinstallerd uit de marketplace.",
        'recommended' => 'Aanbevolen',
        'remove_confirm' => 'Weet je zeker dat je dit thema wilt verwijderen?',
    ],
    'plugin' => [
        'label' => 'Plugin',
        'unnamed' => 'Naamloze plugin',
        'name' => [
            'label' => 'Plugin naam',
            'help' => 'Gebruik bij het invoeren van de naam de unieke code van de plugin. Bijvoorbeeld: Winter.Blog',
        ],
        'by_author' => 'Door :name',
    ],
    'plugins' => [
        'manage' => 'Beheer plugins',
        'install' => 'Installeer plugins',
        'install_products' => 'Installeer plugins',
        'search' => 'Zoek plugins om te installeren',
        'installed' => 'Geïnstalleerde plugins',
        'no_plugins' => 'Er zijn geen plugins geïnstalleerd uit de marketplace.',
        'recommended' => 'Aanbevolen',
        'plugin_label' => 'Plugin',
        'unknown_plugin' => 'Plugin is verwijderd van het bestandssysteem.',
        'select_label' => 'Selecteer actie...',
        'bulk_actions_label' => 'Bulk acties',
        'check_yes' => 'Ja',
        'check_no' => 'Nee',
        'unfrozen' => 'Updates ingeschakeld',
        'enabled' => 'Plugin ingeschakeld',
        'freeze' => 'Updates uitschakelen',
        'unfreeze' => 'Updates inschakelen',
        'enable' => 'Inschakelen',
        'disable' => 'Uitschakelen',
        'refresh' => 'Verversen',
        'remove' => 'Verwijder',
        'freeze_label' => 'Updates uitschakelen',
        'unfreeze_label' => 'Updates inschakelen',
        'enable_label' => 'Plugin inschakelen',
        'disable_label' => 'Plugin uitschakelen',
        'refresh_label' => 'Verwijder plugin data',
        'action_confirm' => 'De volgende actie wordt uitgevoerd voor de geselecteerde plugins: :action',
        'freeze_success' => 'Updates voor geselecteerde plugins zijn uitgeschakeld.',
        'unfreeze_success' => 'Updates voor geselecteerde plugins zijn ingeschakeld.',
        'enable_success' => 'Geselecteerde plugins zijn ingeschakeld.',
        'disable_success' => 'Geselecteerde plugins zijn uitgeschakeld.',
        'refresh_confirm' => 'Weet je zeker dat je de data van de geselecteerde plugins wilt resetten? De plugins zullen naar hun oorspronkelijke staat worden gebracht.',
        'refresh_success' => 'Geselecteerde plugins zijn ge-reset.',
        'remove_confirm' => 'Weet je zeker dat je de geselecteerde plugins wilt verwijderen? De data van de plugins zullen ook verwijderd worden.',
        'remove_success' => 'Geselecteerde plugins zijn verwijderd.',
    ],
    'project' => [
        'name' => 'Project',
        'owner_label' => 'Eigenaar',
        'attach' => 'Koppel project',
        'detach' => 'Ontkoppel project',
        'none' => 'Geen',
        'id' => [
            'label' => 'Project ID',
            'help' => 'Hoe achterhaal je jouw Project ID?',
            'missing' => 'Voer een Project ID in.',
        ],
        'detach_confirm' => 'Weet je zeker dat je dit project wilt ontkoppelen?',
        'unbind_success' => 'Project is succesvol ontkoppeld.',
    ],
    'settings' => [
        'menu_label' => 'Instellingen',
        'not_found' => 'Kan specifieke instelling niet vinden.',
        'missing_model' => 'De instellingenpagina mist de definitie van een Model.',
        'update_success' => 'Instellingen voor :name zijn succesvol bijgewerkt.',
        'return' => 'Terug naar systeeminstellingen',
        'search' => 'Zoeken',
    ],
    'mail' => [
        'log_file' => 'Logboek bestand',
        'menu_label' => 'E-mailinstellingen',
        'menu_description' => 'Beheer e-mailinstellingen.',
        'general' => 'Algemeen',
        'method' => 'E-mail methode',
        'sender_name' => 'Naam afzender',
        'sender_email' => 'E-mailadres afzender',
        'php_mail' => 'PHP mail',
        'smtp' => 'SMTP',
        'smtp_address' => 'SMTP adres',
        'smtp_authorization' => 'SMTP authenticatie vereist',
        'smtp_authorization_comment' => 'Vink deze optie aan indien de SMTP server authenticatie vereist.',
        'smtp_username' => 'Gebruikersnaam',
        'smtp_password' => 'Wachtwoord',
        'smtp_port' => 'SMTP poort',
        'sendmail' => 'Sendmail',
        'sendmail_path' => 'Pad naar Sendmail',
        'sendmail_path_comment' => 'Geef hier het volledige pad op naar de Sendmail-applicatie.',
    ],
    'mail_templates' => [
        'menu_label' => 'E-mail sjablonen',
        'menu_description' => 'Wijzig de e-mail sjablonen die verstuurd worden naar gebruikers en beheerders. En beheer e-mail lay-outs.',
        'new_template' => 'Nieuw sjabloon',
        'new_layout' => 'Nieuwe lay-out',
        'new_partial' => 'Nieuw fragment',
        'template' => 'Sjabloon',
        'templates' => 'Sjablonen',
        'partial' => 'Fragment',
        'partials' => 'Fragmenten',
        'menu_layouts_label' => 'E-mail lay-outs',
        'menu_partials_label' => 'E-mail fragmenten',
        'layout' => 'Lay-out',
        'layouts' => 'Lay-outs',
        'no_layout' => '-- Geen lay-out --',
        'name' => 'Naam',
        'name_comment' => 'Een unieke naam die refereert naar dit sjabloon',
        'code' => 'Code',
        'code_comment' => 'Een unieke code die refereert naar deze lay-out',
        'subject' => 'Onderwerp',
        'subject_comment' => 'E-mail onderwerp',
        'description' => 'Omschrijving',
        'content_html' => 'HTML',
        'content_css' => 'CSS',
        'content_text' => 'Platte tekst',
        'test_send' => 'Stuur testbericht',
        'test_success' => 'Het testbericht is succesvol verzonden.',
        'test_confirm' => 'Er zal een testbericht verstuurd worden naar :email. Zal ik doorgaan?',
        'creating' => 'Aanmaken sjabloon...',
        'creating_layout' => 'Aanmaken lay-out...',
        'saving' => 'Opslaan sjabloon...',
        'saving_layout' => 'Opslaan lay-out...',
        'delete_confirm' => 'Weet je zeker dat je dit sjabloon wilt verwijderen?',
        'delete_layout_confirm' => 'Weet je zeker dat je deze lay-out wilt verwijderen?',
        'deleting' => 'Verwijderen sjabloon...',
        'deleting_layout' => 'Verwijderen lay-out...',
        'sending' => 'Versturen testbericht...',
        'return' => 'Terug naar templatelijst',
        'options' => 'Opties',
        'disable_auto_inline_css' => 'Automatische inline CSS uitschakelen',
    ],
    'mail_brand' => [
        'menu_label' => 'E-mail branding',
        'menu_description' => 'Aanpassen van kleuren en weergave van e-mailsjablonen.',
        'page_title' => 'Aanpassen e-mailweergave',
        'sample_template' => [
            'heading' => 'Kop',
            'paragraph' => 'Dit is een paragraaf gevuld met Lorem Ipsum en een link. Cumque dicta <a>doloremque eaque</a>, enim error laboriosam pariatur possimus tenetur veritatis voluptas.',
            'table' => [
                'item' => 'Item',
                'description' => 'Omschrijving',
                'price' => 'Prijs',
                'centered' => 'Gecentreerd',
                'right_aligned' => 'Rechts-uitgelijnd',
            ],
            'buttons' => [
                'primary' => 'Primaire knop',
                'positive' => 'Knop positief',
                'negative' => 'Knop negatief',
            ],
            'panel' => 'Hoe geweldig is dit panel?',
            'more' => 'Wat meer tekst',
            'promotion' => 'Coupon code: WINTER',
            'subcopy' => 'Voettekst',
            'thanks' => 'Bedankt',
        ],
        'fields' => [
            '_section_background' => 'Achtergrond',
            'body_bg' => 'Body',
            'content_bg' => 'Inhoud',
            'content_inner_bg' => 'Binnenste inhoud',
            '_section_buttons' => 'Knoppen',
            'button_text_color' => 'Knoptekst',
            'button_primary_bg' => 'Primaire knop',
            'button_positive_bg' => 'Positieve knop',
            'button_negative_bg' => 'Negatieve knop',
            '_section_type' => 'Typografie',
            'header_color' => 'Header',
            'heading_color' => 'Kopteksten',
            'text_color' => 'Tekst',
            'link_color' => 'Hyperlinks',
            'footer_color' => 'Footer',
            '_section_borders' => 'Randen',
            'body_border_color' => 'Inhoud',
            'subcopy_border_color' => 'Voettekst',
            'table_border_color' => 'Tabellen',
            '_section_components' => 'Componenten',
            'panel_bg' => 'Paneel achtergrond',
            'promotion_bg' => 'Promotie achtergrond',
            'promotion_border_color' => 'Promotie randkleur',
        ],
    ],
    'install' => [
        'project_label' => 'Koppel aan project',
        'plugin_label' => 'Installeer plugin',
        'theme_label' => 'Installeer thema',
        'missing_plugin_name' => 'Voer de naam van een plugin in om te installeren.',
        'missing_theme_name' => 'Voor de naam van een thema in om te installeren.',
        'install_completing' => 'Bezig met het afronden van het installatieproces',
        'install_success' => 'De plugin is succesvol geïnstalleerd.',
    ],
    'updates' => [
        'title' => 'Beheer updates',
        'name' => 'Applicatie-update',
        'menu_label' => 'Updates & Plugins',
        'menu_description' => "Update het systeem, beheer en installeer plugins en thema's.",
        'return_link' => 'Terug naar updates',
        'check_label' => 'Controleer op updates',
        'retry_label' => 'Probeer nogmaals',
        'plugin_name' => 'Naam',
        'plugin_code' => 'Code',
        'plugin_description' => 'Omschrijving',
        'plugin_version' => 'Versie',
        'plugin_author' => 'Auteur',
        'plugin_not_found' => 'Plugin niet gevonden',
        'plugin_version_not_found' => 'Pluginversie niet gevonden',
        'core_current_build' => 'Huidige build',
        'core_view_changelog' => 'Bekijk changelog',
        'core_build' => 'Build :build',
        'core_build_help' => 'De meest recente versie is beschikbaar.',
        'core_downloading' => 'Bestanden aan het downloaden',
        'core_extracting' => 'Bestanden aan het uitpakken',
        'core_set_build' => 'Bouwnummer bijwerken',
        'update_warnings_title' => 'Enkele problemen zijn gedetecteerd en vereisen aandacht:',
        'update_warnings_plugin_missing' => 'De :parent_code plugin vereist dat :code geinstalleerd is, alvorens deze zal werken',
        'changelog' => 'Logboek van wijzigingen',
        'changelog_view_details' => 'Bekijk details',
        'plugins' => 'Plugins',
        'themes' => 'Thema\'s',
        'disabled' => 'Uitgeschakeld',
        'plugin_downloading' => 'Plugin downloaden: :name',
        'plugin_extracting' => 'Plugin uitpakken: :name',
        'plugin_version_none' => 'Nieuwe plugin',
        'plugin_current_version' => 'Huidige versie',
        'theme_new_install' => 'Nieuwe thema-installatie.',
        'theme_downloading' => 'Thema downloaden: :name',
        'theme_extracting' => 'Thema uitpakken: :name',
        'update_label' => 'Applicatie bijwerken',
        'update_completing' => 'Afronden updateproces',
        'update_loading' => 'Beschikbare updates laden...',
        'update_success' => 'Het updateproces is succesvol afgerond.',
        'update_failed_label' => 'Update mislukt',
        'force_label' => 'Forceer update',
        'found' => [
            'label' => 'Nieuwe updates beschikbaar!',
            'help' => 'Klik op \'Applicatie bijwerken\' om het updateproces te starten.',
        ],
        'none' => [
            'label' => 'Geen updates',
            'help' => 'Er zijn geen nieuwe updates gevonden.',
        ],
        'important_action' => [
            'empty' => 'Selecteer actie',
            'confirm' => 'Bevestig update',
            'skip' => 'Sla deze plugin eenmalig over',
            'ignore' => 'Negeer deze plugin',
        ],
        'important_action_required' => 'Actie vereist!',
        'important_view_guide' => 'Toon upgrade handleiding',
        'important_view_release_notes' => 'Bekijk release notes',
        'important_alert_text' => 'Een aantal updates vereisen aandacht.',
        'details_title' => 'Plugin details',
        'details_view_homepage' => 'Toon homepagina',
        'details_readme' => 'Documentatie',
        'details_readme_missing' => 'Er is geen documentatie beschikbaar.',
        'details_changelog' => 'Changelog',
        'details_changelog_missing' => 'Er is geen changelog aanwezig.',
        'details_upgrades' => 'Upgrade instructie',
        'details_upgrades_missing' => 'Er is geen upgrade instructie beschikbaar gemaakt.',
        'details_licence' => 'Licentie',
        'details_licence_missing' => 'Er is geen licentie beschikbaar gemaakt.',
        'details_current_version' => 'Huidige versie',
        'details_author' => 'Auteur',
    ],
    'server' => [
        'connect_error' => 'Fout tijdens het verbinden met de server.',
        'response_not_found' => 'De updateserver kan niet worden gevonden.',
        'response_invalid' => 'Ongeldige reactie van de server.',
        'response_empty' => 'Lege reactie van de server.',
        'file_error' => 'Fout tijdens aanleveren bestand door server.',
        'file_corrupt' => 'Door server aangeboden bestand is corrupt.',
    ],
    'behavior' => [
        'missing_property' => 'Klasse :class moet variabele $:property bevatten welke gebruikt wordt door het gedrag (behavior) :behavior.',
    ],
    'config' => [
        'not_found' => 'Kan het configuratiebestand :file gedefinieerd voor :location niet vinden.',
        'required' => 'Configuratie gebruikt in :location moet de waarde :property toewijzen.',
    ],
    'zip' => [
        'extract_failed' => "Kan het corebestand ':file' niet uitpakken.",
    ],
    'event_log' => [
        'hint' => 'Dit logboek toont een lijst met potentiële fouten zoals exceptions of debuginformatie, welke voorkomen in de applicatie.',
        'menu_label' => 'Gebeurtenissenlogboek',
        'menu_description' => 'Bekijk systeemberichten met de geregistreerde tijd en detail.',
        'empty_link' => 'Gebeurtenissenlogboek legen',
        'empty_loading' => 'Bezig met het gebeurtenissenlogboek legen...',
        'empty_success' => 'Het gebeurtenissenlogboek legen is gelukt.',
        'return_link' => 'Terug naar gebeurtenissenlogboek',
        'id' => 'ID',
        'id_label' => 'Gebeurtenis ID',
        'created_at' => 'Datum & tijd',
        'message' => 'Bericht',
        'level' => 'Level',
        'preview_title' => 'Gebeurtenis',
    ],
    'request_log' => [
        'hint' => 'Dit logboek toont een lijst met pagina aanvragen welke mogelijk aandacht vereisen. Bijvoorbeeld: Een bezoeker opent een CMS pagina welke niet gevonden kan worden, een aantekening wordt gemaakt met statuscode 404.',
        'menu_label' => 'Aanvragenlogboek',
        'menu_description' => 'Bekijk foutieve of doorverwezen aanvragen zoals \'Pagina niet gevonden (404)\'.',
        'empty_link' => 'Aanvragenlogboek legen',
        'empty_loading' => 'Bezig met het aanvragenlogboek legen...',
        'empty_success' => 'Het aanvragenlogboek legen is gelukt.',
        'return_link' => 'Terug naar het aanvragenlogboek',
        'id' => 'ID',
        'id_label' => 'Log ID',
        'count' => 'Aantal',
        'referer' => 'Verwijzingen',
        'url' => 'URL',
        'status_code' => 'Status',
        'preview_title' => 'Verzoek',
    ],
    'permissions' => [
        'name' => 'Systeem',
        'manage_system_settings' => 'Beheer systeeminstellingen',
        'manage_software_updates' => 'Beheer applicatie updates',
        'access_logs' => 'Bekijk systeem logbestanden',
        'manage_mail_templates' => 'Beheer e-mailsjablonen',
        'manage_mail_settings' => 'Beheer e-mailinstellingen',
        'manage_other_administrators' => 'Beheer mede-beheerders',
        'impersonate_users' => 'Inloggen als',
        'manage_preferences' => 'Beheer back-end voorkeuren',
        'manage_editor' => 'Beheer code editor voorkeuren',
        'manage_own_editor' => 'Beheer persoonlijk code editor voorkeuren',
        'view_the_dashboard' => 'Toon dashboard',
        'manage_default_dashboard' => 'Beheer het standaard dashboard',
        'manage_branding' => 'Back-end aanpassen',
    ],
    'log' => [
        'menu_label' => 'Log instellingen',
        'menu_description' => 'Specifieer welke voor welke onderdelen logging ingeschakeld moet worden.',
        'default_tab' => 'Logging',
        'log_events' => 'Bijhouden systeemgebeurtenissen',
        'log_events_comment' => 'Opslaan van systeemgebeurtenissen in de database als aanvulling op het loggen in het logboekbestand.',
        'log_requests' => 'Bijhouden ongeldige verzoeken',
        'log_requests_comment' => 'Verzoeken van browsers die aandacht benodigd hebben, zoals bijvoorbeeld 404 fouten.',
        'log_theme' => 'Bijhouden van thema wijzigingen',
        'log_theme_comment' => 'Wanneer er een wijziging zijn gemaakt binnen het thema (vanuit de back-end omgeving).',
    ],
    'media' => [
        'invalid_path' => 'Ongeldig pad opgegeven: \':path\'.',
        'folder_size_items' => 'item(s)',
    ],
    'page' => [
        'custom_error' => [
            'label' => 'Paginafout',
            'help' => 'Excuses, er is een fout opgetreden. De pagina kan niet worden weergegeven.',
        ],
        'invalid_token' => [
            'label' => 'Ongeldig security token',
        ],
        'maintenance' => [
            'label' => 'Wij zijn zo weer terug!',
            'help' => 'Op dit moment wordt er onderhoud uitgevoerd. Kom later terug.',
            'message' => 'Bericht:',
            'available_at' => 'Probeer het nog eens op:',
        ],
    ],
    'pagination' => [
        'previous' => 'Vorige',
        'next' => 'Volgende',
    ],
];
