<?php Block::put('breadcrumb') ?>
    <ul>
        <li><a href="<?= Backend::url('system/updates') ?>"><?= e(trans('system::lang.updates.menu_label')) ?></a></li>
        <li><?= e(trans($this->pageTitle)) ?></li>
    </ul>
<?php Block::endPut() ?>

<?php if (!$this->fatalError): ?>

    <div class="control-tabs content-tabs tabs-flush" data-control="tab">
        <ul class="nav nav-tabs">
            <li class="<?= $activeTab == 'plugins' ? 'active' : '' ?>">
                <a
                    href="#tabPlugins"
                    data-tab-url="<?= Backend::url('system/updates/install/plugins') ?>">
                    <?= e(trans('system::lang.updates.plugins')) ?>
                </a>
            </li>
            <li class="<?= $activeTab == 'themes' ? 'active' : '' ?>">
                <a
                    href="#tabThemes"
                    data-tab-url="<?= Backend::url('system/updates/install/themes') ?>">
                    <?= e(trans('system::lang.updates.themes')) ?>
                </a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane <?= $activeTab == 'plugins' ? 'active' : '' ?>">
                <div class="padded-container">
                    <?= $this->makePartial('install_plugins') ?>
                </div>
            </div>
            <div class="tab-pane <?= $activeTab == 'themes' ? 'active' : '' ?>">
                <div class="padded-container">
                    <?= $this->makePartial('install_themes') ?>
                </div>
            </div>
        </div>
    </div>

<?php else: ?>

    <div class="padded-container">
        <p class="flash-message static error"><?= e($this->fatalError) ?></p>
        <p><a href="<?= Backend::url('system/updates') ?>" class="btn btn-default"><?= e(trans('system::lang.settings.return')) ?></a></p>
        <p><a href="<?= Backend::url('cms/themes') ?>" class="btn btn-default"><?= e(trans('cms::lang.theme.return')) ?></a></p>
    </div>

<?php endif ?>
