<?php

declare(strict_types=1);

/*
 * This file is part of the Zikula package.
 *
 * Copyright Zikula - https://ziku.la/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Zikula\SecurityCenterModule\Helper;

use Zikula\SecurityCenterModule\Api\ApiInterface\HtmlFilterApiInterface;

class HtmlTagsHelper
{
    public function getDefaultValues()
    {
        return [
            '!--' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'a' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'abbr' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'acronym' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'address' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'applet' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'area' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'article' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'aside' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'audio' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'b' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'base' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'basefont' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'bdo' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'big' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'blockquote' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'br' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'button' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'canvas' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'caption' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'center' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'cite' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'code' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'col' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'colgroup' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'command' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'datalist' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'dd' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'del' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'details' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'dfn' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'dir' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'div' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'dl' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'dt' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'em' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'embed' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'fieldset' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'figcaption' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'figure' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'footer' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'font' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'form' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'h1' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'h2' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'h3' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'h4' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'h5' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'h6' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'header' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'hgroup' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'hr' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'i' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'iframe' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'img' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'input' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'ins' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'keygen' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'kbd' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'label' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'legend' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'li' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'map' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'mark' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'menu' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'marquee' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'meter' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'nav' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'nobr' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'object' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'ol' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'optgroup' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'option' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'output' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'p' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'param' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'pre' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'progress' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'q' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'rp' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'rt' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'ruby' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            's' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'samp' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'script' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'section' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'select' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'small' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'source' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'span' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'strike' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'strong' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'sub' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'summary' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'sup' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'table' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'tbody' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'td' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'textarea' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'tfoot' => HtmlFilterApiInterface::TAG_ALLOWED_PLAIN,
            'th' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'thead' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'time' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'tr' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'tt' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'u' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'ul' => HtmlFilterApiInterface::TAG_ALLOWED_WITH_ATTRIBUTES,
            'var' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'video' => HtmlFilterApiInterface::TAG_NOT_ALLOWED,
            'wbr' => HtmlFilterApiInterface::TAG_NOT_ALLOWED
        ];
    }

    public function getTagsWithLinks()
    {
        $baseUrl = 'https://www.w3schools.com/tags/';

        return [
            '!--' => $baseUrl . 'tag_comment.asp',
            'a' => $baseUrl . 'tag_a.asp',
            'abbr' => $baseUrl . 'tag_abbr.asp',
            'acronym' => $baseUrl . 'tag_acronym.asp',
            'address' => $baseUrl . 'tag_address.asp',
            'applet' => $baseUrl . 'tag_applet.asp',
            'area' => $baseUrl . 'tag_area.asp',
            'article' => $baseUrl . 'tag_article.asp',
            'aside' => $baseUrl . 'tag_aside.asp',
            'audio' => $baseUrl . 'tag_audio.asp',
            'b' => $baseUrl . 'tag_b.asp',
            'base' => $baseUrl . 'tag_base.asp',
            'basefont' => $baseUrl . 'tag_basefont.asp',
            'bdo' => $baseUrl . 'tag_bdo.asp',
            'big' => $baseUrl . 'tag_font_style.asp',
            'blockquote' => $baseUrl . 'tag_blockquote.asp',
            'br' => $baseUrl . 'tag_br.asp',
            'button' => $baseUrl . 'tag_button.asp',
            'canvas' => $baseUrl . 'tag_canvas.asp',
            'caption' => $baseUrl . 'tag_caption.asp',
            'center' => $baseUrl . 'tag_center.asp',
            'cite' => $baseUrl . 'tag_cite.asp',
            'code' => $baseUrl . 'tag_code.asp',
            'col' => $baseUrl . 'tag_col.asp',
            'colgroup' => $baseUrl . 'tag_colgroup.asp',
            'command' => $baseUrl . 'tag_command.asp',
            'datalist' => $baseUrl . 'tag_datalist.asp',
            'dd' => $baseUrl . 'tag_dd.asp',
            'del' => $baseUrl . 'tag_del.asp',
            'details' => $baseUrl . 'tag_details.asp',
            'dfn' => $baseUrl . 'tag_dfn.asp',
            'dir' => $baseUrl . 'tag_dir.asp',
            'div' => $baseUrl . 'tag_div.asp',
            'dl' => $baseUrl . 'tag_dl.asp',
            'dt' => $baseUrl . 'tag_dt.asp',
            'em' => $baseUrl . 'tag_em.asp',
            'embed' => $baseUrl . 'tag_embed.asp',
            'fieldset' => $baseUrl . 'tag_fieldset.asp',
            'figcaption' => $baseUrl . 'tag_figcaption.asp',
            'figure' => $baseUrl . 'tag_figure.asp',
            'font' => $baseUrl . 'tag_font.asp',
            'footer' => $baseUrl . 'tag_footer.asp',
            'form' => $baseUrl . 'tag_form.asp',
            'h1' => $baseUrl . 'tag_hn.asp',
            'h2' => $baseUrl . 'tag_hn.asp',
            'h3' => $baseUrl . 'tag_hn.asp',
            'h4' => $baseUrl . 'tag_hn.asp',
            'h5' => $baseUrl . 'tag_hn.asp',
            'h6' => $baseUrl . 'tag_hn.asp',
            'header' => $baseUrl . 'tag_header.asp',
            'hgroup' => $baseUrl . 'tag_hgroup.asp',
            'hr' => $baseUrl . 'tag_hr.asp',
            'i' => $baseUrl . 'tag_i.asp',
            'iframe' => $baseUrl . 'tag_iframe.asp',
            'img' => $baseUrl . 'tag_img.asp',
            'input' => $baseUrl . 'tag_input.asp',
            'ins' => $baseUrl . 'tag_ins.asp',
            'keygen' => $baseUrl . 'tag_keygen.asp',
            'kbd' => $baseUrl . 'tag_kbd.asp',
            'label' => $baseUrl . 'tag_label.asp',
            'legend' => $baseUrl . 'tag_legend.asp',
            'li' => $baseUrl . 'tag_li.asp',
            'map' => $baseUrl . 'tag_map.asp',
            'mark' => $baseUrl . 'tag_mark.asp',
            'menu' => $baseUrl . 'tag_menu.asp',
            'marquee' => '',
            'meter' => $baseUrl . 'tag_meter.asp',
            'nav' => $baseUrl . 'tag_nav.asp',
            'nobr' => '',
            'object' => $baseUrl . 'tag_object.asp',
            'ol' => $baseUrl . 'tag_ol.asp',
            'optgroup' => $baseUrl . 'tag_optgroup.asp',
            'option' => $baseUrl . 'tag_option.asp',
            'output' => $baseUrl . 'tag_output.asp',
            'p' => $baseUrl . 'tag_p.asp',
            'param' => $baseUrl . 'tag_param.asp',
            'pre' => $baseUrl . 'tag_pre.asp',
            'progress' => $baseUrl . 'tag_progress.asp',
            'q' => $baseUrl . 'tag_q.asp',
            'rp' => $baseUrl . 'tag_rp.asp',
            'rt' => $baseUrl . 'tag_rt.asp',
            'ruby' => $baseUrl . 'tag_ruby.asp',
            's' => $baseUrl . 'tag_s.asp',
            'samp' => $baseUrl . 'tag_samp.asp',
            'script' => $baseUrl . 'tag_script.asp',
            'section' => $baseUrl . 'tag_section.asp',
            'select' => $baseUrl . 'tag_select.asp',
            'small' => $baseUrl . 'tag_small.asp',
            'source' => $baseUrl . 'tag_source.asp',
            'span' => $baseUrl . 'tag_span.asp',
            'strike' => $baseUrl . 'tag_strike.asp',
            'strong' => $baseUrl . 'tag_strong.asp',
            'sub' => $baseUrl . 'tag_sup.asp',
            'summary' => $baseUrl . 'tag_summary.asp',
            'sup' => $baseUrl . 'tag_sup.asp',
            'table' => $baseUrl . 'tag_table.asp',
            'tbody' => $baseUrl . 'tag_tbody.asp',
            'td' => $baseUrl . 'tag_td.asp',
            'textarea' => $baseUrl . 'tag_textarea.asp',
            'tfoot' => $baseUrl . 'tag_tfoot.asp',
            'th' => $baseUrl . 'tag_th.asp',
            'thead' => $baseUrl . 'tag_thead.asp',
            'time' => $baseUrl . 'tag_time.asp',
            'tr' => $baseUrl . 'tag_tr.asp',
            'tt' => $baseUrl . 'tag_font_style.asp',
            'u' => $baseUrl . 'tag_u.asp',
            'ul' => $baseUrl . 'tag_ul.asp',
            'var' => $baseUrl . 'tag_var.asp',
            'video' => $baseUrl . 'tag_video.asp',
            'wbr' => $baseUrl . 'tag_wbr.asp'
        ];
    }
}
