<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'zikula/distribution';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'antishov/doctrine-extensions-bundle' => 'v1.4.3@b036a8d62111c03f237a619b1840c46570f48483',
  'behat/transliterator' => 'v1.3.0@3c4ec1d77c3d05caa1f0bf8fb3aae4845005c7fc',
  'components/bootstrap' => '4.6.1@97f06b5527fba4083b85b7bdb152513ad8c7d6ce',
  'components/font-awesome' => '5.15.4@e6fd09f30f578915cc0cf186b0dd0da54385b6be',
  'components/jquery' => '3.6.0@6cf38ee1fd04b6adf8e7dda161283aa35be818c3',
  'components/jqueryui' => '1.12.1@44ecf3794cc56b65954cc19737234a3119d036cc',
  'composer/ca-bundle' => '1.3.1@4c679186f2aca4ab6a0f1b0b9cf9252decb44d0b',
  'composer/composer' => '1.10.24@6dea608377dc5409895d4cfd987947bc0abe154a',
  'composer/installers' => 'v1.12.0@d20a64ed3c94748397ff5973488761b22f6d3f19',
  'composer/package-versions-deprecated' => '1.11.99.4@b174585d1fe49ceed21928a945138948cb394600',
  'composer/semver' => '1.7.2@647490bbcaf7fc4891c58f47b825eb99d19c377a',
  'composer/spdx-licenses' => '1.5.6@a30d487169d799745ca7280bc90fdfa693536901',
  'composer/xdebug-handler' => '1.4.6@f27e06cd9675801df441b3656569b328e04aa37c',
  'dimsemenov/magnific-popup' => '1.1.0@6b7a8088783cbce01034414c1fd2d8e1889093ae',
  'doctrine/annotations' => '1.13.2@5b668aef16090008790395c02c893b1ba13f7e08',
  'doctrine/cache' => '1.12.1@4cf401d14df219fa6f38b671f5493449151c9ad8',
  'doctrine/collections' => '1.6.8@1958a744696c6bb3bb0d28db2611dc11610e78af',
  'doctrine/common' => '2.13.3@f3812c026e557892c34ef37f6ab808a6b567da7f',
  'doctrine/dbal' => '2.13.6@67ef6d0327ccbab1202b39e0222977a47ed3ef2f',
  'doctrine/deprecations' => 'v0.5.3@9504165960a1f83cc1480e2be1dd0a0478561314',
  'doctrine/doctrine-bundle' => '2.3.2@d6b3c37804539a24ba8a7d647a6144cab2f13242',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'doctrine/inflector' => '1.4.4@4bd5c1cdfcd00e9e2d8c484f79150f67e5d355d9',
  'doctrine/instantiator' => '1.4.0@d56bf6102915de5702778fe20f2de3b2fe570b5b',
  'doctrine/lexer' => '1.2.1@e864bbf5904cb8f5bb334f99209b48018522f042',
  'doctrine/orm' => '2.7.5@01187c9260cd085529ddd1273665217cae659640',
  'doctrine/persistence' => '1.3.8@7a6eac9fb6f61bba91328f15aa7547f4806ca288',
  'doctrine/reflection' => '1.2.2@fa587178be682efe90d005e3a322590d6ebb59a5',
  'doctrine/sql-formatter' => '1.1.2@20c39c2de286a9d3262cc8ed282a4ae60e265894',
  'egulias/email-validator' => '2.1.25@0dbf5d78455d4d6a41d186da50adc1122ec066f4',
  'erusev/parsedown' => '1.7.4@cb17b6477dfff935958ba01325f2e8a2bfa6dab3',
  'ezyang/htmlpurifier' => 'dev-master@996eaf43310edf1d908bc0030a18b37b8cf6eefd',
  'frdh/mmenu.js' => '8.5.23@fc73fd03ee015a13dab0e8a57a0f2ad56e7e548a',
  'friendsofsymfony/jsrouting-bundle' => '2.8.0@c978fabc6a21a77052ff3fe927b41111ec944f0d',
  'gedmo/doctrine-extensions' => 'v2.4.42@b6c4442b4f32ce05673fbdf1fa4a2d5e315cc0a4',
  'guzzlehttp/guzzle' => '7.4.1@ee0a041b1760e6a53d2a39c8c34115adc2af2c79',
  'guzzlehttp/promises' => '1.5.1@fe752aedc9fd8fcca3fe7ad05d419d32998a06da',
  'guzzlehttp/psr7' => '2.1.0@089edd38f5b8abba6cb01567c2a8aaa47cec4c72',
  'imagine/imagine' => '1.2.4@d2e18be6e930ca169e4f921ef73ebfc061bf55d8',
  'ircmaxell/random-lib' => 'v1.2.0@e9e0204f40e49fa4419946c677eccd3fa25b8cf4',
  'ircmaxell/security-lib' => 'v1.1.0@f3db6de12c20c9bcd1aa3db4353a1bbe0e44e1b5',
  'itsjavi/fontawesome-iconpicker' => '3.2.0@ca4d2f2b03140af422ea9e15160494e887844d39',
  'jakeasmith/http_build_url' => '1.0.1@93c273e77cb1edead0cf8bcf8cd2003428e74e37',
  'jms/i18n-routing-bundle' => '3.0.4@99e02159433a495c696bf9372db14b117f4480de',
  'justinrainbow/json-schema' => '5.2.11@2ab6744b7296ded80f8cc4f9509abbff393399aa',
  'knplabs/knp-menu' => 'v3.2.0@9e7f174862c9a91f1249d18b5c2fa039eef81b8f',
  'knplabs/knp-menu-bundle' => 'v3.2.0@a0b4224f872d74ae939589eb1ccf0e11291370a9',
  'league/commonmark' => '1.6.6@c4228d11e30d7493c6836d20872f9582d8ba6dcf',
  'league/html-to-markdown' => '4.10.0@0868ae7a552e809e5cd8f93ba022071640408e88',
  'league/oauth2-client' => '2.6.0@badb01e62383430706433191b82506b6df24ad98',
  'league/oauth2-facebook' => '2.0.5@14cead7580cab8caace67f5a61ea5d2a8ff213eb',
  'league/oauth2-github' => '2.0.0@e63d64f3ec167c09232d189c6b0c397458a99357',
  'league/oauth2-google' => '3.0.4@6b79441f244040760bed5fdcd092a2bda7cf34c6',
  'league/oauth2-instagram' => '2.0.0@abf6466ebd2c2a73e920b0ce834e2bf50d1abdcc',
  'league/oauth2-linkedin' => '4.1.1@0dfb338db84cb87c3d24b0205ec7f3e3a9457b81',
  'liip/imagine-bundle' => '2.7.1@f15570747af01c5a8b3907e1c3f72b1664a99608',
  'lorenzo/pinky' => '1.0.5@2bc1a9d5696d6496df5d5682962929165a823e57',
  'matthiasnoback/symfony-console-form' => 'v4.1.0@c304e46f0d019ed36f3cd00334aae903b3a142c0',
  'michelf/php-markdown' => '1.9.1@5024d623c1a057dcd2d076d25b7d270a1d0d55f3',
  'monolog/monolog' => '2.3.5@fd4380d6fc37626e2f799f29d91195040137eba9',
  'nikic/php-parser' => 'v4.13.2@210577fe3cf7badcc5814d99455df46564f3c077',
  'nyholm/nsa' => '1.3.0@c264c17ed2aa8251c64ad289442ed53f64cdb283',
  'oomphinc/composer-installers-extender' => '2.0.1@cbf4b6f9a24153b785d09eee755b995ba87bd5f9',
  'oro/twig-inspector' => '1.0.3@a6bfa95e3909fba2f7ee411b4a5ac6b373490e2f',
  'paragonie/random_compat' => 'v9.99.100@996434e5492cb4c3edcb9168db6fbb1359ef965a',
  'php-translation/common' => '3.1.0@fcb8338be8d4a65e76e916660c053c06e8376765',
  'php-translation/extractor' => '2.0.3@296026263aeabb5f17c6b6958608ba255b92ad9c',
  'php-translation/symfony-bundle' => '0.12.1@7fbc991062d6cf7d862122d07428adfa972fce78',
  'php-translation/symfony-storage' => '2.3.0@8b1954b9b4933245250bc5b3d45f0d7bde38c761',
  'phpids/phpids' => 'dev-master@dfc1476e4ffe9f1dde72c0954912411082a17597',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.1@8622567409010282b7aeebe4bb841fe98b58dcaf',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.1@2dfb5f6c5eff0e91e20e913f8c5452ed95b86621',
  'psr/http-factory' => '1.0.1@12ac7fcd07e5b077433f5f2bee95b3a771bf61be',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'seld/jsonlint' => '1.8.3@9ad6ce79c342fbd44df10ea95511a1b24dee5b57',
  'seld/phar-utils' => '1.2.0@9f3452c93ff423469c0d56450431562ca423dcee',
  'sensio/framework-extra-bundle' => 'v5.6.1@430d14c01836b77c28092883d195a43ce413ee32',
  'sensiolabs/security-checker' => 'v6.0.3@a576c01520d9761901f269c4934ba55448be4a54',
  'symfony/contracts' => 'v2.5.0@1f4c95d47bddf0c1579779d4b85602c923ed2f1c',
  'symfony/maker-bundle' => 'v1.36.4@716eee9c8b10b33e682df1b7d80b9061887e9691',
  'symfony/monolog-bundle' => 'v3.7.1@fde12fc628162787a4e53877abadc30047fd868b',
  'symfony/polyfill-ctype' => 'v1.23.0@46cd95797e9df938fdd2b03693b5fca5e64b01ce',
  'symfony/polyfill-intl-grapheme' => 'v1.23.1@16880ba9c5ebe3642d1995ab866db29270b36535',
  'symfony/polyfill-intl-icu' => 'v1.23.0@4a80a521d6176870b6445cfb469c130f9cae1dda',
  'symfony/polyfill-intl-idn' => 'v1.23.0@65bd267525e82759e7d8c4e8ceea44f398838e65',
  'symfony/polyfill-intl-messageformatter' => 'v1.23.0@22c4bba53bfadde90a4c1b32088e720638a42a83',
  'symfony/polyfill-intl-normalizer' => 'v1.23.0@8590a5f561694770bdcd3f9b5c69dde6945028e8',
  'symfony/polyfill-mbstring' => 'v1.23.1@9174a3d80210dca8daa7f31fec659150bbeabfc6',
  'symfony/polyfill-php72' => 'v1.23.0@9a142215a36a3888e30d0a9eeea9766764e96976',
  'symfony/polyfill-php73' => 'v1.23.0@fba8933c384d6476ab14fb7b8526e5287ca7e010',
  'symfony/polyfill-php80' => 'v1.23.1@1100343ed1a92e3a38f9ae122fc0eb21602547be',
  'symfony/polyfill-uuid' => 'v1.23.0@9165effa2eb8a31bb3fa608df9d529920d21ddd9',
  'symfony/profiler-pack' => 'v1.0.6@bcd6e80af9819454ac18594362e7875fd1d771c7',
  'symfony/requirements-checker' => 'v1.1.8@8e134f691a1ed23e3c03c5415693b3b164c1bcc1',
  'symfony/symfony' => 'v5.1.9@84f32fe2ee1d3b15efadbda8f56f852d78795310',
  'thomaspark/bootswatch' => 'v4.6.1@8e6358e490c4caf9523b3cc5dd71167276dd77c8',
  'tijsverkoyen/css-to-inline-styles' => '2.2.4@da444caae6aca7a19c0c140f68c6182e337d5b1c',
  'twig/cssinliner-extra' => 'v3.3.4@a6065b23645282e1c81d847cf0c7f0211d22b682',
  'twig/extra-bundle' => 'v3.3.4@1fe52d84aa22b7891c7717ef904b1551c8d70100',
  'twig/html-extra' => 'v3.3.4@ce33ea51bb0df393d2bc9945d08e2ce7fbe808c5',
  'twig/inky-extra' => 'v3.3.4@6f81ada491569cfeb04fb43070f3a8908fc0f9ce',
  'twig/intl-extra' => 'v3.3.4@a0bdab97a1cf5ccc944c70aee1d2f2602db64d16',
  'twig/markdown-extra' => 'v3.3.4@c84c1fb75f0abb6e8477631b4ada59de770e83e6',
  'twig/string-extra' => 'v3.3.4@2aea4098a54af141366ebb0100492750253d971a',
  'twig/twig' => 'v3.3.4@65cb6f0b956485e1664f13d023c55298a4bb59ca',
  'vakata/jstree' => '3.3.12@7a03954015eaea2467956dc05e6be78f4d1a1ff0',
  'webmozart/assert' => '1.10.0@6964c76c7804814a842473e0c8fd15bab0f18e25',
  'willdurand/js-translation-bundle' => '3.0.1@a64af02e1b2193ba77dfbb08a5df14d2c7d3bae4',
  'willdurand/jsonp-callback-validator' => 'v1.1.0@1a7d388bb521959e612ef50c5c7b1691b097e909',
  'zikula/admin-module' => '3.0.4@0a12aaedef51d4ddd32a01f364666722d4ea3c00',
  'zikula/atom-theme' => '3.0.4@5eb5e0157ecd51adcb751f771eda8b97e7a9d734',
  'zikula/blocks-module' => '3.0.4@9258206fe4bea5a8cd774f01053d397bf390f288',
  'zikula/bootstrap-theme' => '3.0.4@ce2d24fe3d40408fd02082e0609a5d623df9a48f',
  'zikula/categories-module' => '3.0.4@dd32c0a211712463d216aeb05648fdf11b923501',
  'zikula/core-bundle' => '3.0.4@cff2878700d9d956eb730dbbab44b536a80d2f8c',
  'zikula/coreinstaller-bundle' => '3.0.4@6c0a2f105335cb9925f63d7a01581b9cf22dd312',
  'zikula/extensions-module' => '3.0.4@6a73dfe43ef91488923fb4dd3f4991a17aa54eff',
  'zikula/formextension-bundle' => '3.0.4@dbc426cd59ffa662288f59b35ecf7fc21e2c8655',
  'zikula/groups-module' => '3.0.4@ddf839ee417ff92159c1fda2ebaab433e9fa5060',
  'zikula/hook-bundle' => '3.0.4@bc44a27c4e597ffb596a36b515f0eb87ce0b1c24',
  'zikula/legal-module' => '3.2.10@ee17d8482fcd657fc82481bab51c22945e7bbe29',
  'zikula/mailer-module' => '3.0.4@8d0a17a7495f56d772aeb255a88d55f03397b064',
  'zikula/menu-module' => '3.0.4@a544f3476e141dde9c51a348290bd1889e0df00d',
  'zikula/oauth-module' => '1.2.3@83428af241daf695403f64058ab62d5006c3eff7',
  'zikula/pagelock-module' => '1.3.9@bc21a6c7163b585edfefd29b0c4603d24641da81',
  'zikula/permissions-module' => '3.0.4@e7564cf41279153fefcfaf247991013035d5176e',
  'zikula/printer-theme' => '3.0.4@e9019a149dd00c87f1e6eaa5ca49621b3bd53e69',
  'zikula/profile-module' => '3.1.18@902599daa417eeee99ff77be7d2c33c5f8692583',
  'zikula/routes-module' => '3.0.4@05f0abde2ea36d52c94356a74657885ba6a54361',
  'zikula/rss-theme' => '3.0.4@062cf0cdec1950bb0cd80a07ef5349f7821a23db',
  'zikula/search-module' => '3.0.4@16aa08725c0626e84401912af475e498edf28024',
  'zikula/securitycenter-module' => '3.0.4@62b090da7d7f55fa16140ba60bc263f1e40ac37b',
  'zikula/settings-module' => '3.0.4@37b3272dde42208ae78f93dd35fc4d99f5b98e4e',
  'zikula/sortable-columns' => '1.0.0@bb563c26cc5eb39df29a10ed300f82c1f7bbcc82',
  'zikula/theme-module' => '3.0.4@e23f8043aff3e9b42c86ff4acf09b0510be70956',
  'zikula/users-module' => '3.0.4@7c0fffe8b45c5c42c7486f627062666576cfc336',
  'zikula/wizard' => 'dev-main@4a21fabc878583561fdb578b6fc7b008559b2354',
  'zikula/workflow-bundle' => '3.0.4@d4c80e7681b1810ba3733660d9d72d5802285f3a',
  'zikula/zauth-module' => '3.0.4@f3990f535affe6531f58146d3f93018a3a2ab332',
  'zikula/distribution' => '3.0.x-dev@e86dba28fec731cf34ff0d5f4fff6d969d36a020',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
